/**
 * @fileoverview
 * 'settings-ai-policy-indicator' is an indicator that informs the user if the
 * feature is controlled by policy.
 */
import '/shared/settings/controls/cr_policy_pref_indicator.js';
import '../settings_shared.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export declare function isFeatureDisabledByPolicy(enterprisePref: chrome.settingsPrivate.PrefObject | undefined): boolean;
declare const SettingsAiPolicyIndicatorBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/controls/pref_control_mixin.js").PrefControlMixinInterface);
export declare class SettingsAiPolicyIndicator extends SettingsAiPolicyIndicatorBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    private isFeatureDisabledByPolicy_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-ai-policy-indicator': SettingsAiPolicyIndicator;
    }
}
export {};
