/**
 * @fileoverview
 * 'settings-ai-page-index' is the settings page containing settings for
 * passwords, payment methods and addresses.
 */
import 'chrome://resources/cr_elements/cr_view_manager/cr_view_manager.js';
import '/shared/settings/prefs/prefs.js';
import './ai_info_card.js';
import './ai_page.js';
import '../glic_page/glic_page.js';
import '../glic_page/glic_subpage.js';
import type { CrViewManagerElement } from 'chrome://resources/cr_elements/cr_view_manager/cr_view_manager.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { Route, SettingsRoutes } from '../router.js';
import type { SettingsPlugin } from '../settings_main/settings_plugin.js';
export interface SettingsAiPageIndexElement {
    $: {
        viewManager: CrViewManagerElement;
    };
}
declare const SettingsAiPageIndexElementBase: typeof PolymerElement & (new (...args: any[]) => import("../router.js").RouteObserverMixinInterface) & (new (...args: any[]) => import("../settings_page/searchable_view_container_mixin.js").SearchableViewContainerMixinInterface);
export declare class SettingsAiPageIndexElement extends SettingsAiPageIndexElementBase implements SettingsPlugin {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        prefs: ObjectConstructor;
        routes_: {
            type: ObjectConstructor;
            value: () => SettingsRoutes;
        };
        showGlicSettings_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
        showAiPageAiFeatureSection_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
        showComposeControl_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
        showCompareControl_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
        showHistorySearchControl_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
        showTabOrganizationControl_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
    };
    prefs: {
        [key: string]: any;
    };
    private routes_;
    private showGlicSettings_;
    private showAiPageAiFeatureSection_;
    private showComposeControl_;
    private showCompareControl_;
    private showHistorySearchControl_;
    private showTabOrganizationControl_;
    private showDefaultViews_;
    currentRouteChanged(newRoute: Route, oldRoute?: Route): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-ai-page-index': SettingsAiPageIndexElement;
    }
}
export {};
