/**
 * @fileoverview
 * 'settings-ai-logging-info-bullet' is a bullet point that informs about
 * logging practices. It shows different info depending on the managed state of
 * an AI feature. |pref| must be set to the preference that is bound to the
 * enterprise policy of this AI feature.
 */
import '/shared/settings/controls/cr_policy_pref_indicator.js';
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import '../settings_shared.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
declare const SettingsAiLoggingInfoBulletBase: typeof PolymerElement & (new (...args: any[]) => import("/shared/settings/controls/pref_control_mixin.js").PrefControlMixinInterface);
export declare class SettingsAiLoggingInfoBullet extends SettingsAiLoggingInfoBulletBase {
    static get is(): string;
    static get template(): HTMLTemplateElement;
    static get properties(): {
        label_: {
            type: StringConstructor;
            computed: string;
        };
        loggingManagedDisabledCustomLabel: {
            type: StringConstructor;
            value: null;
        };
    };
    private label_;
    loggingManagedDisabledCustomLabel: string | null;
    private isLoggingDisabledByPolicy_;
    private computeLabel_;
}
declare global {
    interface HTMLElementTagNameMap {
        'settings-ai-logging-info-bullet': SettingsAiLoggingInfoBullet;
    }
}
export {};
