// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * 'settings-ai-info-card' is the top info card in AI settings page.
 */
import 'chrome://resources/cr_elements/cr_icon/cr_icon.js';
import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import '../settings_page/settings_section.js';
import '../settings_shared.css.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { loadTimeData } from '../i18n_setup.js';
import { getTemplate } from './ai_info_card.html.js';
export class SettingsAiInfoCardElement extends PolymerElement {
    static get is() {
        return 'settings-ai-info-card';
    }
    static get template() {
        return getTemplate();
    }
    static get properties() {
        return {
            icon3_: {
                type: String,
                computed: 'computeIcon3_()',
            },
        };
    }
    isManaged_() {
        return loadTimeData.getBoolean('isManaged');
    }
    computeIcon3_() {
        return this.isManaged_() ? loadTimeData.getString('managedByIcon') :
            'settings20:account-box';
    }
}
customElements.define(SettingsAiInfoCardElement.is, SettingsAiInfoCardElement);
