/**
 * @fileoverview
 * 'settings-a11y-page' is the small section of advanced settings with
 * a link to the web store accessibility page on most platforms, and
 * a subpage with lots of other settings on Chrome OS.
 */
import 'chrome://resources/cr_elements/cr_link_row/cr_link_row.js';
import '../controls/settings_toggle_button.js';
import '../settings_page/settings_section.js';
import '../settings_shared.css.js';
import './ax_annotations_section.js';
import './live_caption.js';
import { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import type { SettingsToggleButtonElement } from '../controls/settings_toggle_button.js';
/**
 * Must be kept in sync with the C++ enum of the same name in
 * chrome/browser/ui/toasts/toast_metrics.h.
 */
export declare enum ToastAlertLevel {
    ALL = 0,
    ACTIONABLE = 1,
    COUNT = 1
}
declare const SettingsA11yPageElementBase: typeof PolymerElement & (new (...args: any[]) => import("../base_mixin.js").BaseMixinInterface) & (new (...args: any[]) => import("chrome://resources/cr_elements/web_ui_listener_mixin.js").WebUiListenerMixinInterface) & (new (...args: any[]) => import("/shared/settings/prefs/prefs_mixin.js").PrefsMixinInterface) & (new (...args: any[]) => import("../settings_page/settings_view_mixin.js").SettingsViewMixinInterface);
export interface SettingsA11yPageElement {
    $: {
        toastToggle: SettingsToggleButtonElement;
    };
}
export declare class SettingsA11yPageElement extends SettingsA11yPageElementBase {
    static get is(): "settings-a11y-page";
    static get template(): HTMLTemplateElement;
    static get properties(): {
        enableLiveCaption_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
        /**
         * Indicate whether a screen reader is enabled. Also, determine whether
         * to show accessibility labels settings.
         */
        hasScreenReader_: {
            type: BooleanConstructor;
            value: boolean;
        };
        /**
         * Whether to show the AxTreeFixing subpage.
         */
        showAxTreeFixingSection_: {
            type: BooleanConstructor;
            value: () => boolean;
        };
        /**
         * Whether to show the AxAnnotations subpage.
         */
        showAxAnnotationsSection_: {
            type: BooleanConstructor;
            computed: string;
        };
        /** Valid toast alert level option. */
        toastAlertLevelEnum_: {
            type: ObjectConstructor;
            value: typeof ToastAlertLevel;
        };
        numericUncheckedToastAlertValues_: {
            type: ArrayConstructor;
            value: () => ToastAlertLevel[];
        };
    };
    private browserProxy_;
    private enableLiveCaption_;
    private numericUncheckedToastAlertValues_;
    private hasScreenReader_;
    private showAxTreeFixingSection_;
    private showAxAnnotationsSection_;
    connectedCallback(): void;
    private onA11yCaretBrowsingChange_;
    private onA11yImageLabelsChange_;
    /**
     * Return whether to show the AxAnnotations subpage based on:
     *    1. If any annotation's feature flag is enabled.
     *    2. Whether a screen reader is enabled.
     * Note: on ChromeOS, the AxAnnotations subpage is shown on a different
     * settings page; i.e. Settings > Accessibility > Text-to-Speech.
     */
    private computeShowAxAnnotationsSection_;
    private onCaptionsClick_;
    private onFocusHighlightChange_;
    /** private */
    private onMoreFeaturesLinkClick_;
    private onMacTrackpadGesturesLinkClick_;
    private onToastAlertLevelChange_;
    getAssociatedControlFor(childViewId: string): HTMLElement;
}
declare global {
    interface HTMLElementTagNameMap {
        [SettingsA11yPageElement.is]: SettingsA11yPageElement;
    }
}
export {};
