import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="settings-shared">#title{color:var(--cr-primary-text-color);font-size:1.375rem;font-weight:500;letter-spacing:0.02em;margin-bottom:8px;margin-top:24px;outline:none;text-align:center}#subtitle{font-size:0.813rem;line-height:1.25rem;margin:8px auto 4px auto;max-width:400px;text-align:center}.section-header{color:var(--cr-primary-text-color);font-size:0.88rem;font-weight:400;letter-spacing:0.02em;margin-bottom:12px;margin-top:var(--cr-section-vertical-margin);outline:none;padding-bottom:4px;padding-top:8px}.card-container{display:flex;flex-direction:column;gap:16px}</style>

<h1 id="title">$i18n{yourSavedInfoPageTitle}</h1>
<div id="subtitle" class="secondary">$i18n{yourSavedInfoPageDescription}</div>
<settings-account-card prefs="{{prefs}}">
</settings-account-card>

<h2 id="yourSavedInfoPageTitle" class="section-header">
  $i18n{yourSavedInfoPageTitle}
</h2>
<div class="card-container" on-data-category-click="onDataCategoryClick_"
    on-data-chip-click="onDataChipClick_">
  <category-reference-card card-title="$i18n{localPasswordManager}"
      is-external
      category-id="[[hierarchy_.passwordManager.id]]"
      chips="[[getVisibleChips_(hierarchy_.passwordManager.chips)]]">
  </category-reference-card>
  <category-reference-card id="paymentManagerButton"
      card-title="$i18n{paymentsTitle}"
      category-id="[[hierarchy_.payments.id]]"
      chips="[[getVisibleChips_(hierarchy_.payments.chips)]]">
  </category-reference-card>
  <category-reference-card id="addressesManagerButton"
      card-title="$i18n{contactInfoTitle}"
      category-id="[[hierarchy_.contactInfo.id]]"
      chips="[[getVisibleChips_(hierarchy_.contactInfo.chips)]]">
  </category-reference-card>
  <category-reference-card id="identityManagerButton"
      card-title="$i18n{identityDocsCardTitle}"
      category-id="[[hierarchy_.identityDocs.id]]"
      chips="[[getVisibleChips_(hierarchy_.identityDocs.chips)]]">
  </category-reference-card>
  <category-reference-card id="travelManagerButton"
      card-title="$i18n{travelCardTitle}"
      category-id="[[hierarchy_.travel.id]]"
      chips="[[getVisibleChips_(hierarchy_.travel.chips)]]">
  </category-reference-card>
</div>

<settings-section page-title="$i18n{yourSavedInfoAutofillSettingsLabel}">
  <collapsible-autofill-settings-card prefs="{{prefs}}">
  </collapsible-autofill-settings-card>
</settings-section>

<settings-section page-title="$i18n{yourSavedInfoRelatedServicesTitle}">
  <div route-path="default">
    <cr-link-row id="passwordManagerButton" label="$i18n{localPasswordManager}"
        on-click="onPasswordManagerRelatedServiceClick_"
        start-icon="cr20:password" external>
    </cr-link-row>
    <cr-link-row id="googleWalletButton" label="$i18n{googleWalletTitle}"
        on-click="onGoogleWalletRelatedServiceClick_"
        start-icon="settings20:wallet" external>
    </cr-link-row>
    <cr-link-row id="googleAccountButton" label="$i18n{googleAccount}"
        on-click="onGoogleAccountRelatedServiceClick_"
        start-icon="settings20:googleg" external>
    </cr-link-row>
  </div>
</settings-section>
<!--_html_template_end_-->`;
}