import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">#addSite{margin-inline-start:var(--cr-button-edge-spacing)}
    </style>
    <div id="category">
      <div class="cr-row first">
        <h2 id="listHeader" class="flex secondary" tabIndex="-1">
          [[categoryHeader]]
        </h2>
        <cr-button id="addSite" class="header-aligned-button"
            hidden$="[[!showAddSiteButton_]]" on-click="onAddSiteClick_"
            aria-label$="[[getAddButtonLabel_()]]">
          $i18n{add}
        </cr-button>
      </div>
      <div hidden$="[[!showHeaderWarning_(
              sites.*,systemPermissionWarningKey_)]]"
          id="systemPermissionDeclinedWarning"
          class="list-frame">
        <div class="list-item secondary">
          <div inner-h-t-m-l="[[getSystemPermissionWarning_(
                  systemPermissionWarningKey_)]]">
          </div>
        </div>
      </div>
      <cr-action-menu role-description="$i18n{menu}">
        <button class="dropdown-item" id="allow"
            on-click="onAllowClick_" hidden$="[[!showAllowAction_]]">
          $i18n{siteSettingsActionAllow}
        </button>
        <button class="dropdown-item" id="block"
            on-click="onBlockClick_" hidden$="[[!showBlockAction_]]">
          $i18n{siteSettingsActionBlock}
        </button>
        <button class="dropdown-item" id="sessionOnly"
            on-click="onSessionOnlyClick_"
            hidden$="[[!showSessionOnlyActionForSite_(actionMenuSite_)]]">
          $i18n{siteSettingsActionSessionOnly}
        </button>
        <button class="dropdown-item" id="edit"
            on-click="onEditClick_">
          $i18n{edit}
        </button>
        <button class="dropdown-item" id="reset"
            on-click="onResetClick_">
          $i18n{siteSettingsActionReset}
        </button>
      </cr-action-menu>

      <div class="list-frame" hidden$="[[hasSites_(sites.*)]]">
        <div class="list-item secondary">$i18n{noSitesAdded}</div>
      </div>
      <div class="list-frame"
          hidden$="[[!showNoSearchResults_(searchFilter, sites.*)]]">
        <div class="list-item secondary">$i18n{searchNoResults}</div>
      </div>
      <div class="list-frame menu-content vertical-list" id="listContainer"
          hidden$="[[!hasSites_(sites.*)]]">
        <iron-list items="[[getFilteredSites_(searchFilter, sites.*)]]"
            role="grid" aria-labelledby="listHeader"
            aria-describedby="[[categoryHeader]]" preserve-focus risk-selection>
          <template>
            <site-list-entry model="[[item]]" read-only-list="[[readOnlyList]]"
                on-show-action-menu="onShowActionMenu_"
                singleton-entry="[[hasOneFilteredSite_(searchFilter, sites.*)]]"
                section-header="[[categoryHeader]]" tabindex$="[[tabIndex]]"
                first$="[[!index]]" iron-list-tab-index="[[tabIndex]]"
                last-focused="{{lastFocused_}}" list-blurred="{{listBlurred_}}"
                on-show-tooltip="onShowTooltip_" focus-row-index="[[index]]"
                on-site-list-entry-reset-click="onResetEntry_"
                cookies-exception-type="[[cookiesExceptionType]]">
            </site-list-entry>
          </template>
        </iron-list>
      </div>
    </div>
    <cr-tooltip id="tooltip" hidden="[[!tooltipText_]]"
        fit-to-visible-bounds manual-mode position="top">
      [[tooltipText_]]
    </cr-tooltip>
    <template is="dom-if" if="[[showEditExceptionDialog_]]" restamp>
      <settings-edit-exception-dialog model="[[actionMenuSite_]]"
          on-close="onEditExceptionDialogClosed_">
      </settings-edit-exception-dialog>
    </template>
    <template is="dom-if" if="[[showAddSiteDialog_]]" restamp>
      <add-site-dialog has-incognito="[[hasIncognito_]]" category="[[category]]"
          content-setting="[[categorySubtype]]"
          on-close="onAddSiteDialogClosed_"
          cookies-exception-type="[[cookiesExceptionType]]">
      </add-site-dialog>
    </template>
<!--_html_template_end_-->`;
}