import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_-->    <style include="settings-shared md-select"></style>
    <div id="details" hidden$="[[shouldHideCategory_(site)]]">
      <div id="permissionItem"
          class$="list-item [[permissionInfoStringClass_(site.source,
                                            category,
                                            site.setting,
                                            systemPermissionWarningKey_)]]">
        <div>
          <cr-icon icon="[[icon]]" aria-hidden="true" role="presentation">
          </cr-icon>
        </div>
        <div class="middle" id="permissionHeader">
          [[label]]
          <div class="secondary" id="permissionSecondary"
              hidden$="[[!showSystemPermissionWarning_(site.source,
                  category,site.setting,systemPermissionWarningKey_)]]"
              inner-h-t-m-l="[[getSystemPermissionWarning_(
                  systemPermissionWarningKey_)]]">
          </div>
          <div class="secondary" id="permissionSecondary"
              hidden$="[[!hasPermissionInfoString_(site.source,
                                        category,
                                        site.setting, 
                                        systemPermissionWarningKey_)]]"
              inner-h-t-m-l="[[permissionInfoString_(
                site.source,
                category,
                site.setting,
                '$i18nPolymer{siteSettingsAllowlisted}',
                '$i18nPolymer{siteSettingsAdsBlockBlocklistedSingular}',
                '$i18nPolymer{siteSettingsAdsBlockNotBlocklistedSingular}',
                '$i18nPolymer{siteSettingsSourceEmbargo}',
                '$i18nPolymer{siteSettingsSourceInsecureOrigin}',
                '$i18nPolymer{siteSettingsSourceKillSwitch}',

                '$i18nPolymer{siteSettingsSourceExtensionAllow}',
                '$i18nPolymer{siteSettingsSourceExtensionBlock}',
                '$i18nPolymer{siteSettingsSourceExtensionAsk}',
                '$i18nPolymer{siteSettingsSourcePolicyAllow}',
                '$i18nPolymer{siteSettingsSourcePolicyBlock}',
                '$i18nPolymer{siteSettingsSourcePolicyAsk}')]]">
          </div>
        </div>
        <select id="permission" class="md-select"
            aria-label$="[[label]]"
            aria-describedby="permissionSecondary"
            on-change="onPermissionSelectionChange_"
            disabled$="[[!isPermissionUserControlled_(site.source, category,
                              site.setting, systemPermissionWarningKey_)]]">
          <option id="default" value$="[[contentSettingEnum_.DEFAULT]]">
            [[defaultSettingString_(
                defaultSetting_,
                category,
                useAutomaticLabel,
                useBlockIfUnfamiliarLabelForDefault)]]
          </option>
          <option id="allow" value$="[[contentSettingEnum_.ALLOW]]"
              hidden$="[[!showAllowedSetting_(category)]]">
            $i18n{siteSettingsActionAllow}
          </option>
          <option id="block" value$="[[contentSettingEnum_.BLOCK]]">
            [[blockSettingString_(
                category,
                '$i18n{siteSettingsActionBlock}',
                '$i18n{siteSettingsActionMute}')]]
          </option>
          <option id="ask" value$="[[contentSettingEnum_.ASK]]"
              hidden$="[[!showAskSetting_(category, site.setting,
                                          site.source)]]">
            $i18n{siteSettingsActionAsk}
          </option>
        </select>
      </div>
      <div class="list-frame" role="table">
        <template is="dom-repeat" items="[[chooserExceptions_]]">
          <site-details-permission-device-entry exception="[[item]]">
          </site-details-permission-device-entry>
        </template>
      </div>
    </div>
<!--_html_template_end_-->`;
}