import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteDataPageTitle}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
<div class="content-settings-header secondary">
  $i18n{siteDataPageDescription}
</div>
<div class="radio-group">
  <h2>$i18n{siteDataPageDefaultBehavior}</h2>
  <div class="secondary radio-group-sub-heading">
    $i18n{siteDataPagedefaultBehaviorDescription}
  </div>
  <settings-radio-group id="defaultGroup" no-set-pref
      pref="{{prefs.generated.cookie_default_content_setting}}"
      selectable-elements="cr-radio-button, settings-collapse-radio-button"
      on-change="onDefaultRadioChange_">
    <settings-collapse-radio-button id="defaultAllow" no-collapse
        name="[[contentSettingEnum_.ALLOW]]"
        pref="[[prefs.generated.cookie_default_content_setting]]"
        label="$i18n{siteDataPageAllowRadioLabel}"
        sub-label="$i18n{siteDataPageAllowRadioSubLabel}"
        icon="privacy:database">
    </settings-collapse-radio-button>
    <settings-collapse-radio-button id="defaultSessionOnly" no-collapse
        class="two-line"
        name="[[contentSettingEnum_.SESSION_ONLY]]"
        pref="[[prefs.generated.cookie_default_content_setting]]"
        label="$i18n{siteDataPageClearOnExitRadioLabel}"
        sub-label="$i18n{siteDataPageClearOnExitRadioSubLabel}"
        icon="privacy:database">
    </settings-collapse-radio-button>
    <settings-collapse-radio-button id="defaultBlock" no-collapse
        class="two-line"
        name="[[contentSettingEnum_.BLOCK]]"
        pref="[[prefs.generated.cookie_default_content_setting]]"
        label="$i18n{siteDataPageBlockRadioLabel}"
        sub-label="$i18n{siteDataPageBlockRadioSublabel}"
        icon="privacy:database-off">
    </settings-collapse-radio-button>
  </settings-radio-group>
</div>
<div id="exceptionHeader">
  <h2>$i18n{siteDataPageCustomizedBehaviorHeading}</h2>
  <div id="exceptionHeaderSubLabel" class="secondary">
    $i18n{siteDataPageCustomizedBehaviorDescription}
  </div>
</div>
<site-list id="allowExceptionsList"
    category="[[cookiesContentSettingType_]]"
    category-subtype="[[contentSettingEnum_.ALLOW]]"
    category-header="$i18n{siteDataPageAllowExceptionsSubHeading}"
    read-only-list="[[exceptionListsReadOnly_]]"
    search-filter="[[searchTerm]]"
    cookies-exception-type="site-data">
</site-list>
<site-list id="sessionOnlyExceptionsList"
    category="[[cookiesContentSettingType_]]"
    category-subtype="[[contentSettingEnum_.SESSION_ONLY]]"
    category-header="$i18n{siteDataPageDeleteOnExitExceptionsSubHeading}"
    read-only-list="[[exceptionListsReadOnly_]]"
    search-filter="[[searchTerm]]"
    cookies-exception-type="site-data">
</site-list>
<!-- Shows all block-exceptions (in contrast to allow and session above). -->
<site-list id="blockExceptionsList"
    category="[[cookiesContentSettingType_]]"
    category-subtype="[[contentSettingEnum_.BLOCK]]"
    category-header="$i18n{siteDataPageBlockExceptionsSubHeading}"
    read-only-list="[[exceptionListsReadOnly_]]"
    search-filter="[[searchTerm]]"
    cookies-exception-type="combined">
</site-list>
<template is="dom-if" if="[[showDefaultBlockDialog_]]" restamp>
  <cr-dialog id="defaultBlockDialog" show-on-attach>
    <div slot="title">$i18n{siteDataPageBlockConfirmDialogTitle}</div>
    <div slot="body">$i18n{siteDataPageBlockConfirmDialogDescription}</div>
    <div slot="button-container">
    <cr-button id="defaultBlockDialogCancel" class="cancel-button"
        on-click="onDefaultBlockDialogCancel_">
        $i18n{siteDataPageBlockConfirmDialogCancelButton}
    </cr-button>
    <cr-button id="defaultBlockDialogConfirm" class="action-button"
        on-click="onDefaultBlockDialogConfirm_">
        $i18n{siteDataPageBlockConfirmDialogConfirmButton}
    </cr-button>
    </div>
  </cr-dialog>
</template>
</settings-subpage>
<!--_html_template_end_-->`;
}