import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_-->  <style include="settings-shared md-select clear-storage-dialog-shared">cr-dialog div[slot=title]{line-height:20px}#sort{align-items:center;display:flex;margin:0 var(--cr-icon-button-margin-start);margin-bottom:8px;padding:0 var(--cr-section-padding)}#sortMethod{margin-inline-start:1em}.list-frame.without-heading{padding-inline-start:var(--cr-section-padding)}#clearAllContainer{align-items:center;display:flex;height:var(--cr-section-two-line-min-height);justify-content:space-between;margin:0 var(--cr-icon-button-margin-start);padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding)}#relatedWebsiteSetsLearnMore{margin:0 var(--cr-icon-button-margin-start);padding-bottom:16px;padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding);width:60%}#relatedWebsiteSetsDescription{margin:0 var(--cr-icon-button-margin-start);padding-bottom:8px;padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding)}#clearAllButton cr-button{white-space:nowrap}
  </style>
  <settings-subpage page-title="$i18n{siteSettingsAllSites}"
      search-label="$i18n{siteSettingsAllSitesFilter}"
      search-icon="settings20:filter-list"
      search-term="{{filter}}" preserve-search-term route-path$="[[routePath]]"
      hide-close-button>
    <div id="sort">
      <label id="sortLabel">$i18n{siteSettingsAllSitesSort}</label>
      <select id="sortMethod" class="md-select" aria-labelledby="sortLabel"
          on-change="onSortMethodChanged_">
        <option value="[[sortMethodEnum_.MOST_VISITED]]">
          $i18n{siteSettingsAllSitesSortMethodMostVisited}
        </option>
        <option value="[[sortMethodEnum_.STORAGE]]">
          $i18n{siteSettingsAllSitesSortMethodStorage}
        </option>
        <option value="[[sortMethodEnum_.NAME]]">
          $i18n{siteSettingsAllSitesSortMethodName}
        </option>
      </select>
    </div>
    <div id="clearAllContainer">
      <div id="clearLabel">
          [[getClearStorageDescription_(totalUsage_, filter, filteredList_)]]
      </div>
      <div id="clearAllButton"
          hidden$="[[!shouldShowClearAllButton_(filteredList_.length)]]">
        <cr-button type="button" on-click="onConfirmClearAllData_">
          [[getClearDataButtonString_(filter)]]
        </cr-button>
      </div>
    </div>
    <div id="relatedWebsiteSetsLearnMore"
        hidden$="[[!hasFilteredRwsSites_(filter, filteredList_)]]">
      [[getRwsLearnMoreLabel_(filter)]]
      <a href="$i18n{relatedWebsiteSetsLearnMoreURL}"
          aria-label="$i18n{siteSettingsRelatedWebsiteSetsLearnMoreAccessibility}">
        $i18n{learnMore}
      </a>
    </div>
    <div class="list-frame" hidden$="[[!siteGroupMapEmpty_(siteGroupMap)]]">
      <div class="list-item secondary">$i18n{emptyAllSitesPage}</div>
    </div>
    <div id="noSitesFoundText" class="list-frame"
        hidden$="[[!noSearchResultFound_(filteredList_)]]">
      <div class="list-item secondary">$i18n{noSitesFound}</div>
    </div>
    <div class="list-frame without-heading" id="listContainer">
      <iron-list id="allSitesList"
          items="[[filteredList_]]"
          scroll-target="[[subpageScrollTarget]]">
        <template>
          <site-entry site-group="[[item]]" list-index="[[index]]"
              iron-list-tab-index="[[tabIndex]]"
              focus-row-index="[[index]]"
              tabindex$="[[tabIndex]]"
              last-focused="{{lastFocused_}}"
              list-blurred="{{listBlurred_}}"
              sort-method="[[sortMethod_]]"
              is-rws-filtered="[[isRwsFiltered_(filter)]]">
          </site-entry>
        </template>
      </iron-list>
    </div>

    <!-- Overflow menu. -->
    <cr-lazy-render id="menu">
      <template>
        <cr-action-menu role-description="$i18n{menu}">
          <button class="dropdown-item" role="menuitem"
              on-click="onShowRelatedSites_">
            $i18n{relatedWebsiteSetsShowRelatedSitesButton}
          </button>
          <button class="dropdown-item" role="menuitem" on-click="onRemove_">
            $i18n{relatedWebsiteSetsSiteDeleteStorageButton}
          </button>
        </cr-action-menu>
      </template>
    </cr-lazy-render>

    <!-- Confirm remove site dialog. -->
    <cr-lazy-render id="confirmRemoveSite">
      <template>
        <cr-dialog close-text="$i18n{close}">
          <div id="removeSiteTitle" slot="title">
            [[getRemoveSiteTitle_(actionMenuModel_)]]
          </div>
          <div slot="body">
            <div id="logoutBulletPoint" class="detail">
              <cr-icon icon="all-sites:logout" aria-hidden="true"
                role="presentation"></cr-icon>
              [[getRemoveSiteLogoutBulletPoint_(actionMenuModel_)]]
            </div>
            <div class="detail">
              <cr-icon icon="all-sites:offline" aria-hidden="true"
                role="presentation"></cr-icon>
              $i18n{siteSettingsRemoveSiteOfflineData}
            </div>
            <div id="permissionsBulletPoint" class="detail"
                hidden$="[[!showPermissionsBulletPoint_(actionMenuModel_)]]">
              <cr-icon icon="privacy:page-info"></cr-icon>
              $i18n{siteSettingsRemoveSitePermissions}
            </div>
          </div>
          <div slot="button-container">
            <cr-button class="cancel-button" on-click="onCloseDialog_">
              $i18n{cancel}
            </cr-button>
            <cr-button class="action-button" on-click="onConfirmRemoveSite_">
              $i18n{siteSettingsRemoveSiteConfirm}
            </cr-button>
          </div>
        </cr-dialog>
      </template>
    </cr-lazy-render>

    <!-- Confirm clear all data dialog. -->
    <cr-lazy-render id="confirmClearAllData">
      <template>
        <cr-dialog close-text="$i18n{close}">
          <div slot="title">[[getClearAllStorageDialogTitle_(filter)]]</div>
          <div slot="body">
            <div id="clearAllStorageDialogDescription">
              [[getClearAllStorageDialogDescription_(totalUsage_,
                  filteredList_)]]
            </div>
            <div class="detail-list">
              <div id="clearAllStorageDialogSignOutLabel" class="detail">
                <cr-icon icon="all-sites:logout" aria-hidden="true"
                  role="presentation"></cr-icon>
                [[getClearAllStorageDialogSignOutLabel_(filter)]]
              </div>
              <div class="detail">
                <cr-icon icon="all-sites:offline" aria-hidden="true"
                  role="presentation"></cr-icon>
                $i18n{siteSettingsSiteGroupDeleteOfflineData}
              </div>
            </div>
          </div>
          <div slot="button-container">
            <cr-button class="cancel-button" on-click="onCloseDialog_">
              $i18n{cancel}
            </cr-button>
            <cr-button class="action-button" on-click="onClearAllData_">
              $i18n{siteSettingsSiteClearStorage}
            </cr-button>
          </div>
        </cr-dialog>
      </template>
    </cr-lazy-render>
  </settings-subpage>
<!--_html_template_end_-->`;
}