import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_-->  <style include="cr-shared-style settings-shared">settings-omnibox-extension-entry{border-top:var(--cr-separator-line)}
  </style>
  <settings-subpage
      page-title="$i18n{searchEnginesManageSiteSearch}"
      route-path$="[[routePath]]" search-label="$i18n{searchEnginesSearch}"
      search-icon="settings20:filter-list"
      search-term="{{filter_}}">
    <div class="cr-row first">
      <div class="secondary">$i18n{searchEnginesPageExplanation}</div>
    </div>
    <div class="cr-row first">
      <div class="flex cr-padded-text">
        <div id="keyboardShortcutsTitle">
          $i18n{searchEnginesKeyboardShortcutsTitle}
        </div>
        <div class="secondary">
          $i18n{searchEnginesKeyboardShortcutsDescription}
        </div>
      </div>
    </div>
    <div class="list-frame">
      <settings-radio-group id="keyboardShortcutSettingGroup"
          pref="{{prefs.omnibox.keyword_space_triggering_enabled}}"
          on-change="onKeyboardShortcutSettingChange_">
        <controlled-radio-button class="list-item" name="true"
            pref="{{prefs.omnibox.keyword_space_triggering_enabled}}"
            label="$i18n{searchEnginesKeyboardShortcutsSpaceOrTab}"
            aria-labelledby="keyboardShortcutsTitle"
            no-extension-indicator>
        </controlled-radio-button>
        <controlled-radio-button class="list-item" name="false"
            pref="{{prefs.omnibox.keyword_space_triggering_enabled}}"
            label="$i18n{searchEnginesKeyboardShortcutsTab}"
            aria-labelledby="keyboardShortcutsTitle"
            no-extension-indicator>
        </controlled-radio-button>
      </settings-radio-group>
    </div>

    <div class="cr-row first">
      <div class="flex cr-padded-text">
        <h2>$i18n{searchEnginesSearchEngines}</h2>
        <div class="secondary">
          $i18n{searchEnginesSearchEnginesExplanation}
        </div>
      </div>
    </div>
    <settings-search-engines-list hidden="[[!matchingDefaultEngines_.length]]"
        engines="[[matchingDefaultEngines_]]" show-shortcut>
    </settings-search-engines-list>

    <div class="no-search-results list-frame"
        hidden="[[matchingDefaultEngines_.length]]">
      $i18n{searchNoResults}
    </div>

    <template is="dom-if" if="[[showEditDialog_]]" restamp>
      <settings-search-engine-edit-dialog model="[[dialogModel_]]"
          on-close="onCloseEditDialog_">
      </settings-search-engine-edit-dialog>
    </template>

    <template is="dom-if" if="[[showDeleteConfirmationDialog_]]" restamp>
      <settings-simple-confirmation-dialog id="deleteConfirmDialog"
          title-text="$i18n{searchEnginesDeleteConfirmationTitle}"
          body-text="[[getDeleteConfirmationBodyText_(dialogModel_)]]"
          confirm-text="$i18n{delete}"
          on-close="onCloseDeleteConfirmationDialog_">
      </settings-simple-confirmation-dialog>
    </template>

    <div class="cr-row first">
        <div class="flex cr-padded-text">
          <h2>$i18n{searchEnginesSiteSearch}</h2>
          <div class="secondary">$i18n{searchEnginesSiteSearchExplanation}</div>
        </div>
        <cr-button class="secondary-button header-aligned-button"
                   aria-label="$i18n{searchEnginesAddButtonAriaLabel}"
                   on-click="onAddSearchEngineClick_" id="addSearchEngine">
          $i18n{add}
        </cr-button>
    </div>
    <div id="noActiveEngines" class="list-frame"
           hidden="[[activeEngines.length]]">
          $i18n{searchEnginesNoSitesAdded}
    </div>
    <div class="no-search-results list-frame"
           hidden="[[!showNoResultsMessage_(
          activeEngines, matchingActiveEngines_)]]">
          $i18n{searchNoResults}
    </div>
    <settings-search-engines-list id="activeEngines"
        hidden="[[!matchingActiveEngines_.length]]"
        engines="[[matchingActiveEngines_]]"
        scroll-target="[[subpageScrollTarget]]"
        show-shortcut collapse-list
        expand-list-text="$i18n{searchEnginesAdditionalSites}">
    </settings-search-engines-list>

    <div class="cr-row first">
        <h2>$i18n{searchEnginesInactiveShortcuts}</h2>
    </div>
    <settings-search-engines-list
        hidden="[[!matchingOtherEngines_.length]]"
        engines="[[matchingOtherEngines_]]"
        scroll-target="[[subpageScrollTarget]]"
        show-query-url collapse-list
        expand-list-text="$i18n{searchEnginesAdditionalInactiveSites}">
    </settings-search-engines-list>

    <div id="noOtherEngines" class="list-frame"
        hidden="[[otherEngines.length]]">
      $i18n{searchEnginesNoOtherEngines}
    </div>
    <div class="no-search-results list-frame"
        hidden="[[!showNoResultsMessage_(
            otherEngines, matchingOtherEngines_)]]">
      $i18n{searchNoResults}
    </div>

    <template is="dom-if" if="[[showExtensionsList_]]">
      <div class="cr-row first">
        <div class="flex cr-padded-text">
          <h2 class="flex">$i18n{searchEnginesExtension}</h2>
          <div class="secondary"> $i18n{searchEnginesExtensionExplanation}</div>
        </div>
      </div>
      <div class="no-search-results list-frame"
          hidden="[[matchingExtensions_.length]]">
        $i18n{searchNoResults}
      </div>
      <iron-list id="extensions" class="extension-engines list-frame"
          items="[[matchingExtensions_]]" preserve-focus risk-selection>
        <template>
          <settings-omnibox-extension-entry engine="[[item]]"
              focus-row-index="[[index]]"
              tabindex$="[[tabIndex]]" iron-list-tab-index="[[tabIndex]]"
              last-focused="{{omniboxExtensionlastFocused_}}"
              list-blurred="{{omniboxExtensionListBlurred_}}">
          </settings-omnibox-extension-entry>
        </template>
      </iron-list>
    </template>
  </settings-subpage>
<!--_html_template_end_-->`;
}