import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_-->    <style include="settings-shared">#policySubtitleContainer{gap:10px;display:flex;margin-bottom:16px}
    </style>
    <cr-dialog id="dialog" close-text="$i18n{close}">
      <div slot="title">[[dialogTitle_]]</div>
      <div slot="body" spellcheck="false">
        <template is="dom-if" if="[[showPolicySubtitle_]]">
          <div id="policySubtitleContainer">
            <cr-icon icon="cr:domain"></cr-icon>
            <span class="secondary">
              $i18n{searchEnginesDeleteConfirmationSubtitleForPolicy}
            </span>
          </div>
        </template>
        <cr-input id="searchEngine"
            label="$i18n{searchEnginesName}"
            readonly="[[readonly_]]"
            error-message="$i18n{notValid}"
            value="{{searchEngine_}}" on-input="validate_"
            autofocus>
        </cr-input>
        <cr-input id="keyword"
            label="$i18n{searchEnginesShortcut}"
            readonly="[[readonly_]]"
            error-message="$i18n{notValid}"
            value="{{keyword_}}" on-focus="validate_" on-input="validate_">
        </cr-input>
        <cr-input id="queryUrl"
            label="$i18n{searchEnginesQueryURLExplanation}"
            readonly="[[urlIsReadonly_]]"
            error-message="$i18n{notValid}"
            value="{{queryUrl_}}" on-focus="validate_" on-input="validate_">
        </cr-input>
      </div>
      <div slot="button-container">
        <cr-button class="cancel-button" on-click="cancel_" id="cancel"
            hidden="[[readonly_]]">
          $i18n{cancel}</cr-button>
        <cr-button id="actionButton" class="action-button"
            on-click="onActionButtonClick_">
          [[actionButtonText_]]
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`;
}