import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="cr-shared-style">:host{display:flex;flex-direction:column}.box{background-color:var(--cr-card-background-color);box-shadow:var(--cr-card-shadow)}.card{flex:1;padding:20px}.card:hover{background-color:var(--cr-hover-background-color);cursor:pointer}.card-start{border-start-start-radius:var(--cr-card-border-radius)}.card-end{border-start-end-radius:var(--cr-card-border-radius)}#bundlesRadioGroup controlled-radio-button::part(labelWrapper){align-items:center;display:flex;justify-content:space-between}.section-header{color:var(--cr-primary-text-color);flex:1;font-size:108%;font-weight:400;letter-spacing:.25px;margin-bottom:16px;margin-top:30px;width:100%;user-select:none}.section-header.first{margin-top:0px}#safeBrowsingRadioGroup{padding-inline-start:40px}security-page-feature-row{border-end-start-radius:var(--cr-card-border-radius);border-end-end-radius:var(--cr-card-border-radius)}settings-toggle-button{border-radius:var(--cr-card-border-radius)}</style>
<settings-subpage page-title="$i18n{securityPageTitle}"
    learn-more-url="$i18n{safeBrowsingHelpCenterURL}"
    route-path$="[[routePath]]" class="multi-card" hide-close-button>
  <h2 class="section-header cr-secondary-text first">
    $i18n{securityTitle}
  </h2>
  <settings-radio-group id="bundlesRadioGroup"
      class="card-container"
      pref="{{prefs.generated.security_settings_bundle}}"
      on-change="onSecurityBundleChanged_"
      selectable-elements="controlled-radio-button"
      nested-selectable is-horizontal>
    <div class="box card card-start">
      <controlled-radio-button
          id="securitySettingsBundleStandard"
          name="[[securitySettingsBundleSettingEnum_.STANDARD]]"
          pref="{{prefs.generated.security_settings_bundle}}"
          label="$i18n{securityStandardBundleTitle}">
        <cr-button
            id="resetStandardBundleToDefaultsButton"
            on-click="onResetBundleToDefaultsButtonClick_"
            hidden$="[[!isResetStandardBundleToDefaultsButtonVisible_]]">
          $i18n{securityBundleResetToDefaultsButtonLabel}
        </cr-button>
      </controlled-radio-button>
      <!-- TODO(crbug.com/460826064): Fix styling before enabling feature. -->
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:computer"></cr-icon>
          <div class="cr-secondary-text">
            $i18n{securityBundleStandardBulletOne}
          </div>
        </li>
        <li>
          <cr-icon icon="settings20:local-cafe"></cr-icon>
          <div class="cr-secondary-text">
            $i18n{securityBundleStandardBulletTwo}
          </div>
        </li>
        <li>
          <cr-icon icon="settings20:sprint"></cr-icon>
          <div class="cr-secondary-text">
            $i18n{securityBundleStandardBulletThree}
          </div>
        </li>
      </ul>
    </div>
    <div class="box card card-end">
      <controlled-radio-button
          id="securitySettingsBundleEnhanced"
          name="[[securitySettingsBundleSettingEnum_.ENHANCED]]"
          pref="{{prefs.generated.security_settings_bundle}}"
          label="$i18n{securityEnhancedBundleTitle}">
        <cr-button id="resetEnhancedBundleToDefaultsButton"
            on-click="onResetBundleToDefaultsButtonClick_"
            hidden$="[[!isResetEnhancedBundleToDefaultsButtonVisible_]]">
          $i18n{securityBundleResetToDefaultsButtonLabel}
        </cr-button>
      </controlled-radio-button>
      <!-- TODO(crbug.com/460826064): Fix styling before enabling feature. -->
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:center-focus-strong"></cr-icon>
          <div class="cr-secondary-text">
            $i18n{securityBundleEnhancedBulletOne}
          </div>
        </li>
        <li>
          <cr-icon icon="settings20:e911-emergency"></cr-icon>
          <div class="cr-secondary-text">
            $i18n{securityBundleEnhancedBulletTwo}
          </div>
        </li>
        <li>
          <cr-icon icon="settings20:front-hand"></cr-icon>
          <div class="cr-secondary-text">
            $i18n{securityBundleEnhancedBulletThree}
          </div>
        </li>
      </ul>
    </div>
  </settings-radio-group>
  <security-page-feature-row id="safeBrowsingRow"
      on-expanded-changed="onSafeBrowsingRowClick_"
      pref="{{prefs.generated.safe_browsing}}"
      label="$i18n{securitySafeBrowsingTitle}"
      sub-label="$i18n{securitySafeBrowsingDesc}"
      class="box"
      numeric-unchecked-values="[[safeBrowsingOff_]]"
      state-text-map="[[safeBrowsingStateTextMap_]]">
    <div slot="collapse">
      <settings-radio-group id="safeBrowsingRadioGroup"
          pref="{{prefs.generated.safe_browsing}}"
          selectable-elements="controlled-radio-button"
          on-change="onSafeBrowsingRadioChange_">
        <controlled-radio-button
            label="$i18n{securitySafeBrowsingStandardTitle}"
            name="[[safeBrowsingSettingEnum_.STANDARD]]"
            pref="[[prefs.generated.safe_browsing]]">
        </controlled-radio-button>
        <controlled-radio-button id="enhancedProtectionButton"
            label="$i18n{securitySafeBrowsingEnhancedTitle}"
            name="[[safeBrowsingSettingEnum_.ENHANCED]]"
            pref="[[prefs.generated.safe_browsing]]">
        </controlled-radio-button>
      </settings-radio-group>
    </div>
  </security-page-feature-row>
  <h2 class="section-header cr-secondary-text">
    $i18n{securityAccountAndNetworkSectionTitle}
  </h2>
  <settings-toggle-button id="passwordsLeakToggle"
      pref="{{prefs.generated.password_leak_detection}}"
      label="$i18n{securityPasswordsLeakDetectionTitle}"
      sub-label="$i18n{securityPasswordsLeakDetectionDesc}"
      class="box">
  </settings-toggle-button>
</settings-subpage>
<!--_html_template_end_-->`;
}