import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="privacy-guide-fragment-shared"></style>
<div class="settings-fragment-header" focus-element tabindex="-1">
  <picture>
    <source
        srcset="./images/privacy_guide/msbb_graphic_dark_v2.svg"
        media="(prefers-color-scheme: dark)">
    <img alt="" src="./images/privacy_guide/msbb_graphic_v2.svg">
  </picture>
  <h2 class="settings-fragment-header-label">
    $i18n{privacyGuideMsbbCardHeader}
  </h2>
</div>
<div class="fragment-content">
  <div class="embedded-setting-wrapper">
    <settings-toggle-button id="urlCollectionToggle"
        pref="{{prefs.url_keyed_anonymized_data_collection.enabled}}"
        label="$i18n{urlKeyedAnonymizedDataCollection}"
        on-change="onMsbbToggleClick_">
    </settings-toggle-button>
  </div>
  <div class="settings-columned-section">
    <div class="column">
      <h3 class="description-header">
        $i18n{columnHeadingWhenOn}
      </h3>
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:flash-on" aria-hidden="true"></cr-icon>
          <div class="secondary">
            $i18n{privacyGuideMsbbFeatureDescription1}
          </div>
        </li>
        <li>
          <cr-icon icon="settings20:lightbulb" aria-hidden="true"></cr-icon>
          <div class="secondary">
            $i18n{privacyGuideMsbbFeatureDescription2}
          </div>
        </li>
        <li>
          <cr-icon icon="settings20:notification-add" aria-hidden="true">
          </cr-icon>
          <div class="secondary">
            $i18n{privacyGuideMsbbFeatureDescription3}
          </div>
        </li>
      </ul>
    </div>
    <div class="column">
      <h3 class="description-header">$i18n{columnHeadingConsider}</h3>
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:link" aria-hidden="true"></cr-icon>
          <div class="secondary">
            $i18n{privacyGuideMsbbPrivacyDescription1}
          </div>
        </li>
        <li>
          <cr-icon icon="settings20:data-connectors-system" aria-hidden="true">
          </cr-icon>
          <div class="secondary">
            $i18n{privacyGuideMsbbPrivacyDescription2}
          </div>
        </li>
      </ul>
    </div>
  </div>
</div>
<!--_html_template_end_-->`;
}