import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_-->    <style include="settings-shared md-select">:host(.list-frame) settings-toggle-button{padding-inline-end:0;padding-inline-start:0}:host(.list-frame) cr-link-row{padding-inline-end:8px;padding-inline-start:0}.hr:not(.hr:not([hidden])~*){border-top:0}#chromeSigninUserChoiceSetting{padding:var(--settings-signin-choice-padding,10px 0px 10px)}#labelWrapper{margin-inline-end:20px}

    </style>


    <div id="chromeSigninUserChoiceSetting" class="hr cr-row" role="group"
        hidden="[[!chromeSigninUserChoiceInfo_.shouldShowSettings]]"
        aria-label="$i18n{chromeSigninChoiceTitle}">
      <div id="labelWrapper" class="flex">
          <div>
            $i18n{chromeSigninChoiceTitle}
          </div>
          <div id="chromeSigninChoiceDescription" class="secondary">
            [[i18n('chromeSigninChoiceDescription',
                chromeSigninUserChoiceInfo_.signedInEmail)]]
          </div>
      </div>
      <select id="chromeSigninUserChoiceSelection" class="md-select"
          on-change="onChromeSigninChoiceSelectionChanged_">
          <option selected disabled hidden
              value="[[chromeSigninUserChoiceEnum_.NO_CHOICE]]">
            $i18n{chromeSigninChoiceSelectOptionPlaceholder}
          </option>
          <option value="[[chromeSigninUserChoiceEnum_.SIGNIN]]">
            $i18n{chromeSigninChoiceSignin}
          </option>
          <option value="[[chromeSigninUserChoiceEnum_.DO_NOT_SIGNIN]]">
            $i18n{chromeSigninChoiceDoNotSignin}
          </option>
          <option value="[[chromeSigninUserChoiceEnum_.ALWAYS_ASK]]">
            $i18n{chromeSigninChoiceAlwaysAsk}
          </option>
      </select>
    </div>
    <settings-toggle-button id="signinAllowedToggle"
        class="hr"
        hidden="[[!signinAvailable_]]"
        disabled="[[syncFirstSetupInProgress_]]"
        pref="{{prefs.signin.allowed_on_next_startup}}"
        label="$i18n{signinAllowedTitle}"
        sub-label="$i18n{signinAllowedDescription}"
        on-settings-boolean-control-change="onSigninAllowedChange_"
        no-set-pref>
    </settings-toggle-button>
<!-- not chromeos -->
<!-- _google_chrome -->
    <settings-toggle-button id="urlCollectionToggle"
        class="hr"
        pref="{{prefs.url_keyed_anonymized_data_collection.enabled}}"
        label="$i18n{urlKeyedAnonymizedDataCollection}"
        sub-label="$i18n{urlKeyedAnonymizedDataCollectionDesc}">
    </settings-toggle-button>
<!-- _google_chrome -->
    <template is="dom-if" if="[[showSearchSuggestToggle_()]]" restamp>
      <settings-toggle-button id="searchSuggestToggle"
          class="hr"
          pref="{{prefs.search.suggest_enabled}}"
          label="$i18n{searchSuggestPref}"
          sub-label="$i18n{searchSuggestPrefDesc}">
      </settings-toggle-button>
    </template>

    <!-- This toggle is only shown for users with the appropriate enterprise
        policy enabled. The state is not changeable by the user, so when shown,
        it is alays selected but disabled. -->
    <template is="dom-if" if="[[showSearchAggregatorSuggest_]]" restamp>
      <settings-toggle-button id="searchAggregatorSuggestToggle"
          pref="[[searchAggregatorSuggestFakePref_]]"
          disabled
          class="hr"
          label="$i18n{searchAggregatorSuggestPref}"
          sub-label="$i18n{searchAggregatorSuggestPrefDesc}">
      </settings-toggle-button>
    </template>

    <template is="dom-if" if="[[showPriceEmailNotificationsToggle_(
        syncStatus, syncStatus.signedInState)]]" restamp>
      <settings-toggle-button id="priceEmailNotificationsToggle"
          class="hr"
          label="$i18n{priceEmailNotificationsPref}"
          sub-label="[[getPriceEmailNotificationsPrefDesc_(syncStatus)]]"
          pref="{{prefs.price_tracking.email_notifications_enabled}}">
      </settings-toggle-button>
    </template>

    <template is="dom-if" if="[[showSignoutDialog_]]" restamp>
      <settings-signout-dialog sync-status="[[syncStatus]]"
          on-close="onSignoutDialogClosed_">
      </settings-signout-dialog>
    </template>


    <cr-toast id="toast">
      <div>$i18n{restartToApplyChanges}</div>
      <cr-button on-click="onRestartClick_">$i18n{restart}</cr-button>
    </cr-toast>

    <template is="dom-if" if="[[shouldShowRelaunchDialog]]" restamp>
      <relaunch-confirmation-dialog restart-type="[[restartTypeEnum.RESTART]]"
          on-close="onRelaunchDialogClose"></relaunch-confirmation-dialog>
    </template>
    <cr-toast id="chromeSigninUserChoiceToast" duration="5000">
      <div>$i18n{chromeSigninChoiceToast}</div>
    </cr-toast>

<!--_html_template_end_-->`;
}