// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {loadTimeData} from './i18n_setup.js';

/**
 * Specifies page visibility based on incognito status and Chrome OS guest mode.
 */
export interface PageVisibility {
  a11y?: boolean;
  ai?: boolean;
  appearance?: boolean|AppearancePageVisibility;
  autofill?: boolean;
  defaultBrowser?: boolean;
  downloads?: boolean;
  extensions?: boolean;
  languages?: boolean;
  onStartup?: boolean;
  people?: boolean;
  performance?: boolean;
  privacy?: boolean|PrivacyPageVisibility;
  reset?: boolean;
  safetyHub?: boolean;
  system?: boolean;
  yourSavedInfo?: boolean;
}

export interface AppearancePageVisibility {
  bookmarksBar: boolean;
  homeButton: boolean;
  hoverCard: boolean;
  pageZoom: boolean;
  setTheme: boolean;
  sidePanel: boolean;
}

// TODO(crbug.com/362659905): Merge pageVisibility.safetyHub with
// PrivacyPageVisibility when the crash is fixed.
export interface PrivacyPageVisibility {
  networkPrediction: boolean;
  searchPrediction: boolean;
}

function createPageVisibility(): PageVisibility|undefined {
  if (!loadTimeData.getBoolean('isGuest')) {
    return undefined;
  }

  // 
  const pageVisibility = {
    a11y: false,
    ai: false,
    appearance: false,
    autofill: false,
    defaultBrowser: false,
    downloads: false,
    extensions: false,
    languages: false,
    onStartup: false,
    people: false,
    performance: false,
    privacy: false,
    reset: false,
    safetyHub: false,
    system: false,
    yourSavedInfo: false,
  };
  // 
  // 

  return pageVisibility;
}

/**
 * Dictionary defining page visibility.
 */
export let pageVisibility: PageVisibility|undefined = createPageVisibility();

export function resetPageVisibilityForTesting(
    testVisibility: PageVisibility|undefined = createPageVisibility()) {
  pageVisibility = testVisibility;
}
