import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_-->  <style include="cr-shared-style settings-shared"></style>
  <settings-section page-title="$i18n{onStartup}"
      class="cr-centered-card-container">
    <div class="cr-row first">
      <settings-radio-group id="onStartupRadioGroup"
          class="flex"
          pref="{{prefs.session.restore_on_startup}}"
          group-aria-label="$i18n{onStartup}">
        <controlled-radio-button name="[[getName_(prefValuesEnum_.OPEN_NEW_TAB)]]"
            pref="[[prefs.session.restore_on_startup]]"
            label="$i18n{onStartupOpenNewTab}"
            no-extension-indicator>
        </controlled-radio-button>
        <template is="dom-if" if="[[ntpExtension_]]">
          <extension-controlled-indicator
              extension-id="[[ntpExtension_.id]]"
              extension-name="[[ntpExtension_.name]]"
              extension-can-be-disabled="[[ntpExtension_.canBeDisabled]]">
          </extension-controlled-indicator>
        </template>
        <controlled-radio-button name="[[getName_(prefValuesEnum_.CONTINUE)]]"
            pref="[[prefs.session.restore_on_startup]]"
            label="$i18n{onStartupContinue}">
        </controlled-radio-button>
        <controlled-radio-button name="[[getName_(prefValuesEnum_.OPEN_SPECIFIC)]]"
            pref="[[prefs.session.restore_on_startup]]"
            label="$i18n{onStartupOpenSpecific}">
        </controlled-radio-button>
        <controlled-radio-button name="[[getName_(
          prefValuesEnum_.CONTINUE_AND_OPEN_SPECIFIC)]]"
            pref="[[prefs.session.restore_on_startup]]"
            label="$i18n{onStartupContinueAndOpenSpecific}"
            hidden="[[!showContinueAndOpenSpecific_(
              prefs.session.restore_on_startup)]]">
        </controlled-radio-button>
      </settings-radio-group>
    </div>
    <template is="dom-if"
        if="[[showStartupUrls_(prefs.session.restore_on_startup.value)]]">
      <settings-startup-urls-page prefs="[[prefs]]">
      </settings-startup-urls-page>
    </template>
  </settings-section>
<!--_html_template_end_-->`;
}