import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_-->    <style include="settings-shared">cr-link-row{--cr-icon-button-margin-start:20px}cr-link-row:not([hidden])~cr-link-row{border-top:var(--cr-separator-line)}
    </style>
    <settings-section page-title="$i18n{autofillPageTitle}">
      <div route-path="default">
        <cr-link-row id="passwordManagerButton"
            label="$i18n{localPasswordManager}" on-click="onPasswordsClick_"
            role-description="$i18n{subpageArrowRoleDescription}"
            start-icon="cr20:password" external>
        </cr-link-row>
        <cr-link-row id="paymentManagerButton"
            start-icon="settings20:credit-card" label="$i18n{creditCards}"
            on-click="onPaymentsClick_"
            role-description="$i18n{subpageArrowRoleDescription}"></cr-link-row>
        <cr-link-row id="addressesManagerButton"
            start-icon="settings:location-on" label="$i18n{addressesTitle}"
            sub-label="[[addressesSublabel_()]]"
            on-click="onAddressesClick_"
            role-description="$i18n{subpageArrowRoleDescription}"></cr-link-row>
        <template is="dom-if" if="[[autofillAiAvailable_]]">
          <cr-link-row id="autofillAiManagerButton"
              start-icon="settings20:text-analysis"
              label="$i18n{autofillAiPageTitle}"
              sub-label="$i18n{autofillAiDescription}"
              on-click="onAutofillAiClick_"></cr-link-row>
        </template>
      </div>
    </settings-section>
<!--_html_template_end_-->`;
}