// Copyright 2015 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{p as PrefControlMixin,a7 as ModelExecutionEnterprisePolicyValue,S as SettingsViewMixin,P as PrefsMixin,a5 as AiEnterpriseFeaturePrefName,M as MetricsBrowserProxyImpl,aY as AiPageCompareInteractions,j as AiPageActions,O as OpenWindowProxyImpl,a$ as AiPageTabOrganizationInteractions,F as FeatureOptInState,a_ as AiPageHistorySearchInteractions,e as I18nMixin,L as ListPropertyUpdateMixin,aZ as AiPageComposeInteractions,c as getCss$b,bs as EventTracker,d as assert,bt as CrRippleMixin,o as CrPolicyPrefMixin,a6 as EntityDataManagerProxyImpl,bu as getCss$c,g as getCss$d,bv as CountryDetailManagerProxyImpl,s as sanitizeInnerHtml,a9 as AutofillManagerImpl,y as focusWithoutInk,ah as getInstance,a as assertNotReached,bw as AnchorAlignment,a8 as PaymentsManagerImpl,b0 as CardBenefitsUserAction,b3 as PrivacyElementInteractions,b1 as CvcDeletionUserAction,G as SignedInState,K as StatusAction,W as WebUiListenerMixin,D as SyncBrowserProxyImpl,bx as SettingsBooleanControlMixin,n as RouteObserverMixin,by as TimePeriod,B as ChromeSigninAccessPoint,bz as ClearBrowsingDataBrowserProxyImpl,ai as FocusOutlineManager,r as routes,h as Router,bA as assertNotReachedCase,u as PasswordManagerImpl,v as PasswordManagerPage,bB as BrowsingDataType,k as CrSettingsPrefs,bC as SiteSettingsBrowserProxyImpl,bD as SiteSettingSource,bE as CookiesExceptionType,bF as ContentSettingsTypes,bG as ContentSetting,bH as SITE_EXCEPTION_WILDCARD,w as FocusRowMixin,N as BaseMixin,bI as ChooserType,T as TooltipMixin,bJ as INVALID_CATEGORY_SUBTYPE,_ as CookieControlsMode,bK as ThirdPartyCookieBlockingSetting,aM as getTrustedHTML,aL as PluralStringProxyImpl,bh as SafeBrowsingSetting,Y as HatsBrowserProxyImpl,bf as SecurityPageV2Interaction,aB as PrivacyPageBrowserProxyImpl,aC as SecureDnsMode,aD as SecureDnsUiManagementMode,H as HelpBubbleMixin,b6 as SafeBrowsingInteractions,bi as PrivacySandboxBrowserProxyImpl,bL as CardState,bM as SafetyHubEvent,bN as SafetyHubBrowserProxyImpl,b7 as SafetyCheckNotificationsModuleInteractions,bO as isUndoKeyboardEvent,bP as PermissionsRevocationType,b8 as SafetyCheckUnusedSitePermissionsModuleInteractions,R as RelaunchMixin,bc as SafetyHubSurfaces,f as RestartType,bb as SafetyHubModuleType,a3 as SearchEnginesBrowserProxyImpl,a4 as ChoiceMadeLocation,ar as ExtensionControlBrowserProxyImpl,bQ as GlobalScrollTargetMixin,bm as SearchEnginesInteractions,bR as DefaultSettingSource,bS as AllSitesAction2,bT as SortMethod,b2 as DeleteBrowsingDataAction,bU as AllSitesDialog,bV as SettingsState,ba as SafetyHubEntryPoint,bW as JavascriptOptimizerSetting,$ as PromiseResolver,aV as convertLanguageCodeForTranslate,aU as convertLanguageCodeForChrome,aW as getBaseLanguage,aX as isTranslateBaseLanguage,x as ScrollableMixin,ak as FindShortcutMixin,bX as getFullName,ax as UserSelectableType,av as syncPrefsIndividualDataTypes,E as ProfileInfoBrowserProxyImpl,at as ChromeSigninUserChoice,q as pageVisibility,b as getCss$e,I as I18nMixinLit,bY as hasKeyModifiers,J as getImage,au as PageStatus,m as SearchableViewContainerMixin,z as getSearchManager,bZ as isWindows,a2 as ResetBrowserProxyImpl,ac as EntityTypeName}from"./shared.rollup.js";export{aF as CrButtonElement,b$ as CrCheckboxElement,c0 as CrCollapseElement,aG as CrDialogElement,c1 as CrExpandButtonElement,c2 as CrIconButtonElement,c3 as CrInputElement,c4 as CrLazyRenderElement,b_ as CrShortcutInputElement,c5 as CrToastElement,c6 as CrTooltipElement,U as NetworkPredictionOptions,cb as PrivacyGuideAdTopicsFragmentElement,cc as PrivacyGuideCompletionFragmentElement,cd as PrivacyGuideCookiesFragmentElement,cf as PrivacyGuideHistorySyncFragmentElement,cg as PrivacyGuideMsbbFragmentElement,ci as PrivacyGuideSafeBrowsingFragmentElement,ca as PrivacyGuideStep,cj as PrivacyGuideWelcomeFragmentElement,i as SettingsAiPageFeaturePrefName,c7 as SettingsAutofillAiAddOrEditDialogElement,aR as SettingsAutofillAiEntriesListElement,c8 as SettingsCollapseRadioButtonElement,ce as SettingsPrivacyGuideDialogElement,ch as SettingsPrivacyGuidePageElement,c9 as SettingsRadioGroupElement,ck as SettingsSafetyHubEntryPointElement,cl as SettingsSafetyHubModuleElement,cm as SettingsSimpleConfirmationDialogElement,aP as SettingsToggleButtonElement}from"./shared.rollup.js";import{html,PolymerElement,microTask,flush,afterNextRender,dedupingMixin}from"chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js";import{loadTimeData}from"chrome://resources/js/load_time_data.js";import"chrome://settings/strings.m.js";import{css,html as html$1,CrLitElement,nothing}from"chrome://resources/lit/v3_0/lit.rollup.js";import{sendWithPromise}from"chrome://resources/js/cr.js";import{mojo}from"chrome://resources/mojo/mojo/public/js/bindings.js";import{SkColorSpec}from"chrome://resources/mojo/skia/public/mojom/skcolor.mojom-webui.js";function getTemplate$2p(){return html`<!--_html_template_start_--><style include="settings-shared">.cr-row{--cr-section-min-height:0;padding-top:2px;padding-bottom:16px}cr-policy-pref-indicator{margin-inline-end:var(--cr-icon-button-margin-start)}</style>

<template is="dom-if" if="[[isFeatureDisabledByPolicy_(pref)]]" restamp>
  <div class="cr-row first" id="aiPolicyIndicator">
    <cr-policy-pref-indicator pref="[[pref]]"></cr-policy-pref-indicator>
    $i18n{aiSubpageFeatureManagedDisabledLabel}
  </div>
</template><!--_html_template_end_-->`}function isFeatureDisabledByPolicy(enterprisePref){return!!enterprisePref&&enterprisePref.value===ModelExecutionEnterprisePolicyValue.DISABLE}const SettingsAiPolicyIndicatorBase=PrefControlMixin(PolymerElement);class SettingsAiPolicyIndicator extends SettingsAiPolicyIndicatorBase{static get is(){return"settings-ai-policy-indicator"}static get template(){return getTemplate$2p()}isFeatureDisabledByPolicy_(){return isFeatureDisabledByPolicy(this.pref)}}customElements.define(SettingsAiPolicyIndicator.is,SettingsAiPolicyIndicator);function getTemplate$2o(){return html`<!--_html_template_start_--><style include="settings-shared settings-columned-section">cr-icon{flex-shrink:0}</style>

<settings-subpage page-title="$i18n{aiCompareLabel}"
    route-path$="[[routePath]]">
<settings-ai-policy-indicator pref="[[enterprisePref_]]">
</settings-ai-policy-indicator>
<template is="dom-if" if="[[!isDisabled_(enterprisePref_)]]" restamp>
  <cr-link-row label="$i18n{aiCompareLabel}"
      on-click="onCompareLinkoutClick_" external>
    <div slot="sub-label">
      $i18n{aiCompareSublabel}$i18n{sentenceEnd}
      <a href="[[getLearnMoreUrl_(enterprisePref_)]]"
          aria-label="$i18n{aiCompareLearnMoreA11yLabel}"
          aria-description="$i18n{opensInNewTab}"
          on-click="onLearnMoreClick_" target="_blank">
        $i18n{learnMore}
      </a>
    </div>
  </cr-link-row>
</template>
<template is="dom-if" if="[[isDisabled_(enterprisePref_)]]" restamp>
  <div class="cr-row first">
    <div class="flex cr-padded-text">
      <div>$i18n{aiCompareLabel}</div>
      <div class="secondary">
        $i18n{aiCompareSublabel}$i18n{sentenceEnd}
        <a href="[[getLearnMoreUrl_(enterprisePref_)]]"
            aria-label="$i18n{aiCompareLearnMoreA11yLabel}"
            aria-description="$i18n{opensInNewTab}"
            on-click="onLearnMoreClick_" target="_blank">
          $i18n{learnMore}
        </a>
      </div>
    </div>
  </div>
</template>
<div class="settings-columned-section">
  <div class="column">
    <h2 class="description-header">$i18n{columnHeadingWhenUsed}</h2>
    <ul class="icon-bulleted-list">
      <li>
        <cr-icon icon="settings20:table-chart-organize" aria-hidden="true">
        </cr-icon>
        <div class="secondary">$i18n{aiCompareWhenOnProductDetails}</div>
      </li>
      <li>
        <cr-icon icon="settings20:text-compare" aria-hidden="true">
        </cr-icon>
        <div class="secondary">$i18n{aiCompareWhenOnProductSuggest}</div>
      </li>
      <li>
        <cr-icon icon="settings20:filter-list" aria-hidden="true">
        </cr-icon>
        <div class="secondary">$i18n{aiCompareWhenOnProductFilter}</div>
      </li>
      <li>
        <cr-icon icon="settings20:reviews" aria-hidden="true">
        </cr-icon>
        <div class="secondary">$i18n{aiCompareWhenOnProductReviews}</div>
      </li>
    </ul>
  </div>
  <div class="column">
    <h2 class="description-header">$i18n{columnHeadingConsider}</h2>
    <ul class="icon-bulleted-list">
      <li>
        <cr-icon icon="settings20:psychiatry" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{aiSubpageSublabelAi}</div>
      </li>
      <li>
        <cr-icon icon="settings20:googleg" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{aiCompareConsiderData}</div>
      </li>
      <settings-ai-logging-info-bullet pref="[[enterprisePref_]]">
      </settings-ai-logging-info-bullet>
      <li>
        <cr-icon icon="settings20:account-circle" aria-hidden="true">
        </cr-icon>
        <div class="secondary">$i18n{aiCompareConsiderTablesInAccount}</div>
      </li>
    </ul>
  </div>
</div>
</settings-subpage>
<!--_html_template_end_-->`}function getAiLearnMoreUrl(enterprisePref,learnMoreUrl,learnMoreEnterpriseUrl){return enterprisePref.value===ModelExecutionEnterprisePolicyValue.ALLOW_WITHOUT_LOGGING?learnMoreEnterpriseUrl:learnMoreUrl}const SettingsAiCompareSubpageElementBase=SettingsViewMixin(PrefsMixin(PolymerElement));class SettingsAiCompareSubpageElement extends SettingsAiCompareSubpageElementBase{static get is(){return"settings-ai-compare-subpage"}static get template(){return getTemplate$2o()}static get properties(){return{enterprisePref_:{type:Object,computed:`computePref(prefs.${AiEnterpriseFeaturePrefName.COMPARE})`}}}metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();recordInteractionMetrics_(interaction,action){this.metricsBrowserProxy_.recordAiPageCompareInteractions(interaction);this.metricsBrowserProxy_.recordAction(action)}onCompareLinkoutClick_(){if(this.isDisabled_()){return}this.recordInteractionMetrics_(AiPageCompareInteractions.FEATURE_LINK_CLICKED,AiPageActions.COMPARE_FEATURE_LINK_CLICKED);OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("compareDataHomeUrl"))}onLearnMoreClick_(event){event.stopPropagation();this.recordInteractionMetrics_(AiPageCompareInteractions.LEARN_MORE_LINK_CLICKED,AiPageActions.COMPARE_LEARN_MORE_CLICKED)}getLearnMoreUrl_(){return getAiLearnMoreUrl(this.enterprisePref_,loadTimeData.getString("compareLearnMoreUrl"),loadTimeData.getString("compareLearnMoreManagedUrl"))}isDisabled_(){return isFeatureDisabledByPolicy(this.enterprisePref_)}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsAiCompareSubpageElement.is,SettingsAiCompareSubpageElement);function getTemplate$2n(){return html`<!--_html_template_start_--><style include="settings-shared settings-columned-section">cr-icon{flex-shrink:0}</style>

<settings-subpage page-title="$i18n{tabOrganizationSettingLabel}"
    route-path$="[[routePath]]">
<settings-ai-policy-indicator pref="[[enterprisePref_]]">
</settings-ai-policy-indicator>
<div class="cr-row first">
  <div class="flex cr-padded-text">
    <div id="tabOrganizationLabel">$i18n{tabOrganizationSettingLabel}</div>
    <div class="secondary">
      $i18n{tabOrganizationSettingSublabelV2}$i18n{sentenceEnd}
      <a href="[[getLearnMoreUrl_(enterprisePref_)]]"
          aria-label="$i18n{tabOrganizationSettingLearnMoreA11y}"
          aria-description="$i18n{opensInNewTab}"
          on-click="onLearnMoreClick_" target="_blank">
        $i18n{learnMore}
      </a>
    </div>
  </div>
</div>
<div class="settings-columned-section">
  <div class="column">
    <h2 class="description-header">$i18n{columnHeadingWhenUsed}</h2>
    <ul class="icon-bulleted-list">
      <li>
        <cr-icon icon="settings20:auto-tab-group" aria-hidden="true"></cr-icon>
        <div class="secondary">
          $i18n{tabOrganizationSettingWhenOnAutoGroups}
        </div>
      </li>
      <li>
        <cr-icon icon="settings20:tab" aria-hidden="true"></cr-icon>
        <div class="secondary">
          $i18n{tabOrganizationSettingWhenOnImproveFocus}
        </div>
      </li>
    </ul>
  </div>
  <div class="column">
    <h2 class="description-header">$i18n{columnHeadingConsider}</h2>
    <ul class="icon-bulleted-list">
      <li>
        <cr-icon icon="settings20:psychiatry" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{aiSubpageSublabelAi}</div>
      </li>
      <li>
        <cr-icon icon="settings20:googleg" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{tabOrganizationSettingConsiderData}</div>
      </li>
      <settings-ai-logging-info-bullet pref="[[enterprisePref_]]">
      </settings-ai-logging-info-bullet>
    </ul>
  </div>
</div>
</settings-subpage>
<!--_html_template_end_-->`}const SettingsAiTabOrganizationSubpageElementBase=SettingsViewMixin(PrefsMixin(PolymerElement));class SettingsAiTabOrganizationSubpageElement extends SettingsAiTabOrganizationSubpageElementBase{static get is(){return"settings-ai-tab-organization-subpage"}static get template(){return getTemplate$2n()}static get properties(){return{enterprisePref_:{type:Object,computed:`computePref(prefs.${AiEnterpriseFeaturePrefName.TAB_ORGANIZATION})`}}}metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();recordInteractionMetrics_(interaction,action){this.metricsBrowserProxy_.recordAiPageTabOrganizationInteractions(interaction);this.metricsBrowserProxy_.recordAction(action)}onLearnMoreClick_(){this.recordInteractionMetrics_(AiPageTabOrganizationInteractions.LEARN_MORE_LINK_CLICKED,AiPageActions.TAB_ORGANIZATION_LEARN_MORE_CLICKED)}getLearnMoreUrl_(){return getAiLearnMoreUrl(this.enterprisePref_,loadTimeData.getString("tabOrganizationLearnMoreUrl"),loadTimeData.getString("tabOrganizationLearnMoreManagedUrl"))}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsAiTabOrganizationSubpageElement.is,SettingsAiTabOrganizationSubpageElement);function getTemplate$2m(){return html`<!--_html_template_start_--><style include="settings-shared settings-columned-section">.separator{margin:0 4px}.separator+settings-toggle-button{margin-inline-end:12px}cr-icon{flex-shrink:0}cr-policy-pref-indicator{margin-inline-end:4px}</style>

<settings-subpage page-title="$i18n{historySearchSettingLabel}"
    route-path$="[[routePath]]">
<div class="settings-row first">
  <template is="dom-if" if="[[!isDisabledByPolicy_(enterprisePref_)]]"
      restamp>
    <cr-link-row label="$i18n{historySearchSettingLabel}"
        on-click="onHistorySearchLinkoutClick_" external>
      <div slot="sub-label">
        <span id="linkoutText">[[toggleSubLabelV2_]]</span>
        <a href="[[getLearnMoreUrl_(enterprisePref_)]]"
            aria-label="$i18n{historySearchLearnMoreA11yLabel}"
            aria-description="$i18n{opensInNewTab}"
            on-click="onLearnMoreClick_" target="_blank">
          $i18n{learnMore}
        </a>
      </div>
    </cr-link-row>
    <div class="separator"></div>
  </template>
  <template is="dom-if" if="[[isDisabledByPolicy_(enterprisePref_)]]" restamp>
    <div class="cr-row first">
      <div class="flex cr-padded-text">
        <div id="historySearchLabel">$i18n{historySearchSettingLabel}</div>
        <div class="secondary">
          [[toggleSubLabelV2_]]
          <a href="[[getLearnMoreUrl_(enterprisePref_)]]"
              aria-label="$i18n{historySearchLearnMoreA11yLabel}"
              aria-description="$i18n{opensInNewTab}"
              on-click="onLearnMoreClick_" target="_blank">
            $i18n{learnMore}
          </a>
        </div>
      </div>
    </div>
    <cr-policy-pref-indicator id="policyIndicator"
          pref="[[enterprisePref_]]">
    </cr-policy-pref-indicator>
  </template>
  <settings-toggle-button aria-label="$i18n{historySearchSettingLabel}"
      learn-more-url="[[getLearnMoreUrl_(enterprisePref_)]]"
      learn-more-aria-label="$i18n{historySearchLearnMoreA11yLabel}"
      pref="{{prefs.optimization_guide.history_search_setting_state}}"
      numeric-unchecked-values="[[numericUncheckedValues_]]"
      numeric-checked-value="[[featureOptInStateEnum_.ENABLED]]"
      on-settings-boolean-control-change="onHistorySearchToggleChange_"
      disabled="[[isDisabledByPolicy_(enterprisePref_)]]">
  </settings-toggle-button>
</div>
<div class="settings-columned-section">
  <div class="column">
    <h2 class="description-header">$i18n{columnHeadingWhenOn}</h2>
    <ul class="icon-bulleted-list">
      <li>
        <cr-icon icon="settings20:search-spark" aria-hidden="true"></cr-icon>
        <div id="whenOnPageContentText" class="secondary"
            hidden="[[isAnswersFeatureEnabled_]]">
          $i18n{historySearchWhenOnPageContent}
        </div>
        <div id="whenOnPageContentTextWithAnswers" class="secondary"
            hidden="[[!isAnswersFeatureEnabled_]]">
          $i18n{historySearchWithAnswersWhenOnPageContent}
        </div>
      </li>
      <li id="whenOnRecallInfoWithAnswers"
          hidden="[[!isAnswersFeatureEnabled_]]">
        <cr-icon icon="settings20:auto-summarize" aria-hidden="true">
        </cr-icon>
        <div class="secondary">
          $i18n{historySearchWithAnswersWhenOnRecallInfo}
        </div>
      </li>
      <li>
        <cr-icon icon="settings20:quick-reference-all" aria-hidden="true">
        </cr-icon>
        <div class="secondary">$i18n{historySearchWhenOnSearchFrom}</div>
      </li>
      <li id="whenOnLogStartItem">
        <cr-icon icon="settings20:history" aria-hidden="true">
        </cr-icon>
        <div class="secondary">
          $i18n{historySearchWhenOnLogStart}
        </div>
      </li>
    </ul>
  </div>
  <div class="column">
    <h2 class="description-header">$i18n{columnHeadingConsider}</h2>
    <ul class="icon-bulleted-list">
      <li>
        <cr-icon icon="settings20:psychiatry" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{aiSubpageSublabelAi}</div>
      </li>
      <li>
        <cr-icon icon="settings20:googleg" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{historySearchConsiderData}</div>
      </li>
      <settings-ai-logging-info-bullet pref="[[enterprisePref_]]">
      </settings-ai-logging-info-bullet>
      <li>
        <cr-icon icon="settings20:file-save" aria-hidden="true"></cr-icon>
        <div id="considerDataEncryptedText" class="secondary"
            hidden="[[isAnswersFeatureEnabled_]]">
          $i18n{historySearchConsiderDataEncrypted}
        </div>
        <div id="considerDataEncryptedTextWithAnswers" class="secondary"
            hidden="[[!isAnswersFeatureEnabled_]]">
          $i18n{historySearchWithAnswersConsiderDataEncrypted}
        </div>
      </li>
      <li id="considerOutDatedItem" hidden="[[!isAnswersFeatureEnabled_]]">
        <cr-icon icon="settings20:difference" aria-hidden="true"></cr-icon>
        <div class="secondary">
          $i18n{historySearchWithAnswersConsiderOutdated}
        </div>
      </li>
    </ul>
  </div>
</div>
</settings-subpage>
<!--_html_template_end_-->`}const SettingsHistorySearchPageElementBase=SettingsViewMixin(PrefsMixin(PolymerElement));class SettingsHistorySearchPageElement extends SettingsHistorySearchPageElementBase{static get is(){return"settings-history-search-page"}static get template(){return getTemplate$2m()}static get properties(){return{featureOptInStateEnum_:{type:Object,value:FeatureOptInState},isAnswersFeatureEnabled_:{type:Boolean,value:()=>loadTimeData.getBoolean("historyEmbeddingsAnswersFeatureEnabled")},numericUncheckedValues_:{type:Array,value:()=>[FeatureOptInState.DISABLED,FeatureOptInState.NOT_INITIALIZED]},toggleSubLabelV2_:{type:String,value:()=>(loadTimeData.getBoolean("historyEmbeddingsAnswersFeatureEnabled")?loadTimeData.getString("historySearchWithAnswersSettingSublabelV2"):loadTimeData.getString("historySearchSettingSublabelV2"))+loadTimeData.getString("sentenceEnd")+" "},enterprisePref_:{type:Object,computed:`computePref(prefs.${AiEnterpriseFeaturePrefName.HISTORY_SEARCH})`}}}metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();recordInteractionMetrics_(interaction,action){this.metricsBrowserProxy_.recordAiPageHistorySearchInteractions(interaction);this.metricsBrowserProxy_.recordAction(action)}onHistorySearchLinkoutClick_(){this.recordInteractionMetrics_(AiPageHistorySearchInteractions.FEATURE_LINK_CLICKED,AiPageActions.HISTORY_SEARCH_FEATURE_LINK_CLICKED);OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("historySearchDataHomeUrl"))}onLearnMoreClick_(event){event.stopPropagation();this.recordInteractionMetrics_(AiPageHistorySearchInteractions.LEARN_MORE_LINK_CLICKED,AiPageActions.HISTORY_SEARCH_LEARN_MORE_CLICKED)}onHistorySearchToggleChange_(e){const toggle=e.target;if(toggle.checked){this.recordInteractionMetrics_(AiPageHistorySearchInteractions.HISTORY_SEARCH_ENABLED,AiPageActions.HISTORY_SEARCH_ENABLED);return}this.recordInteractionMetrics_(AiPageHistorySearchInteractions.HISTORY_SEARCH_DISABLED,AiPageActions.HISTORY_SEARCH_DISABLED)}getLearnMoreUrl_(){return getAiLearnMoreUrl(this.enterprisePref_,loadTimeData.getString("historySearchLearnMoreUrl"),loadTimeData.getString("historySearchLearnMoreManagedUrl"))}isDisabledByPolicy_(){return isFeatureDisabledByPolicy(this.enterprisePref_)}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsHistorySearchPageElement.is,SettingsHistorySearchPageElement);function getTemplate$2l(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared settings-columned-section">.cr-row{border-top:none}.list-frame{padding-inline-start:var(--cr-section-indent-width)}#disabledSitesList{display:flex;flex-direction:column}#disabledSitesList>div:not(:first-child){border-top:var(--cr-separator-line)}cr-icon{flex-shrink:0}settings-toggle-button.hr{padding-top:16px}</style>

<settings-subpage page-title="$i18n{aiComposeLabel}"
    route-path$="[[routePath]]">
<settings-ai-policy-indicator pref="[[enterprisePref_]]">
</settings-ai-policy-indicator>
<div class="cr-row first">
  <div class="flex cr-padded-text">
    <div id="helpMeWriteLabel">$i18n{aiComposeLabel}</div>
    <div class="secondary">
      $i18n{aiComposeSublabelV2}$i18n{sentenceEnd}
      <a href="[[getLearnMoreUrl_(enterprisePref_)]]"
          aria-label="$i18n{aiComposeSettingLearnMoreA11y}"
          aria-description="$i18n{opensInNewTab}"
          on-click="onLearnMoreClick_" target="_blank">
        $i18n{learnMore}
      </a>
    </div>
  </div>
</div>
<div class="settings-columned-section">
  <div class="column">
    <h2 class="description-header">$i18n{columnHeadingWhenUsed}</h2>
    <ul class="icon-bulleted-list">
      <li>
        <cr-icon icon="settings20:pen-spark" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{aiComposeWhenOnWritingHelp}</div>
      </li>
      <li>
        <cr-icon icon="settings20:summarize" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{aiComposeWhenOnWritingExamples}</div>
      </li>
      <li>
        <cr-icon icon="settings20:text-analysis" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{aiComposeWhenOnWritingReferences}</div>
      </li>
    </ul>
  </div>
  <div class="column">
    <h2 class="description-header">$i18n{columnHeadingConsider}</h2>
    <ul class="icon-bulleted-list">
      <li>
        <cr-icon icon="settings20:psychiatry" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{aiSubpageSublabelAi}</div>
      </li>
      <li>
        <cr-icon icon="settings20:googleg" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{aiComposeComposeConsiderData}</div>
      </li>
      <settings-ai-logging-info-bullet pref="[[enterprisePref_]]">
      </settings-ai-logging-info-bullet>
    </ul>
  </div>
</div>

<template is="dom-if" if="[[enableComposeProactiveNudge_]]" restamp>
  <settings-toggle-button class="hr"
      pref="{{prefs.compose.proactive_nudge_enabled}}"
      label="$i18n{offerWritingHelpToggleLabel}"
      sub-label="$i18n{offerWritingHelpToggleSublabel}"
      on-settings-boolean-control-change="onComposeProactiveNudgeToggleChange_">
  </settings-toggle-button>
  <div class="cr-row">
    <div id="disabledSitesHeading" class="flex">
      $i18n{offerWritingHelpDisabledSitesLabelV2}
    </div>
  </div>
  <div id="noDisabledSitesLabel" class="list-frame"
      hidden$="[[hasSites_(siteList_.*)]]">
    <div class="list-item secondary">
      $i18n{offerWritingHelpNoDisabledSites}
    </div>
  </div>
  <div id="disabledSitesList" class="list-frame" role="list">
    <template is="dom-repeat" items="[[siteList_]]">
      <div class="list-item" role="listitem">
        <div class="start cr-padded-text">[[item]]</div>
        <cr-icon-button
            class="icon-delete-gray"
            aria-label="[[i18n('offerWritingHelpRemoveDisabledSiteAriaLabel',
                          item)]]"
            on-click="onDeleteClick_"
            title="$i18n{delete}">
        </cr-icon-button>
      </div>
    </template>
  </div>
</template>
</settings-subpage>
<!--_html_template_end_-->`}const COMPOSE_PROACTIVE_NUDGE_PREF="compose.proactive_nudge_enabled";const COMPOSE_PROACTIVE_NUDGE_DISABLED_SITES_PREF="compose.proactive_nudge_disabled_sites_with_time";const SettingsOfferWritingHelpPageElementBase=SettingsViewMixin(I18nMixin(ListPropertyUpdateMixin(PrefsMixin(PolymerElement))));class SettingsOfferWritingHelpPageElement extends SettingsOfferWritingHelpPageElementBase{static get is(){return"settings-offer-writing-help-page"}static get template(){return getTemplate$2l()}static get properties(){return{siteList_:{type:Array,value:()=>[]},enableComposeProactiveNudge_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableComposeProactiveNudge")},enterprisePref_:{type:Object,computed:`computePref(prefs.${AiEnterpriseFeaturePrefName.COMPOSE})`}}}static get observers(){return[`onPrefsChanged_(\n        prefs.${COMPOSE_PROACTIVE_NUDGE_DISABLED_SITES_PREF}.value.*)`]}metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();recordInteractionMetrics_(interaction,action){this.metricsBrowserProxy_.recordAiPageComposeInteractions(interaction);this.metricsBrowserProxy_.recordAction(action)}onLearnMoreClick_(){this.recordInteractionMetrics_(AiPageComposeInteractions.LEARN_MORE_LINK_CLICKED,AiPageActions.COMPOSE_LEARN_MORE_CLICKED)}onComposeProactiveNudgeToggleChange_(e){const toggle=e.target;if(toggle.checked){this.recordInteractionMetrics_(AiPageComposeInteractions.COMPOSE_PROACTIVE_NUDGE_ENABLED,AiPageActions.COMPOSE_PROACTIVE_NUDGE_ENABLED);return}this.recordInteractionMetrics_(AiPageComposeInteractions.COMPOSE_PROACTIVE_NUDGE_DISABLED,AiPageActions.COMPOSE_PROACTIVE_NUDGE_DISABLED)}hasSites_(){return this.siteList_.length>0}onDeleteClick_(e){this.deletePrefDictEntry(COMPOSE_PROACTIVE_NUDGE_DISABLED_SITES_PREF,e.model.item)}onPrefsChanged_(){const prefDict=this.getPref(COMPOSE_PROACTIVE_NUDGE_DISABLED_SITES_PREF).value;const newSites=Object.keys(prefDict);this.updateList("siteList_",(entry=>entry),newSites)}getLearnMoreUrl_(){return getAiLearnMoreUrl(this.enterprisePref_,loadTimeData.getString("composeLearnMorePageURL"),loadTimeData.getString("composeLearnMorePageManagedURL"))}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsOfferWritingHelpPageElement.is,SettingsOfferWritingHelpPageElement);let instance$o=null;function getCss$a(){return instance$o||(instance$o=[...[getCss$b()],css`:host{--cr-slider-active-color:var(--google-blue-600);--cr-slider-container-color:rgba(var(--google-blue-600-rgb),.24);--cr-slider-container-disabled-color:rgba(var(--google-grey-600-rgb),.24);--cr-slider-disabled-color:var(--google-grey-600);--cr-slider-knob-color-rgb:var(--google-blue-600-rgb);--cr-slider-knob-disabled-color:white;--cr-slider-marker-active-color:rgba(255,255,255,.54);--cr-slider-marker-color:rgba(26,115,232,.54);--cr-slider-marker-disabled-color:rgba(128,134,139,.54);--cr-slider-position-transition:80ms ease;--cr-slider-ripple-color:rgba(var(--cr-slider-knob-color-rgb),.25);-webkit-tap-highlight-color:rgba(0,0,0,0);cursor:default;height:32px;isolation:isolate;outline:none;padding:0 16px;user-select:none}@media (prefers-color-scheme:dark){:host{--cr-slider-active-color:var(--google-blue-300);--cr-slider-container-color:rgba(var(--google-blue-500-rgb),.48);--cr-slider-container-disabled-color:rgba(var(--google-grey-600-rgb),.48);--cr-slider-knob-color-rgb:var(--google-blue-300-rgb);--cr-slider-knob-disabled-color:var(--google-grey-900-white-4-percent);--cr-slider-marker-active-color:var(--google-blue-300);--cr-slider-marker-color:var(--google-blue-300);--cr-slider-marker-disabled-color:rgba(255,255,255,.54);--cr-slider-ripple-color:rgba(var(--cr-slider-knob-color-rgb),.4)}}:host,:host>#container{touch-action:none}#container,#bar{border-top-style:solid;border-top-width:2px}#container{border-top-color:var(--cr-slider-container-color);position:relative;top:16px}#container>div{position:absolute}#markers,#bar{top:-2px}#markers{display:flex;flex-direction:row;left:0;pointer-events:none;right:0}.active-marker,.inactive-marker{flex:1}#markers::before,#markers::after,.active-marker::after,.inactive-marker::after{border-radius:50%;content:'';display:block;height:2px;margin-inline-start:-1px;width:2px}#markers::before,.active-marker::after{background-color:var(--cr-slider-marker-active-color)}#markers::after,.inactive-marker::after{background-color:var(--cr-slider-marker-color)}#bar{border-top-color:var(--cr-slider-active-color)}:host([transiting_]) #bar{transition:width var(--cr-slider-position-transition)}#knobAndLabel{top:-1px}:host([transiting_]) #knobAndLabel{transition:margin-inline-start var(--cr-slider-position-transition)}#knob{background-color:rgb(var(--cr-slider-knob-color-rgb));border-radius:50%;box-shadow:0 1px 3px 0 rgba(0,0,0,.4);height:10px;outline:none;position:relative;transform:translate(-50%,-50%);width:10px}:host-context([dir=rtl]) #knob{transform:translate(50%,-50%)}#label{background:rgb(var(--cr-slider-knob-color-rgb));border-radius:.75em;bottom:22px;color:white;font-size:12px;line-height:1.5em;opacity:0;outline:1px transparent solid;padding:0 .67em;position:absolute;transform:translateX(-50%);transition:opacity 80ms ease-in-out;white-space:nowrap}:host-context([dir=rtl]) #label{transform:translateX(50%)}:host(:hover) #label,:host([show-label_]) #label{opacity:1}#ink{--paper-ripple-opacity:var(--cr-slider-ripple-opacity,1);color:var(--cr-slider-ripple-color);height:var(--cr-slider-ripple-size,32px);pointer-events:none;transition:color linear 80ms;transform:translate(-50%,-50%);top:50%;left:50%;width:var(--cr-slider-ripple-size,32px);z-index:var(--cr-slider-ripple-z-index,auto)}:host-context([dir=rtl]) #ink{left:auto;right:50%;transform:translate(50%,-50%)}:host([disabled_]){pointer-events:none}:host([disabled_]) #container{border-top-color:var(--cr-slider-container-disabled-color)}:host([disabled_]) #bar{border-top-color:var(--cr-slider-disabled-color)}:host([disabled_]) .inactive-marker::after,:host([disabled_]) #markers::after{background-color:var(--cr-slider-marker-disabled-color)}:host([disabled_]) #knob{background-color:var(--cr-slider-disabled-color);border:2px solid var(--cr-slider-knob-disabled-color);box-shadow:unset}`])}function getHtml$a(){return html$1`
<div id="container" part="container">
  <div id="bar"></div>
  <div id="markers" ?hidden="${!this.markerCount}">
    ${this.getMarkers_().map(((_item,index)=>html$1`
      <div class="${this.getMarkerClass_(index)}"></div>
    `))}
  </div>
  <div id="knobAndLabel" @transitionend="${this.onTransitionEnd_}">
    <div id="knob" part="knob"></div>
    <div id="label" part="label">${this.label_}</div>
  </div>
</div>`}function clamp(min,max,value){return Math.min(max,Math.max(min,value))}function getAriaValue(tick){if(Number.isFinite(tick)){return tick}const sliderTick=tick;return sliderTick.ariaValue!==undefined?sliderTick.ariaValue:sliderTick.value}const CrSliderElementBase=CrRippleMixin(CrLitElement);class CrSliderElement extends CrSliderElementBase{static get is(){return"cr-slider"}static get styles(){return getCss$a()}render(){return getHtml$a.bind(this)()}static get properties(){return{disabled:{type:Boolean},disabled_:{type:Boolean,reflect:true},dragging:{type:Boolean,notify:true},updatingFromKey:{type:Boolean,notify:true},keyPressSliderIncrement:{type:Number},markerCount:{type:Number},max:{type:Number},min:{type:Number},noKeybindings:{type:Boolean},snaps:{type:Boolean},ticks:{type:Array},value:{type:Number},label_:{type:String,state:true},showLabel_:{type:Boolean,reflect:true},transiting_:{type:Boolean,reflect:true}}}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#dragging_accessor_storage=false;get dragging(){return this.#dragging_accessor_storage}set dragging(value){this.#dragging_accessor_storage=value}#updatingFromKey_accessor_storage=false;get updatingFromKey(){return this.#updatingFromKey_accessor_storage}set updatingFromKey(value){this.#updatingFromKey_accessor_storage=value}#keyPressSliderIncrement_accessor_storage=1;get keyPressSliderIncrement(){return this.#keyPressSliderIncrement_accessor_storage}set keyPressSliderIncrement(value){this.#keyPressSliderIncrement_accessor_storage=value}#markerCount_accessor_storage=0;get markerCount(){return this.#markerCount_accessor_storage}set markerCount(value){this.#markerCount_accessor_storage=value}#max_accessor_storage=100;get max(){return this.#max_accessor_storage}set max(value){this.#max_accessor_storage=value}#min_accessor_storage=0;get min(){return this.#min_accessor_storage}set min(value){this.#min_accessor_storage=value}#noKeybindings_accessor_storage=false;get noKeybindings(){return this.#noKeybindings_accessor_storage}set noKeybindings(value){this.#noKeybindings_accessor_storage=value}#snaps_accessor_storage=false;get snaps(){return this.#snaps_accessor_storage}set snaps(value){this.#snaps_accessor_storage=value}#ticks_accessor_storage=[];get ticks(){return this.#ticks_accessor_storage}set ticks(value){this.#ticks_accessor_storage=value}#value_accessor_storage=0;get value(){return this.#value_accessor_storage}set value(value){this.#value_accessor_storage=value}#disabled__accessor_storage=false;get disabled_(){return this.#disabled__accessor_storage}set disabled_(value){this.#disabled__accessor_storage=value}#label__accessor_storage="";get label_(){return this.#label__accessor_storage}set label_(value){this.#label__accessor_storage=value}#showLabel__accessor_storage=false;get showLabel_(){return this.#showLabel__accessor_storage}set showLabel_(value){this.#showLabel__accessor_storage=value}#transiting__accessor_storage=false;get transiting_(){return this.#transiting__accessor_storage}set transiting_(value){this.#transiting__accessor_storage=value}deltaKeyMap_=null;draggingEventTracker_=null;firstUpdated(){this.setAttribute("role","slider");this.addEventListener("blur",this.hideRipple_);this.addEventListener("focus",this.showRipple_);this.addEventListener("keydown",this.onKeyDown_);this.addEventListener("keyup",this.onKeyUp_);this.addEventListener("pointerdown",this.onPointerDown_.bind(this))}connectedCallback(){super.connectedCallback();this.draggingEventTracker_=new EventTracker}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("keyPressSliderIncrement")){this.onKeyPressSliderIncrementChanged_()}if(changedProperties.has("value")||changedProperties.has("min")||changedProperties.has("max")){if(this.value!==undefined){this.updateValue_(this.value)}}if(changedProperties.has("disabled")||changedProperties.has("ticks")){this.disabled_=this.disabled||this.ticks.length===1}if(changedProperties.has("ticks")){if(this.ticks.length>1){this.snaps=true;this.max=this.ticks.length-1;this.min=0}}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("disabled_")){this.setAttribute("tabindex",this.disabled_?"-1":"0");this.blur()}if(changedProperties.has("ticks")){if(this.value!==undefined){this.updateValue_(this.value)}}if(changedProperties.has("value")||changedProperties.has("min")||changedProperties.has("max")||changedProperties.has("ticks")){this.updateUi_()}}getMarkers_(){const array=Array.from({length:Math.max(0,this.markerCount-1)});array.fill(0);return array}getMarkerClass_(index){const currentStep=(this.markerCount-1)*this.getRatio();return index<currentStep?"active-marker":"inactive-marker"}getRatio(){return(this.value-this.min)/(this.max-this.min)}stopDragging_(pointerId){this.draggingEventTracker_.removeAll();this.releasePointerCapture(pointerId);this.dragging=false;this.hideRipple_()}hideRipple_(){if(this.noink){return}this.getRipple().clear();this.showLabel_=false}showRipple_(){if(this.noink){return}if(!this.getRipple().holdDown){this.getRipple().showAndHoldDown()}this.showLabel_=true}onKeyDown_(event){if(this.disabled_||this.noKeybindings){return}if(event.metaKey||event.shiftKey||event.altKey||event.ctrlKey){return}let newValue;if(event.key==="Home"){newValue=this.min}else if(event.key==="End"){newValue=this.max}else if(this.deltaKeyMap_.has(event.key)){newValue=this.value+this.deltaKeyMap_.get(event.key)}if(newValue===undefined){return}this.updatingFromKey=true;if(this.updateValue_(newValue)){this.fire("cr-slider-value-changed")}event.preventDefault();event.stopPropagation();this.showRipple_()}onKeyUp_(event){if(event.key==="Home"||event.key==="End"||this.deltaKeyMap_.has(event.key)){setTimeout((()=>{this.updatingFromKey=false}))}}onPointerDown_(event){if(this.disabled_||event.buttons!==1&&event.pointerType==="mouse"){return}this.dragging=true;this.transiting_=true;this.updateValueFromClientX_(event.clientX);this.showRipple_();this.setPointerCapture(event.pointerId);const stopDragging=this.stopDragging_.bind(this,event.pointerId);assert(!!this.draggingEventTracker_);this.draggingEventTracker_.add(this,"pointermove",(e=>{e.preventDefault();if(e.buttons!==1&&e.pointerType==="mouse"){stopDragging();return}this.updateValueFromClientX_(e.clientX)}));this.draggingEventTracker_.add(this,"pointercancel",stopDragging);this.draggingEventTracker_.add(this,"pointerdown",stopDragging);this.draggingEventTracker_.add(this,"pointerup",stopDragging);this.draggingEventTracker_.add(this,"keydown",(e=>{if(e.key==="Escape"||e.key==="Tab"||e.key==="Home"||e.key==="End"||this.deltaKeyMap_.has(e.key)){stopDragging()}}))}onTransitionEnd_(){this.transiting_=false}updateUi_(){const percent=`${this.getRatio()*100}%`;this.$.bar.style.width=percent;this.$.knobAndLabel.style.marginInlineStart=percent;const ticks=this.ticks;const value=this.value;if(ticks&&ticks.length>0&&Number.isInteger(value)&&value>=0&&value<ticks.length){const tick=ticks[this.value];this.label_=Number.isFinite(tick)?"":tick.label;const ariaValueNow=getAriaValue(tick);this.setAttribute("aria-valuetext",String(this.label_||ariaValueNow));this.setAttribute("aria-valuenow",ariaValueNow.toString());this.setAttribute("aria-valuemin",getAriaValue(ticks[0]).toString());this.setAttribute("aria-valuemax",getAriaValue(ticks.slice(-1)[0]).toString())}else{this.setAttribute("aria-valuetext",value!==undefined?value.toString():"");this.setAttribute("aria-valuenow",value!==undefined?value.toString():"");this.setAttribute("aria-valuemin",this.min.toString());this.setAttribute("aria-valuemax",this.max.toString())}}updateValue_(value){if(this.snaps){if(Math.abs(this.value-value)<.8){return false}value=Math.round(value)}value=clamp(this.min,this.max,value);if(this.value===value){return false}this.value=value;return true}isRtl_(){return this.matches(":host-context([dir=rtl]) cr-slider")}updateValueFromClientX_(clientX){const rect=this.$.container.getBoundingClientRect();let ratio=(clientX-rect.left)/rect.width;if(this.isRtl_()){ratio=1-ratio}if(this.updateValue_(ratio*(this.max-this.min)+this.min)){this.fire("cr-slider-value-changed")}}onKeyPressSliderIncrementChanged_(){const isRtl=this.isRtl_();const increment=this.keyPressSliderIncrement;const decrement=-this.keyPressSliderIncrement;this.deltaKeyMap_=new Map([["ArrowDown",decrement],["ArrowUp",increment],["PageDown",decrement],["PageUp",increment],["ArrowLeft",isRtl?increment:decrement],["ArrowRight",isRtl?decrement:increment]])}createRipple(){this.rippleContainer=this.$.knob;const ripple=super.createRipple();ripple.setAttribute("recenters","");ripple.classList.add("circle");return ripple}}customElements.define(CrSliderElement.is,CrSliderElement);function getTemplate$2k(){return html`<!--_html_template_start_--><style>:host{display:inline-flex}cr-policy-pref-indicator{align-self:center;margin-inline-start:var(--cr-controlled-by-spacing)}#labels[disabled]{color:var(--google-grey-400)}@media (prefers-color-scheme:dark){#labels[disabled]{color:var(--google-grey-500)}}div.outer{align-items:stretch;display:flex;flex-direction:column;margin:8px 0;min-width:200px}#labels{display:flex;flex-direction:row;justify-content:space-between;margin:-4px 16px 0 16px}#labels>div{font-size:12px}#label-begin{margin-inline-end:4px}#label-end{margin-inline-start:4px}</style>
<template is="dom-if" if="[[pref.controlledBy]]" restamp>
  <cr-policy-pref-indicator pref="[[pref]]"></cr-policy-pref-indicator>
</template>
<div class="outer">
  <cr-slider id="slider" disabled$="[[disableSlider_]]" ticks="[[ticks]]"
      on-cr-slider-value-changed="onSliderChanged_" max="[[max]]"
      min="[[min]]" on-dragging-changed="onSliderChanged_"
      on-updating-from-key="onSliderChanged_"
      aria-roledescription$="[[getRoleDescription_()]]"
      aria-label$="[[labelAria]]"
      aria-disabled="[[ariaDisabled]]">
  </cr-slider>
  <!-- aria-hidden because role description on #slider contains min/max. -->
  <div id="labels" disabled$="[[disableSlider_]]" aria-hidden="true">
    <div id="label-begin">[[labelMin]]</div>
    <div id="label-end">[[labelMax]]</div>
  </div>
</div>
<!--_html_template_end_-->`}const SettingsSliderElementBase=CrPolicyPrefMixin(PolymerElement);class SettingsSliderElement extends SettingsSliderElementBase{static get is(){return"settings-slider"}static get template(){return getTemplate$2k()}static get properties(){return{pref:Object,ticks:{type:Array,value:()=>[]},scale:{type:Number,value:1},min:Number,max:Number,labelAria:String,labelMin:String,labelMax:String,disabled:Boolean,ariaDisabled:String,showMarkers:Boolean,disableSlider_:{computed:"computeDisableSlider_(pref.*, disabled, ticks.*)",type:Boolean},updateValueInstantly:{type:Boolean,value:true,observer:"onSliderChanged_"},loaded_:Boolean}}static get observers(){return["valueChanged_(pref.*, ticks.*, loaded_)"]}connectedCallback(){super.connectedCallback();this.loaded_=true}focus(){this.$.slider.focus()}getTickValue_(tick){return typeof tick==="object"?tick.value:tick}getTickValueAtIndex_(index){return this.getTickValue_(this.ticks[index])}onSliderChanged_(){if(!this.loaded_){return}if(this.$.slider.dragging&&!this.updateValueInstantly){return}const sliderValue=this.$.slider.value;let newValue;if(this.ticks&&this.ticks.length>0){newValue=this.getTickValueAtIndex_(sliderValue)}else{newValue=sliderValue/this.scale}this.set("pref.value",newValue)}computeDisableSlider_(){return this.disabled||this.isPrefEnforced()}valueChanged_(){if(this.pref===undefined||!this.loaded_||this.$.slider.dragging||this.$.slider.updatingFromKey){return}const numTicks=this.ticks.length;if(numTicks===1){this.$.slider.disabled=true;return}const prefValue=this.pref.value;if(numTicks===0){this.$.slider.value=prefValue*this.scale;return}assert(this.scale===1);const MAX_TICKS=10;this.$.slider.markerCount=this.showMarkers||numTicks<=MAX_TICKS?numTicks:0;const index=this.ticks.map((tick=>Math.abs(this.getTickValue_(tick)-prefValue))).reduce(((acc,diff,index)=>diff<acc.diff?{index:index,diff:diff}:acc),{index:-1,diff:Number.MAX_VALUE}).index;assert(index!==-1);if(this.$.slider.value!==index){this.$.slider.value=index}const tickValue=this.getTickValueAtIndex_(index);if(this.pref.value!==tickValue){this.set("pref.value",tickValue)}}getRoleDescription_(){return loadTimeData.getStringF("settingsSliderRoleDescription",this.labelMin,this.labelMax)}}customElements.define(SettingsSliderElement.is,SettingsSliderElement);class FontsBrowserProxyImpl{fetchFontsData(){return sendWithPromise("fetchFontsData")}static getInstance(){return instance$n||(instance$n=new FontsBrowserProxyImpl)}static setInstance(obj){instance$n=obj}}let instance$n=null;function getTemplate$2j(){return html`<!--_html_template_start_-->  <style include="cr-shared-style settings-shared">#minimumSize{align-items:flex-end;display:flex;flex-direction:column}#minimumSizeFontPreview{text-align:end}div[id$='FontPreview']{line-height:initial}
  </style>
  <settings-subpage page-title="$i18n{customizeFonts}"
      route-path$="[[routePath]]">
    <div class="cr-row first">
      <div class="flex cr-padded-text" aria-hidden="true">
        $i18n{fontSize}
      </div>
      <settings-slider id="sizeSlider"
          pref="{{prefs.webkit.webprefs.default_font_size}}"
          ticks="[[fontSizeRange_]]" label-aria="$i18n{fontSize}"
          label-min="$i18n{tiny}" label-max="$i18n{huge}">
      </settings-slider>
    </div>
    <div class="cr-row">
      <div class="flex cr-padded-text" aria-hidden="true">
        $i18n{minimumFont}
      </div>
      <div id="minimumSize">
        <settings-slider  pref="{{prefs.webkit.webprefs.minimum_font_size}}"
            ticks="[[minimumFontSizeRange_]]" label-aria="$i18n{minimumFont}"
            label-min="$i18n{tiny}" label-max="$i18n{huge}">
        </settings-slider>
        <div id="minimumSizeFontPreview"
            style="
                font-size:[[computeMinimumFontSize_(
                    prefs.webkit.webprefs.minimum_font_size.value)]]px;
                font-family:
                    '[[prefs.webkit.webprefs.fonts.standard.Zyyy.value]]';"
            hidden>
          [[computeMinimumFontSize_(
                  prefs.webkit.webprefs.minimum_font_size.value)]]:
          $i18n{quickBrownFox}
        </div>
      </div>
    </div>
    <div class="cr-row" aria-hidden="true">
      <h2>$i18n{standardFont}</h2>
    </div>
    <div class="list-frame">
      <div class="list-item">
        <settings-dropdown-menu class="start" label="$i18n{standardFont}"
            pref="{{prefs.webkit.webprefs.fonts.standard.Zyyy}}"
            menu-options="[[fontOptions_]]">
        </settings-dropdown-menu>
      </div>
      <div id="standardFontPreview" class="list-item cr-padded-text"
          style="
              font-size:[[prefs.webkit.webprefs.default_font_size.value]]px;
              font-family:
                  '[[prefs.webkit.webprefs.fonts.standard.Zyyy.value]]';">
        [[prefs.webkit.webprefs.default_font_size.value]]:
        $i18n{quickBrownFox}
      </div>
    </div>
    <div class="cr-row" aria-hidden="true">
      <h2>$i18n{serifFont}</h2>
    </div>
    <div class="list-frame">
      <div class="list-item">
        <settings-dropdown-menu class="start" label="$i18n{serifFont}"
            pref="{{prefs.webkit.webprefs.fonts.serif.Zyyy}}"
            menu-options="[[fontOptions_]]">
        </settings-dropdown-menu>
      </div>
      <div id="serifFontPreview" class="list-item cr-padded-text"
          style="
              font-size:[[prefs.webkit.webprefs.default_font_size.value]]px;
              font-family:
                  '[[prefs.webkit.webprefs.fonts.serif.Zyyy.value]]';">
        [[prefs.webkit.webprefs.default_font_size.value]]:
        $i18n{quickBrownFox}
      </div>
    </div>
    <div class="cr-row" aria-hidden="true">
      <h2>$i18n{sansSerifFont}</h2>
    </div>
    <div class="list-frame">
      <div class="list-item">
        <settings-dropdown-menu class="start" label="$i18n{sansSerifFont}"
            pref="{{prefs.webkit.webprefs.fonts.sansserif.Zyyy}}"
            menu-options="[[fontOptions_]]">
        </settings-dropdown-menu>
      </div>
      <div id="sansSerifFontPreview" class="list-item cr-padded-text"
          style="
              font-size:[[prefs.webkit.webprefs.default_font_size.value]]px;
              font-family:
                  '[[prefs.webkit.webprefs.fonts.sansserif.Zyyy.value]]';">
        [[prefs.webkit.webprefs.default_font_size.value]]:
        $i18n{quickBrownFox}
      </div>
    </div>
    <div class="cr-row" aria-hidden="true">
      <h2>$i18n{fixedWidthFont}</h2>
    </div>
    <div class="list-frame">
      <div class="list-item">
        <settings-dropdown-menu class="start" label="$i18n{fixedWidthFont}"
            pref="{{prefs.webkit.webprefs.fonts.fixed.Zyyy}}"
            menu-options="[[fontOptions_]]">
        </settings-dropdown-menu>
      </div>
      <div id="fixedFontPreview" class="list-item cr-padded-text"
          style="
              font-size:
                  [[prefs.webkit.webprefs.default_fixed_font_size.value]]px;
              font-family: '[[fontFamilyValueForFixed_(
                  prefs.webkit.webprefs.fonts.fixed.Zyyy.value)]]';">
        [[prefs.webkit.webprefs.default_fixed_font_size.value]]:
        $i18n{quickBrownFox}
      </div>
    </div>
    <div class="cr-row" aria-hidden="true">
      <h2>$i18n{mathFont}</h2>
    </div>
    <div class="list-frame">
      <div class="list-item">
        <settings-dropdown-menu class="start" label="$i18n{mathFont}"
            pref="{{prefs.webkit.webprefs.fonts.math.Zyyy}}"
            menu-options="[[fontOptions_]]">
        </settings-dropdown-menu>
      </div>
      <!-- A text preview like quickBrownFox is not really helpful for
           mathematical fonts. Not only it's desired to show special math
           characters but also to demo advanced features involving the
           OpenType MATH table such as big/stretchy operators or special
           layout constants. This is what the formula below tries to do. -->
      <div id="mathFontPreview" class="list-item cr-padded-text"
          style="
              font-size:[[prefs.webkit.webprefs.default_font_size.value]]px;
              font-family:
                  '[[prefs.webkit.webprefs.fonts.math.Zyyy.value]]';">
        [[prefs.webkit.webprefs.default_font_size.value]]:
        <math style="font: inherit;" displaystyle="true">
          <mrow>
            <msqrt>
              <mrow>
                <munderover>
                  <mo>∑</mo>
                  <mrow>
                    <mi>n</mi>
                    <mo>=</mo>
                    <mn>1</mn>
                  </mrow>
                  <mn>∞</mn>
                </munderover>
                <mfrac>
                  <mn>10</mn>
                  <msup>
                    <mi>n</mi>
                    <mn>4</mn>
                  </msup>
                </mfrac>
              </mrow>
            </msqrt>
            <mo>=</mo>
            <mrow>
              <msubsup>
                <mo>∫</mo>
                <mn>0</mn>
                <mn>∞</mn>
              </msubsup>
              <mfrac>
                <mrow>
                  <mn>2</mn>
                  <mi>x</mi>
                  <mrow>
                    <mi>d</mi>
                    <mi>x</mi>
                  </mrow>
                </mrow>
                <mrow>
                  <msup>
                    <mi>e</mi>
                    <mi>x</mi>
                  </msup>
                  <mo>−</mo>
                  <mn>1</mn>
                </mrow>
              </mfrac>
            </mrow>
            <mo>=</mo>
            <mfrac>
              <msup>
                <mi>π</mi>
                <mn>2</mn>
              </msup>
              <mn>3</mn>
            </mfrac>
            <mo>∊</mo>
            <mi>ℝ</mi>
          </mrow>
        </math>
      </div>
    </div>
  </settings-subpage>
<!--_html_template_end_-->`}const FONT_SIZE_RANGE=[9,10,11,12,13,14,15,16,17,18,20,22,24,26,28,30,32,34,36,40,44,48,56,64,72];const MINIMUM_FONT_SIZE_RANGE=[0,6,7,8,9,10,11,12,13,14,15,16,17,18,20,22,24];function ticksWithLabels(ticks){return ticks.map((x=>({label:`${x}`,value:x,ariaValue:undefined})))}const SettingsAppearanceFontsPageElementBase=SettingsViewMixin(PolymerElement);class SettingsAppearanceFontsPageElement extends SettingsAppearanceFontsPageElementBase{static get is(){return"settings-appearance-fonts-page"}static get template(){return getTemplate$2j()}static get properties(){return{fontOptions_:Object,fontSizeRange_:{readOnly:true,type:Array,value:ticksWithLabels(FONT_SIZE_RANGE)},minimumFontSizeRange_:{readOnly:true,type:Array,value:ticksWithLabels(MINIMUM_FONT_SIZE_RANGE)},prefs:{type:Object,notify:true}}}static get observers(){return["onMinimumSizeChange_(prefs.webkit.webprefs.minimum_font_size.value)"]}browserProxy_=FontsBrowserProxyImpl.getInstance();ready(){super.ready();this.browserProxy_.fetchFontsData().then(this.setFontsData_.bind(this))}setFontsData_(response){const fontMenuOptions=[];for(const fontData of response.fontList){fontMenuOptions.push({value:fontData[0],name:fontData[1]})}this.fontOptions_=fontMenuOptions}computeMinimumFontSize_(){const prefValue=this.get("prefs.webkit.webprefs.minimum_font_size.value");return prefValue||MINIMUM_FONT_SIZE_RANGE[0]}onMinimumSizeChange_(){this.$.minimumSizeFontPreview.hidden=this.computeMinimumFontSize_()<=0}fontFamilyValueForFixed_(prefValue){if(prefValue==="Osaka"){return"Osaka-Mono"}return prefValue}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsAppearanceFontsPageElement.is,SettingsAppearanceFontsPageElement);function getTemplate$2i(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared cr-icons
    settings-columned-section">#topSection{border-bottom:var(--cr-separator-line)}
</style>
<settings-subpage page-title="$i18n{autofillAiPageTitle}">
<div id="topSection">
  <settings-toggle-button id="prefToggle"
      on-settings-boolean-control-change="onOptInToggleChange_"
      disabled="[[ineligibleUser]]" pref="{{optedIn_}}"
      no-extension-indicator label="$i18n{autofillAiPageTitle}"
      sub-label="$i18n{autofillAiToggleSubLabel}">
  </settings-toggle-button>

  <div class="settings-columned-section">
    <div class="column">
      <h3 class="description-header">$i18n{columnHeadingWhenOn}</h3>
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:sync-saved-locally" aria-hidden="true">
          </cr-icon>
          <div class="cr-secondary-text">
            $i18n{autofillAiWhenOnSavedInfo}
          </div>
        </li>
        <li>
          <cr-icon icon="settings20:text-analysis" aria-hidden="true"></cr-icon>
          <div class="cr-secondary-text">
            $i18n{autofillAiWhenOnUseToFill}
          </div>
        </li>
      </ul>
    </div>
    <div class="column">
      <h3 class="description-header">
        $i18n{columnHeadingConsider}
      </h3>
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:googleg" aria-hidden="true"></cr-icon>
          <div class="cr-secondary-text">
            $i18n{autofillAiToConsiderDataUsage}
          </div>
        </li>
        <template is="dom-if" if="[[showLoggingInfoBullet_(
            prefs.optimization_guide.model_execution.autofill_prediction_improvements_enterprise_policy_allowed.value)]]"
            restamp>
          <settings-ai-logging-info-bullet
              id="enterpriseInfoBullet"
              pref=
                  "[[prefs.optimization_guide.model_execution.autofill_prediction_improvements_enterprise_policy_allowed]]"
              logging-managed-disabled-custom-label=
                  "$i18n{autofillAiSubpageSublabelLoggingManagedDisabled}">
          </settings-ai-logging-info-bullet>
        </template>
      </ul>
    </div>
  </div>
</div>

<settings-autofill-ai-entries-list
    list-title="$i18n{autofillAiEntityInstancesHeader}"
    prefs="{{prefs}}">
</settings-autofill-ai-entries-list>
</settings-subpage>
<!--_html_template_end_-->`}const SettingsAutofillAiSectionElementBase=SettingsViewMixin(I18nMixin(PrefsMixin(PolymerElement)));class SettingsAutofillAiSectionElement extends SettingsAutofillAiSectionElementBase{static get is(){return"settings-autofill-ai-section"}static get template(){return getTemplate$2i()}static get properties(){return{ineligibleUser:{type:Boolean,value(){return!loadTimeData.getBoolean("userEligibleForAutofillAi")}},optedIn_:{type:Object,value:()=>({type:chrome.settingsPrivate.PrefType.BOOLEAN,value:false})},isWalletServerStorageEnabled_:{type:Boolean,value(){return loadTimeData.getBoolean("isWalletServerStorageEnabled")}},autofillAiIgnoresWhetherAddressFillingIsEnabled_:{type:Boolean,value(){return loadTimeData.getBoolean("AutofillAiIgnoresWhetherAddressFillingIsEnabled")}}}}static get observers(){return[`onAutofillAddressPrefChanged_(\n          prefs.autofill.profile_enabled.value)`]}entityDataManager_=EntityDataManagerProxyImpl.getInstance();connectedCallback(){super.connectedCallback();this.entityDataManager_.getOptInStatus().then((optedIn=>this.set("optedIn_.value",!this.ineligibleUser&&optedIn)));const policyDisabled=this.getPref(AiEnterpriseFeaturePrefName.AUTOFILL_AI).value===ModelExecutionEnterprisePolicyValue.DISABLE;if(policyDisabled){this.set("optedIn_.enforcement",chrome.settingsPrivate.Enforcement.ENFORCED);this.set("optedIn_.controlledBy",chrome.settingsPrivate.ControlledBy.USER_POLICY)}}disconnectedCallback(){super.disconnectedCallback()}async onOptInToggleChange_(){this.ineligibleUser=!await this.entityDataManager_.setOptInStatus(this.$.prefToggle.checked);if(this.ineligibleUser){this.set("optedIn_.value",false)}}showLoggingInfoBullet_(pref){return pref!==ModelExecutionEnterprisePolicyValue.ALLOW}async onAutofillAddressPrefChanged_(prefValue){if(this.autofillAiIgnoresWhetherAddressFillingIsEnabled_){return}const optedIn=await this.entityDataManager_.getOptInStatus();this.set("optedIn_.value",!this.ineligibleUser&&optedIn&&prefValue)}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsAutofillAiSectionElement.is,SettingsAutofillAiSectionElement);let instance$m=null;function getCss$9(){return instance$m||(instance$m=[...[getCss$b(),getCss$c(),getCss$d()],css`textarea{display:block;resize:none;position:relative;z-index:1}#input-container{background-color:var(--cr-input-background-color);border-radius:8px;border:1px solid rgba(0,0,0,0.1)}@media (prefers-color-scheme:dark){#input-container{border:1px solid rgba(255,255,255,0.8)}}:host([autogrow][has-max-height]) #input-container{box-sizing:content-box;max-height:var(--cr-textarea-autogrow-max-height);min-height:1lh}:host([invalid]) #underline{border-color:var(--cr-input-error-color)}#input{padding-bottom:var(--cr-input-padding-bottom);padding-inline-end:var(--cr-input-padding-end);padding-inline-start:var(--cr-input-padding-start);padding-top:var(--cr-input-padding-top)}#footerContainer{border-top:0;display:var(--cr-textarea-footer-display,none);font-size:var(--cr-form-field-label-font-size);height:var(--cr-form-field-label-height);justify-content:space-between;line-height:var(--cr-form-field-label-line-height);margin:8px 0;min-height:0;padding:0;white-space:var(--cr-input-error-white-space)}:host([invalid]) #label,:host([invalid]) #footerContainer{color:var(--cr-input-error-color)}#mirror{display:none;font-size:12px;line-height:16px}:host([autogrow]) #mirror{display:block;visibility:hidden;white-space:pre-wrap;word-wrap:break-word}:host([autogrow]) #mirror,:host([autogrow]) textarea{border:0;box-sizing:border-box;padding-bottom:var(--cr-input-padding-bottom,6px);padding-inline-end:var(--cr-input-padding-end,8px);padding-inline-start:var(--cr-input-padding-start,8px);padding-top:var(--cr-input-padding-top,6px)}:host([autogrow]) textarea{height:100%;left:0;overflow:hidden;position:absolute;resize:none;top:0;width:100%}:host([autogrow][has-max-height]) #mirror,:host([autogrow][has-max-height]) textarea{overflow-x:hidden;overflow-y:auto}`])}function getHtml$9(){return html$1`
<div id="label" class="cr-form-field-label" ?hidden="${!this.label}"
    aria-hidden="true">
  ${this.label}
</div>
<div id="input-container">
  <!-- The mirror div is used to take up the required space when autogrow is
       set. -->
  <div id="mirror">${this.calculateMirror_()}</div>
  <!-- The textarea is limited to |rows| height. If the content exceeds the
       bounds, it scrolls by default unless autogrow is set. No space or
       comments are allowed before the closing tag. -->
  <div id="hover-layer"></div>
  <textarea id="input" ?autofocus="${this.autofocus}" .rows="${this.rows}"
     .value="${this.internalValue_}" aria-label="${this.label}"
     @input="${this.onInput_}" @focus="${this.onInputFocusChange_}"
     @blur="${this.onInputFocusChange_}" @change="${this.onInputChange_}"
     ?disabled="${this.disabled}" maxlength="${this.maxlength}"
     ?readonly="${this.readonly}" ?required="${this.required}"
     placeholder="${this.placeholder||nothing}">
  </textarea>
  <div id="underline-base"></div>
  <div id="underline"></div>
</div>
<div id="footerContainer" class="cr-row">
  <div id="firstFooter" aria-live="${this.getFooterAria_()}">
    ${this.firstFooter}
  </div>
  <div id="secondFooter" aria-live="${this.getFooterAria_()}">
    ${this.secondFooter}
  </div>
</div>`}class CrTextareaElement extends CrLitElement{static get is(){return"cr-textarea"}static get styles(){return getCss$9()}render(){return getHtml$9.bind(this)()}static get properties(){return{autofocus:{type:Boolean,reflect:true},disabled:{type:Boolean,reflect:true},required:{type:Boolean,reflect:true},maxlength:{type:Number},readonly:{type:Boolean,reflect:true},rows:{type:Number,reflect:true},label:{type:String},value:{type:String,notify:true},internalValue_:{type:String,state:true},placeholder:{type:String},autogrow:{type:Boolean,reflect:true},hasMaxHeight:{type:Boolean,reflect:true},invalid:{type:Boolean,reflect:true},firstFooter:{type:String},secondFooter:{type:String}}}#autofocus_accessor_storage=false;get autofocus(){return this.#autofocus_accessor_storage}set autofocus(value){this.#autofocus_accessor_storage=value}#disabled_accessor_storage=false;get disabled(){return this.#disabled_accessor_storage}set disabled(value){this.#disabled_accessor_storage=value}#readonly_accessor_storage=false;get readonly(){return this.#readonly_accessor_storage}set readonly(value){this.#readonly_accessor_storage=value}#required_accessor_storage=false;get required(){return this.#required_accessor_storage}set required(value){this.#required_accessor_storage=value}#rows_accessor_storage=3;get rows(){return this.#rows_accessor_storage}set rows(value){this.#rows_accessor_storage=value}#label_accessor_storage="";get label(){return this.#label_accessor_storage}set label(value){this.#label_accessor_storage=value}#maxlength_accessor_storage;get maxlength(){return this.#maxlength_accessor_storage}set maxlength(value){this.#maxlength_accessor_storage=value}#value_accessor_storage="";get value(){return this.#value_accessor_storage}set value(value){this.#value_accessor_storage=value}#placeholder_accessor_storage="";get placeholder(){return this.#placeholder_accessor_storage}set placeholder(value){this.#placeholder_accessor_storage=value}#autogrow_accessor_storage=false;get autogrow(){return this.#autogrow_accessor_storage}set autogrow(value){this.#autogrow_accessor_storage=value}#hasMaxHeight_accessor_storage=false;get hasMaxHeight(){return this.#hasMaxHeight_accessor_storage}set hasMaxHeight(value){this.#hasMaxHeight_accessor_storage=value}#invalid_accessor_storage=false;get invalid(){return this.#invalid_accessor_storage}set invalid(value){this.#invalid_accessor_storage=value}#firstFooter_accessor_storage="";get firstFooter(){return this.#firstFooter_accessor_storage}set firstFooter(value){this.#firstFooter_accessor_storage=value}#secondFooter_accessor_storage="";get secondFooter(){return this.#secondFooter_accessor_storage}set secondFooter(value){this.#secondFooter_accessor_storage=value}#internalValue__accessor_storage="";get internalValue_(){return this.#internalValue__accessor_storage}set internalValue_(value){this.#internalValue__accessor_storage=value}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("value")){this.internalValue_=this.value===undefined||this.value===null?"":this.value}}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("disabled")){this.setAttribute("aria-disabled",this.disabled?"true":"false")}}focusInput(){this.$.input.focus()}async onInputChange_(e){await this.updateComplete;this.fire("change",{sourceEvent:e})}calculateMirror_(){if(!this.autogrow){return""}const tokens=this.value?this.value.split("\n"):[""];while(this.rows>0&&tokens.length<this.rows){tokens.push("")}return tokens.join("\n")+"&nbsp;"}onInput_(e){this.internalValue_=e.target.value;this.value=this.internalValue_}onInputFocusChange_(){if(this.shadowRoot.activeElement===this.$.input){this.setAttribute("focused_","")}else{this.removeAttribute("focused_")}}getFooterAria_(){return this.invalid?"assertive":"polite"}}customElements.define(CrTextareaElement.is,CrTextareaElement);function getTemplate$2h(){return html`<!--_html_template_start_-->    <style include="cr-shared-style settings-shared md-select">:host{white-space:nowrap}:host-context([dir=rtl]) cr-input.phone-number-input::part(input){direction:ltr;text-align:end}.address-row{display:flex}.address-column{margin-inline-end:16px;width:calc((var(--cr-default-input-max-width) - 16px) / 2)}#select-row{display:block;outline:none;transform:translate3d(0,0,0)}.md-select{--md-select-width:var(--cr-default-input-max-width)}.long{width:var(--cr-default-input-max-width)}cr-input{--cr-input-error-display:none}cr-input:not(.last-row),cr-textarea,.md-select{margin-bottom:var(--cr-form-field-bottom-spacing)}#dialog::part(body-container){max-height:550px}@media all and (max-height:714px){#dialog::part(body-container){max-height:270px}}#notices{margin-bottom:4px;margin-top:20px;white-space:initial}#validationError{color:var(--google-red-600)}@media (prefers-color-scheme:dark){#validationError{color:var(--google-red-300)}}

    </style>
    <cr-dialog id="dialog" close-text="$i18n{close}">
      <div slot="title">[[title_]]</div>
      <div slot="body">
        <div id="select-row" class="address-row">
          <label id="select-label" class="cr-form-field-label">
            $i18n{addressCountry}
          </label>
          <select id="country" class="md-select" aria-labelledby="select-label"
              value="[[countryCode_]]" on-change="onCountryCodeSelectChange_"
              autofocus>
            <!-- TODO(crbug.com/403312087): Use
                 $i18n{autofillDropdownNoOptionSelected} as a text for this
                 option once the string is approved. -->
            <option value="" hidden="[[isAccountAddress_]]"></option>
            <template is="dom-repeat" items="[[countries_]]">
              <option value="[[getCode_(item)]]"
                  disabled="[[isDivision_(item)]]">
                [[getName_(item)]]
              </option>
            </template>
          </select>
        </div>
        <template is="dom-repeat" items="[[components_]]">
          <div class="address-row">
            <template is="dom-repeat" items="[[item]]">
              <template is="dom-if" if="[[item.isTextarea]]">
                <cr-textarea label="[[item.label]]"
                    value="{{item.value}}"
                    class$="address-column [[item.additionalClassName]]"
                    spellcheck="false" maxlength="1000"
                    required="[[item.isRequired]]"
                    invalid="[[isVisuallyInvalid_(item.isValidatable,
                                                  item.isValid)]]">
                </cr-textarea>
              </template>
              <template is="dom-if" if="[[!item.isTextarea]]">
                <cr-input type="text" label="[[item.label]]"
                    value="{{item.value}}" spellcheck="false"
                    maxlength="1000"
                    class$="address-column [[item.additionalClassName]]
                    [[getPhoneNumberInputClass_(item.fieldType)]]"
                    required="[[item.isRequired]]"
                    invalid="[[isVisuallyInvalid_(item.isValidatable,
                                                  item.isValid)]]">
                </cr-input>
              </template>
            </template>
          </div>
        </template>
        <div id="notices" hidden="[[!isAccountAddress_]]">
          <div id="validationError" hidden="[[!validationError_]]">
            [[validationError_]]
          </div>
          <div id="accountRecordTypeNotice"
              hidden="[[!accountAddressRecordTypeNotice_]]">
            [[accountAddressRecordTypeNotice_]]
          </div>
        </div>
      </div>
      <div slot="button-container">
        <cr-button id="cancelButton" class="cancel-button"
            on-click="onCancelClick_">
          $i18n{cancel}
        </cr-button>
        <cr-button id="saveButton" class="action-button"
            disabled="[[!canSave_]]" on-click="onSaveButtonClick_">
          $i18n{save}
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`}function isValueEmpty(value){return value===undefined||value===""}class AddressComponentUi{fieldType_;originalValue_;existingAddress_;onValueUpdateListener_;skipValidation_;addressFields_;isValidatable_;isTextarea;isRequired;label;additionalClassName;constructor(addressFields,originalFields,fieldType,label,onValueUpdateListener,additionalClassName="",isTextarea=false,skipValidation=false,isRequired=false){this.addressFields_=addressFields;this.existingAddress_=originalFields!==undefined;this.originalValue_=originalFields?.get(fieldType);this.fieldType_=fieldType;this.label=label;this.onValueUpdateListener_=onValueUpdateListener;this.additionalClassName=additionalClassName;this.isTextarea=isTextarea;this.isRequired=isRequired;this.skipValidation_=skipValidation;this.isValidatable_=false}get isValidatable(){return this.isValidatable_}get isValid(){if(this.skipValidation_){return true}if(this.existingAddress_){if(this.originalValue_===this.value||isValueEmpty(this.originalValue_)&&isValueEmpty(this.value)){return true}}return!this.isRequired||!!this.value}get value(){return this.addressFields_.get(this.fieldType_)}set value(value){const changed=value!==this.value;this.addressFields_.set(this.fieldType_,value);if(changed){this.onValueUpdateListener_()}}get hasValue(){return!isValueEmpty(this.value)}get fieldType(){return this.fieldType_}makeValidatable(){this.isValidatable_=true}}const AddressRecordType=chrome.autofillPrivate.AddressRecordType;const FieldType=chrome.autofillPrivate.FieldType;const SettingsAddressEditDialogElementBase=I18nMixin(PolymerElement);class SettingsAddressEditDialogElement extends SettingsAddressEditDialogElementBase{static get is(){return"settings-address-edit-dialog"}static get template(){return getTemplate$2h()}static get properties(){return{address:Object,accountInfo:Object,title_:String,validationError_:String,countries_:Array,countryCode_:{type:String,observer:"onCountryCodeChanged_"},components_:{type:Array,value:()=>[]},canSave_:Boolean,isAccountAddress_:{type:Boolean,computed:"isAddressStoredInAccount_(address, accountInfo)",value:false},accountAddressRecordTypeNotice_:{type:String,computed:"getAccountAddressRecordTypeNotice_(address, accountInfo)"}}}addressFields_=new Map;originalAddressFields_;countryDetailManager_=CountryDetailManagerProxyImpl.getInstance();connectedCallback(){super.connectedCallback();assert(this.address);for(const entry of this.address.fields){this.addressFields_.set(entry.type,entry.value)}const forAccountStorage=!!this.address.guid&&this.address.metadata!==undefined&&this.address.metadata.recordType===AddressRecordType.ACCOUNT;this.countryDetailManager_.getCountryList(forAccountStorage).then((countryList=>{this.countries_=countryList;const isEditingExistingAddress=!!this.address.guid;this.title_=this.i18n(isEditingExistingAddress?"editAddressTitle":"addAddressTitle");this.originalAddressFields_=isEditingExistingAddress?new Map(this.addressFields_):undefined;microTask.run((()=>{const countryField=this.addressFields_.get(FieldType.ADDRESS_HOME_COUNTRY);if(!countryField){assert(countryList.length>0);this.addressFields_.set(FieldType.ADDRESS_HOME_COUNTRY,countryList[0].countryCode)}this.countryCode_=this.addressFields_.get(FieldType.ADDRESS_HOME_COUNTRY)}))}))}fire_(eventName,detail){this.dispatchEvent(new CustomEvent(eventName,{bubbles:true,composed:true,detail:detail}))}async updateAddressComponents_(){const countryCode=this.countryCode_||this.countries_[0].countryCode;const format=await this.countryDetailManager_.getAddressFormat(countryCode);this.address.languageCode=format.languageCode;const skipValidation=!this.isAccountAddress_;this.components_=format.components.map(((componentRow,rowIndex)=>componentRow.row.map(((component,colIndex)=>new AddressComponentUi(this.addressFields_,this.originalAddressFields_,component.field,component.fieldName,this.notifyComponentValidity_.bind(this,rowIndex,colIndex),component.isLongField?"long":"",component.field===FieldType.ADDRESS_HOME_STREET_ADDRESS,skipValidation,component.isRequired)))));const contactsRowIndex=this.components_.length;this.components_.push([new AddressComponentUi(this.addressFields_,this.originalAddressFields_,FieldType.PHONE_HOME_WHOLE_NUMBER,this.i18n("addressPhone"),this.notifyComponentValidity_.bind(this,contactsRowIndex,0),"last-row"),new AddressComponentUi(this.addressFields_,this.originalAddressFields_,FieldType.EMAIL_ADDRESS,this.i18n("addressEmail"),this.notifyComponentValidity_.bind(this,contactsRowIndex,1),"long last-row")]);flush();this.updateCanSave_();this.fire_("on-update-address-wrapper");if(!this.$.dialog.open){this.$.dialog.showModal()}}isVisuallyInvalid_(isValidatable,isValid){return isValidatable&&!isValid}notifyComponentValidity_(row,col){this.components_[row][col].makeValidatable();const componentReference=`components_.${row}.${col}`;this.notifyPath(componentReference+".isValidatable");this.notifyPath(componentReference+".isValid");this.updateCanSave_()}notifyValidity_(){this.components_.forEach(((row,i)=>{row.forEach(((_col,j)=>this.notifyComponentValidity_(i,j)))}))}updateCanSave_(){this.validationError_="";if(!this.countryCode_&&this.hasAnyValue_()||this.countryCode_&&(!this.hasInvalidComponent_()||this.hasUncoveredInvalidComponent_())){this.canSave_=true;this.fire_("on-update-can-save");return}if(this.isAccountAddress_){const nInvalid=this.countInvalidComponent_();if(nInvalid===1){this.validationError_=this.i18n("editAddressRequiredFieldError")}else if(nInvalid>1){this.validationError_=this.i18n("editAddressRequiredFieldsError")}}this.canSave_=false;this.fire_("on-update-can-save")}getCode_(country){return country.countryCode||"SPACER"}getName_(country){return country.name||"------"}isDivision_(country){return!country.countryCode}getPhoneNumberInputClass_(fieldType){if(fieldType===chrome.autofillPrivate.FieldType.PHONE_HOME_WHOLE_NUMBER){return"phone-number-input"}return""}isAddressStoredInAccount_(){if(this.address.guid){return this.address.metadata!==undefined&&this.address.metadata.recordType===AddressRecordType.ACCOUNT}return!!this.accountInfo?.isEligibleForAddressAccountStorage}getAccountAddressRecordTypeNotice_(){if(this.accountInfo){return this.i18n(this.address.guid?"editAccountAddressRecordTypeNotice":"newAccountAddressRecordTypeNotice",this.accountInfo.email)}return""}hasAnyValue_(){return this.components_.flat().some((component=>component.hasValue))}hasInvalidComponent_(){return this.countInvalidComponent_()>0}countInvalidComponent_(){return this.components_.flat().filter((component=>!component.isValid)).length}hasUncoveredInvalidComponent_(){return this.components_.flat().some((component=>!component.isValid&&!component.isValidatable))}onCancelClick_(){chrome.metricsPrivate.recordBoolean("Autofill.Settings.EditAddress",false);this.$.dialog.cancel()}onSaveButtonClick_(){this.notifyValidity_();this.updateCanSave_();if(!this.canSave_){return}this.address.fields=[];this.addressFields_.forEach(((value,key,_map)=>{this.address.fields.push({type:key,value:value})}));chrome.metricsPrivate.recordBoolean("Autofill.Settings.EditAddress",true);this.fire_("save-address",this.address);this.$.dialog.close()}async onCountryCodeChanged_(){await this.updateAddressComponents_()}onCountryCodeSelectChange_(){this.addressFields_.set(FieldType.ADDRESS_HOME_COUNTRY,this.$.country.value);this.countryCode_=this.$.country.value}}customElements.define(SettingsAddressEditDialogElement.is,SettingsAddressEditDialogElement);function getTemplate$2g(){return html`<!--_html_template_start_--><cr-dialog show-on-attach id="dialog" close-text="$i18n{close}">
  <div slot="title" id="title">[[confirmationTitle_]]</div>
  <div slot="body" id="description"
      inner-h-t-m-l="[[confirmationDescription_]]">
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button" on-click="onCancelClick" id="cancel">
      $i18n{cancel}
    </cr-button>
    <cr-button class="action-button" on-click="onRemoveClick" id="remove">
      [[removeButtonLabel_]]
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}const SettingsAddressRemoveConfirmationDialogBase=I18nMixin(PolymerElement);class SettingsAddressRemoveConfirmationDialogElement extends SettingsAddressRemoveConfirmationDialogBase{static get is(){return"settings-address-remove-confirmation-dialog"}static get template(){return getTemplate$2g()}static get properties(){return{address:Object,accountInfo:Object,confirmationTitle_:{type:String,computed:"computeConfirmationTitle_()"},confirmationDescription_:{type:String,computed:"computeConfirmationDescription_(address, accountInfo)"},removeButtonLabel_:{type:String,computed:"computeRemoveButtonLabel_()"}}}wasConfirmed(){return this.$.dialog.getNative().returnValue==="success"}computeConfirmationTitle_(){if(this.isAccountHomeAddress_()){return this.i18n("removeHomeAddressConfirmationTitle")}if(this.isAccountWorkAddress_()){return this.i18n("removeWorkAddressConfirmationTitle")}return this.isAccountNameEmailAddress_()?this.i18n("removeNameEmailAddressConfirmationTitle"):this.i18n("removeAddressConfirmationTitle")}computeConfirmationDescription_(address,accountInfo){const isAccountAddress=address?.metadata?.recordType===chrome.autofillPrivate.AddressRecordType.ACCOUNT;if(isAccountAddress){return sanitizeInnerHtml(this.i18n("deleteAccountAddressRecordTypeNotice",accountInfo?.email||""))}if(this.isAccountHomeAddress_()){return sanitizeInnerHtml(loadTimeData.getStringF("deleteHomeAddressNotice",loadTimeData.getString("googleAccountHomeAddressUrl"),accountInfo?.email||""))}if(this.isAccountWorkAddress_()){return sanitizeInnerHtml(loadTimeData.getStringF("deleteWorkAddressNotice",loadTimeData.getString("googleAccountWorkAddressUrl"),accountInfo?.email||""))}if(this.isAccountNameEmailAddress_()){return sanitizeInnerHtml(loadTimeData.getStringF("deleteNameEmailAddressNotice",loadTimeData.getString("googleAccountNameEmailAddressEditUrl"),accountInfo?.email||""))}const isSyncEnabled=!!accountInfo?.isSyncEnabledForAutofillProfiles;return sanitizeInnerHtml(this.i18n(isSyncEnabled?"removeSyncAddressConfirmationDescription":"removeLocalAddressConfirmationDescription"))}computeRemoveButtonLabel_(){return this.isAccountHomeAddress_()||this.isAccountWorkAddress_()||this.isAccountNameEmailAddress_()?this.i18n("removeAddressFromChrome"):this.i18n("removeAddress")}isAccountHomeAddress_(){return this.address?.metadata?.recordType===chrome.autofillPrivate.AddressRecordType.ACCOUNT_HOME}isAccountWorkAddress_(){return this.address?.metadata?.recordType===chrome.autofillPrivate.AddressRecordType.ACCOUNT_WORK}isAccountNameEmailAddress_(){return this.address?.metadata?.recordType===chrome.autofillPrivate.AddressRecordType.ACCOUNT_NAME_EMAIL}onRemoveClick(){this.$.dialog.close()}onCancelClick(){this.$.dialog.cancel()}}customElements.define(SettingsAddressRemoveConfirmationDialogElement.is,SettingsAddressRemoveConfirmationDialogElement);const styleMod$5=document.createElement("dom-module");styleMod$5.appendChild(html`
  <template>
    <style>
.multi-card>.card{background-color:var(--cr-card-background-color);border-radius:var(--cr-card-border-radius);box-shadow:var(--cr-card-shadow);margin-top:var(--cr-section-vertical-margin)}.multi-card>.card:first-of-type{margin-top:0}.card h2{align-self:auto;padding-bottom:0;padding-top:12px}
    </style>
  </template>
`.content);styleMod$5.register("your-saved-info-shared");function getTemplate$2f(){return html`<!--_html_template_start_-->  <style include="cr-shared-style settings-shared passwords-shared
      your-saved-info-shared">#autofillSyncToggleWrapper{align-items:center;cursor:pointer;display:flex;min-height:var(--cr-section-two-line-min-height);padding:0 var(--cr-section-padding)}#autofillSyncToggleWrapper:hover{background-color:var(--cr-hover-background-color)}#addressList .start{display:flex;overflow:hidden}#addressSummary{display:flex;flex:1;overflow:hidden}#plusAddressSettingsButton{margin-top:16px}.dropdown-item.external-link-style{display:flex;justify-content:space-between;align-items:center;width:100%}.dropdown-item.external-link-style cr-icon{--cr-icon-color:var(--cr-secondary-text-color)}
  </style>
  <settings-subpage page-title="[[getPageTitleLabel_(isYourSavedInfoSubpage_)]]"
      hide-close-button
      learn-more-url="$i18n{addressesAndPaymentMethodsLearnMoreURL}"
      class$="[[getMultiCardClass_(isYourSavedInfoSubpage_)]]">
    <div class="card">
      <settings-toggle-button id="autofillProfileToggle"
          no-extension-indicator label="$i18n{enableProfilesLabel}"
          sub-label="$i18n{enableProfilesSublabel}"
          pref="{{prefs.autofill.profile_enabled}}"
          on-change="onAutofillProfileToggleChanged_">
      </settings-toggle-button>
      <div id="autofillSyncToggleWrapper"
          hidden$="[[!isAutofillSyncToggleVisible_(accountInfo_)]]">
        <div class="flex">
          <div class="label">$i18n{autofillSyncToggleLabel}</div>
          <div class="label cr-secondary-text">[[accountInfo_.email]]</div>
        </div>
        <cr-toggle id="autofillSyncToggle"
            checked="[[accountInfo_.isAutofillSyncToggleEnabled]]"
            on-change="onAutofillSyncEnabledChange_">
        </cr-toggle>
      </div>
      <template is="dom-if"
          if="[[prefs.autofill.profile_enabled.extensionId]]">
        <div class="cr-row continuation">
          <extension-controlled-indicator class="flex"
              id="autofillExtensionIndicator"
              extension-id="[[prefs.autofill.profile_enabled.extensionId]]"
              extension-name=
                  "[[prefs.autofill.profile_enabled.controlledByName]]"
              extension-can-be-disabled="[[
                  prefs.autofill.profile_enabled.extensionCanBeDisabled]]">
          </extension-controlled-indicator>
        </div>
      </template>
    </div>
    <div class="card">
      <div class="cr-row continuation">
        <h2 class="flex">$i18n{addresses}</h2>
        <cr-button id="addAddress" class="header-aligned-button"
            on-click="onAddAddressClick_" aria-label="$i18n{addAddressTitle}"
            hidden$="[[!prefs.autofill.profile_enabled.value]]">
          $i18n{add}
        </cr-button>
      </div>
      <div class="list-frame" aria-label="$i18n{addressesTableAriaLabel}"
          role="list">
        <div id="addressList" class="vertical-list" role="none">
          <template is="dom-repeat" items="[[addresses]]">
            <div class="list-item" role="listitem">
              <div class="start">
                <span id="addressSummary">
                  <span class="ellipses">
                    [[item.metadata.summaryLabel]]
                  </span>
                  <span class="ellipses">
                    [[item.metadata.summarySublabel]]
                  </span>
                </span>
                <cr-icon
                    id="address-row-icon"
                    icon="[[getAddressIcon_(item, accountInfo_)]]"
                    hidden$="[[!shouldShowAddressIcon_(item, accountInfo_)]]"
                    aria-label="[[getA11yLabelForIcon_(item, accountInfo_)]]"
                    role="img">
                </cr-icon>
              </div>
              <cr-icon-button class="icon-more-vert address-menu"
                  on-click="onAddressMenuClick_"
                  title="[[moreActionsTitle_(item)]]">
              </cr-icon-button>
            </div>
          </template>
        </div>
        <div id="noAddressesLabel" class="list-item"
            hidden$="[[hasSome_(addresses)]]">
          $i18n{noAddressesFound}
        </div>
      </div>
      <cr-action-menu id="addressSharedMenu" role-description="$i18n{menu}">
        <template is="dom-if" if="[[isGoogleProfileAddress]]" restamp>
          <button
              id="menuEditAddress"
              class="dropdown-item external-link-style"
              on-click="onMenuEditAddressClick_"
              aria-label="$i18n{homeWorkAddressAccessiblityLabel}">
            <span class="label">$i18n{edit}</span>
            <cr-icon icon="cr:open-in-new" aria-hidden="true"></cr-icon>
          </button>

          <button id="menuRemoveAddress"
              class="dropdown-item"
              on-click="onMenuRemoveAddressClick_">
            [[getMenuRemoveAddressLabel_(activeAddress)]]
          </button>
        </template>

        <template is="dom-if" if="[[!isGoogleProfileAddress]]" restamp>
          <button id="menuEditAddress" class="dropdown-item"
              on-click="onMenuEditAddressClick_">$i18n{edit}</button>

          <button id="menuRemoveAddress" class="dropdown-item"
              on-click="onMenuRemoveAddressClick_">
            [[getMenuRemoveAddressLabel_(activeAddress)]]
          </button>
        </template>
      </cr-action-menu>
      <template is="dom-if" if="[[showAddressDialog_]]" restamp>
        <settings-address-edit-dialog address="[[activeAddress]]"
            account-info="[[accountInfo_]]" on-close="onAddressDialogClose_">
        </settings-address-edit-dialog>
      </template>
      <template is="dom-if" if="[[showAddressRemoveConfirmationDialog_]]"
          restamp>
        <settings-address-remove-confirmation-dialog
            address="[[activeAddress]]" account-info="[[accountInfo_]]"
            on-close="onAddressRemoveConfirmationDialogClose_">
        </settings-address-remove-confirmation-dialog>
      </template>
      <template is="dom-if" if="[[isPlusAddressEnabled_]]">
        <cr-link-row class="cr-row" id="plusAddressSettingsButton"
            label="$i18n{plusAddressSettings}"
            sub-label="$i18n{plusAddressSettingsSublabel}"
            on-click="onPlusAddressClick_"
            role-description="$i18n{subpageArrowRoleDescription}"
            external>
        </cr-link-row>
      </template>
    </div>
  </settings-subpage>
<!--_html_template_end_-->`}var AutofillAddressOptInChange;(function(AutofillAddressOptInChange){AutofillAddressOptInChange[AutofillAddressOptInChange["OPT_IN"]=0]="OPT_IN";AutofillAddressOptInChange[AutofillAddressOptInChange["OPT_OUT"]=1]="OPT_OUT";AutofillAddressOptInChange[AutofillAddressOptInChange["COUNT"]=2]="COUNT"})(AutofillAddressOptInChange||(AutofillAddressOptInChange={}));const SettingsAutofillSectionElementBase=SettingsViewMixin(I18nMixin(PolymerElement));class SettingsAutofillSectionElement extends SettingsAutofillSectionElementBase{static get is(){return"settings-autofill-section"}static get template(){return getTemplate$2f()}static get properties(){return{prefs:Object,accountInfo_:{type:Object,value:null},addresses:Array,activeAddress:Object,showAddressDialog_:Boolean,showAddressRemoveConfirmationDialog_:Boolean,isGoogleProfileAddress:{type:Boolean,computed:"computeIsGoogleProfileAddress_(activeAddress)"},isPlusAddressEnabled_:{type:Boolean,value:()=>loadTimeData.getBoolean("plusAddressEnabled")},isYourSavedInfoSubpage_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableYourSavedInfoSettingsPage")}}}autofillManager_=AutofillManagerImpl.getInstance();setPersonalDataListener_=null;ready(){super.ready();this.addEventListener("save-address",this.saveAddress_);this.$.autofillSyncToggleWrapper.addEventListener("click",(()=>{this.$.autofillSyncToggle.click()}))}connectedCallback(){super.connectedCallback();const setAddressesListener=addressList=>{this.addresses=addressList};const setAccountListener=accountInfo=>{this.accountInfo_=accountInfo||null};const setPersonalDataListener=(addressList,_cardList,_ibans,_payOverTimeIssuerList,accountInfo)=>{this.addresses=addressList;this.accountInfo_=accountInfo||null};this.setPersonalDataListener_=setPersonalDataListener;this.autofillManager_.getAddressList().then(setAddressesListener);this.autofillManager_.getAccountInfo().then(setAccountListener);this.autofillManager_.setPersonalDataManagerListener(setPersonalDataListener);chrome.metricsPrivate.recordUserAction("AutofillAddressesViewed")}disconnectedCallback(){super.disconnectedCallback();this.autofillManager_.removePersonalDataManagerListener(this.setPersonalDataListener_);this.setPersonalDataListener_=null}getMultiCardClass_(){return this.isYourSavedInfoSubpage_?"multi-card":""}getPageTitleLabel_(){return this.i18n(this.isYourSavedInfoSubpage_?"contactInfoTitle":"addressesTitle")}getMenuRemoveAddressLabel_(address){const isGoogleProfileAddress=this.isAccountHomeAddress_(address)||this.isAccountWorkAddress_(address)||this.isAccountNameEmailAddress_(address);return this.i18n(isGoogleProfileAddress?"removeFromChrome":"removeAddress")}onAddressMenuClick_(e){const item=e.model.item;this.activeAddress=Object.assign({},item);const dotsButton=e.target;this.$.addressSharedMenu.showAt(dotsButton)}onAddAddressClick_(e){e.preventDefault();this.activeAddress={fields:[]};this.showAddressDialog_=true}onAddressDialogClose_(){this.showAddressDialog_=false}onMenuEditAddressClick_(e){e.preventDefault();if(this.isAccountHomeAddress_(this.activeAddress)){this.onAccountHomeAddressClick_()}else if(this.isAccountWorkAddress_(this.activeAddress)){this.onAccountWorkAddressClick_()}else if(this.isAccountNameEmailAddress_(this.activeAddress)){this.onAccountNameEmailAddressClick_()}else{this.showAddressDialog_=true}this.$.addressSharedMenu.close()}onAddressRemoveConfirmationDialogClose_(){const wasDeletionConfirmed=this.shadowRoot.querySelector("settings-address-remove-confirmation-dialog").wasConfirmed();const isHomeOrWorkAddress=this.isAccountHomeAddress_(this.activeAddress)||this.isAccountWorkAddress_(this.activeAddress);const recordType=this.activeAddress?.metadata?.recordType;if(wasDeletionConfirmed){if(this.addresses.length===1){focusWithoutInk(this.$.addAddress)}else{const lastIndex=this.addresses.length-1;if(this.activeAddress.guid===this.addresses[lastIndex].guid){focusWithoutInk(this.$.addressList.querySelectorAll(".address-menu")[lastIndex-1])}}this.autofillManager_.removeAddress(this.activeAddress.guid);if(isHomeOrWorkAddress){getInstance().announce(loadTimeData.getString("homeAndWorkAddressRemovedMessage"))}else if(this.isAccountNameEmailAddress_(this.activeAddress)){getInstance().announce(loadTimeData.getString("nameEmailAddressRemovedMessage"))}else{getInstance().announce(loadTimeData.getString("addressRemovedMessage"))}}if(recordType){this.recordDeletionMetrics_(wasDeletionConfirmed,recordType)}this.showAddressRemoveConfirmationDialog_=false}onMenuRemoveAddressClick_(){this.showAddressRemoveConfirmationDialog_=true;this.$.addressSharedMenu.close()}hasSome_(list){return!!(list&&list.length)}saveAddress_(event){this.autofillManager_.saveAddress(event.detail)}isAccountHomeAddress_(address){return address.metadata?.recordType===chrome.autofillPrivate.AddressRecordType.ACCOUNT_HOME}isAccountWorkAddress_(address){return address.metadata?.recordType===chrome.autofillPrivate.AddressRecordType.ACCOUNT_WORK}isAccountNameEmailAddress_(address){return address.metadata?.recordType===chrome.autofillPrivate.AddressRecordType.ACCOUNT_NAME_EMAIL}computeIsGoogleProfileAddress_(address){if(!address){return false}return this.isAccountHomeAddress_(address)||this.isAccountWorkAddress_(address)||this.isAccountNameEmailAddress_(address)}onAccountHomeAddressClick_(){OpenWindowProxyImpl.getInstance().openUrl(this.i18n("googleAccountHomeAddressUrl"))}onAccountWorkAddressClick_(){OpenWindowProxyImpl.getInstance().openUrl(this.i18n("googleAccountWorkAddressUrl"))}onAccountNameEmailAddressClick_(){OpenWindowProxyImpl.getInstance().openUrl(this.i18n("googleAccountNameEmailAddressEditUrl"))}isCloudOffVisible_(address,accountInfo){if(address.metadata?.recordType===chrome.autofillPrivate.AddressRecordType.ACCOUNT||address.metadata?.recordType===chrome.autofillPrivate.AddressRecordType.ACCOUNT_HOME||address.metadata?.recordType===chrome.autofillPrivate.AddressRecordType.ACCOUNT_WORK||address.metadata?.recordType===chrome.autofillPrivate.AddressRecordType.ACCOUNT_NAME_EMAIL){return false}if(!accountInfo){return false}if(accountInfo.isSyncEnabledForAutofillProfiles){return false}return true}shouldShowAddressIcon_(address,accountInfo){return this.getAddressIcon_(address,accountInfo).length>0}getAddressIcon_(address,accountInfo){if(loadTimeData.getBoolean("enableSupportForHomeAndWork")){if(this.isAccountHomeAddress_(address)){return"settings20:home"}if(this.isAccountWorkAddress_(address)){return"settings20:work"}}if(this.isCloudOffVisible_(address,accountInfo)){return"cr20:cloud-off"}return""}getA11yLabelForIcon_(address,accountInfo){if(this.isCloudOffVisible_(address,accountInfo)){return this.i18n("localAddressIconA11yLabel")}if(this.isAccountHomeAddress_(address)){return this.i18n("homeAddressIconA11yLabel")}if(this.isAccountWorkAddress_(address)){return this.i18n("workAddressIconA11yLabel")}return""}moreActionsTitle_(address){const label=address.metadata?.summaryLabel;const subLabel=address.metadata?.summarySublabel;const fullLabel=label+(subLabel??"");let messageKey;if(this.isAccountHomeAddress_(address)){messageKey="moreOptionsForHomeAddress"}else if(this.isAccountWorkAddress_(address)){messageKey="moreOptionsForWorkAddress"}else{messageKey="moreActionsForAddress"}return this.i18n(messageKey,fullLabel)}isAutofillSyncToggleVisible_(accountInfo){return!!accountInfo?.isAutofillSyncToggleAvailable}getRecordTypeSuffix_(recordType){switch(recordType){case chrome.autofillPrivate.AddressRecordType.LOCAL_OR_SYNCABLE:return"LocalOrSyncable";case chrome.autofillPrivate.AddressRecordType.ACCOUNT:return"Account";case chrome.autofillPrivate.AddressRecordType.ACCOUNT_HOME:return"AccountHome";case chrome.autofillPrivate.AddressRecordType.ACCOUNT_WORK:return"AccountWork";case chrome.autofillPrivate.AddressRecordType.ACCOUNT_NAME_EMAIL:return"AccountNameEmail";default:assertNotReached()}}recordDeletionMetrics_(wasDeletionConfirmed,recordType){const suffix=this.getRecordTypeSuffix_(recordType);chrome.metricsPrivate.recordBoolean("Autofill.ProfileDeleted.Settings.Total",wasDeletionConfirmed);chrome.metricsPrivate.recordBoolean("Autofill.ProfileDeleted.Any.Total",wasDeletionConfirmed);chrome.metricsPrivate.recordBoolean("Autofill.ProfileDeleted.Settings."+suffix,wasDeletionConfirmed);chrome.metricsPrivate.recordBoolean("Autofill.ProfileDeleted.Any."+suffix,wasDeletionConfirmed)}onAutofillSyncEnabledChange_(){assert(this.accountInfo_&&this.accountInfo_.isAutofillSyncToggleAvailable);this.autofillManager_.setAutofillSyncToggleEnabled(this.$.autofillSyncToggle.checked)}onAutofillProfileToggleChanged_(){const value=this.$.autofillProfileToggle.checked?AutofillAddressOptInChange.OPT_IN:AutofillAddressOptInChange.OPT_OUT;chrome.metricsPrivate.recordEnumerationValue("Autofill.Address.IsEnabled.Change",value,AutofillAddressOptInChange.COUNT)}onPlusAddressClick_(){chrome.metricsPrivate.recordUserAction("Settings.ManageOptionOnSettingsSelected");OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("plusAddressManagementUrl"))}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsAutofillSectionElement.is,SettingsAutofillSectionElement);function getTemplate$2e(){return html`<!--_html_template_start_--><style include="settings-shared passwords-shared md-select action-link">cr-icon-button{--cr-icon-button-icon-size:16px;margin-inline-start:2px}#footnote{margin-inline-start:2px;margin-top:16px}cr-input{--cr-input-error-display:none}#websiteInput[invalid].has-error-message,#usernameInput{margin-top:var(--cr-form-field-bottom-spacing)}#usernameInput[invalid]{--cr-input-error-display:block;margin-top:var(--cr-form-field-bottom-spacing)}</style>

<cr-dialog id="dialog" close-text="$i18n{close}" show-on-attach>
  <div slot="title" id="title">$i18n{editPasskeyDialogTitle}</div>
  <div slot="body">
    <cr-input id="websiteInput" label="$i18n{editPasskeySiteLabel}"
        placeholder="[[relyingPartyId]]" readonly="true">
    </cr-input>
    <cr-input id="usernameInput" label="$i18n{editPasskeyUsernameLabel}"
        value="{{username}}" invalid="[[usernameInputInvalid_]]"
        error-message="[[usernameInputErrorMessage_]]">
    </cr-input>
    <div id="footnote">[[dialogFootnote_]]</div>
  </div>
  <div slot="button-container">
    <cr-button id="cancel" class="cancel-button" on-click="onCancel_">
      $i18n{cancel}
    </cr-button>
    <cr-button id="actionButton" class="action-button"
        on-click="onSaveButtonClick_" disabled="[[usernameInputInvalid_]]">
      $i18n{save}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}const PasskeyEditDialogElementBase=I18nMixin(PolymerElement);class PasskeyEditDialogElement extends PasskeyEditDialogElementBase{static get is(){return"passkey-edit-dialog"}static get template(){return getTemplate$2e()}static get properties(){return{username:String,relyingPartyId:String,usernameInputErrorMessage_:String,dialogFootnote_:String,usernameInputInvalid_:{type:Boolean,computed:"computeUsernameInputInvalid_(username)"}}}ready(){super.ready();this.dialogFootnote_=this.i18n("passkeyEditDialogFootnote",this.relyingPartyId)}onSaveButtonClick_(){this.dispatchEvent(new CustomEvent("saved-passkey-edited",{bubbles:true,composed:true,detail:this.username}));this.close()}computeUsernameInputInvalid_(){if(this.username.length===0){this.usernameInputErrorMessage_=this.i18n("passkeyLengthError");return true}return false}onCancel_(){this.$.dialog.cancel()}close(){this.$.dialog.close()}}customElements.define(PasskeyEditDialogElement.is,PasskeyEditDialogElement);class PasskeysBrowserProxyImpl{hasPasskeys(){return sendWithPromise("passkeysHasPasskeys")}enumerate(){return sendWithPromise("passkeysEnumerate")}delete(credentialId){return sendWithPromise("passkeysDelete",credentialId)}edit(credentialId,newUsername){return sendWithPromise("passkeysEdit",credentialId,newUsername)}static getInstance(){return passkeysProxyInstance||(passkeysProxyInstance=new PasskeysBrowserProxyImpl)}static setInstance(obj){passkeysProxyInstance=obj}}let passkeysProxyInstance=null;function getTemplate$2d(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared passwords-shared">#passkeys-list-header{padding-inline-end:calc(var(--cr-icon-ripple-size) + var(--cr-icon-button-margin-start))}#iconContainer{height:24px;line-height:100%;margin-inline-end:20px;padding:4px;width:24px}</style>

<settings-subpage page-title="$i18n{managePasskeysTitle}"
    search-label="$i18n{managePasskeysSearch}"
    search-term="{{filter_}}">
<template is="dom-if" if="[[noManagement_]]">
  <div id="error" class="cr-row first">
    <div id="iconContainer">
      <cr-icon icon="cr:info"></cr-icon>
    </div>
    <p>$i18n{managePasskeysNoSupport}</p>
  </div>
</template>

<div class="cr-row first cr-secondary-text">
  $i18n{managePasskeysSubTitle}
</div>

<div class="list-frame">
  <div id="passkeys-list-header"
       class="list-item column-header right-pad"
       aria-hidden="true">
    <div class="website-column">$i18n{editPasskeySiteLabel}</div>
    <div class="username-column">$i18n{editPasskeyUsernameLabel}</div>
  </div>
  <div class="cr-separators list-with-header">
    <template is="dom-repeat" items="[[passkeys_]]"
        filter="[[filterFunction_(filter_)]]">
      <div class="list-item" focus-row-container>
        <div class="website-column no-min-width">
          <site-favicon url="[[getIconUrl_(item)]]"></site-favicon>
          <span class="text-elide elide-left">[[item.relyingPartyId]]</span>
        </div>

        <div id="username" class="username-column no-min-width text-elide">
          [[item.userName]]
        </div>

         <cr-icon-button id="moreActionsButton" class="icon-more-vert"
            data-credential-id$="[[item.credentialId]]"
            on-click="onDotsClick_" title="[[getMoreActionsLabel_(item)]]"
            focus-row-control focus-type="moreActionsButton"></cr-icon-button>
      </div>
    </template>
  </div>
</div>

<cr-action-menu id="menu" role-description="$i18n{menu}">
  
    <button class="dropdown-item" on-click="onEditClick_" id="edit">
      $i18n{edit}
    </button>
  
  <button class="dropdown-item" on-click="onDeleteClick_" id="delete">
    $i18n{delete}
  </button>
</cr-action-menu>

<cr-lazy-render id="deleteErrorDialog">
  <template>
    <cr-dialog close-text="$i18n{close}">
      <div slot="title">$i18n{managePasskeysCannotDeleteTitle}</div>
      <div slot="body">$i18n{managePasskeysCannotDeleteBody}</div>
      <div slot="button-container">
        <cr-button class="action-button" on-click="onErrorDialogOkClick_">
          $i18n{ok}
        </cr-button>
      </div>
    </cr-dialog>
  </template>
</cr-lazy-render>

<template is="dom-if" if="[[showDeleteConfirmationDialog_]]" restamp>
  <settings-simple-confirmation-dialog id="deleteConfirmDialog"
      title-text="$i18n{managePasskeysDeleteConfirmationTitle}"
      body-text="$i18n{managePasskeysDeleteConfirmationDescription}"
      confirm-text="$i18n{delete}" no-primary-button
      on-close="onConfirmDialogClose_">
  </settings-simple-confirmation-dialog>
</template>

  <template is="dom-if" if="[[showEditDialog_]]" restamp>
    <passkey-edit-dialog id="editPasskeyDialog" existing-entry="[[credential]]"
        on-saved-passkey-edited="onSavedPasskeyEdited_"
        relying-party-id="[[relyingPartyId_]]" username="[[username_]]"
        on-close="onEditDialogClose_">
    </passkey-edit-dialog>
  </template>

</settings-subpage>
<!--_html_template_end_-->`}const SettingsPasskeysSubpageElementBase=SettingsViewMixin(PolymerElement);class SettingsPasskeysSubpageElement extends SettingsPasskeysSubpageElementBase{static get is(){return"settings-passkeys-subpage"}static get template(){return getTemplate$2d()}static get properties(){return{filter_:{type:String,value:""},passkeys_:Array,showDeleteConfirmationDialog_:Boolean,noManagement_:Boolean,showEditDialog_:Boolean,username_:String,relyingPartyId_:String}}credentialIdForActionMenu_;browserProxy_=PasskeysBrowserProxyImpl.getInstance();ready(){super.ready();this.browserProxy_.enumerate().then(this.onEnumerateComplete_.bind(this))}filterFunction_(){return passkey=>[passkey.relyingPartyId,passkey.userName].some((str=>str.toLowerCase().includes(this.filter_.trim().toLowerCase())))}onEnumerateComplete_(passkeys){if(passkeys===null){this.noManagement_=true;this.passkeys_=[];return}this.passkeys_=passkeys}getIconUrl_(passkey){if(["@",":","/"].every((c=>passkey.relyingPartyId.indexOf(c)===-1))){return"https://"+passkey.relyingPartyId+"/"}return""}onDotsClick_(e){this.credentialIdForActionMenu_=e.target.dataset["credentialId"];this.$.menu.showAt(e.target,{anchorAlignmentY:AnchorAlignment.AFTER_END});const existingEntry=this.passkeys_.find((entry=>entry.credentialId===this.credentialIdForActionMenu_));this.username_=existingEntry.userName;this.relyingPartyId_=existingEntry.relyingPartyId}onDeleteClick_(){assert(this.credentialIdForActionMenu_);this.$.menu.close();this.showDeleteConfirmationDialog_=true}onConfirmDialogClose_(){const dialog=this.shadowRoot.querySelector("settings-simple-confirmation-dialog");assert(dialog);const confirmed=dialog.wasConfirmed();this.showDeleteConfirmationDialog_=false;if(confirmed){assert(this.credentialIdForActionMenu_);this.browserProxy_.delete(this.credentialIdForActionMenu_).then(this.onDeleteComplete_.bind(this,this.credentialIdForActionMenu_))}this.credentialIdForActionMenu_=null}onDeleteComplete_(deletedCredentialId,newPasskeys){if(newPasskeys!==null&&newPasskeys.findIndex((cred=>cred.credentialId===deletedCredentialId))!==-1){this.$.deleteErrorDialog.get().showModal()}this.onEnumerateComplete_(newPasskeys)}onErrorDialogOkClick_(){this.$.deleteErrorDialog.get().close()}getMoreActionsLabel_(passkey){return loadTimeData.getStringF("managePasskeysMoreActionsLabel",passkey.userName,passkey.relyingPartyId)}onEditClick_(){this.shadowRoot.querySelector("cr-action-menu").close();this.showEditDialog_=true}onEditDialogClose_(){this.showEditDialog_=false}onEditComplete_(newPasskeys){this.onEnumerateComplete_(newPasskeys)}onSavedPasskeyEdited_(event){assert(this.credentialIdForActionMenu_);this.browserProxy_.edit(this.credentialIdForActionMenu_,event.detail).then(this.onEditComplete_.bind(this))}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsPasskeysSubpageElement.is,SettingsPasskeysSubpageElement);function getTemplate$2c(){return html`<!--_html_template_start_-->    <style include="cr-shared-style settings-shared md-select">cr-input{--cr-input-error-display:block;margin-bottom:0;width:var(--cr-default-input-max-width)}.md-select+.md-select{margin-inline-start:8px}#numberInput{margin-bottom:10px}#month{width:70px}#cvcInput{width:132px}#cvcImage{margin-inline-start:10px}#saved-to-this-device-only-label{margin-bottom:10px;margin-top:0}#year{width:100px}#nicknameInput{--cr-input-width:var(--cr-default-input-max-width);width:fit-content}#charCount{font-size:var(--cr-form-field-label-font-size);line-height:var(--cr-form-field-label-line-height);padding-inline-start:8px}#nicknameInput:not(:focus-within) #charCount{display:none}#expiredError{display:block;font-size:var(--cr-form-field-label-font-size);height:var(--cr-form-field-label-height);line-height:var(--cr-form-field-label-line-height);margin:8px 0;visibility:hidden}:host([expired_]) #expiredError{visibility:visible}#expiredError,:host([expired_]) #expiration{color:var(--google-red-600)}@media (prefers-color-scheme:dark){#expiredError,:host([expired_]) #expiration{color:var(--google-red-300)}}
    </style>
    <cr-dialog id="dialog" close-text="$i18n{close}">
      <div slot="title">[[title_]]</div>
      <div slot="body">
        <cr-input id="numberInput" label="$i18n{creditCardNumber}"
            on-blur="onNumberInputBlurred_"
            invalid="[[showErrorForCardNumber_(cardNumberValidationState_)]]"
            error-message="$i18n{creditCardNumberInvalid}"
            value="{{rawCardNumber_}}" autofocus>
        </cr-input>
        <!-- aria-hidden for creditCardExpiration label since
          creditCardExpirationMonth and creditCardExpirationYear provide
          sufficient labeling. -->
        <label id='expiration' class="cr-form-field-label" aria-hidden="true">
          $i18n{creditCardExpiration}
        </label>
        <select class="md-select" id="month" value="[[expirationMonth_]]"
            on-change="onMonthChange_"
            aria-label="$i18n{creditCardExpirationMonth}"
            aria-invalid$="[[getExpirationAriaInvalid_(expired_)]]">
          <template is="dom-repeat" items="[[monthList_]]">
            <option>[[item]]</option>
          </template>
        </select>
        <select class="md-select" id="year" value="[[expirationYear_]]"
            on-change="onYearChange_"
            aria-label="$i18n{creditCardExpirationYear}"
            aria-invalid$="[[getExpirationAriaInvalid_(expired_)]]">
          <template is="dom-repeat" items="[[yearList_]]">
            <option>[[item]]</option>
          </template>
        </select>
        <div id="expiredError">$i18n{creditCardExpired}</div>
        <template is="dom-if"
            if="[[checkIfCvcStorageIsAvailable_(
                  prefs.autofill.payment_cvc_storage.value,
                  cvcStorageAvailable_)]]">
          <cr-input id="cvcInput" label="$i18n{creditCardCvcInputTitle}"
              placeholder="$i18n{creditCardCvcInputPlaceholder}"
              value="{{cvc_}}">
            <img slot="suffix" id="cvcImage"
                src="[[getCvcImageSource_(sanitizedCardNumber_)]]"
                title="[[getCvcImageTooltip_(sanitizedCardNumber_)]]">
            </img>
          </cr-input>
        </template>
        <!-- Place cardholder name field and nickname field after CVC input.-->
        <cr-input id="nameInput" label="$i18n{creditCardName}"
            value="{{name_}}" spellcheck="false">
        </cr-input>
        <cr-input id="nicknameInput" label="$i18n{creditCardNickname}"
            value="{{nickname_}}" spellcheck="false" maxlength="25"
            on-input="validateNickname_"
            invalid="[[nicknameInvalid_]]"
            error-message="$i18n{creditCardNicknameInvalid}"
            aria-description="[[i18n('inputMaxLengthDescription', 25)]]">
            <div id="charCount" slot="suffix" aria-hidden="true">
              [[computeNicknameCharCount_(nickname_)]]/25
            </div>
        </cr-input>
        <div id="saved-to-this-device-only-label">
          $i18n{savedToThisDeviceOnly}
        </div>
      </div>
      <div slot="button-container">
        <cr-button id="cancelButton" class="cancel-button"
            on-click="onCancelButtonClick_">$i18n{cancel}</cr-button>
        <cr-button id="saveButton" class="action-button"
            on-click="onSaveButtonClick_"
            disabled="[[!saveEnabled_(nicknameInvalid_, cardNumberValidationState_,
                expired_, name_, sanitizedCardNumber_, nickname_)]]">
          $i18n{save}
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`}const NICKNAME_INVALID_REGEX=new RegExp(".*\\d+.*");var CardNumberValidationState;(function(CardNumberValidationState){CardNumberValidationState["VALID"]="valid";CardNumberValidationState["INVALID_NO_ERROR"]="invalid-no-error";CardNumberValidationState["INVALID_WITH_ERROR"]="invalid-with-error"})(CardNumberValidationState||(CardNumberValidationState={}));const SettingsCreditCardEditDialogElementBase=I18nMixin(PolymerElement);class SettingsCreditCardEditDialogElement extends SettingsCreditCardEditDialogElementBase{static get is(){return"settings-credit-card-edit-dialog"}static get template(){return getTemplate$2c()}static get properties(){return{prefs:Object,creditCard:Object,title_:String,monthList_:{type:Array,value:["01","02","03","04","05","06","07","08","09","10","11","12"]},yearList_:Array,name_:String,rawCardNumber_:String,cvc_:String,nickname_:String,expirationYear_:String,expirationMonth_:String,sanitizedCardNumber_:{type:String,computed:"sanitizeCardNumber_(rawCardNumber_)",observer:"onSanitizedCardNumberChanged_"},nicknameInvalid_:{type:Boolean,value:false},cardNumberValidationState_:{type:CardNumberValidationState,value:false},expired_:{type:Boolean,computed:"computeExpired_(expirationMonth_, expirationYear_)",reflectToAttribute:true,observer:"onExpiredChanged_"},cvcStorageAvailable_:{type:Boolean,value(){return loadTimeData.getBoolean("cvcStorageAvailable")}}}}connectedCallback(){super.connectedCallback();this.title_=this.i18n(this.creditCard.guid?"editCreditCardTitle":"addCreditCardTitle");if(this.creditCard.expirationMonth.length===1){this.creditCard.expirationMonth="0"+this.creditCard.expirationMonth}const date=new Date;let firstYear=date.getFullYear();let lastYear=firstYear+19;let selectedYear=parseInt(this.creditCard.expirationYear,10);if(!selectedYear){selectedYear=firstYear}else if(selectedYear<firstYear){firstYear=selectedYear}else if(selectedYear>lastYear){lastYear=selectedYear}const yearList=[];for(let i=firstYear;i<=lastYear;++i){yearList.push(i.toString())}this.yearList_=yearList;microTask.run((()=>{this.expirationYear_=selectedYear.toString();this.expirationMonth_=this.creditCard.expirationMonth;this.cvc_=this.creditCard.cvc;this.name_=this.creditCard.name;this.rawCardNumber_=this.creditCard.cardNumber||"";this.nickname_=this.creditCard.nickname;this.$.dialog.showModal()}))}close(){this.$.dialog.close()}onCancelButtonClick_(){this.$.dialog.cancel()}onSaveButtonClick_(){if(!this.saveEnabled_()){return}this.creditCard.expirationYear=this.expirationYear_;this.creditCard.expirationMonth=this.expirationMonth_;this.creditCard.name=this.name_;this.creditCard.cardNumber=this.sanitizedCardNumber_;this.creditCard.nickname=this.nickname_;this.creditCard.cvc=this.cvc_;this.trimCreditCard_();this.dispatchEvent(new CustomEvent("save-credit-card",{bubbles:true,composed:true,detail:this.creditCard}));this.close()}onSanitizedCardNumberChanged_(){this.cardNumberValidationState_=this.computeCardNumberValidationState_(this.sanitizedCardNumber_,false)}onNumberInputBlurred_(event){assert(event.type==="blur");this.cardNumberValidationState_=this.computeCardNumberValidationState_(this.sanitizedCardNumber_,true)}showErrorForCardNumber_(cardNumberValidationState){return cardNumberValidationState===CardNumberValidationState.INVALID_WITH_ERROR}onMonthChange_(){this.expirationMonth_=this.monthList_[this.$.month.selectedIndex]}onYearChange_(){this.expirationYear_=this.yearList_[this.$.year.selectedIndex]}onExpiredChanged_(){const errorElement=this.$.expiredError;const ERROR_ID=errorElement.id;if(this.expired_){errorElement.setAttribute("role","alert");this.shadowRoot.querySelector(`#month`).setAttribute("aria-errormessage",ERROR_ID);this.shadowRoot.querySelector(`#year`).setAttribute("aria-errormessage",ERROR_ID)}else{errorElement.removeAttribute("role");this.shadowRoot.querySelector(`#month`).removeAttribute("aria-errormessage");this.shadowRoot.querySelector(`#year`).removeAttribute("aria-errormessage")}}getExpirationAriaInvalid_(){return this.expired_?"true":"false"}checkIfCvcStorageIsAvailable_(cvcStorageToggleEnabled){return this.cvcStorageAvailable_&&cvcStorageToggleEnabled}getCvcImageSource_(){return this.isCardAmex_()?"chrome://settings/images/cvc_amex.svg":"chrome://settings/images/cvc.svg"}getCvcImageTooltip_(){return this.i18n(this.isCardAmex_()?"creditCardCvcAmexImageTitle":"creditCardCvcImageTitle")}validateNickname_(){this.nicknameInvalid_=NICKNAME_INVALID_REGEX.test(this.nickname_)}computeNicknameCharCount_(nickname){return(nickname||"").length}saveEnabled_(){if(this.cardNumberValidationState_!==CardNumberValidationState.VALID){return false}return!this.expired_&&!this.nicknameInvalid_}computeExpired_(){if(this.expirationYear_===undefined||this.expirationMonth_===undefined){return false}const now=new Date;const expirationYear=parseInt(this.expirationYear_,10);const expirationMonth=parseInt(this.expirationMonth_,10);return expirationYear<now.getFullYear()||expirationYear===now.getFullYear()&&expirationMonth<=now.getMonth()}trimCreditCard_(){if(this.creditCard.name){this.creditCard.name=this.creditCard.name.trim()}if(this.creditCard.cardNumber){this.creditCard.cardNumber=this.creditCard.cardNumber.trim()}if(this.creditCard.nickname){this.creditCard.nickname=this.creditCard.nickname.trim()}}isCardAmex_(){const cardNumber=this.sanitizedCardNumber_;return!!cardNumber&&cardNumber.length>=2&&!!cardNumber.match("^(34|37)")}sanitizeCardNumber_(cardNumber){return cardNumber?cardNumber.trim().replaceAll(/ |-/g,""):""}computeCardNumberValidationState_(sanitizedCardNumber,isBlur=false){if(/[^\d]/.test(sanitizedCardNumber)){return CardNumberValidationState.INVALID_WITH_ERROR}if(isBlur){return sanitizedCardNumber.length>=12&&sanitizedCardNumber.length<=19&&this.passesLuhnCheck_(sanitizedCardNumber)?CardNumberValidationState.VALID:CardNumberValidationState.INVALID_WITH_ERROR}if(sanitizedCardNumber.length>19){return CardNumberValidationState.INVALID_WITH_ERROR}if(sanitizedCardNumber.length>=16){return this.passesLuhnCheck_(sanitizedCardNumber)?CardNumberValidationState.VALID:CardNumberValidationState.INVALID_WITH_ERROR}if(sanitizedCardNumber.length>=12){return this.passesLuhnCheck_(sanitizedCardNumber)?CardNumberValidationState.VALID:CardNumberValidationState.INVALID_NO_ERROR}return CardNumberValidationState.INVALID_NO_ERROR}passesLuhnCheck_(cardNumber){let sum=0;let odd=false;const cardNumberDigits=cardNumber.split("").reverse();for(const digit of cardNumberDigits){let intDigit=Number(digit);if(Number.isNaN(intDigit)){return false}if(odd){intDigit*=2;sum+=Math.floor(intDigit/10)+intDigit%10}else{sum+=intDigit}odd=!odd}return sum%10===0}}customElements.define(SettingsCreditCardEditDialogElement.is,SettingsCreditCardEditDialogElement);function getTemplate$2b(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared">cr-input{--cr-input-error-display:block;margin-bottom:0;width:var(--cr-default-input-max-width)}div[slot='button-container']{padding-top:0}#saved-to-this-device-only-label{margin-bottom:26px;margin-top:0}#charCount{font-size:var(--cr-form-field-label-font-size);line-height:var(--cr-form-field-label-line-height);padding-inline-start:8px}#nicknameInput:not(:focus-within) #charCount{--cr-input-width:var(--cr-default-input-max-width);display:none;width:fit-content}</style>
<cr-dialog id="dialog" close-text="$i18n{close}">
  <div slot="title">[[title_]]</div>
  <div slot="body">
    <cr-input id="valueInput" label="$i18n{addPaymentMethodIban}"
        on-blur="onIbanInputBlurred_"
        invalid="[[showErrorForIban_(ibanValidationState_)]]"
        error-message="$i18n{ibanInvalid}"
        value="{{value_}}" autofocus>
    </cr-input>
    <cr-input id="nicknameInput" label="$i18n{ibanNickname}"
        value="{{nickname_}}" spellcheck="false" maxlength="25"
        aria-description="[[i18n('inputMaxLengthDescription', 25)]]">
      <div id="charCount" slot="suffix">
        [[computeNicknameCharCount_(nickname_)]]/25
      </div>
    </cr-input>
    <div id="saved-to-this-device-only-label">
      $i18n{ibanSavedToThisDeviceOnly}
    </div>
  </div>
  <div slot="button-container">
    <cr-button id="cancelButton" class="cancel-button"
        on-click="onCancelButtonClick_">$i18n{cancel}</cr-button>
    <cr-button id="saveButton" class="action-button"
        on-click="onIbanSaveButtonClick_">
      $i18n{save}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}var IbanValidationState;(function(IbanValidationState){IbanValidationState["VALID"]="valid";IbanValidationState["INVALID_NO_ERROR"]="invalid-no-error";IbanValidationState["INVALID_WITH_ERROR"]="invalid-with-error"})(IbanValidationState||(IbanValidationState={}));const SettingsIbanEditDialogElementBase=I18nMixin(PolymerElement);class SettingsIbanEditDialogElement extends SettingsIbanEditDialogElementBase{static get is(){return"settings-iban-edit-dialog"}static get template(){return getTemplate$2b()}static get properties(){return{iban:{type:Object,value:null},title_:String,value_:String,nickname_:String,sanitizedIban_:{type:String,computed:"sanitizeIban_(value_)",observer:"onSanitizedIbanChanged_"},ibanValidationState_:{type:IbanValidationState,value:false}}}paymentsManager_=PaymentsManagerImpl.getInstance();connectedCallback(){super.connectedCallback();if(this.iban){this.value_=this.iban.value;this.nickname_=this.iban.nickname;this.title_=this.i18n("editIbanTitle")}else{this.title_=this.i18n("addIbanTitle");this.$.saveButton.disabled=true}this.$.dialog.showModal()}close(){this.$.dialog.close()}onCancelButtonClick_(){this.$.dialog.cancel()}onIbanSaveButtonClick_(){const iban={guid:this.iban?.guid,value:this.sanitizedIban_,nickname:this.nickname_?this.nickname_.trim():""};this.dispatchEvent(new CustomEvent("save-iban",{bubbles:true,composed:true,detail:iban}));this.close()}async onSanitizedIbanChanged_(){this.ibanValidationState_=await this.computeIbanValidationState_(false);this.$.saveButton.disabled=this.ibanValidationState_!==IbanValidationState.VALID}async onIbanInputBlurred_(event){assert(event.type==="blur");this.ibanValidationState_=await this.computeIbanValidationState_(true)}showErrorForIban_(ibanValidationState){return ibanValidationState===IbanValidationState.INVALID_WITH_ERROR}sanitizeIban_(value){return value?value.replace(/\s/g,""):""}async computeIbanValidationState_(isBlur){const isValid=await this.isValidIban();if(isValid){return IbanValidationState.VALID}return this.sanitizedIban_.length>=24||isBlur?IbanValidationState.INVALID_WITH_ERROR:IbanValidationState.INVALID_NO_ERROR}async isValidIban(){if(!this.sanitizedIban_){return false}return this.paymentsManager_.isValidIban(this.sanitizedIban_)}computeNicknameCharCount_(){return(this.nickname_||"").length}}customElements.define(SettingsIbanEditDialogElement.is,SettingsIbanEditDialogElement);const styleMod$4=document.createElement("dom-module");styleMod$4.appendChild(html`
  <template>
    <style>
.screen-reader-only{clip-path:inset(100%);position:fixed}.screen-reader-only-host-node{position:relative}.screen-reader-only-host-node .screen-reader-only{height:100%;overflow:hidden;position:absolute;width:100%}
    </style>
  </template>
`.content);styleMod$4.register("screen-reader-only");function getTemplate$2a(){return html`<!--_html_template_start_-->    <style include="settings-shared passwords-shared screen-reader-only">.expiration-column,.misc-column{align-items:center;display:flex}.misc-column{justify-content:flex-end}.list-item{margin-bottom:8px;margin-top:8px}.sub-label{color:var(--cr-secondary-text-color)}#paymentsIcon{vertical-align:middle}#cardImage{margin-inline-end:16px;vertical-align:middle}
    </style>
    <div class="list-item" role="row">
      <div class="type-column" role="cell">
        <img id="cardImage" srcset="[[getCardImage_(creditCard.imageSrc)]]" alt="">
        <div class="summary-column screen-reader-only-host-node">
          <div class="screen-reader-only">
            [[getCardIdentifierAriaLabel_(creditCard)]],
            [[getSummaryAriaLabel_(creditCard)]],
            [[getSummaryAriaSublabel_(creditCard)]]
          </div>
          <template is="dom-if" if="[[!shouldShowNewFopDisplay_()]]">
            <div id="summaryLabel" class="ellipses" aria-hidden="true">
              [[creditCard.metadata.summaryLabel]]
            </div>
          </template>
          <template is="dom-if" if="[[shouldShowNewFopDisplay_()]]">
            <div>
              <span id="label" class="ellipses" aria-hidden="true">
                [[creditCard.metadata.summaryLabel]]
              </span>
              <template is="dom-if" if="[[hasCardIdentifier_(creditCard)]]">
                <div class="sub-label" aria-hidden="true">
                  <span id="summaryLabel_1">
                    [[creditCard.metadata.summarySublabel]]
                  </span>
                  <span id="summaryLabel_2">
                    [[getExpirationlabel_(creditCard)]]
                  </span>
                </div>
              </template>
              <template is="dom-if" if="[[!hasCardIdentifier_(creditCard)]]">
                <span id="expirationLabel" class="sub-label">
                  [[getExpirationlabel_(creditCard)]]
                </span>
              </template>
            </div>
          </template>
          <div id="summarySublabel" class="sub-label">
            <span aria-hidden="true">[[getSummarySublabel_(creditCard)]]</span>
            <template is="dom-if"
                if="[[hasSummaryAndBenefitSublabel_(creditCard)]]">
              |
            </template>
            <template is="dom-if" if="[[isCardBenefitsProductUrlAvailable_(creditCard)]]">
              <a id="summaryTermsLink"
                aria-label="[[getBenefitsTermsAriaLabel_(creditCard)]]"
                aria-description="$i18n{opensInNewTab}"
                on-click="onSummarySublabelTermsLinkClick_"
                href="[[getCardBenefitsProductUrl_(creditCard)]]"
                target="_blank">$i18n{benefitsTermsTagForCreditCardListEntry}</a>
            </template>
          </div>
        </div>
      </div>
      <div class="expiration-column">
        <div role="cell" class="misc-column">
          <div id="paymentsIndicator"
              hidden$="[[!shouldShowPaymentsIndicator_(creditCard.metadata)]]">
            
            
              <span class="sub-label">
                $i18n{googlePayments}
              </span>
            
          </div>
          <template is="dom-if" if="[[showDots_(creditCard.metadata)]]">
            <cr-icon-button class="icon-more-vert" id="creditCardMenu"
                title="[[moreActionsTitle_(creditCard)]]"
                on-click="onDotsMenuClick_">
            </cr-icon-button>
          </template>
          <template is="dom-if" if="[[!showDots_(creditCard.metadata)]]">
            <cr-icon-button class="icon-external" id="remoteCreditCardLink"
                title="$i18n{remotePaymentMethodsLinkLabel}" role="link"
                on-click="onRemoteEditClick_"
                aria-description="$i18n{opensInNewTab}"></cr-icon-button>
          </template>
        </div>
      </div>
    </div>
<!--_html_template_end_-->`}const SettingsCreditCardListEntryElementBase=I18nMixin(PolymerElement);class SettingsCreditCardListEntryElement extends SettingsCreditCardListEntryElementBase{static get is(){return"settings-credit-card-list-entry"}static get template(){return getTemplate$2a()}static get properties(){return{creditCard:Object,showNewFopDisplayEnabled_:{type:Boolean,value(){return loadTimeData.getBoolean("enableNewFopDisplay")},readOnly:true}}}get dotsMenu(){return this.shadowRoot.getElementById("creditCardMenu")}onDotsMenuClick_(){this.dispatchEvent(new CustomEvent("dots-card-menu-click",{bubbles:true,composed:true,detail:{creditCard:this.creditCard,anchorElement:this.shadowRoot.querySelector("#creditCardMenu")}}))}onRemoteEditClick_(){this.dispatchEvent(new CustomEvent("remote-card-menu-click",{bubbles:true,composed:true,detail:{creditCard:this.creditCard,anchorElement:this.shadowRoot.querySelector("#creditCardMenu")}}))}onSummarySublabelTermsLinkClick_(){MetricsBrowserProxyImpl.getInstance().recordAction(CardBenefitsUserAction.CARD_BENEFITS_TERMS_LINK_CLICKED)}getCardNumberDescription_(creditCard){const cardNumber=creditCard.cardNumber;if(cardNumber){const lastFourDigits=cardNumber.substring(Math.max(0,cardNumber.length-4));if(lastFourDigits){const network=creditCard.network||this.i18n("genericCreditCard");return this.i18n("creditCardDescription",network,lastFourDigits)}}return undefined}moreActionsTitle_(){const cardDescription=this.creditCard.nickname||this.getCardNumberDescription_(this.creditCard)||this.creditCard.name;return this.i18n(this.creditCard.cvc?"moreActionsForCreditCardWithCvc":"moreActionsForCreditCard",cardDescription)}shouldShowNewFopDisplay_(){return this.showNewFopDisplayEnabled_}hasCardIdentifier_(){return(this.creditCard.metadata.summarySublabel||"").length>0}showDots_(){return!!(this.creditCard.metadata.isLocal||this.isVirtualCardEnrollmentEligible_())}isVirtualCardEnrollmentEligible_(){return this.creditCard.metadata.isVirtualCardEnrollmentEligible}isVirtualCardEnrolled_(){return this.creditCard.metadata.isVirtualCardEnrolled}getCardIdentifierAriaLabel_(){return this.creditCard.metadata.summaryLabel||""}getSummaryAriaLabel_(){const cardNumberDescription=this.getCardNumberDescription_(this.creditCard);if(cardNumberDescription){return this.i18n("creditCardA11yLabeled",cardNumberDescription)}return this.creditCard.metadata.summaryLabel}getBenefitsTermsAriaLabel_(){const cardNumberDescription=this.getCardNumberDescription_(this.creditCard);if(cardNumberDescription){return this.i18n("benefitsTermsAriaLabel",cardNumberDescription)}return this.i18n("benefitsTermsTagForCreditCardListEntry")}getCardExpiryDate_(){assert(this.creditCard.expirationMonth);assert(this.creditCard.expirationYear);return this.creditCard.expirationMonth+"/"+this.creditCard.expirationYear.toString().substring(2)}getCardSublabelType(){if(this.isVirtualCardEnrolled_()){if(this.isCardCvcAvailable_()){return this.isCardBenefitsProductUrlAvailable_()?7:6}return this.isCardBenefitsProductUrlAvailable_()?5:4}if(this.isCardCvcAvailable_()){return this.isCardBenefitsProductUrlAvailable_()?3:2}return this.isCardBenefitsProductUrlAvailable_()?1:0}getExpirationlabel_(){return" · "+this.getCardExpiryDate_()}getSummarySublabel_(){const separator=" | ";let summarySublabel=this.isVirtualCardEnrolled_()?this.i18n("virtualCardTurnedOn"):this.shouldShowNewFopDisplay_()?"":this.getCardExpiryDate_();if(this.isCardCvcAvailable_()){if(summarySublabel.length>0){summarySublabel+=separator}summarySublabel+=this.i18n("cvcTagForCreditCardListEntry")}return summarySublabel}hasSummaryAndBenefitSublabel_(){return this.getSummarySublabel_().length>0&&this.isCardBenefitsProductUrlAvailable_()}getSummaryAriaSublabel_(){switch(this.getCardSublabelType()){case 7:case 5:case 6:case 4:return this.shouldShowNewFopDisplay_()?this.i18n("creditCardExpDateA11yLabeled",this.getCardExpiryDate_())+this.getSummarySublabel_():this.getSummarySublabel_();case 3:case 1:case 2:case 0:return this.i18n("creditCardExpDateA11yLabeled",this.shouldShowNewFopDisplay_()?this.getCardExpiryDate_():this.getSummarySublabel_());default:assertNotReached()}}shouldShowVirtualCardSecondarySublabel_(){return this.creditCard.metadata.summarySublabel.trim()!==""||this.isVirtualCardEnrolled_()||this.isVirtualCardEnrollmentEligible_()}shouldShowPaymentsIndicator_(){return!this.creditCard.metadata.isLocal}isCardCvcAvailable_(){return loadTimeData.getBoolean("cvcStorageAvailable")&&!!this.creditCard.cvc}isCardBenefitsProductUrlAvailable_(){return!!this.creditCard.productTermsUrl}getCardBenefitsProductUrl_(){return this.creditCard.productTermsUrl||""}getCardImage_(imageSrc){return imageSrc.startsWith("chrome://theme")?this.getScaledSrcSet_(imageSrc):imageSrc}getScaledSrcSet_(url){return`${url} 1x, ${url}@2x 2x`}}customElements.define(SettingsCreditCardListEntryElement.is,SettingsCreditCardListEntryElement);function getTemplate$29(){return html`<!--_html_template_start_--><style include="settings-shared passwords-shared screen-reader-only">.second-column{align-items:center;display:flex;flex:1;justify-content:flex-end}.list-item{margin-bottom:8px;margin-top:8px}.sub-label{color:var(--cr-secondary-text-color)}#ibanImage{margin-inline-end:16px;vertical-align:middle}</style>
<div class="list-item type-column" role="row">
  <img id="ibanImage" src="[[getIbanImageSrc_(showNewFopDisplayEnabled_)]]" alt="">
  <div class="summary-column screen-reader-only-host-node" role="cell">
    <div class="screen-reader-only">
      [[getA11yIbanDescription_(iban)]], [[iban.nickname]]
    </div>
    <div id="label" class="ellipses" aria-hidden="true">
      [[getLabel_(iban)]]
    </div>
    <div id="subLabel" class="ellipses sub-label" aria-hidden="true">
      [[getSubLabel_(iban)]]
    </div>
  </div>
  <div role="cell" class="second-column">
    <div id="paymentsIndicator"
        hidden$="[[!shouldShowGooglePaymentsIndicator_(iban.metadata)]]">


        <span class="sub-label">$i18n{googlePayments}</span>

    </div>
    <template is="dom-if" if="[[showDotsMenu_(iban.metadata)]]">
      <cr-icon-button class="icon-more-vert" id="ibanMenu"
          title="[[getMoreActionsTitle_(iban)]]" on-click="onDotsMenuClick_">
      </cr-icon-button>
    </template>
    <template is="dom-if" if="[[!showDotsMenu_(iban.metadata)]]">
      <cr-icon-button class="icon-external" id="remoteIbanLink"
          title="$i18n{remotePaymentMethodsLinkLabel}" role="link"
          on-click="onRemoteEditClick_"
          aria-description="$i18n{opensInNewTab}"></cr-icon-button>
    </template>
  </div>
</div>
<!--_html_template_end_-->`}const SettingsIbanListEntryElementBase=I18nMixin(PolymerElement);class SettingsIbanListEntryElement extends SettingsIbanListEntryElementBase{static get is(){return"settings-iban-list-entry"}static get template(){return getTemplate$29()}static get properties(){return{iban:Object,showNewFopDisplayEnabled_:{type:Boolean,value(){return loadTimeData.getBoolean("enableNewFopDisplay")},readOnly:true}}}get dotsMenu(){return this.shadowRoot.getElementById("ibanMenu")}showDotsMenu_(){return!!this.iban.metadata.isLocal}shouldShowGooglePaymentsIndicator_(){return!this.iban.metadata.isLocal}getScaledSrcSet_(url){return`${url} 1x, ${url}@2x 2x`}onDotsMenuClick_(){this.dispatchEvent(new CustomEvent("dots-iban-menu-click",{bubbles:true,composed:true,detail:{iban:this.iban,anchorElement:this.dotsMenu}}))}onRemoteEditClick_(){this.dispatchEvent(new CustomEvent("remote-iban-menu-click",{bubbles:true,composed:true,detail:{iban:this.iban,anchorElement:this.dotsMenu}}))}getA11yIbanDescription_(iban){const strippedSummaryLabel=iban.metadata?iban.metadata.summaryLabel.replace(/\s/g,""):"";const lastFourDigits=strippedSummaryLabel.substring(Math.max(0,strippedSummaryLabel.length-4));return this.i18n("a11yIbanDescription",lastFourDigits)}getIbanImageSrc_(){return this.showNewFopDisplayEnabled_?"chrome://settings/images/iban.svg":"chrome://settings/images/iban_old.svg"}getLabel_(iban){if(this.showNewFopDisplayEnabled_&&iban.nickname){return iban.nickname}return iban.metadata.summaryLabel}getSubLabel_(iban){if(this.showNewFopDisplayEnabled_&&iban.nickname){return iban.metadata.summaryLabel}return iban.nickname||""}getMoreActionsTitle_(iban){return this.i18n("moreActionsForIban",iban.nickname||this.getA11yIbanDescription_(iban))}}customElements.define(SettingsIbanListEntryElement.is,SettingsIbanListEntryElement);function getTemplate$28(){return html`<!--_html_template_start_--><style include="settings-shared passwords-shared screen-reader-only">.misc-column{align-items:center;display:flex;justify-content:flex-end}.list-item{margin-bottom:8px;margin-top:8px}.sub-label{color:var(--cr-secondary-text-color)}#paymentsIcon{vertical-align:middle}#payOverTimeIssuerImage{line-height:0;margin-inline-end:16px;vertical-align:middle}</style>

<div class="list-item" role="row">
  <div class="type-column" role="cell">
    <picture id="payOverTimeIssuerImage">
      <source
          srcset="[[getIssuerImage_(payOverTimeIssuer.imageSrcDark)]]"
          media="(prefers-color-scheme: dark)">
      <img alt="" srcset="[[getIssuerImage_(payOverTimeIssuer.imageSrc)]]">
    </picture>
    <div class="summary-column screen-reader-only-host-node" role="cell">
      <div id="summaryLabel" class="ellipses">
        [[payOverTimeIssuer.displayName]]
      </div>
    </div>
  </div>
  <div class="misc-column" role="cell">
    <div id="paymentsIndicator">


      <span class="sub-label">$i18n{googlePayments}</span>

    </div>
    <cr-icon-button class="icon-external" id="remotePayOverTimeIssuerLink"
        title="$i18n{remotePaymentMethodsLinkLabel}" role="link"
        on-click="onRemoteEditClick_"
        aria-description="$i18n{opensInNewTab}"></cr-icon-button>
  </div>
</div>
<!--_html_template_end_-->`}class SettingsPayOverTimeIssuerListEntryElement extends PolymerElement{static get is(){return"settings-pay-over-time-issuer-list-entry"}static get template(){return getTemplate$28()}static get properties(){return{payOverTimeIssuer:Object}}getIssuerImage_(imageSrc){return imageSrc.startsWith("chrome://theme")?this.getScaledSrcSet_(imageSrc):imageSrc}getScaledSrcSet_(url){return`${url} 1x, ${url}@2x 2x`}onRemoteEditClick_(){OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("managePaymentMethodsUrl"))}}customElements.define(SettingsPayOverTimeIssuerListEntryElement.is,SettingsPayOverTimeIssuerListEntryElement);function getTemplate$27(){return html`<!--_html_template_start_-->    <style include="settings-shared passwords-shared">.expiration-column{align-items:center;display:flex;flex:1}.vertical-list:has(.payment-method)~.vertical-list:has(.payment-method){border-top:var(--cr-separator-line);width:100%}
    </style>
    <div role="table">
      <div class="vertical-list list-with-header" role="rowgroup">
        <template is="dom-repeat" items="[[creditCards]]">
          <settings-credit-card-list-entry id="[[getCreditCardId_(index)]]"
              class="payment-method" credit-card="[[item]]">
          </settings-credit-card-list-entry>
        </template>
      </div>
      <div class="vertical-list list-with-header" role="rowgroup">
        <template is="dom-repeat" items="[[ibans]]">
          <settings-iban-list-entry id="[[getIbanId_(index)]]"
              class="payment-method" iban="[[item]]">
          </settings-iban-list-entry>
        </template>
      </div>
      <div class="vertical-list list-with-header" role="rowgroup">
        <template is="dom-repeat" items="[[payOverTimeIssuers]]">
          <settings-pay-over-time-issuer-list-entry class="payment-method"
              pay-over-time-issuer="[[item]]">
          </settings-pay-over-time-issuer-list-entry>
        </template>
      </div>
    </div>
    <div id="noPaymentMethodsLabel" class="list-item"
        hidden$="[[showAnyPaymentMethods_]]">
      $i18n{noPaymentMethodsFound}
    </div>
<!--_html_template_end_-->`}class SettingsPaymentsListElement extends PolymerElement{static get is(){return"settings-payments-list"}static get template(){return getTemplate$27()}static get properties(){return{creditCards:Array,ibans:Array,payOverTimeIssuers:Array,enableIbans_:{type:Boolean,value(){return loadTimeData.getBoolean("showIbansSettings")}},enablePayOverTime_:{type:Boolean,value(){return loadTimeData.getBoolean("shouldShowPayOverTimeSettings")}},showAnyPaymentMethods_:{type:Boolean,value:false,computed:"computeShowAnyPaymentMethods_("+"creditCards, ibans, enableIbans_, payOverTimeIssuers, enablePayOverTime_)"}}}updateFocusBeforeCreditCardRemoval(cardIndex){if(cardIndex===this.creditCards.length-1){return this.updateFocusBeforeRemoval_(this.getCreditCardId_(cardIndex))}else{return true}}updateFocusBeforeIbanRemoval(ibanIndex){if(ibanIndex===this.ibans.length-1){return this.updateFocusBeforeRemoval_(this.getIbanId_(ibanIndex))}else{return true}}updateFocusBeforeRemoval_(id){const paymentMethods=this.shadowRoot.querySelectorAll(".payment-method");if(paymentMethods.length<=1){return false}const index=[...paymentMethods].findIndex((element=>element.id===id));const isLastItem=index===paymentMethods.length-1;const indexToFocus=index+(isLastItem?-1:+1);const menu=paymentMethods[indexToFocus].dotsMenu;if(menu){focusWithoutInk(menu);return true}return false}getCreditCardId_(index){return`card-${index}`}getIbanId_(index){return`iban-${index}`}hasSome_(list){return!!(list&&list.length)}showCreditCards_(){return this.hasSome_(this.creditCards)}showIbans_(){return this.enableIbans_&&this.hasSome_(this.ibans)}showPayOverTimeIssuers_(){return this.enablePayOverTime_&&this.hasSome_(this.payOverTimeIssuers)}computeShowAnyPaymentMethods_(){return this.showCreditCards_()||this.showIbans_()||this.showPayOverTimeIssuers_()}}customElements.define(SettingsPaymentsListElement.is,SettingsPaymentsListElement);function getTemplate$26(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared"></style>
<cr-dialog id="dialog" show-on-attach close-text="$i18n{close}">
  <div slot="title">$i18n{unenrollVirtualCardDialogTitle}</div>
  <div slot="body">
    <div class="cr-padded-text">$i18nRaw{unenrollVirtualCardDialogLabel}</div>
  </div>
  <div slot="button-container">
    <cr-button id="cancelButton" class="cancel-button"
        on-click="onCancelButtonClick_">$i18n{cancel}</cr-button>
    <cr-button id="confirmButton" class="action-button"
        on-click="onConfirmButtonClick_">
      $i18n{unenrollVirtualCardDialogConfirm}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}class SettingsVirtualCardUnenrollDialogElement extends PolymerElement{static get is(){return"settings-virtual-card-unenroll-dialog"}static get template(){return getTemplate$26()}static get properties(){return{creditCard:Object}}close(){this.$.dialog.close()}onCancelButtonClick_(){this.$.dialog.cancel()}onConfirmButtonClick_(){this.dispatchEvent(new CustomEvent("unenroll-virtual-card",{bubbles:true,composed:true,detail:this.creditCard.guid}));this.close()}}customElements.define(SettingsVirtualCardUnenrollDialogElement.is,SettingsVirtualCardUnenrollDialogElement);function getTemplate$25(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared passwords-shared
    your-saved-info-shared">#cardBenefitsToggle{display:none}.expiration-column{align-items:center;display:flex;flex:1}.arrow-icon-down{fill:currentColor;flex-shrink:0;margin-inline-start:6px;margin-inline-end:-6px;width:var(--cr-icon-size)}.payment-list-margin-start{padding-inline-start:20px}
</style>
<settings-subpage page-title="[[getPageTitleLabel_(isYourSavedInfoSubpage_)]]"
    hide-close-button="[[hideCloseButton]]"
    learn-more-url="$i18n{addressesAndPaymentMethodsLearnMoreURL}"
    class$="[[getMultiCardClass_(isYourSavedInfoSubpage_)]]">

<div class="card">
<settings-toggle-button id="autofillCreditCardToggle"
    no-extension-indicator label="$i18n{enableCreditCardsLabel}"
    sub-label="$i18n{enableCreditCardsSublabel}"
    pref="{{prefs.autofill.credit_card_enabled}}">
</settings-toggle-button>

  <settings-toggle-button id="mandatoryAuthToggle"
      no-extension-indicator label="$i18n{enableMandatoryAuthToggleLabel}"
      sub-label="$i18n{enableMandatoryAuthToggleSublabel}"
      pref="{{prefs.autofill.payment_methods_mandatory_reauth}}" no-set-pref
      disabled="[[shouldDisableAuthToggle_(
                prefs.autofill.credit_card_enabled.value, deviceAuthAvailable_)]]"
      on-settings-boolean-control-change="onMandatoryAuthToggleChange_">
  </settings-toggle-button>

<template is="dom-if" if="[[cvcStorageAvailable_]]">
  <settings-toggle-button id="cvcStorageToggle"
        no-extension-indicator label="$i18n{enableCvcStorageLabel}"
        aria-label="[[getCvcStorageAriaLabel_(creditCards)]]"
        sub-label-with-link="[[getCvcStorageSublabel_(creditCards)]]"
        disabled="[[!prefs.autofill.credit_card_enabled.value]]"
        on-sub-label-link-clicked="onBulkRemoveCvcClick_"
        pref="{{prefs.autofill.payment_cvc_storage}}">
    </settings-toggle-button>
</template>
<template is="dom-if" if="[[cardBenefitsFlagEnabled_]]">
  <settings-toggle-button id="cardBenefitsToggle"
      no-extension-indicator label="$i18n{cardBenefitsLabel}"
      sub-label-with-link="[[cardBenefitsSublabel_]]"
      on-sub-label-link-clicked="onCardBenefitsSublabelLinkClick_"
      disabled="[[!prefs.autofill.credit_card_enabled.value]]"
      pref="{{prefs.autofill.payment_card_benefits}}">
  </settings-toggle-button>
</template>
<template is="dom-if" if="[[shouldShowPayOverTimeSettings_]]">
  <settings-toggle-button id="payOverTimeToggle"
      no-extension-indicator label="$i18n{autofillPayOverTimeSettingsLabel}"
      sub-label-with-link="[[payOverTimeSublabel_]]"
      on-sub-label-link-clicked="onPayOverTimeSublabelLinkClick_"
      disabled="[[!prefs.autofill.credit_card_enabled.value]]"
      pref="{{prefs.autofill.bnpl_enabled}}">
  </settings-toggle-button>
</template>
<settings-toggle-button id="canMakePaymentToggle"
    aria-label="$i18n{canMakePaymentToggleLabel}"
    label="$i18n{canMakePaymentToggleLabel}"
    pref="{{prefs.payments.can_make_payment_enabled}}"
    on-settings-boolean-control-change="onCanMakePaymentChange_">
</settings-toggle-button>
<template is="dom-if"
    if="[[prefs.autofill.credit_card_enabled.extensionId]]">
  <div class="cr-row continuation">
    <extension-controlled-indicator class="flex"
        id="autofillExtensionIndicator"
        extension-id="[[prefs.autofill.credit_card_enabled.extensionId]]"
        extension-name="[[
            prefs.autofill.credit_card_enabled.controlledByName]]"
        extension-can-be-disabled="[[
            prefs.autofill.credit_card_enabled.extensionCanBeDisabled]]">
    </extension-controlled-indicator>
  </div>
</template>

<div id="manageLink" class="cr-row first" hidden>
  <!-- This span lays out the link correctly, relative to the text. -->
  <div class="cr-padded-text">$i18nRaw{manageCreditCardsLabel}</div>
</div>

</div>

<div class="card">

<div class="cr-row continuation">
  <h2 class="flex">$i18n{creditCards}</h2>
  <template is="dom-if"
      if="[[!shouldShowIbanSettings_(showIbanSettingsEnabled_)]]">
    <cr-button id="addCreditCard" class="header-aligned-button"
        on-click="onAddCreditCardClick_" aria-label="$i18n{addCreditCardTitle}"
        hidden$="[[!prefs.autofill.credit_card_enabled.value]]">
      $i18n{add}
    </cr-button>
  </template>
  <template is="dom-if"
      if="[[shouldShowIbanSettings_(showIbanSettingsEnabled_)]]">
    <cr-button class="header-aligned-button"
        id="addPaymentMethods" on-click="onAddPaymentMethodClick_"
        aria-label="$i18n{addPaymentMethods}"
        hidden$="[[!prefs.autofill.credit_card_enabled.value]]">
      $i18n{add}
      <cr-icon icon="cr:arrow-drop-down" class="arrow-icon-down"></cr-icon>
    </cr-button>
    <cr-lazy-render id="paymentMethodsActionMenu">
      <template>
        <cr-action-menu role-description="$i18n{menu}">
          <button id="addCreditCard" class="dropdown-item"
              on-click="onAddCreditCardClick_">
            $i18n{addPaymentMethodCreditOrDebitCard}
          </button>
          <button id="addIban" class="dropdown-item"
              on-click="onAddIbanClick_">
            $i18n{addPaymentMethodIban}
          </button>
        </cr-action-menu>
      </template>
    </cr-lazy-render>
  </template>
</div>
<settings-payments-list id="paymentsList"
    class="list-frame payment-list-margin-start"
    credit-cards="[[creditCards]]"
    ibans="[[ibans]]"
    pay-over-time-issuers="[[payOverTimeIssuers]]"
    on-dots-iban-menu-click="onDotsIbanMenuClick_"
    on-remote-iban-menu-click="onRemoteEditIbanMenuClick_"
    on-dots-card-menu-click="onCreditCardDotsMenuClick_"
    on-remote-card-menu-click="onRemoteEditCreditCardClick_"
    aria-label="$i18n{paymentsMethodsTableAriaLabel}">
</settings-payments-list>

<cr-action-menu id="creditCardSharedMenu" role-description="$i18n{menu}">
  <button id="menuEditCreditCard" class="dropdown-item"
      on-click="onMenuEditCreditCardClick_">
    [[getMenuEditCardText_(activeCreditCard_.metadata.isLocal)]]
  </button>

  <button id="menuRemoveCreditCard" class="dropdown-item"
      hidden$="[[!activeCreditCard_.metadata.isLocal]]"
      on-click="onMenuRemoveCreditCardClick_">$i18n{delete}</button>

  <button id="menuAddVirtualCard" class="dropdown-item"
      on-click="onMenuAddVirtualCardClick_"
      hidden$="[[!shouldShowAddVirtualCardButton_(activeCreditCard_)]]">
    $i18n{addVirtualCard}
  </button>
  <button id="menuRemoveVirtualCard" class="dropdown-item"
      on-click="onMenuRemoveVirtualCardClick_"
      hidden$="[[!shouldShowRemoveVirtualCardButton_(activeCreditCard_)]]">
    $i18n{removeVirtualCard}
  </button>
</cr-action-menu>

<cr-lazy-render id="ibanSharedActionMenu">
  <template>
    <cr-action-menu id="ibanSharedMenu" role-description="$i18n{menu}">
      <button id="menuEditIban" class="dropdown-item"
          on-click="onMenuEditIbanClick_">
        $i18n{editIban}
      </button>
      <button id="menuRemoveIban" class="dropdown-item"
          on-click="onMenuRemoveIbanClick_">
        $i18n{delete}
      </button>
    </cr-action-menu>
  </template>
</cr-lazy-render>

<template is="dom-if" if="[[showCreditCardDialog_]]" restamp>
  <settings-credit-card-edit-dialog credit-card="[[activeCreditCard_]]"
      on-close="onCreditCardDialogClose_" on-save-credit-card="saveCreditCard_"
      prefs="{{prefs}}">
  </settings-credit-card-edit-dialog>
</template>
<template is="dom-if" if="[[showIbanDialog_]]" restamp>
  <settings-iban-edit-dialog iban="[[activeIban_]]"
      on-close="onIbanDialogClose_" on-save-iban="onSaveIban_">
  </settings-iban-edit-dialog>
</template>

<template is="dom-if" if="[[showVirtualCardUnenrollDialog_]]" restamp>
  <settings-virtual-card-unenroll-dialog credit-card="[[activeCreditCard_]]"
      on-close="onVirtualCardUnenrollDialogClose_"
      on-unenroll-virtual-card="unenrollVirtualCard_">
  </settings-virtual-card-unenroll-dialog>
</template>

<template is="dom-if" if="[[showLocalCreditCardRemoveConfirmationDialog_]]"
    restamp>
  <settings-simple-confirmation-dialog id="localCardDeleteConfirmDialog"
      title-text="$i18n{removeLocalCreditCardConfirmationTitle}"
      body-text="$i18n{removeLocalPaymentMethodConfirmationDescription}"
      confirm-text="$i18n{delete}"
      on-close="onLocalCreditCardRemoveConfirmationDialogClose_">
  </settings-simple-confirmation-dialog>
</template>

<template is="dom-if" if="[[showLocalIbanRemoveConfirmationDialog_]]" restamp>
  <settings-simple-confirmation-dialog id="localIbanDeleteConfirmationDialog"
      title-text="$i18n{removeLocalIbanConfirmationTitle}"
      body-text="$i18n{removeLocalPaymentMethodConfirmationDescription}"
      confirm-text="$i18n{delete}"
      on-close="onLocalIbanRemoveConfirmationDialogClose_">
  </settings-simple-confirmation-dialog>
</template>

<template is="dom-if" if="[[showBulkRemoveCvcConfirmationDialog_]]" restamp>
  <settings-simple-confirmation-dialog id="bulkDeleteCvcConfirmDialog"
      title-text="$i18n{bulkRemoveCvcConfirmationTitle}"
      body-text="$i18n{bulkRemoveCvcConfirmationDescription}"
      confirm-text="$i18n{delete}"
      on-close="onShowBulkRemoveCvcConfirmationDialogClose_">
  </settings-simple-confirmation-dialog>
</template>

</div>

</settings-subpage>
<!--_html_template_end_-->`}const SettingsPaymentsSectionElementBase=SettingsViewMixin(I18nMixin(PolymerElement));class SettingsPaymentsSectionElement extends SettingsPaymentsSectionElementBase{static get is(){return"settings-payments-section"}static get template(){return getTemplate$25()}static get properties(){return{prefs:Object,hideCloseButton:{type:Boolean,value:false},creditCards:{type:Array,value:()=>[]},ibans:{type:Array,value:()=>[]},payOverTimeIssuers:{type:Array,value:()=>[]},showIbanSettingsEnabled_:{type:Boolean,value(){return loadTimeData.getBoolean("showIbansSettings")},readOnly:true},activeCreditCard_:Object,activeIban_:Object,showCreditCardDialog_:Boolean,showIbanDialog_:Boolean,showLocalCreditCardRemoveConfirmationDialog_:Boolean,showLocalIbanRemoveConfirmationDialog_:Boolean,showVirtualCardUnenrollDialog_:Boolean,showBulkRemoveCvcConfirmationDialog_:Boolean,deviceAuthAvailable_:{type:Boolean,value(){return loadTimeData.getBoolean("deviceAuthAvailable")}},cvcStorageAvailable_:{type:Boolean,value(){return loadTimeData.getBoolean("cvcStorageAvailable")}},cardBenefitsFlagEnabled_:{type:Boolean,value(){return loadTimeData.getBoolean("autofillCardBenefitsAvailable")}},cardBenefitsSublabel_:{type:String,value(){return loadTimeData.getString("cardBenefitsToggleSublabel")}},shouldShowPayOverTimeSettings_:{type:Boolean,value(){return loadTimeData.getBoolean("shouldShowPayOverTimeSettings")},readOnly:true},payOverTimeSublabel_:{type:String,value(){return loadTimeData.getString("autofillPayOverTimeSettingsSublabel")}},isYourSavedInfoSubpage_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableYourSavedInfoSettingsPage")}}}paymentsManager_=PaymentsManagerImpl.getInstance();setPersonalDataListener_=null;connectedCallback(){super.connectedCallback();const setCreditCardsListener=cardList=>{this.setCreditCards_(cardList)};const setPersonalDataListener=(_addressList,cardList,ibanList,payOverTimeIssuerList)=>{this.setCreditCards_(cardList);this.ibans=ibanList;if(this.shouldShowPayOverTimeSettings_){this.payOverTimeIssuers=payOverTimeIssuerList}};const setIbansListener=ibanList=>{this.ibans=ibanList};this.setPersonalDataListener_=setPersonalDataListener;this.paymentsManager_.getCreditCardList().then(setCreditCardsListener);this.paymentsManager_.getIbanList().then(setIbansListener);if(this.shouldShowPayOverTimeSettings_){this.paymentsManager_.getPayOverTimeIssuerList().then((issuers=>{this.payOverTimeIssuers=issuers}))}this.paymentsManager_.setPersonalDataManagerListener(setPersonalDataListener);this.paymentsManager_.checkIfDeviceAuthAvailable().then((result=>this.deviceAuthAvailable_=result));chrome.metricsPrivate.recordUserAction("AutofillCreditCardsViewed");const manageAccountAnchor=this.$.manageLink.querySelector("a");if(manageAccountAnchor!==null){manageAccountAnchor.addEventListener("click",(()=>{MetricsBrowserProxyImpl.getInstance().recordAction("Autofill.PaymentMethodsSettingsPage.ManagePaymentMethodsLinkClicked")}))}}disconnectedCallback(){super.disconnectedCallback();assert(this.setPersonalDataListener_);this.paymentsManager_.removePersonalDataManagerListener(this.setPersonalDataListener_);this.setPersonalDataListener_=null}getMultiCardClass_(){return this.isYourSavedInfoSubpage_?"multi-card":""}getPageTitleLabel_(){return this.i18n(this.isYourSavedInfoSubpage_?"paymentsTitle":"creditCards")}setCreditCards_(cardList){this.creditCards=cardList;const autofillEnabledPref=this.get("prefs.autofill.credit_card_enabled");if(!!autofillEnabledPref&&autofillEnabledPref.value){MetricsBrowserProxyImpl.getInstance().recordBooleanHistogram("Autofill.PaymentMethodsSettingsPage.CardsViewedWithoutExistingCards",this.creditCards.length===0)}}shouldShowIbanSettings_(){return this.showIbanSettingsEnabled_}onAddPaymentMethodClick_(e){const target=e.currentTarget;const menu=this.shadowRoot.querySelector("#paymentMethodsActionMenu").get();assert(menu);menu.showAt(target,{anchorAlignmentX:AnchorAlignment.BEFORE_END,anchorAlignmentY:AnchorAlignment.AFTER_END,noOffset:true})}onCreditCardDotsMenuClick_(e){this.activeCreditCard_=e.detail.creditCard;this.$.creditCardSharedMenu.showAt(e.detail.anchorElement)}onDotsIbanMenuClick_(e){this.activeIban_=e.detail.iban;this.$.ibanSharedActionMenu.get().showAt(e.detail.anchorElement)}onAddCreditCardClick_(e){e.preventDefault();MetricsBrowserProxyImpl.getInstance().recordBooleanHistogram("Autofill.PaymentMethodsSettingsPage.AddCardClicked2",true);MetricsBrowserProxyImpl.getInstance().recordBooleanHistogram("Autofill.PaymentMethodsSettingsPage.AddCardClickedWithoutExistingCards2",this.creditCards.length===0);const date=new Date;const expirationMonth=date.getMonth()+1;this.activeCreditCard_={expirationMonth:expirationMonth.toString(),expirationYear:date.getFullYear().toString()};this.showCreditCardDialog_=true;if(this.showIbanSettingsEnabled_){const menu=this.shadowRoot.querySelector("#paymentMethodsActionMenu").get();assert(menu);menu.close()}}onCreditCardDialogClose_(){this.showCreditCardDialog_=false;this.activeCreditCard_=null}onAddIbanClick_(e){e.preventDefault();this.showIbanDialog_=true;const menu=this.shadowRoot.querySelector("#paymentMethodsActionMenu").get();assert(menu);menu.close()}onIbanDialogClose_(){this.showIbanDialog_=false;this.activeIban_=null}async onMenuEditCreditCardClick_(e){e.preventDefault();assert(this.activeCreditCard_);if(this.activeCreditCard_.metadata.isLocal){const unmaskedCreditCard=await this.paymentsManager_.getLocalCard(this.activeCreditCard_.guid);assert(unmaskedCreditCard);this.activeCreditCard_=unmaskedCreditCard;this.showCreditCardDialog_=true}else{this.onRemoteCreditCardUrlClick_()}this.$.creditCardSharedMenu.close()}onRemoteEditCreditCardClick_(e){this.activeCreditCard_=e.detail.creditCard;this.onRemoteCreditCardUrlClick_()}onRemoteCreditCardUrlClick_(){this.paymentsManager_.logServerCardLinkClicked();const url=new URL(loadTimeData.getString("managePaymentMethodsUrl"));assert(this.activeCreditCard_);if(this.activeCreditCard_.instrumentId){url.searchParams.append("id",this.activeCreditCard_.instrumentId)}OpenWindowProxyImpl.getInstance().openUrl(url.toString())}onRemoteEditIbanMenuClick_(e){this.activeIban_=e.detail.iban;this.paymentsManager_.logServerIbanLinkClicked();const url=new URL(loadTimeData.getString("managePaymentMethodsUrl"));assert(this.activeIban_);if(this.activeIban_.instrumentId){url.searchParams.append("id",this.activeIban_.instrumentId)}OpenWindowProxyImpl.getInstance().openUrl(url.toString())}onLocalCreditCardRemoveConfirmationDialogClose_(){const confirmationDialog=this.shadowRoot.querySelector("#localCardDeleteConfirmDialog");assert(confirmationDialog);if(confirmationDialog.wasConfirmed()){assert(this.activeCreditCard_);assert(this.activeCreditCard_.guid);const index=this.creditCards.findIndex((card=>card.guid===this.activeCreditCard_.guid));if(!this.$.paymentsList.updateFocusBeforeCreditCardRemoval(index)){this.focusHeaderControls_()}this.paymentsManager_.removeCreditCard(this.activeCreditCard_.guid);this.activeCreditCard_=null}this.showLocalCreditCardRemoveConfirmationDialog_=false}onMenuRemoveCreditCardClick_(){this.showLocalCreditCardRemoveConfirmationDialog_=true;this.$.creditCardSharedMenu.close()}onMenuEditIbanClick_(e){e.preventDefault();this.showIbanDialog_=true;this.$.ibanSharedActionMenu.get().close()}onLocalIbanRemoveConfirmationDialogClose_(){const confirmationDialog=this.shadowRoot.querySelector("#localIbanDeleteConfirmationDialog");assert(confirmationDialog);if(confirmationDialog.wasConfirmed()){assert(this.activeIban_);assert(this.activeIban_.guid);const index=this.ibans.findIndex((iban=>iban.guid===this.activeIban_.guid));if(!this.$.paymentsList.updateFocusBeforeIbanRemoval(index)){this.focusHeaderControls_()}this.paymentsManager_.removeIban(this.activeIban_.guid);this.activeIban_=null}this.showLocalIbanRemoveConfirmationDialog_=false}onMenuRemoveIbanClick_(){assert(this.activeIban_);this.showLocalIbanRemoveConfirmationDialog_=true;this.$.ibanSharedActionMenu.get().close()}onMenuAddVirtualCardClick_(){this.paymentsManager_.addVirtualCard(this.activeCreditCard_.guid);this.$.creditCardSharedMenu.close();this.activeCreditCard_=null}onMenuRemoveVirtualCardClick_(){this.showVirtualCardUnenrollDialog_=true;this.$.creditCardSharedMenu.close()}onVirtualCardUnenrollDialogClose_(){this.showVirtualCardUnenrollDialog_=false;this.activeCreditCard_=null}onCanMakePaymentChange_(){MetricsBrowserProxyImpl.getInstance().recordSettingsPageHistogram(PrivacyElementInteractions.PAYMENT_METHOD)}saveCreditCard_(event){this.paymentsManager_.saveCreditCard(event.detail)}onSaveIban_(event){this.paymentsManager_.saveIban(event.detail)}getMenuEditCardText_(isLocalCard){return this.i18n(isLocalCard?"edit":"editServerCard")}shouldShowAddVirtualCardButton_(){if(this.activeCreditCard_===null||!this.activeCreditCard_.metadata){return false}return!!this.activeCreditCard_.metadata.isVirtualCardEnrollmentEligible&&!this.activeCreditCard_.metadata.isVirtualCardEnrolled}shouldShowRemoveVirtualCardButton_(){if(this.activeCreditCard_===null||!this.activeCreditCard_.metadata){return false}return!!this.activeCreditCard_.metadata.isVirtualCardEnrollmentEligible&&!!this.activeCreditCard_.metadata.isVirtualCardEnrolled}unenrollVirtualCard_(event){this.paymentsManager_.removeVirtualCard(event.detail)}shouldDisableAuthToggle_(creditCardEnabled){return!creditCardEnabled||!this.deviceAuthAvailable_}focusHeaderControls_(){const element=this.shadowRoot.querySelector(".header-aligned-button");if(element){focusWithoutInk(element)}}onMandatoryAuthToggleChange_(e){const mandatoryAuthToggle=e.target;assert(mandatoryAuthToggle);mandatoryAuthToggle.checked=!mandatoryAuthToggle.checked;this.paymentsManager_.authenticateUserAndFlipMandatoryAuthToggle()}onBulkRemoveCvcClick_(){assert(this.cvcStorageAvailable_);MetricsBrowserProxyImpl.getInstance().recordAction(CvcDeletionUserAction.HYPERLINK_CLICKED);this.showBulkRemoveCvcConfirmationDialog_=true}onShowBulkRemoveCvcConfirmationDialogClose_(){assert(this.cvcStorageAvailable_);const confirmationDialog=this.shadowRoot.querySelector("#bulkDeleteCvcConfirmDialog");assert(confirmationDialog);MetricsBrowserProxyImpl.getInstance().recordAction(confirmationDialog.wasConfirmed()?CvcDeletionUserAction.DIALOG_ACCEPTED:CvcDeletionUserAction.DIALOG_CANCELLED);if(confirmationDialog.wasConfirmed()){this.paymentsManager_.bulkDeleteAllCvcs()}this.showBulkRemoveCvcConfirmationDialog_=false;const cvcStorageToggle=this.shadowRoot.querySelector("#cvcStorageToggle");assert(cvcStorageToggle);cvcStorageToggle.focus()}getCvcStorageSublabel_(){const card=this.creditCards.find((cc=>!!cc.cvc));return this.i18nAdvanced(card===undefined?"enableCvcStorageSublabel":"enableCvcStorageDeleteDataSublabel")}onCardBenefitsSublabelLinkClick_(){OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("cardBenefitsToggleLearnMoreUrl"))}getCvcStorageAriaLabel_(){const card=this.creditCards.find((cc=>!!cc.cvc));return this.i18n(card===undefined?"enableCvcStorageAriaLabelForNoCvcSaved":"enableCvcStorageLabel")}onPayOverTimeSublabelLinkClick_(){OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("autofillPayOverTimeSettingsLearnMoreUrl"))}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsPaymentsSectionElement.is,SettingsPaymentsSectionElement);function getTemplate$24(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared">:host{--cr-section-padding:0;--shown-avatar-size:40px}#avatarRow{max-width:280px}#userInfo{padding-top:0;padding-bottom:0}.account-icon{border-radius:50%;flex-shrink:0;height:var(--shown-avatar-size);width:var(--shown-avatar-size)}</style>

<template is="dom-if" if="[[shouldShowAccountIndicator_]]" restamp>
  <div id="avatarRow" class="cr-row first two-line">
    <img class="account-icon" alt=""
        src="[[getProfileImageSrc_(shownAccount_.avatarImage)]]">
    <div id="userInfo" class="cr-row-gap cr-padded-text flex no-min-width">
      <div class="text-elide">[[shownAccount_.fullName]]</div>
      <div class="text-elide secondary">[[shownAccount_.email]]</div>
    </div>
  </div>
</template><!--_html_template_end_-->`}function canDeleteAccountData(syncStatus){return isSignedIn(syncStatus)&&syncStatus.signedInState!==SignedInState.SIGNED_IN_PAUSED&&!isSyncPaused(syncStatus)}function isSignedIn(syncStatus){if(!syncStatus){return false}switch(syncStatus.signedInState){case SignedInState.SIGNED_IN_PAUSED:case SignedInState.SIGNED_IN:case SignedInState.SYNCING:return true;case SignedInState.WEB_ONLY_SIGNED_IN:case SignedInState.SIGNED_OUT:return false;default:assertNotReached("Invalid SignedInState")}}function isSyncPaused(syncStatus){return!!syncStatus.hasError&&!syncStatus.hasUnrecoverableError&&syncStatus.statusAction===StatusAction.REAUTHENTICATE}const SettingsClearBrowsingDataAccountIndicatorBase=WebUiListenerMixin(PolymerElement);class SettingsClearBrowsingDataAccountIndicator extends SettingsClearBrowsingDataAccountIndicatorBase{static get is(){return"settings-clear-browsing-data-account-indicator"}static get template(){return getTemplate$24()}static get properties(){return{shouldShowAccountIndicator_:{type:Boolean,value:false,computed:"computeShouldShowAvatarRow_(shownAccount_,"+"syncStatus_.signedInState)"},shownAccount_:String,syncStatus_:Object}}syncBrowserProxy_=SyncBrowserProxyImpl.getInstance();ready(){super.ready();this.syncBrowserProxy_.getStoredAccounts().then(this.handleStoredAccounts_.bind(this));this.syncBrowserProxy_.getSyncStatus().then(this.handleSyncStatus_.bind(this));this.addWebUiListener("stored-accounts-updated",this.handleStoredAccounts_.bind(this));this.addWebUiListener("sync-status-changed",this.handleSyncStatus_.bind(this))}handleStoredAccounts_(accounts){if(!accounts){this.shownAccount_=null;return}this.shownAccount_=accounts.length>0?accounts[0]:null}handleSyncStatus_(syncStatus){this.syncStatus_=syncStatus}computeShouldShowAvatarRow_(){if(!this.shownAccount_){return false}return canDeleteAccountData(this.syncStatus_)}getProfileImageSrc_(){assert(this.shownAccount_);return this.shownAccount_.avatarImage||"chrome://theme/IDR_PROFILE_AVATAR_PLACEHOLDER_LARGE"}}customElements.define(SettingsClearBrowsingDataAccountIndicator.is,SettingsClearBrowsingDataAccountIndicator);const styleMod$3=document.createElement("dom-module");styleMod$3.appendChild(html`
  <template>
    <style>
.spinner{--cr-spinner-size:28px;mask-image:url(//resources/images/throbber_small.svg);mask-position:center;mask-repeat:no-repeat;mask-size:var(--cr-spinner-size) var(--cr-spinner-size);background-color:var(--cr-spinner-color,var(--google-blue-500));height:var(--cr-spinner-size);width:var(--cr-spinner-size)}@media (prefers-color-scheme:dark){.spinner{background-color:var(--cr-spinner-color,var(--google-blue-300))}}
    </style>
  </template>
`.content);styleMod$3.register("cr-spinner-style");function getTemplate$23(){return html`<!--_html_template_start_--><style include="settings-shared"></style>

<cr-dialog id="dialog" close-text="$i18n{close}" show-on-attach>
  <div slot="title">$i18n{historyDeletionDialogTitle}</div>
  <div slot="body">$i18nRaw{historyDeletionDialogBody}</div>
  <div slot="button-container">
    <cr-button id="okButton" class="action-button" on-click="onOkClick_">
      $i18n{historyDeletionDialogOK}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}class SettingsHistoryDeletionDialogElement extends PolymerElement{static get is(){return"settings-history-deletion-dialog"}static get template(){return getTemplate$23()}onOkClick_(){this.$.dialog.close()}}customElements.define(SettingsHistoryDeletionDialogElement.is,SettingsHistoryDeletionDialogElement);function getTemplate$22(){return html`<!--_html_template_start_--><cr-dialog id="dialog" close-text="$i18n{close}" show-on-attach>
  <div slot="title">$i18n{passwordsDeletionDialogTitle}</div>
  <div slot="body">$i18nRaw{passwordsDeletionDialogBody}</div>
  <div slot="button-container">
    <cr-button class="action-button" on-click="onOkClick_">
      $i18n{ok}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`}class SettingsPasswordsDeletionDialogElement extends PolymerElement{static get is(){return"settings-passwords-deletion-dialog"}static get template(){return getTemplate$22()}onOkClick_(){this.$.dialog.close()}}customElements.define(SettingsPasswordsDeletionDialogElement.is,SettingsPasswordsDeletionDialogElement);function getTemplate$21(){return html`<!--_html_template_start_--><style include="cr-shared-style">#outerRow{align-items:center;display:flex;min-height:var(--cr-section-two-line-min-height);width:100%}#outerRow[noSubLabel]{min-height:var(--cr-section-min-height)}cr-checkbox{margin-bottom:4px;margin-top:var(--settings-checkbox-margin-top,4px);width:100%}cr-policy-pref-indicator{margin-inline-start:var(--cr-controlled-by-spacing)}a{color:var(--cr-link-color)}</style>
<div id="outerRow" noSubLabel$="[[!hasSubLabel_(subLabel, subLabelHtml)]]">
  <cr-checkbox id="checkbox" checked="{{checked}}"
      on-change="notifyChangedByUserInteraction"
      disabled="[[controlDisabled(disabled, pref.*)]]"
      aria-label="[[label]]">
    <div id="label">[[label]] <slot></slot></div>
    <div id="subLabel" class="cr-secondary-text">
      <div inner-h-t-m-l="[[sanitizeInnerHtml_(subLabelHtml)]]"
          on-click="onSubLabelClick_"></div>
      [[subLabel]]
    </div>
  </cr-checkbox>
  <template is="dom-if" if="[[pref.controlledBy]]">
    <cr-policy-pref-indicator pref="[[pref]]" icon-aria-label="[[label]]">
    </cr-policy-pref-indicator>
  </template>
</div>
<!--_html_template_end_-->`}const SettingsCheckboxElementBase=SettingsBooleanControlMixin(PolymerElement);class SettingsCheckboxElement extends SettingsCheckboxElementBase{static get is(){return"settings-checkbox"}static get template(){return getTemplate$21()}static get properties(){return{subLabelHtml:{type:String,value:""}}}static get observers(){return["onSubLabelChanged_(subLabel, subLabelHtml)"]}focus(){this.$.checkbox.focus()}onSubLabelChanged_(){this.$.checkbox.ariaDescription=this.$.subLabel.textContent}stopPropagation_(event){event.stopPropagation()}hasSubLabel_(subLabel,subLabelHtml){return!!subLabel||!!subLabelHtml}sanitizeInnerHtml_(rawString){return sanitizeInnerHtml(rawString,{attrs:["id","aria-label"]})}onSubLabelClick_(e){const target=e.target;if(target.tagName==="A"){this.dispatchEvent(new CustomEvent("sub-label-link-clicked",{bubbles:true,composed:true,detail:{id:target.id}}));e.preventDefault();e.stopPropagation()}}}customElements.define(SettingsCheckboxElement.is,SettingsCheckboxElement);function getTemplate$20(){return html`<!--_html_template_start_-->    <style include="settings-shared cr-spinner-style">:host{--body-container-height:322px}#clearBrowsingDataDialog{--border-top-color:var(--google-grey-300);--cr-dialog-top-container-min-height:42px;--cr-dialog-body-border-top:1px solid var(--border-top-color)}@media (prefers-color-scheme:dark){#clearBrowsingDataDialog{--border-top-color:var(--cr-separator-color)}}#clearBrowsingDataDialog:not(.fully-rendered){visibility:hidden}#clearBrowsingDataDialog [slot=title]{padding-bottom:8px}#clearBrowsingDataDialog::part(body-container){height:var(--body-container-height);min-height:200px}#clearBrowsingDataDialog [slot=body]{padding-top:8px}#clearBrowsingDataDialog [slot=footer]{background:var(--google-grey-50);border-top:none;padding:0}@media (prefers-color-scheme:dark){#clearBrowsingDataDialog [slot=footer]{background:rgb(50,54,57)}}.row{align-items:center;display:flex;min-height:40px}.spinner{margin-bottom:auto;margin-inline-end:16px;margin-top:auto}settings-checkbox{--cr-section-two-line-min-height:48px}#basicTab settings-checkbox+settings-checkbox{--settings-checkbox-margin-top:12px}cr-tabs{--cr-tabs-font-size:100%;--cr-tabs-height:40px}.time-range-row{margin-bottom:12px}.time-range-select{margin-inline-start:12px}.dropdown-error::part(select){border-color:var(--settings-error-color);color:var(--settings-error-color)}.dropdown-error::part(select):focus{outline-color:var(--settings-error-color)}[slot=title] .secondary{font-size:calc(13 / 15 * 100%);padding-top:8px}.divider{border-top:var(--cr-separator-line);margin:0 16px}#footerDescription{color:var(--cr-secondary-text-color);padding:16px}#clearingDataAlert{clip:rect(0,0,0,0);position:fixed}.search-history-box{background-color:var(--google-grey-50);border:1px solid var(--google-grey-200);border-radius:4px;display:flex;margin-top:12px;padding:8px}@media (prefers-color-scheme:dark){.search-history-box{background-color:rgba(0,0,0,.3);border-color:transparent}}.search-history-box-icon{--iron-icon-fill-color:var(--cr-link-row-start-icon-color,var(--google-grey-700));display:flex;flex-shrink:0;margin:auto;padding-inline-end:10px;width:var(--cr-link-row-icon-width,var(--cr-icon-size))}@media (prefers-color-scheme:dark){.search-history-box-icon{--iron-icon-fill-color:var(--cr-link-row-start-icon-color,var(--google-grey-500))}}#nonGoogleSearchHistoryBox{margin-bottom:16px}
    </style>

    <cr-dialog id="clearBrowsingDataDialog"
        close-text="$i18n{close}" ignore-popstate has-tabs ignore-enter-key>
      <div slot="title">
        <div>$i18n{clearBrowsingData}</div>
      </div>
      <div slot="header">
        <cr-tabs id="tabs" tab-names="[[tabsNames_]]"
            selected="{{selectedTabIndex_}}"
            on-selected-changed="recordTabChange_">
        </cr-tabs>
      </div>
      <div slot="body">
        <cr-page-selector id="pages" selected="[[selectedTabIndex_]]"
            on-iron-select="updateClearButtonState_">
          <div id="basicTab">
            <div class="row time-range-row">
              <span class="time-range-label" aria-hidden="true">
                $i18n{clearTimeRange}
              </span>
              <settings-dropdown-menu id="clearFromBasic" no-set-pref
                  class="time-range-select"
                  label="$i18n{clearTimeRange}"
                  pref="{{prefs.browser.clear_data.time_period_basic}}"
                  menu-options="[[clearFromOptions_]]"
                  on-settings-control-change="onTimePeriodChanged_">
              </settings-dropdown-menu>
            </div>
            <!-- Note: whether these checkboxes are checked are ignored if
                 deleting history is disabled (i.e. supervised users, policy),
                 so it's OK to have a hidden checkbox that's also checked (as
                 the C++ accounts for whether a user is allowed to delete
                 history independently). -->
            <settings-checkbox id="browsingCheckboxBasic"
                pref="{{prefs.browser.clear_data.browsing_history_basic}}"
                label="$i18n{clearBrowsingHistory}"
                sub-label-html="[[browsingCheckboxLabel_(isSyncingHistory_,
                    '$i18nPolymer{clearBrowsingHistorySummary}',
                    '$i18nPolymer{clearBrowsingHistorySummarySignedInNoLink}'
                    )]]"
                disabled="[[clearingInProgress_]]"
                no-set-pref>
            </settings-checkbox>
            <settings-checkbox id="cookiesCheckboxBasic"
                class="cookies-checkbox"
                pref="{{prefs.browser.clear_data.cookies_basic}}"
                label="$i18n{clearCookies}"
                sub-label="[[cookiesCheckboxLabel_(
                    syncStatus.signedInState,
                    shouldShowCookieException_,
                    '$i18nPolymer{clearCookiesSummary}',
                    '$i18nPolymer{clearCookiesSummarySignedIn}',
                    '$i18nPolymer{clearCookiesSummarySyncing}',
                    '$i18nPolymer{clearCookiesSummarySignedInSupervisedProfile}'
                    )]]"
                disabled="[[clearingInProgress_]]" no-set-pref>
            </settings-checkbox>
            <settings-checkbox id="cacheCheckboxBasic"
                class="cache-checkbox"
                pref="{{prefs.browser.clear_data.cache_basic}}"
                label="$i18n{clearCache}"
                sub-label="[[counters_.cache_basic]]"
                disabled="[[clearingInProgress_]]" no-set-pref>
            </settings-checkbox>
            <div class="search-history-box"
                hidden="[[!showSearchHistoryBox_(syncStatus.signedInState)]]">
              <cr-icon class="search-history-box-icon" aria-hidden="true"
                  icon="settings20:googleg">
              </cr-icon>
              <div id="googleSearchHistoryLabel"
                  inner-h-t-m-l="[[googleSearchHistoryString_]]">
              </div>
            </div>
            <div id="nonGoogleSearchHistoryBox"
                class="search-history-box"
                hidden="[[!isNonGoogleDse_]]">
              <cr-icon class="search-history-box-icon" aria-hidden="true"
                  icon="cr:search">
              </cr-icon>
              <div id="nonGoogleSearchHistoryLabel"
                  inner-h-t-m-l="[[nonGoogleSearchHistoryString_]]">
              </div>
            </div>
          </div>
          <div id="advancedTab">
            <div class="row time-range-row">
              <span class="time-range-label" aria-hidden="true">
                $i18n{clearTimeRange}
              </span>
              <settings-dropdown-menu id="clearFrom" no-set-pref
                  class="time-range-select"
                  label="$i18n{clearTimeRange}"
                  pref="{{prefs.browser.clear_data.time_period}}"
                  menu-options="[[clearFromOptions_]]"
                  on-settings-control-change="onTimePeriodChanged_">
              </settings-dropdown-menu>
            </div>
            <settings-checkbox id="browsingCheckbox"
                pref="{{prefs.browser.clear_data.browsing_history}}"
                label="$i18n{clearBrowsingHistory}"
                sub-label="[[counters_.browsing_history]]"
                disabled="[[clearingInProgress_]]"
                no-set-pref>
            </settings-checkbox>
            <settings-checkbox id="downloadCheckbox"
                pref="{{prefs.browser.clear_data.download_history}}"
                label="$i18n{clearDownloadHistory}"
                sub-label="[[counters_.download_history]]"
                disabled="[[clearingInProgress_]]"
                no-set-pref>
            </settings-checkbox>
            <settings-checkbox id="cookiesCheckbox"
                class="cookies-checkbox"
                pref="{{prefs.browser.clear_data.cookies}}"
                label="$i18n{clearCookies}"
                sub-label="[[counters_.cookies]]"
                disabled="[[clearingInProgress_]]" no-set-pref>
            </settings-checkbox>
            <settings-checkbox id="cacheCheckbox"
                class="cache-checkbox"
                pref="{{prefs.browser.clear_data.cache}}"
                label="$i18n{clearCache}"
                sub-label="[[counters_.cache]]"
                disabled="[[clearingInProgress_]]" no-set-pref>
            </settings-checkbox>
            <settings-checkbox
                pref="{{prefs.browser.clear_data.passwords}}"
                label="$i18n{clearPasswords}"
                sub-label="[[counters_.passwords]]"
                disabled="[[clearingInProgress_]]" no-set-pref>
            </settings-checkbox>
            <settings-checkbox
                pref="{{prefs.browser.clear_data.form_data}}"
                label="$i18n{clearFormData}"
                sub-label="[[counters_.form_data]]"
                disabled="[[clearingInProgress_]]" no-set-pref>
            </settings-checkbox>
            <settings-checkbox
                pref="{{prefs.browser.clear_data.site_settings}}"
                label="$i18nPolymer{siteSettings}"
                sub-label="[[counters_.site_settings]]"
                disabled="[[clearingInProgress_]]" no-set-pref>
            </settings-checkbox>
            <settings-checkbox
                pref="{{prefs.browser.clear_data.hosted_apps_data}}"
                label="$i18n{clearHostedAppData}"
                sub-label="[[counters_.hosted_apps_data]]"
                disabled="[[clearingInProgress_]]" no-set-pref>
            </settings-checkbox>
          </div>
        </cr-page-selector>
      </div>
      <div slot="button-container">
        <div class="spinner" hidden$="[[!clearingInProgress_]]"></div>
        <cr-button class="cancel-button" autofocus
            disabled="[[clearingInProgress_]]"
            on-click="onCancelClick_">
          $i18n{cancel}
        </cr-button>
        <cr-button id="clearButton" class="action-button"
            on-click="clearBrowsingData_"
            disabled="[[isClearButtonDisabled_(clearingInProgress_,
                                               clearButtonDisabled_)]]">
          $i18n{clearData}
        </cr-button>

        <!-- The alert must be inside the dialog for it to be read while the
             dialog is open. -->
        <div id="clearingDataAlert" role="alert">
          [[clearingDataAlertString_]]
        </div>
      </div>

      <template is="dom-if"
          if="[[shouldShowFooter_(
              syncStatus.signedInState, isClearPrimaryAccountAllowed_)]]"
          restamp>
        <div slot="footer">
          <settings-sync-account-control sync-status="[[syncStatus]]"
              prefs="{{prefs}}" hide-buttons hide-banner
              access-point="[[accessPointEnum_.SETTINGS]]">
          </settings-sync-account-control>
          <div class="divider"></div>
          <div id="footerDescription" on-click="onSyncDescriptionLinkClicked_">
            <span id="signinInfo"
                hidden="[[!showSigninInfo_(
                    syncStatus.signedInState, isClearPrimaryAccountAllowed_)]]">
              $i18nRaw{clearBrowsingDataSignedIn}
            </span>
            <span id="syncInfo"
                hidden="[[!showSyncInfo_(
                    syncStatus.signedInState, isClearPrimaryAccountAllowed_)]]">
              $i18nRaw{clearBrowsingDataWithSync}
            </span>
            <span id="syncPausedInfo" hidden="[[!isSyncPaused_]]">
              $i18nRaw{clearBrowsingDataWithSyncPaused}
            </span>
            <span id="syncPassphraseErrorInfo"
                hidden="[[!hasPassphraseError_]]">
              $i18nRaw{clearBrowsingDataWithSyncPassphraseError}
            </span>
            <span id="syncOtherErrorInfo" hidden="[[!hasOtherSyncError_]]">
              $i18nRaw{clearBrowsingDataWithSyncError}
            </span>
          </div>
        </div>
      </template>

    </cr-dialog>

    <template is="dom-if" if="[[showHistoryDeletionDialog_]]" restamp>
      <settings-history-deletion-dialog id="historyNotice"
          on-close="onHistoryDeletionDialogClose_">
      </settings-history-deletion-dialog>
    </template>

    <template is="dom-if" if="[[showPasswordsDeletionDialog_]]" restamp>
      <settings-passwords-deletion-dialog id="passwordsNotice"
          on-close="onPasswordsDeletionDialogClose_">
      </settings-passwords-deletion-dialog>
    </template>
<!--_html_template_end_-->`}function closeDialog$1(dialog,isLast){if(!isLast){dialog.addEventListener("close",(e=>{e.stopPropagation()}),{once:true})}dialog.close()}const SettingsClearBrowsingDataDialogElementBase=RouteObserverMixin(WebUiListenerMixin(PrefsMixin(I18nMixin(PolymerElement))));class SettingsClearBrowsingDataDialogElement extends SettingsClearBrowsingDataDialogElementBase{static get is(){return"settings-clear-browsing-data-dialog"}static get template(){return getTemplate$20()}static get properties(){return{syncStatus:Object,counters_:{type:Object,value(){return{}}},clearFromOptions_:{readOnly:true,type:Array,value:[{value:TimePeriod.LAST_HOUR,name:loadTimeData.getString("clearPeriodHour")},{value:TimePeriod.LAST_DAY,name:loadTimeData.getString("clearPeriod24Hours")},{value:TimePeriod.LAST_WEEK,name:loadTimeData.getString("clearPeriod7Days")},{value:TimePeriod.FOUR_WEEKS,name:loadTimeData.getString("clearPeriod4Weeks")},{value:TimePeriod.ALL_TIME,name:loadTimeData.getString("clearPeriodEverything")}]},clearingInProgress_:{type:Boolean,value:false},clearingDataAlertString_:{type:String,value:""},clearButtonDisabled_:{type:Boolean,value:false},showHistoryDeletionDialog_:{type:Boolean,value:false},showPasswordsDeletionDialogLater_:{type:Boolean,value:false},showPasswordsDeletionDialog_:{type:Boolean,value:false},isSyncingHistory_:{type:Boolean,value:false},shouldShowCookieException_:{type:Boolean,value:false},isClearPrimaryAccountAllowed_:{type:Boolean,value(){return loadTimeData.getBoolean("isClearPrimaryAccountAllowed")}},isSyncPaused_:{type:Boolean,value:false,computed:"computeIsSyncPaused_(syncStatus)"},hasPassphraseError_:{type:Boolean,value:false,computed:"computeHasPassphraseError_(syncStatus)"},hasOtherSyncError_:{type:Boolean,value:false,computed:"computeHasOtherError_(syncStatus, isSyncPaused_, hasPassphraseError_)"},selectedTabIndex_:Number,tabsNames_:{type:Array,value:()=>[loadTimeData.getString("basicPageTitle"),loadTimeData.getString("advancedPageTitle")]},googleSearchHistoryString_:{type:String,computed:"computeGoogleSearchHistoryString_(isNonGoogleDse_)"},isNonGoogleDse_:{type:Boolean,value:false},nonGoogleSearchHistoryString_:String,accessPointEnum_:{type:Object,value:ChromeSigninAccessPoint}}}static get observers(){return[`onTimePeriodAdvancedPrefUpdated_(\n          prefs.browser.clear_data.time_period.value)`,`onTimePeriodBasicPrefUpdated_(\n          prefs.browser.clear_data.time_period_basic.value)`,`onSelectedTabIndexPrefUpdated_(\n          prefs.browser.last_clear_browsing_data_tab.value)`]}focusOutlineManager_;browserProxy_=ClearBrowsingDataBrowserProxyImpl.getInstance();syncBrowserProxy_=SyncBrowserProxyImpl.getInstance();ready(){super.ready();this.syncBrowserProxy_.getSyncStatus().then(this.handleSyncStatus_.bind(this));this.addWebUiListener("sync-status-changed",this.handleSyncStatus_.bind(this));this.addWebUiListener("update-sync-state",this.updateSyncState_.bind(this));this.addWebUiListener("browsing-data-counter-text-update",this.updateCounterText_.bind(this));this.addEventListener("settings-boolean-control-change",this.updateClearButtonState_)}connectedCallback(){super.connectedCallback();this.browserProxy_.initialize().then((()=>{this.$.clearBrowsingDataDialog.showModal();this.focusOutlineManager_=FocusOutlineManager.forDocument(document);this.focusOutlineManager_.visible=true;document.addEventListener("mousedown",(()=>{this.focusOutlineManager_.visible=false}),{once:true})}))}handleSyncStatus_(syncStatus){this.syncStatus=syncStatus}isClearButtonDisabled_(clearingInProgress,clearButtonDisabled){return clearingInProgress||clearButtonDisabled}updateClearButtonState_(){const page=this.$.pages.selectedItem;if(!page){return}this.clearButtonDisabled_=this.getSelectedDataTypes_(page).length===0}currentRouteChanged(currentRoute){if(currentRoute===routes.CLEAR_BROWSER_DATA){chrome.metricsPrivate.recordUserAction("ClearBrowsingData_DialogCreated")}}updateSyncState_(event){this.isSyncingHistory_=event.syncingHistory;this.shouldShowCookieException_=event.shouldShowCookieException;this.$.clearBrowsingDataDialog.classList.add("fully-rendered");this.isNonGoogleDse_=event.isNonGoogleDse;this.nonGoogleSearchHistoryString_=sanitizeInnerHtml(event.nonGoogleSearchHistoryString)}browsingCheckboxLabel_(isSyncingHistory,historySummary,historySummarySignedInNoLink){return isSyncingHistory?historySummarySignedInNoLink:historySummary}cookiesCheckboxLabel_(signedInState,shouldShowCookieException,cookiesSummary,clearCookiesSummarySignedIn,clearCookiesSummarySyncing,clearCookiesSummarySignedInSupervisedProfile){if(loadTimeData.getBoolean("isChildAccount")){return clearCookiesSummarySignedInSupervisedProfile}if(signedInState===SignedInState.SIGNED_IN){return clearCookiesSummarySignedIn}if(shouldShowCookieException){return clearCookiesSummarySyncing}return cookiesSummary}updateCounterText_(prefName,text){const matches=prefName.match(/^browser\.clear_data\.(\w+)$/);assert(matches[1]);this.set("counters_."+matches[1],text)}getSelectedDataTypes_(page){const checkboxes=page.querySelectorAll("settings-checkbox");const dataTypes=[];checkboxes.forEach((checkbox=>{if(checkbox.checked&&!checkbox.hidden){dataTypes.push(checkbox.pref.key)}}));return dataTypes}getTimeRangeDropdownForCurrentPage_(){const page=this.$.pages.selectedItem;const dropdownMenu=page.querySelector(".time-range-select");assert(dropdownMenu);return dropdownMenu}isBasicTabSelected_(){const page=this.$.pages.selectedItem;assert(page);switch(page.id){case"basicTab":return true;case"advancedTab":return false;default:assertNotReached()}}async clearBrowsingData_(){this.clearingInProgress_=true;this.clearingDataAlertString_=loadTimeData.getString("clearingData");const page=this.$.pages.selectedItem;const dataTypes=this.getSelectedDataTypes_(page);const dropdownMenu=this.getTimeRangeDropdownForCurrentPage_();const timePeriod=Number(dropdownMenu.getSelectedValue());if(this.isBasicTabSelected_()){chrome.metricsPrivate.recordUserAction("ClearBrowsingData_BasicTab");this.browserProxy_.recordSettingsClearBrowsingDataBasicTimePeriodHistogram(timePeriod)}else{chrome.metricsPrivate.recordUserAction("ClearBrowsingData_AdvancedTab");this.browserProxy_.recordSettingsClearBrowsingDataAdvancedTimePeriodHistogram(timePeriod)}this.setPrefValue("browser.last_clear_browsing_data_tab",this.selectedTabIndex_);this.shadowRoot.querySelectorAll("settings-checkbox[no-set-pref]").forEach((checkbox=>checkbox.sendPrefChange()));this.shadowRoot.querySelectorAll("settings-dropdown-menu[no-set-pref]").forEach((dropdown=>dropdown.sendPrefChange()));const{showHistoryNotice:showHistoryNotice,showPasswordsNotice:showPasswordsNotice}=await this.browserProxy_.clearBrowsingData(dataTypes,dropdownMenu.pref.value);this.clearingInProgress_=false;getInstance().announce(loadTimeData.getString("clearedData"));this.showHistoryDeletionDialog_=showHistoryNotice;this.showPasswordsDeletionDialog_=showPasswordsNotice&&!showHistoryNotice;this.showPasswordsDeletionDialogLater_=showPasswordsNotice&&showHistoryNotice;const isLastDialog=!showHistoryNotice&&!showPasswordsNotice;if(this.$.clearBrowsingDataDialog.open){closeDialog$1(this.$.clearBrowsingDataDialog,isLastDialog)}}onCancelClick_(){this.$.clearBrowsingDataDialog.cancel()}onHistoryDeletionDialogClose_(e){this.showHistoryDeletionDialog_=false;if(this.showPasswordsDeletionDialogLater_){e.stopPropagation();this.showPasswordsDeletionDialogLater_=false;this.showPasswordsDeletionDialog_=true}}onPasswordsDeletionDialogClose_(){this.showPasswordsDeletionDialog_=false}onSelectedTabIndexPrefUpdated_(selectedTabIndex){this.selectedTabIndex_=selectedTabIndex}recordTabChange_(event){if(event.detail.value===0){chrome.metricsPrivate.recordUserAction("ClearBrowsingData_SwitchTo_BasicTab")}else{chrome.metricsPrivate.recordUserAction("ClearBrowsingData_SwitchTo_AdvancedTab")}}onSyncDescriptionLinkClicked_(e){if(e.target.tagName==="A"){e.preventDefault();if(this.showSigninInfo_()){chrome.metricsPrivate.recordUserAction("ClearBrowsingData_SignOut");this.syncBrowserProxy_.signOut(false)}else if(this.showSyncInfo_()){chrome.metricsPrivate.recordUserAction("ClearBrowsingData_Sync_Pause");this.syncBrowserProxy_.pauseSync()}else if(this.isSyncPaused_){chrome.metricsPrivate.recordUserAction("ClearBrowsingData_Sync_SignIn");this.syncBrowserProxy_.startSignIn(ChromeSigninAccessPoint.SETTINGS)}else{if(this.hasPassphraseError_){chrome.metricsPrivate.recordUserAction("ClearBrowsingData_Sync_NavigateToPassphrase")}else{chrome.metricsPrivate.recordUserAction("ClearBrowsingData_Sync_NavigateToError")}Router.getInstance().navigateTo(routes.SYNC)}}}computeIsSyncPaused_(){return!!this.syncStatus.hasError&&!this.syncStatus.hasUnrecoverableError&&this.syncStatus.statusAction===StatusAction.REAUTHENTICATE}computeHasPassphraseError_(){return!!this.syncStatus.hasError&&this.syncStatus.statusAction===StatusAction.ENTER_PASSPHRASE}computeHasOtherError_(){return this.syncStatus!==undefined&&!!this.syncStatus.hasError&&!this.isSyncPaused_&&!this.hasPassphraseError_}computeGoogleSearchHistoryString_(isNonGoogleDse){return isNonGoogleDse?this.i18nAdvanced("clearGoogleSearchHistoryNonGoogleDse"):this.i18nAdvanced("clearGoogleSearchHistoryGoogleDse")}shouldShowFooter_(){if(!this.syncStatus){return false}switch(this.syncStatus.signedInState){case SignedInState.SIGNED_IN:return this.isClearPrimaryAccountAllowed_;case SignedInState.SYNCING:return true;case SignedInState.WEB_ONLY_SIGNED_IN:case SignedInState.SIGNED_OUT:case SignedInState.SIGNED_IN_PAUSED:default:return false}}showSigninInfo_(){if(!this.syncStatus){return false}return this.syncStatus.signedInState===SignedInState.SIGNED_IN&&this.isClearPrimaryAccountAllowed_}showSyncInfo_(){if(!this.syncStatus){return false}return!this.showSigninInfo_()&&!this.syncStatus.hasError}showSearchHistoryBox_(){if(!this.syncStatus){return false}switch(this.syncStatus.signedInState){case SignedInState.SIGNED_IN_PAUSED:case SignedInState.SIGNED_IN:case SignedInState.SYNCING:return true;case SignedInState.WEB_ONLY_SIGNED_IN:case SignedInState.SIGNED_OUT:default:return false}}onTimePeriodChanged_(){const dropdownMenu=this.getTimeRangeDropdownForCurrentPage_();const timePeriod=parseInt(dropdownMenu.getSelectedValue(),10);assert(!Number.isNaN(timePeriod));this.browserProxy_.restartCounters(this.isBasicTabSelected_(),timePeriod)}onTimePeriodAdvancedPrefUpdated_(){this.onTimePeriodPrefUpdated_(false)}onTimePeriodBasicPrefUpdated_(){this.onTimePeriodPrefUpdated_(true)}onTimePeriodPrefUpdated_(isBasic){const timePeriodPref=isBasic?"browser.clear_data.time_period_basic":"browser.clear_data.time_period";const timePeriodValue=this.getPref(timePeriodPref).value;if(!this.clearFromOptions_.find((timePeriodOption=>timePeriodOption.value===timePeriodValue))){this.setPrefValue(timePeriodPref,TimePeriod.LAST_HOUR)}}}customElements.define(SettingsClearBrowsingDataDialogElement.is,SettingsClearBrowsingDataDialogElement);function getTemplate$1$(){return html`<!--_html_template_start_--><style>:host{--cr-menu-border-radius:12px}#timePicker{max-width:512px}.dropdown-item{padding:4px 16px}.row{align-items:center;display:flex}.time-period-chip{margin-inline-end:5px}</style>

<div class="row" id="timePicker">
  <template is="dom-repeat" items="[[expandedOptionList_]]"
      on-dom-change="onTimePickerDomChanged_">
    <cr-chip class="time-period-chip"
        selected="[[isTimePeriodSelected_(item.value)]]"
        on-click="onTimePeriodSelected_">
      <cr-icon icon="cr:check" hidden="[[!isTimePeriodSelected_(item.value)]]">
      </cr-icon>
      [[item.label]]
    </cr-chip>
  </template>
  <cr-chip id="moreButton" hidden="[[!moreOptionList_.length]]"
      on-click="onMoreTimePeriodsButtonClick_">
    $i18n{clearBrowsingDataMore}
    <cr-icon icon="cr:arrow-drop-down"></cr-icon>
  </cr-chip>
  <cr-lazy-render id="moreTimePeriodsMenu">
    <template>
      <cr-action-menu role-description="$i18n{menu}"
          on-close="onMoreOptionsMenuClose_">
        <template is="dom-repeat" items="[[moreOptionList_]]">
          <button class="dropdown-item" on-click="onMenuTimePeriodSelected_">
            [[item.label]]
          </button>
        </template>
      </cr-action-menu>
    </template>
  </cr-lazy-render>
</div><!--_html_template_end_-->`}const MENU_VERTICAL_OFFSET_PX=5;function getTimePeriodString(timePeriod,short=true){switch(timePeriod){case TimePeriod.LAST_15_MINUTES:return short?loadTimeData.getString("clearPeriod15Min"):loadTimeData.getString("clearPeriod15Minutes");case TimePeriod.LAST_HOUR:return loadTimeData.getString("clearPeriodHour");case TimePeriod.LAST_DAY:return loadTimeData.getString("clearPeriod24Hours");case TimePeriod.LAST_WEEK:return loadTimeData.getString("clearPeriod7Days");case TimePeriod.FOUR_WEEKS:return loadTimeData.getString("clearPeriod4Weeks");case TimePeriod.ALL_TIME:return loadTimeData.getString("clearPeriodEverything");default:assertNotReachedCase()}}const SettingsClearBrowsingDataTimePickerBase=PrefsMixin(PolymerElement);class SettingsClearBrowsingDataTimePicker extends SettingsClearBrowsingDataTimePickerBase{static get is(){return"settings-clear-browsing-data-time-picker"}static get template(){return getTemplate$1$()}static get properties(){return{selectedTimePeriod_:{type:Number,observer:"onTimePeriodSelectionChanged_",value:TimePeriod.LAST_HOUR},allTimePeriodList_:{readOnly:true,type:Array,value:[TimePeriod.LAST_15_MINUTES,TimePeriod.LAST_HOUR,TimePeriod.LAST_DAY,TimePeriod.LAST_WEEK,TimePeriod.FOUR_WEEKS,TimePeriod.ALL_TIME]},expandedOptionList_:{type:Array,computed:"computeExpandedOptionList_(maxChipsShown_, selectedTimePeriod_)"},moreOptionList_:{type:Array,computed:"computeMoreOptionList_(expandedOptionList_)"},maxChipsShown_:{type:Number,value:4}}}static get observers(){return["onTimePeriodPrefUpdated_(prefs.browser.clear_data.time_period.value)"]}onTimePeriodPrefUpdated_(){const timePeriodValue=this.getPref("browser.clear_data.time_period").value;if(timePeriodValue in TimePeriod&&timePeriodValue!==this.selectedTimePeriod_){this.selectedTimePeriod_=timePeriodValue}}onTimePeriodSelectionChanged_(){this.dispatchEvent(new CustomEvent("selected-time-period-change",{bubbles:true,composed:true}))}computeExpandedOptionList_(){const expandedOptionsList=[];let selectedTimePeriodAdded=false;for(let i=0;i<this.maxChipsShown_-1;i++){const timePeriod=this.allTimePeriodList_[i];selectedTimePeriodAdded||=timePeriod===this.selectedTimePeriod_;expandedOptionsList.push({value:timePeriod,label:getTimePeriodString(timePeriod)})}if(selectedTimePeriodAdded){const timePeriod=this.allTimePeriodList_[this.maxChipsShown_-1];expandedOptionsList.push({value:timePeriod,label:getTimePeriodString(timePeriod)})}else{expandedOptionsList.push({value:this.selectedTimePeriod_,label:getTimePeriodString(this.selectedTimePeriod_)})}return expandedOptionsList}computeMoreOptionList_(){const expandedTimePeriodsList=this.expandedOptionList_.map((option=>option.value));const moreOptionsList=[];this.allTimePeriodList_.forEach((timePeriod=>{if(!expandedTimePeriodsList.includes(timePeriod)){moreOptionsList.push({value:timePeriod,label:getTimePeriodString(timePeriod)})}}));return moreOptionsList}onTimePickerDomChanged_(){const timePicker=this.$.timePicker;if(timePicker.scrollWidth>timePicker.clientWidth){this.maxChipsShown_--}}isTimePeriodSelected_(timePeriod){return timePeriod===this.selectedTimePeriod_}onTimePeriodSelected_(event){const newTimePeriod=event.model.item.value;if(newTimePeriod!==this.selectedTimePeriod_){this.selectedTimePeriod_=event.model.item.value}}onMenuTimePeriodSelected_(event){this.onTimePeriodSelected_(event);const actionMenu=this.shadowRoot.querySelector("cr-action-menu");if(actionMenu){actionMenu.close()}}onMoreTimePeriodsButtonClick_(e){const target=e.currentTarget;this.$.moreTimePeriodsMenu.get().showAt(target,{anchorAlignmentX:AnchorAlignment.BEFORE_END,top:target.getBoundingClientRect().bottom+MENU_VERTICAL_OFFSET_PX});MetricsBrowserProxyImpl.getInstance().recordAction("Settings.DeleteBrowsingData.TimePickerMoreClick")}onMoreOptionsMenuClose_(e){e.stopPropagation()}getSelectedTimePeriod(){return this.selectedTimePeriod_}sendPrefChange(){this.setPrefValue("browser.clear_data.time_period",this.selectedTimePeriod_)}}customElements.define(SettingsClearBrowsingDataTimePicker.is,SettingsClearBrowsingDataTimePicker);function getTemplate$1_(){return html`<!--_html_template_start_--><style include="cr-icons cr-shared-style settings-shared">#subpageDescription{padding-bottom:16px}.cancel-button{margin:0}.icon-arrow-back{--cr-icon-button-margin-end:12px;--cr-icon-button-margin-start:0}.label{color:var(--cr-primary-text-color);font-weight:500}.link-rows-block>*{background-color:var(--dbd-container-color);padding:4px 16px}cr-link-row:first-of-type{border-bottom-left-radius:var(--dbd-container-stacked-border-radius);border-bottom-right-radius:var(--dbd-container-stacked-border-radius);border-top-left-radius:var(--dbd-container-border-radius);border-top-right-radius:var(--dbd-container-border-radius);margin-bottom:2px}cr-link-row:last-of-type{border-bottom-left-radius:var(--dbd-container-border-radius);border-bottom-right-radius:var(--dbd-container-border-radius);border-top-left-radius:var(--dbd-container-stacked-border-radius);border-top-right-radius:var(--dbd-container-stacked-border-radius);margin-bottom:0}cr-link-row:not(:first-of-type):not(:last-of-type){border-radius:var(--dbd-container-stacked-border-radius);margin-bottom:2px}cr-link-row:only-of-type{border-radius:var(--dbd-container-border-radius);margin-bottom:0}cr-link-row.hide-icon::part(icon){display:none}div[slot="title"]{--cr-dialog-title-slot-padding-bottom:12px;--cr-dialog-title-slot-padding-top:18px;align-items:center;display:flex;font-size:16px;font-weight:500}</style>

<cr-dialog id="dialog" show-on-attach>
  <div slot="title">
    <cr-icon-button class="icon-arrow-back" aria-label="$i18n{back}"
        on-click="onBackOrCancelClick_" autofocus></cr-icon-button>
    [[dialogTitle_]]
  </div>
  <div slot="body">
    <div id="subpageDescription">$i18n{otherDataDescription}
    </div>
    <div class="link-rows-block">
      <cr-link-row id="passwordManagerLink" external using-slotted-label
          sub-label="$i18n{manageInGooglePasswordManager}"
          on-click="onPasswordManagerClick_">
        <div slot="label" class="label">$i18n{passwordsAndPasskeys}</div>
      </cr-link-row>
      <template is="dom-if"
          if="[[shouldShowGoogleSearchHistoryLink_(syncStatus_, isGoogleDse_)]]"
          restamp>
        <cr-link-row id="googleSearchHistoryLink" external using-slotted-label
            sub-label="$i18n{manageInYourGoogleAccount}"
            on-click="onGoogleSearchHistoryLinkClick_">
          <div slot="label" class="label">$i18n{searchHistory}</div>
        </cr-link-row>
      </template>
      <template is="dom-if" if="[[shouldShowMyActivityLink_(syncStatus_)]]"
          restamp>
        <cr-link-row id="myActivityLink" external using-slotted-label
            sub-label="$i18n{manageInYourGoogleAccount}"
            on-click="onMyActivityLinkClick_">
          <div slot="label" class="label">$i18n{myActivity}</div>
        </cr-link-row>
      </template>
      <template is="dom-if"
          if="[[shouldShowGeminiAppsActivityLink_(syncStatus_)]]" restamp>
        <cr-link-row id="geminiAppsActivityLink" external using-slotted-label
            sub-label="$i18n{manageInYourGeminiAppsActivity}"
            on-click="onGeminiAppsActivityClick_">
          <div slot="label" class="label">$i18n{geminiAppsActivity}</div>
        </cr-link-row>
      </template>
      <template is="dom-if" if="[[!isGoogleDse_]]" restamp>
        <cr-link-row id="nonGoogleSearchHistoryLink" external
            using-slotted-label class="hide-icon"
            sub-label="[[nonGoogleSearchHistorySubLabel_]]">
          <div slot="label" class="label">$i18n{searchHistory}</div>
        </cr-link-row>
      </template>
    </div>
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button" on-click="onBackOrCancelClick_">
      $i18n{done}
    </cr-button>
  </div>
</cr-dialog><!--_html_template_end_-->`}const SettingsOtherGoogleDataDialogElementBase=WebUiListenerMixin(PolymerElement);class SettingsOtherGoogleDataDialogElement extends SettingsOtherGoogleDataDialogElementBase{static get is(){return"settings-other-google-data-dialog"}static get template(){return getTemplate$1_()}static get properties(){return{dialogTitle_:{type:String,computed:"computeDialogTitle_(isGoogleDse_)"},isGoogleDse_:{type:Boolean,value:false},nonGoogleSearchHistorySubLabel_:String,syncStatus_:Object}}clearBrowsingDataBrowserProxy_=ClearBrowsingDataBrowserProxyImpl.getInstance();syncBrowserProxy_=SyncBrowserProxyImpl.getInstance();metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();ready(){super.ready();this.addWebUiListener("sync-status-changed",this.handleSyncStatus_.bind(this));this.syncBrowserProxy_.getSyncStatus().then(this.handleSyncStatus_.bind(this));this.addWebUiListener("update-sync-state",this.updateDseStatus_.bind(this));this.clearBrowsingDataBrowserProxy_.getSyncState().then(this.updateDseStatus_.bind(this))}updateDseStatus_(event){this.isGoogleDse_=!event.isNonGoogleDse;this.nonGoogleSearchHistorySubLabel_=sanitizeInnerHtml(event.nonGoogleSearchHistoryString)}handleSyncStatus_(syncStatus){this.syncStatus_=syncStatus}computeDialogTitle_(){return this.isGoogleDse_?loadTimeData.getString("otherGoogleDataTitle"):loadTimeData.getString("otherDataTitle")}onBackOrCancelClick_(){this.$.dialog.cancel()}onPasswordManagerClick_(){PasswordManagerImpl.getInstance().showPasswordManager(PasswordManagerPage.PASSWORDS);this.metricsBrowserProxy_.recordAction("Settings.DeleteBrowsingData.PasswordManagerLinkClick")}onMyActivityLinkClick_(){OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("deleteBrowsingDataMyActivityUrl"));this.metricsBrowserProxy_.recordAction("Settings.DeleteBrowsingData.MyActivityLinkClick")}onGoogleSearchHistoryLinkClick_(){OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("deleteBrowsingDataSearchHistoryUrl"));this.metricsBrowserProxy_.recordAction("Settings.DeleteBrowsingData.GoogleSearchHistoryLinkClick")}onGeminiAppsActivityClick_(){OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("myActivityGeminiAppsUrl"));this.metricsBrowserProxy_.recordAction("Settings.DeleteBrowsingData.GeminiAppsActivityLinkClick")}onGeminiPersonalContextClick_(){OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("geminiPersonalContextUrl"))}shouldShowMyActivityLink_(){return isSignedIn(this.syncStatus_)}shouldShowGoogleSearchHistoryLink_(){return isSignedIn(this.syncStatus_)&&this.isGoogleDse_}shouldShowGeminiAppsActivityLink_(){return isSignedIn(this.syncStatus_)&&loadTimeData.getBoolean("showGlicSettings")&&loadTimeData.getBoolean("enableBrowsingHistoryActorIntegrationM1")}}customElements.define(SettingsOtherGoogleDataDialogElement.is,SettingsOtherGoogleDataDialogElement);function getTemplate$1Z(){return html`<!--_html_template_start_--><style include="settings-shared cr-spinner-style">:host{--cr-dialog-button-container-padding-bottom:20px;--cr-dialog-button-container-padding-horizontal:20px;--cr-dialog-button-container-padding-top:20px;--cr-dialog-title-font-size:16px;--cr-dialog-title-slot-padding-bottom:14px;--cr-section-two-line-min-height:40px;--dbd-container-border-radius:12px;--dbd-container-color:var(--cr-fallback-color-surface3);--dbd-container-stacked-border-radius:4px;--dbd-dialog-body-max-height:400px;--dbd-dialog-max-height:600px;--settings-checkbox-margin-top:8px}#checkboxContainer{background-color:var(--dbd-container-color);border-radius:var(--dbd-container-border-radius);padding:8px var(--cr-section-padding) 12px var(--cr-section-padding)}#checkboxContainer:has(+#showMoreButton:not([hidden])){border-bottom-left-radius:var(--dbd-container-stacked-border-radius);border-bottom-right-radius:var(--dbd-container-stacked-border-radius);border-top-left-radius:var(--dbd-container-border-radius);border-top-right-radius:var(--dbd-container-border-radius);margin-bottom:2px}#deleteBrowsingDataDialog [slot=header]{padding-bottom:var(--cr-section-padding);padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding)}#deleteBrowsingDataDialog::part(body-container){max-height:var(--dbd-dialog-body-max-height)}#deleteBrowsingDataDialog::part(dialog){max-height:var(--dbd-dialog-max-height)}#deletingDataAlert{clip:rect(0,0,0,0);position:fixed}#manageOtherGoogleDataRow{border-radius:var(--dbd-container-border-radius);color:var(--cr-primary-text-color);background:var(--dbd-container-color);margin-top:12px;display:flex;align-items:center;font-weight:500}#showMoreButton{--cr-button-background-color:var(--dbd-container-color);--cr-button-height:auto;--cr-button-text-color:var(--cr-primary-text-color);border:none;border-bottom-left-radius:var(--dbd-container-border-radius);border-bottom-right-radius:var(--dbd-container-border-radius);border-top-left-radius:var(--dbd-container-stacked-border-radius);border-top-right-radius:var(--dbd-container-stacked-border-radius);padding:var(--cr-section-vertical-padding) 16px;width:100%}#spinner{margin-bottom:auto;margin-inline-end:16px;margin-top:auto}.checkbox-title{font-weight:500}.dialog-title{font-weight:500;line-height:24px}.row-aligned{align-items:center;display:flex}settings-clear-browsing-data-account-indicator{margin-inline-end:auto;overflow:hidden}</style>

<cr-dialog id="deleteBrowsingDataDialog" close-text="$i18n{close}"
    show-on-attach ignore-popstate ignore-enter-key
    hidden="[[showOtherGoogleDataDialog_]]">
  <div slot="title" class="dialog-title">$i18n{clearBrowsingData}</div>
  <div slot="header">
    <settings-clear-browsing-data-time-picker id="timePicker" prefs="{{prefs}}"
        on-selected-time-period-change="onTimePeriodChanged_">
    </settings-clear-browsing-data-time-picker>
  </div>
  <div slot="body">
    <div id="checkboxContainer">
      <template is="dom-repeat"
          items="[[expandedBrowsingDataTypeOptionsList_]]">
        <settings-checkbox pref="{{item.pref}}" no-set-pref
            sub-label-html="[[item.subLabel]]"
            disabled="[[isDeletionInProgress_]]"
            on-sub-label-link-clicked="onCheckboxSubLabelLinkClick_">
          <div class="checkbox-title">[[item.label]]</div>
        </settings-checkbox>
      </template>
      <div id="moreOptionsList">
        <template is="dom-if" if="[[dataTypesExpanded_]]">
          <template is="dom-repeat"
              items="[[moreBrowsingDataTypeOptionsList_]]">
            <settings-checkbox pref="{{item.pref}}" no-set-pref
                sub-label-html="[[item.subLabel]]"
                disabled="[[isDeletionInProgress_]]"
                on-sub-label-link-clicked="onCheckboxSubLabelLinkClick_">
              <div class="checkbox-title">[[item.label]]</div>
            </settings-checkbox>
          </template>
        </template>
      </div>
    </div>
    <cr-button id="showMoreButton" on-click="onShowMoreClick_"
        hidden="[[shouldHideShowMoreButton_(
            dataTypesExpanded_, moreBrowsingDataTypeOptionsList_)]]">
      $i18n{clearBrowsingDataShowMore}
      <cr-icon icon="cr:expand-more" aria-hidden="true" role="presentation">
      </cr-icon>
    </cr-button>
    <cr-link-row id="manageOtherGoogleDataRow"
        label="[[otherGoogleDataRowLabel_]]"
        sub-label="[[otherGoogleDataRowSubLabel_]]"
        on-click="onManageOtherGoogleDataRowClick_"
        role-description="$i18n{subpageArrowRoleDescription}">
    </cr-link-row>
  </div>
  <div slot="button-container" class="row-aligned">

    <settings-clear-browsing-data-account-indicator>
    </settings-clear-browsing-data-account-indicator>

    <div id="spinner" class="spinner" hidden="[[!isDeletionInProgress_]]"></div>
    <cr-button id="cancelButton" class="cancel-button" on-click="onCancelClick_"
        disabled="[[isDeletionInProgress_]]" autofocus>
      $i18n{cancel}
    </cr-button>
    <cr-button id="deleteButton" class="action-button"
        on-click="onDeleteBrowsingDataClick_"
        disabled="[[shouldDisableDeleteButton_(
            isDeletionInProgress_, isNoDatatypeSelected_)]]">
      [[deleteButtonLabel_]]
    </cr-button>
    <!-- The alert must be inside the dialog for it to be read while the
         dialog is open. -->
    <div id="deletingDataAlert" role="alert">
      [[deletingDataAlertString_]]
    </div>
  </div>
</cr-dialog>

<template is="dom-if" if="[[showHistoryDeletionDialog_]]" restamp>
  <settings-history-deletion-dialog id="historyNotice"
      on-close="onHistoryDeletionDialogClose_">
  </settings-history-deletion-dialog>
</template>

<template is="dom-if" if="[[showOtherGoogleDataDialog_]]" restamp>
  <settings-other-google-data-dialog on-cancel="onOtherGoogleDataDialogClose_">
  </settings-other-google-data-dialog>
</template><!--_html_template_end_-->`}function closeDialog(dialog,isLast){if(!isLast){dialog.addEventListener("close",(e=>{e.stopPropagation()}),{once:true})}dialog.close()}const ALL_BROWSING_DATATYPES_LIST=[BrowsingDataType.HISTORY,BrowsingDataType.SITE_DATA,BrowsingDataType.CACHE,BrowsingDataType.DOWNLOADS,BrowsingDataType.FORM_DATA,BrowsingDataType.SITE_SETTINGS,BrowsingDataType.HOSTED_APPS_DATA];const DEFAULT_BROWSING_DATATYPES_LIST=[BrowsingDataType.HISTORY,BrowsingDataType.SITE_DATA,BrowsingDataType.CACHE];function getDataTypeLabel(datatypes){switch(datatypes){case BrowsingDataType.HISTORY:return loadTimeData.getString("clearBrowsingHistory");case BrowsingDataType.CACHE:return loadTimeData.getString("clearCache");case BrowsingDataType.SITE_DATA:return loadTimeData.getString("clearCookies");case BrowsingDataType.FORM_DATA:return loadTimeData.getString("clearFormData");case BrowsingDataType.SITE_SETTINGS:return loadTimeData.getString("siteSettings");case BrowsingDataType.DOWNLOADS:return loadTimeData.getString("clearDownloadHistory");case BrowsingDataType.HOSTED_APPS_DATA:return loadTimeData.getString("clearHostedAppData");default:assertNotReachedCase()}}function getDataTypePrefName(datatypes){switch(datatypes){case BrowsingDataType.HISTORY:return"browser.clear_data.browsing_history";case BrowsingDataType.CACHE:return"browser.clear_data.cache";case BrowsingDataType.SITE_DATA:return"browser.clear_data.cookies";case BrowsingDataType.FORM_DATA:return"browser.clear_data.form_data";case BrowsingDataType.SITE_SETTINGS:return"browser.clear_data.site_settings";case BrowsingDataType.DOWNLOADS:return"browser.clear_data.download_history";case BrowsingDataType.HOSTED_APPS_DATA:return"browser.clear_data.hosted_apps_data";default:assertNotReachedCase()}}const SettingsClearBrowsingDataDialogV2ElementBase=RouteObserverMixin(WebUiListenerMixin(PrefsMixin(PolymerElement)));class SettingsClearBrowsingDataDialogV2Element extends SettingsClearBrowsingDataDialogV2ElementBase{static get is(){return"settings-clear-browsing-data-dialog-v2"}static get template(){return getTemplate$1Z()}static get properties(){return{dataTypesExpanded_:{type:Boolean,value:false},deleteButtonLabel_:{type:String,value:loadTimeData.getString("deleteDataFromDevice"),computed:"computeDeleteButtonLabel_(syncStatus_.signedInState)"},deletingDataAlertString_:{type:String,value:""},isDeletionInProgress_:{type:Boolean,value:false},isNoDatatypeSelected_:{type:Boolean,value:false},isGoogleDse_:{type:Boolean,value:false},otherGoogleDataRowLabel_:{type:String,computed:"computeOtherGoogleDataRowLabel_(isGoogleDse_)"},otherGoogleDataRowSubLabel_:{type:String,computed:"computeOtherGoogleDataRowSubLabel_(syncStatus_.signedInState, isGoogleDse_)"},showHistoryDeletionDialog_:{type:Boolean,value:false},showOtherGoogleDataDialog_:{type:Boolean,value:false},expandedBrowsingDataTypeOptionsList_:Array,moreBrowsingDataTypeOptionsList_:Array,syncStatus_:{type:Object,observer:"onSyncStatusChanged_"}}}clearBrowsingDataBrowserProxy_=ClearBrowsingDataBrowserProxyImpl.getInstance();syncBrowserProxy_=SyncBrowserProxyImpl.getInstance();metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();ready(){super.ready();this.addWebUiListener("browsing-data-counter-text-update",this.updateCounterText_.bind(this));this.addWebUiListener("sync-status-changed",this.handleSyncStatus_.bind(this));this.syncBrowserProxy_.getSyncStatus().then(this.handleSyncStatus_.bind(this));this.addEventListener("settings-boolean-control-change",this.updateDeleteButtonState_.bind(this));this.addWebUiListener("update-sync-state",(event=>this.updateDseStatus_(event.isNonGoogleDse)));this.clearBrowsingDataBrowserProxy_.getSyncState().then((event=>this.updateDseStatus_(event.isNonGoogleDse)));CrSettingsPrefs.initialized.then((()=>{this.setUpDataTypeOptionLists_();afterNextRender(this,(()=>this.updateDeleteButtonState_()))}))}updateDseStatus_(isNonGoogleDse){this.isGoogleDse_=!isNonGoogleDse}handleSyncStatus_(syncStatus){this.syncStatus_=syncStatus}onSyncStatusChanged_(){this.clearBrowsingDataBrowserProxy_.restartCounters(false,this.$.timePicker.getSelectedTimePeriod())}connectedCallback(){super.connectedCallback();this.clearBrowsingDataBrowserProxy_.initialize();this.setFocusOutlineToVisible_()}currentRouteChanged(currentRoute){if(currentRoute===routes.CLEAR_BROWSER_DATA){this.metricsBrowserProxy_.recordAction("ClearBrowsingData_DialogCreated")}}setUpDataTypeOptionLists_(){const expandedOptionsList=[];const moreOptionsList=[];ALL_BROWSING_DATATYPES_LIST.forEach((datatype=>{const datatypeOption={label:getDataTypeLabel(datatype),pref:this.getPref(getDataTypePrefName(datatype))};if(this.shouldDataTypeBeExpanded_(datatype)){expandedOptionsList.push(datatypeOption)}else{moreOptionsList.push(datatypeOption)}}));this.expandedBrowsingDataTypeOptionsList_=expandedOptionsList;this.moreBrowsingDataTypeOptionsList_=moreOptionsList}updateCounterText_(prefName,text){const expandedListIndex=this.expandedBrowsingDataTypeOptionsList_.map((option=>option.pref.key)).indexOf(prefName);if(expandedListIndex!==-1){this.set(`expandedBrowsingDataTypeOptionsList_.${expandedListIndex}.subLabel`,text);return}const moreListIndex=this.moreBrowsingDataTypeOptionsList_.map((option=>option.pref.key)).indexOf(prefName);assert(moreListIndex!==-1);this.set(`moreBrowsingDataTypeOptionsList_.${moreListIndex}.subLabel`,text)}isSignedIn_(){return isSignedIn(this.syncStatus_)}shouldDataTypeBeExpanded_(datatype){return DEFAULT_BROWSING_DATATYPES_LIST.includes(datatype)||this.getPref(getDataTypePrefName(datatype)).value}computeDeleteButtonLabel_(){return canDeleteAccountData(this.syncStatus_)?loadTimeData.getString("clearData"):loadTimeData.getString("deleteDataFromDevice")}computeOtherGoogleDataRowLabel_(){return this.isGoogleDse_?loadTimeData.getString("manageOtherGoogleDataLabel"):loadTimeData.getString("manageOtherDataLabel")}computeOtherGoogleDataRowSubLabel_(){if(loadTimeData.getBoolean("showGlicSettings")&&loadTimeData.getBoolean("enableBrowsingHistoryActorIntegrationM1")&&this.isSignedIn_()){return loadTimeData.getString("manageSearchGeminiPasswordsSubLabel")}if(this.isSignedIn_()||!this.isGoogleDse_){return loadTimeData.getString("manageOtherDataSubLabel")}return loadTimeData.getString("managePasswordsSubLabel")}onTimePeriodChanged_(){this.clearBrowsingDataBrowserProxy_.restartCounters(false,this.$.timePicker.getSelectedTimePeriod())}onCancelClick_(){this.$.deleteBrowsingDataDialog.close()}async onDeleteBrowsingDataClick_(){this.deletingDataAlertString_=loadTimeData.getString("clearingData");this.isDeletionInProgress_=true;const dataTypes=this.getSelectedDataTypes_();const timePeriod=this.$.timePicker.getSelectedTimePeriod();this.clearBrowsingDataBrowserProxy_.recordSettingsClearBrowsingDataAdvancedTimePeriodHistogram(timePeriod);this.$.deleteBrowsingDataDialog.querySelectorAll("settings-checkbox[no-set-pref]").forEach((checkbox=>this.setPrefValue(checkbox.pref.key,checkbox.checked)));this.$.timePicker.sendPrefChange();const{showHistoryNotice:showHistoryNotice}=await this.clearBrowsingDataBrowserProxy_.clearBrowsingData(dataTypes,timePeriod);this.isDeletionInProgress_=false;this.showHistoryDeletionDialog_=showHistoryNotice;this.showDeletionConfirmationToast_(timePeriod);if(this.$.deleteBrowsingDataDialog.open){closeDialog(this.$.deleteBrowsingDataDialog,!showHistoryNotice)}}showDeletionConfirmationToast_(timePeriod){const deletionConfirmationToastLabel=timePeriod===TimePeriod.ALL_TIME?loadTimeData.getString("deletionConfirmationAllTimeToast"):loadTimeData.getStringF("deletionConfirmationToast",getTimePeriodString(timePeriod,false));this.dispatchEvent(new CustomEvent("browsing-data-deleted",{bubbles:true,composed:true,detail:{deletionConfirmationText:deletionConfirmationToastLabel}}))}getSelectedDataTypes_(){const checkboxes=this.$.deleteBrowsingDataDialog.querySelectorAll("settings-checkbox");const dataTypes=[];checkboxes.forEach((checkbox=>{if(checkbox.checked&&!checkbox.hidden){dataTypes.push(checkbox.pref.key)}}));return dataTypes}updateDeleteButtonState_(){this.isNoDatatypeSelected_=this.getSelectedDataTypes_().length===0}onShowMoreClick_(){this.dataTypesExpanded_=true;this.metricsBrowserProxy_.recordAction("Settings.DeleteBrowsingData.CheckboxesShowMoreClick");afterNextRender(this,(()=>{const toFocus=this.$.moreOptionsList.querySelector("settings-checkbox");assert(toFocus);toFocus.focus()}))}shouldHideShowMoreButton_(){return this.dataTypesExpanded_||!this.moreBrowsingDataTypeOptionsList_||this.moreBrowsingDataTypeOptionsList_.length===0}shouldDisableDeleteButton_(){return this.isDeletionInProgress_||this.isNoDatatypeSelected_}onHistoryDeletionDialogClose_(){this.showHistoryDeletionDialog_=false}onManageOtherGoogleDataRowClick_(){this.showOtherGoogleDataDialog_=true;this.metricsBrowserProxy_.recordAction("Settings.DeleteBrowsingData.OtherDataEntryPointClick")}setFocusOutlineToVisible_(){const focusOutlineManager=FocusOutlineManager.forDocument(document);focusOutlineManager.visible=true;document.addEventListener("mousedown",(()=>{focusOutlineManager.visible=false}),{once:true})}onOtherGoogleDataDialogClose_(e){e.stopPropagation();this.showOtherGoogleDataDialog_=false;afterNextRender(this,(()=>focusWithoutInk(this.$.manageOtherGoogleDataRow)))}onCheckboxSubLabelLinkClick_(e){if(e.detail.id==="signOutLink"){this.syncBrowserProxy_.signOut(false);this.metricsBrowserProxy_.recordAction("Settings.DeleteBrowsingData.CookiesSignOutLinkClick");return}assertNotReached(`Invalid sub-label link with id: ${e.detail.id}`)}}customElements.define(SettingsClearBrowsingDataDialogV2Element.is,SettingsClearBrowsingDataDialogV2Element);function getTemplate$1Y(){return html`<!--_html_template_start_-->    <style include="settings-shared">#incognito{padding-bottom:10px}
    </style>
    <cr-dialog id="dialog" close-text="$i18n{close}">
      <div slot="title">$i18n{addSiteTitle}</div>
      <div slot="body">
        <cr-input id="site" label="$i18n{addSite}"
            placeholder="$i18n{addSiteExceptionPlaceholder}"
            value="{{site_}}" on-input="validate_"
            error-message="{{errorMessage_}}" spellcheck="false"
            autofocus></cr-input>
        <cr-checkbox id="incognito"
            hidden$="[[!showIncognitoSessionOnly_(hasIncognito,
                contentSetting)]]">
          $i18n{incognitoSiteOnly}
        </cr-checkbox>
      </div>
      <div slot="button-container">
        <cr-button class="cancel-button" on-click="onCancelClick_">
          $i18n{cancel}
        </cr-button>
        <cr-button class="action-button" id="add" on-click="onSubmit_"
            disabled>
          $i18n{add}
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`}const SiteSettingsMixin=dedupingMixin((superClass=>{class SiteSettingsMixin extends superClass{static get properties(){return{category:String,contentTypes_:{type:Array,value:[]}}}browserProxy;constructor(...args){super(...args);this.browserProxy=SiteSettingsBrowserProxyImpl.getInstance()}ensureUrlHasScheme(url){if(url.length===0){return url}return url.includes("://")?url:"http://"+url}sanitizePort(url){const urlWithScheme=this.ensureUrlHasScheme(url);if(urlWithScheme.startsWith("https://")&&urlWithScheme.endsWith(":443")){return url.slice(0,-4)}if(urlWithScheme.startsWith("http://")&&urlWithScheme.endsWith(":80")){return url.slice(0,-3)}return url}toUrl(originOrPattern){if(originOrPattern.length===0){return null}originOrPattern=originOrPattern.replace("*://","");originOrPattern=originOrPattern.replace("[*.]","");return new URL(this.ensureUrlHasScheme(originOrPattern))}originRepresentation(origin){try{const url=this.toUrl(origin);return url?url.host||url.origin:""}catch(error){return""}}expandSiteException(exception){const origin=exception.origin;const embeddingOrigin=exception.embeddingOrigin;let enforcement=null;if(exception.source===SiteSettingSource.EXTENSION||exception.source===SiteSettingSource.HOSTED_APP||exception.source===SiteSettingSource.POLICY){enforcement=chrome.settingsPrivate.Enforcement.ENFORCED}let controlledBy=chrome.settingsPrivate.ControlledBy.PRIMARY_USER;if(exception.source===SiteSettingSource.EXTENSION||exception.source===SiteSettingSource.HOSTED_APP){controlledBy=chrome.settingsPrivate.ControlledBy.EXTENSION}else if(exception.source===SiteSettingSource.POLICY){controlledBy=chrome.settingsPrivate.ControlledBy.USER_POLICY}return{category:exception.type,embeddingOrigin:embeddingOrigin,incognito:exception.incognito,isEmbargoed:exception.isEmbargoed,origin:origin,displayName:exception.displayName,setting:exception.setting,description:exception.description,enforcement:enforcement,controlledBy:controlledBy}}}return SiteSettingsMixin}));const AddSiteDialogElementBase=SiteSettingsMixin(PolymerElement);class AddSiteDialogElement extends AddSiteDialogElementBase{static get is(){return"add-site-dialog"}static get template(){return getTemplate$1Y()}static get properties(){return{contentSetting:String,hasIncognito:{type:Boolean,observer:"hasIncognitoChanged_"},cookiesExceptionType:String,site_:String,errorMessage_:String}}metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();connectedCallback(){super.connectedCallback();assert(this.category);assert(this.contentSetting);assert(typeof this.hasIncognito!=="undefined");this.$.dialog.showModal()}validate_(){if(this.$.site.value.trim()===""){this.$.site.invalid=false;this.$.add.disabled=true;return}this.browserProxy.isPatternValidForType(this.site_,this.category).then((({isValid:isValid,reason:reason})=>{this.$.site.invalid=!isValid;this.$.add.disabled=!isValid;this.errorMessage_=reason||""}))}onCancelClick_(){this.$.dialog.cancel()}onSubmit_(){assert(!this.$.add.disabled);let primaryPattern=this.site_;let secondaryPattern=SITE_EXCEPTION_WILDCARD;if(this.cookiesExceptionType===CookiesExceptionType.THIRD_PARTY||this.category===ContentSettingsTypes.TRACKING_PROTECTION){primaryPattern=SITE_EXCEPTION_WILDCARD;secondaryPattern=this.site_}if(this.showIncognitoSessionOnly_()){this.metricsBrowserProxy_.recordBooleanHistogram("Settings.AddSiteDialog.Incognito",this.$.incognito.checked)}this.browserProxy.setCategoryPermissionForPattern(primaryPattern,secondaryPattern,this.category,this.contentSetting,this.$.incognito.checked);this.$.dialog.close()}showIncognitoSessionOnly_(){return this.hasIncognito&&!loadTimeData.getBoolean("isGuest")&&this.contentSetting!==ContentSetting.SESSION_ONLY}hasIncognitoChanged_(){if(!this.hasIncognito){this.$.incognito.checked=false}}}customElements.define(AddSiteDialogElement.is,AddSiteDialogElement);function getTemplate$1X(){return html`<!--_html_template_start_-->    <style include="settings-shared"></style>
    <cr-dialog id="dialog">
      <div slot="title">$i18n{editSiteTitle}</div>
      <div slot="body">
        <cr-input label="$i18n{addSite}" value="{{origin_}}"
            placeholder="$i18n{addSiteExceptionPlaceholder}"
            on-input="validate_" error-message="{{errorMessage_}}"
            invalid="[[invalid_]]" autofocus spellcheck="false">
        </cr-input>
      </div>
      <div slot="button-container">
        <cr-button class="cancel-button" on-click="onCancelClick_"
            id="cancel">$i18n{cancel}</cr-button>
        <cr-button id="actionButton" class="action-button"
            on-click="onActionButtonClick_" disabled="[[invalid_]]">
          $i18n{save}
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`}class SettingsEditExceptionDialogElement extends PolymerElement{static get is(){return"settings-edit-exception-dialog"}static get template(){return getTemplate$1X()}static get properties(){return{model:{type:Object,observer:"modelChanged_"},origin_:String,errorMessage_:String,invalid_:{type:Boolean,value:false}}}browserProxy_=SiteSettingsBrowserProxyImpl.getInstance();connectedCallback(){super.connectedCallback();this.origin_=this.model.origin;this.$.dialog.showModal()}onCancelClick_(){this.$.dialog.close()}onActionButtonClick_(){if(this.model.origin!==this.origin_){this.browserProxy_.resetCategoryPermissionForPattern(this.model.origin,this.model.embeddingOrigin,this.model.category,this.model.incognito);this.browserProxy_.setCategoryPermissionForPattern(this.origin_,SITE_EXCEPTION_WILDCARD,this.model.category,this.model.setting,this.model.incognito)}this.$.dialog.close()}validate_(){if(this.shadowRoot.querySelector("cr-input").value.trim()===""){this.invalid_=true;return}this.browserProxy_.isPatternValidForType(this.origin_,this.model.category).then((({isValid:isValid,reason:reason})=>{this.invalid_=!isValid;this.errorMessage_=reason||""}))}modelChanged_(){if(!this.model){this.$.dialog.cancel()}}}customElements.define(SettingsEditExceptionDialogElement.is,SettingsEditExceptionDialogElement);function getTemplate$1W(){return html`<!--_html_template_start_-->    <style include="settings-shared">:host{padding-inline-end:4px}.settings-row{flex:1}cr-policy-pref-indicator::part(tooltip){clip:rect(0 0 0 0);height:1px;overflow:hidden;width:1px}
    </style>
    <div class="list-item" focus-row-container>
      <div class="settings-row" role="row"
          aria-label="[[computeAriaLabel_(model)]]">
        <div role="gridcell" class="settings-row" on-click="onOriginClick_"
            id="originArea" aria-label="[[computeAriaLabel_(model)]]"
            actionable$="[[allowNavigateToSiteDetail_]]">
          <site-favicon url="[[computeFaviconOrigin_(model)]]"></site-favicon>
          <div class="middle no-min-width">
            <div class="text-elide">
              <span class="url-directionality">
                [[computeDisplayName_(model)]]</span>
            </div>
            <!-- This div must not contain extra whitespace. -->
            <div class="secondary"
                id="siteDescription">[[computeSiteDescription_(model)]]</div>
          </div>

          <template is="dom-if" if="[[allowNavigateToSiteDetail_]]">
            <cr-icon-button class="subpage-arrow"
                aria-label$="[[computeViewButtonAriaLabel_(model)]]"
                aria-describedby="siteDescription"
                aria-roledescription="$i18n{subpageArrowRoleDescription}"
                focus-type="site-details" focus-row-control></cr-icon-button>
            <div class="separator"></div>
          </template>
        </div>
        <template is="dom-if" if="[[showPolicyPrefIndicator_]]">
          <div role="gridcell">
            <cr-policy-pref-indicator pref="[[model]]"
                on-mouseenter="onShowTooltip_"
                on-focus="onShowTooltip_" focus-row-control focus-type="policy">
            </cr-policy-pref-indicator>
          </div>
        </template>
        <template is="dom-if" if="[[model.incognito]]">
          <div role="gridcell">
            <cr-tooltip-icon id="incognitoTooltip"
                icon-aria-label="$i18n{incognitoSiteExceptionDesc}"
                icon-class="settings20:incognito"
                focus-row-control focus-type="incognito"
                on-mouseenter="onShowIncognitoTooltip_"
                on-focus="onShowIncognitoTooltip_"></cr-tooltip-icon>
          </div>
        </template>
        <template is="dom-if"
            if="[[shouldShowResetButton_(model, readOnlyList)]]">
          <div role="gridcell">
            <cr-icon-button id="resetSite" class="icon-delete-gray"
                on-click="onResetButtonClick_"
                aria-label="[[computeRemoveButtonAriaLabel_(model)]]"
                focus-row-control focus-type="reset"></cr-icon-button>
          </div>
        </template>
        <template is="dom-if"
            if="[[shouldShowActionMenu_(model, readOnlyList)]]">
          <div role="gridcell">
            <cr-icon-button id="actionMenuButton" class="icon-more-vert"
                on-click="onShowActionMenuClick_"
                title$="[[getActionMenuButtonLabel_(model)]]"
                focus-row-control focus-type="menu"></cr-icon-button>
          </div>
        </template>
      </div>
    </div>
<!--_html_template_end_-->`}const SiteListEntryElementBase=FocusRowMixin(BaseMixin(SiteSettingsMixin(I18nMixin(PolymerElement))));class SiteListEntryElement extends SiteListEntryElementBase{static get is(){return"site-list-entry"}static get template(){return getTemplate$1W()}static get properties(){return{readOnlyList:{type:Boolean,value:false},model:{type:Object,observer:"onModelChanged_"},singletonEntry:{type:Boolean},sectionHeader:{type:String},chooserType:{type:String,value:ChooserType.NONE},chooserObject:{type:Object,value:null},showPolicyPrefIndicator_:{type:Boolean,computed:"computeShowPolicyPrefIndicator_(model)"},allowNavigateToSiteDetail_:{type:Boolean,value:false},cookiesExceptionType:String}}onShowTooltip_(){const indicator=this.shadowRoot.querySelector("cr-policy-pref-indicator");assert(!!indicator);const text=indicator.indicatorTooltip;this.fire("show-tooltip",{target:indicator,text:text})}onShowIncognitoTooltip_(){const tooltip=this.shadowRoot.querySelector("#incognitoTooltip");const text=loadTimeData.getString("incognitoSiteExceptionDesc");this.fire("show-tooltip",{target:tooltip,text:text})}isIsolatedWebApp_(){return this.model.origin.startsWith("isolated-app://")}isUserEditable_(){return!this.readOnlyList&&!this.model.embeddingOrigin&&!this.isIsolatedWebApp_()}shouldShowResetButton_(){if(this.model===undefined){return false}return this.model.enforcement!==chrome.settingsPrivate.Enforcement.ENFORCED&&!this.isUserEditable_()}shouldShowActionMenu_(){if(this.model===undefined){return false}return this.model.enforcement!==chrome.settingsPrivate.Enforcement.ENFORCED&&this.isUserEditable_()}onOriginClick_(){if(!this.allowNavigateToSiteDetail_){return}Router.getInstance().navigateTo(routes.SITE_SETTINGS_SITE_DETAILS,new URLSearchParams("site="+this.model.origin))}computeDisplayName_(){if(this.model.embeddingOrigin&&(this.model.category===ContentSettingsTypes.COOKIES&&this.model.origin.trim()===SITE_EXCEPTION_WILDCARD||this.model.category===ContentSettingsTypes.TRACKING_PROTECTION)){return this.model.embeddingOrigin}return this.model.displayName}computeAriaLabel_(){if(this.singletonEntry){return`${this.computeDisplayName_()} ${this.sectionHeader}`}return this.computeDisplayName_()}computeRemoveButtonAriaLabel_(){return this.i18n("siteSettingsActionResetFromListA11y",this.computeDisplayName_(),this.sectionHeader)}computeViewButtonAriaLabel_(){return this.i18n("siteSettingsActionViewFromListA11y",this.computeDisplayName_(),this.sectionHeader)}computeFaviconOrigin_(){if(this.model.origin.trim()!==SITE_EXCEPTION_WILDCARD){return this.model.origin.trim()}if(this.model.embeddingOrigin.trim()!==SITE_EXCEPTION_WILDCARD){return this.model.embeddingOrigin.trim()}assertNotReached()}computeSiteDescription_(){let description="";if(this.model.description){description=this.model.description}else if(this.model.isEmbargoed){assert(!this.model.embeddingOrigin,"Embedding origin should be empty for embargoed origin.");description=loadTimeData.getString("siteSettingsSourceEmbargo")}else if(this.model.embeddingOrigin){if(this.model.category===ContentSettingsTypes.COOKIES&&this.model.origin.trim()===SITE_EXCEPTION_WILDCARD){if(this.cookiesExceptionType===CookiesExceptionType.COMBINED){description=loadTimeData.getString("siteSettingsCookiesThirdPartyExceptionLabel")}}else if(this.model.category!==ContentSettingsTypes.TRACKING_PROTECTION){description=loadTimeData.getStringF("embeddedOnHost",this.sanitizePort(this.model.embeddingOrigin))}}try{const url=new URL(this.model.origin);if(url.protocol==="chrome-extension:"){description=loadTimeData.getStringF("siteSettingsExtensionIdDescription",url.hostname)}}finally{return description}}computeShowPolicyPrefIndicator_(){return this.model.enforcement===chrome.settingsPrivate.Enforcement.ENFORCED&&!!this.model.controlledBy}onResetButtonClick_(){this.fire("site-list-entry-reset-click");if(this.chooserType!==ChooserType.NONE&&this.chooserObject!==null){this.browserProxy.resetChooserExceptionForSite(this.chooserType,this.model.origin,this.chooserObject);return}this.browserProxy.resetCategoryPermissionForPattern(this.model.origin,this.model.embeddingOrigin,this.model.category,this.model.incognito)}onShowActionMenuClick_(){if(this.chooserType!==ChooserType.NONE){return}this.fire("show-action-menu",{anchor:this.shadowRoot.querySelector("#actionMenuButton"),model:this.model})}onModelChanged_(){if(!this.model){this.allowNavigateToSiteDetail_=false;return}this.browserProxy.isOriginValid(this.model.origin).then((valid=>{this.allowNavigateToSiteDetail_=valid}))}getActionMenuButtonLabel_(){return this.i18n("siteDataPageAddSiteContextMenuLabel",this.computeDisplayName_())}setSectionHeaderForTest(sectionHeader){this.sectionHeader=sectionHeader}}customElements.define(SiteListEntryElement.is,SiteListEntryElement);function getTemplate$1V(){return html`<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">#addSite{margin-inline-start:var(--cr-button-edge-spacing)}
    </style>
    <div id="category">
      <div class="cr-row first">
        <h2 id="listHeader" class="flex secondary" tabIndex="-1">
          [[categoryHeader]]
        </h2>
        <cr-button id="addSite" class="header-aligned-button"
            hidden$="[[!showAddSiteButton_]]" on-click="onAddSiteClick_"
            aria-label$="[[getAddButtonLabel_()]]">
          $i18n{add}
        </cr-button>
      </div>
      <div hidden$="[[!showHeaderWarning_(
              sites.*,systemPermissionWarningKey_)]]"
          id="systemPermissionDeclinedWarning"
          class="list-frame">
        <div class="list-item secondary">
          <div inner-h-t-m-l="[[getSystemPermissionWarning_(
                  systemPermissionWarningKey_)]]">
          </div>
        </div>
      </div>
      <cr-action-menu role-description="$i18n{menu}">
        <button class="dropdown-item" id="allow"
            on-click="onAllowClick_" hidden$="[[!showAllowAction_]]">
          $i18n{siteSettingsActionAllow}
        </button>
        <button class="dropdown-item" id="block"
            on-click="onBlockClick_" hidden$="[[!showBlockAction_]]">
          $i18n{siteSettingsActionBlock}
        </button>
        <button class="dropdown-item" id="sessionOnly"
            on-click="onSessionOnlyClick_"
            hidden$="[[!showSessionOnlyActionForSite_(actionMenuSite_)]]">
          $i18n{siteSettingsActionSessionOnly}
        </button>
        <button class="dropdown-item" id="edit"
            on-click="onEditClick_">
          $i18n{edit}
        </button>
        <button class="dropdown-item" id="reset"
            on-click="onResetClick_">
          $i18n{siteSettingsActionReset}
        </button>
      </cr-action-menu>

      <div class="list-frame" hidden$="[[hasSites_(sites.*)]]">
        <div class="list-item secondary">$i18n{noSitesAdded}</div>
      </div>
      <div class="list-frame"
          hidden$="[[!showNoSearchResults_(searchFilter, sites.*)]]">
        <div class="list-item secondary">$i18n{searchNoResults}</div>
      </div>
      <div class="list-frame menu-content vertical-list" id="listContainer"
          hidden$="[[!hasSites_(sites.*)]]">
        <iron-list items="[[getFilteredSites_(searchFilter, sites.*)]]"
            role="grid" aria-labelledby="listHeader"
            aria-describedby="[[categoryHeader]]" preserve-focus risk-selection>
          <template>
            <site-list-entry model="[[item]]" read-only-list="[[readOnlyList]]"
                on-show-action-menu="onShowActionMenu_"
                singleton-entry="[[hasOneFilteredSite_(searchFilter, sites.*)]]"
                section-header="[[categoryHeader]]" tabindex$="[[tabIndex]]"
                first$="[[!index]]" iron-list-tab-index="[[tabIndex]]"
                last-focused="{{lastFocused_}}" list-blurred="{{listBlurred_}}"
                on-show-tooltip="onShowTooltip_" focus-row-index="[[index]]"
                on-site-list-entry-reset-click="onResetEntry_"
                cookies-exception-type="[[cookiesExceptionType]]">
            </site-list-entry>
          </template>
        </iron-list>
      </div>
    </div>
    <cr-tooltip id="tooltip" hidden="[[!tooltipText_]]"
        fit-to-visible-bounds manual-mode position="top">
      [[tooltipText_]]
    </cr-tooltip>
    <template is="dom-if" if="[[showEditExceptionDialog_]]" restamp>
      <settings-edit-exception-dialog model="[[actionMenuSite_]]"
          on-close="onEditExceptionDialogClosed_">
      </settings-edit-exception-dialog>
    </template>
    <template is="dom-if" if="[[showAddSiteDialog_]]" restamp>
      <add-site-dialog has-incognito="[[hasIncognito_]]" category="[[category]]"
          content-setting="[[categorySubtype]]"
          on-close="onAddSiteDialogClosed_"
          cookies-exception-type="[[cookiesExceptionType]]">
      </add-site-dialog>
    </template>
<!--_html_template_end_-->`}const SiteListElementBase=TooltipMixin(ListPropertyUpdateMixin(SiteSettingsMixin(WebUiListenerMixin(I18nMixin(PolymerElement)))));class SiteListElement extends SiteListElementBase{static get is(){return"site-list"}static get template(){return getTemplate$1V()}static get properties(){return{readOnlyList:{type:Boolean,value:false},categoryHeader:String,systemPermissionWarningKey_:{type:String,value:null,observer:"attachSystemPermissionSettingsLinkClick_"},actionMenuSite_:Object,showEditExceptionDialog_:Boolean,sites:{type:Array,value(){return[]}},categorySubtype:{type:String,value:INVALID_CATEGORY_SUBTYPE},cookiesExceptionType:String,hasIncognito_:Boolean,showAddSiteButton_:{type:Boolean,computed:"computeShowAddSiteButton_(readOnlyList, category, "+"categorySubtype)"},showAddSiteDialog_:Boolean,showAllowAction_:Boolean,showBlockAction_:Boolean,showSessionOnlyAction_:Boolean,lastFocused_:Object,listBlurred_:Boolean,tooltipText_:String,searchFilter:String}}static get observers(){return["configureWidget_(category, categorySubtype)"]}activeDialogAnchor_;browserProxy_=SiteSettingsBrowserProxyImpl.getInstance();constructor(){super();this.updateCategoryWarning_();this.activeDialogAnchor_=null}ready(){super.ready();this.addWebUiListener("contentSettingSitePermissionChanged",(category=>this.siteWithinCategoryChanged_(category)));this.addWebUiListener("contentSettingCategoryChanged",(category=>this.siteWithinCategoryChanged_(category)));this.addWebUiListener("onIncognitoStatusChanged",(hasIncognito=>this.onIncognitoStatusChanged_(hasIncognito)));this.addWebUiListener("osGlobalPermissionChanged",(messages=>{this.setCategoryWarning_(messages.includes(this.category))}));this.browserProxy.updateIncognitoStatus()}updateCategoryWarning_(){this.browserProxy.getSystemDeniedPermissions().then((messages=>{this.setCategoryWarning_(messages.includes(this.category))}))}setCategoryWarning_(categoryBlocked){this.set("systemPermissionWarningKey_",(category=>{if(!categoryBlocked){return null}switch(category){case ContentSettingsTypes.CAMERA:return"siteSettingsContentCameraBlockedByOs";case ContentSettingsTypes.MIC:return"siteSettingsContentMicBlockedByOs";case ContentSettingsTypes.GEOLOCATION:return"siteSettingsContentLocationBlockedByOs";default:return null}})(this.category))}siteWithinCategoryChanged_(category){if(category===this.category||this.category===ContentSettingsTypes.TRACKING_PROTECTION&&category===ContentSettingsTypes.COOKIES){this.configureWidget_()}}onIncognitoStatusChanged_(hasIncognito){this.hasIncognito_=hasIncognito;if(this.categorySubtype===ContentSetting.SESSION_ONLY){return}this.populateList_()}configureWidget_(){if(this.category===undefined){return}this.setUpActionMenu_();this.populateList_();if(this.categorySubtype===ContentSetting.SESSION_ONLY){this.$.category.hidden=this.category!==ContentSettingsTypes.COOKIES}}hasSites_(){return this.sites.length>0}showHeaderWarning_(){return this.hasSites_()&&this.systemPermissionWarningKey_!==null}getSystemPermissionWarning_(){const sanitizeOptions={tags:["a"],attrs:["id"]};if(this.systemPermissionWarningKey_!==null){return this.i18nAdvanced(this.systemPermissionWarningKey_,sanitizeOptions)}return sanitizeInnerHtml("")}onSystemPermissionSettingsLinkClick_(event){event.preventDefault();if(this.category!==null){this.browserProxy.openSystemPermissionSettings(this.category)}}attachSystemPermissionSettingsLinkClick_(){const elementId="openSystemSettingsLink";const element=this.shadowRoot?.querySelector(`#${elementId}`);if(element!==null&&element!==undefined){element.addEventListener("click",(me=>{this.onSystemPermissionSettingsLinkClick_(me)}));const settingsPageName=(()=>{switch(this.category){case ContentSettingsTypes.CAMERA:return"Camera";case ContentSettingsTypes.MIC:return"Microphone";case ContentSettingsTypes.GEOLOCATION:return"Location";default:return null}})();if(settingsPageName){element.setAttribute("aria-label",`System Settings: ${settingsPageName}`)}}}computeShowAddSiteButton_(){return!(this.readOnlyList||this.category===ContentSettingsTypes.FILE_SYSTEM_WRITE&&this.categorySubtype===ContentSetting.ALLOW)}showNoSearchResults_(){return this.sites.length>0&&this.getFilteredSites_().length===0}onAddSiteClick_(){assert(!this.readOnlyList);this.showAddSiteDialog_=true}onAddSiteDialogClosed_(){this.showAddSiteDialog_=false;focusWithoutInk(this.$.addSite)}onShowTooltip_(e){this.tooltipText_=e.detail.text;this.showTooltipAtTarget(this.$.tooltip,e.detail.target)}populateList_(){this.browserProxy_.getExceptionList(this.category).then((exceptionList=>{this.processExceptions_(exceptionList);this.closeActionMenu_()}))}processExceptions_(exceptionList){const sites=exceptionList.filter((site=>site.setting!==ContentSetting.DEFAULT&&site.setting===this.categorySubtype)).filter((site=>{if(this.category!==ContentSettingsTypes.COOKIES){return true}assert(this.cookiesExceptionType!==undefined);switch(this.cookiesExceptionType){case CookiesExceptionType.THIRD_PARTY:return site.origin===SITE_EXCEPTION_WILDCARD;case CookiesExceptionType.SITE_DATA:return site.origin!==SITE_EXCEPTION_WILDCARD;case CookiesExceptionType.COMBINED:return true}})).map((site=>this.expandSiteException(site)));this.updateList("sites",(x=>x.origin),sites)}setUpActionMenu_(){this.showAllowAction_=this.categorySubtype!==ContentSetting.ALLOW;this.showBlockAction_=this.categorySubtype!==ContentSetting.BLOCK;this.showSessionOnlyAction_=this.categorySubtype!==ContentSetting.SESSION_ONLY&&this.category===ContentSettingsTypes.COOKIES}showSessionOnlyActionForSite_(){if(!this.actionMenuSite_||this.actionMenuSite_.incognito){return false}return this.showSessionOnlyAction_}setContentSettingForActionMenuSite_(contentSetting){assert(this.actionMenuSite_);this.browserProxy.setCategoryPermissionForPattern(this.actionMenuSite_.origin,this.actionMenuSite_.embeddingOrigin,this.category,contentSetting,this.actionMenuSite_.incognito)}onAllowClick_(){const shouldMoveFocus=this.hasOneFilteredSite_();this.setContentSettingForActionMenuSite_(ContentSetting.ALLOW);this.closeActionMenu_();if(shouldMoveFocus){this.$.listHeader.focus()}}onBlockClick_(){const shouldMoveFocus=this.hasOneFilteredSite_();this.setContentSettingForActionMenuSite_(ContentSetting.BLOCK);this.closeActionMenu_();if(shouldMoveFocus){this.$.listHeader.focus()}}onSessionOnlyClick_(){this.setContentSettingForActionMenuSite_(ContentSetting.SESSION_ONLY);this.closeActionMenu_()}onEditClick_(){this.shadowRoot.querySelector("cr-action-menu").close();this.showEditExceptionDialog_=true}onEditExceptionDialogClosed_(){this.showEditExceptionDialog_=false;this.actionMenuSite_=null;if(this.activeDialogAnchor_){this.activeDialogAnchor_.focus();this.activeDialogAnchor_=null}}onResetClick_(){const shouldMoveFocus=this.hasOneFilteredSite_();assert(this.actionMenuSite_);this.browserProxy.resetCategoryPermissionForPattern(this.actionMenuSite_.origin,this.actionMenuSite_.embeddingOrigin,this.category,this.actionMenuSite_.incognito);this.closeActionMenu_();if(shouldMoveFocus){this.$.listHeader.focus()}}onShowActionMenu_(e){this.activeDialogAnchor_=e.detail.anchor;this.actionMenuSite_=e.detail.model;this.shadowRoot.querySelector("cr-action-menu").showAt(this.activeDialogAnchor_)}onResetEntry_(){if(this.hasOneFilteredSite_()){this.$.listHeader.focus()}}closeActionMenu_(){this.actionMenuSite_=null;this.activeDialogAnchor_=null;const actionMenu=this.shadowRoot.querySelector("cr-action-menu");if(actionMenu.open){actionMenu.close()}}getFilteredSites_(){if(!this.searchFilter){return this.sites.slice()}const propNames=["displayName","origin","embeddingOrigin"];const searchFilter=this.searchFilter.toLowerCase();return this.sites.filter((site=>propNames.some((propName=>site[propName].toLowerCase().includes(searchFilter)))))}hasOneFilteredSite_(){return this.getFilteredSites_().length===1}getAddButtonLabel_(){if(this.categorySubtype===ContentSetting.ALLOW){return this.i18n("siteDataPageAddSiteToAllowListLabel")}else if(this.categorySubtype===ContentSetting.BLOCK){return this.i18n("siteDataPageAddSiteToBlockListLabel")}else{return""}}}customElements.define(SiteListElement.is,SiteListElement);function getTemplate$1U(){return html`<!--_html_template_start_-->    <style include="settings-shared">.toggle{padding:0 var(--cr-section-padding);margin-bottom:var(--cr-section-vertical-padding)}
    </style>
    <settings-toggle-button id="toggle" class="toggle"
      label="$i18n{doNotTrack}"
      pref="{{prefs.enable_do_not_track}}"
      on-settings-boolean-control-change="onToggleChange_"
      sub-label="$i18n{trackingProtectionDoNotTrackToggleSubLabel}"
      icon="settings:forward"
      no-set-pref>
    </settings-toggle-button>
    <template is="dom-if" if="[[showDialog_]]"
        on-dom-change="onDomChange_" restamp>
      <cr-dialog id="confirmDialog"
          close-text="$i18n{close}" on-cancel="onDialogCancel_"
          on-close="onDialogClosed_">
        <div slot="title">$i18n{doNotTrackDialogTitle}</div>
        <div slot="body">$i18n{doNotTrackDialogMessage}
          <a href="$i18nRaw{doNotTrackLearnMoreURL}" target="_blank"
              aria-description="$i18n{opensInNewTab}"
              aria-label="$i18n{doNotTrackDialogLearnMoreA11yLabel}">
            $i18n{learnMore}
          </a>
        </div>
        <div slot="button-container">
          <cr-button class="cancel-button"
              on-click="onDialogCancel_">
            $i18n{cancel}
          </cr-button>
          <cr-button class="action-button"
              on-click="onDialogConfirm_">
            $i18n{confirm}
          </cr-button>
        </div>
      </cr-dialog>
    </template>
<!--_html_template_end_-->`}class SettingsDoNotTrackToggleElement extends PolymerElement{static get is(){return"settings-do-not-track-toggle"}static get template(){return getTemplate$1U()}static get properties(){return{prefs:{type:Object,notify:true},showDialog_:{type:Boolean,value:false}}}onDomChange_(){if(this.showDialog_){this.shadowRoot.querySelector("cr-dialog").showModal()}}onToggleChange_(event){MetricsBrowserProxyImpl.getInstance().recordSettingsPageHistogram(PrivacyElementInteractions.DO_NOT_TRACK);const target=event.target;if(!target.checked){target.sendPrefChange();return}this.showDialog_=true}closeDialog_(){this.shadowRoot.querySelector("cr-dialog").close();this.showDialog_=false}onDialogClosed_(){focusWithoutInk(this.toggle_)}onDialogConfirm_(){this.toggle_.sendPrefChange();this.closeDialog_()}onDialogCancel_(){this.toggle_.resetToPrefValue();this.closeDialog_()}get toggle_(){return this.shadowRoot.querySelector("#toggle")}}customElements.define(SettingsDoNotTrackToggleElement.is,SettingsDoNotTrackToggleElement);function getTemplate$1T(){return html`<!--_html_template_start_-->  <style include="settings-shared">#explanationText,#generalControls{padding:0 var(--cr-section-padding)}#default,#additionalProtections{padding:16px var(--cr-section-padding) 8px var(--cr-section-padding)}#defaultHeader{padding-top:0;padding-bottom:6px}#exceptionHeader3pcd{padding:0 var(--cr-section-padding);margin-bottom:-32px}#explanationText{padding-bottom:var(--cr-section-vertical-padding)}#blockThirdPartyToggle{padding:0 var(--cr-section-padding)}.radio-group-sub-heading{padding-bottom:10px}.bullet-row{align-items:center;display:flex;padding:var(--cr-section-vertical-padding) var(--cr-section-padding)}.bullet-row>div{padding-left:var(--cr-section-padding);padding-right:40px}.bullet-line{align-items:center;display:flex;min-height:var(--cr-section-two-line-min-height)}.bullet-line.one-line{min-height:var(--cr-section-min-height)}.bullet-line>div{padding-inline-start:var(--cr-radio-button-size)}settings-collapse-radio-button{--settings-collapse-toggle-min-height:var(--cr-section-min-height)}settings-collapse-radio-button:not(:first-of-type){--settings-collapse-separator-line:var(--cr-separator-line)}settings-collapse-radio-button .bullet-line:last-child{padding-bottom:12px}#relatedWebsiteSetsToggle,#relatedWebsiteSetsToggle3pcSetting{padding-inline-end:0;padding-inline-start:0}#toastText{align-items:center;display:flex;max-width:300px;min-height:var(--cr-section-two-line-min-height)}
  </style>
  <settings-subpage
      hide-close-button
      page-title="$i18n{thirdPartyCookiesPageTitle}"
      learn-more-url="$i18n{cookiesSettingsHelpCenterURL}"
      search-label="$i18n{siteSettingsAllSitesFilter}"
      search-icon="settings20:filter-list"
      search-term="{{searchTerm}}" route-path$="[[routePath]]">
    <template is="dom-if" if="[[!is3pcdRedesignEnabled_]]">
      <div id="explanationText" class="secondary">
        $i18n{thirdPartyCookiesPageDescription}
      </div>
      <div id="generalControls">
        <settings-radio-group id="thirdPartyCookieBlockingSettingGroup" no-set-pref
            pref="{{prefs.generated.third_party_cookie_blocking_setting}}"
            selectable-elements="cr-radio-button, settings-collapse-radio-button"
            on-change="onThirdPartyCookieBlockingSettingChanged_">
          <settings-collapse-radio-button id="block3pcIncognito"
              pref="[[prefs.generated.third_party_cookie_blocking_setting]]"
              name="[[thirdPartyCookieBlockingSettingEnum_.INCOGNITO_ONLY]]"
              label="$i18n{thirdPartyCookiesPageAllowRadioLabel}"
              expand-aria-label="$i18n{allowThirdPartyCookiesExpandA11yLabel}">
            <div slot="collapse">
              <div class="bullet-line">
                <cr-icon icon="privacy:cookie"></cr-icon>
                <div class="secondary">
                  $i18n{cookiePageSettingsAllowBulletOne}
                </div>
              </div>
              <div class="bullet-line one-line">
                <cr-icon icon="settings20:web"></cr-icon>
                <div class="secondary">
                  $i18n{cookiePageSettingsAllowBulletTwo}
                </div>
              </div>
              <div class="bullet-line one-line">
                <cr-icon icon="settings20:incognito-unfilled"></cr-icon>
                <div class="secondary">
                  $i18n{cookiePageSettingsAllowBulletThree}
                </div>
              </div>
            </div>
          </settings-collapse-radio-button>
          <settings-collapse-radio-button id="blockAll3pc"
              pref="[[prefs.generated.third_party_cookie_blocking_setting]]"
              name="[[thirdPartyCookieBlockingSettingEnum_.BLOCK_THIRD_PARTY]]"
              label="$i18n{thirdPartyCookiesPageBlockRadioLabel}"
              expand-aria-label="$i18n{blockThirdPartyCookiesExpandA11yLabel}">
            <div slot="collapse">
              <div class="bullet-line">
                <cr-icon icon="settings:block"></cr-icon>
                <div class="secondary">
                  $i18n{cookiePageSettingsBlockBulletOne}
                </div>
              </div>
              <div class="bullet-line one-line">
                <cr-icon icon="privacy:cookie"></cr-icon>
                <div class="secondary">
                  $i18n{cookiePageSettingsBlockBulletTwo}
                </div>
              </div>
              <div class="bullet-line one-line">
                <cr-icon icon="settings20:broken"></cr-icon>
                <div class="secondary">
                  $i18n{cookiePageSettingsBlockBulletThree}
                </div>
              </div>
            </div>
            <div slot="noSelectionCollapse">
              <settings-toggle-button id="relatedWebsiteSetsToggle3pcSetting"
                  pref="{{prefs.privacy_sandbox.first_party_sets_enabled}}"
                  label="$i18n{cookiePageRwsLabel}"
                  sub-label="$i18n{cookiePageRwsSubLabel}"
                  disabled="[[relatedWebsiteSetsToggle3pcSettingDisabled_(
                                prefs.generated.third_party_cookie_blocking_setting.value)]]">
              </settings-toggle-button>
            </div>
          </settings-collapse-radio-button>
        </settings-radio-group>
      </div>
    </template>
    <template is="dom-if" if="[[is3pcdRedesignEnabled_]]">
      <div id="default" class="secondary">
        $i18n{trackingProtectionPageDescription}
      </div>
      <div>
        <div class="bullet-row">
          <cr-icon icon="settings:visibility-off" aria-hidden="true">
          </cr-icon>
          <div>
            $i18n{trackingProtectionBulletOne}
            <div class="secondary">
              $i18n{trackingProtectionBulletOneDescription}
            </div>
          </div>
        </div>
        <div class="bullet-row">
          <cr-icon icon="settings:domain-verification" aria-hidden="true">
          </cr-icon>
          <div>
            $i18n{trackingProtectionBulletTwo}
            <div class="secondary" hidden>
              $i18nRaw{trackingProtectionBulletTwoDescription}
            </div>
          </div>
        </div>
      </div>
    </template>
    <h2 id="additionalProtections">
      $i18n{trackingProtectionAdvancedLabel}
    </h2>
    <template is="dom-if" if="[[is3pcdRedesignEnabled_]]">
      <settings-toggle-button
          id="blockThirdPartyToggle"
          pref="{{prefs.tracking_protection.block_all_3pc_toggle_enabled}}"
          label="$i18n{trackingProtectionThirdPartyCookiesToggleLabel}"
          sub-label="
            $i18n{trackingProtectionThirdPartyCookiesToggleSubLabel}"
          learn-more-url="
            $i18n{trackingProtectionThirdPartyCookiesLearnMoreUrl}"
          learn-more-aria-label="
            $i18n{trackingProtectionThirdPartyCookiesLearnMoreAriaLabel}"
          on-settings-boolean-control-change="onBlockAll3pcToggleChanged_"
          icon="settings:visibility-off">
      </settings-toggle-button>
    </template>
    <settings-do-not-track-toggle id="doNotTrack" prefs="{{prefs}}">
    </settings-do-not-track-toggle>
    <cr-link-row id="siteDataTrigger" class="hr"
        on-click="onSiteDataClick_" label="$i18n{cookiePageAllSitesLink}"
        role-description="$i18n{subpageArrowRoleDescription}">
    </cr-link-row>
    <div id="exceptionHeader3pcd">
      <h2>$i18n{trackingProtectionSitesAllowedCookiesTitle}</h2>
    </div>
    <site-list id="allow3pcExceptionsList"
        category="[[cookiesContentSettingType_]]"
        category-subtype="[[contentSettingEnum_.ALLOW]]"
        category-header="$i18n{trackingProtectionSitesAllowedCookiesDescription}"
        search-filter="[[searchTerm]]"
        cookies-exception-type="third-party">
    </site-list>
    <cr-toast id="toast">
      <div id="toastText">$i18n{privacySandboxCookiesDialog}</div>
      <cr-button on-click="onPrivacySandboxClick_">
        $i18n{privacySandboxCookiesDialogMore}
      </cr-button>
      <a id="privacySandboxLink" href="adPrivacy"
          target="_blank" tabindex="-1" aria-disabled="true"
          role="none"></a>
    </cr-toast>
  </settings-subpage>
<!--_html_template_end_-->`}const SettingsCookiesPageElementBase=RouteObserverMixin(SettingsViewMixin(WebUiListenerMixin(I18nMixin(PrefsMixin(PolymerElement)))));class SettingsCookiesPageElement extends SettingsCookiesPageElementBase{static get is(){return"settings-cookies-page"}static get template(){return getTemplate$1T()}static get properties(){return{searchTerm:{type:String,notify:true,value:""},cookieControlsModeEnum_:{type:Object,value:CookieControlsMode},thirdPartyCookieBlockingSettingEnum_:{type:Object,value:ThirdPartyCookieBlockingSetting},contentSettingEnum_:{type:Object,value:ContentSetting},cookiesContentSettingType_:{type:String,value:ContentSettingsTypes.COOKIES},blockAllPref_:{type:Object,value(){return{}}},is3pcdRedesignEnabled_:{type:Boolean,value:()=>loadTimeData.getBoolean("is3pcdCookieSettingsRedesignEnabled")}}}metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();currentRouteChanged(newRoute,oldRoute){super.currentRouteChanged(newRoute,oldRoute);if(newRoute!==routes.COOKIES){this.$.toast.hide()}}onSiteDataClick_(){Router.getInstance().navigateTo(routes.SITE_SETTINGS_ALL)}onBlockAll3pcToggleChanged_(event){this.metricsBrowserProxy_.recordSettingsPageHistogram(PrivacyElementInteractions.BLOCK_ALL_THIRD_PARTY_COOKIES);const target=event.target;if(target.checked){this.metricsBrowserProxy_.recordAction("Settings.PrivacySandbox.Block3PCookies")}}showOrHideToast(switchedToBlock3pcs){const areAnyPrivacySandboxApisEnabled=this.getPref("privacy_sandbox.m1.topics_enabled").value||this.getPref("privacy_sandbox.m1.fledge_enabled").value||this.getPref("privacy_sandbox.m1.ad_measurement_enabled").value;if(areAnyPrivacySandboxApisEnabled&&switchedToBlock3pcs){if(!loadTimeData.getBoolean("isPrivacySandboxRestricted")){this.$.toast.show()}this.metricsBrowserProxy_.recordAction("Settings.PrivacySandbox.Block3PCookies")}else{this.$.toast.hide()}}onCookieControlsModeChanged_(){const primarySettingGroup=this.shadowRoot.querySelector("#primarySettingGroup");const selection=Number(primarySettingGroup.selected);if(selection===CookieControlsMode.OFF){this.metricsBrowserProxy_.recordSettingsPageHistogram(PrivacyElementInteractions.THIRD_PARTY_COOKIES_ALLOW)}else if(selection===CookieControlsMode.INCOGNITO_ONLY){this.metricsBrowserProxy_.recordSettingsPageHistogram(PrivacyElementInteractions.THIRD_PARTY_COOKIES_BLOCK_IN_INCOGNITO)}else{assert(selection===CookieControlsMode.BLOCK_THIRD_PARTY);this.metricsBrowserProxy_.recordSettingsPageHistogram(PrivacyElementInteractions.THIRD_PARTY_COOKIES_BLOCK)}const currentCookieControlsMode=this.getPref("profile.cookie_controls_mode").value;this.showOrHideToast((currentCookieControlsMode===CookieControlsMode.OFF||currentCookieControlsMode===CookieControlsMode.INCOGNITO_ONLY)&&selection===CookieControlsMode.BLOCK_THIRD_PARTY);primarySettingGroup.sendPrefChange()}onThirdPartyCookieBlockingSettingChanged_(){const thirdPartyCookieBlockingSettingGroup=this.shadowRoot.querySelector("#thirdPartyCookieBlockingSettingGroup");const selection=Number(thirdPartyCookieBlockingSettingGroup.selected);if(selection===ThirdPartyCookieBlockingSetting.INCOGNITO_ONLY){this.metricsBrowserProxy_.recordSettingsPageHistogram(PrivacyElementInteractions.THIRD_PARTY_COOKIES_BLOCK_IN_INCOGNITO);this.metricsBrowserProxy_.recordAction("Settings.ThirdPartyCookies.Allow")}else{assert(selection===ThirdPartyCookieBlockingSetting.BLOCK_THIRD_PARTY);this.metricsBrowserProxy_.recordSettingsPageHistogram(PrivacyElementInteractions.THIRD_PARTY_COOKIES_BLOCK);this.metricsBrowserProxy_.recordAction("Settings.ThirdPartyCookies.Block")}const currentThirdPartyCookieBlockingSetting=this.getPref("generated.third_party_cookie_blocking_setting").value;this.showOrHideToast(currentThirdPartyCookieBlockingSetting===ThirdPartyCookieBlockingSetting.INCOGNITO_ONLY&&selection===ThirdPartyCookieBlockingSetting.BLOCK_THIRD_PARTY);thirdPartyCookieBlockingSettingGroup.sendPrefChange()}onPrivacySandboxClick_(){this.metricsBrowserProxy_.recordAction("Settings.PrivacySandbox.OpenedFromCookiesPageToast");this.$.toast.hide();this.shadowRoot.querySelector("#privacySandboxLink").click()}relatedWebsiteSetsToggleDisabled_(){return this.getPref("profile.cookie_controls_mode").value!==CookieControlsMode.BLOCK_THIRD_PARTY}relatedWebsiteSetsToggle3pcSettingDisabled_(){return this.getPref("generated.third_party_cookie_blocking_setting").value!==ThirdPartyCookieBlockingSetting.BLOCK_THIRD_PARTY}getFocusConfig(){return new Map([[`${routes.SITE_SETTINGS_ALL.path}_${routes.COOKIES.path}`,"#siteDataTrigger"]])}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsCookiesPageElement.is,SettingsCookiesPageElement);function getTemplate$1S(){return html`<!--_html_template_start_-->    <style include="settings-shared">cr-input{display:inline-block;padding-inline-end:2em;--cr-input-width:8em}
    </style>

    <p>$i18n{securityKeysPINPrompt}</p>
    <cr-input id="pin" value="{{value_}}" min-length="[[minPinLength]]"
        max-length="255" spellcheck="false"
        on-input="onPinInput_"
        invalid="[[isNonEmpty_(error_)]]"
        label="$i18n{securityKeysPIN}"
        type$="[[inputType_(inputVisible_)]]"
        error-message="[[error_]]">
      <cr-icon-button slot="suffix" id="showButton"
          class$="[[showButtonClass_(inputVisible_)]]"
          title="[[showButtonTitle_(inputVisible_)]]"
          focus-row-control focus-type="showPassword"
          on-click="showButtonClick_"></cr-icon-button>
    </cr-input>
<!--_html_template_end_-->`}const SettingsSecurityKeysPinFieldElementBase=I18nMixin(PolymerElement);class SettingsSecurityKeysPinFieldElement extends SettingsSecurityKeysPinFieldElementBase{static get is(){return"settings-security-keys-pin-field"}static get template(){return getTemplate$1S()}static get properties(){return{minPinLength:{value:4,type:Number},error_:{type:String,observer:"errorChanged_"},value_:String,inputVisible_:{type:Boolean,value:false}}}focus(){this.$.pin.focus()}validate_(){const error=this.isValidPin_(this.value_);if(error!==""){this.error_=error;return false}return true}trySubmit(submitFunc){if(!this.validate_()){this.focus();return Promise.reject()}return submitFunc(this.value_).then((retries=>{if(retries!==null){this.showIncorrectPinError_(retries);this.focus();return Promise.reject()}return}))}showIncorrectPinError_(retries){let error;if(1<retries&&retries<=3){error=this.i18n("securityKeysPINIncorrectRetriesPl",retries.toString())}else if(retries===1){error=this.i18n("securityKeysPINIncorrectRetriesSin")}else{error=this.i18n("securityKeysPINIncorrect")}this.error_=error}onPinInput_(){this.error_=""}isNonEmpty_(s){return s!==""}inputType_(){return this.inputVisible_?"text":"password"}showButtonClass_(){return"icon-visibility"+(this.inputVisible_?"-off":"")}showButtonTitle_(){return this.i18n(this.inputVisible_?"securityKeysHidePINs":"securityKeysShowPINs")}showButtonClick_(){this.inputVisible_=!this.inputVisible_}isValidPin_(pin){const utf8Encoded=(new TextEncoder).encode(pin);if(utf8Encoded.length<this.minPinLength){return this.i18n("securityKeysPINTooShort")}if(utf8Encoded.length>63||utf8Encoded[utf8Encoded.length-1]===0){return this.i18n("securityKeysPINTooLong")}let length=0;for(const _codepoint of pin){length++}if(length<this.minPinLength){return this.i18n("securityKeysPINTooShort")}return""}errorChanged_(){getInstance().announce(this.error_)}}customElements.define(SettingsSecurityKeysPinFieldElement.is,SettingsSecurityKeysPinFieldElement);var Ctap2Status;(function(Ctap2Status){Ctap2Status[Ctap2Status["OK"]=0]="OK";Ctap2Status[Ctap2Status["ERR_FP_DATABASE_FULL"]=23]="ERR_FP_DATABASE_FULL";Ctap2Status[Ctap2Status["ERR_INVALID_OPTION"]=44]="ERR_INVALID_OPTION";Ctap2Status[Ctap2Status["ERR_KEEPALIVE_CANCEL"]=45]="ERR_KEEPALIVE_CANCEL"})(Ctap2Status||(Ctap2Status={}));var SampleStatus;(function(SampleStatus){SampleStatus[SampleStatus["OK"]=0]="OK"})(SampleStatus||(SampleStatus={}));class SecurityKeysPinBrowserProxyImpl{startSetPin(){return sendWithPromise("securityKeyStartSetPIN")}setPin(oldPIN,newPIN){return sendWithPromise("securityKeySetPIN",oldPIN,newPIN)}close(){chrome.send("securityKeyPINClose")}static getInstance(){return pinBrowserProxyInstance||(pinBrowserProxyInstance=new SecurityKeysPinBrowserProxyImpl)}static setInstance(obj){pinBrowserProxyInstance=obj}}let pinBrowserProxyInstance=null;class SecurityKeysCredentialBrowserProxyImpl{startCredentialManagement(){return sendWithPromise("securityKeyCredentialManagementStart")}providePin(pin){return sendWithPromise("securityKeyCredentialManagementPIN",pin)}enumerateCredentials(){return sendWithPromise("securityKeyCredentialManagementEnumerate")}deleteCredentials(ids){return sendWithPromise("securityKeyCredentialManagementDelete",ids)}updateUserInformation(credentialId,userHandle,newUsername,newDisplayname){return sendWithPromise("securityKeyCredentialManagementUpdate",credentialId,userHandle,newUsername,newDisplayname)}close(){chrome.send("securityKeyCredentialManagementClose")}static getInstance(){return credentialBrowserProxyInstance||(credentialBrowserProxyInstance=new SecurityKeysCredentialBrowserProxyImpl)}static setInstance(obj){credentialBrowserProxyInstance=obj}}let credentialBrowserProxyInstance=null;class SecurityKeysResetBrowserProxyImpl{reset(){return sendWithPromise("securityKeyReset")}completeReset(){return sendWithPromise("securityKeyCompleteReset")}close(){chrome.send("securityKeyResetClose")}static getInstance(){return resetBrowserProxyInstance||(resetBrowserProxyInstance=new SecurityKeysResetBrowserProxyImpl)}static setInstance(obj){resetBrowserProxyInstance=obj}}let resetBrowserProxyInstance=null;class SecurityKeysBioEnrollProxyImpl{startBioEnroll(){return sendWithPromise("securityKeyBioEnrollStart")}providePin(pin){return sendWithPromise("securityKeyBioEnrollProvidePIN",pin)}getSensorInfo(){return sendWithPromise("securityKeyBioEnrollGetSensorInfo")}enumerateEnrollments(){return sendWithPromise("securityKeyBioEnrollEnumerate")}startEnrolling(){return sendWithPromise("securityKeyBioEnrollStartEnrolling")}cancelEnrollment(){chrome.send("securityKeyBioEnrollCancel")}deleteEnrollment(id){return sendWithPromise("securityKeyBioEnrollDelete",id)}renameEnrollment(id,name){return sendWithPromise("securityKeyBioEnrollRename",id,name)}close(){chrome.send("securityKeyBioEnrollClose")}static getInstance(){return bioEnrollProxyInstance||(bioEnrollProxyInstance=new SecurityKeysBioEnrollProxyImpl)}static setInstance(obj){bioEnrollProxyInstance=obj}}let bioEnrollProxyInstance=null;function getTemplate$1R(){return html`<!--_html_template_start_-->    <style include="settings-shared cr-spinner-style">.spinner{padding-bottom:12px}#header{display:flex;justify-content:flex-start}site-favicon{margin-inline-end:2px;min-width:16px}.icon-placeholder{margin-inline-end:var(--cr-icon-button-margin-end);margin-inline-start:var(--cr-icon-button-margin-start);width:var(--cr-icon-ripple-size)}.site{flex:1}.user-name{flex:1}.user-display-name{flex:0.8}.user-display-name,.user-name,.site{align-items:center;display:inline-block;overflow:hidden;overflow-wrap:break-word;padding-inline-start:0.3rem;text-align:start}#siteHeader,#userDisplayNameHeader,#userNameHeader{font-weight:bold}#siteHeader{margin-inline-start:1rem}.edit{display:flex;flex-direction:column}#title{user-select:none}
    </style>

    <cr-dialog id="dialog" close-text="$i18n{cancel}" ignore-popstate
        on-close="onDialogClosed_">
      <div id="title" slot="title">[[dialogTitle_]]</div>

      <div slot="body">
        <cr-page-selector attr-for-selected="id" selected="[[dialogPage_]]"
            on-iron-select="onIronSelect_">
          <div id="initial">
            <p>$i18n{securityKeysTouchToContinue}</p>
            <div class="spinner"></div>
          </div>

          <div id="pinPrompt">
            <settings-security-keys-pin-field id="pin"
                min-pin-length="[[minPinLength_]]">
            </settings-security-keys-pin-field>
          </div>

          <div id="credentials">
            <div id="header" class="list-item column-header">
              <div class="site" id="siteHeader">
                $i18n{securityKeysCredentialWebsiteLabel}
              </div>
              <div class="user-display-name" id="userDisplayNameHeader">
                $i18n{securityKeysCredentialDisplayNameLabel}
              </div>
              <div class="user-name" id="userNameHeader">
                $i18n{securityKeysCredentialUsernameLabel}
              </div>
              <div class="icon-placeholder"></div>
              <div class="icon-placeholder"></div>
            </div>

            <div id="container">
              <iron-list id="credentialList" items="[[credentials_]]"
                  class="cr-separators list-with-header">
                <template>
                  <div class="list-item">
                    <site-favicon url="[[item.relyingPartyId]]"></site-favicon>
                    <div class="site">[[item.relyingPartyId]]</div>
                    <div class="user-display-name">
                      [[item.userDisplayName]]
                    </div>
                    <div class="user-name">[[item.userName]]</div>
                    <cr-icon-button iron-icon="cr:create"
                        aria-label="$i18n{edit}"
                        class="edit-button"
                        on-click="onUpdateButtonClick_"
                        hidden="[[!editButtonVisible_]]"
                        data-credentialid$="[[item.credentialId]]">
                    </cr-icon-button>
                    <cr-icon-button iron-icon="cr:delete"
                        aria-label="$i18n{delete}"
                        class="delete-button"
                        on-click="onDeleteButtonClick_"
                        data-credentialid$="[[item.credentialId]]">
                    </cr-icon-button>
                  </div>
                </template>
              </iron-list>
            </div>
          </div>

          <div id="edit">
            <div class="edit-item">
              <cr-input id="displayNameInput"
                  value="{{newDisplayName_}}"
                  spellcheck="false"
                  on-input="validateInput_"
                  label="$i18n{securityKeysCredentialDisplayNameLabel}"
                  error-message="[[displayNameInputError_]]"
                  invalid="[[!isEmpty_(displayNameInputError_)]]">
              </cr-input>
            </div>
            <div class="edit-item">
              <cr-input id="userNameInput"
                  value="{{newUsername_}}"
                  spellcheck="false"
                  on-input="validateInput_"
                  label="$i18n{securityKeysCredentialUsernameLabel}"
                  error-message="[[userNameInputError_]]"
                  invalid="[[!isEmpty_(userNameInputError_)]]">
              </cr-input>
            </div>
          </div>
          <div id="pinError">[[errorMsg_]]</div>
          <div id="error">[[errorMsg_]]</div>
          <div id="confirm">[[confirmMsg_]]</div>
        </cr-page-selector>
      </div>

      <div slot="button-container">
        <cr-button id="cancelButton" class="cancel-button"
            on-click="onCancelButtonClick_" hidden="[[!cancelButtonVisible_]]">
          $i18n{cancel}
        </cr-button>
        <cr-button id="confirmButton" class="action-button"
            on-click="onConfirmButtonClick_"
            disabled="[[confirmButtonDisabled_]]"
            hidden="[[!confirmButtonVisible_]]">
          [[confirmButtonLabel_]]
        </cr-button>
        <cr-button id="closeButton" class="action-button"
            on-click="close_"
            hidden="[[!closeButtonVisible_]]">
          $i18n{close}
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`}var CredentialManagementDialogPage;(function(CredentialManagementDialogPage){CredentialManagementDialogPage["INITIAL"]="initial";CredentialManagementDialogPage["PIN_PROMPT"]="pinPrompt";CredentialManagementDialogPage["PIN_ERROR"]="pinError";CredentialManagementDialogPage["CREDENTIALS"]="credentials";CredentialManagementDialogPage["EDIT"]="edit";CredentialManagementDialogPage["ERROR"]="error";CredentialManagementDialogPage["CONFIRM"]="confirm"})(CredentialManagementDialogPage||(CredentialManagementDialogPage={}));const SettingsSecurityKeysCredentialManagementDialogElementBase=WebUiListenerMixin(I18nMixin(PolymerElement));const MAX_INPUT_LENGTH=62;class SettingsSecurityKeysCredentialManagementDialogElement extends SettingsSecurityKeysCredentialManagementDialogElementBase{static get is(){return"settings-security-keys-credential-management-dialog"}static get template(){return getTemplate$1R()}static get properties(){return{dialogPage_:{type:String,value:CredentialManagementDialogPage.INITIAL,observer:"dialogPageChanged_"},dialogTitle_:String,credentials_:{type:Array,notify:true},errorMsg_:String,cancelButtonVisible_:Boolean,closeButtonVisible_:Boolean,confirmButtonDisabled_:Boolean,confirmButtonLabel_:String,confirmButtonVisible_:Boolean,confirmMsg_:String,credentialIdToDelete_:String,displayNameInputError_:String,editingCredential_:Object,editButtonVisible_:Boolean,minPinLength_:Number,newDisplayName_:String,newUsername_:String,userNameInputError_:String}}browserProxy_=SecurityKeysCredentialBrowserProxyImpl.getInstance();showSetPINButton_=false;connectedCallback(){super.connectedCallback();this.$.dialog.showModal();this.addWebUiListener("security-keys-credential-management-finished",((error,requiresPINChange=false)=>this.onPinError_(error,requiresPINChange)));this.browserProxy_.startCredentialManagement().then((response=>{this.minPinLength_=response.minPinLength;this.editButtonVisible_=response.supportsUpdateUserInformation;this.dialogPage_=CredentialManagementDialogPage.PIN_PROMPT}))}onPinError_(error,requiresPINChange=false){this.errorMsg_=error;this.showSetPINButton_=requiresPINChange;this.dialogPage_=CredentialManagementDialogPage.PIN_ERROR}onError_(error){this.errorMsg_=error;this.dialogPage_=CredentialManagementDialogPage.ERROR}submitPin_(){this.confirmButtonDisabled_=true;this.$.pin.trySubmit((pin=>this.browserProxy_.providePin(pin))).then((()=>{this.browserProxy_.enumerateCredentials().then((credentials=>this.onCredentials_(credentials)))}),(()=>{this.confirmButtonDisabled_=false}))}onCredentials_(credentials){this.credentials_=credentials;this.$.credentialList.fire("iron-resize");this.dialogPage_=CredentialManagementDialogPage.CREDENTIALS}dialogPageChanged_(){switch(this.dialogPage_){case CredentialManagementDialogPage.INITIAL:this.cancelButtonVisible_=true;this.confirmButtonVisible_=false;this.closeButtonVisible_=false;this.dialogTitle_=this.i18n("securityKeysCredentialManagementDialogTitle");break;case CredentialManagementDialogPage.PIN_PROMPT:this.cancelButtonVisible_=false;this.confirmButtonLabel_=this.i18n("continue");this.confirmButtonDisabled_=false;this.confirmButtonVisible_=true;this.closeButtonVisible_=false;this.dialogTitle_=this.i18n("securityKeysCredentialManagementDialogTitle");this.$.pin.focus();break;case CredentialManagementDialogPage.PIN_ERROR:this.cancelButtonVisible_=true;this.confirmButtonLabel_=this.i18n("securityKeysSetPinButton");this.confirmButtonVisible_=this.showSetPINButton_;this.confirmButtonDisabled_=false;this.closeButtonVisible_=false;this.dialogTitle_=this.i18n("securityKeysCredentialManagementDialogTitle");break;case CredentialManagementDialogPage.CREDENTIALS:this.cancelButtonVisible_=false;this.confirmButtonLabel_=this.i18n("done");this.confirmButtonDisabled_=false;this.confirmButtonVisible_=true;this.closeButtonVisible_=false;this.dialogTitle_=this.i18n("securityKeysCredentialManagementDialogTitle");break;case CredentialManagementDialogPage.EDIT:this.cancelButtonVisible_=true;this.confirmButtonLabel_=this.i18n("save");this.confirmButtonDisabled_=false;this.confirmButtonVisible_=true;this.closeButtonVisible_=false;this.dialogTitle_=this.i18n("securityKeysUpdateCredentialDialogTitle");break;case CredentialManagementDialogPage.ERROR:this.cancelButtonVisible_=false;this.confirmButtonLabel_=this.i18n("continue");this.confirmButtonDisabled_=false;this.confirmButtonVisible_=true;this.closeButtonVisible_=false;this.dialogTitle_=this.i18n("securityKeysCredentialManagementDialogTitle");break;case CredentialManagementDialogPage.CONFIRM:this.cancelButtonVisible_=true;this.confirmButtonLabel_=this.i18n("delete");this.confirmButtonVisible_=true;this.closeButtonVisible_=false;this.dialogTitle_=this.i18n("securityKeysCredentialManagementConfirmDeleteTitle");break;default:assertNotReached()}this.dispatchEvent(new CustomEvent("credential-management-dialog-ready-for-testing",{bubbles:true,composed:true}))}onConfirmButtonClick_(){switch(this.dialogPage_){case CredentialManagementDialogPage.PIN_PROMPT:this.submitPin_();break;case CredentialManagementDialogPage.PIN_ERROR:this.$.dialog.close();this.dispatchEvent(new CustomEvent("credential-management-set-pin",{bubbles:true,composed:true}));break;case CredentialManagementDialogPage.CREDENTIALS:this.$.dialog.close();break;case CredentialManagementDialogPage.EDIT:this.updateUserInformation_();break;case CredentialManagementDialogPage.ERROR:this.dialogPage_=CredentialManagementDialogPage.CREDENTIALS;break;case CredentialManagementDialogPage.CONFIRM:this.deleteCredential_();break;default:assertNotReached()}}onCancelButtonClick_(){switch(this.dialogPage_){case CredentialManagementDialogPage.INITIAL:case CredentialManagementDialogPage.PIN_PROMPT:case CredentialManagementDialogPage.PIN_ERROR:case CredentialManagementDialogPage.CREDENTIALS:this.$.dialog.close();break;case CredentialManagementDialogPage.EDIT:case CredentialManagementDialogPage.ERROR:case CredentialManagementDialogPage.CONFIRM:this.dialogPage_=CredentialManagementDialogPage.CREDENTIALS;break;default:assertNotReached()}}onDialogClosed_(){this.browserProxy_.close()}close_(){this.$.dialog.close()}isEmpty_(str){return!str||str.length===0}onIronSelect_(e){e.stopPropagation();setTimeout((()=>this.$.credentialList.notifyResize()),0)}onDeleteButtonClick_(e){const target=e.target;this.credentialIdToDelete_=target.dataset["credentialid"];assert(!this.isEmpty_(this.credentialIdToDelete_));this.confirmMsg_=this.i18n("securityKeysCredentialManagementConfirmDeleteCredential");this.dialogPage_=CredentialManagementDialogPage.CONFIRM}deleteCredential_(){this.browserProxy_.deleteCredentials([this.credentialIdToDelete_]).then((response=>{if(!response.success){this.onError_(response.message);return}for(let i=0;i<this.credentials_.length;i++){if(this.credentials_[i].credentialId===this.credentialIdToDelete_){this.credentials_.splice(i,1);break}}this.dialogPage_=CredentialManagementDialogPage.CREDENTIALS}))}validateInput_(){this.displayNameInputError_=this.newDisplayName_.length>MAX_INPUT_LENGTH?this.i18n("securityKeysInputTooLong"):"";this.userNameInputError_=this.newUsername_.length>MAX_INPUT_LENGTH?this.i18n("securityKeysInputTooLong"):"";this.confirmButtonDisabled_=!this.isEmpty_(this.displayNameInputError_+this.userNameInputError_)}onUpdateButtonClick_(e){const target=e.target;for(const credential of this.credentials_){if(credential.credentialId===target.dataset["credentialid"]){this.editingCredential_=credential;break}}this.newDisplayName_=this.editingCredential_.userDisplayName;this.newUsername_=this.editingCredential_.userName;this.dialogPage_=CredentialManagementDialogPage.EDIT}updateUserInformation_(){assert(this.dialogPage_===CredentialManagementDialogPage.EDIT);if(this.isEmpty_(this.newUsername_)){this.newUsername_=this.editingCredential_.userName}if(this.isEmpty_(this.newDisplayName_)){this.newDisplayName_=this.editingCredential_.userDisplayName}this.browserProxy_.updateUserInformation(this.editingCredential_.credentialId,this.editingCredential_.userHandle,this.newUsername_,this.newDisplayName_).then((response=>{if(!response.success){this.onError_(response.message);return}for(let i=0;i<this.credentials_.length;i++){if(this.credentials_[i].credentialId===this.editingCredential_.credentialId){const newCred=Object.assign({},this.credentials_[i]);newCred.userName=this.newUsername_;newCred.userDisplayName=this.newDisplayName_;this.credentials_.splice(i,1,newCred);this.$.credentialList.fire("iron-resize");break}}}));this.dialogPage_=CredentialManagementDialogPage.CREDENTIALS}}customElements.define(SettingsSecurityKeysCredentialManagementDialogElement.is,SettingsSecurityKeysCredentialManagementDialogElement);const div$2=document.createElement("div");div$2.innerHTML=getTrustedHTML`<cr-iconset name="fingerprint-icon" size="32">
  <svg>
    <defs>
      <g id="fingerprint-scanned-dark" viewBox="0 0 93 104">
        <path fill="#669df6" d="M75.346031,12.4513714 C65.426031,7.33637143 56.8487739,5.16637143 46.5674024,5.16637143 C36.3374024,5.16637143 26.6237739,7.595 17.7896596,12.4513714 C16.5487739,13.1227429 14.9987739,12.6577429 14.276031,11.4177429 C13.6046596,10.1777429 14.0696596,8.57637143 15.3096596,7.905 C24.9196596,2.68637143 35.4596596,0 46.5674024,0 C57.5732882,0 67.1824024,2.42774286 77.7232882,7.85274286 C79.0146596,8.525 79.4796596,10.075 78.8074024,11.315 C78.3424024,12.245 77.4646596,12.7613714 76.5346596,12.7613714 C76.121031,12.7613714 75.7074024,12.6577429 75.346031,12.4513714 Z">
        </path>
        <path fill="#5bb974" d="M1.10147387,39.4213714 C-0.0871547017,38.595 -0.344897559,36.9927429 0.480588155,35.805 C5.59647387,28.5713714 12.1055882,22.8877429 19.8555882,18.91 C36.0801024,10.54 56.8492167,10.4877429 73.1242167,18.8577429 C80.8742167,22.8363714 87.3851024,28.4677429 92.4992167,35.65 C93.3264739,36.7863714 93.0678453,38.44 91.8801024,39.2663714 C90.6914739,40.0927429 89.0892167,39.835 88.2628453,38.6463714 C83.6128453,32.1363714 77.7228453,27.0213714 70.7478453,23.4563714 C55.9192167,15.8613714 36.9578453,15.8613714 22.1805882,23.5077429 C15.1551024,27.125 9.26421673,32.2913714 4.61421673,38.8013714 C4.20147387,39.525 3.42647387,39.8863714 2.59921673,39.8863714 C2.0828453,39.8863714 1.56647387,39.7313714 1.10147387,39.4213714 Z">
        </path>
        <path fill="#fcc934" d="M33.0827567,101.473097 C28.5877567,96.9780971 26.1600139,94.0844686 22.6977567,87.8330971 C19.1327567,81.4780971 17.2727567,73.7280971 17.2727567,65.4094686 C17.2727567,50.0644686 30.3963853,37.5617257 46.5163853,37.5617257 C62.6354996,37.5617257 75.7600139,50.0644686 75.7600139,65.4094686 C75.7600139,66.8567257 74.6227567,67.9930971 73.1763853,67.9930971 C71.7300139,67.9930971 70.5927567,66.8567257 70.5927567,65.4094686 C70.5927567,52.9067257 59.7941282,42.7280971 46.5163853,42.7280971 C33.2377567,42.7280971 22.4391282,52.9067257 22.4391282,65.4094686 C22.4391282,72.8494686 24.0927567,79.7217257 27.2441282,85.3017257 C30.5513853,91.2430971 32.8241282,93.7744686 36.8027567,97.8044686 C37.7850139,98.8380971 37.7850139,100.439469 36.8027567,101.473097 C36.2350139,101.989469 35.5627567,102.248097 34.8913853,102.248097 C34.2191282,102.248097 33.5477567,101.989469 33.0827567,101.473097 Z">
        </path>
        <path fill="#ea4335" d="M55.9193939,88.0911057 C48.221651,82.8733629 43.6230224,74.3997343 43.6230224,65.4097343 C43.6230224,63.9633629 44.7593939,62.8261057 46.2057653,62.8261057 C47.6530224,62.8261057 48.7893939,63.9633629 48.7893939,65.4097343 C48.7893939,72.6947343 52.5093939,79.5661057 58.8130224,83.8033629 C62.4807653,86.2833629 66.7693939,87.4711057 71.9357653,87.4711057 C73.1757653,87.4711057 75.2421367,87.3161057 77.3093939,86.9547343 C78.7052796,86.6961057 80.0480224,87.6261057 80.3057653,89.0733629 C80.5643939,90.4683629 79.6343939,91.8111057 78.1880224,92.0697343 C75.2421367,92.6383629 72.6593939,92.6897343 71.9357653,92.6897343 C65.7880224,92.6897343 60.3630224,91.1397343 55.9193939,88.0911057 Z">
        </path>
        <path fill="#669df6" d="M60.8797482,103.229557 C52.6647482,100.955929 47.2911196,97.9081857 41.6597482,92.3795571 C34.4261196,85.1981857 30.4483767,75.6395571 30.4483767,65.4095571 C30.4483767,57.0395571 37.5783767,50.2195571 46.3611196,50.2195571 C55.1447482,50.2195571 62.2738624,57.0395571 62.2738624,65.4095571 C62.2738624,70.9381857 67.0797482,75.4331857 73.0211196,75.4331857 C78.962491,75.4331857 83.767491,70.9381857 83.767491,65.4095571 C83.767491,45.9309286 66.9761196,30.1218143 46.3097482,30.1218143 C31.6361196,30.1218143 18.2033767,38.2845571 12.157491,50.9431857 C10.142491,55.1281857 9.10974816,60.0359286 9.10974816,65.4095571 C9.10974816,69.4395571 9.47111958,75.7945571 12.5711196,84.0609286 C13.087491,85.4045571 12.4161196,86.9031857 11.0733767,87.3681857 C9.72974816,87.8845571 8.23111958,87.1609286 7.76611958,85.8695571 C5.23474816,79.1018143 3.99474816,72.3845571 3.99474816,65.4095571 C3.99474816,59.2095571 5.18249101,53.5781857 7.50749101,48.6695571 C14.3797482,34.2545571 29.6211196,24.9031857 46.3097482,24.9031857 C69.817491,24.9031857 88.9347482,43.0381857 88.9347482,65.3581857 C88.9347482,73.7281857 81.8047482,80.5481857 73.0211196,80.5481857 C64.237491,80.5481857 57.107491,73.7281857 57.107491,65.3581857 C57.107491,59.8295571 52.3033767,55.3345571 46.3611196,55.3345571 C40.4197482,55.3345571 35.6147482,59.8295571 35.6147482,65.3581857 C35.6147482,74.1931857 39.0238624,82.4595571 45.2761196,88.6595571 C50.1847482,93.5168143 54.8861196,96.2031857 62.1711196,98.2181857 C63.5661196,98.5795571 64.3411196,100.026814 63.9797482,101.369557 C63.7211196,102.558186 62.6361196,103.333186 61.5511196,103.333186 C61.3447482,103.333186 61.0861196,103.280929 60.8797482,103.229557 Z">
        </path>
      </g>
      <g id="fingerprint-scanned-light" viewBox="0 0 93 104">
        <path fill="#4285f4" d="M75.346031,12.4513714 C65.426031,7.33637143 56.8487739,5.16637143 46.5674024,5.16637143 C36.3374024,5.16637143 26.6237739,7.595 17.7896596,12.4513714 C16.5487739,13.1227429 14.9987739,12.6577429 14.276031,11.4177429 C13.6046596,10.1777429 14.0696596,8.57637143 15.3096596,7.905 C24.9196596,2.68637143 35.4596596,0 46.5674024,0 C57.5732882,0 67.1824024,2.42774286 77.7232882,7.85274286 C79.0146596,8.525 79.4796596,10.075 78.8074024,11.315 C78.3424024,12.245 77.4646596,12.7613714 76.5346596,12.7613714 C76.121031,12.7613714 75.7074024,12.6577429 75.346031,12.4513714 Z">
        </path>
        <path fill="#34a853" d="M1.10147387,39.4213714 C-0.0871547017,38.595 -0.344897559,36.9927429 0.480588155,35.805 C5.59647387,28.5713714 12.1055882,22.8877429 19.8555882,18.91 C36.0801024,10.54 56.8492167,10.4877429 73.1242167,18.8577429 C80.8742167,22.8363714 87.3851024,28.4677429 92.4992167,35.65 C93.3264739,36.7863714 93.0678453,38.44 91.8801024,39.2663714 C90.6914739,40.0927429 89.0892167,39.835 88.2628453,38.6463714 C83.6128453,32.1363714 77.7228453,27.0213714 70.7478453,23.4563714 C55.9192167,15.8613714 36.9578453,15.8613714 22.1805882,23.5077429 C15.1551024,27.125 9.26421673,32.2913714 4.61421673,38.8013714 C4.20147387,39.525 3.42647387,39.8863714 2.59921673,39.8863714 C2.0828453,39.8863714 1.56647387,39.7313714 1.10147387,39.4213714 Z">
        </path>
        <path fill="#fbbc04" d="M33.0827567,101.473097 C28.5877567,96.9780971 26.1600139,94.0844686 22.6977567,87.8330971 C19.1327567,81.4780971 17.2727567,73.7280971 17.2727567,65.4094686 C17.2727567,50.0644686 30.3963853,37.5617257 46.5163853,37.5617257 C62.6354996,37.5617257 75.7600139,50.0644686 75.7600139,65.4094686 C75.7600139,66.8567257 74.6227567,67.9930971 73.1763853,67.9930971 C71.7300139,67.9930971 70.5927567,66.8567257 70.5927567,65.4094686 C70.5927567,52.9067257 59.7941282,42.7280971 46.5163853,42.7280971 C33.2377567,42.7280971 22.4391282,52.9067257 22.4391282,65.4094686 C22.4391282,72.8494686 24.0927567,79.7217257 27.2441282,85.3017257 C30.5513853,91.2430971 32.8241282,93.7744686 36.8027567,97.8044686 C37.7850139,98.8380971 37.7850139,100.439469 36.8027567,101.473097 C36.2350139,101.989469 35.5627567,102.248097 34.8913853,102.248097 C34.2191282,102.248097 33.5477567,101.989469 33.0827567,101.473097 Z">
        </path>
        <path fill="#ea4335" d="M55.9193939,88.0911057 C48.221651,82.8733629 43.6230224,74.3997343 43.6230224,65.4097343 C43.6230224,63.9633629 44.7593939,62.8261057 46.2057653,62.8261057 C47.6530224,62.8261057 48.7893939,63.9633629 48.7893939,65.4097343 C48.7893939,72.6947343 52.5093939,79.5661057 58.8130224,83.8033629 C62.4807653,86.2833629 66.7693939,87.4711057 71.9357653,87.4711057 C73.1757653,87.4711057 75.2421367,87.3161057 77.3093939,86.9547343 C78.7052796,86.6961057 80.0480224,87.6261057 80.3057653,89.0733629 C80.5643939,90.4683629 79.6343939,91.8111057 78.1880224,92.0697343 C75.2421367,92.6383629 72.6593939,92.6897343 71.9357653,92.6897343 C65.7880224,92.6897343 60.3630224,91.1397343 55.9193939,88.0911057 Z">
        </path>
        <path fill="#4285f4" d="M60.8797482,103.229557 C52.6647482,100.955929 47.2911196,97.9081857 41.6597482,92.3795571 C34.4261196,85.1981857 30.4483767,75.6395571 30.4483767,65.4095571 C30.4483767,57.0395571 37.5783767,50.2195571 46.3611196,50.2195571 C55.1447482,50.2195571 62.2738624,57.0395571 62.2738624,65.4095571 C62.2738624,70.9381857 67.0797482,75.4331857 73.0211196,75.4331857 C78.962491,75.4331857 83.767491,70.9381857 83.767491,65.4095571 C83.767491,45.9309286 66.9761196,30.1218143 46.3097482,30.1218143 C31.6361196,30.1218143 18.2033767,38.2845571 12.157491,50.9431857 C10.142491,55.1281857 9.10974816,60.0359286 9.10974816,65.4095571 C9.10974816,69.4395571 9.47111958,75.7945571 12.5711196,84.0609286 C13.087491,85.4045571 12.4161196,86.9031857 11.0733767,87.3681857 C9.72974816,87.8845571 8.23111958,87.1609286 7.76611958,85.8695571 C5.23474816,79.1018143 3.99474816,72.3845571 3.99474816,65.4095571 C3.99474816,59.2095571 5.18249101,53.5781857 7.50749101,48.6695571 C14.3797482,34.2545571 29.6211196,24.9031857 46.3097482,24.9031857 C69.817491,24.9031857 88.9347482,43.0381857 88.9347482,65.3581857 C88.9347482,73.7281857 81.8047482,80.5481857 73.0211196,80.5481857 C64.237491,80.5481857 57.107491,73.7281857 57.107491,65.3581857 C57.107491,59.8295571 52.3033767,55.3345571 46.3611196,55.3345571 C40.4197482,55.3345571 35.6147482,59.8295571 35.6147482,65.3581857 C35.6147482,74.1931857 39.0238624,82.4595571 45.2761196,88.6595571 C50.1847482,93.5168143 54.8861196,96.2031857 62.1711196,98.2181857 C63.5661196,98.5795571 64.3411196,100.026814 63.9797482,101.369557 C63.7211196,102.558186 62.6361196,103.333186 61.5511196,103.333186 C61.3447482,103.333186 61.0861196,103.280929 60.8797482,103.229557 Z">
        </path>
      </g>
    </defs>
  </svg>
</cr-iconset>
`;const iconsets$2=div$2.querySelectorAll("cr-iconset");for(const iconset of iconsets$2){document.head.appendChild(iconset)}let instance$l=null;function getCss$8(){return instance$l||(instance$l=[...[],css`canvas{height:100%;width:100%}`])}function getHtml$8(){return html$1`<canvas id="canvas" ?hidden="${this.hidden}"></canvas>`}let workerLoaderPolicy=null;function getLottieWorkerURL(){if(workerLoaderPolicy===null){workerLoaderPolicy=window.trustedTypes.createPolicy("lottie-worker-script-loader",{createScriptURL:_ignore=>{const script=`import 'chrome://resources/lottie/lottie_worker.min.js';`;const blob=new Blob([script],{type:"text/javascript"});return URL.createObjectURL(blob)},createHTML:()=>assertNotReached(),createScript:()=>assertNotReached()})}return workerLoaderPolicy.createScriptURL("")}class CrLottieElement extends CrLitElement{static get is(){return"cr-lottie"}static get styles(){return getCss$8()}render(){return getHtml$8.bind(this)()}static get properties(){return{animationUrl:{type:String},autoplay:{type:Boolean},hidden:{type:Boolean},singleLoop:{type:Boolean}}}#animationUrl_accessor_storage="";get animationUrl(){return this.#animationUrl_accessor_storage}set animationUrl(value){this.#animationUrl_accessor_storage=value}#autoplay_accessor_storage=false;get autoplay(){return this.#autoplay_accessor_storage}set autoplay(value){this.#autoplay_accessor_storage=value}#hidden_accessor_storage=false;get hidden(){return this.#hidden_accessor_storage}set hidden(value){this.#hidden_accessor_storage=value}#singleLoop_accessor_storage=false;get singleLoop(){return this.#singleLoop_accessor_storage}set singleLoop(value){this.#singleLoop_accessor_storage=value}canvasElement_=null;isAnimationLoaded_=false;offscreenCanvas_=null;hasTransferredCanvas_=false;resizeObserver_=null;playState_=false;workerNeedsSizeUpdate_=false;workerNeedsPlayControlUpdate_=false;worker_=null;xhr_=null;connectedCallback(){super.connectedCallback();this.worker_=new Worker(getLottieWorkerURL(),{type:"module"});this.worker_.onmessage=this.onMessage_.bind(this);this.initialize_()}disconnectedCallback(){super.disconnectedCallback();if(this.resizeObserver_){this.resizeObserver_.disconnect()}if(this.worker_){this.worker_.terminate();this.worker_=null}if(this.xhr_){this.xhr_.abort();this.xhr_=null}}updated(changedProperties){super.updated(changedProperties);if(!changedProperties.has("animationUrl")){return}if(!this.worker_){return}if(this.xhr_){this.xhr_.abort();this.xhr_=null}if(this.isAnimationLoaded_){this.worker_.postMessage({control:{stop:true}});this.isAnimationLoaded_=false}this.sendXmlHttpRequest_(this.animationUrl,"json",this.initAnimation_.bind(this))}setPlay(shouldPlay){this.playState_=shouldPlay;if(this.isAnimationLoaded_){this.sendPlayControlInformationToWorker_()}else{this.workerNeedsPlayControlUpdate_=true}}sendPlayControlInformationToWorker_(){assert(this.worker_);this.worker_.postMessage({control:{play:this.playState_}})}initialize_(){this.canvasElement_=this.$.canvas;this.offscreenCanvas_=this.canvasElement_.transferControlToOffscreen();this.resizeObserver_=new ResizeObserver(this.onCanvasElementResized_.bind(this));this.resizeObserver_.observe(this.canvasElement_);if(this.isAnimationLoaded_){return}this.sendXmlHttpRequest_(this.animationUrl,"json",this.initAnimation_.bind(this))}getCanvasDrawBufferSize_(){const canvasElement=this.$.canvas;const devicePixelRatio=window.devicePixelRatio;const clientRect=canvasElement.getBoundingClientRect();const drawSize={width:clientRect.width*devicePixelRatio,height:clientRect.height*devicePixelRatio};return drawSize}isValidUrl_(maybeValidUrl){const url=new URL(maybeValidUrl,document.location.href);return url.protocol==="chrome:"||url.protocol==="data:"&&url.pathname.startsWith("application/json;")}sendXmlHttpRequest_(url,responseType,successCallback){assert(this.isValidUrl_(url),"Invalid scheme or data url used.");assert(!this.xhr_);this.xhr_=new XMLHttpRequest;this.xhr_.open("GET",url,true);this.xhr_.responseType=responseType;this.xhr_.send();this.xhr_.onreadystatechange=()=>{assert(this.xhr_);if(this.xhr_.readyState===4&&this.xhr_.status===200){const response=this.xhr_.response;this.xhr_=null;successCallback(response)}}}onCanvasElementResized_(){if(this.isAnimationLoaded_){this.sendCanvasSizeToWorker_()}else{this.workerNeedsSizeUpdate_=true}}sendCanvasSizeToWorker_(){assert(this.worker_);this.worker_.postMessage({drawSize:this.getCanvasDrawBufferSize_()})}initAnimation_(animationData){const message={animationData:animationData,drawSize:this.getCanvasDrawBufferSize_(),params:{loop:!this.singleLoop,autoplay:this.autoplay}};assert(this.worker_);if(!this.hasTransferredCanvas_){message.canvas=this.offscreenCanvas_;this.hasTransferredCanvas_=true;this.worker_.postMessage(message,[this.offscreenCanvas_])}else{this.worker_.postMessage(message)}}onMessage_(event){if(event.data.name==="initialized"&&event.data.success){this.isAnimationLoaded_=true;this.sendPendingInfo_();this.fire("cr-lottie-initialized")}else if(event.data.name==="playing"){this.fire("cr-lottie-playing")}else if(event.data.name==="paused"){this.fire("cr-lottie-paused")}else if(event.data.name==="stopped"){this.fire("cr-lottie-stopped")}else if(event.data.name==="resized"){this.fire("cr-lottie-resized",event.data.size)}}sendPendingInfo_(){if(this.workerNeedsSizeUpdate_){this.workerNeedsSizeUpdate_=false;this.sendCanvasSizeToWorker_()}if(this.workerNeedsPlayControlUpdate_){this.workerNeedsPlayControlUpdate_=false;this.sendPlayControlInformationToWorker_()}}}customElements.define(CrLottieElement.is,CrLottieElement);function getTemplate$1Q(){return html`<!--_html_template_start_-->    <style>:host{user-select:none}.translucent{opacity:0.3}#canvasDiv{height:240px;overflow:hidden;position:relative;width:460px}cr-lottie{display:inline-block;position:absolute}#fingerprintScanned{position:absolute}
    </style>

    <div id="canvasDiv">
      <canvas id="canvas" height="240" width="460"></canvas>
      <cr-lottie id="scanningAnimation" aria-hidden="true"
          autoplay="[[autoplay]]">
      </cr-lottie>
      <cr-icon id="fingerprintScanned" hidden></cr-icon>
    </div>
<!--_html_template_end_-->`}const FINGERPRINT_SCANNED_ICON_DARK="fingerprint-icon:fingerprint-scanned-dark";const FINGERPRINT_SCANNED_ICON_LIGHT="fingerprint-icon:fingerprint-scanned-light";const FINGERPRINT_CHECK_DARK_URL="chrome://theme/IDR_FINGERPRINT_COMPLETE_CHECK_DARK";const FINGERPRINT_CHECK_LIGHT_URL="chrome://theme/IDR_FINGERPRINT_COMPLETE_CHECK_LIGHT";const PROGRESS_CIRCLE_BACKGROUND_COLOR_DARK="rgba(95, 99, 104, 1.0)";const PROGRESS_CIRCLE_BACKGROUND_COLOR_LIGHT="rgba(232, 234, 237, 1.0)";const PROGRESS_CIRCLE_FILL_COLOR_DARK="rgba(102, 157, 246, 1.0)";const PROGRESS_CIRCLE_FILL_COLOR_LIGHT="rgba(66, 133, 244, 1.0)";const ANIMATE_TICKS_MS=20;const ANIMATE_DURATION_MS=200;const DEFAULT_PROGRESS_CIRCLE_RADIUS=114;const ICON_HEIGHT=118;const ICON_WIDTH=106;const CHECK_MARK_SIZE=53;const FINGERPRINT_SCAN_SUCCESS_MS=500;const PROGRESS_CIRCLE_STROKE_WIDTH=4;class FingerprintProgressArcElement extends PolymerElement{static get is(){return"fingerprint-progress-arc"}static get template(){return getTemplate$1Q()}static get properties(){return{circleRadius:{type:Number,value:DEFAULT_PROGRESS_CIRCLE_RADIUS},autoplay:{type:Boolean,value:false},scale_:{type:Number,value:1},isComplete_:Boolean}}isDarkModeActive_=false;eventTracker_=new EventTracker;progressAnimationIntervalId_=undefined;progressPercentDrawn_=0;updateTimerId_=undefined;onDarkModeChanged_(e){this.isDarkModeActive_=e.matches;this.clearCanvas_();this.drawProgressCircle_(this.progressPercentDrawn_);this.updateAnimationAsset_();this.updateIconAsset_()}connectedCallback(){super.connectedCallback();const darkModeQuery=window.matchMedia("(prefers-color-scheme: dark)");this.isDarkModeActive_=darkModeQuery.matches;this.eventTracker_.add(darkModeQuery,"change",(e=>this.onDarkModeChanged_(e)));this.scale_=this.circleRadius/DEFAULT_PROGRESS_CIRCLE_RADIUS;this.updateIconAsset_();this.updateImages_()}disconnectedCallback(){super.disconnectedCallback();this.eventTracker_.removeAll()}reset(){this.cancelAnimations_();this.clearCanvas_();this.isComplete_=false;this.drawProgressCircle_(0);this.$.fingerprintScanned.hidden=true;const scanningAnimation=this.$.scanningAnimation;scanningAnimation.singleLoop=false;scanningAnimation.classList.add("translucent");this.updateAnimationAsset_();this.resizeAndCenterIcon_(scanningAnimation);scanningAnimation.hidden=false}setProgress(prevPercentComplete,currPercentComplete,isComplete){if(this.isComplete_){return}this.isComplete_=isComplete;this.cancelAnimations_();let nextPercentToDraw=prevPercentComplete;const endPercent=isComplete?100:Math.min(100,currPercentComplete);const step=(endPercent-prevPercentComplete)/(ANIMATE_DURATION_MS/ANIMATE_TICKS_MS);const doAnimate=()=>{if(nextPercentToDraw>=endPercent){if(this.progressAnimationIntervalId_){clearInterval(this.progressAnimationIntervalId_);this.progressAnimationIntervalId_=undefined}nextPercentToDraw=endPercent}this.clearCanvas_();this.drawProgressCircle_(nextPercentToDraw);if(!this.progressAnimationIntervalId_){this.dispatchEvent(new CustomEvent("fingerprint-progress-arc-drawn",{bubbles:true,composed:true}))}nextPercentToDraw+=step};this.progressAnimationIntervalId_=setInterval(doAnimate,ANIMATE_TICKS_MS);if(isComplete){this.animateScanComplete_()}else{this.animateScanProgress_()}}setPlay(shouldPlay){this.$.scanningAnimation.setPlay(shouldPlay)}isComplete(){return this.isComplete_}drawArc_(startAngle,endAngle,color){const c=this.$.canvas;const ctx=c.getContext("2d");assert(!!ctx);ctx.beginPath();ctx.arc(c.width/2,c.height/2,this.circleRadius,startAngle,endAngle);ctx.lineWidth=PROGRESS_CIRCLE_STROKE_WIDTH;ctx.strokeStyle=color;ctx.stroke()}drawProgressCircle_(currentPercent){const start=3*Math.PI/2;const currentAngle=2*Math.PI*currentPercent/100;this.drawArc_(start,start+currentAngle,this.isDarkModeActive_?PROGRESS_CIRCLE_FILL_COLOR_DARK:PROGRESS_CIRCLE_FILL_COLOR_LIGHT);this.drawArc_(start+currentAngle,currentAngle<=0?7*Math.PI/2:start,this.isDarkModeActive_?PROGRESS_CIRCLE_BACKGROUND_COLOR_DARK:PROGRESS_CIRCLE_BACKGROUND_COLOR_LIGHT);this.progressPercentDrawn_=currentPercent}updateAnimationAsset_(){const scanningAnimation=this.$.scanningAnimation;if(this.isComplete_){scanningAnimation.animationUrl=this.isDarkModeActive_?FINGERPRINT_CHECK_DARK_URL:FINGERPRINT_CHECK_LIGHT_URL;return}scanningAnimation.animationUrl=this.isDarkModeActive_?"chrome://theme/IDR_FINGERPRINT_ICON_ANIMATION_DARK":"chrome://theme/IDR_FINGERPRINT_ICON_ANIMATION_LIGHT"}updateIconAsset_(){this.$.fingerprintScanned.icon=this.isDarkModeActive_?FINGERPRINT_SCANNED_ICON_DARK:FINGERPRINT_SCANNED_ICON_LIGHT}cancelAnimations_(){this.progressPercentDrawn_=0;if(this.progressAnimationIntervalId_){clearInterval(this.progressAnimationIntervalId_);this.progressAnimationIntervalId_=undefined}if(this.updateTimerId_){window.clearTimeout(this.updateTimerId_);this.updateTimerId_=undefined}}animateScanComplete_(){const scanningAnimation=this.$.scanningAnimation;scanningAnimation.singleLoop=true;scanningAnimation.autoplay=true;scanningAnimation.classList.remove("translucent");this.updateAnimationAsset_();this.resizeCheckMark_(scanningAnimation);this.$.fingerprintScanned.hidden=false}animateScanProgress_(){this.$.fingerprintScanned.hidden=false;this.$.scanningAnimation.hidden=true;this.updateTimerId_=window.setTimeout((()=>{this.$.scanningAnimation.hidden=false;this.$.fingerprintScanned.hidden=true}),FINGERPRINT_SCAN_SUCCESS_MS)}clearCanvas_(){const c=this.$.canvas;const ctx=c.getContext("2d");assert(!!ctx);ctx.clearRect(0,0,c.width,c.height)}updateImages_(){this.resizeAndCenterIcon_(this.$.scanningAnimation);this.resizeAndCenterIcon_(this.$.fingerprintScanned)}resizeAndCenterIcon_(target){target.style.width=ICON_WIDTH*this.scale_+"px";target.style.height=ICON_HEIGHT*this.scale_+"px";const left=this.$.canvas.width/2-ICON_WIDTH*this.scale_/2;const top=this.$.canvas.height/2-ICON_HEIGHT*this.scale_/2;target.style.left=left+"px";target.style.top=top+"px"}resizeCheckMark_(target){target.style.width=CHECK_MARK_SIZE*this.scale_+"px";target.style.height=CHECK_MARK_SIZE*this.scale_+"px";const top=this.$.canvas.height/2+this.circleRadius-CHECK_MARK_SIZE*this.scale_;const left=this.$.canvas.width/2+this.circleRadius-CHECK_MARK_SIZE*this.scale_;target.style.left=left+"px";target.style.top=top+"px"}}customElements.define(FingerprintProgressArcElement.is,FingerprintProgressArcElement);function getTemplate$1P(){return html`<!--_html_template_start_-->    <style include="settings-shared cr-spinner-style">div[slot='body']{padding-inline-end:16px}#header{display:flex}#header .header-label{flex:auto}h3{font-size:inherit;font-weight:500;margin:0;padding-bottom:12px;padding-top:32px}cr-icon{padding-inline-end:12px}.list-item .name{word-break:break-word}.name{flex:3}#container{padding-inline-start:var(--cr-section-padding)}.spinner{padding-bottom:16px}@media (prefers-color-scheme:dark){#lightIcon{display:none}}@media (prefers-color-scheme:light){#darkIcon{display:none}}
    </style>

    <cr-dialog id="dialog" close-text="$i18n{cancel}" ignore-popstate
        on-close="onDialogClosed_">
      <div slot="title">[[dialogTitle_(dialogPage_)]]</div>

      <div slot="body">
        <cr-page-selector attr-for-selected="id" selected="[[dialogPage_]]"
            on-iron-select="onIronSelect_">
          <div id="initial">
            <p>$i18n{securityKeysTouchToContinue}</p>
            <div class="spinner"></div>
          </div>

          <div id="pinPrompt">
            <settings-security-keys-pin-field id="pin"
                min-pin-length="[[minPinLength_]]">
            </settings-security-keys-pin-field>
          </div>

          <div id="enrollments">
            <div id="header" class="list-item column-header">
              <h3 class="header-label">[[enrollmentsHeader_(enrollments_)]]</h3>
              <cr-button id="addButton" on-click="addButtonClick_"
                  class="secondary-button header-aligned-button">
                $i18n{add}
              </cr-button>
            </div>

            <div id="container">
              <iron-list id="enrollmentList" items="[[enrollments_]]"
                  class="cr-separators" role="list">
                <template>
                  <div class="list-item" first$="[[!index]]" role="listitem">
                    <cr-icon id="darkIcon"
                        icon="fingerprint-icon:fingerprint-scanned-dark">
                    </cr-icon>
                    <cr-icon id="lightIcon"
                        icon="fingerprint-icon:fingerprint-scanned-light">
                    </cr-icon>
                    <div class="name">
                      [[item.name]]
                    </div>
                    <cr-icon-button class="icon-clear"
                        aria-label="$i18n{securityKeysBioEnrollmentDelete}"
                        on-click="deleteEnrollment_"
                        disabled="[[deleteInProgress_]]">
                    </cr-icon-button>
                  </div>
                </template>
              </iron-list>
            </div>
          </div>

          <div id="enroll">
            <p>[[progressArcLabel_]]</p>
            <fingerprint-progress-arc id="arc" autoplay>
            </fingerprint-progress-arc>
          </div>

          <div id="chooseName">
            <p>$i18n{securityKeysBioEnrollmentChooseName}</p>
            <cr-input type="text" id="enrollmentName"
                max-length="[[enrollmentNameMaxUtf8Length_]]"
                value="{{recentEnrollmentName_}}"
                label="$i18n{securityKeysBioEnrollmentNameLabel}"
                on-input="onEnrollmentNameInput_"
                error-message="[[enrollmentNameError_]]"
                invalid="[[!isNullOrEmpty_(enrollmentNameError_)]]"
                spellcheck="false">
            </cr-input>
          </div>

          <div id="error">[[errorMsg_]]</div>
        </cr-page-selector>
      </div>

      <div slot="button-container">
        <cr-button id="cancelButton" class="cancel-button" on-click="cancel_"
            hidden="[[!cancelButtonVisible_]]"
            disabled="[[cancelButtonDisabled_]]">
          $i18n{cancel}
        </cr-button>
        <cr-button id="confirmButton" class="action-button"
            hidden="[[!confirmButtonVisible_]]"
            disabled="[[confirmButtonDisabled_]]"
            on-click="confirmButtonClick_">
          [[confirmButtonLabel_]]
        </cr-button>
        <cr-button id="doneButton" class="action-button"
            on-click="done_" hidden="[[!doneButtonVisible_]]">
          $i18n{done}
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`}var BioEnrollDialogPage;(function(BioEnrollDialogPage){BioEnrollDialogPage["INITIAL"]="initial";BioEnrollDialogPage["PIN_PROMPT"]="pinPrompt";BioEnrollDialogPage["ENROLLMENTS"]="enrollments";BioEnrollDialogPage["ENROLL"]="enroll";BioEnrollDialogPage["CHOOSE_NAME"]="chooseName";BioEnrollDialogPage["ERROR"]="error"})(BioEnrollDialogPage||(BioEnrollDialogPage={}));const SettingsSecurityKeysBioEnrollDialogElementBase=WebUiListenerMixin(I18nMixin(PolymerElement));class SettingsSecurityKeysBioEnrollDialogElement extends SettingsSecurityKeysBioEnrollDialogElementBase{static get is(){return"settings-security-keys-bio-enroll-dialog"}static get template(){return getTemplate$1P()}static get properties(){return{cancelButtonDisabled_:Boolean,cancelButtonVisible_:Boolean,confirmButtonDisabled_:Boolean,confirmButtonVisible_:Boolean,confirmButtonLabel_:String,deleteInProgress_:Boolean,dialogPage_:{type:String,value:BioEnrollDialogPage.INITIAL,observer:"dialogPageChanged_"},doneButtonVisible_:Boolean,enrollments_:Array,minPinLength_:Number,progressArcLabel_:String,recentEnrollmentName_:String,enrollmentNameError_:String,enrollmentNameMaxUtf8Length_:Number,errorMsg_:String}}browserProxy_=SecurityKeysBioEnrollProxyImpl.getInstance();maxSamples_=-1;recentEnrollmentId_="";showSetPINButton_=false;connectedCallback(){super.connectedCallback();this.$.dialog.showModal();this.addWebUiListener("security-keys-bio-enroll-error",((error,requiresPINChange=false)=>this.onError_(error,requiresPINChange)));this.addWebUiListener("security-keys-bio-enroll-status",(response=>this.onEnrollmentSample_(response)));this.browserProxy_.startBioEnroll().then((([minPinLength])=>{this.minPinLength_=minPinLength;this.dialogPage_=BioEnrollDialogPage.PIN_PROMPT}))}setDialogPageForTesting(page){this.dialogPage_=page}fire_(eventName,detail){this.dispatchEvent(new CustomEvent(eventName,{bubbles:true,composed:true,detail:detail}))}onError_(error,requiresPINChange=false){this.errorMsg_=error;this.showSetPINButton_=requiresPINChange;this.dialogPage_=BioEnrollDialogPage.ERROR}submitPin_(){this.confirmButtonDisabled_=true;this.$.pin.trySubmit((pin=>this.browserProxy_.providePin(pin))).then((()=>{this.browserProxy_.getSensorInfo().then((sensorInfo=>{this.enrollmentNameMaxUtf8Length_=sensorInfo.maxTemplateFriendlyName;this.showEnrollmentsPage_()}))}),(()=>{this.confirmButtonDisabled_=false}))}onEnrollments_(enrollments){this.enrollments_=enrollments.slice().sort(((a,b)=>a.name.localeCompare(b.name)));this.$.enrollmentList.fire("iron-resize");this.dialogPage_=BioEnrollDialogPage.ENROLLMENTS}setCancelButtonDisabledForTesting(disabled){this.cancelButtonDisabled_=disabled}dialogPageChanged_(){switch(this.dialogPage_){case BioEnrollDialogPage.INITIAL:this.cancelButtonVisible_=true;this.cancelButtonDisabled_=false;this.confirmButtonVisible_=false;this.doneButtonVisible_=false;break;case BioEnrollDialogPage.PIN_PROMPT:this.cancelButtonVisible_=true;this.cancelButtonDisabled_=false;this.confirmButtonVisible_=true;this.confirmButtonLabel_=this.i18n("continue");this.confirmButtonDisabled_=false;this.doneButtonVisible_=false;this.$.pin.focus();break;case BioEnrollDialogPage.ENROLLMENTS:this.cancelButtonVisible_=false;this.confirmButtonVisible_=false;this.doneButtonVisible_=true;break;case BioEnrollDialogPage.ENROLL:this.cancelButtonVisible_=true;this.cancelButtonDisabled_=false;this.confirmButtonVisible_=false;this.doneButtonVisible_=false;break;case BioEnrollDialogPage.CHOOSE_NAME:this.cancelButtonVisible_=false;this.confirmButtonVisible_=true;this.confirmButtonLabel_=this.i18n("continue");this.confirmButtonDisabled_=!this.recentEnrollmentName_.length;this.doneButtonVisible_=false;this.$.enrollmentName.focus();break;case BioEnrollDialogPage.ERROR:this.cancelButtonVisible_=true;this.confirmButtonVisible_=this.showSetPINButton_;this.confirmButtonLabel_=this.i18n("securityKeysSetPinButton");this.doneButtonVisible_=false;break;default:assertNotReached()}this.fire_("bio-enroll-dialog-ready-for-testing")}addButtonClick_(){assert(this.dialogPage_===BioEnrollDialogPage.ENROLLMENTS);this.maxSamples_=-1;this.$.arc.reset();this.progressArcLabel_=this.i18n("securityKeysBioEnrollmentEnrollingLabel");this.recentEnrollmentId_="";this.recentEnrollmentName_="";this.dialogPage_=BioEnrollDialogPage.ENROLL;this.browserProxy_.startEnrolling().then((response=>{this.onEnrollmentComplete_(response)}))}onEnrollmentSample_(response){if(response.status!==SampleStatus.OK){this.progressArcLabel_=this.i18n("securityKeysBioEnrollmentTryAgainLabel");getInstance().announce(this.progressArcLabel_);return}this.progressArcLabel_=this.i18n("securityKeysBioEnrollmentEnrollingLabel");assert(response.remaining>=0);if(this.maxSamples_===-1){this.maxSamples_=response.remaining+1}this.$.arc.setProgress(100*(this.maxSamples_-response.remaining-1)/this.maxSamples_,100*(this.maxSamples_-response.remaining)/this.maxSamples_,false)}onEnrollmentComplete_(response){switch(response.code){case Ctap2Status.OK:break;case Ctap2Status.ERR_KEEPALIVE_CANCEL:this.showEnrollmentsPage_();return;case Ctap2Status.ERR_FP_DATABASE_FULL:this.onError_(this.i18n("securityKeysBioEnrollmentStorageFullLabel"));return;default:this.onError_(this.i18n("securityKeysBioEnrollmentEnrollingFailedLabel"));return}this.maxSamples_=Math.max(this.maxSamples_,1);this.$.arc.setProgress(100*(this.maxSamples_-1)/this.maxSamples_,100,true);assert(response.enrollment);this.recentEnrollmentId_=response.enrollment.id;this.recentEnrollmentName_=response.enrollment.name;this.cancelButtonVisible_=false;this.confirmButtonVisible_=true;this.confirmButtonDisabled_=false;this.progressArcLabel_=this.i18n("securityKeysBioEnrollmentEnrollingCompleteLabel");this.$.confirmButton.focus();this.fire_("iron-announce",{text:this.progressArcLabel_});this.fire_("bio-enroll-dialog-ready-for-testing")}confirmButtonClick_(){switch(this.dialogPage_){case BioEnrollDialogPage.PIN_PROMPT:this.submitPin_();break;case BioEnrollDialogPage.ENROLL:assert(!!this.recentEnrollmentId_.length);this.dialogPage_=BioEnrollDialogPage.CHOOSE_NAME;break;case BioEnrollDialogPage.CHOOSE_NAME:this.renameNewEnrollment_();break;case BioEnrollDialogPage.ERROR:this.$.dialog.close();this.fire_("bio-enroll-set-pin");break;default:assertNotReached()}}renameNewEnrollment_(){assert(this.dialogPage_===BioEnrollDialogPage.CHOOSE_NAME);if((new TextEncoder).encode(this.recentEnrollmentName_).length>this.enrollmentNameMaxUtf8Length_){this.enrollmentNameError_=this.i18n("securityKeysBioEnrollmentNameLabelTooLong");return}this.enrollmentNameError_=null;this.confirmButtonDisabled_=true;this.browserProxy_.renameEnrollment(this.recentEnrollmentId_,this.recentEnrollmentName_).then((enrollments=>{this.onEnrollments_(enrollments)}))}showEnrollmentsPage_(){this.browserProxy_.enumerateEnrollments().then((enrollments=>{this.onEnrollments_(enrollments)}))}cancel_(){if(this.dialogPage_===BioEnrollDialogPage.ENROLL){this.cancelButtonDisabled_=true;this.browserProxy_.cancelEnrollment()}else{this.done_()}}done_(){this.$.dialog.close()}onDialogClosed_(){this.browserProxy_.close()}onIronSelect_(e){e.stopPropagation();setTimeout((()=>this.$.enrollmentList.notifyResize()),0)}deleteEnrollment_(event){if(this.deleteInProgress_){return}this.deleteInProgress_=true;const enrollment=this.enrollments_[event.model.index];this.browserProxy_.deleteEnrollment(enrollment.id).then((enrollments=>{this.deleteInProgress_=false;this.onEnrollments_(enrollments)}))}onEnrollmentNameInput_(){this.confirmButtonDisabled_=!this.recentEnrollmentName_.length}dialogTitle_(dialogPage){if(dialogPage===BioEnrollDialogPage.ENROLL||dialogPage===BioEnrollDialogPage.CHOOSE_NAME){return this.i18n("securityKeysBioEnrollmentAddTitle")}return this.i18n("securityKeysBioEnrollmentDialogTitle")}enrollmentsHeader_(enrollments){return this.i18n(enrollments&&enrollments.length?"securityKeysBioEnrollmentEnrollmentsLabel":"securityKeysBioEnrollmentNoEnrollmentsLabel")}isNullOrEmpty_(s){return s===""||!s}}customElements.define(SettingsSecurityKeysBioEnrollDialogElement.is,SettingsSecurityKeysBioEnrollDialogElement);function getTemplate$1O(){return html`<!--_html_template_start_-->    <style include="settings-shared cr-spinner-style">cr-input{display:inline-block;--cr-input-width:8em}#newPIN{padding-inline-end:2em}#newPINRow{display:flex;flex-direction:row}#newPINRow cr-input{width:8em;--cr-input-error-white-space:nowrap}.spinner{padding-bottom:12px}
    </style>

    <cr-dialog id="dialog" close-text="$i18n{close}" ignore-popstate
        on-close="closeDialog_">
      <div slot="title">[[title_]]</div>
      <div slot="body">
        <cr-page-selector attr-for-selected="id" selected="[[shown_]]"
            on-iron-select="onIronSelect_">
          <div id="initial">
            <p>$i18n{securityKeysTouchToContinue}</p>
            <div class="spinner"></div>
          </div>

          <div id="noPINSupport">
            <p>$i18n{securityKeysNoPIN}</p>
          </div>

          <div id="pinPrompt">
            <div id="currentPINEntry" hidden="[[!showCurrentEntry_]]">
              <p>$i18nRaw{securityKeysCurrentPINIntro}</p>

              <div id="currentPINRow">
                <cr-input id="currentPIN" value="{{currentPIN_}}"
                    min-length="[[currentMinPinLength_]]"
                    max-length="255" spellcheck="false"
                    on-input="onCurrentPinInput_"
                    invalid="[[isNonEmpty_(currentPINError_)]]"
                    label="$i18n{securityKeysCurrentPIN}"
                    type$="[[inputType_(pinsVisible_)]]"
                    error-message="[[currentPINError_]]">
                  <cr-icon-button slot="suffix" id="showPINsButton"
                      class$="[[showPinsClass_(pinsVisible_)]]"
                      title="[[showPinsTitle_(pinsVisible_)]]"
                      focus-row-control focus-type="showPassword"
                      on-click="showPinsClick_"></cr-icon-button>
                </cr-input>

              </div>
            </div>

            <p>[[newPINDialogDescription_]]</p>

            <div id="newPINRow">
              <cr-input id="newPIN" value="{{newPIN_}}"
                  min-length="[[newMinPinLength_]]"
                  max-length="255" spellcheck="false" on-input="onNewPinInput_"
                  label="$i18n{securityKeysPIN}"
                  type$="[[inputType_(pinsVisible_)]]"
                  invalid="[[isNonEmpty_(newPINError_)]]"
                  error-message="[[newPINError_]]">
                <!-- If a show/hide icon is included in this row, this div is
                     needed to ensure that the cr-input is the same height
                     as the one to the right. Otherwise they don't vertically
                     align -->
                <div style="height: 36px" slot="suffix"
                     hidden="[[showCurrentEntry_]]"></div>
              </cr-input>
              <cr-input id="confirmPIN" value="{{confirmPIN_}}"
                  min-length="[[newMinPinLength_]]"
                  max-length="255" spellcheck="false"
                  on-input="onConfirmPinInput_"
                  label="$i18n{securityKeysConfirmPIN}"
                  invalid="[[isNonEmpty_(confirmPINError_)]]"
                  type$="[[inputType_(pinsVisible_)]]"
                  error-message="[[confirmPINError_]]">
                <cr-icon-button slot="suffix"
                    class$="[[showPinsClass_(pinsVisible_)]]"
                    title="[[showPinsTitle_(pinsVisible_)]]"
                    hidden="[[showCurrentEntry_]]"
                    focus-row-control focus-type="showPassword"
                    on-click="showPinsClick_"></cr-icon-button>
              </cr-input>
            </div>
          </div>

          <div id="success">
            <p>$i18n{securityKeysPINSuccess}</p>
          </div>

          <div id="error">
            <p>[[pinFailed_(errorCode_)]]</p>
          </div>

          <div id="locked">
            <p>$i18n{securityKeysPINHardLock}</p>
          </div>

          <div id="reinsert">
            <p>$i18n{securityKeysPINSoftLock}</p>
          </div>
        </cr-page-selector>
      </div>

      <div slot="button-container">
        <cr-button id="closeButton"
            class$="[[maybeActionButton_(complete_)]]"
            on-click="closeDialog_">
          [[closeText_(complete_)]]
        </cr-button>
        <cr-button id="pinSubmit" class="action-button"
            on-click="pinSubmitNew_" disabled="[[!setPINButtonValid_]]"
            hidden="[[complete_]]">
          $i18n{securityKeysSetPINConfirm}
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`}var SetPinDialogPage;(function(SetPinDialogPage){SetPinDialogPage["INITIAL"]="initial";SetPinDialogPage["NO_PIN_SUPPORT"]="noPINSupport";SetPinDialogPage["REINSERT"]="reinsert";SetPinDialogPage["LOCKED"]="locked";SetPinDialogPage["ERROR"]="error";SetPinDialogPage["PIN_PROMPT"]="pinPrompt";SetPinDialogPage["SUCCESS"]="success"})(SetPinDialogPage||(SetPinDialogPage={}));const SettingsSecurityKeysSetPinDialogElementBase=I18nMixin(PolymerElement);class SettingsSecurityKeysSetPinDialogElement extends SettingsSecurityKeysSetPinDialogElementBase{static get is(){return"settings-security-keys-set-pin-dialog"}static get template(){return getTemplate$1O()}static get properties(){return{currentPINValid_:Boolean,newPINValid_:Boolean,confirmPINValid_:Boolean,setPINButtonValid_:{type:Boolean,value:false},newPIN_:{type:String,value:""},confirmPIN_:{type:String,value:""},currentPIN_:{type:String,value:""},currentMinPinLength_:Number,newMinPinLength_:{type:Number,observer:"newMinPinLengthChanged_"},retries_:Number,errorCode_:Number,showCurrentEntry_:{type:Boolean,value:false},currentPINError_:{type:String,value:""},newPINError_:{type:String,value:""},confirmPINError_:{type:String,value:""},complete_:{type:Boolean,value:false},shown_:{type:String,value:SetPinDialogPage.INITIAL},pinsVisible_:{type:Boolean,value:false},title_:String,newPINDialogDescription_:String}}browserProxy_=SecurityKeysPinBrowserProxyImpl.getInstance();connectedCallback(){super.connectedCallback();this.title_=this.i18n("securityKeysSetPINInitialTitle");this.$.dialog.showModal();this.browserProxy_.startSetPin().then((({done:done,error:error,currentMinPinLength:currentMinPinLength,newMinPinLength:newMinPinLength,retries:retries})=>{if(done){if(error===1){this.shown_=SetPinDialogPage.NO_PIN_SUPPORT;this.finish_()}else if(error===52){this.shown_=SetPinDialogPage.REINSERT;this.finish_()}else if(error===50){this.shown_=SetPinDialogPage.LOCKED;this.finish_()}else{this.errorCode_=error;this.shown_=SetPinDialogPage.ERROR;this.finish_()}}else if(retries===0){this.shown_=SetPinDialogPage.LOCKED;this.finish_()}else{this.currentPINValid_=true;this.newPINValid_=true;this.confirmPINValid_=true;this.setPINButtonValid_=true;this.currentMinPinLength_=currentMinPinLength;this.newMinPinLength_=newMinPinLength;this.retries_=retries;let focusTarget;if(this.retries_===null){this.showCurrentEntry_=false;focusTarget=this.$.newPIN;this.title_=this.i18n("securityKeysSetPINCreateTitle")}else{this.showCurrentEntry_=true;focusTarget=this.$.currentPIN;this.title_=this.i18n("securityKeysSetPINChangeTitle")}this.shown_=SetPinDialogPage.PIN_PROMPT;window.setTimeout((function(){focusTarget.focus()}),0);this.fire_("ui-ready")}}))}fire_(eventName,detail){this.dispatchEvent(new CustomEvent(eventName,{bubbles:true,composed:true,detail:detail}))}closeDialog_(){this.$.dialog.close();this.finish_()}finish_(){if(this.complete_){return}this.complete_=true;this.$.dialog.focus();this.browserProxy_.close()}onIronSelect_(e){e.stopPropagation()}onCurrentPinInput_(){this.currentPINError_=""}onNewPinInput_(){this.newPINError_=""}onConfirmPinInput_(){this.confirmPINError_=""}isValidPin_(pin,minLength){const utf8Encoded=(new TextEncoder).encode(pin);if(utf8Encoded.length<minLength){return this.i18n("securityKeysPINTooShort")}if(utf8Encoded.length>63||utf8Encoded[utf8Encoded.length-1]===0){return this.i18n("securityKeysPINTooLong")}let length=0;for(const _codepoint of pin){length++}if(length<minLength){return this.i18n("securityKeysPINTooShort")}return""}mismatchError_(retries){if(1<retries&&retries<=3){return this.i18n("securityKeysPINIncorrectRetriesPl",retries.toString())}if(retries===1){return this.i18n("securityKeysPINIncorrectRetriesSin")}return this.i18n("securityKeysPINIncorrect")}focusOn_(focusTarget){let preFocusTarget=this.$.newPIN;if(preFocusTarget===focusTarget){preFocusTarget=this.$.currentPIN}window.setTimeout((function(){preFocusTarget.focus();focusTarget.focus()}),0)}pinSubmitNew_(){if(this.showCurrentEntry_){this.currentPINError_=this.isValidPin_(this.currentPIN_,this.currentMinPinLength_);if(this.currentPINError_!==""){this.focusOn_(this.$.currentPIN);this.fire_("ui-ready");return}}this.newPINError_=this.isValidPin_(this.newPIN_,this.newMinPinLength_);if(this.newPINError_!==""){this.focusOn_(this.$.newPIN);this.fire_("ui-ready");return}if(this.newPIN_!==this.confirmPIN_){this.confirmPINError_=this.i18n("securityKeysPINMismatch");this.focusOn_(this.$.confirmPIN);this.fire_("ui-ready");return}if(this.newPIN_===this.currentPIN_){this.newPINError_=this.i18n("securityKeysSamePINAsCurrent");this.focusOn_(this.$.newPIN);this.fire_("ui-ready");return}this.setPINButtonValid_=false;this.browserProxy_.setPin(this.currentPIN_,this.newPIN_).then((response=>{const error=response.error;if(error===0){this.shown_=SetPinDialogPage.SUCCESS;this.finish_()}else if(error===52){this.shown_=SetPinDialogPage.REINSERT;this.finish_()}else if(error===50){this.shown_=SetPinDialogPage.LOCKED;this.finish_()}else if(error===49){this.currentPINValid_=false;this.retries_--;this.currentPINError_=this.mismatchError_(this.retries_);this.setPINButtonValid_=true;this.focusOn_(this.$.currentPIN);this.fire_("ui-ready")}else{this.errorCode_=error;this.shown_=SetPinDialogPage.ERROR;this.finish_()}}))}showPinsClick_(){this.pinsVisible_=!this.pinsVisible_}isNonEmpty_(s){return s!==""}pinFailed_(){if(this.errorCode_===null){return""}return this.i18n("securityKeysPINError",this.errorCode_.toString())}maybeActionButton_(){return this.complete_?"action-button":"cancel-button"}closeText_(){return this.i18n(this.complete_?"ok":"cancel")}newMinPinLengthChanged_(){PluralStringProxyImpl.getInstance().getPluralString("securityKeysNewPIN",this.newMinPinLength_).then((string=>this.newPINDialogDescription_=string))}showPinsClass_(){return"icon-visibility"+(this.pinsVisible_?"-off":"")}showPinsTitle_(){return this.i18n(this.pinsVisible_?"securityKeysHidePINs":"securityKeysShowPINs")}inputType_(){return this.pinsVisible_?"text":"password"}}customElements.define(SettingsSecurityKeysSetPinDialogElement.is,SettingsSecurityKeysSetPinDialogElement);function getTemplate$1N(){return html`<!--_html_template_start_-->    <style include="settings-shared cr-spinner-style">.spinner{padding-bottom:12px}
    </style>
    <cr-dialog id="dialog" close-text="$i18n{close}" ignore-popstate
         on-close="closeDialog_">
      <div slot="title">[[title_]]</div>
      <div slot="body">
        <cr-page-selector attr-for-selected="id" selected="[[shown_]]"
            on-iron-select="onIronSelect_">
          <div id="initial">
            <p>$i18n{securityKeysResetStep1}</p>
            <div class="spinner"></div>
          </div>

          <div id="noReset">
            <p>$i18n{securityKeysNoReset}</p>
          </div>

          <div id="resetFailed">
            <p>[[resetFailed_(errorCode_)]]</p>
          </div>

          <div id="resetConfirm">
            <p>$i18n{securityKeysResetStep2}</p>
          </div>

          <div id="resetSuccess">
            <p>$i18n{securityKeysResetSuccess}</p>
          </div>

          <div id="resetNotAllowed">
            <p>$i18n{securityKeysResetNotAllowed}</p>
          </div>
        </cr-page-selector>
      </div>
      <div slot="button-container">
        <cr-button id="button" class$="[[maybeActionButton_(complete_)]]"
             on-click="closeDialog_">
          [[closeText_(complete_)]]
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`}var ResetDialogPage;(function(ResetDialogPage){ResetDialogPage["INITIAL"]="initial";ResetDialogPage["NO_RESET"]="noReset";ResetDialogPage["RESET_FAILED"]="resetFailed";ResetDialogPage["RESET_CONFIRM"]="resetConfirm";ResetDialogPage["RESET_SUCCESS"]="resetSuccess";ResetDialogPage["RESET_NOT_ALLOWED"]="resetNotAllowed"})(ResetDialogPage||(ResetDialogPage={}));const SettingsSecurityKeysResetDialogElementBase=I18nMixin(PolymerElement);class SettingsSecurityKeysResetDialogElement extends SettingsSecurityKeysResetDialogElementBase{static get is(){return"settings-security-keys-reset-dialog"}static get template(){return getTemplate$1N()}static get properties(){return{errorCode_:Number,complete_:{type:Boolean,value:false},shown_:{type:String,value:ResetDialogPage.INITIAL},title_:String}}browserProxy_=SecurityKeysResetBrowserProxyImpl.getInstance();connectedCallback(){super.connectedCallback();this.title_=this.i18n("securityKeysResetTitle");this.$.dialog.showModal();this.browserProxy_.reset().then((code=>{if(code===1){this.shown_=ResetDialogPage.NO_RESET;this.finish_()}else if(code!==0){this.errorCode_=code;this.shown_=ResetDialogPage.RESET_FAILED;this.finish_()}else{this.title_=this.i18n("securityKeysResetConfirmTitle");this.shown_=ResetDialogPage.RESET_CONFIRM;this.browserProxy_.completeReset().then((code=>{this.title_=this.i18n("securityKeysResetTitle");if(code===0){this.shown_=ResetDialogPage.RESET_SUCCESS}else if(code===48){this.shown_=ResetDialogPage.RESET_NOT_ALLOWED}else{this.errorCode_=code;this.shown_=ResetDialogPage.RESET_FAILED}this.finish_()}))}}))}closeDialog_(){this.$.dialog.close();this.finish_()}finish_(){if(this.complete_){return}this.complete_=true;this.browserProxy_.close()}onIronSelect_(e){e.stopPropagation()}resetFailed_(code){if(code===null){return""}return this.i18n("securityKeysResetError",code.toString())}closeText_(complete){return this.i18n(complete?"ok":"cancel")}maybeActionButton_(complete){return complete?"action-button":"cancel-button"}}customElements.define(SettingsSecurityKeysResetDialogElement.is,SettingsSecurityKeysResetDialogElement);function getTemplate$1M(){return html`<!--_html_template_start_--><style include="settings-shared"></style>
<settings-subpage page-title="$i18n{securityKeysTitle}"
    route-path$="[[routePath]]">
  <cr-link-row
      id="setPINButton"
      class="hr"
      label="$i18n{securityKeysSetPIN}"
      sub-label="$i18n{securityKeysSetPINDesc}"
      on-click="onSetPin_"></cr-link-row>
  <cr-link-row
      id="credentialManagementButton"
      class="hr"
      label="$i18n{securityKeysCredentialManagementLabel}"
      sub-label="$i18n{securityKeysCredentialManagementDesc}"
      on-click="onCredentialManagement_"></cr-link-row>
  <template is="dom-if" if="[[enableBioEnrollment_]]">
    <cr-link-row
        id="bioEnrollButton"
        class="hr"
        label="$i18n{securityKeysBioEnrollmentSubpageLabel}"
        sub-label="$i18n{securityKeysBioEnrollmentSubpageDescription}"
        on-click="onBioEnroll_"></cr-link-row>
  </template>
  <cr-link-row
      id="resetButton"
      class="hr"
      label="$i18n{securityKeysReset}"
      sub-label="$i18n{securityKeysResetDesc}"
      on-click="onReset_"></cr-link-row>

  <template is="dom-if" if="[[showSetPINDialog_]]" restamp>
    <settings-security-keys-set-pin-dialog on-close="onSetPinDialogClosed_">
    </settings-security-keys-set-pin-dialog>
  </template>

  <template is="dom-if" if="[[showCredentialManagementDialog_]]" restamp>
    <settings-security-keys-credential-management-dialog
        on-credential-management-set-pin="onSetPin_"
        on-close="onCredentialManagementDialogClosed_">
    </settings-security-keys-credential-management-dialog>
  </template>

  <template is="dom-if" if="[[showResetDialog_]]" restamp>
    <settings-security-keys-reset-dialog on-close="onResetDialogClosed_">
    </settings-security-keys-reset-dialog>
  </template>

  <template is="dom-if" if="[[showBioEnrollDialog_]]" restamp>
    <settings-security-keys-bio-enroll-dialog
        on-bio-enroll-set-pin="onSetPin_"
        on-close="onBioEnrollDialogClosed_">
    </settings-security-keys-bio-enroll-dialog>
  </template>
</settings-subpage>
<!--_html_template_end_-->`}const SecurityKeysSubpageElementBase=SettingsViewMixin(PolymerElement);class SecurityKeysSubpageElement extends SecurityKeysSubpageElementBase{static get is(){return"security-keys-subpage"}static get template(){return getTemplate$1M()}static get properties(){return{enableBioEnrollment_:{type:Boolean,readOnly:true,value(){return loadTimeData.getBoolean("enableSecurityKeysBioEnrollment")}},showSetPINDialog_:{type:Boolean,value:false},showCredentialManagementDialog_:{type:Boolean,value:false},showResetDialog_:{type:Boolean,value:false},showBioEnrollDialog_:{type:Boolean,value:false}}}onSetPin_(){this.showSetPINDialog_=true}onSetPinDialogClosed_(){this.showSetPINDialog_=false;focusWithoutInk(this.$.setPINButton)}onCredentialManagement_(){this.showCredentialManagementDialog_=true}onCredentialManagementDialogClosed_(){this.showCredentialManagementDialog_=false;const toFocus=this.shadowRoot.querySelector("#credentialManagementButton");assert(toFocus);focusWithoutInk(toFocus)}onReset_(){this.showResetDialog_=true}onResetDialogClosed_(){this.showResetDialog_=false;focusWithoutInk(this.$.resetButton)}onBioEnroll_(){this.showBioEnrollDialog_=true}onBioEnrollDialogClosed_(){this.showBioEnrollDialog_=false;const toFocus=this.shadowRoot.querySelector("#bioEnrollButton");assert(toFocus);focusWithoutInk(toFocus)}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SecurityKeysSubpageElement.is,SecurityKeysSubpageElement);function getTemplate$1L(){return html`<!--_html_template_start_--><style include="settings-shared">:host{display:block}#content-wrapper{display:flex;flex-direction:row;align-items:center;width:100%}</style>
<template is="dom-if" if="[[expanded]]" restamp>
  <settings-toggle-button id="toggleButton" pref="{{pref}}" label="[[label]]"
      sub-label="[[subLabel]]"
      numeric-unchecked-values="[[numericUncheckedValues]]">
    <div slot="more-actions-after">
      <cr-expand-button id="expandButton" expanded="{{expanded}}">
      </cr-expand-button>
    </div>
  </settings-toggle-button>
</template>
<template is="dom-if" if="[[!expanded]]" restamp>
  <cr-expand-button class="cr-row" id="expandButton" expanded="{{expanded}}">
    <div id="content-wrapper">
      <div class="flex">
        [[label]]
        <div class="cr-secondary-text">[[subLabel]]</div>
      </div>
      <div class="cr-secondary-text" id="stateLabel">
        [[currentStateLabel_]]
      </div>
    </div>
  </cr-expand-button>
</template>
<cr-collapse opened="[[expanded]]">
  <slot name="collapse"></slot>
</cr-collapse>
<!--_html_template_end_-->`}class SecurityPageFeatureRowElement extends PolymerElement{static get is(){return"security-page-feature-row"}static get template(){return getTemplate$1L()}static get properties(){return{expanded:{type:Boolean,notify:true,value:false},label:String,pref:Object,subLabel:String,numericUncheckedValues:Array,stateTextMap:Object,currentStateLabel_:{type:String,computed:"computeCurrentStateLabel_(pref.value, stateTextMap)"}}}computeCurrentStateLabel_(){if(this.stateTextMap&&this.stateTextMap[this.pref.value]!==undefined){return this.stateTextMap[this.pref.value]}return""}}customElements.define(SecurityPageFeatureRowElement.is,SecurityPageFeatureRowElement);function getTemplate$1K(){return html`<!--_html_template_start_--><style include="cr-shared-style">:host{display:flex;flex-direction:column}.box{background-color:var(--cr-card-background-color);box-shadow:var(--cr-card-shadow)}.card{flex:1;padding:20px}.card:hover{background-color:var(--cr-hover-background-color);cursor:pointer}.card-start{border-start-start-radius:var(--cr-card-border-radius)}.card-end{border-start-end-radius:var(--cr-card-border-radius)}#bundlesRadioGroup controlled-radio-button::part(labelWrapper){align-items:center;display:flex;justify-content:space-between}.section-header{color:var(--cr-primary-text-color);flex:1;font-size:108%;font-weight:400;letter-spacing:.25px;margin-bottom:16px;margin-top:30px;width:100%;user-select:none}.section-header.first{margin-top:0px}#safeBrowsingRadioGroup{padding-inline-start:40px}security-page-feature-row{border-end-start-radius:var(--cr-card-border-radius);border-end-end-radius:var(--cr-card-border-radius)}settings-toggle-button{border-radius:var(--cr-card-border-radius)}</style>
<settings-subpage page-title="$i18n{securityPageTitle}"
    learn-more-url="$i18n{safeBrowsingHelpCenterURL}"
    route-path$="[[routePath]]" class="multi-card" hide-close-button>
  <h2 class="section-header cr-secondary-text first">
    $i18n{securityTitle}
  </h2>
  <settings-radio-group id="bundlesRadioGroup"
      class="card-container"
      pref="{{prefs.generated.security_settings_bundle}}"
      on-change="onSecurityBundleChanged_"
      selectable-elements="controlled-radio-button"
      nested-selectable is-horizontal>
    <div class="box card card-start">
      <controlled-radio-button
          id="securitySettingsBundleStandard"
          name="[[securitySettingsBundleSettingEnum_.STANDARD]]"
          pref="{{prefs.generated.security_settings_bundle}}"
          label="$i18n{securityStandardBundleTitle}">
        <cr-button
            id="resetStandardBundleToDefaultsButton"
            on-click="onResetBundleToDefaultsButtonClick_"
            hidden$="[[!isResetStandardBundleToDefaultsButtonVisible_]]">
          $i18n{securityBundleResetToDefaultsButtonLabel}
        </cr-button>
      </controlled-radio-button>
      <!-- TODO(crbug.com/460826064): Fix styling before enabling feature. -->
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:computer"></cr-icon>
          <div class="cr-secondary-text">
            $i18n{securityBundleStandardBulletOne}
          </div>
        </li>
        <li>
          <cr-icon icon="settings20:local-cafe"></cr-icon>
          <div class="cr-secondary-text">
            $i18n{securityBundleStandardBulletTwo}
          </div>
        </li>
        <li>
          <cr-icon icon="settings20:sprint"></cr-icon>
          <div class="cr-secondary-text">
            $i18n{securityBundleStandardBulletThree}
          </div>
        </li>
      </ul>
    </div>
    <div class="box card card-end">
      <controlled-radio-button
          id="securitySettingsBundleEnhanced"
          name="[[securitySettingsBundleSettingEnum_.ENHANCED]]"
          pref="{{prefs.generated.security_settings_bundle}}"
          label="$i18n{securityEnhancedBundleTitle}">
        <cr-button id="resetEnhancedBundleToDefaultsButton"
            on-click="onResetBundleToDefaultsButtonClick_"
            hidden$="[[!isResetEnhancedBundleToDefaultsButtonVisible_]]">
          $i18n{securityBundleResetToDefaultsButtonLabel}
        </cr-button>
      </controlled-radio-button>
      <!-- TODO(crbug.com/460826064): Fix styling before enabling feature. -->
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:center-focus-strong"></cr-icon>
          <div class="cr-secondary-text">
            $i18n{securityBundleEnhancedBulletOne}
          </div>
        </li>
        <li>
          <cr-icon icon="settings20:e911-emergency"></cr-icon>
          <div class="cr-secondary-text">
            $i18n{securityBundleEnhancedBulletTwo}
          </div>
        </li>
        <li>
          <cr-icon icon="settings20:front-hand"></cr-icon>
          <div class="cr-secondary-text">
            $i18n{securityBundleEnhancedBulletThree}
          </div>
        </li>
      </ul>
    </div>
  </settings-radio-group>
  <security-page-feature-row id="safeBrowsingRow"
      on-expanded-changed="onSafeBrowsingRowClick_"
      pref="{{prefs.generated.safe_browsing}}"
      label="$i18n{securitySafeBrowsingTitle}"
      sub-label="$i18n{securitySafeBrowsingDesc}"
      class="box"
      numeric-unchecked-values="[[safeBrowsingOff_]]"
      state-text-map="[[safeBrowsingStateTextMap_]]">
    <div slot="collapse">
      <settings-radio-group id="safeBrowsingRadioGroup"
          pref="{{prefs.generated.safe_browsing}}"
          selectable-elements="controlled-radio-button"
          on-change="onSafeBrowsingRadioChange_">
        <controlled-radio-button
            label="$i18n{securitySafeBrowsingStandardTitle}"
            name="[[safeBrowsingSettingEnum_.STANDARD]]"
            pref="[[prefs.generated.safe_browsing]]">
        </controlled-radio-button>
        <controlled-radio-button id="enhancedProtectionButton"
            label="$i18n{securitySafeBrowsingEnhancedTitle}"
            name="[[safeBrowsingSettingEnum_.ENHANCED]]"
            pref="[[prefs.generated.safe_browsing]]">
        </controlled-radio-button>
      </settings-radio-group>
    </div>
  </security-page-feature-row>
  <h2 class="section-header cr-secondary-text">
    $i18n{securityAccountAndNetworkSectionTitle}
  </h2>
  <settings-toggle-button id="passwordsLeakToggle"
      pref="{{prefs.generated.password_leak_detection}}"
      label="$i18n{securityPasswordsLeakDetectionTitle}"
      sub-label="$i18n{securityPasswordsLeakDetectionDesc}"
      class="box">
  </settings-toggle-button>
</settings-subpage>
<!--_html_template_end_-->`}var SecuritySettingsBundleSetting;(function(SecuritySettingsBundleSetting){SecuritySettingsBundleSetting[SecuritySettingsBundleSetting["STANDARD"]=0]="STANDARD";SecuritySettingsBundleSetting[SecuritySettingsBundleSetting["ENHANCED"]=1]="ENHANCED"})(SecuritySettingsBundleSetting||(SecuritySettingsBundleSetting={}));const SettingsSecurityPageV2ElementBase=RouteObserverMixin(SettingsViewMixin(WebUiListenerMixin(PrefsMixin(PolymerElement))));class SettingsSecurityPageV2Element extends SettingsSecurityPageV2ElementBase{static get is(){return"settings-security-page-v2"}static get template(){return getTemplate$1K()}static get properties(){return{securitySettingsBundleSettingEnum_:{type:Object,value:SecuritySettingsBundleSetting},safeBrowsingSettingEnum_:{type:Object,value:SafeBrowsingSetting},isResetStandardBundleToDefaultsButtonVisible_:{type:Boolean,value:false},isResetEnhancedBundleToDefaultsButtonVisible_:{type:Boolean,value:false},isResettingToDefaults_:{type:Boolean,value:false},safeBrowsingOff_:{type:Array,value:()=>[SafeBrowsingSetting.DISABLED]},safeBrowsingStateTextMap_:{type:Object,value:()=>({[SafeBrowsingSetting.ENHANCED]:loadTimeData.getString("securityFeatureRowStateEnhanced"),[SafeBrowsingSetting.STANDARD]:loadTimeData.getString("securityFeatureRowStateStandard"),[SafeBrowsingSetting.DISABLED]:loadTimeData.getString("securityFeatureRowStateOff")})}}}static get observers(){return["updateResetButtonVisibility_("+"isResettingToDefaults_,"+"prefs.generated.security_settings_bundle.value,"+"prefs.generated.safe_browsing.*),"]}lastFocusTime_;totalTimeInFocus_=0;interactions_=new Set;safeBrowsingStateOnOpen_;securitySettingsBundleStateOnOpen_;isRouteSecurity_=true;eventTracker_=new EventTracker;hatsBrowserProxy_=HatsBrowserProxyImpl.getInstance();ready(){super.ready();this.lastFocusTime_=this.hatsBrowserProxy_.now()}currentRouteChanged(route){if(route!==routes.SECURITY){this.onBeforeUnload_();this.isRouteSecurity_=false;this.eventTracker_.removeAll();return}this.eventTracker_.add(window,"focus",this.onFocus_.bind(this));this.eventTracker_.add(window,"blur",this.onBlur_.bind(this));this.eventTracker_.add(window,"beforeunload",this.onBeforeUnload_.bind(this));this.isRouteSecurity_=true;this.interactions_.clear();this.totalTimeInFocus_=0;this.lastFocusTime_=this.hatsBrowserProxy_.now();CrSettingsPrefs.initialized.then((()=>{this.safeBrowsingStateOnOpen_=this.getPref("generated.safe_browsing").value;this.securitySettingsBundleStateOnOpen_=this.getPref("generated.security_settings_bundle").value}))}onBlur_(){if(!this.isRouteSecurity_){return}const timeSinceLastFocus=this.hatsBrowserProxy_.now()-this.lastFocusTime_;this.totalTimeInFocus_+=timeSinceLastFocus;this.lastFocusTime_=undefined}onFocus_(){this.lastFocusTime_=this.hatsBrowserProxy_.now()}onBeforeUnload_(){if(!this.isRouteSecurity_){return}if(this.safeBrowsingStateOnOpen_===undefined||this.securitySettingsBundleStateOnOpen_===undefined){return}if(this.lastFocusTime_!==undefined){this.totalTimeInFocus_+=this.hatsBrowserProxy_.now()-this.lastFocusTime_}const interactions=Array.from(this.interactions_);this.hatsBrowserProxy_.securityPageHatsRequest(interactions,this.safeBrowsingStateOnOpen_,this.totalTimeInFocus_,this.securitySettingsBundleStateOnOpen_)}onSafeBrowsingRowClick_(e){const isExpanded=e.detail.value;if(isExpanded){this.interactions_.add(SecurityPageV2Interaction.SAFE_BROWSING_ROW_EXPANDED)}}onSafeBrowsingRadioChange_(){const selected=Number.parseInt(this.$.safeBrowsingRadioGroup.selected||"",10);if(selected===SafeBrowsingSetting.STANDARD){this.interactions_.add(SecurityPageV2Interaction.STANDARD_SAFE_BROWSING_RADIO_BUTTON_CLICK)}else if(selected===SafeBrowsingSetting.ENHANCED){this.interactions_.add(SecurityPageV2Interaction.ENHANCED_SAFE_BROWSING_RADIO_BUTTON_CLICK)}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}getBundleSetting_(){return this.getPref("generated.security_settings_bundle").value}getDefaultSafeBrowsingValue_(bundleSetting){return loadTimeData.getInteger(bundleSetting===SecuritySettingsBundleSetting.ENHANCED?"securityEnhancedBundleSafeBrowsingDefault":"securityStandardBundleSafeBrowsingDefault")}updateResetButtonVisibility_(){this.isResetStandardBundleToDefaultsButtonVisible_=false;this.isResetEnhancedBundleToDefaultsButtonVisible_=false;if(this.isResettingToDefaults_){return}const bundleSetting=this.getBundleSetting_();const prefsToCheck=[{prefKey:"generated.safe_browsing",defaultValue:this.getDefaultSafeBrowsingValue_(bundleSetting)}];for(const prefToCheck of prefsToCheck){const pref=this.getPref(prefToCheck.prefKey);if(pref.value!==prefToCheck.defaultValue&&pref.controlledBy==null){if(bundleSetting===SecuritySettingsBundleSetting.ENHANCED){this.isResetEnhancedBundleToDefaultsButtonVisible_=true}else{this.isResetStandardBundleToDefaultsButtonVisible_=true}return}}}onSecurityBundleChanged_(){const selected=Number.parseInt(this.$.bundlesRadioGroup.selected||"",10);if(selected===SecuritySettingsBundleSetting.STANDARD){this.interactions_.add(SecurityPageV2Interaction.STANDARD_BUNDLE_RADIO_BUTTON_CLICK)}else if(selected===SecuritySettingsBundleSetting.ENHANCED){this.interactions_.add(SecurityPageV2Interaction.ENHANCED_BUNDLE_RADIO_BUTTON_CLICK)}this.resetBundleToDefaults_()}onResetBundleToDefaultsButtonClick_(){this.resetBundleToDefaults_()}resetBundleToDefaults_(){this.isResettingToDefaults_=true;const bundleSetting=this.getBundleSetting_();this.setPrefValue("generated.safe_browsing",this.getDefaultSafeBrowsingValue_(bundleSetting));this.isResettingToDefaults_=false}}customElements.define(SettingsSecurityPageV2Element.is,SettingsSecurityPageV2Element);function getTemplate$1J(){return html`<!--_html_template_start_-->    <style>:host{cursor:auto;display:block;width:100%}cr-textarea{width:100%;--cr-textarea-footer-display:flex}
    </style>
    <!-- Max length of 100 KB to prevent browser from freezing. -->
    <cr-textarea id="input" value="{{value}}" rows=1 autogrow="true"
        placeholder="$i18n{secureDnsCustomPlaceholder}" invalid="[[showError_]]"
        first-footer="[[errorText_]]" maxlength="102400" spellcheck="false"
        on-keypress="onKeyPress_" on-input="onInput_"
        on-blur="validate" on-change="validate">
    </cr-textarea>
<!--_html_template_end_-->`}class SecureDnsInputElement extends PolymerElement{static get is(){return"secure-dns-input"}static get template(){return getTemplate$1J()}static get properties(){return{value:String,showError_:{type:Boolean,computed:"isInvalid_(errorText_)"},errorText_:{type:String,value:""}}}browserProxy_=PrivacyPageBrowserProxyImpl.getInstance();onKeyPress_(e){if(e.key==="Enter"&&!e.shiftKey){e.preventDefault();this.validate()}}onInput_(){this.errorText_=""}async validate(){this.errorText_="";const valueToValidate=this.value;const valid=await this.browserProxy_.isValidConfig(valueToValidate);const successfulProbe=valid&&await this.browserProxy_.probeConfig(valueToValidate);if(valueToValidate===this.value&&this.value!==""&&!successfulProbe){this.errorText_=loadTimeData.getString(valid?"secureDnsCustomConnectionError":"secureDnsCustomFormatError")}this.dispatchEvent(new CustomEvent("value-update",{bubbles:true,composed:true,detail:{isValid:valid,text:valueToValidate}}))}focus(){this.$.input.focusInput()}isInvalid_(){return this.errorText_.length>0}}customElements.define(SecureDnsInputElement.is,SecureDnsInputElement);function getTemplate$1I(){return html`<!--_html_template_start_-->    <style include="cr-shared-style md-select">:host(.no-hr) settings-toggle-button.hr{border-top:0}#resolverSelect{width:inherit}#resolverLabel{flex:1}#privacyPolicy{display:none;padding:calc(var(--cr-section-padding) / 2) var(--cr-section-padding)}#privacyPolicy a{color:var(--cr-link-color)}#secureDnsInputContainer{margin-top:calc(var(--cr-section-padding) / 2)}
    </style>

    <settings-toggle-button
        id="secureDnsToggle"
        class="hr"
        pref="{{secureDnsToggle_}}"
        label="$i18n{secureDns}"
        sub-label="[[secureDnsDescription_]]"
        on-change="onToggleChanged_">
    </settings-toggle-button>

    <div id="resolverOptions" hidden="[[!showSecureDnsOptions_]]">
      <div class="cr-row continuation">
        <div id="resolverLabel" class="flex cr-padded-text">
          $i18n{secureDnsSecureDropdownModeDescription}
        </div>

        <select id="resolverSelect"
            class="md-select"
            aria-labelledby="resolverLabel"
            on-change="onDropdownSelectionChanged_">
          <option value="[[resolverTypeEnum_.AUTOMATIC]]">
            $i18n{secureDnsAutomaticModeDescription}
          </option>
          <option value="[[resolverTypeEnum_.CUSTOM]]">
            $i18n{secureDnsCustomProviderDescription}
          </option>
          <template is="dom-repeat" items="[[resolverOptions_]]">
            <option data-resolver-type$="[[resolverTypeEnum_.BUILT_IN]]"
                value="[[index]]">
              [[item.name]]
            </option>
          </template>
        </select>
      </div>

      <div id="privacyPolicy">
        <div class="cr-secondary-text"
            inner-h-t-m-l="[[privacyPolicyString_]]"></div>
      </div>

      <div id="secureDnsInputContainer" class="cr-row continuation">
        <secure-dns-input id="secureDnsInput"
            value="[[secureDnsInputValue_]]"
            on-value-update="onSecureDnsInputEvaluated_">
        </secure-dns-input>
      </div>
    </div>
<!--_html_template_end_-->`}const SettingsSecureDnsElementBase=WebUiListenerMixin(PrefsMixin(I18nMixin(PolymerElement)));var SecureDnsResolverType;(function(SecureDnsResolverType){SecureDnsResolverType["AUTOMATIC"]="automatic";SecureDnsResolverType["BUILT_IN"]="built-in";SecureDnsResolverType["CUSTOM"]="custom"})(SecureDnsResolverType||(SecureDnsResolverType={}));class SettingsSecureDnsElement extends SettingsSecureDnsElementBase{static get is(){return"settings-secure-dns"}static get template(){return getTemplate$1I()}static get properties(){return{resolverTypeEnum_:{type:Object,value:SecureDnsResolverType},secureDnsDescription_:String,secureDnsToggle_:{type:Object,value(){return{type:chrome.settingsPrivate.PrefType.BOOLEAN,value:false}}},showSecureDnsOptions_:Boolean,resolverOptions_:Array,privacyPolicyString_:String,secureDnsInputValue_:String}}browserProxy_=PrivacyPageBrowserProxyImpl.getInstance();connectedCallback(){super.connectedCallback();this.browserProxy_.getSecureDnsResolverList().then((resolvers=>{this.resolverOptions_=resolvers;this.browserProxy_.getSecureDnsSetting().then((setting=>this.onSecureDnsPrefsChanged_(setting)));this.addWebUiListener("secure-dns-setting-changed",(setting=>this.onSecureDnsPrefsChanged_(setting)))}))}onSecureDnsPrefsChanged_(setting){switch(setting.mode){case SecureDnsMode.SECURE:case SecureDnsMode.AUTOMATIC:this.set("secureDnsToggle_.value",true);this.updateConfigRepresentation_(setting.mode,setting.config);break;case SecureDnsMode.OFF:this.set("secureDnsToggle_.value",false);break;default:assertNotReached("Received unknown secure DNS mode")}this.updateManagementView_(setting)}onToggleChanged_(){this.showSecureDnsOptions_=this.secureDnsToggle_.value;if(!this.secureDnsToggle_.value){this.updateDnsPrefs_(SecureDnsMode.OFF);return}const resolver=this.$.resolverSelect.value;if(resolver===SecureDnsResolverType.AUTOMATIC){this.updateDnsPrefs_(SecureDnsMode.AUTOMATIC)}else{if(resolver===SecureDnsResolverType.CUSTOM){this.$.secureDnsInput.focus()}this.updateDnsPrefs_(SecureDnsMode.SECURE)}}updateDnsPrefs_(mode,templates=""){switch(mode){case SecureDnsMode.SECURE:const builtInResolver=this.builtInResolver_();if(!builtInResolver){if(!templates){return}this.setPrefValue("dns_over_https.templates",templates)}else{this.setPrefValue("dns_over_https.templates",builtInResolver.value)}this.setPrefValue("dns_over_https.mode",mode);break;case SecureDnsMode.AUTOMATIC:case SecureDnsMode.OFF:this.setPrefValue("dns_over_https.mode",mode);this.setPrefValue("dns_over_https.templates","");break;default:assertNotReached("Received unknown secure DNS mode")}}onDropdownSelectionChanged_(){switch(this.$.resolverSelect.value){case SecureDnsResolverType.AUTOMATIC:this.updateDnsPrefs_(SecureDnsMode.AUTOMATIC);this.updateConfigRepresentation_(SecureDnsMode.AUTOMATIC,"");break;case SecureDnsResolverType.CUSTOM:this.updateDnsPrefs_(SecureDnsMode.SECURE);this.updateConfigRepresentation_(SecureDnsMode.SECURE,"");break;default:const resolver=this.builtInResolver_();assert(resolver);this.updateDnsPrefs_(SecureDnsMode.SECURE,resolver.value);this.updateConfigRepresentation_(SecureDnsMode.SECURE,resolver.value);break}}updateManagementView_(setting){if(this.prefs===undefined){return}const pref={key:"",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:this.secureDnsToggle_.value};const secureDescription=loadTimeData.getString("secureDnsDescription");if(this.getPref("dns_over_https.mode").enforcement===chrome.settingsPrivate.Enforcement.ENFORCED){pref.enforcement=chrome.settingsPrivate.Enforcement.ENFORCED;pref.controlledBy=this.getPref("dns_over_https.mode").controlledBy;this.secureDnsDescription_=secureDescription}else{switch(setting.managementMode){case SecureDnsUiManagementMode.NO_OVERRIDE:this.secureDnsDescription_=secureDescription;break;case SecureDnsUiManagementMode.DISABLED_MANAGED:pref.enforcement=chrome.settingsPrivate.Enforcement.ENFORCED;this.secureDnsDescription_=loadTimeData.getString("secureDnsDisabledForManagedEnvironment");break;case SecureDnsUiManagementMode.DISABLED_PARENTAL_CONTROLS:pref.enforcement=chrome.settingsPrivate.Enforcement.ENFORCED;this.secureDnsDescription_=loadTimeData.getString("secureDnsDisabledForParentalControl");break;default:assertNotReached("Received unknown secure DNS management mode "+setting.managementMode)}}this.secureDnsToggle_=pref;if(this.secureDnsToggle_.enforcement===chrome.settingsPrivate.Enforcement.ENFORCED){this.showSecureDnsOptions_=false}else{this.showSecureDnsOptions_=this.secureDnsToggle_.value}}updateConfigRepresentation_(mode,template){let hideCustomEntry=true;let selectValue="";let privacyPolicy="";const index=this.resolverOptions_.findIndex((r=>r.value===template));if(index!==-1){privacyPolicy=this.resolverOptions_[index].policy}switch(mode){case SecureDnsMode.AUTOMATIC:selectValue=SecureDnsResolverType.AUTOMATIC;break;case SecureDnsMode.SECURE:if(index===-1){selectValue=SecureDnsResolverType.CUSTOM;hideCustomEntry=false}else{selectValue=index.toString()}break;default:assertNotReached(`Unexpected DNS mode ${mode}`)}this.$.resolverSelect.value=selectValue;this.updatePrivacyPolicyLine_(privacyPolicy);this.$.secureDnsInputContainer.hidden=hideCustomEntry;if(!hideCustomEntry){this.secureDnsInputValue_=template;if(!template){this.$.secureDnsInput.focus()}}}updatePrivacyPolicyLine_(policy){if(!policy){this.$.privacyPolicy.style.display="none";return}this.$.privacyPolicy.style.display="block";this.privacyPolicyString_=sanitizeInnerHtml(loadTimeData.substituteString(loadTimeData.getString("secureDnsSecureDropdownModePrivacyPolicy"),policy))}onSecureDnsInputEvaluated_(event){if(event.detail.isValid){this.updateDnsPrefs_(SecureDnsMode.SECURE,event.detail.text)}}builtInResolver_(){if(this.$.resolverSelect.selectedOptions[0].dataset["resolverType"]===SecureDnsResolverType.BUILT_IN){const index=Number.parseInt(this.$.resolverSelect.value);return this.resolverOptions_[index]}return undefined}}customElements.define(SettingsSecureDnsElement.is,SettingsSecureDnsElement);function getLocalizationStringForContentType(contentSettingsType){switch(contentSettingsType){case ContentSettingsTypes.ADS:return"siteSettingsAdsMidSentence";case ContentSettingsTypes.AR:return"siteSettingsArMidSentence";case ContentSettingsTypes.AUTO_PICTURE_IN_PICTURE:return"siteSettingsAutoPictureInPictureMidSentence";case ContentSettingsTypes.AUTOMATIC_DOWNLOADS:return"siteSettingsAutomaticDownloadsMidSentence";case ContentSettingsTypes.AUTOMATIC_FULLSCREEN:return"siteSettingsAutomaticFullscreenMidSentence";case ContentSettingsTypes.BACKGROUND_SYNC:return"siteSettingsBackgroundSyncMidSentence";case ContentSettingsTypes.BLUETOOTH_DEVICES:return"siteSettingsBluetoothDevicesMidSentence";case ContentSettingsTypes.BLUETOOTH_SCANNING:return"siteSettingsBluetoothScanningMidSentence";case ContentSettingsTypes.CAMERA:return"siteSettingsCameraMidSentence";case ContentSettingsTypes.CAPTURED_SURFACE_CONTROL:return"siteSettingsCapturedSurfaceControlMidSentence";case ContentSettingsTypes.CLIPBOARD:return"siteSettingsClipboardMidSentence";case ContentSettingsTypes.COOKIES:return"siteSettingsCookiesMidSentence";case ContentSettingsTypes.FEDERATED_IDENTITY_API:return"siteSettingsFederatedIdentityApiMidSentence";case ContentSettingsTypes.FILE_SYSTEM_WRITE:return"siteSettingsFileSystemWriteMidSentence";case ContentSettingsTypes.GEOLOCATION:return"siteSettingsLocationMidSentence";case ContentSettingsTypes.HAND_TRACKING:return"siteSettingsHandTrackingMidSentence";case ContentSettingsTypes.HID_DEVICES:return"siteSettingsHidDevicesMidSentence";case ContentSettingsTypes.IDLE_DETECTION:return"siteSettingsIdleDetectionMidSentence";case ContentSettingsTypes.IMAGES:return"siteSettingsImagesMidSentence";case ContentSettingsTypes.JAVASCRIPT:return"siteSettingsJavascriptMidSentence";case ContentSettingsTypes.JAVASCRIPT_OPTIMIZER:return"siteSettingsJavascriptOptimizerMidsentence";case ContentSettingsTypes.KEYBOARD_LOCK:return"siteSettingsKeyboardLockMidSentence";case ContentSettingsTypes.LOCAL_FONTS:return"siteSettingsFontAccessMidSentence";case ContentSettingsTypes.LOCAL_NETWORK_ACCESS:return"siteSettingsLocalNetworkAccessMidSentence";case ContentSettingsTypes.MIC:return"siteSettingsMicMidSentence";case ContentSettingsTypes.MIDI_DEVICES:return"siteSettingsMidiDevicesMidSentence";case ContentSettingsTypes.MIXEDSCRIPT:return"siteSettingsInsecureContentMidSentence";case ContentSettingsTypes.NOTIFICATIONS:return"siteSettingsNotificationsMidSentence";case ContentSettingsTypes.PAYMENT_HANDLER:return"siteSettingsPaymentHandlerMidSentence";case ContentSettingsTypes.POINTER_LOCK:return"siteSettingsPointerLockMidSentence";case ContentSettingsTypes.POPUPS:return"siteSettingsPopupsMidSentence";case ContentSettingsTypes.PROTECTED_CONTENT:return"siteSettingsProtectedContentMidSentence";case ContentSettingsTypes.PROTOCOL_HANDLERS:return"siteSettingsHandlersMidSentence";case ContentSettingsTypes.SENSORS:return"siteSettingsSensorsMidSentence";case ContentSettingsTypes.SERIAL_PORTS:return"siteSettingsSerialPortsMidSentence";case ContentSettingsTypes.SOUND:return"siteSettingsSoundMidSentence";case ContentSettingsTypes.STORAGE_ACCESS:return"siteSettingsStorageAccessMidSentence";case ContentSettingsTypes.USB_DEVICES:return"siteSettingsUsbDevicesMidSentence";case ContentSettingsTypes.WEB_APP_INSTALLATION:return"siteSettingsWebAppInstallationMidSentence";case ContentSettingsTypes.WEB_PRINTING:return"siteSettingsWebPrintingMidSentence";case ContentSettingsTypes.VR:return"siteSettingsVrMidSentence";case ContentSettingsTypes.WINDOW_MANAGEMENT:return"siteSettingsWindowManagementMidSentence";case ContentSettingsTypes.ZOOM_LEVELS:return"siteSettingsZoomLevelsMidSentence";case ContentSettingsTypes.ANTI_ABUSE:case ContentSettingsTypes.PDF_DOCUMENTS:case ContentSettingsTypes.PERFORMANCE:case ContentSettingsTypes.PRIVATE_NETWORK_DEVICES:case ContentSettingsTypes.SITE_DATA:case ContentSettingsTypes.TRACKING_PROTECTION:case ContentSettingsTypes.OFFER_WRITING_HELP:case ContentSettingsTypes.SMART_CARD_READERS:return null;default:assertNotReached()}}function isSettingEnabled(setting){return setting!==ContentSetting.BLOCK}function getTemplate$1H(){return html`<!--_html_template_start_-->  <style include="cr-shared-style settings-shared settings-columned-section">#safeBrowsingSection{padding:0 var(--cr-section-padding)}#advancedProtectionProgramLink{display:none}.bullet-line{align-items:center;display:flex;min-height:var(--cr-section-min-height)}.bullet-line>div{padding-inline-start:var(--cr-radio-button-size)}settings-collapse-radio-button:not(:first-of-type){--settings-collapse-separator-line:var(--cr-separator-line)}settings-collapse-radio-button[hidden]+settings-collapse-radio-button{--settings-collapse-separator-line:0}settings-collapse-radio-button .bullet-line:last-child{padding-bottom:12px}settings-toggle-button{padding-inline-end:0;padding-inline-start:0}settings-toggle-button:not([disabled]){pointer-events:all}#safeBrowsingEnhanced .bullet-line:last-of-type{padding-bottom:12px}#safeBrowsingEnhanced{--cr-radio-button-unchecked-ripple-color:var(--cr-radio-button-checked-ripple-color)}#secureConnectionsSection h2{padding:24px var(--cr-section-padding) 8px}#httpsOnlyModeToggle,#passwordsLeakToggle{padding:0 var(--cr-section-padding)}#httpsFirstModeToggle{margin-top:8px}#httpsFirstModeRadioGroup{width:100%}#httpsFirstModeRadioGroup .list-item{padding-inline-end:20px;padding-inline-start:20px}#learnMoreLabelContainer{padding-bottom:12px;pointer-events:auto}
  </style>
  <settings-subpage page-title="$i18n{securityPageTitle}"
      learn-more-url="$i18n{safeBrowsingHelpCenterURL}"
      route-path$="[[routePath]]" hide-close-button>
    <div id="safeBrowsingSection">
      <h2 class="cr-title-text">$i18n{safeBrowsingSectionLabel}</h2>
      <settings-radio-group id="safeBrowsingRadioGroup" no-set-pref
          pref="{{prefs.generated.safe_browsing}}"
          selectable-elements="cr-radio-button, settings-collapse-radio-button"
          on-change="onSafeBrowsingRadioChange_">
        <settings-collapse-radio-button id="safeBrowsingEnhanced"
            name="[[safeBrowsingSettingEnum_.ENHANCED]]"
            pref="[[prefs.generated.safe_browsing]]"
            label="$i18n{safeBrowsingEnhanced}"
            sub-label="$i18n{safeBrowsingEnhancedDescUpdated}"
            indicator-aria-label="$i18n{controlledSettingPolicy}"
            expand-aria-label="$i18n{safeBrowsingEnhancedExpandA11yLabel}"
            on-expand-clicked="onEnhancedProtectionExpandButtonClicked_"
            no-automatic-collapse>
          <div slot="collapse">
            <div id="enhancedProtectionDescContainer"
                class="settings-columned-section">
              <div class="column">
                <h3 class="description-header">
                  $i18n{columnHeadingWhenOn}
                </h3>
                <ul class="icon-bulleted-list">
                  <li>
                    <cr-icon icon="settings20:data" aria-hidden="true">
                    </cr-icon>
                    <div class="secondary">
                      $i18n{safeBrowsingEnhancedWhenOnBulOne}
                    </div>
                  </li>
                  <li>
                    <cr-icon icon="settings20:download" aria-hidden="true">
                    </cr-icon>
                    <div class="secondary">
                      $i18n{safeBrowsingEnhancedWhenOnBulTwo}
                    </div>
                  </li>
                  <li>
                    <cr-icon icon="settings20:gshield" aria-hidden="true">
                    </cr-icon>
                    <div class="secondary">
                      $i18n{safeBrowsingEnhancedWhenOnBulThree}
                    </div>
                  </li>
                  <li>
                    <cr-icon icon="settings:language" aria-hidden="true">
                    </cr-icon>
                    <div class="secondary">
                      $i18n{safeBrowsingEnhancedWhenOnBulFour}
                    </div>
                  </li>
                </ul>
              </div>
              <div class="column">
                <h3 class="description-header">
                  $i18n{columnHeadingConsider}
                </h3>
                <ul class="icon-bulleted-list">
                  <li>
                    <cr-icon icon="settings20:link"></cr-icon>
                    <div class="cr-secondary-text">
                      $i18n{safeBrowsingEnhancedThingsToConsiderBulOne}
                    </div>
                  </li>
                  <li>
                    <cr-icon icon="settings20:account-circle"></cr-icon>
                    <div class="cr-secondary-text">
                      $i18n{safeBrowsingEnhancedThingsToConsiderBulTwo}
                    </div>
                  </li>
                  <li>
                    <cr-icon icon="settings:performance"></cr-icon>
                    <div class="cr-secondary-text">
                      $i18n{safeBrowsingEnhancedThingsToConsiderBulThree}
                    </div>
                  </li>
                </ul>
              </div>
            </div>
            <div id="learnMoreLabelContainer">
              <div class="cr-secondary-text">
                $i18nRaw{safeBrowsingEnhancedLearnMoreLabel}
              </div>
            </div>
          </div>
        </settings-collapse-radio-button>
        <settings-collapse-radio-button id="safeBrowsingStandard"
            no-collapse="[[hideExtendedReportingRadioButton_]]"
            name="[[safeBrowsingSettingEnum_.STANDARD]]"
            pref="[[prefs.generated.safe_browsing]]"
            label="$i18n{safeBrowsingStandard}"
            sub-label="[[getSafeBrowsingStandardSubLabel_(
                        enableHashPrefixRealTimeLookups_)]]"
            indicator-aria-label="$i18n{controlledSettingPolicy}"
            expand-aria-label="$i18n{safeBrowsingStandardExpandA11yLabel}"
            info-opened="{{infoOpened_}}"
            on-expand-clicked="onStandardProtectionExpandButtonClicked_"
            no-automatic-collapse>
          <div slot="noSelectionCollapse">
            <template is="dom-if" if="[[!hideExtendedReportingRadioButton_]]">
              <settings-toggle-button id="safeBrowsingReportingToggle"
                pref="{{prefs.safebrowsing.scout_reporting_enabled}}"
                label="$i18n{safeBrowsingStandardReportingLabel}"
                sub-label="$i18n{safeBrowsingEnableExtendedReportingDesc}"
                on-change="onSafeBrowsingExtendedReportingChange_"
                disabled="[[getDisabledExtendedSafeBrowsing_(
                              prefs.generated.safe_browsing.*)]]">
              </settings-toggle-button>
            </template>
          </div>
        </settings-collapse-radio-button>
        <settings-collapse-radio-button id="safeBrowsingDisabled" no-collapse
            name="[[safeBrowsingSettingEnum_.DISABLED]]"
            pref="[[prefs.generated.safe_browsing]]"
            label="$i18n{safeBrowsingNone}"
            sub-label="$i18n{safeBrowsingNoneDesc}"
            indicator-aria-label="$i18n{controlledSettingPolicy}">
        </settings-collapse-radio-button>
      </settings-radio-group>
    </div>
    <template is="dom-if" if="[[enableHttpsFirstModeNewSettings_]]" restamp>
      <div id="secureConnectionsSection">
        <h2 class="cr-title-text">$i18n{secureConnectionsSectionTitle}</h2>
        <settings-toggle-button id="httpsFirstModeToggle" class="cr-row first"
            pref="{{prefs.generated.https_first_mode_enabled}}"
            label="$i18n{httpsOnlyModeTitle}"
            sub-label="[[getHttpsFirstModeSubLabel_(
                prefs.generated.https_first_mode_enabled.*)]]"
            numeric-unchecked-values="[[httpsFirstModeUncheckedValues_]]"
            numeric-checked-value=
                "[[httpsFirstModeSettingEnum_.ENABLED_BALANCED]]">
        </settings-toggle-button>
        <cr-collapse id="httpsFirstModeRadioGroupCollapse"
            opened="[[isHttpsFirstModeExpanded_(
                        prefs.generated.https_first_mode_enabled.value)]]">
          <div class="cr-row continuation https-first-mode-radio-group">
            <settings-radio-group id="httpsFirstModeRadioGroup"
                pref="{{prefs.generated.https_first_mode_enabled}}">
              <controlled-radio-button id="httpsFirstModeEnabledBalanced"
                name="[[getName_(
                          httpsFirstModeSettingEnum_.ENABLED_BALANCED)]]"
                pref="[[prefs.generated.https_first_mode_enabled]]"
                label="$i18n{httpsFirstModeEnabledBalancedLabel}"
                class="list-item">
            </controlled-radio-button>
              <controlled-radio-button id="httpsFirstModeEnabledStrict"
                  name="[[getName_(httpsFirstModeSettingEnum_.ENABLED_FULL)]]"
                  pref="[[prefs.generated.https_first_mode_enabled]]"
                  label="$i18n{httpsFirstModeEnabledStrictLabel}"
                  class="list-item">
                <div class="cr-secondary-text">
                  $i18n{httpsFirstModeEnabledStrictSubLabel}
                </div>
              </controlled-radio-button>
            </settings-radio-group>
          </div>
        </cr-collapse>
      </div>
    </template>
    <div class="cr-row first">
      <h2 class="cr-title-text">$i18n{advancedPageTitle}</h2>
    </div>
    <settings-toggle-button id="passwordsLeakToggle"
          label="$i18n{passwordsLeakDetectionLabel}"
          pref="{{prefs.generated.password_leak_detection}}"
          sub-label="[[getPasswordsLeakToggleSubLabel_(
                        prefs.profile.password_manager_leak_detection.*,
                        prefs.generated.password_leak_detection.*)]]">
    </settings-toggle-button>
    <template is="dom-if" if="[[!enableHttpsFirstModeNewSettings_]]" restamp>
      <settings-toggle-button id="httpsOnlyModeToggle"
          pref="{{prefs.generated.https_first_mode_enabled}}"
          label="$i18n{httpsOnlyModeTitle}"
          sub-label="[[getHttpsFirstModeSubLabel_(
                         prefs.generated.https_first_mode_enabled.*)]]"
          numeric-checked-value="[[httpsFirstModeSettingEnum_.ENABLED_FULL]]">
      </settings-toggle-button>
      <template is="dom-if" if="[[showSecureDnsSetting_]]">
        <settings-secure-dns prefs="{{prefs}}" id="secureDnsSettingOld">
        </settings-secure-dns>
      </template>
    </template>
    <template is="dom-if" if="[[enableHttpsFirstModeNewSettings_]]" restamp>
      <template is="dom-if" if="[[showSecureDnsSetting_]]">
        <settings-secure-dns prefs="{{prefs}}" class="hr"
            id="secureDnsSettingNew">
        </settings-secure-dns>
      </template>
    </template>

    <cr-link-row id="javascriptOptimizerSettingLink" class="hr"
        on-click="onJavascriptOptimizerSettingsClick_"
        label="$i18n{securityJavascriptOptimizerLinkTitle}"
        sub-label="[[javascriptOptimizerSubLabel_]]"
        role-description="$i18n{subpageArrowRoleDescription}">
    </cr-link-row>
    <template is="dom-if" if="[[enableSecurityKeysSubpage_]]">
        <cr-link-row id="securityKeysSubpageTrigger" class="hr"
            label="$i18n{securityKeysTitle}"
            sub-label="$i18n{securityKeysDesc}"
            on-click="onSecurityKeysClick_"
            role-description="$i18n{subpageArrowRoleDescription}">
        </cr-link-row>
    </template>

    <cr-link-row id="manageCertificatesLinkRow" class="hr"
        role-description="$i18n{subpageArrowRoleDescription}"
        label="$i18n{manageCertificates}"
        sub-label="$i18n{manageCertificatesDescription}"
        on-click="onManageCertificatesClick_" external>
    </cr-link-row>

    <cr-link-row id="advancedProtectionProgramLink" class="hr"
        label="$i18n{advancedProtectionProgramTitle}"
        sub-label="$i18n{advancedProtectionProgramDesc}"
        on-click="onAdvancedProtectionProgramLinkClick_"
        external>
    </cr-link-row>
    <template is="dom-if" if="[[showDisableSafebrowsingDialog_]]" restamp>
      <settings-simple-confirmation-dialog
          title-text="$i18n{safeBrowsingDisableDialog}"
          body-text="$i18n{safeBrowsingDisableDialogDesc}"
          confirm-text="$i18n{safeBrowsingDisableDialogConfirm}"
          on-close="onDisableSafebrowsingDialogClose_">
      </settings-simple-confirmation-dialog>
    </template>
  </settings-subpage>
<!--_html_template_end_-->`}var HttpsFirstModeSetting;(function(HttpsFirstModeSetting){HttpsFirstModeSetting[HttpsFirstModeSetting["DISABLED"]=0]="DISABLED";HttpsFirstModeSetting[HttpsFirstModeSetting["ENABLED_FULL"]=2]="ENABLED_FULL";HttpsFirstModeSetting[HttpsFirstModeSetting["ENABLED_BALANCED"]=3]="ENABLED_BALANCED"})(HttpsFirstModeSetting||(HttpsFirstModeSetting={}));const SettingsSecurityPageElementBase=HelpBubbleMixin(RouteObserverMixin(SettingsViewMixin(WebUiListenerMixin(I18nMixin(PrefsMixin(PolymerElement))))));class SettingsSecurityPageElement extends SettingsSecurityPageElementBase{static get is(){return"settings-security-page"}static get template(){return getTemplate$1H()}static get properties(){return{showSecureDnsSetting_:{type:Boolean,readOnly:true,value:function(){return loadTimeData.getBoolean("showSecureDnsSetting")}},safeBrowsingSettingEnum_:{type:Object,value:SafeBrowsingSetting},httpsFirstModeSettingEnum_:{type:Object,value:HttpsFirstModeSetting},httpsFirstModeUncheckedValues_:{type:Array,value:()=>[HttpsFirstModeSetting.DISABLED]},javascriptOptimizerSubLabel_:{type:String,value:""},enableHttpsFirstModeNewSettings_:{type:Boolean,readOnly:true,value(){return loadTimeData.getBoolean("enableHttpsFirstModeNewSettings")}},enableSecurityKeysSubpage_:{type:Boolean,readOnly:true,value(){return loadTimeData.getBoolean("enableSecurityKeysSubpage")}},enableHashPrefixRealTimeLookups_:{type:Boolean,value(){return loadTimeData.getBoolean("enableHashPrefixRealTimeLookups")}},hideExtendedReportingRadioButton_:{type:Boolean,value(){return loadTimeData.getBoolean("extendedReportingRemovePrefDependency")&&loadTimeData.getBoolean("hashPrefixRealTimeLookupsSamplePing")}},showDisableSafebrowsingDialog_:Boolean}}browserProxy_=PrivacyPageBrowserProxyImpl.getInstance();metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();siteBrowserProxy_=SiteSettingsBrowserProxyImpl.getInstance();ready(){super.ready();CrSettingsPrefs.initialized.then((()=>{const prefValue=this.getPref("generated.safe_browsing").value;if(prefValue===SafeBrowsingSetting.ENHANCED){this.$.safeBrowsingEnhanced.expanded=true}else if(prefValue===SafeBrowsingSetting.STANDARD){this.$.safeBrowsingStandard.expanded=true}if(!loadTimeData.getBoolean("enableHttpsFirstModeNewSettings")){assert(this.getPref("generated.https_first_mode_enabled").value!==HttpsFirstModeSetting.ENABLED_BALANCED)}}));this.registerHelpBubble("kEnhancedProtectionSettingElementId",this.$.safeBrowsingEnhanced.getBubbleAnchor(),{anchorPaddingTop:10});this.addWebUiListener("contentSettingCategoryChanged",(category=>{if(category===ContentSettingsTypes.JAVASCRIPT_OPTIMIZER){this.updateJavascriptOptimizerEnabledByDefault_()}}));this.updateJavascriptOptimizerEnabledByDefault_()}currentRouteChanged(route,oldRoute){super.currentRouteChanged(route,oldRoute);this.metricsBrowserProxy_.recordSafeBrowsingInteractionHistogram(SafeBrowsingInteractions.SAFE_BROWSING_SHOWED);const queryParams=Router.getInstance().getQueryParameters();const section=queryParams.get("q");if(section==="enhanced"){this.$.safeBrowsingEnhanced.expanded=false;this.$.safeBrowsingStandard.expanded=false}}updateCollapsedButtons_(){this.$.safeBrowsingEnhanced.updateCollapsed();this.$.safeBrowsingStandard.updateCollapsed()}async updateJavascriptOptimizerEnabledByDefault_(){const defaultValue=await this.siteBrowserProxy_.getDefaultValueForContentType(ContentSettingsTypes.JAVASCRIPT_OPTIMIZER);this.javascriptOptimizerSubLabel_=this.i18n(isSettingEnabled(defaultValue.setting)?"securityJavascriptOptimizerLinkRowLabelEnabled":"securityJavascriptOptimizerLinkRowLabelDisabled")}onSafeBrowsingRadioChange_(){const selected=Number.parseInt(this.$.safeBrowsingRadioGroup.selected||"",10);const prefValue=this.getPref("generated.safe_browsing").value;if(prefValue!==selected){this.recordInteractionHistogramOnRadioChange_(selected);this.recordActionOnRadioChange_(selected)}if(selected===SafeBrowsingSetting.DISABLED){this.showDisableSafebrowsingDialog_=true}else{this.updateCollapsedButtons_();this.$.safeBrowsingRadioGroup.sendPrefChange()}}getDisabledExtendedSafeBrowsing_(){return this.getPref("generated.safe_browsing").value!==SafeBrowsingSetting.STANDARD}getSafeBrowsingStandardSubLabel_(){return this.i18n(this.enableHashPrefixRealTimeLookups_?"safeBrowsingStandardDescProxy":"safeBrowsingStandardDesc")}getPasswordsLeakToggleSubLabel_(){let subLabel=this.i18n("passwordsLeakDetectionGeneralDescription");if(this.prefs!==undefined){const generatedPref=this.getPref("generated.password_leak_detection");if(this.getPref("profile.password_manager_leak_detection").value&&!generatedPref.value&&generatedPref.userControlDisabled){subLabel+=" "+this.i18n("passwordsLeakDetectionSignedOutEnabledDescription")}}return subLabel}getName_(value){return value.toString()}getHttpsFirstModeSubLabel_(){const generatedPref=this.getPref("generated.https_first_mode_enabled");if(this.enableHttpsFirstModeNewSettings_){return this.i18n(generatedPref.userControlDisabled?"httpsFirstModeDescriptionAdvancedProtection":"httpsFirstModeSectionDescription")}else{return this.i18n(generatedPref.userControlDisabled?"httpsOnlyModeDescriptionAdvancedProtection":"httpsOnlyModeDescription")}}isHttpsFirstModeExpanded_(value){const generatedPref=this.getPref("generated.https_first_mode_enabled");if(generatedPref.userControlDisabled){return false}return value!==HttpsFirstModeSetting.DISABLED}onManageCertificatesClick_(){this.metricsBrowserProxy_.recordSettingsPageHistogram(PrivacyElementInteractions.MANAGE_CERTIFICATES);OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("certManagementV2URL"))}onAdvancedProtectionProgramLinkClick_(){window.open(loadTimeData.getString("advancedProtectionURL"))}onJavascriptOptimizerSettingsClick_(){Router.getInstance().navigateTo(routes.SITE_SETTINGS_JAVASCRIPT_OPTIMIZER)}onSecurityKeysClick_(){Router.getInstance().navigateTo(routes.SECURITY_KEYS)}onEnhancedProtectionLearnMoreClick_(e){OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("enhancedProtectionHelpCenterURL"));e.preventDefault()}onSafeBrowsingExtendedReportingChange_(){this.metricsBrowserProxy_.recordSettingsPageHistogram(PrivacyElementInteractions.IMPROVE_SECURITY)}onDisableSafebrowsingDialogClose_(){const dialog=this.shadowRoot.querySelector("settings-simple-confirmation-dialog");assert(dialog);const confirmed=dialog.wasConfirmed();this.recordInteractionHistogramOnSafeBrowsingDialogClose_(confirmed);this.recordActionOnSafeBrowsingDialogClose_(confirmed);if(confirmed){this.$.safeBrowsingRadioGroup.sendPrefChange();this.updateCollapsedButtons_()}else{this.$.safeBrowsingRadioGroup.resetToPrefValue()}this.showDisableSafebrowsingDialog_=false;focusWithoutInk(this.$.safeBrowsingDisabled)}onEnhancedProtectionExpandButtonClicked_(){this.recordInteractionHistogramOnExpandButtonClicked_(SafeBrowsingSetting.ENHANCED);this.recordActionOnExpandButtonClicked_(SafeBrowsingSetting.ENHANCED)}onStandardProtectionExpandButtonClicked_(){this.recordInteractionHistogramOnExpandButtonClicked_(SafeBrowsingSetting.STANDARD);this.recordActionOnExpandButtonClicked_(SafeBrowsingSetting.STANDARD)}recordInteractionHistogramOnRadioChange_(safeBrowsingSetting){let action;if(safeBrowsingSetting===SafeBrowsingSetting.ENHANCED){action=SafeBrowsingInteractions.SAFE_BROWSING_ENHANCED_PROTECTION_CLICKED}else if(safeBrowsingSetting===SafeBrowsingSetting.STANDARD){action=SafeBrowsingInteractions.SAFE_BROWSING_STANDARD_PROTECTION_CLICKED}else{action=SafeBrowsingInteractions.SAFE_BROWSING_DISABLE_SAFE_BROWSING_CLICKED}this.metricsBrowserProxy_.recordSafeBrowsingInteractionHistogram(action)}recordInteractionHistogramOnExpandButtonClicked_(safeBrowsingSetting){this.metricsBrowserProxy_.recordSafeBrowsingInteractionHistogram(safeBrowsingSetting===SafeBrowsingSetting.ENHANCED?SafeBrowsingInteractions.SAFE_BROWSING_ENHANCED_PROTECTION_EXPAND_ARROW_CLICKED:SafeBrowsingInteractions.SAFE_BROWSING_STANDARD_PROTECTION_EXPAND_ARROW_CLICKED)}recordInteractionHistogramOnSafeBrowsingDialogClose_(confirmed){this.metricsBrowserProxy_.recordSafeBrowsingInteractionHistogram(confirmed?SafeBrowsingInteractions.SAFE_BROWSING_DISABLE_SAFE_BROWSING_DIALOG_CONFIRMED:SafeBrowsingInteractions.SAFE_BROWSING_DISABLE_SAFE_BROWSING_DIALOG_DENIED)}recordActionOnRadioChange_(safeBrowsingSetting){let actionName;if(safeBrowsingSetting===SafeBrowsingSetting.ENHANCED){actionName="SafeBrowsing.Settings.EnhancedProtectionClicked"}else if(safeBrowsingSetting===SafeBrowsingSetting.STANDARD){actionName="SafeBrowsing.Settings.StandardProtectionClicked"}else{actionName="SafeBrowsing.Settings.DisableSafeBrowsingClicked"}this.metricsBrowserProxy_.recordAction(actionName)}recordActionOnExpandButtonClicked_(safeBrowsingSetting){this.metricsBrowserProxy_.recordAction(safeBrowsingSetting===SafeBrowsingSetting.ENHANCED?"SafeBrowsing.Settings.EnhancedProtectionExpandArrowClicked":"SafeBrowsing.Settings.StandardProtectionExpandArrowClicked")}recordActionOnSafeBrowsingDialogClose_(confirmed){this.metricsBrowserProxy_.recordAction(confirmed?"SafeBrowsing.Settings.DisableSafeBrowsingDialogConfirmed":"SafeBrowsing.Settings.DisableSafeBrowsingDialogDenied")}getFocusConfig(){const map=new Map([[routes.SITE_SETTINGS_JAVASCRIPT_OPTIMIZER.path,"#javascriptOptimizerSettingLink"]]);if(routes.SECURITY_KEYS){map.set(routes.SECURITY_KEYS.path,"#securityKeysSubpageTrigger")}return map}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsSecurityPageElement.is,SettingsSecurityPageElement);function getTemplate$1G(){return html`<!--_html_template_start_--><style include="settings-shared settings-columned-section">#disclaimer{padding:16px var(--cr-section-padding)}</style>
<settings-subpage page-title="$i18n{adMeasurementPageTitle}"
    learn-more-url="$i18n{adPrivacyLearnMoreURL}"
    route-path$="[[routePath]]">
  <settings-toggle-button
      id="adMeasurementToggle"
      pref="{{prefs.privacy_sandbox.m1.ad_measurement_enabled}}"
      label="$i18n{adMeasurementPageToggleLabel}"
      sub-label="$i18n{adMeasurementPageToggleSubLabel}"
      on-settings-boolean-control-change="onToggleChange_">
  </settings-toggle-button>
  <div class="settings-columned-section">
    <div class="column">
      <h2 class="description-header">$i18n{columnHeadingWhenOn}</h2>
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:bar-chart" aria-hidden="true"></cr-icon>
          <div class="secondary">$i18n{adMeasurementPageEnabledBullet1}</div>
        </li>
        <li>
          <cr-icon icon="settings20:auto-delete" aria-hidden="true"></cr-icon>
          <div class="secondary">$i18n{adMeasurementPageEnabledBullet2}</div>
        </li>
        <li>
          <cr-icon icon="settings20:background-replace" aria-hidden="true">
          </cr-icon>
          <div class="secondary">$i18n{adMeasurementPageEnabledBullet3}</div>
        </li>
      </ul>
    </div>
    <div class="column">
      <h2 class="description-header">$i18n{columnHeadingConsider}</h2>
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:delete" aria-hidden="true"></cr-icon>
          <div class="secondary">$i18n{adMeasurementPageConsiderBullet1}</div>
        </li>
        <li>
          <cr-icon icon="settings20:filter-list" aria-hidden="true"></cr-icon>
          <div class="secondary">$i18n{adMeasurementPageConsiderBullet2}</div>
        </li>
      </ul>
    </div>
  </div>
  <div id="disclaimer" class="cr-secondary-text hr">
    $i18nRaw{adMeasurementPageDisclaimer}
  </div>
</settings-subpage>
<!--_html_template_end_-->`}const SettingsPrivacySandboxAdMeasurementSubpageElementBase=SettingsViewMixin(PrefsMixin(PolymerElement));class SettingsPrivacySandboxAdMeasurementSubpageElement extends SettingsPrivacySandboxAdMeasurementSubpageElementBase{static get is(){return"settings-privacy-sandbox-ad-measurement-subpage"}static get template(){return getTemplate$1G()}metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();onToggleChange_(e){const target=e.target;this.metricsBrowserProxy_.recordAction(target.checked?"Settings.PrivacySandbox.AdMeasurement.Enabled":"Settings.PrivacySandbox.AdMeasurement.Disabled")}onPrivacyPolicyLinkClicked_(){this.metricsBrowserProxy_.recordAction("Settings.PrivacySandbox.AdMeasurement.PrivacyPolicyLinkClicked")}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsPrivacySandboxAdMeasurementSubpageElement.is,SettingsPrivacySandboxAdMeasurementSubpageElement);function getTemplate$1F(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared">.interest-item{min-height:auto;padding-block-end:16px;padding-block-start:16px}#label{flex:1}site-favicon{margin-inline-end:16px}</style>
<div class="list-item interest-item" focus-row-container>
  <site-favicon hidden$="[[interest.topic]]" url="[[interest.site]]">
  </site-favicon>
  <div id="label">[[getDisplayString_(interest)]]</div>
  <cr-button role="button" on-click="onInterestChanged_"
      aria-label$="[[getButtonAriaLabel_(interest.removed)]]">
    [[getButtonLabel_(interest.removed)]]
  </cr-button>
</div>
<!--_html_template_end_-->`}const PrivacySandboxInterestItemElementBase=I18nMixin(PolymerElement);class PrivacySandboxInterestItemElement extends PrivacySandboxInterestItemElementBase{static get is(){return"privacy-sandbox-interest-item"}static get template(){return getTemplate$1F()}static get properties(){return{interest:Object}}getDisplayString_(){if(this.interest.topic!==undefined){assert(!this.interest.site);return this.interest.topic.displayString}else{assert(!this.interest.topic);return this.interest.site}}getButtonLabel_(){if(this.interest.topic!==undefined){assert(!this.interest.site);return this.i18n(this.interest.removed?"unblockTopicButtonTextV2":"topicsPageBlockTopic")}else{assert(!this.interest.topic);return this.i18n(this.interest.removed?"fledgePageAllowSite":"fledgePageBlockSite")}}getButtonAriaLabel_(){if(this.interest.topic!==undefined){assert(!this.interest.site);return this.i18n(this.interest.removed?"topicsPageUnblockTopicA11yLabel":"topicsPageBlockTopicA11yLabel",this.interest.topic.displayString)}else{assert(!this.interest.topic);return this.i18n(this.interest.removed?"fledgePageAllowSiteA11yLabel":"fledgePageBlockSiteA11yLabel",this.interest.site)}}onInterestChanged_(e){e.stopPropagation();this.dispatchEvent(new CustomEvent("interest-changed",{bubbles:true,composed:true,detail:this.interest}))}}customElements.define(PrivacySandboxInterestItemElement.is,PrivacySandboxInterestItemElement);function getTemplate$1E(){return html`<!--_html_template_start_--><style include="cr-shared-style">#currentSitesSection{align-items:center;display:flex;padding:0 var(--cr-section-padding)}#currentSitesSectionWrapper{width:100%}#currentSitesHeading{color:var(--cr-secondary-text-color);font-size:100%;font-weight:500;margin:0;padding-block-start:var(--cr-section-vertical-padding)}#currentSitesDescription{padding-block-end:var(--cr-section-vertical-padding)}#learnMoreLink,#learnMoreLinkV2{background:none;border:none;color:var(--cr-link-color);cursor:pointer;margin:0;padding:0;text-decoration:underline}.no-sites{padding-block-end:32px;padding-block-start:16px;padding-inline-start:40px}#blockedSitesDescription{min-height:auto;padding-block-end:16px;padding-block-start:16px}.no-blocked-sites{padding-inline-start:60px}#blockedSitesList{padding:0 var(--cr-section-padding)}#footer{padding-block-end:16px;padding-block-start:16px}#dialog p{margin:0;padding-block-end:16px;padding-block-start:4px}.footer{padding:16px var(--cr-section-padding)}#secondDescription,#secondDescriptionV2{padding:0 var(--cr-section-padding) var(--cr-section-vertical-padding)}a{color:var(--cr-link-color)}</style>

<settings-subpage page-title="$i18n{fledgePageTitle}"
    learn-more-url="$i18n{adPrivacyLearnMoreURL}"
    route-path$="[[routePath]]">
<settings-toggle-button
    id="siteSuggestedAdsToggleV2"
    pref="{{prefs.privacy_sandbox.m1.fledge_enabled}}"
    label="$i18n{fledgePageToggleLabel}"
    sub-label="$i18n{siteSuggestedAdsPageToggleSubLabelV2}"
    on-settings-boolean-control-change="onToggleChange_">
</settings-toggle-button>
<div id="secondDescriptionV2" class="cr-secondary-text">
  $i18n{siteSuggestedAdsPageExplanationV2}
  <button id="learnMoreLinkV2" on-click="onLearnMoreClick_"
      aria-label="$i18n{siteSuggestedAdsPageExplanationV2LinkAriaDescription}">
    $i18n{siteSuggestedAdsPageExplanationV2LinkText}
  </button>
</div>
<template is="dom-if" if="[[!isFledgePrefManaged_(
    prefs.privacy_sandbox.m1.fledge_enabled.enforcement)]]" restamp>
  <div id="currentSitesSection">
    <div id="currentSitesSectionWrapper" class="hr">
      <h2 id="currentSitesHeading">
        $i18n{fledgePageCurrentSitesHeading}
      </h2>
      <div id="currentSitesDescription" class="cr-secondary-text">
        $i18n{fledgePageCurrentSitesDescription}
      </div>
      <template is="dom-if" if="[[isFledgeEnabledAndLoaded_(
          prefs.privacy_sandbox.m1.fledge_enabled.value, isSitesListLoaded_)]]"
          restamp>
        <div role="region"
            aria-label="$i18n{fledgePageCurrentSitesRegionA11yDescription}">
          <template is="dom-repeat" items="[[mainSitesList_]]">
            <privacy-sandbox-interest-item interest="[[item]]"
                on-interest-changed="onInterestChanged_">
            </privacy-sandbox-interest-item>
          </template>
        </div>
        <template is="dom-if" if="[[!isRemainingSitesListEmpty_(
            remainingSitesList_.length)]]" restamp>
          <cr-expand-button id="seeAllSites"
              expanded="{{seeAllSitesExpanded_}}">
            $i18n{fledgePageSeeAllSitesLabel}
          </cr-expand-button>
          <cr-collapse opened="[[seeAllSitesExpanded_]]">
            <div role="region"
                aria-label="$i18n{fledgePageCurrentSitesRegionA11yDescription}">
              <template is="dom-repeat" items="[[remainingSitesList_]]">
                <privacy-sandbox-interest-item interest="[[item]]"
                    on-interest-changed="onInterestChanged_">
                </privacy-sandbox-interest-item>
              </template>
            </div>
          </cr-collapse>
        </template>
        <div id="currentSitesDescriptionEmpty"
            class="no-sites cr-secondary-text"
            hidden="[[!isSitesListEmpty_(sitesList_.length)]]">
          $i18n{fledgePageCurrentSitesDescriptionEmpty}
        </div>
      </template>
      <div id="currentSitesDescriptionDisabled"
          class="no-sites cr-secondary-text"
          hidden="[[prefs.privacy_sandbox.m1.fledge_enabled.value]]">
        $i18n{fledgePageCurrentSitesDescriptionDisabled}
      </div>
    </div>
  </div>
</template>
<cr-expand-button id="blockedSitesRow" class="cr-row"
    expanded="{{blockedSitesExpanded_}}">
  $i18n{fledgePageBlockedSitesHeading}
</cr-expand-button>
<cr-collapse opened="[[blockedSitesExpanded_]]">
  <div id="blockedSitesDescription"
      class$="[[getBlockedSitesDescriptionClass_(blockedSitesList_.length)]]">
    [[computeBlockedSitesDescription_(blockedSitesList_.length)]]
  </div>
  <div id="blockedSitesList" role="region"
      aria-label="$i18n{fledgePageBlockedSitesRegionA11yDescription}">
    <template is="dom-repeat" items="[[blockedSitesList_]]">
      <privacy-sandbox-interest-item interest="[[item]]"
          on-interest-changed="onInterestChanged_">
      </privacy-sandbox-interest-item>
    </template>
  </div>
</cr-collapse>

<div id="footerV2" class="cr-secondary-text hr footer">
  $i18nRaw{siteSuggestedAdsFooterV2Desktop}
</div>
<div id="disclaimer" class="cr-secondary-text footer">
  $i18nRaw{siteSuggestedAdsPageDisclaimer}
</div>
<template is="dom-if" if="[[isLearnMoreDialogOpen_]]" restamp>
  <cr-dialog id="dialog" on-close="onCloseDialog_" show-on-attach>
    <div slot="title">$i18n{fledgePageLearnMoreHeading}</div>
    <div id="bodyV2" slot="body">
      <p>$i18n{siteSuggestedAdsPageLearnMoreBullet1V2}</p>
      <p>$i18n{siteSuggestedAdsPageLearnMoreBullet2V2}</p>
      <p>$i18nRaw{siteSuggestedAdsPageLearnMoreBullet3V2}</p>
    </div>
    <div slot="button-container">
      <cr-button id="closeButton" class="cancel-button" autofocus
          on-click="onCloseDialog_">
        $i18n{close}
      </cr-button>
    </div>
  </cr-dialog>
</template>
</settings-subpage>
<!--_html_template_end_-->`}const maxFledgeSitesCount=15;const SettingsPrivacySandboxFledgeSubpageElementBase=SettingsViewMixin(I18nMixin(PrefsMixin(PolymerElement)));class SettingsPrivacySandboxFledgeSubpageElement extends SettingsPrivacySandboxFledgeSubpageElementBase{static get is(){return"settings-privacy-sandbox-fledge-subpage"}static get template(){return getTemplate$1E()}static get properties(){return{sitesList_:{type:Array,observer:"onSitesListChanged_",value(){return[]}},mainSitesList_:{type:Array,value(){return[]}},remainingSitesList_:{type:Array,value(){return[]}},blockedSitesList_:{type:Array,value(){return[]}},isSitesListLoaded_:{type:Boolean,value:false},isLearnMoreDialogOpen_:{type:Boolean,value:false},seeAllSitesExpanded_:{type:Boolean,value:false,observer:"onSeeAllSitesExpanded_"},blockedSitesExpanded_:{type:Boolean,value:false,observer:"onBlockedSitesExpanded_"}}}static get maxFledgeSites(){return maxFledgeSitesCount}privacySandboxBrowserProxy_=PrivacySandboxBrowserProxyImpl.getInstance();metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();ready(){super.ready();this.privacySandboxBrowserProxy_.getFledgeState().then((state=>this.onFledgeStateChanged_(state)))}isFledgePrefManaged_(){const fledgeEnabledPref=this.getPref("privacy_sandbox.m1.fledge_enabled");if(fledgeEnabledPref.enforcement===chrome.settingsPrivate.Enforcement.ENFORCED){assert(!fledgeEnabledPref.value);return true}return false}onFledgeStateChanged_(state){this.sitesList_=state.joiningSites.map((site=>({site:site,removed:false})));this.blockedSitesList_=state.blockedSites.map((site=>({site:site,removed:true})));this.isSitesListLoaded_=true}onSitesListChanged_(){this.mainSitesList_=this.sitesList_.slice(0,maxFledgeSitesCount);this.remainingSitesList_=this.sitesList_.slice(maxFledgeSitesCount)}isFledgeEnabledAndLoaded_(){return this.getPref("privacy_sandbox.m1.fledge_enabled").value&&this.isSitesListLoaded_}isSitesListEmpty_(){return this.sitesList_.length===0}isRemainingSitesListEmpty_(){return this.remainingSitesList_.length===0}computeBlockedSitesDescription_(){return this.i18n(this.blockedSitesList_.length===0?"fledgePageBlockedSitesDescriptionEmpty":"fledgePageBlockedSitesDescription")}getBlockedSitesDescriptionClass_(){const defaultClass="cr-row continuation cr-secondary-text";return this.blockedSitesList_.length===0?`${defaultClass} no-blocked-sites`:defaultClass}onToggleChange_(e){const target=e.target;this.metricsBrowserProxy_.recordAction(target.checked?"Settings.PrivacySandbox.Fledge.Enabled":"Settings.PrivacySandbox.Fledge.Disabled");this.sitesList_=[]}onLearnMoreClick_(){this.metricsBrowserProxy_.recordAction("Settings.PrivacySandbox.Fledge.LearnMoreClicked");this.isLearnMoreDialogOpen_=true}onCloseDialog_(){this.isLearnMoreDialogOpen_=false;afterNextRender(this,(()=>{this.shadowRoot.querySelector("#learnMoreLink")?.focus()}))}onInterestChanged_(e){const interest=e.detail;assert(!interest.topic);if(interest.removed){this.blockedSitesList_.splice(this.blockedSitesList_.indexOf(interest),1)}else{this.sitesList_.splice(this.sitesList_.indexOf(interest),1);this.blockedSitesList_.push({site:interest.site,removed:true});this.blockedSitesList_.sort(((first,second)=>first.site<second.site?-1:1))}this.sitesList_=this.sitesList_.slice();this.blockedSitesList_=this.blockedSitesList_.slice();this.privacySandboxBrowserProxy_.setFledgeJoiningAllowed(interest.site,interest.removed);this.metricsBrowserProxy_.recordAction(interest.removed?"Settings.PrivacySandbox.Fledge.SiteAdded":"Settings.PrivacySandbox.Fledge.SiteRemoved");afterNextRender(this,(()=>{if(!this.shadowRoot.activeElement){this.shadowRoot.querySelector("#blockedSitesRow")?.focus()}}))}onSeeAllSitesExpanded_(){if(this.seeAllSitesExpanded_){this.metricsBrowserProxy_.recordAction("Settings.PrivacySandbox.Fledge.AllSitesOpened")}}onBlockedSitesExpanded_(){if(this.blockedSitesExpanded_){this.metricsBrowserProxy_.recordAction("Settings.PrivacySandbox.Fledge.BlockedSitesOpened")}}onPrivacyPolicyLinkClicked_(){this.metricsBrowserProxy_.recordAction("Settings.PrivacySandbox.SiteSuggestedAds.PrivacyPolicyLinkClicked")}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsPrivacySandboxFledgeSubpageElement.is,SettingsPrivacySandboxFledgeSubpageElement);const div$1=document.createElement("div");div$1.innerHTML=getTrustedHTML`<cr-iconset name="firstLevelTopics20" size="20">
    <svg>
      <defs>
        <g id="artist" viewBox="0 -960 960 960"><path d="M740-560h140v80h-80v220q0 42-29 71t-71 29q-42 0-71-29t-29-71q0-42 29-71t71-29q8 0 18 1.5t22 6.5v-208ZM120-160v-112q0-35 17.5-63t46.5-43q62-31 126-46.5T440-440q42 0 83.5 6.5T607-414q-20 12-36 29t-28 37q-26-6-51.5-9t-51.5-3q-57 0-112 14t-108 40q-9 5-14.5 14t-5.5 20v32h321q2 20 9.5 40t20.5 40H120Zm320-320q-66 0-113-47t-47-113q0-66 47-113t113-47q66 0 113 47t47 113q0 66-47 113t-113 47Zm0-80q33 0 56.5-23.5T520-640q0-33-23.5-56.5T440-720q-33 0-56.5 23.5T360-640q0 33 23.5 56.5T440-560Zm0-80Zm0 400Z"></path></g>
        <g id="bigtop-updates" viewBox="0 -960 960 960"><path d="M198-278q-57-57-87.5-129.5T80-560q0-80 30.5-152.5T198-842l48 48q-47 47-72.5 107.5T148-560q0 66 25.5 126.5T246-326l-48 48Zm92-92q-38-38-58-87t-20-103q0-54 20-103t58-87l48 48q-29 29-43.5 65.5T280-560q0 40 14.5 76.5T338-418l-48 48Zm150 250v-348q-27-12-43.5-37T380-560q0-42 29-71t71-29q42 0 71 29t29 71q0 30-16.5 55T520-468v348h-80Zm230-250-48-48q29-29 43.5-65.5T680-560q0-40-14.5-76.5T622-702l48-48q38 38 58 87t20 103q0 54-20 103t-58 87Zm92 92-48-48q47-47 72.5-107.5T812-560q0-66-25.5-126.5T714-794l48-48q57 57 87.5 129.5T880-560q0 80-30.5 152.5T762-278Z"></path></g>
        <g id="business-center" viewBox="0 -960 960 960"><path d="M160-120q-33 0-56.5-23.5T80-200v-440q0-33 23.5-56.5T160-720h160v-80q0-33 23.5-56.5T400-880h160q33 0 56.5 23.5T640-800v80h160q33 0 56.5 23.5T880-640v440q0 33-23.5 56.5T800-120H160Zm240-600h160v-80H400v80Zm400 360H600v80H360v-80H160v160h640v-160Zm-360 0h80v-80h-80v80Zm-280-80h200v-80h240v80h200v-200H160v200Zm320 40Z"></path></g>
        <g id="category" viewBox="0 -960 960 960"><path d="m260-520 220-360 220 360H260ZM700-80q-75 0-127.5-52.5T520-260q0-75 52.5-127.5T700-440q75 0 127.5 52.5T880-260q0 75-52.5 127.5T700-80Zm-580-20v-320h320v320H120Zm580-60q42 0 71-29t29-71q0-42-29-71t-71-29q-42 0-71 29t-29 71q0 42 29 71t71 29Zm-500-20h160v-160H200v160Zm202-420h156l-78-126-78 126Zm78 0ZM360-340Zm340 80Z"></path></g>
        <g id="communities" viewBox="0 -960 960 960"><path d="M360-320q33 0 56.5-23.5T440-400q0-33-23.5-56.5T360-480q-33 0-56.5 23.5T280-400q0 33 23.5 56.5T360-320Zm240 0q33 0 56.5-23.5T680-400q0-33-23.5-56.5T600-480q-33 0-56.5 23.5T520-400q0 33 23.5 56.5T600-320ZM480-520q33 0 56.5-23.5T560-600q0-33-23.5-56.5T480-680q-33 0-56.5 23.5T400-600q0 33 23.5 56.5T480-520Zm0 440q-83 0-156-31.5T197-197q-54-54-85.5-127T80-480q0-83 31.5-156T197-763q54-54 127-85.5T480-880q83 0 156 31.5T763-763q54 54 85.5 127T880-480q0 83-31.5 156T763-197q-54 54-127 85.5T480-80Zm0-80q134 0 227-93t93-227q0-134-93-227t-227-93q-134 0-227 93t-93 227q0 134 93 227t227 93Zm0-320Z"></path></g>
        <g id="crowdsource" viewBox="0 -960 960 960"><path d="M660-570q-25 0-42.5-17.5T600-630q0-25 17.5-42.5T660-690q25 0 42.5 17.5T720-630q0 25-17.5 42.5T660-570Zm-360 0q-25 0-42.5-17.5T240-630q0-25 17.5-42.5T300-690q25 0 42.5 17.5T360-630q0 25-17.5 42.5T300-570Zm180 110q-25 0-42.5-17.5T420-520q0-25 17.5-42.5T480-580q25 0 42.5 17.5T540-520q0 25-17.5 42.5T480-460Zm0-220q-25 0-42.5-17.5T420-740q0-25 17.5-42.5T480-800q25 0 42.5 17.5T540-740q0 25-17.5 42.5T480-680Zm0 520q-20 0-40.5-3t-39.5-8v-143q0-35 23.5-60.5T480-400q33 0 56.5 25.5T560-314v143q-19 5-39.5 8t-40.5 3Zm-140-32q-20-8-38.5-18T266-232q-28-20-44.5-52T205-352q0-26-5.5-48.5T180-443q-10-13-37.5-39.5T92-532q-11-11-11-28t11-28q11-11 28-11t28 11l153 145q20 18 29.5 42.5T340-350v158Zm280 0v-158q0-26 10-51t29-42l153-145q12-11 28.5-11t27.5 11q11 11 11 28t-11 28q-23 23-50.5 49T780-443q-14 20-19.5 42.5T755-352q0 36-16.5 68.5T693-231q-16 11-34.5 21T620-192Z"></path></g>
        <g id="directions-car" viewBox="0 -960 960 960"><path d="M240-200v40q0 17-11.5 28.5T200-120h-40q-17 0-28.5-11.5T120-160v-320l84-240q6-18 21.5-29t34.5-11h440q19 0 34.5 11t21.5 29l84 240v320q0 17-11.5 28.5T800-120h-40q-17 0-28.5-11.5T720-160v-40H240Zm-8-360h496l-42-120H274l-42 120Zm-32 80v200-200Zm100 160q25 0 42.5-17.5T360-380q0-25-17.5-42.5T300-440q-25 0-42.5 17.5T240-380q0 25 17.5 42.5T300-320Zm360 0q25 0 42.5-17.5T720-380q0-25-17.5-42.5T660-440q-25 0-42.5 17.5T600-380q0 25 17.5 42.5T660-320Zm-460 40h560v-200H200v200Z"></path></g>
        <g id="keyboard" viewBox="0 -960 960 960"><path d="M160-200q-33 0-56.5-23.5T80-280v-400q0-33 23.5-56.5T160-760h640q33 0 56.5 23.5T880-680v400q0 33-23.5 56.5T800-200H160Zm0-80h640v-400H160v400Zm160-40h320v-80H320v80ZM200-440h80v-80h-80v80Zm120 0h80v-80h-80v80Zm120 0h80v-80h-80v80Zm120 0h80v-80h-80v80Zm120 0h80v-80h-80v80ZM200-560h80v-80h-80v80Zm120 0h80v-80h-80v80Zm120 0h80v-80h-80v80Zm120 0h80v-80h-80v80Zm120 0h80v-80h-80v80ZM160-280v-400 400Z"></path></g>
        <g id="menu-book" viewBox="0 -960 960 960"><path d="M560-564v-68q33-14 67.5-21t72.5-7q26 0 51 4t49 10v64q-24-9-48.5-13.5T700-600q-38 0-73 9.5T560-564Zm0 220v-68q33-14 67.5-21t72.5-7q26 0 51 4t49 10v64q-24-9-48.5-13.5T700-380q-38 0-73 9t-67 27Zm0-110v-68q33-14 67.5-21t72.5-7q26 0 51 4t49 10v64q-24-9-48.5-13.5T700-490q-38 0-73 9.5T560-454ZM260-320q47 0 91.5 10.5T440-278v-394q-41-24-87-36t-93-12q-36 0-71.5 7T120-692v396q35-12 69.5-18t70.5-6Zm260 42q44-21 88.5-31.5T700-320q36 0 70.5 6t69.5 18v-396q-33-14-68.5-21t-71.5-7q-47 0-93 12t-87 36v394Zm-40 118q-48-38-104-59t-116-21q-42 0-82.5 11T100-198q-21 11-40.5-1T40-234v-482q0-11 5.5-21T62-752q46-24 96-36t102-12q58 0 113.5 15T480-740q51-30 106.5-45T700-800q52 0 102 12t96 36q11 5 16.5 15t5.5 21v482q0 23-19.5 35t-40.5 1q-37-20-77.5-31T700-240q-60 0-116 21t-104 59ZM280-494Z"></path></g>
        <g id="fastfood" viewBox="0 -960 960 960"><path d="M533-440q-32-45-84.5-62.5T340-520q-56 0-108.5 17.5T147-440h386ZM40-360q0-109 91-174.5T340-600q118 0 209 65.5T640-360H40Zm0 160v-80h600v80H40ZM720-40v-80h56l56-560H450l-10-80h200v-160h80v160h200L854-98q-3 25-22 41.5T788-40h-68Zm0-80h56-56ZM80-40q-17 0-28.5-11.5T40-80v-40h600v40q0 17-11.5 28.5T600-40H80Zm260-400Z"></path></g>
        <g id="finance-mode" viewBox="0 -960 960 960"><path d="M320-414v-306h120v306l-60-56-60 56Zm200 60v-526h120v406L520-354ZM120-216v-344h120v224L120-216Zm0 98 258-258 142 122 224-224h-64v-80h200v200h-80v-64L524-146 382-268 232-118H120Z"></path></g>
        <g id="gavel" viewBox="0 -960 960 960"><path d="M160-120v-80h480v80H160Zm226-194L160-540l84-86 228 226-86 86Zm254-254L414-796l86-84 226 226-86 86Zm184 408L302-682l56-56 522 522-56 56Z"></path></g>
        <g id="health-and-beauty" viewBox="0 -960 960 960"><path d="M200-80 40-520l200-120v-240h160v240l200 120L440-80H200Zm480 0q-17 0-28.5-11.5T640-120q0-17 11.5-28.5T680-160h120v-80H680q-17 0-28.5-11.5T640-280q0-17 11.5-28.5T680-320h120v-80H680q-17 0-28.5-11.5T640-440q0-17 11.5-28.5T680-480h120v-80H680q-17 0-28.5-11.5T640-600q0-17 11.5-28.5T680-640h120v-80H680q-17 0-28.5-11.5T640-760q0-17 11.5-28.5T680-800h160q33 0 56.5 23.5T920-720v560q0 33-23.5 56.5T840-80H680Zm-424-80h128l118-326-124-74H262l-124 74 118 326Zm64-200Z"></path></g>
        <g id="home-and-garden" viewBox="0 -960 960 960"><path d="M641-26q-20 12-41.5 19T555 0q-64 0-109-45.5T401-156q0-23 6.5-44t19.5-40q-13-19-19.5-41t-6.5-45q0-64 45-109t109-45q23 0 45 6.5t41 19.5q19-13 41-19.5t45-6.5q64 0 109 44.5T881-328q0 23-6.5 45T855-242q13 20 19.5 42.5T881-154q0 64-45.5 109T725 0q-23 0-44-7t-40-19Zm134-183-36-32 40-34q11-9 16.5-22.5T801-326q0-31-21.5-52.5T727-400q-16 0-29.5 5.5T675-378l-35 40-34-40q-9-11-22.5-16.5T554-400q-30 0-51.5 22T481-324q0 15 6.5 28.5T506-271l36 30-40 34q-10 9-15.5 22t-5.5 29q0 32 21.5 54T554-80q15 0 29.5-7t26.5-21l30-34 35 40q9 11 22.5 16.5T727-80q31 0 52.5-22t21.5-54q0-14-6.5-28T775-209Zm-134 25q23 0 39.5-16.5T697-240q0-23-16.5-39.5T641-296q-23 0-39.5 16.5T585-240q0 23 16.5 39.5T641-184Zm-481 24v-402H40l440-358 440 358H800v42h-80v-102L480-818 240-622v382h120v80H160Zm481-80Z"></path></g>
        <g id="newsmode" viewBox="0 -960 960 960"><path d="M160-120q-33 0-56.5-23.5T80-200v-560q0-33 23.5-56.5T160-840h640q33 0 56.5 23.5T880-760v560q0 33-23.5 56.5T800-120H160Zm0-80h640v-560H160v560Zm80-80h480v-80H240v80Zm0-160h160v-240H240v240Zm240 0h240v-80H480v80Zm0-160h240v-80H480v80ZM160-200v-560 560Z"></path></g>
        <g id="pets" viewBox="0 -960 960 960"><path d="M180-475q-42 0-71-29t-29-71q0-42 29-71t71-29q42 0 71 29t29 71q0 42-29 71t-71 29Zm180-160q-42 0-71-29t-29-71q0-42 29-71t71-29q42 0 71 29t29 71q0 42-29 71t-71 29Zm240 0q-42 0-71-29t-29-71q0-42 29-71t71-29q42 0 71 29t29 71q0 42-29 71t-71 29Zm180 160q-42 0-71-29t-29-71q0-42 29-71t71-29q42 0 71 29t29 71q0 42-29 71t-71 29ZM266-75q-45 0-75.5-34.5T160-191q0-52 35.5-91t70.5-77q29-31 50-67.5t50-68.5q22-26 51-43t63-17q34 0 63 16t51 42q28 32 49.5 69t50.5 69q35 38 70.5 77t35.5 91q0 47-30.5 81.5T694-75q-54 0-107-9t-107-9q-54 0-107 9t-107 9Z"></path></g>
        <g id="real-estate-agent" viewBox="0 -960 960 960"><path d="M760-400v-260L560-800 360-660v60h-80v-100l280-200 280 200v300h-80ZM560-800Zm20 160h40v-40h-40v40Zm-80 0h40v-40h-40v40Zm80 80h40v-40h-40v40Zm-80 0h40v-40h-40v40ZM280-220l278 76 238-74q-5-9-14.5-15.5T760-240H558q-27 0-43-2t-33-8l-93-31 22-78 81 27q17 5 40 8t68 4q0-11-6.5-21T578-354l-234-86h-64v220ZM40-80v-440h304q7 0 14 1.5t13 3.5l235 87q33 12 53.5 42t20.5 66h80q50 0 85 33t35 87v40L560-60l-280-78v58H40Zm80-80h80v-280h-80v280Z"></path></g>
        <g id="sailing" viewBox="0 -960 960 960"><path d="m120-420 320-460v460H120Zm153-80h87v-125l-87 125Zm227 80q12-28 26-98t14-142q0-72-13.5-148T500-920q61 18 121.5 67t109 117q48.5 68 79 149.5T840-420H500Zm104-80h148q-17-77-55.5-141T615-750q2 21 3.5 43.5T620-660q0 47-4.5 87T604-500ZM360-200q-36 0-67-17t-53-43q-14 15-30.5 28T173-211q-35-26-59.5-64.5T80-360h800q-9 46-33.5 84.5T787-211q-20-8-36.5-21T720-260q-23 26-53.5 43T600-200q-36 0-67-17t-53-43q-22 26-53 43t-67 17ZM80-40v-80h40q32 0 62.5-10t57.5-30q27 20 57.5 29.5T360-121q32 0 62-9.5t58-29.5q27 20 57.5 29.5T600-121q32 0 62-9.5t58-29.5q28 20 58 30t62 10h40v80h-40q-31 0-61-7.5T720-70q-29 15-59 22.5T600-40q-31 0-61-7.5T480-70q-29 15-59 22.5T360-40q-31 0-61-7.5T240-70q-29 15-59 22.5T120-40H80Zm280-460Zm244 0Z"></path></g>
        <g id="school" viewBox="0 -960 960 960"><path d="M480-120 200-272v-240L40-600l440-240 440 240v320h-80v-276l-80 44v240L480-120Zm0-332 274-148-274-148-274 148 274 148Zm0 241 200-108v-151L480-360 280-470v151l200 108Zm0-241Zm0 90Zm0 0Z"></path></g>
        <g id="shopping-bag" viewBox="0 -960 960 960"><path d="M240-80q-33 0-56.5-23.5T160-160v-480q0-33 23.5-56.5T240-720h80q0-66 47-113t113-47q66 0 113 47t47 113h80q33 0 56.5 23.5T800-640v480q0 33-23.5 56.5T720-80H240Zm0-80h480v-480h-80v80q0 17-11.5 28.5T600-520q-17 0-28.5-11.5T560-560v-80H400v80q0 17-11.5 28.5T360-520q-17 0-28.5-11.5T320-560v-80h-80v480Zm160-560h160q0-33-23.5-56.5T480-800q-33 0-56.5 23.5T400-720ZM240-160v-480 480Z"></path></g>
        <g id="sports-and-outdoors" viewBox="0 -960 960 960"><path d="m414-168 12-56q3-13 12.5-21.5T462-256l124-10q13-2 24 5t16 19l16 38q39-23 70-55.5t52-72.5l-12-6q-11-8-16-19.5t-2-24.5l28-122q3-12 12.5-20t21.5-10q-5-25-12.5-48.5T764-628q-9 5-19.5 4.5T726-630l-106-64q-11-7-16-19t-2-25l8-34q-31-14-63.5-21t-66.5-7q-14 0-29 1.5t-29 4.5l30 68q5 12 2.5 25T442-680l-94 82q-10 9-23.5 10t-24.5-6l-92-56q-23 38-35.5 81.5T160-480q0 16 4 52l88-8q14-2 25.5 4.5T294-412l48 114q5 12 2.5 25T332-252l-38 32q27 20 57.5 33t62.5 19Zm72-172q-13 2-24-5t-16-19l-54-124q-5-12-1.5-25t13.5-21l102-86q9-9 22-10t24 6l112 66q11 7 17 19t3 25l-32 130q-3 13-12 21.5T618-352l-132 12Zm-6 260q-83 0-156-31.5T197-197q-54-54-85.5-127T80-480q0-83 31.5-156T197-763q54-54 127-85.5T480-880q83 0 156 31.5T763-763q54 54 85.5 127T880-480q0 83-31.5 156T763-197q-54 54-127 85.5T480-80Z"></path></g>
        <g id="travel" viewBox="0 -960 960 960"><path d="m274-274-128-70 42-42 100 14 156-156-312-170 56-56 382 98 157-155q17-17 42.5-17t42.5 17q17 17 17 42.5T812-726L656-570l98 382-56 56-170-312-156 156 14 100-42 42-70-128Z"></path></g>
        <g id="videogame-asset" viewBox="0 -960 960 960"><path d="M160-240q-33 0-56.5-23.5T80-320v-320q0-33 23.5-56.5T160-720h640q33 0 56.5 23.5T880-640v320q0 33-23.5 56.5T800-240H160Zm0-80h640v-320H160v320Zm120-40h80v-80h80v-80h-80v-80h-80v80h-80v80h80v80Zm300 0q25 0 42.5-17.5T640-420q0-25-17.5-42.5T580-480q-25 0-42.5 17.5T520-420q0 25 17.5 42.5T580-360Zm120-120q25 0 42.5-17.5T760-540q0-25-17.5-42.5T700-600q-25 0-42.5 17.5T640-540q0 25 17.5 42.5T700-480ZM160-320v-320 320Z"></path></g>
      </defs>
    </svg>
</cr-iconset>
`;const iconsets$1=div$1.querySelectorAll("cr-iconset");for(const iconset of iconsets$1){document.head.appendChild(iconset)}function getTemplate$1D(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared">#explanationText{padding:4px var(--cr-section-padding) 12px}.outer-row{align-items:center;display:flex;min-height:var(--cr-section-two-line-min-height);width:100%}.topic-toggle-row:hover{background-color:var(--cr-hover-background-color)}.topic-toggle-row{--cr-icon-button-margin-end:20px;padding:0 var(--cr-section-padding)}.icon{margin-inline-end:var(--cr-icon-button-margin-end)}.label-wrapper{padding:16px 0;margin-inline-end:20px}
</style>
<settings-subpage page-title="$i18n{manageTopicsHeading}"
    learn-more-url="$i18n{adPrivacyLearnMoreURL}"
    route-path$="[[routePath]]">
  <div id="explanationText">
    $i18n{manageTopicsPageDescription}
    <span id="learnMoreLink" on-click="onLearnMoreClick_">
      $i18nRaw{manageTopicsPageLearnMoreLink}
    </span>
  </div>
  <template is="dom-repeat" items="[[firstLevelTopicsList_]]">
    <div class="topic-toggle-row" on-click="onToggleRowClick_" actionable>
      <div class="outer-row">
        <span class="icon">
          <cr-icon slot="icon"
              icon="[[computeTopicIcon_(item.topic.topicId)]]">
          </cr-icon>
        </span>
        <div class="flex label-wrapper">
          <div class="label">[[item.topic.displayString]]</div>
          <div class="cr-secondary-text sub-label">
            <span class="sub-label-text">[[item.topic.description]]</span>
          </div>
        </div>
        <cr-toggle id="toggle-[[item.topic.topicId]]"
            on-change="onToggleChange_"
            checked="[[!item.removed]]"
            aria-label="[[item.topic.displayString]]"
            aria-description="[[item.topic.description]]"></cr-toggle>
      </div>
    </div>
  </template>
  <template is="dom-if" if="[[shouldShowBlockTopicDialog_]]" restamp>
    <settings-simple-confirmation-dialog id="blockTopicDialog"
        title-text="[[blockTopicDialogTitle_]]"
        body-text="[[blockTopicDialogBody_]]"
        confirm-text="$i18n{topicsPageBlockTopic}"
        on-close="onBlockTopicDialogClose_">
    </settings-simple-confirmation-dialog>
  </template>
</settings-subpage>
<!--_html_template_end_-->`}const SettingsPrivacySandboxManageTopicsSubpageElementBase=SettingsViewMixin(RouteObserverMixin(I18nMixin(PrefsMixin(PolymerElement))));const topicIdToIconName=new Map([[1,"firstLevelTopics20:artist"],[57,"firstLevelTopics20:directions-car"],[86,"firstLevelTopics20:health-and-beauty"],[100,"firstLevelTopics20:menu-book"],[103,"firstLevelTopics20:business-center"],[126,"firstLevelTopics20:keyboard"],[149,"firstLevelTopics20:finance-mode"],[172,"firstLevelTopics20:fastfood"],[180,"firstLevelTopics20:videogame-asset"],[196,"firstLevelTopics20:sailing"],[207,"firstLevelTopics20:home-and-garden"],[215,"firstLevelTopics20:bigtop-updates"],[226,"firstLevelTopics20:school"],[239,"firstLevelTopics20:gavel"],[243,"firstLevelTopics20:newsmode"],[250,"firstLevelTopics20:communities"],[254,"firstLevelTopics20:crowdsource"],[263,"firstLevelTopics20:pets"],[272,"firstLevelTopics20:real-estate-agent"],[289,"firstLevelTopics20:shopping-bag"],[299,"firstLevelTopics20:sports-and-outdoors"],[332,"firstLevelTopics20:travel"]]);class SettingsPrivacySandboxManageTopicsSubpageElement extends SettingsPrivacySandboxManageTopicsSubpageElementBase{static get is(){return"settings-privacy-sandbox-manage-topics-subpage"}static get template(){return getTemplate$1D()}static get properties(){return{firstLevelTopicsList_:{type:Array,value(){return[]}},blockTopicDialogTitle_:{type:String,value:""},blockTopicDialogBody_:{type:String,value:""},shouldShowBlockTopicDialog_:{type:Boolean,value:false}}}privacySandboxBrowserProxy_=PrivacySandboxBrowserProxyImpl.getInstance();metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();topicBeingToggled_;ready(){super.ready();this.privacySandboxBrowserProxy_.getFirstLevelTopics().then((state=>this.onFirstLevelTopicsStateChanged_(state)))}currentRouteChanged(newRoute,oldRoute){super.currentRouteChanged(newRoute,oldRoute);if(newRoute===routes.PRIVACY_SANDBOX_MANAGE_TOPICS){if(!this.getPref("privacy_sandbox.m1.topics_enabled").value){Router.getInstance().navigateTo(routes.PRIVACY_SANDBOX_TOPICS);return}this.privacySandboxBrowserProxy_.getFirstLevelTopics().then((state=>this.onFirstLevelTopicsStateChanged_(state)));this.metricsBrowserProxy_.recordAction("Settings.PrivacySandbox.Topics.Manage.PageOpened")}}onFirstLevelTopicsStateChanged_(state){const blockedTopicsList=state.blockedTopics.map((topic=>({topic:topic,removed:true})));this.firstLevelTopicsList_=state.firstLevelTopics.map((firstLevelTopic=>({topic:firstLevelTopic,removed:blockedTopicsList.some((interest=>interest.topic?.topicId===firstLevelTopic.topicId))})))}onToggleRowClick_(e){e.stopPropagation();assert(e.model.item?.topic);const toggleId=`#toggle-${e.model.item.topic.topicId}`;const toggleBeingChanged=this.shadowRoot.querySelector(toggleId);assert(toggleBeingChanged);toggleBeingChanged.click()}async onToggleChange_(e){e.stopPropagation();this.topicBeingToggled_=e.model.item;assert(this.topicBeingToggled_);assert(this.topicBeingToggled_.topic);const toggleId=`#toggle-${this.topicBeingToggled_.topic.topicId}`;const toggleBeingChanged=this.shadowRoot.querySelector(toggleId);assert(toggleBeingChanged);if(toggleBeingChanged.checked){this.updateTopicState_({blocked:false});return}const childTopics=await this.privacySandboxBrowserProxy_.getChildTopicsCurrentlyAssigned(this.topicBeingToggled_.topic);if(childTopics.length!==0){this.blockTopicDialogTitle_=loadTimeData.getStringF("manageTopicsDialogTitle",this.topicBeingToggled_.topic.displayString);this.blockTopicDialogBody_=loadTimeData.getStringF("manageTopicsDialogBody",this.topicBeingToggled_.topic.displayString);this.shouldShowBlockTopicDialog_=true;return}this.updateTopicState_({blocked:true})}updateTopicState_(blockedOptions){assert(this.topicBeingToggled_);assert(this.topicBeingToggled_.topic);this.topicBeingToggled_.removed=blockedOptions.blocked;this.firstLevelTopicsList_=this.firstLevelTopicsList_.slice();this.privacySandboxBrowserProxy_.setTopicAllowed(this.topicBeingToggled_.topic,!blockedOptions.blocked);this.topicBeingToggled_=undefined;if(blockedOptions.blocked){this.metricsBrowserProxy_.recordAction("Settings.PrivacySandbox.Topics.Manage.TopicBlocked")}else{this.metricsBrowserProxy_.recordAction("Settings.PrivacySandbox.Topics.Manage.TopicEnabled")}}onBlockTopicDialogClose_(){const dialog=this.shadowRoot.querySelector("settings-simple-confirmation-dialog");assert(dialog);if(dialog.wasConfirmed()){this.onBlockButtonDialogHandler_()}else{this.onCancelButtonDialogHandler_()}this.blockTopicDialogBody_="";this.blockTopicDialogTitle_="";this.topicBeingToggled_=undefined;this.shouldShowBlockTopicDialog_=false}onCancelButtonDialogHandler_(){this.metricsBrowserProxy_.recordAction("Settings.PrivacySandbox.Topics.Manage.TopicBlockingCanceled");this.firstLevelTopicsList_=this.firstLevelTopicsList_.map((topic=>({...topic})))}onBlockButtonDialogHandler_(){this.metricsBrowserProxy_.recordAction("Settings.PrivacySandbox.Topics.Manage.TopicBlockingConfirmed");this.updateTopicState_({blocked:true})}onLearnMoreClick_(){this.metricsBrowserProxy_.recordAction("Settings.PrivacySandbox.Topics.Manage.LearnMoreClicked")}computeTopicIcon_(topicId){return topicIdToIconName.get(topicId)||"firstLevelTopics20:category"}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsPrivacySandboxManageTopicsSubpageElement.is,SettingsPrivacySandboxManageTopicsSubpageElement);function getTemplate$1C(){return html`<!--_html_template_start_--><style include="cr-shared-style"></style>
<settings-subpage page-title="$i18n{adPrivacyPageTitle}"
    learn-more-url="$i18n{adPrivacyLearnMoreURL}"
    route-path$="[[routePath]]">
  <template is="dom-if" if="[[!isPrivacySandboxRestricted_]]">
    <cr-link-row
        id="privacySandboxTopicsLinkRow"
        start-icon="settings20:interests"
        label="$i18n{adPrivacyPageTopicsLinkRowLabel}"
        sub-label="[[computePrivacySandboxTopicsSublabel_(
                      prefs.privacy_sandbox.m1.topics_enabled.value)]]"
        on-click="onPrivacySandboxTopicsClick_"></cr-link-row>
    <cr-link-row
        id="privacySandboxFledgeLinkRow"
        start-icon="settings20:checklist"
        class="hr"
        label="$i18n{adPrivacyPageFledgeLinkRowLabel}"
        sub-label="[[computePrivacySandboxFledgeSublabel_(
                      prefs.privacy_sandbox.m1.fledge_enabled.value)]]"
        on-click="onPrivacySandboxFledgeClick_"></cr-link-row>
  </template>
  <cr-link-row
      id="privacySandboxAdMeasurementLinkRow"
      start-icon="settings20:bar-chart"
      class$="[[measurementLinkRowClass_]]"
      label="$i18n{adPrivacyPageAdMeasurementLinkRowLabel}"
      sub-label="[[computePrivacySandboxAdMeasurementSublabel_(
                    prefs.privacy_sandbox.m1.ad_measurement_enabled.value)]]"
      on-click="onPrivacySandboxAdMeasurementClick_"></cr-link-row>
</settings-subpage>
<!--_html_template_end_-->`}const SettingsPrivacySandboxPageElementBase=SettingsViewMixin(I18nMixin(PrefsMixin(PolymerElement)));class SettingsPrivacySandboxPageElement extends SettingsPrivacySandboxPageElementBase{static get is(){return"settings-privacy-sandbox-page"}static get template(){return getTemplate$1C()}static get properties(){return{isPrivacySandboxRestricted_:{type:Boolean,value:()=>loadTimeData.getBoolean("isPrivacySandboxRestricted")},measurementLinkRowClass_:{type:String,value:()=>loadTimeData.getBoolean("isPrivacySandboxRestricted")?"":"hr"}}}metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();computePrivacySandboxTopicsSublabel_(){return this.i18n(this.isTopicsEnabled_()?"adPrivacyPageTopicsLinkRowSubLabelEnabled":"adPrivacyPageTopicsLinkRowSubLabelDisabled")}computePrivacySandboxFledgeSublabel_(){return this.i18n(this.isFledgeEnabled_()?"adPrivacyPageFledgeLinkRowSubLabelEnabled":"adPrivacyPageFledgeLinkRowSubLabelDisabled")}computePrivacySandboxAdMeasurementSublabel_(){return this.i18n(this.isAdMeasurementEnabled_()?"adPrivacyPageAdMeasurementLinkRowSubLabelEnabled":"adPrivacyPageAdMeasurementLinkRowSubLabelDisabled")}onPrivacySandboxTopicsClick_(){this.metricsBrowserProxy_.recordAction("Settings.PrivacySandbox.Topics.Opened");Router.getInstance().navigateTo(routes.PRIVACY_SANDBOX_TOPICS)}onPrivacySandboxFledgeClick_(){this.metricsBrowserProxy_.recordAction("Settings.PrivacySandbox.Fledge.Opened");Router.getInstance().navigateTo(routes.PRIVACY_SANDBOX_FLEDGE)}onPrivacySandboxAdMeasurementClick_(){this.metricsBrowserProxy_.recordAction("Settings.PrivacySandbox.AdMeasurement.Opened");Router.getInstance().navigateTo(routes.PRIVACY_SANDBOX_AD_MEASUREMENT)}isTopicsEnabled_(){return this.getPref("privacy_sandbox.m1.topics_enabled").value}isFledgeEnabled_(){return this.getPref("privacy_sandbox.m1.fledge_enabled").value}isAdMeasurementEnabled_(){return this.getPref("privacy_sandbox.m1.ad_measurement_enabled").value}getFocusConfig(){const map=new Map;if(routes.PRIVACY_SANDBOX_TOPICS){map.set(routes.PRIVACY_SANDBOX_TOPICS.path,"#privacySandboxTopicsLinkRow")}if(routes.PRIVACY_SANDBOX_FLEDGE){map.set(routes.PRIVACY_SANDBOX_FLEDGE.path,"#privacySandboxFledgeLinkRow")}if(routes.PRIVACY_SANDBOX_AD_MEASUREMENT){map.set(routes.PRIVACY_SANDBOX_AD_MEASUREMENT.path,"#privacySandboxAdMeasurementLinkRow")}return map}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsPrivacySandboxPageElement.is,SettingsPrivacySandboxPageElement);function getTemplate$1B(){return html`<!--_html_template_start_--><style include="cr-shared-style">#currentTopicsSection{align-items:center;display:flex;padding:0 var(--cr-section-padding)}.topics-empty-text{width:100%;display:flex;flex-direction:column;justify-content:center;align-items:center;text-align:center;padding-top:48px;padding-bottom:48px}#currentTopicsSectionWrapper{width:100%}#currentTopicsHeading{color:var(--cr-secondary-text-color);font-size:100%;font-weight:500;margin:0;padding-block-start:var(--cr-section-vertical-padding)}#currentTopicsDescription{padding-block-end:var(--cr-section-vertical-padding)}#disclaimer{padding:0 var(--cr-section-padding);padding-bottom:var(--cr-section-vertical-padding);color:var(--cr-secondary-text-color)}#learnMoreLink{background:none;border:none;color:var(--cr-link-color);cursor:pointer;margin:0;padding:0;text-decoration:underline}.no-topics{padding-block-end:32px;padding-block-start:16px;padding-inline-start:40px}#blockedTopicsDescription{color:var(--cr-secondary-text-color)}.no-blocked-topics{padding-inline-start:60px}#blockedTopicsList{padding:0 var(--cr-section-padding)}.footer{padding:16px var(--cr-section-padding)}a{color:var(--cr-link-color)}#dialog p{margin:0;padding-block-end:16px;padding-block-start:4px}cr-toast{--cr-toast-max-width:80%}</style>

<settings-subpage page-title="$i18n{topicsPageTitle}"
    learn-more-url="$i18n{adPrivacyLearnMoreURL}"
    route-path$="[[routePath]]">
<settings-toggle-button
    id="topicsToggle"
    pref="{{prefs.privacy_sandbox.m1.topics_enabled}}"
    label="$i18n{topicsPageToggleLabel}"
    sub-label="[[adTopicsToggleSubLabel_]]"
    on-settings-boolean-control-change="onToggleChange_">
</settings-toggle-button>
<div id="disclaimer">
  $i18nRaw{topicsPageDisclaimerDesktop}
</div>
<template is="dom-if" if="[[!emptyState_]]" restamp>
  <template is="dom-if" if="[[!isTopicsPrefManaged_(
      prefs.privacy_sandbox.m1.topics_enabled.enforcement)]]" restamp>
    <div id="currentTopicsSection">
      <div id="currentTopicsSectionWrapper" class="hr">
        <h2 id="currentTopicsHeading">$i18n{topicsPageActiveTopicsHeading}</h2>
        <template is="dom-if" if="[[shouldShowAdTopicsContentParity_]]">
          <div id="currentTopicsDescriptionV2" class="cr-secondary-text">
            $i18n{adTopicsPageActiveTopicsDescription}
          </div>
        </template>
        <template is="dom-if" if="[[!shouldShowAdTopicsContentParity_]]">
          <div id="currentTopicsDescription" class="cr-secondary-text">
            $i18n{topicsPageActiveTopicsDescription}
          </div>
        </template>
        <template is="dom-if" if="[[isTopicsEnabledAndLoaded_(
            prefs.privacy_sandbox.m1.topics_enabled.value,
            isTopicsListLoaded_)]]" restamp>
          <div role="region" aria-label=
              "$i18n{topicsPageCurrentTopicsRegionA11yDescription}">
            <template is="dom-repeat" items="[[topicsList_]]">
              <privacy-sandbox-interest-item interest="[[item]]"
                  on-interest-changed="onInterestChanged_">
              </privacy-sandbox-interest-item>
            </template>
          </div>
          <div id="currentTopicsEmptyText"
              class="topics-empty-text"
              hidden="[[!isTopicsListEmpty_(topicsList_.length)]]">
            <span id="currentTopicsDescriptionEmptyTextHeading">
              $i18n{topicsPageCurrentTopicsDescriptionEmptyTextHeading}
            </span>
            <span id="currentTopicsDescriptionEmptyText"
                class="cr-secondary-text">
              $i18n{topicsPageCurrentTopicsDescriptionEmptyText}
            </span>
          </div>
        </template>
        <div id="currentTopicsDescriptionDisabled"
            class="no-topics cr-secondary-text"
            hidden="[[prefs.privacy_sandbox.m1.topics_enabled.value]]">
          $i18n{topicsPageCurrentTopicsDescriptionDisabled}
        </div>
      </div>
    </div>
  </template>
   <cr-expand-button id="blockedTopicsRow" class="cr-row"
      expanded="{{blockedTopicsExpanded_}}">
      $i18n{topicsPageBlockedTopicsHeading}
    <div id="blockedTopicsDescription">
      $i18n{topicsPageBlockedTopicsDescription}
    </div>
  </cr-expand-button>
  <cr-collapse opened="[[blockedTopicsExpanded_]]">
    <div id="blockedTopicsEmptyText"
        class="topics-empty-text"
        hidden="[[!isBlockedTopicsListEmpty_(blockedTopicsList_.length)]]">
      <span id="blockedTopicsDescriptionEmptyTextHeading">
          $i18n{topicsPageBlockedTopicsDescriptionEmptyTextHeading}
      </span>
      <span id="blockedTopicsDescriptionEmptyText"
          class="cr-secondary-text">
        $i18n{topicsPageBlockedTopicsDescriptionEmptyText}
      </span>
    </div>
    <div id="blockedTopicsList" role="region"
        aria-label="$i18n{topicsPageBlockedTopicsRegionA11yDescription}">
      <template is="dom-repeat" items="[[blockedTopicsList_]]">
        <privacy-sandbox-interest-item interest="[[item]]"
            on-interest-changed="onInterestChanged_">
        </privacy-sandbox-interest-item>
      </template>
    </div>
  </cr-collapse>
  <div id="manageTopicsSection" class="hr">
      <cr-link-row id="privacySandboxManageTopicsLinkRow"
          label="$i18n{manageTopicsHeading}"
          sub-label="$i18n{manageTopicsDescription}"
          on-click="onPrivacySandboxManageTopicsClick_">
      </cr-link-row>
  </div>
</template>
<div id="footerV2" class="cr-secondary-text hr footer">
  $i18nRaw{adTopicsPageFooterV2Desktop}
</div>
<template is="dom-if" if="[[shouldShowAdTopicsContentParity_]]">
  <div id="footerDisclaimerV2" class="cr-secondary-text footer">
    $i18nRaw{adTopicsPageDisclaimerV2Desktop}
  </div>
</template>
<template is="dom-if" if="[[!shouldShowAdTopicsContentParity_]]">
  <div id="footerDisclaimer" class="cr-secondary-text footer">
    $i18nRaw{adTopicsPageDisclaimer}
  </div>
</template>
<cr-toast id="unblockTopicToast" duration="10000">
  <div id="unblockTopicToastBody">$i18n{unblockTopicToastBody}</div>
  <cr-button id="closeToastButton" on-click="onHideToastClick_">
    $i18n{unblockTopicToastButtonText}
  </cr-button>
</cr-toast>
<template is="dom-if" if="[[shouldShowBlockTopicDialog_]]" restamp>
  <settings-simple-confirmation-dialog id="blockTopicDialog"
      title-text="[[blockTopicDialogTitle_]]"
      body-text="[[blockTopicDialogBody_]]"
      confirm-text="$i18n{topicsPageBlockTopic}"
      on-close="onBlockTopicDialogClose_">
  </settings-simple-confirmation-dialog>
</template>
</settings-subpage>
<!--_html_template_end_-->`}const SettingsPrivacySandboxTopicsSubpageElementBase=SettingsViewMixin(RouteObserverMixin(I18nMixin(PrefsMixin(PolymerElement))));class SettingsPrivacySandboxTopicsSubpageElement extends SettingsPrivacySandboxTopicsSubpageElementBase{static get is(){return"settings-privacy-sandbox-topics-subpage"}static get template(){return getTemplate$1B()}static get properties(){return{topicsList_:{type:Array,value(){return[]}},blockedTopicsList_:{type:Array,value(){return[]}},isTopicsListLoaded_:{type:Boolean,value:false},blockedTopicsExpanded_:{type:Boolean,value:false,observer:"onBlockedTopicsExpanded_"},blockTopicDialogTitle_:{type:String,value:""},blockTopicDialogBody_:{type:String,value:""},shouldShowBlockTopicDialog_:{type:Boolean,value:false},emptyState_:{type:Boolean,computed:"computeEmptyState_("+"prefs.privacy_sandbox.m1.topics_enabled.value)"},shouldShowAdTopicsContentParity_:{type:Boolean,value:false},adTopicsToggleSubLabel_:{type:String,computed:"computeAdTopicsToggleSubLabel_(shouldShowAdTopicsContentParity_)"}}}privacySandboxBrowserProxy_=PrivacySandboxBrowserProxyImpl.getInstance();metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();currentChildTopics_;currentInterest_;ready(){super.ready();this.privacySandboxBrowserProxy_.getTopicsState().then((state=>this.onTopicsStateChanged_(state)));this.privacySandboxBrowserProxy_.shouldShowPrivacySandboxAdTopicsContentParity().then((shouldShow=>{this.shouldShowAdTopicsContentParity_=shouldShow}))}computeEmptyState_(){return!this.getPref("privacy_sandbox.m1.topics_enabled").value}currentRouteChanged(newRoute,oldRoute){super.currentRouteChanged(newRoute,oldRoute);if(newRoute===routes.PRIVACY_SANDBOX_TOPICS){this.privacySandboxBrowserProxy_.getTopicsState().then((state=>this.onTopicsStateChanged_(state)))}}isTopicsPrefManaged_(){const topicsEnabledPref=this.getPref("privacy_sandbox.m1.topics_enabled");if(topicsEnabledPref.enforcement===chrome.settingsPrivate.Enforcement.ENFORCED){assert(!topicsEnabledPref.value);return true}return false}onTopicsStateChanged_(state){this.topicsList_=state.topTopics.map((topic=>({topic:topic,removed:false})));this.blockedTopicsList_=state.blockedTopics.map((topic=>({topic:topic,removed:true})));this.isTopicsListLoaded_=true}isTopicsEnabledAndLoaded_(){return this.getPref("privacy_sandbox.m1.topics_enabled").value&&this.isTopicsListLoaded_}isTopicsListEmpty_(){return this.topicsList_.length===0}isBlockedTopicsListEmpty_(){return this.blockedTopicsList_.length===0}getBlockedTopicsDescriptionClass_(){const defaultClass="cr-row continuation cr-secondary-text";return this.blockedTopicsList_.length===0?`${defaultClass} no-blocked-topics`:defaultClass}onToggleChange_(e){const target=e.target;this.metricsBrowserProxy_.recordAction(target.checked?"Settings.PrivacySandbox.Topics.Enabled":"Settings.PrivacySandbox.Topics.Disabled");this.privacySandboxBrowserProxy_.topicsToggleChanged(target.checked);this.topicsList_=[]}onBlockTopicDialogClose_(){const dialog=this.shadowRoot.querySelector("settings-simple-confirmation-dialog");assert(dialog);assert(this.currentInterest_);if(dialog.wasConfirmed()){this.updateTopicsStateForSelectedTopic_(this.currentInterest_)}this.blockTopicDialogBody_="";this.blockTopicDialogTitle_="";this.currentChildTopics_=[];this.shouldShowBlockTopicDialog_=false;this.currentInterest_=undefined}updateTopicsStateForSelectedTopic_(currentSelectedInterest){this.privacySandboxBrowserProxy_.setTopicAllowed(currentSelectedInterest.topic,currentSelectedInterest.removed);this.privacySandboxBrowserProxy_.getTopicsState().then((state=>this.onTopicsStateChanged_(state)));this.metricsBrowserProxy_.recordAction(currentSelectedInterest.removed?"Settings.PrivacySandbox.Topics.TopicAdded":"Settings.PrivacySandbox.Topics.TopicRemoved");afterNextRender(this,(()=>{if(!this.shadowRoot.activeElement){this.shadowRoot.querySelector("#blockedTopicsRow")?.focus()}}))}async onInterestChanged_(e){this.currentInterest_=e.detail;assert(!this.currentInterest_.site);assert(this.currentInterest_.topic);assert(this.currentInterest_.topic.displayString);if(this.currentInterest_.removed){const toast=this.shadowRoot.querySelector("cr-toast");assert(toast);toast.show();this.updateTopicsStateForSelectedTopic_(this.currentInterest_);return}this.currentChildTopics_=await this.privacySandboxBrowserProxy_.getChildTopicsCurrentlyAssigned(this.currentInterest_.topic);if(this.currentChildTopics_.length!==0){this.blockTopicDialogTitle_=loadTimeData.getStringF("manageTopicsDialogTitle",this.currentInterest_.topic.displayString);this.blockTopicDialogBody_=loadTimeData.getStringF("manageTopicsDialogBody",this.currentInterest_.topic.displayString);this.shouldShowBlockTopicDialog_=true;return}this.updateTopicsStateForSelectedTopic_(this.currentInterest_);this.blockedTopicsExpanded_=true}onBlockedTopicsExpanded_(){if(this.blockedTopicsExpanded_){this.metricsBrowserProxy_.recordAction("Settings.PrivacySandbox.Topics.BlockedTopicsOpened")}}onPrivacySandboxManageTopicsClick_(){Router.getInstance().navigateTo(routes.PRIVACY_SANDBOX_MANAGE_TOPICS)}onHideToastClick_(){const toast=this.shadowRoot.querySelector("cr-toast");assert(toast);toast.hide()}onPrivacyPolicyLinkClicked_(){this.metricsBrowserProxy_.recordAction("Settings.PrivacySandbox.AdTopics.PrivacyPolicyLinkClicked")}computeAdTopicsToggleSubLabel_(){return this.i18n(this.shouldShowAdTopicsContentParity_?"adTopicsPageToggleSubLabel":"topicsPageToggleSubLabel")}getFocusConfig(){return new Map([[routes.PRIVACY_SANDBOX_MANAGE_TOPICS.path,"#privacySandboxManageTopicsLinkRow"]])}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsPrivacySandboxTopicsSubpageElement.is,SettingsPrivacySandboxTopicsSubpageElement);function getTemplate$1A(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared">:host{flex-direction:column;display:flex;flex:1;padding:14px 16px}#header{font-weight:500;font-size:0.75rem;user-select:none}#subheader{font-size:0.6875rem;line-height:18px;user-select:none}cr-icon{height:var(--cr-icon-size);margin-bottom:10px;width:var(--cr-icon-size)}cr-icon.green{--iron-icon-fill-color:var(--google-green-700)}cr-icon.yellow{--iron-icon-fill-color:var(--google-yellow-700)}cr-icon.red{--iron-icon-fill-color:var(--google-red-600)}@media (prefers-color-scheme:dark){cr-icon.green{--iron-icon-fill-color:var(--google-green-300)}cr-icon.yellow{--iron-icon-fill-color:var(--google-yellow-300)}cr-icon.red{--iron-icon-fill-color:var(--google-red-300)}}</style>

<cr-icon id="icon" icon$="[[getStatusIcon(data.state)]]"
    class$="[[getColorClass(data.state)]]">
</cr-icon>
<div id="header">[[data.header]]</div>
<div id="subheader" class="cr-secondary-text">[[data.subheader]]</div>
<!--_html_template_end_-->`}class SettingsSafetyHubCardElement extends PolymerElement{static get is(){return"settings-safety-hub-card"}static get template(){return getTemplate$1A()}static get properties(){return{data:Object}}getStatusIcon(state){switch(state){case CardState.WARNING:case CardState.WEAK:return"cr:error";case CardState.INFO:return"cr:info";case CardState.SAFE:return"cr:check-circle";default:assertNotReached()}}getColorClass(state){switch(state){case CardState.WARNING:return"red";case CardState.WEAK:return"yellow";case CardState.INFO:return"grey";case CardState.SAFE:return"green";default:assertNotReached()}}}customElements.define(SettingsSafetyHubCardElement.is,SettingsSafetyHubCardElement);function getTemplate$1z(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared">:host{display:block}.icon-blue{fill:var(--google-blue-600)}@media (prefers-color-scheme:dark){.icon-blue{fill:var(--google-blue-300)}}</style>

<settings-safety-hub-module header="[[headerString_]]">
  <div slot="button-container">
    <cr-button id="reviewButton" on-click="onButtonClick_">
      $i18n{safetyHubReview}
      <cr-icon icon="cr:open-in-new" class="icon-blue" slot="suffix-icon">
      </cr-icon>
    </cr-button>
  </div>
</settings-safety-hub-module>
<!--_html_template_end_-->`}const SettingsSafetyHubExtensionsModuleElementBase=WebUiListenerMixin(PolymerElement);class SettingsSafetyHubExtensionsModuleElement extends SettingsSafetyHubExtensionsModuleElementBase{static get is(){return"settings-safety-hub-extensions-module"}static get template(){return getTemplate$1z()}static get properties(){return{headerString_:String}}async connectedCallback(){super.connectedCallback();this.addWebUiListener(SafetyHubEvent.EXTENSIONS_CHANGED,(num=>this.onSafetyCheckExtensionsChanged_(num)));const numExtensions=await SafetyHubBrowserProxyImpl.getInstance().getNumberOfExtensionsThatNeedReview();this.onSafetyCheckExtensionsChanged_(numExtensions)}async onSafetyCheckExtensionsChanged_(numExtensions){this.headerString_=await PluralStringProxyImpl.getInstance().getPluralString("safetyHubExtensionsReviewLabel",numExtensions)}onButtonClick_(){MetricsBrowserProxyImpl.getInstance().recordAction("Settings.SafetyCheck.ReviewExtensionsThroughSafetyCheck");OpenWindowProxyImpl.getInstance().openUrl("chrome://extensions")}}customElements.define(SettingsSafetyHubExtensionsModuleElement.is,SettingsSafetyHubExtensionsModuleElement);function getTemplate$1y(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared">:host{display:block}cr-tooltip{--paper-tooltip-min-width:max-content}</style>
<settings-safety-hub-module
    id="module"
    animated
    on-sh-module-item-button-click="onBlockClick_"
    on-sh-module-more-action-button-click="onMoreActionClick_"
    header="[[headerString_]]"
    subheader="[[subheaderString_]]"
    button-aria-label-id="safetyHubNotificationPermissionReviewDontAllowAriaLabel"
    button-icon="cr20:block"
    button-tooltip-text="$i18n{safetyHubNotificationPermissionReviewDontAllowLabel}"
    more-action-visible
    more-button-aria-label-id="safetyHubNotificationPermissionReviewMoreActionsAriaLabel"
    sites="[[sites_]]">
  <div slot="button-container">
    <cr-button id="blockAllButton" on-click="onBlockAllClick_"
        hidden$="[[shouldShowCompletionInfo_]]">
      $i18n{safetyHubNotificationPermissionReviewBlockAllLabel}
    </cr-button>
    <cr-icon-button id="moreActionButton" class="icon-more-vert"
        on-click="onHeaderMoreActionClick_"
        hidden$="[[shouldShowCompletionInfo_]]" title="$i18n{moreActions}">
    </cr-icon-button>
    <cr-icon-button id="bulkUndoButton" iron-icon="settings20:undo"
        on-click="onUndoClick_" hidden$="[[!shouldShowCompletionInfo_]]"
        on-focus="showUndoTooltip_" on-mouseenter="showUndoTooltip_"
        aria-label="$i18n{safetyHubNotificationPermissionReviewUndo}">
    </cr-icon-button>
  </div>
</settings-safety-hub-module>
<cr-action-menu id="actionMenu" role-description="$i18n{menu}">
  <button class="dropdown-item" id="ignore" on-click="onIgnoreClick_"
      aria-label$="[[getIgnoreAriaLabelForOrigins(lastOrigins_)]]">
    $i18n{safetyHubNotificationPermissionReviewIgnoreLabel}
  </button>
  <button class="dropdown-item" id="reset" on-click="onResetClick_"
      aria-label$="[[getResetAriaLabelForOrigins(lastOrigins_)]]">
    $i18n{safetyHubNotificationPermissionReviewResetLabel}
  </button>
</cr-action-menu>
<cr-action-menu id="headerActionMenu" role-description="$i18n{menu}">
  <button class="dropdown-item" id="goToSettings"
      on-click="onGoToSettingsClick_">
    $i18n{safetyHubGoNotificationSettingsItem}
  </button>
</cr-action-menu>
<cr-toast id="undoToast" duration="5000">
  <div id="undoNotification">[[toastText_]]</div>
  <cr-button id="toastUndoButton" on-click="onUndoClick_"
      aria-label="$i18n{safetyHubNotificationPermissionReviewUndo}">
    $i18n{safetyHubNotificationPermissionReviewUndo}
  </cr-button>
</cr-toast>
<cr-tooltip fit-to-visible-bounds manual-mode position="top" offset="3">
  $i18n{safetyHubNotificationPermissionReviewUndo}
</cr-tooltip>
<!--_html_template_end_-->`}var Actions;(function(Actions){Actions["BLOCK"]="block";Actions["BLOCK_ALL"]="block_all";Actions["IGNORE"]="ignore";Actions["RESET"]="reset"})(Actions||(Actions={}));const SettingsSafetyHubNotificationPermissionsModuleElementBase=TooltipMixin(WebUiListenerMixin(RouteObserverMixin(BaseMixin(SiteSettingsMixin(I18nMixin(PolymerElement))))));class SettingsSafetyHubNotificationPermissionsModuleElement extends SettingsSafetyHubNotificationPermissionsModuleElementBase{static get is(){return"settings-safety-hub-notification-permissions-module"}static get template(){return getTemplate$1y()}static get properties(){return{headerString_:String,subheaderString_:String,toastText_:String,lastUserAction_:String,lastOrigins_:{type:Array,value:()=>[]},sites_:{type:Array,value:null},shouldShowCompletionInfo_:{type:Boolean,computed:"computeShouldShowCompletionInfo_(sites_.*)"}}}static get observers(){return["updateUndoNotificationText_(lastUserAction_, lastOrigins_)","onSitesChanged_(sites_, shouldShowCompletionInfo_)"]}renderedOrigins_=[];eventTracker_=new EventTracker;browserProxy_=SafetyHubBrowserProxyImpl.getInstance();metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();async connectedCallback(){this.addWebUiListener(SafetyHubEvent.NOTIFICATION_PERMISSIONS_MAYBE_CHANGED,(sites=>this.onNotificationPermissionListChanged_(sites)));const sites=await this.browserProxy_.getNotificationPermissionReview();this.onNotificationPermissionListChanged_(sites);super.connectedCallback()}disconnectedCallback(){super.disconnectedCallback();this.eventTracker_.removeAll()}currentRouteChanged(currentRoute){if(currentRoute!==routes.SAFETY_HUB){this.eventTracker_.removeAll();return}if(this.sites_!==null){this.metricsBrowserProxy_.recordSafetyHubNotificationPermissionsModuleListCountHistogram(this.sites_.length)}this.eventTracker_.add(document,"keydown",(e=>this.onKeyDown_(e)))}onNotificationPermissionListChanged_(sites){this.sites_=sites.map((site=>({...site,detail:site.notificationInfoString})))}setHeaderToCompletionState_(){assert(this.toastText_);this.headerString_=this.toastText_;this.subheaderString_=""}async onSitesChanged_(){if(this.sites_===null){return}this.$.module.animateShow(this.sites_.map((site=>site.origin)).filter((origin=>!this.renderedOrigins_.includes(origin))));this.renderedOrigins_=this.sites_.map((site=>site.origin));if(this.shouldShowCompletionInfo_){this.setHeaderToCompletionState_();return}this.headerString_=await PluralStringProxyImpl.getInstance().getPluralString("safetyHubNotificationPermissionsPrimaryLabel",this.sites_.length);this.subheaderString_=await PluralStringProxyImpl.getInstance().getPluralString("safetyHubNotificationPermissionsSecondaryLabel",this.sites_.length)}resetValues_(e){e.stopPropagation();this.$.undoToast.hide();this.lastOrigins_=[];this.lastUserAction_=null}setValues_(origins,action){assert(!this.lastUserAction_);assert(!this.lastOrigins_.length);this.lastOrigins_=origins;this.lastUserAction_=action}onBlockClick_(e){this.resetValues_(e);this.setValues_([e.detail.origin],Actions.BLOCK);this.showUndoToast_();this.$.module.animateHide(e.detail.origin,this.browserProxy_.blockNotificationPermissionForOrigins.bind(this.browserProxy_,this.lastOrigins_));this.browserProxy_.recordSafetyHubInteraction();this.metricsBrowserProxy_.recordSafetyHubNotificationPermissionsModuleInteractionsHistogram(SafetyCheckNotificationsModuleInteractions.BLOCK)}onMoreActionClick_(e){this.resetValues_(e);this.lastOrigins_=[e.detail.origin];this.$.actionMenu.showAt(e.detail.target)}onIgnoreClick_(e){const tempLastOrigins=this.lastOrigins_;this.resetValues_(e);this.setValues_(tempLastOrigins,Actions.IGNORE);this.showUndoToast_();this.$.actionMenu.close();this.$.module.animateHide(this.lastOrigins_[0],this.browserProxy_.ignoreNotificationPermissionForOrigins.bind(this.browserProxy_,this.lastOrigins_));this.browserProxy_.recordSafetyHubInteraction();this.metricsBrowserProxy_.recordSafetyHubNotificationPermissionsModuleInteractionsHistogram(SafetyCheckNotificationsModuleInteractions.IGNORE)}onResetClick_(e){const tempLastOrigins=this.lastOrigins_;this.resetValues_(e);this.setValues_(tempLastOrigins,Actions.RESET);this.showUndoToast_();this.$.actionMenu.close();this.$.module.animateHide(this.lastOrigins_[0],this.browserProxy_.resetNotificationPermissionForOrigins.bind(this.browserProxy_,this.lastOrigins_));this.browserProxy_.recordSafetyHubInteraction();this.metricsBrowserProxy_.recordSafetyHubNotificationPermissionsModuleInteractionsHistogram(SafetyCheckNotificationsModuleInteractions.RESET)}onBlockAllClick_(e){this.resetValues_(e);assert(this.sites_);this.setValues_(this.sites_.map((site=>site.origin)),Actions.BLOCK_ALL);this.$.module.animateHide(null,this.browserProxy_.blockNotificationPermissionForOrigins.bind(this.browserProxy_,this.lastOrigins_));this.browserProxy_.recordSafetyHubInteraction();this.metricsBrowserProxy_.recordSafetyHubNotificationPermissionsModuleInteractionsHistogram(SafetyCheckNotificationsModuleInteractions.BLOCK_ALL)}onUndoClick_(e){e.stopPropagation();this.undoLastAction_()}onHeaderMoreActionClick_(e){e.stopPropagation();this.$.headerActionMenu.showAt(e.target)}onGoToSettingsClick_(e){e.stopPropagation();this.$.headerActionMenu.close();Router.getInstance().navigateTo(routes.SITE_SETTINGS_NOTIFICATIONS,undefined,true);this.metricsBrowserProxy_.recordSafetyHubNotificationPermissionsModuleInteractionsHistogram(SafetyCheckNotificationsModuleInteractions.GO_TO_SETTINGS)}async updateUndoNotificationText_(){if(!this.lastUserAction_||this.lastOrigins_.length===0){return}switch(this.lastUserAction_){case Actions.BLOCK:this.toastText_=this.i18n("safetyHubNotificationPermissionReviewBlockedToastLabel",this.lastOrigins_[0]);break;case Actions.BLOCK_ALL:this.toastText_=await PluralStringProxyImpl.getInstance().getPluralString("safetyHubNotificationPermissionReviewBlockAllToastLabel",this.lastOrigins_.length);break;case Actions.IGNORE:this.toastText_=this.i18n("safetyHubNotificationPermissionReviewIgnoredToastLabel",this.lastOrigins_[0]);break;case Actions.RESET:this.toastText_=this.i18n("safetyHubNotificationPermissionReviewResetToastLabel",this.lastOrigins_[0]);break;default:assertNotReached()}}showUndoToast_(){if(this.sites_.length>1){this.$.undoToast.show()}}undoLastAction_(){switch(this.lastUserAction_){case Actions.BLOCK:this.browserProxy_.allowNotificationPermissionForOrigins(this.lastOrigins_);this.metricsBrowserProxy_.recordSafetyHubNotificationPermissionsModuleInteractionsHistogram(SafetyCheckNotificationsModuleInteractions.UNDO_BLOCK);break;case Actions.BLOCK_ALL:this.browserProxy_.allowNotificationPermissionForOrigins(this.lastOrigins_);this.metricsBrowserProxy_.recordSafetyHubNotificationPermissionsModuleInteractionsHistogram(SafetyCheckNotificationsModuleInteractions.UNDO_BLOCK_ALL);break;case Actions.RESET:this.browserProxy_.allowNotificationPermissionForOrigins(this.lastOrigins_);this.metricsBrowserProxy_.recordSafetyHubNotificationPermissionsModuleInteractionsHistogram(SafetyCheckNotificationsModuleInteractions.UNDO_RESET);break;case Actions.IGNORE:this.browserProxy_.undoIgnoreNotificationPermissionForOrigins(this.lastOrigins_);this.metricsBrowserProxy_.recordSafetyHubNotificationPermissionsModuleInteractionsHistogram(SafetyCheckNotificationsModuleInteractions.UNDO_IGNORE);break;default:assertNotReached()}this.$.undoToast.hide()}onKeyDown_(e){if(!this.$.undoToast.open){return}if(isUndoKeyboardEvent(e)){this.undoLastAction_();e.stopPropagation()}}computeShouldShowCompletionInfo_(){return this.sites_!==null&&this.sites_.length===0}getIgnoreAriaLabelForOrigins(origins){if(origins.length!==1){return""}return this.i18n("safetyHubNotificationPermissionReviewIgnoreAriaLabel",origins[0])}getResetAriaLabelForOrigins(origins){if(origins.length!==1){return""}return this.i18n("safetyHubNotificationPermissionReviewResetAriaLabel",origins[0])}showUndoTooltip_(e){e.stopPropagation();const tooltip=this.shadowRoot.querySelector("cr-tooltip");assert(tooltip);this.showTooltipAtTarget(tooltip,e.target)}}customElements.define(SettingsSafetyHubNotificationPermissionsModuleElement.is,SettingsSafetyHubNotificationPermissionsModuleElement);function getTemplate$1x(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared">:host{display:block}cr-tooltip{--paper-tooltip-min-width:max-content}</style>
<settings-safety-hub-module
    id="module"
    animated
    on-sh-module-item-button-click="onAllowAgainClick_"
    header="[[headerString_]]"
    subheader="[[subheaderString_]]"
    button-aria-label-id="safetyHubUnusedSitePermissionsAllowAgainAriaLabel"
    button-icon="settings20:undo"
    button-tooltip-text="$i18n{safetyHubUnusedSitePermissionsAllowAgainLabel}"
    sites="[[sites_]]">
  <div slot="button-container">
    <cr-button id="gotItButton" on-click="onGotItClick_"
        hidden$="[[shouldShowCompletionInfo_]]"
        aria-description$="[[subheaderString_]]">
      $i18n{safetyHubUnusedSitePermissionsGotItLabel}
    </cr-button>
    <cr-icon-button id="moreActionButton" class="icon-more-vert"
        on-click="onMoreActionClick_" hidden$="[[shouldShowCompletionInfo_]]"
        title="$i18n{moreActions}"
        aria-description$="[[headerString_]]">
    </cr-icon-button>
    <cr-icon-button id="bulkUndoButton" iron-icon="settings20:undo"
        on-click="onUndoClick_" hidden$="[[!shouldShowCompletionInfo_]]"
        on-focus="showUndoTooltip_" on-mouseenter="showUndoTooltip_"
        aria-label="$i18n{safetyHubUnusedSitePermissionsUndoLabel}"
        aria-description$="[[headerString_]]">
    </cr-icon-button>
  </div>
</settings-safety-hub-module>
<cr-toast id="undoToast" duration="5000">
  <div>[[toastText_]]</div>
  <cr-button id="toastUndoButton" on-click="onUndoClick_">
    $i18n{safetyHubUnusedSitePermissionsUndoLabel}
  </cr-button>
</cr-toast>
<cr-action-menu id="headerActionMenu" role-description="$i18n{menu}">
  <button class="dropdown-item" id="goToSettings"
      on-click="onGoToSettingsClick_">
    $i18n{safetyHubGoSiteSettingsItem}
  </button>
</cr-action-menu>
<cr-tooltip fit-to-visible-bounds manual-mode position="top" offset="3">
  $i18n{safetyHubUnusedSitePermissionsUndoLabel}
</cr-tooltip>
<!--_html_template_end_-->`}var Action;(function(Action){Action[Action["ALLOW_AGAIN"]=0]="ALLOW_AGAIN";Action[Action["GOT_IT"]=1]="GOT_IT"})(Action||(Action={}));const SettingsSafetyHubUnusedSitePermissionsModuleElementBase=TooltipMixin(I18nMixin(RouteObserverMixin(WebUiListenerMixin(SiteSettingsMixin(PolymerElement)))));function doNothing(){}class SettingsSafetyHubUnusedSitePermissionsModuleElement extends SettingsSafetyHubUnusedSitePermissionsModuleElementBase{static get is(){return"settings-safety-hub-unused-site-permissions-module"}static get template(){return getTemplate$1x()}static get properties(){return{headerString_:String,subheaderString_:String,lastUnusedSitePermissionsAllowedAgain_:{type:Object,value:null},lastUnusedSitePermissionsListAcknowledged_:{type:Array,value:null},renderedOrigins_:{type:Array,value:[]},lastUserAction_:{type:Object,value:null},sites_:{type:Array,value:null,observer:"onSitesChanged_"},toastText_:String,shouldShowCompletionInfo_:{type:Boolean,computed:"computeShouldShowCompletionInfo_(sites_.*)"}}}pendingFocusCallback_=doNothing;eventTracker_=new EventTracker;browserProxy_=SafetyHubBrowserProxyImpl.getInstance();metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();async connectedCallback(){this.addWebUiListener(SafetyHubEvent.UNUSED_PERMISSIONS_MAYBE_CHANGED,(sites=>this.onUnusedSitePermissionListChanged_(sites)));const sites=await this.browserProxy_.getRevokedUnusedSitePermissionsList();this.onUnusedSitePermissionListChanged_(sites);super.connectedCallback()}disconnectedCallback(){super.disconnectedCallback();this.eventTracker_.removeAll()}currentRouteChanged(currentRoute){if(currentRoute!==routes.SAFETY_HUB){this.eventTracker_.removeAll();return}if(this.sites_!==null){this.metricsBrowserProxy_.recordSafetyHubUnusedSitePermissionsModuleListCountHistogram(this.sites_.length)}this.eventTracker_.add(document,"keydown",(e=>this.onKeyDown_(e)))}getPermissionsText_(revocationType,permissions){assert(permissions.length>0,"There is no permission for the user to review.");const permissionsI18n=permissions.map((permission=>{const localizationString=getLocalizationStringForContentType(permission);return localizationString?this.i18n(localizationString):""}));if(revocationType===PermissionsRevocationType.ABUSIVE_NOTIFICATION_PERMISSIONS||revocationType===PermissionsRevocationType.UNUSED_PERMISSIONS_AND_ABUSIVE_NOTIFICATIONS){return this.i18n("safetyHubAbusiveNotificationPermissionsSettingSublabel")}switch(permissionsI18n.length){case 1:return this.i18n("safetyHubUnusedSitePermissionsRemovedOnePermissionLabel",...permissionsI18n);case 2:return this.i18n("safetyHubUnusedSitePermissionsRemovedTwoPermissionsLabel",...permissionsI18n);case 3:return this.i18n("safetyHubUnusedSitePermissionsRemovedThreePermissionsLabel",...permissionsI18n);default:return this.i18n("safetyHubUnusedSitePermissionsRemovedFourOrMorePermissionsLabel",permissionsI18n[0],permissionsI18n[1],permissionsI18n.length-2)}}resetValues(event){event.stopPropagation();this.$.undoToast.hide()}onAllowAgainClick_(event){this.resetValues(event);const item=event.detail;this.lastUserAction_=Action.ALLOW_AGAIN;this.lastUnusedSitePermissionsAllowedAgain_=item;this.toastText_=this.i18n("safetyHubUnusedSitePermissionsToastLabel",item.origin);if(this.sites_.length>1){this.$.undoToast.show().then((()=>{this.$.toastUndoButton.focus()}))}this.$.module.animateHide(item.origin,this.browserProxy_.allowPermissionsAgainForUnusedSite.bind(this.browserProxy_,item.origin));this.browserProxy_.recordSafetyHubInteraction();this.metricsBrowserProxy_.recordSafetyHubUnusedSitePermissionsModuleInteractionsHistogram(SafetyCheckUnusedSitePermissionsModuleInteractions.ALLOW_AGAIN);if(this.doesSiteListIncludeAbusiveNotifications([item])){this.metricsBrowserProxy_.recordSafetyHubAbusiveNotificationPermissionRevocationInteractionsHistogram(SafetyCheckUnusedSitePermissionsModuleInteractions.ALLOW_AGAIN)}}async onGotItClick_(e){this.resetValues(e);assert(this.sites_!==null);this.lastUserAction_=Action.GOT_IT;this.lastUnusedSitePermissionsListAcknowledged_=this.sites_;this.toastText_=await PluralStringProxyImpl.getInstance().getPluralString("safetyHubUnusedSitePermissionsToastBulkLabel",this.sites_.length);this.$.module.animateHide(null,this.browserProxy_.acknowledgeRevokedUnusedSitePermissionsList.bind(this.browserProxy_));this.browserProxy_.recordSafetyHubInteraction();this.metricsBrowserProxy_.recordSafetyHubUnusedSitePermissionsModuleInteractionsHistogram(SafetyCheckUnusedSitePermissionsModuleInteractions.ACKNOWLEDGE_ALL);if(this.doesSiteListIncludeAbusiveNotifications(this.sites_)){this.metricsBrowserProxy_.recordSafetyHubAbusiveNotificationPermissionRevocationInteractionsHistogram(SafetyCheckUnusedSitePermissionsModuleInteractions.ACKNOWLEDGE_ALL)}}onMoreActionClick_(e){e.stopPropagation();this.$.headerActionMenu.showAt(e.target)}onGoToSettingsClick_(e){e.stopPropagation();this.$.headerActionMenu.close();Router.getInstance().navigateTo(routes.SITE_SETTINGS,undefined,true);this.metricsBrowserProxy_.recordSafetyHubUnusedSitePermissionsModuleInteractionsHistogram(SafetyCheckUnusedSitePermissionsModuleInteractions.GO_TO_SETTINGS);if(this.sites_&&this.sites_.length>0&&this.doesSiteListIncludeAbusiveNotifications(this.sites_)){this.metricsBrowserProxy_.recordSafetyHubAbusiveNotificationPermissionRevocationInteractionsHistogram(SafetyCheckUnusedSitePermissionsModuleInteractions.GO_TO_SETTINGS)}}onUnusedSitePermissionListChanged_(sites){this.sites_=sites.map((site=>({...site,detail:this.getPermissionsText_(site.revocationType,site.permissions)})))}setHeaderToCompletionState_(){assert(this.headerString_);this.headerString_=this.toastText_;this.subheaderString_="";this.$.bulkUndoButton.focus()}async onSitesChanged_(){if(this.sites_===null){return}const callback=this.pendingFocusCallback_;this.pendingFocusCallback_=doNothing;this.$.module.animateShow(this.sites_.map((site=>site.origin)).filter((origin=>!this.renderedOrigins_.includes(origin))),callback);this.renderedOrigins_=this.sites_.map((site=>site.origin));if(this.shouldShowCompletionInfo_){this.setHeaderToCompletionState_();return}this.headerString_=await PluralStringProxyImpl.getInstance().getPluralString("safetyHubUnusedSitePermissionsPrimaryLabel",this.sites_.length);this.subheaderString_=await PluralStringProxyImpl.getInstance().getPluralString("safetyHubRevokedPermissionsSecondaryLabel",this.sites_.length)}onUndoClick_(e){e.stopPropagation();this.undoLastAction_()}computeShouldShowCompletionInfo_(){return this.sites_!==null&&this.sites_.length===0}undoLastAction_(){switch(this.lastUserAction_){case Action.ALLOW_AGAIN:assert(this.lastUnusedSitePermissionsAllowedAgain_!==null);this.browserProxy_.undoAllowPermissionsAgainForUnusedSite(this.lastUnusedSitePermissionsAllowedAgain_);if(this.doesSiteListIncludeAbusiveNotifications([this.lastUnusedSitePermissionsAllowedAgain_])){this.metricsBrowserProxy_.recordSafetyHubAbusiveNotificationPermissionRevocationInteractionsHistogram(SafetyCheckUnusedSitePermissionsModuleInteractions.UNDO_ALLOW_AGAIN)}const originToFocus=this.lastUnusedSitePermissionsAllowedAgain_.origin;this.pendingFocusCallback_=()=>{this.$.module.focusOriginMainButton(originToFocus)};this.lastUnusedSitePermissionsAllowedAgain_=null;this.metricsBrowserProxy_.recordSafetyHubUnusedSitePermissionsModuleInteractionsHistogram(SafetyCheckUnusedSitePermissionsModuleInteractions.UNDO_ALLOW_AGAIN);break;case Action.GOT_IT:assert(this.lastUnusedSitePermissionsListAcknowledged_!==null);this.browserProxy_.undoAcknowledgeRevokedUnusedSitePermissionsList(this.lastUnusedSitePermissionsListAcknowledged_);if(this.doesSiteListIncludeAbusiveNotifications(this.lastUnusedSitePermissionsListAcknowledged_)){this.metricsBrowserProxy_.recordSafetyHubAbusiveNotificationPermissionRevocationInteractionsHistogram(SafetyCheckUnusedSitePermissionsModuleInteractions.UNDO_ACKNOWLEDGE_ALL)}this.lastUnusedSitePermissionsListAcknowledged_=null;this.metricsBrowserProxy_.recordSafetyHubUnusedSitePermissionsModuleInteractionsHistogram(SafetyCheckUnusedSitePermissionsModuleInteractions.UNDO_ACKNOWLEDGE_ALL);this.pendingFocusCallback_=()=>{this.$.gotItButton.focus()};break;default:assertNotReached()}this.lastUserAction_=null;this.$.undoToast.hide()}onKeyDown_(e){if(!this.$.undoToast.open){return}if(isUndoKeyboardEvent(e)){this.undoLastAction_();e.stopPropagation()}}showUndoTooltip_(e){e.stopPropagation();const tooltip=this.shadowRoot.querySelector("cr-tooltip");assert(tooltip);this.showTooltipAtTarget(tooltip,e.target)}doesSiteListIncludeAbusiveNotifications(sites){return sites.map((site=>site.revocationType)).filter((type=>type===PermissionsRevocationType.ABUSIVE_NOTIFICATION_PERMISSIONS||type===PermissionsRevocationType.UNUSED_PERMISSIONS_AND_ABUSIVE_NOTIFICATIONS)).length>0}}customElements.define(SettingsSafetyHubUnusedSitePermissionsModuleElement.is,SettingsSafetyHubUnusedSitePermissionsModuleElement);function getTemplate$1w(){return html`<!--_html_template_start_--><style include="cr-shared-style">:host{display:flex;flex-direction:column}.box{background-color:var(--cr-card-background-color);border-radius:var(--cr-card-border-radius);box-shadow:var(--cr-card-shadow)}.card-container{align-items:stretch;display:flex;gap:16px;justify-content:space-between;width:100%}.card:hover{background-color:var(--cr-hover-background-color);cursor:pointer}.module{height:fit-content;margin-bottom:16px;padding:12px 20px}.section-header{color:var(--cr-primary-text-color);flex:1;font-size:108%;font-weight:400;letter-spacing:.25px;margin-bottom:16px;margin-top:30px;width:100%;user-select:none}.section-header.first{margin-top:0px}</style>

<settings-subpage class="multi-card" page-title="$i18n{safetyHub}"
    learn-more-url="$i18n{safetyHubHelpCenterURL}" route-path$="[[routePath]]">
<h2 class="section-header cr-secondary-text first">
  $i18n{safetyHubPageCardSectionHeader}
</h2>
<div class="card-container">
  <settings-safety-hub-card id="passwords" class="card box"
      data="[[passwordCardData_]]" on-click="onPasswordsClick_"
      tabindex="0" on-keydown="onPasswordsKeyPress_" role="link"
      aria-description="$i18n{safetyHubPasswordNavigationAriaLabel}">
  </settings-safety-hub-card>
  <settings-safety-hub-card id="version" class="card box"
      data="[[versionCardData_]]" on-click="onVersionClick_"
      tabindex="0" on-keydown="onVersionKeyPress_" role="[[versionCardRole_]]"
      aria-description="[[versionCardAriaDescription_]]">
  </settings-safety-hub-card>
  <settings-safety-hub-card id="safeBrowsing" class="card box"
      data="[[safeBrowsingCardData_]]" on-click="onSafeBrowsingClick_"
      tabindex="0" on-keydown="onSafeBrowsingKeyPress_" role="link"
      aria-description="$i18n{safetyHubSBNavigationAriaLabel}">
  </settings-safety-hub-card>
</div>
<h2 class="section-header cr-secondary-text">
  $i18n{safetyHubPageModuleSectionHeader}
</h2>
<template is="dom-if" if="[[showNotificationPermissions_]]">
  <settings-safety-hub-notification-permissions-module class="module box">
  </settings-safety-hub-notification-permissions-module>
</template>
<template is="dom-if" if="[[showUnusedSitePermissions_]]">
  <settings-safety-hub-unused-site-permissions-module class="module box">
  </settings-safety-hub-unused-site-permissions-module>
</template>
<template is="dom-if" if="[[showExtensions_]]">
  <settings-safety-hub-extensions-module class="module box">
  </settings-safety-hub-extensions-module>
</template>
<template is="dom-if" if="[[showNoRecommendationsState_]]">
  <settings-safety-hub-module id="emptyStateModule" class="module box"
      header="$i18n{safetyHubEmptyStateModuleHeader}"
      subheader="$i18n{safetyHubEmptyStateModuleSubheader}"
      header-icon="cr:check">
  </settings-safety-hub-module>
  <settings-safety-hub-module
      id="userEducationModule"
      on-sh-module-item-link-click="onEducationLinkClick_"
      class="module box"
      header="$i18n{safetyHubUserEduModuleHeader}"
      header-icon="settings20:lightbulb"
      sites="[[userEducationItemList_]]">
  </settings-safety-hub-module>
</template>

  <template is="dom-if" if="[[shouldShowRelaunchDialog]]" restamp>
    <relaunch-confirmation-dialog restart-type="[[restartTypeEnum.RELAUNCH]]"
        on-close="onRelaunchDialogClose" is-version-update>
    </relaunch-confirmation-dialog>
  </template>

</settings-supage>
<!--_html_template_end_-->`}const SettingsSafetyHubPageElementBase=RouteObserverMixin(SettingsViewMixin(RelaunchMixin(PrefsMixin(WebUiListenerMixin(I18nMixin(PolymerElement))))));class SettingsSafetyHubPageElement extends SettingsSafetyHubPageElementBase{static get is(){return"settings-safety-hub-page"}static get template(){return getTemplate$1w()}static get properties(){return{passwordCardData_:Object,versionCardData_:Object,safeBrowsingCardData_:Object,showNotificationPermissions_:{type:Boolean,value:false},showUnusedSitePermissions_:{type:Boolean,value:false},showExtensions_:{type:Boolean,value:false},showNoRecommendationsState_:{type:Boolean,computed:"computeShowNoRecommendationsState_(showUnusedSitePermissions_.*, showExtensions_.*, showNotificationPermissions_.*)"},userEducationItemList_:Array,hasDataForNotificationPermissions_:Boolean,hasDataForUnusedPermissions_:Boolean,hasDataForExtensions_:Boolean,versionCardRole_:{type:String,computed:"computeVersionCardRole_(versionCardData_)"},versionCardAriaDescription_:{type:String,computed:"computeVersionCardAriaDescription_(versionCardData_)"}}}static get observers(){return["onAllModulesLoaded_(passwordCardData_, versionCardData_, safeBrowsingCardData_, hasDataForUnusedPermissions_, hasDataForNotificationPermissions_, hasDataForExtensions_)","onSafeBrowsingPrefChanged_(prefs.generated.safe_browsing)"]}shouldRecordMetric_=false;browserProxy_=SafetyHubBrowserProxyImpl.getInstance();metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();connectedCallback(){this.initializeCards_();this.initializeModules_();this.initializeUserEducation_();super.connectedCallback()}currentRouteChanged(newRoute,oldRoute){super.currentRouteChanged(newRoute,oldRoute);if(Router.getInstance().getCurrentRoute()!==routes.SAFETY_HUB){return}this.browserProxy_.dismissActiveMenuNotification();setTimeout((()=>{if(Router.getInstance().getCurrentRoute()===routes.SAFETY_HUB){this.browserProxy_.recordSafetyHubPageVisit()}}),2e4);this.metricsBrowserProxy_.recordSafetyHubImpression(SafetyHubSurfaces.SAFETY_HUB_PAGE);this.metricsBrowserProxy_.recordSafetyHubInteraction(SafetyHubSurfaces.SAFETY_HUB_PAGE);this.shouldRecordMetric_=true;this.onAllModulesLoaded_()}initializeCards_(){this.browserProxy_.getPasswordCardData().then((data=>{this.passwordCardData_=data}));this.browserProxy_.getSafeBrowsingCardData().then((data=>{this.safeBrowsingCardData_=data}));this.browserProxy_.getVersionCardData().then((data=>{this.versionCardData_=data}))}initializeModules_(){this.addWebUiListener(SafetyHubEvent.NOTIFICATION_PERMISSIONS_MAYBE_CHANGED,(sites=>this.onNotificationPermissionListChanged_(sites)));this.addWebUiListener(SafetyHubEvent.UNUSED_PERMISSIONS_MAYBE_CHANGED,(sites=>this.onUnusedSitePermissionListChanged_(sites)));this.addWebUiListener(SafetyHubEvent.EXTENSIONS_CHANGED,(num=>this.onExtensionsChanged_(num)));this.browserProxy_.getNotificationPermissionReview().then((sites=>this.onNotificationPermissionListChanged_(sites)));this.browserProxy_.getRevokedUnusedSitePermissionsList().then((sites=>this.onUnusedSitePermissionListChanged_(sites)));this.browserProxy_.getNumberOfExtensionsThatNeedReview().then((num=>this.onExtensionsChanged_(num)))}initializeUserEducation_(){this.userEducationItemList_=[{origin:this.i18n("safetyHubUserEduDataHeader"),detail:this.i18nAdvanced("safetyHubUserEduDataSubheader"),icon:"settings20:chrome-filled"},{origin:this.i18n("safetyHubUserEduIncognitoHeader"),detail:this.i18nAdvanced("safetyHubUserEduIncognitoSubheader"),icon:"settings20:incognito-unfilled"},{origin:this.i18n("safetyHubUserEduSafeBrowsingHeader"),detail:this.i18nAdvanced("safetyHubUserEduSafeBrowsingSubheader"),icon:"cr:security"}]}onPasswordsClick_(){this.metricsBrowserProxy_.recordSafetyHubCardStateClicked("Settings.SafetyHub.PasswordsCard.StatusOnClick",this.passwordCardData_.state);this.browserProxy_.recordSafetyHubInteraction();PasswordManagerImpl.getInstance().showPasswordManager(PasswordManagerPage.CHECKUP)}onPasswordsKeyPress_(e){e.stopPropagation();if(this.isEnterOrSpaceClicked_(e)){this.onPasswordsClick_()}}onVersionClick_(){this.metricsBrowserProxy_.recordSafetyHubCardStateClicked("Settings.SafetyHub.VersionCard.StatusOnClick",this.versionCardData_.state);this.browserProxy_.recordSafetyHubInteraction();if(this.versionCardData_.state===CardState.WARNING){this.performRestart(RestartType.RELAUNCH,true)}else{Router.getInstance().navigateTo(routes.ABOUT,undefined,true)}}onEducationLinkClick_(event){this.browserProxy_.recordSafetyHubInteraction();const headerString=event.detail.querySelector(".site-representation").textContent;switch(headerString){case this.i18n("safetyHubUserEduDataHeader"):this.metricsBrowserProxy_.recordAction("Settings.SafetyHub.SafetyToolsLinkClicked");break;case this.i18n("safetyHubUserEduIncognitoHeader"):this.metricsBrowserProxy_.recordAction("Settings.SafetyHub.IncognitoLinkClicked");break;case this.i18n("safetyHubUserEduSafeBrowsingHeader"):this.metricsBrowserProxy_.recordAction("Settings.SafetyHub.SafeBrowsingLinkClicked");break;default:assertNotReached()}}onVersionKeyPress_(e){e.stopPropagation();if(this.isEnterOrSpaceClicked_(e)){this.onVersionClick_()}}onSafeBrowsingPrefChanged_(){this.browserProxy_.getSafeBrowsingCardData().then((data=>{this.safeBrowsingCardData_=data}))}onSafeBrowsingClick_(){this.metricsBrowserProxy_.recordSafetyHubCardStateClicked("Settings.SafetyHub.SafeBrowsingCard.StatusOnClick",this.safeBrowsingCardData_.state);this.browserProxy_.recordSafetyHubInteraction();Router.getInstance().navigateTo(routes.SECURITY,undefined,true)}onSafeBrowsingKeyPress_(e){e.stopPropagation();if(this.isEnterOrSpaceClicked_(e)){this.onSafeBrowsingClick_()}}onNotificationPermissionListChanged_(permissions){this.showNotificationPermissions_=permissions.length>0||this.showNotificationPermissions_;this.hasDataForNotificationPermissions_=true}onUnusedSitePermissionListChanged_(permissions){this.showUnusedSitePermissions_=permissions.length>0||this.showUnusedSitePermissions_;this.hasDataForUnusedPermissions_=true}computeShowNoRecommendationsState_(){return!(this.showUnusedSitePermissions_||this.showNotificationPermissions_||this.showExtensions_)}onExtensionsChanged_(numberOfExtensions){this.showExtensions_=!!numberOfExtensions;this.hasDataForExtensions_=true}computeVersionCardRole_(){return this.versionCardData_.state===CardState.WARNING?"button":"link"}computeVersionCardAriaDescription_(){return this.versionCardData_.state===CardState.WARNING?this.i18n("safetyHubVersionRelaunchAriaLabel"):this.i18n("safetyHubVersionNavigationAriaLabel")}isEnterOrSpaceClicked_(e){return e.key==="Enter"||e.key===" "}onAllModulesLoaded_(){if(!this.shouldRecordMetric_){return}if(!this.passwordCardData_||!this.safeBrowsingCardData_||!this.versionCardData_){return}if(!this.hasDataForUnusedPermissions_||!this.hasDataForNotificationPermissions_||!this.hasDataForExtensions_){return}this.shouldRecordMetric_=false;let hasAnyWarning=false;if(this.passwordCardData_.state!==CardState.SAFE){this.metricsBrowserProxy_.recordSafetyHubModuleWarningImpression(SafetyHubModuleType.PASSWORDS);hasAnyWarning=true}if(this.safeBrowsingCardData_.state!==CardState.SAFE){this.metricsBrowserProxy_.recordSafetyHubModuleWarningImpression(SafetyHubModuleType.SAFE_BROWSING);hasAnyWarning=true}if(this.versionCardData_.state!==CardState.SAFE){this.metricsBrowserProxy_.recordSafetyHubModuleWarningImpression(SafetyHubModuleType.VERSION);hasAnyWarning=true}if(this.showNotificationPermissions_){this.metricsBrowserProxy_.recordSafetyHubModuleWarningImpression(SafetyHubModuleType.NOTIFICATIONS);hasAnyWarning=true}if(this.showUnusedSitePermissions_){this.metricsBrowserProxy_.recordSafetyHubModuleWarningImpression(SafetyHubModuleType.PERMISSIONS);hasAnyWarning=true}if(this.showExtensions_){this.metricsBrowserProxy_.recordSafetyHubModuleWarningImpression(SafetyHubModuleType.EXTENSIONS);hasAnyWarning=true}this.metricsBrowserProxy_.recordSafetyHubDashboardAnyWarning(hasAnyWarning)}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsSafetyHubPageElement.is,SettingsSafetyHubPageElement);function getTemplate$1v(){return html`<!--_html_template_start_-->    <style include="settings-shared">#policySubtitleContainer{gap:10px;display:flex;margin-bottom:16px}
    </style>
    <cr-dialog id="dialog" close-text="$i18n{close}">
      <div slot="title">[[dialogTitle_]]</div>
      <div slot="body" spellcheck="false">
        <template is="dom-if" if="[[showPolicySubtitle_]]">
          <div id="policySubtitleContainer">
            <cr-icon icon="cr:domain"></cr-icon>
            <span class="secondary">
              $i18n{searchEnginesDeleteConfirmationSubtitleForPolicy}
            </span>
          </div>
        </template>
        <cr-input id="searchEngine"
            label="$i18n{searchEnginesName}"
            readonly="[[readonly_]]"
            error-message="$i18n{notValid}"
            value="{{searchEngine_}}" on-input="validate_"
            autofocus>
        </cr-input>
        <cr-input id="keyword"
            label="$i18n{searchEnginesShortcut}"
            readonly="[[readonly_]]"
            error-message="$i18n{notValid}"
            value="{{keyword_}}" on-focus="validate_" on-input="validate_">
        </cr-input>
        <cr-input id="queryUrl"
            label="$i18n{searchEnginesQueryURLExplanation}"
            readonly="[[urlIsReadonly_]]"
            error-message="$i18n{notValid}"
            value="{{queryUrl_}}" on-focus="validate_" on-input="validate_">
        </cr-input>
      </div>
      <div slot="button-container">
        <cr-button class="cancel-button" on-click="cancel_" id="cancel"
            hidden="[[readonly_]]">
          $i18n{cancel}</cr-button>
        <cr-button id="actionButton" class="action-button"
            on-click="onActionButtonClick_">
          [[actionButtonText_]]
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`}const DEFAULT_MODEL_INDEX=-1;const SettingsSearchEngineEditDialogElementBase=WebUiListenerMixin(PolymerElement);class SettingsSearchEngineEditDialogElement extends SettingsSearchEngineEditDialogElementBase{static get is(){return"settings-search-engine-edit-dialog"}static get template(){return getTemplate$1v()}static get properties(){return{model:Object,searchEngine_:String,keyword_:String,queryUrl_:String,dialogTitle_:String,actionButtonText_:String,showPolicySubtitle_:Boolean,readonly_:Boolean,urlIsReadonly_:{type:Boolean,computed:"computeUrlIsReadonly_(model, readonly_)"}}}browserProxy_=SearchEnginesBrowserProxyImpl.getInstance();ready(){super.ready();if(this.model){this.readonly_=this.model.isManaged&&!this.model.canBeEdited;if(this.model.isPrepopulated||this.model.default){this.dialogTitle_=loadTimeData.getString(this.readonly_?"searchEnginesViewSearchEngine":"searchEnginesEditSearchEngine")}else{this.dialogTitle_=loadTimeData.getString(this.readonly_?"searchEnginesViewSiteSearch":"searchEnginesEditSiteSearch")}this.actionButtonText_=loadTimeData.getString(this.readonly_?"done":"save");this.showPolicySubtitle_=this.model.isManaged;this.searchEngine_=this.model.name;this.keyword_=this.model.keyword;this.queryUrl_=this.model.url}else{this.dialogTitle_=loadTimeData.getString("searchEnginesAddSiteSearch");this.actionButtonText_=loadTimeData.getString("add");this.readonly_=false;this.showPolicySubtitle_=false}this.addEventListener("cancel",(()=>{this.browserProxy_.searchEngineEditCancelled()}));this.addWebUiListener("search-engines-changed",this.enginesChanged_.bind(this))}connectedCallback(){super.connectedCallback();microTask.run((()=>this.updateActionButtonState_()));this.browserProxy_.searchEngineEditStarted(this.model?this.model.modelIndex:DEFAULT_MODEL_INDEX);this.$.dialog.showModal()}enginesChanged_(searchEnginesInfo){if(this.model){const engineWasRemoved=["defaults","actives","others","extensions"].every((engineType=>searchEnginesInfo[engineType].every((e=>e.id!==this.model.id))));if(engineWasRemoved){this.cancel_();return}}[this.$.searchEngine,this.$.keyword,this.$.queryUrl].forEach((element=>this.validateElement_(element)))}cancel_(){this.$.dialog.cancel()}onActionButtonClick_(){this.browserProxy_.searchEngineEditCompleted(this.searchEngine_,this.keyword_,this.queryUrl_);this.$.dialog.close()}validateElement_(inputElement){if(this.readonly_){return}if(inputElement.value===""){inputElement.invalid=false;this.updateActionButtonState_();return}this.browserProxy_.validateSearchEngineInput(inputElement.id,inputElement.value).then((isValid=>{inputElement.invalid=!isValid;this.updateActionButtonState_()}))}validate_(event){const inputElement=event.target;this.validateElement_(inputElement)}updateActionButtonState_(){const allValid=[this.$.searchEngine,this.$.keyword,this.$.queryUrl].every((function(inputElement){return!inputElement.invalid&&inputElement.value.length>0}));this.$.actionButton.disabled=!allValid}computeUrlIsReadonly_(){return this.readonly_||!!this.model&&this.model.urlLocked}}customElements.define(SettingsSearchEngineEditDialogElement.is,SettingsSearchEngineEditDialogElement);const AUTO_SRC="auto-src";const CLEAR_SRC="clear-src";const IS_GOOGLE_PHOTOS="is-google-photos";const STATIC_ENCODE="static-encode";const ENCODE_TYPE="encode-type";class CrAutoImgElement extends HTMLImageElement{static get observedAttributes(){return[AUTO_SRC,IS_GOOGLE_PHOTOS,STATIC_ENCODE,ENCODE_TYPE]}attributeChangedCallback(name,oldValue,newValue){if(name!==AUTO_SRC&&name!==IS_GOOGLE_PHOTOS&&name!==STATIC_ENCODE&&name!==ENCODE_TYPE){return}if(name===IS_GOOGLE_PHOTOS&&oldValue===null===(newValue===null)){return}if(this.hasAttribute(CLEAR_SRC)){this.removeAttribute("src")}let url=null;try{url=new URL(this.getAttribute(AUTO_SRC)||"")}catch(_){}if(!url||url.protocol==="chrome-untrusted:"){this.removeAttribute("src");return}if(url.protocol==="data:"||url.protocol==="chrome:"){this.src=url.href;return}if(!this.hasAttribute(IS_GOOGLE_PHOTOS)&&!this.hasAttribute(STATIC_ENCODE)&&!this.hasAttribute(ENCODE_TYPE)){this.src="chrome://image?"+url.href;return}this.src=`chrome://image?url=${encodeURIComponent(url.href)}`;if(this.hasAttribute(IS_GOOGLE_PHOTOS)){this.src+=`&isGooglePhotos=true`}if(this.hasAttribute(STATIC_ENCODE)){this.src+=`&staticEncode=true`}if(this.hasAttribute(ENCODE_TYPE)){this.src+=`&encodeType=${this.getAttribute(ENCODE_TYPE)}`}}set autoSrc(src){this.setAttribute(AUTO_SRC,src)}get autoSrc(){return this.getAttribute(AUTO_SRC)||""}set clearSrc(_){this.setAttribute(CLEAR_SRC,"")}get clearSrc(){return this.getAttribute(CLEAR_SRC)||""}set isGooglePhotos(enabled){if(enabled){this.setAttribute(IS_GOOGLE_PHOTOS,"")}else{this.removeAttribute(IS_GOOGLE_PHOTOS)}}get isGooglePhotos(){return this.hasAttribute(IS_GOOGLE_PHOTOS)}set staticEncode(enabled){if(enabled){this.setAttribute(STATIC_ENCODE,"")}else{this.removeAttribute(STATIC_ENCODE)}}get staticEncode(){return this.hasAttribute(STATIC_ENCODE)}set encodeType(type){if(type){this.setAttribute(ENCODE_TYPE,type)}else{this.removeAttribute(ENCODE_TYPE)}}get encodeType(){return this.getAttribute(ENCODE_TYPE)||""}}customElements.define("cr-auto-img",CrAutoImgElement,{extends:"img"});const styleMod$2=document.createElement("dom-module");styleMod$2.appendChild(html`
  <template>
    <style>
site-favicon{margin-inline-end:8px;min-width:16px}
    </style>
  </template>
`.content);styleMod$2.register("search-engine-entry");function getTemplate$1u(){return html`<!--_html_template_start_-->    <style include="settings-shared search-engine-entry">:host([is-default]) .list-item{font-weight:500}.additional-info-column-group{align-items:center;display:flex;flex:6}#controls-column-group{flex:auto;margin-left:auto;display:flex;justify-content:end;align-items:center}cr-policy-indicator{display:inline-flex;justify-content:center;margin-inline-start:16px;vertical-align:middle;width:36px}#downloadedIcon{display:block;height:var(--site-favicon-height,16px);margin-inline-end:8px;min-width:16px;width:var(--site-favicon-width,16px)}#name-column{align-items:center;display:flex;flex:3;word-break:break-word}#shortcut-column{word-break:break-word}#shortcut-column,#url-column{flex:auto;margin-inline-end:10px;max-width:200px}
    </style>

    <div class="list-item cr-row" role="row">
      <span role="cell" id="name-column">
        <site-favicon favicon-url="[[engine.iconURL]]" url="[[engine.url]]"
            icon-path="[[engine.iconPath]]"
            hidden="[[shouldShowDownloadedIcon_(showDownloadedIcon_, engine)]]">
        </site-favicon>
        <img id="downloadedIcon" is="cr-auto-img"
            auto-src="[[engine.iconURL]]" clear-src
            on-load="onDownloadedIconLoadSuccess_"
            on-error="onDownloadedIconLoadError_"
            hidden="[[!shouldShowDownloadedIcon_(showDownloadedIcon_, engine)]]">
        <div>[[engine.displayName]]</div>
      </span>
      <span class="additional-info-column-group">
        <span role="cell" id="shortcut-column" hidden="[[!showShortcut]]">
          <div>[[engine.keyword]]</div>
        </span>
        <span role="cell" id="url-column" hidden="[[!showQueryUrl]]">
          <div class="text-elide">[[engine.url]]</div>
        </span>
        <span role="cell" id="controls-column-group">
          <cr-button class="secondary-button" on-click="onActivateClick_"
              aria-label="[[getActivateButtonAriaLabel_(engine)]]"
              hidden="[[!engine.canBeActivated]]" id="activate">
            $i18n{searchEnginesActivate}
          </cr-button>
          <cr-button class="secondary-button" on-click="onViewOrEditClick_"
              hidden="[[!showSecondaryButton_]]" id="viewDetailsButton">
            $i18n{searchEnginesViewDetails}
          </cr-button>
          <cr-icon-button class="icon-edit" on-click="onViewOrEditClick_"
              title="$i18n{edit}" hidden="[[!showEditIcon_]]"
              aria-label="[[getEditButtonAriaLabel_(engine)]]"
              disabled$="[[!engine.canBeEdited]]" id="editIconButton">
          </cr-icon-button>
          <template is="dom-if" if="[[engine.isManaged]]">
            <cr-policy-indicator indicator-type="userPolicy">
            </cr-policy-indicator>
          </template>
          <cr-icon-button class="icon-more-vert" on-click="onDotsClick_"
              disabled$="[[disableDots_]]" title="$i18n{moreActions}"
              aria-label="[[getMoreActionsAriaLabel_(engine)]]">
          </cr-icon-button>
          <cr-action-menu role-description="$i18n{menu}">
            <button class="dropdown-item" on-click="onMakeDefaultClick_"
                disabled$="[[!engine.canBeDefault]]" id="makeDefault">
              $i18n{searchEnginesMakeDefault}
            </button>
            <button class="dropdown-item" on-click="onDeactivateClick_"
                hidden="[[!engine.canBeDeactivated]]" id="deactivate">
              $i18n{searchEnginesDeactivate}
            </button>
            <button class="dropdown-item" on-click="onDeleteClick_"
                hidden="[[!engine.canBeRemoved]]" id="delete">
              $i18n{delete}
            </button>
          </cr-action-menu>
        </span>
      </span>
    </div>
    <template is="dom-if" if="[[engine.extension]]">
      <extension-controlled-indicator
          extension-id="[[engine.extension.id]]"
          extension-name="[[engine.extension.name]]"
          extension-can-be-disabled="[[engine.extension.canBeDisabled]]">
      </extension-controlled-indicator>
    </template>
<!--_html_template_end_-->`}const SettingsSearchEngineEntryElementBase=I18nMixin(PolymerElement);class SettingsSearchEngineEntryElement extends SettingsSearchEngineEntryElementBase{static get is(){return"settings-search-engine-entry"}static get template(){return getTemplate$1u()}static get properties(){return{engine:{type:Object,observer:"onEngineChanged_"},showShortcut:{type:Boolean,value:false,reflectToAttribute:true},showQueryUrl:{type:Boolean,value:false,reflectToAttribute:true},isDefault:{reflectToAttribute:true,type:Boolean,computed:"computeIsDefault_(engine)"},showEditIcon_:{type:Boolean,computed:"computeShowEditIcon_(engine)"},showDownloadedIcon_:{type:Boolean,value:false},showSecondaryButton_:{type:Boolean,computed:"computeShowSecondaryButton_(engine)"},disableDots_:{type:Boolean,computed:"computeDisableDots_(engine)"}}}browserProxy_=SearchEnginesBrowserProxyImpl.getInstance();timeoutId_=null;onEngineChanged_(newEngine,oldEngine){if(oldEngine&&newEngine.iconURL===oldEngine.iconURL){return}this.showDownloadedIcon_=false;if(this.timeoutId_){clearTimeout(this.timeoutId_);this.timeoutId_=null}this.timeoutId_=setTimeout((()=>{if(!this.$.downloadedIcon.complete){this.$.downloadedIcon.src="";this.showDownloadedIcon_=false}this.timeoutId_=null}),1e3)}closePopupMenu_(){this.shadowRoot.querySelector("cr-action-menu").close()}computeIsDefault_(){return this.engine.default}computeShowEditIcon_(){return!this.engine.isStarterPack&&!this.engine.canBeActivated&&!(this.engine.isManaged&&!this.engine.canBeEdited)}computeShowSecondaryButton_(){return!this.engine.canBeActivated&&(this.engine.isManaged&&!this.engine.canBeEdited)}computeDisableDots_(){return this.engine.default||this.engine.isManaged&&!this.engine.canBeActivated&&!this.engine.canBeDeactivated&&!this.engine.canBeRemoved}onDeleteClick_(e){e.preventDefault();this.closePopupMenu_();if(!this.engine.shouldConfirmDeletion){this.browserProxy_.removeSearchEngine(this.engine.modelIndex);return}const dots=this.shadowRoot.querySelector("cr-icon-button.icon-more-vert");assert(dots);this.dispatchEvent(new CustomEvent("delete-search-engine",{bubbles:true,composed:true,detail:{engine:this.engine,anchorElement:dots}}))}onDotsClick_(){const dots=this.shadowRoot.querySelector("cr-icon-button.icon-more-vert");assert(dots);this.shadowRoot.querySelector("cr-action-menu").showAt(dots,{anchorAlignmentY:AnchorAlignment.AFTER_END})}onViewOrEditClick_(e){e.preventDefault();this.closePopupMenu_();const anchor=this.shadowRoot.querySelector("cr-icon-button");assert(anchor);this.dispatchEvent(new CustomEvent("view-or-edit-search-engine",{bubbles:true,composed:true,detail:{engine:this.engine,anchorElement:anchor}}))}onMakeDefaultClick_(){this.closePopupMenu_();this.browserProxy_.setDefaultSearchEngine(this.engine.modelIndex,ChoiceMadeLocation.SEARCH_ENGINE_SETTINGS,null)}onActivateClick_(){this.closePopupMenu_();this.browserProxy_.setIsActiveSearchEngine(this.engine.modelIndex,true)}onDeactivateClick_(){this.closePopupMenu_();this.browserProxy_.setIsActiveSearchEngine(this.engine.modelIndex,false)}onDownloadedIconLoadError_(){this.showDownloadedIcon_=false}onDownloadedIconLoadSuccess_(){this.showDownloadedIcon_=true;if(this.timeoutId_){clearTimeout(this.timeoutId_)}this.timeoutId_=null}shouldShowDownloadedIcon_(){return this.showDownloadedIcon_&&!this.engine.iconPath&&!!this.engine.iconURL}getMoreActionsAriaLabel_(){return this.i18n("searchEnginesMoreActionsAriaLabel",this.engine.displayName)}getActivateButtonAriaLabel_(){return this.i18n("searchEnginesActivateButtonAriaLabel",this.engine.displayName)}getEditButtonAriaLabel_(){return this.i18n("searchEnginesEditButtonAriaLabel",this.engine.displayName)}}customElements.define(SettingsSearchEngineEntryElement.is,SettingsSearchEngineEntryElement);function getTemplate$1t(){return html`<!--_html_template_start_-->    <style include="settings-shared">#headers{display:flex;padding:10px 0}#headers .additional-info-column-group{align-items:center;display:flex;flex:6}#headers .controls-group{flex:auto;margin-left:auto;display:flex;justify-content:end;align-items:center}#headers .name{flex:3}#headers .shortcut,#headers .url{flex:auto;margin-inline-end:40px}settings-search-engine-entry{border-top:var(--cr-separator-line)}:host([fixed-height]) #container{max-height:calc((var(--cr-section-min-height) + var(--cr-separator-height)) * 6)}.icon-placeholder{margin-inline-end:0;margin-inline-start:var(--cr-icon-button-margin-start);width:var(--cr-icon-ripple-size)}.cr-row{padding-inline-end:7px;padding-inline-start:0}
    </style>
    <div id="outer" class="list-frame" role="table">
      <div role="rowgroup">
        <div role="row" id="headers" class="column-header">
          <span class="name" role="columnheader">$i18n{searchEnginesName}</span>
          <span class="additional-info-column-group">
            <span class="shortcut" role="columnheader"
                  hidden="[[!showShortcut]]">
              $i18n{searchEnginesShortcut}
            </span>
            <span class="url" role="columnheader"
                  hidden="[[!showQueryUrl]]">
              $i18n{searchEnginesQueryURL}
            </span>
            <span class="controls-group">
              <span class="icon-placeholder"></span>
              <span class="icon-placeholder"></span>
            </span>
          </span>
        </div>
      </div>
      <template is="dom-if" if="[[!collapseList]]">
        <div id="container" class="scroll-container"
            scrollable$="[[fixedHeight]]">
          <div role="rowgroup">
            <template is="dom-repeat" items="[[engines]]">
              <settings-search-engine-entry engine="[[item]]"
                  show-query-url="[[showQueryUrl]]"
                  show-shortcut="[[showShortcut]]">
              </settings-search-engine-entry>
            </template>
          </div>
        </div>
      </template>

      <template is="dom-if" if="[[collapseList]]">
        <div id="containerWithCollapsibleSection" class="scroll-container"
            hidden="[[!collapseList]]"
            scrollable$="[[fixedHeight]]">
          <div role="rowgroup">
            <template is="dom-repeat" items="[[visibleEngines]]">
              <settings-search-engine-entry engine="[[item]]"
                  show-shortcut="[[showShortcut]]"
                  show-query-url="[[showQueryUrl]]">
              </settings-search-engine-entry>
            </template>
          </div>

          <cr-expand-button no-hover class="cr-row"
              hidden="[[!collapsedEngines.length]]"
              expanded="{{enginesListExpanded_}}">
            <div>[[expandListText]]</div>
          </cr-expand-button>
          <cr-collapse opened="[[enginesListExpanded_]]">
            <div role="rowgroup">
              <template is="dom-repeat" items="[[collapsedEngines]]">
                <settings-search-engine-entry engine="[[item]]"
                    show-shortcut="[[showShortcut]]"
                    show-query-url="[[showQueryUrl]]">
                </settings-search-engine-entry>
              </template>
            </div>
          </cr-collapse>
        </div>
      </template>
    </div>
<!--_html_template_end_-->`}class SettingsSearchEnginesListElement extends PolymerElement{static get is(){return"settings-search-engines-list"}static get template(){return getTemplate$1t()}static get properties(){return{engines:Array,showShortcut:{type:Boolean,value:false,reflectToAttribute:true},showQueryUrl:{type:Boolean,value:false,reflectToAttribute:true},collapseList:{type:Boolean,value:false,reflectToAttribute:true},visibleEnginesSize:{type:Number,value:5},visibleEngines:{type:Array,computed:"computeVisibleEngines_(engines)"},collapsedEngines:{type:Array,computed:"computeCollapsedEngines_(engines)"},lastFocused_:Object,listBlurred_:Boolean,expandListText:{type:String,reflectToAttribute:true},fixedHeight:{type:Boolean,value:false,reflectToAttribute:true}}}computeVisibleEngines_(engines){if(!engines||!engines.length){return}return engines.slice(0,this.visibleEnginesSize)}computeCollapsedEngines_(engines){if(!engines||!engines.length){return}return engines.slice(this.visibleEnginesSize)}}customElements.define(SettingsSearchEnginesListElement.is,SettingsSearchEnginesListElement);function getTemplate$1s(){return html`<!--_html_template_start_-->    <style include="settings-shared search-engine-entry">.name-column{align-items:center;display:flex;flex:3;word-break:break-word}.keyword-column{flex:7}
    </style>
    <div class="list-item" focus-row-container>
      <div class="name-column">
        <site-favicon favicon-url="[[engine.iconURL]]"></site-favicon>
        <span>[[engine.displayName]]</span>
      </div>
      <div class="keyword-column">[[engine.keyword]]</div>
      <cr-icon-button class="icon-more-vert" on-click="onDotsClick_"
          title="$i18n{moreActions}" focus-row-control focus-type="menu">
      </cr-icon-button>
      <cr-action-menu role-description="$i18n{menu}">
        <button class="dropdown-item" on-click="onManageClick_"
            id="manage">
          $i18n{searchEnginesManageExtension}
        </button>
        <button class="dropdown-item" on-click="onDisableClick_"
            id="disable">
          $i18n{disable}
        </button>
      </cr-action-menu>
    </div>
<!--_html_template_end_-->`}const SettingsOmniboxExtensionEntryElementBase=FocusRowMixin(PolymerElement);class SettingsOmniboxExtensionEntryElement extends SettingsOmniboxExtensionEntryElementBase{static get is(){return"settings-omnibox-extension-entry"}static get template(){return getTemplate$1s()}static get properties(){return{engine:Object}}browserProxy_=ExtensionControlBrowserProxyImpl.getInstance();onManageClick_(){this.closePopupMenu_();this.browserProxy_.manageExtension(this.engine.extension.id)}onDisableClick_(){this.closePopupMenu_();this.browserProxy_.disableExtension(this.engine.extension.id)}closePopupMenu_(){this.shadowRoot.querySelector("cr-action-menu").close()}onDotsClick_(){const dots=this.shadowRoot.querySelector("cr-icon-button");assert(dots);this.shadowRoot.querySelector("cr-action-menu").showAt(dots,{anchorAlignmentY:AnchorAlignment.AFTER_END})}}customElements.define(SettingsOmniboxExtensionEntryElement.is,SettingsOmniboxExtensionEntryElement);function getTemplate$1r(){return html`<!--_html_template_start_-->  <style include="cr-shared-style settings-shared">settings-omnibox-extension-entry{border-top:var(--cr-separator-line)}
  </style>
  <settings-subpage
      page-title="$i18n{searchEnginesManageSiteSearch}"
      route-path$="[[routePath]]" search-label="$i18n{searchEnginesSearch}"
      search-icon="settings20:filter-list"
      search-term="{{filter_}}">
    <div class="cr-row first">
      <div class="secondary">$i18n{searchEnginesPageExplanation}</div>
    </div>
    <div class="cr-row first">
      <div class="flex cr-padded-text">
        <div id="keyboardShortcutsTitle">
          $i18n{searchEnginesKeyboardShortcutsTitle}
        </div>
        <div class="secondary">
          $i18n{searchEnginesKeyboardShortcutsDescription}
        </div>
      </div>
    </div>
    <div class="list-frame">
      <settings-radio-group id="keyboardShortcutSettingGroup"
          pref="{{prefs.omnibox.keyword_space_triggering_enabled}}"
          on-change="onKeyboardShortcutSettingChange_">
        <controlled-radio-button class="list-item" name="true"
            pref="{{prefs.omnibox.keyword_space_triggering_enabled}}"
            label="$i18n{searchEnginesKeyboardShortcutsSpaceOrTab}"
            aria-labelledby="keyboardShortcutsTitle"
            no-extension-indicator>
        </controlled-radio-button>
        <controlled-radio-button class="list-item" name="false"
            pref="{{prefs.omnibox.keyword_space_triggering_enabled}}"
            label="$i18n{searchEnginesKeyboardShortcutsTab}"
            aria-labelledby="keyboardShortcutsTitle"
            no-extension-indicator>
        </controlled-radio-button>
      </settings-radio-group>
    </div>

    <div class="cr-row first">
      <div class="flex cr-padded-text">
        <h2>$i18n{searchEnginesSearchEngines}</h2>
        <div class="secondary">
          $i18n{searchEnginesSearchEnginesExplanation}
        </div>
      </div>
    </div>
    <settings-search-engines-list hidden="[[!matchingDefaultEngines_.length]]"
        engines="[[matchingDefaultEngines_]]" show-shortcut>
    </settings-search-engines-list>

    <div class="no-search-results list-frame"
        hidden="[[matchingDefaultEngines_.length]]">
      $i18n{searchNoResults}
    </div>

    <template is="dom-if" if="[[showEditDialog_]]" restamp>
      <settings-search-engine-edit-dialog model="[[dialogModel_]]"
          on-close="onCloseEditDialog_">
      </settings-search-engine-edit-dialog>
    </template>

    <template is="dom-if" if="[[showDeleteConfirmationDialog_]]" restamp>
      <settings-simple-confirmation-dialog id="deleteConfirmDialog"
          title-text="$i18n{searchEnginesDeleteConfirmationTitle}"
          body-text="[[getDeleteConfirmationBodyText_(dialogModel_)]]"
          confirm-text="$i18n{delete}"
          on-close="onCloseDeleteConfirmationDialog_">
      </settings-simple-confirmation-dialog>
    </template>

    <div class="cr-row first">
        <div class="flex cr-padded-text">
          <h2>$i18n{searchEnginesSiteSearch}</h2>
          <div class="secondary">$i18n{searchEnginesSiteSearchExplanation}</div>
        </div>
        <cr-button class="secondary-button header-aligned-button"
                   aria-label="$i18n{searchEnginesAddButtonAriaLabel}"
                   on-click="onAddSearchEngineClick_" id="addSearchEngine">
          $i18n{add}
        </cr-button>
    </div>
    <div id="noActiveEngines" class="list-frame"
           hidden="[[activeEngines.length]]">
          $i18n{searchEnginesNoSitesAdded}
    </div>
    <div class="no-search-results list-frame"
           hidden="[[!showNoResultsMessage_(
          activeEngines, matchingActiveEngines_)]]">
          $i18n{searchNoResults}
    </div>
    <settings-search-engines-list id="activeEngines"
        hidden="[[!matchingActiveEngines_.length]]"
        engines="[[matchingActiveEngines_]]"
        scroll-target="[[subpageScrollTarget]]"
        show-shortcut collapse-list
        expand-list-text="$i18n{searchEnginesAdditionalSites}">
    </settings-search-engines-list>

    <div class="cr-row first">
        <h2>$i18n{searchEnginesInactiveShortcuts}</h2>
    </div>
    <settings-search-engines-list
        hidden="[[!matchingOtherEngines_.length]]"
        engines="[[matchingOtherEngines_]]"
        scroll-target="[[subpageScrollTarget]]"
        show-query-url collapse-list
        expand-list-text="$i18n{searchEnginesAdditionalInactiveSites}">
    </settings-search-engines-list>

    <div id="noOtherEngines" class="list-frame"
        hidden="[[otherEngines.length]]">
      $i18n{searchEnginesNoOtherEngines}
    </div>
    <div class="no-search-results list-frame"
        hidden="[[!showNoResultsMessage_(
            otherEngines, matchingOtherEngines_)]]">
      $i18n{searchNoResults}
    </div>

    <template is="dom-if" if="[[showExtensionsList_]]">
      <div class="cr-row first">
        <div class="flex cr-padded-text">
          <h2 class="flex">$i18n{searchEnginesExtension}</h2>
          <div class="secondary"> $i18n{searchEnginesExtensionExplanation}</div>
        </div>
      </div>
      <div class="no-search-results list-frame"
          hidden="[[matchingExtensions_.length]]">
        $i18n{searchNoResults}
      </div>
      <iron-list id="extensions" class="extension-engines list-frame"
          items="[[matchingExtensions_]]" preserve-focus risk-selection>
        <template>
          <settings-omnibox-extension-entry engine="[[item]]"
              focus-row-index="[[index]]"
              tabindex$="[[tabIndex]]" iron-list-tab-index="[[tabIndex]]"
              last-focused="{{omniboxExtensionlastFocused_}}"
              list-blurred="{{omniboxExtensionListBlurred_}}">
          </settings-omnibox-extension-entry>
        </template>
      </iron-list>
    </template>
  </settings-subpage>
<!--_html_template_end_-->`}const SettingsSearchEnginesPageElementBase=SettingsViewMixin(GlobalScrollTargetMixin(WebUiListenerMixin(I18nMixin(PolymerElement))));class SettingsSearchEnginesPageElement extends SettingsSearchEnginesPageElementBase{static get is(){return"settings-search-engines-page"}static get template(){return getTemplate$1r()}static get properties(){return{prefs:{type:Object,notify:true},defaultEngines:Array,activeEngines:Array,otherEngines:Array,extensions:Array,subpageRoute:{type:Object,value:routes.SEARCH_ENGINES},showExtensionsList_:{type:Boolean,computed:"computeShowExtensionsList_(extensions)"},filter_:{type:String,value:""},matchingDefaultEngines_:{type:Array,computed:"computeMatchingEngines_(defaultEngines, filter_)"},matchingActiveEngines_:{type:Array,computed:"computeMatchingEngines_(activeEngines, filter_)"},matchingOtherEngines_:{type:Array,computed:"computeMatchingEngines_(otherEngines, filter_)"},matchingExtensions_:{type:Array,computed:"computeMatchingEngines_(extensions, filter_)"},omniboxExtensionlastFocused_:Object,omniboxExtensionListBlurred_:Boolean,dialogModel_:{type:Object,value:null},dialogAnchorElement_:{type:Object,value:null},showEditDialog_:{type:Boolean,value:false},showDeleteConfirmationDialog_:{type:Boolean,value:false}}}static get observers(){return["extensionsChanged_(extensions, showExtensionsList_)"]}browserProxy_=SearchEnginesBrowserProxyImpl.getInstance();ready(){super.ready();this.browserProxy_.getSearchEnginesList().then(this.enginesChanged_.bind(this));this.addWebUiListener("search-engines-changed",this.enginesChanged_.bind(this));this.addEventListener("view-or-edit-search-engine",(e=>this.onEditSearchEngine_(e)));this.addEventListener("delete-search-engine",(e=>this.onDeleteSearchEngine_(e)))}openEditDialog_(searchEngine,anchorElement){this.dialogModel_=searchEngine;this.dialogAnchorElement_=anchorElement;this.showEditDialog_=true}openDeleteConfirmationDialog_(searchEngine,anchorElement){this.dialogModel_=searchEngine;this.dialogAnchorElement_=anchorElement;this.showDeleteConfirmationDialog_=true}getDeleteConfirmationBodyText_(searchEngine){if(searchEngine&&searchEngine.isManaged){return this.i18n("searchEnginesDeleteConfirmationDescriptionForPolicy")}return this.i18n("searchEnginesDeleteConfirmationDescription")}onCloseEditDialog_(){this.showEditDialog_=false;focusWithoutInk(this.dialogAnchorElement_);this.dialogModel_=null;this.dialogAnchorElement_=null}onCloseDeleteConfirmationDialog_(){const dialog=this.shadowRoot.querySelector("settings-simple-confirmation-dialog");assert(dialog);const confirmed=dialog.wasConfirmed();this.showDeleteConfirmationDialog_=false;if(confirmed){assert(this.dialogModel_);this.browserProxy_.removeSearchEngine(this.dialogModel_.modelIndex);this.dialogAnchorElement_=null}this.dialogModel_=null}onEditSearchEngine_(e){this.openEditDialog_(e.detail.engine,e.detail.anchorElement)}onDeleteSearchEngine_(e){this.openDeleteConfirmationDialog_(e.detail.engine,e.detail.anchorElement)}extensionsChanged_(){if(this.showExtensionsList_&&this.$.extensions){this.$.extensions.notifyResize()}}enginesChanged_(searchEnginesInfo){this.defaultEngines=searchEnginesInfo.defaults;this.activeEngines=searchEnginesInfo.actives;this.otherEngines=searchEnginesInfo.others;this.extensions=searchEnginesInfo.extensions}onAddSearchEngineClick_(e){e.preventDefault();this.openEditDialog_(null,this.shadowRoot.querySelector("#addSearchEngine"))}computeShowExtensionsList_(){return this.extensions.length>0}computeMatchingEngines_(list){if(this.filter_===""){return list}const filter=this.filter_.toLowerCase();return list.filter((e=>[e.displayName,e.name,e.keyword,e.url].some((term=>term.toLowerCase().includes(filter)))))}showNoResultsMessage_(list,filteredList){return list.length>0&&filteredList.length===0}onKeyboardShortcutSettingChange_(){const spaceEnabled=this.$.keyboardShortcutSettingGroup.selected==="true";this.browserProxy_.recordSearchEnginesPageHistogram(spaceEnabled?SearchEnginesInteractions.KEYBOARD_SHORTCUT_SPACE_OR_TAB:SearchEnginesInteractions.KEYBOARD_SHORTCUT_TAB)}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsSearchEnginesPageElement.is,SettingsSearchEnginesPageElement);function getTemplate$1q(){return html`<!--_html_template_start_-->    <style include="settings-shared">#exceptionHeader{padding:0 var(--cr-section-padding)}
    </style>
    <div id="exceptionHeader">
      <h2>$i18n{siteSettingsCustomizedBehaviors}</h2>
      <div id="exceptionHeaderSubLabel" class="secondary">
        [[description]]
      </div>
    </div>
    <site-list
        category="[[category]]"
        category-subtype="[[contentSettingEnum_.BLOCK]]"
        category-header="[[blockHeader]]"
        read-only-list="[[getReadOnlyList_(readOnlyList, defaultManaged_)]]"
        search-filter="[[searchFilter]]">
    </site-list>
    <site-list
        category="[[category]]"
        category-subtype="[[contentSettingEnum_.SESSION_ONLY]]"
        category-header="$i18n{siteSettingsSessionOnly}"
        read-only-list="[[getReadOnlyList_(readOnlyList, defaultManaged_)]]"
        search-filter="[[searchFilter]]">
    </site-list>
    <site-list
        category="[[category]]"
        category-subtype="[[contentSettingEnum_.ALLOW]]"
        category-header="[[allowHeader]]"
        read-only-list="[[getReadOnlyList_(readOnlyList, defaultManaged_)]]"
        search-filter="[[searchFilter]]"
        hidden$="[[!showAllowSiteList_]]">
    </site-list>
<!--_html_template_end_-->`}const CategorySettingExceptionsElementBase=SiteSettingsMixin(WebUiListenerMixin(PolymerElement));class CategorySettingExceptionsElement extends CategorySettingExceptionsElementBase{static get is(){return"category-setting-exceptions"}static get template(){return getTemplate$1q()}static get properties(){return{description:{type:String,value:function(){return loadTimeData.getString("siteSettingsCustomizedBehaviorsDescription")}},readOnlyList:{type:Boolean,value:false},defaultManaged_:Boolean,blockHeader:String,allowHeader:String,searchFilter:String,showAllowSiteList_:{type:Boolean,computed:"computeShowAllowSiteList_(category)"},contentSettingEnum_:{type:Object,value:ContentSetting}}}static get observers(){return["updateDefaultManaged_(category)"]}ready(){super.ready();this.addWebUiListener("contentSettingCategoryChanged",(()=>this.updateDefaultManaged_()))}computeShowAllowSiteList_(){return this.category!==ContentSettingsTypes.FILE_SYSTEM_WRITE}updateDefaultManaged_(){if(this.category===undefined){return}this.browserProxy.getDefaultValueForContentType(this.category).then((update=>{this.defaultManaged_=update.source===DefaultSettingSource.POLICY}))}getReadOnlyList_(){return this.readOnlyList||this.defaultManaged_}}customElements.define(CategorySettingExceptionsElement.is,CategorySettingExceptionsElement);function getTemplate$1p(){return html`<!--_html_template_start_--><style include="settings-shared">#radioSection{padding:0 var(--cr-section-padding)}#radioGroupSubLabel{padding-bottom:10px}settings-collapse-radio-button{--settings-collapse-toggle-min-height:var(--cr-section-min-height)}settings-collapse-radio-button.two-line{--settings-collapse-toggle-min-height:var(--cr-section-two-line-min-height)}settings-collapse-radio-button:not(:first-of-type){--settings-collapse-separator-line:var(--cr-separator-line)}</style>
<div id="radioSection">
  <h2>[[header]]</h2>
  <div id="radioGroupSubLabel" class="secondary">
    [[description]]
  </div>
  <settings-radio-group
      id="settingsCategoryDefaultRadioGroup"
      pref="{{pref_}}"
      selectable-elements="settings-collapse-radio-button"
      on-change="onSelectedChanged_"
      group-aria-label=[[header]]>
    <settings-collapse-radio-button
        id="enabledRadioOption"
        class$="[[getEnabledButtonClass_(allowOptionSubLabel)]]"
        name="[[siteContentRadioSettingEnum_.ENABLED]]"
        pref="[[pref_]]"
        label="[[allowOptionLabel]]"
        sub-label="[[allowOptionSubLabel]]"
        disabled$="[[isRadioGroupDisabled_(category)]]"
        icon="[[allowOptionIcon]]"
        no-collapse>
    </settings-collapse-radio-button>
    <settings-collapse-radio-button
        id="disabledRadioOption"
        class$="[[getDisabledButtonClass_(blockOptionSubLabel)]]"
        name="[[siteContentRadioSettingEnum_.DISABLED]]"
        pref="[[pref_]]"
        label="[[blockOptionLabel]]"
        sub-label="[[blockOptionSubLabel]]"
        disabled$="[[isRadioGroupDisabled_(category)]]"
        icon="[[blockOptionIcon]]"
        no-collapse>
    </settings-collapse-radio-button>
  </settings-radio-group>
</div>
<!--_html_template_end_-->`}var SiteContentRadioSetting;(function(SiteContentRadioSetting){SiteContentRadioSetting[SiteContentRadioSetting["DISABLED"]=0]="DISABLED";SiteContentRadioSetting[SiteContentRadioSetting["ENABLED"]=1]="ENABLED"})(SiteContentRadioSetting||(SiteContentRadioSetting={}));const SettingsCategoryDefaultRadioGroupElementBase=SiteSettingsMixin(WebUiListenerMixin(PolymerElement));class SettingsCategoryDefaultRadioGroupElement extends SettingsCategoryDefaultRadioGroupElementBase{static get is(){return"settings-category-default-radio-group"}static get template(){return getTemplate$1p()}static get properties(){return{header:{type:String,value(){return loadTimeData.getString("siteSettingsDefaultBehavior")}},description:{type:String,value(){return loadTimeData.getString("siteSettingsDefaultBehaviorDescription")}},allowOptionLabel:String,allowOptionSubLabel:String,allowOptionIcon:String,blockOptionLabel:String,blockOptionSubLabel:String,blockOptionIcon:String,siteContentRadioSettingEnum_:{type:Object,value:SiteContentRadioSetting},pref_:{type:Object,value(){return{type:chrome.settingsPrivate.PrefType.NUMBER,value:-1}}}}}static get observers(){return["onCategoryChanged_(category)"]}selected;ready(){super.ready();this.addWebUiListener("contentSettingCategoryChanged",(category=>this.onCategoryChanged_(category)))}getAllowOptionForCategory_(){switch(this.category){case ContentSettingsTypes.ADS:case ContentSettingsTypes.AUTOMATIC_FULLSCREEN:case ContentSettingsTypes.BACKGROUND_SYNC:case ContentSettingsTypes.FEDERATED_IDENTITY_API:case ContentSettingsTypes.IMAGES:case ContentSettingsTypes.JAVASCRIPT:case ContentSettingsTypes.JAVASCRIPT_OPTIMIZER:case ContentSettingsTypes.MIXEDSCRIPT:case ContentSettingsTypes.PAYMENT_HANDLER:case ContentSettingsTypes.POPUPS:case ContentSettingsTypes.PROTECTED_CONTENT:case ContentSettingsTypes.PROTOCOL_HANDLERS:case ContentSettingsTypes.SENSORS:case ContentSettingsTypes.SOUND:return ContentSetting.ALLOW;case ContentSettingsTypes.AR:case ContentSettingsTypes.AUTO_PICTURE_IN_PICTURE:case ContentSettingsTypes.AUTOMATIC_DOWNLOADS:case ContentSettingsTypes.BLUETOOTH_DEVICES:case ContentSettingsTypes.BLUETOOTH_SCANNING:case ContentSettingsTypes.CAMERA:case ContentSettingsTypes.CAPTURED_SURFACE_CONTROL:case ContentSettingsTypes.CLIPBOARD:case ContentSettingsTypes.FILE_SYSTEM_WRITE:case ContentSettingsTypes.GEOLOCATION:case ContentSettingsTypes.HAND_TRACKING:case ContentSettingsTypes.HID_DEVICES:case ContentSettingsTypes.IDLE_DETECTION:case ContentSettingsTypes.KEYBOARD_LOCK:case ContentSettingsTypes.LOCAL_FONTS:case ContentSettingsTypes.LOCAL_NETWORK_ACCESS:case ContentSettingsTypes.MIC:case ContentSettingsTypes.MIDI_DEVICES:case ContentSettingsTypes.NOTIFICATIONS:case ContentSettingsTypes.POINTER_LOCK:case ContentSettingsTypes.SERIAL_PORTS:case ContentSettingsTypes.SMART_CARD_READERS:case ContentSettingsTypes.STORAGE_ACCESS:case ContentSettingsTypes.USB_DEVICES:case ContentSettingsTypes.VR:case ContentSettingsTypes.WINDOW_MANAGEMENT:case ContentSettingsTypes.WEB_APP_INSTALLATION:case ContentSettingsTypes.WEB_PRINTING:return ContentSetting.ASK;default:assertNotReached("Invalid category: "+this.category)}}getEnabledButtonClass_(){return this.allowOptionSubLabel?"two-line":""}getDisabledButtonClass_(){return this.blockOptionSubLabel?"two-line":""}onSelectedChanged_(){assert(this.pref_.enforcement!==chrome.settingsPrivate.Enforcement.ENFORCED);const allowOption=this.getAllowOptionForCategory_();this.browserProxy.setDefaultValueForContentType(this.category,this.categoryEnabled_?allowOption:ContentSetting.BLOCK);if(this.selected!==this.categoryEnabled_){this.selected=this.categoryEnabled_;this.dispatchEvent(new CustomEvent("selected-changed",{detail:{value:this.selected}}))}}updatePref_(update){if(update.source!==undefined&&update.source!==DefaultSettingSource.PREFERENCE){this.set("pref_.enforcement",chrome.settingsPrivate.Enforcement.ENFORCED);let controlledBy=chrome.settingsPrivate.ControlledBy.USER_POLICY;switch(update.source){case DefaultSettingSource.POLICY:controlledBy=chrome.settingsPrivate.ControlledBy.DEVICE_POLICY;break;case DefaultSettingSource.SUPERVISED_USER:controlledBy=chrome.settingsPrivate.ControlledBy.PARENT;break;case DefaultSettingSource.EXTENSION:controlledBy=chrome.settingsPrivate.ControlledBy.EXTENSION;break}this.set("pref_.controlledBy",controlledBy)}else{this.set("pref_.enforcement",undefined);this.set("pref_.controlledBy",undefined)}const enabled=isSettingEnabled(update.setting);const prefValue=enabled?SiteContentRadioSetting.ENABLED:SiteContentRadioSetting.DISABLED;this.selected=enabled;this.set("pref_.value",prefValue)}async onCategoryChanged_(category){if(category!==this.category){return}const defaultValue=await this.browserProxy.getDefaultValueForContentType(this.category);this.updatePref_(defaultValue)}get categoryEnabled_(){return this.pref_.value===SiteContentRadioSetting.ENABLED}isRadioGroupDisabled_(){return this.category===ContentSettingsTypes.POPUPS&&loadTimeData.getBoolean("isGuest")}}customElements.define(SettingsCategoryDefaultRadioGroupElement.is,SettingsCategoryDefaultRadioGroupElement);const styleMod$1=document.createElement("dom-module");styleMod$1.appendChild(html`
  <template>
    <style include="cr-shared-style search-highlight-style">
.content-settings-header,.radio-group{padding:0 var(--cr-section-padding)}.radio-group-sub-heading{padding-bottom:10px}.padded-radio-section{padding-inline-start:50px}.cpss-heading{padding-bottom:13px;padding-top:13px}settings-collapse-radio-button{--settings-collapse-toggle-min-height:var(--cr-section-min-height)}settings-collapse-radio-button.two-line{--settings-collapse-toggle-min-height:var(--cr-section-two-line-min-height)}settings-collapse-radio-button:not(:first-of-type){--settings-collapse-separator-line:var(--cr-separator-line)}#exceptionHeader{padding:0 var(--cr-section-padding)}#exceptionHeaderSubLabel{padding-bottom:10px}
    </style>
  </template>
`.content);styleMod$1.register("site-settings-shared");function getTemplate$1o(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsAds}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsAdsDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.ADS]]"
      allow-option-label="$i18n{siteSettingsAdsAllowed}"
      allow-option-icon="privacy:web-asset"
      block-option-label="$i18n{siteSettingsAdsBlocked}"
      block-option-icon="privacy:web-asset-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.ADS]]"
      read-only-list
      allow-header="$i18n{siteSettingsAdsAllowedExceptions}"
      block-header="$i18n{siteSettingsAdsBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const AdsPageElementBase=SettingsViewMixin(PolymerElement);class AdsPageElement extends AdsPageElementBase{static get is(){return"settings-ads-page"}static get template(){return getTemplate$1o()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(AdsPageElement.is,AdsPageElement);const div=document.createElement("div");div.innerHTML=getTrustedHTML`<cr-iconset name="all-sites" size="20">
  <svg>
    <defs>
      <g id="logout" width="24px" height="24px" viewBox="0 0 24 24" fill="#757575"><path d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm0 3c1.66 0 3 1.34 3 3s-1.34 3-3 3-3-1.34-3-3 1.34-3 3-3zm0 14.2c-2.5 0-4.71-1.28-6-3.22.03-1.99 4-3.08 6-3.08 1.99 0 5.97 1.09 6 3.08-1.29 1.94-3.5 3.22-6 3.22z"></path><path d="M0 0h24v24H0z" fill="none"></path></g>
      <g id="offline" viewBox="0 0 24 24" width="24px" height="24px" fill="#757575"><path clip-path="url(#b)" d="M12 2C6.5 2 2 6.5 2 12s4.5 10 10 10 10-4.5 10-10S17.5 2 12 2zm5 16H7v-2h10v2zm-6.7-4L7 10.7l1.4-1.4 1.9 1.9 5.3-5.3L17 7.3 10.3 14z"></path></g>
      <g id="tag" width="24px" height="24px" viewBox="0 0 24 24"><path transform="scale(-1, 1) translate(-24, 0)" d="M14.25 21.4q-.575.575-1.425.575-.85 0-1.425-.575l-8.8-8.8q-.275-.275-.437-.65Q2 11.575 2 11.15V4q0-.825.588-1.413Q3.175 2 4 2h7.15q.425 0 .8.162.375.163.65.438l8.8 8.825q.575.575.575 1.412 0 .838-.575 1.413ZM12.825 20l7.15-7.15L11.15 4H4v7.15ZM6.5 8q.625 0 1.062-.438Q8 7.125 8 6.5t-.438-1.062Q7.125 5 6.5 5t-1.062.438Q5 5.875 5 6.5t.438 1.062Q5.875 8 6.5 8ZM4 4Z"></g>
    </defs>
  </svg>
</cr-iconset>
`;const iconsets=div.querySelectorAll("cr-iconset");for(const iconset of iconsets){document.head.appendChild(iconset)}const styleMod=document.createElement("dom-module");styleMod.appendChild(html`
  <template>
    <style>
.detail-list{margin-top:12px}.detail{align-items:center;display:flex;margin-top:8px}.detail cr-icon{margin-inline-end:16px}
    </style>
  </template>
`.content);styleMod.register("clear-storage-dialog-shared");function getTemplate$1n(){return html`<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">:host{padding:0 var(--cr-section-padding)}.row-aligned{align-items:center;display:flex}#toggleButton{min-height:var(--cr-section-min-height)}.site-representation{display:flex}.second-line{margin-top:0.1em;min-height:1.54em}.data-unit{direction:ltr;unicode-bidi:isolate}.list-frame{padding-inline-end:0}.origin-link{overflow:hidden}.spacing{padding-inline-start:1ch}
    </style>
    <div id="collapseParent" focus-row-container>
      <div class$="list-item [[getClassForIndex_(listIndex)]]">
        <div id="toggleButton" class="start row-aligned two-line text-elide"
            on-click="onSiteEntryClick_" actionable aria-expanded="false">
          <site-favicon url="[[getSiteGroupIcon_(siteGroup)]]"></site-favicon>
          <div class="middle text-elide" id="displayName">
            <div class="site-representation">
              <span class="url-directionality text-elide">
                [[displayName_]]
              </span>
              <span class="secondary"
                  hidden$="[[!siteGroupScheme_(siteGroup)]]">
                &nbsp;$i18nPolymer{siteSettingsSiteRepresentationSeparator}&nbsp;
              </span>
              <span class="secondary"
                  hidden$="[[!siteGroupScheme_(siteGroup)]]">
                [[siteGroupScheme_(siteGroup)]]
              </span>
            </div>
            <div class="second-line secondary">
              <span class="data-unit">[[overallUsageString_]]</span>
              <span id="cookies" hidden$="[[!siteGroup.numCookies]]">
                &middot; [[cookieString_]]
              </span>
              <span id="rwsMembership" hidden$=
                  "[[!isRwsMember_(siteGroup.rwsOwner, isRwsFiltered)]]">
                &middot; [[rwsMembershipLabel_]]
              </span>
              <span id="extensionIdDescription"
                  hidden$="[[!isExtension_(siteGroup)]]">
                &middot; [[extensionIdDescription_(siteGroup)]]
              </span>
            </div>
          </div>
          <template is="dom-if" restamp if="[[shouldShowPolicyPrefIndicator_(
                            siteGroup.rwsEnterpriseManaged)]]">
            <cr-policy-pref-indicator
                id="rwsPolicy" pref="[[rwsEnterprisePref_]]"
                icon-aria-label="[[label]]"
                focus-row-control focus-type="policy">
            </cr-policy-pref-indicator>
          </template>
          <cr-icon-button id="expandIcon" class="icon-expand-more"
              hidden$="[[!grouped_(siteGroup)]]" aria-label$="[[displayName_]]"
              aria-describedby="displayName" aria-expanded="false"
              focus-row-control focus-type="expand"></cr-icon-button>
          <cr-icon-button class="subpage-arrow"
              hidden$="[[grouped_(siteGroup)]]"
              aria-label$="[[getSubpageLabel_(siteGroup.displayName)]]"
              aria-roledescription="$i18n{subpageArrowRoleDescription}"
              focus-row-control focus-type="show-detail"></cr-icon-button>
        </div>
        <div class="row-aligned">
          <template is="dom-if" if=
              "[[shouldShowOverflowMenu(siteGroup.rwsOwner, isRwsFiltered)]]">
            <div class="separator"></div>
            <cr-icon-button class="icon-more-vert"
                id="rwsOverflowMenuButton"
                title="$i18n{moreActions}"
                on-click="showOverflowMenu_"
                focus-row-control focus-type="more-actions"
                aria-label$="[[getMoreActionsLabel_(siteGroup)]]">
            </cr-icon-button>
          </template>
          <template is="dom-if" if=
              "[[!shouldShowOverflowMenu(siteGroup.rwsOwner, isRwsFiltered)]]">
            <div class="separator"></div>
            <cr-icon-button class="icon-delete-gray" id="removeSiteButton"
                title$=
                  "[[i18n('siteSettingsCookieRemoveSite', displayName_)]]"
                on-click="onRemove_" focus-row-control focus-type="remove">
            </cr-icon-button>
          </template>
        </div>
      </div>

      <cr-lazy-render id="originList">
        <template>
          <cr-collapse id="collapseChild" no-animation>
            <div class="list-frame">
              <template is="dom-repeat" items="[[siteGroup.origins]]">
                <div class="list-item hr">
                  <div class="start row-aligned list-item origin-link"
                       on-click="onOriginClick_"
                       actionable$="[[!item.isPartitioned]]">
                    <site-favicon url="[[item.origin]]"></site-favicon>
                    <div class="site-representation middle text-elide">
                      <span id="originSiteRepresentation"
                          class="url-directionality text-elide">
                        [[originRepresentation(item.origin)]]
                      </span>
                      <span class="secondary"
                          hidden$="[[!originScheme_(item)]]">
                        &nbsp;
                        $i18nPolymer{siteSettingsSiteRepresentationSeparator}
                        &nbsp;
                      </span>
                      <span class="secondary"
                          hidden$="[[!originScheme_(item)]]">
                        [[originScheme_(item)]]
                      </span>
                      <!--Define a spacing span so that when the direction is
                         rtl, the spacing is still showing correctly. This is
                         because the data-unit class is set to be ltr so the
                         padding will be in wrong place if we put padding in
                         that span.-->
                      <span class="spacing" hidden$="[[!item.usage]]"></span>
                      <span class="secondary data-unit"
                            hidden$="[[!item.usage]]">
                        [[originUsagesItem_(originUsages_.*, index)]]
                      </span>
                      <span class="secondary" hidden$="[[!item.numCookies]]">
                          &nbsp;&middot;
                          [[originCookiesItem_(cookiesNum_.*, index)]]
                      </span>
                      <span class="secondary" hidden$="[[!item.isPartitioned]]">
                          &nbsp;&middot;
                          $i18n{siteSettingsSiteEntryPartitionedLabel}
                      </span>
                    </div>
                    <cr-icon-button class="subpage-arrow"
                        hidden$="[[item.isPartitioned]]"
                        aria-label$="[[getOriginSubpageLabel_(item.origin)]]"
                        aria-roledescription=
                            "$i18n{subpageArrowRoleDescription}"
                        focus-row-control focus-type="detailed-sites">
                    </cr-icon-button>
                  </div>
                  <div class="row-aligned">
                    <div class="separator"></div>
                    <cr-icon-button class="icon-delete-gray"
                        id="removeOriginButton"
                        title$="[[getRemoveOriginButtonTitle_(item.origin)]]"
                        data-origin$="[[item.origin]]" data-context="origin"
                        data-partitioned$="[[item.isPartitioned]]"
                        on-click="onRemove_" focus-row-control
                        focus-type="remove">
                    </cr-icon-button>
                  </div>
                </div>
              </template>
            </div>
          </cr-collapse>
      </template>
    </cr-lazy-render>
    </div>
<!--_html_template_end_-->`}const SiteEntryElementBase=FocusRowMixin(BaseMixin(SiteSettingsMixin(I18nMixin(PolymerElement))));class SiteEntryElement extends SiteEntryElementBase{static get is(){return"site-entry"}static get template(){return getTemplate$1n()}static get properties(){return{siteGroup:{type:Object,observer:"onSiteGroupChanged_"},displayName_:String,cookieString_:String,rwsMembershipLabel_:{type:String,value:""},rwsEnterprisePref_:Object,isRwsFiltered:Boolean,listIndex:{type:Number,value:-1},overallUsageString_:String,originUsages_:{type:Array,value(){return[]}},cookiesNum_:{type:Array,value(){return[]}},sortMethod:{type:String,observer:"updateOrigins_"}}}static get observers(){return["updateRwsMembershipLabel_(siteGroup.rwsNumMembers, siteGroup.rwsOwner)","updatePolicyPref_(siteGroup.rwsEnterpriseManaged)","updateFocus_(siteGroup.rwsOwner)"]}button_=null;eventTracker_=new EventTracker;disconnectedCallback(){super.disconnectedCallback();if(this.button_){this.eventTracker_.remove(this.button_,"keydown")}}onButtonKeydown_(e){if(e.shiftKey&&e.key==="Tab"){this.focus()}}grouped_(siteGroup){if(!siteGroup){return false}if(siteGroup.origins.length>1||siteGroup.numCookies>siteGroup.origins[0].numCookies||siteGroup.origins.some((o=>o.isPartitioned))){return true}return false}siteGroupRepresentation_(siteGroup){if(!siteGroup){return""}return siteGroup.displayName}onSiteGroupChanged_(siteGroup){if(this.button_){this.eventTracker_.remove(this.button_,"keydown")}this.button_=this.shadowRoot.querySelector("#toggleButton *:not([hidden])");assert(this.button_);this.eventTracker_.add(this.button_,"keydown",(e=>this.onButtonKeydown_(e)));if(!this.grouped_(siteGroup)){const collapseChild=this.$.originList.getIfExists();if(collapseChild&&collapseChild.opened){this.toggleCollapsible_()}}if(!siteGroup){return}this.calculateUsageInfo_(siteGroup);this.getCookieNumString_(siteGroup.numCookies).then((string=>{this.cookieString_=string}));this.updateOrigins_(this.sortMethod);this.displayName_=this.siteGroupRepresentation_(siteGroup)}siteGroupScheme_(siteGroup){if(!siteGroup||this.grouped_(siteGroup)){return""}return this.originScheme_(siteGroup.origins[0])}originScheme_(origin){const url=this.toUrl(origin.origin);const scheme=url.protocol.replace(new RegExp(":*$"),"");const HTTPS_SCHEME="https";if(scheme===HTTPS_SCHEME){return""}return scheme}getSiteGroupIcon_(siteGroup){const origins=siteGroup.origins;assert(origins);assert(origins.length>=1);if(origins.length===1){return origins[0].origin}for(const originInfo of origins){if(siteGroup.etldPlus1&&this.toUrl(originInfo.origin).host==="www."+siteGroup.etldPlus1){return originInfo.origin}}const getMaxStorage=(max,originInfo)=>max.usage>originInfo.usage||max.usage===originInfo.usage&&max.numCookies>originInfo.numCookies?max:originInfo;return origins.reduce(getMaxStorage,origins[0]).origin}calculateUsageInfo_(siteGroup){let overallUsage=0;siteGroup.origins.forEach((originInfo=>{overallUsage+=originInfo.usage}));this.browserProxy.getFormattedBytes(overallUsage).then((string=>{this.overallUsageString_=string}))}isRwsMember_(){return!!this.siteGroup&&this.siteGroup.rwsOwner!==undefined}shouldShowOverflowMenu(){return this.isRwsMember_()&&!this.isRwsFiltered}getCookieNumString_(numCookies){if(numCookies===0){return Promise.resolve("")}return this.browserProxy.getNumCookiesString(numCookies)}updateRwsMembershipLabel_(){if(!this.siteGroup.rwsOwner){this.rwsMembershipLabel_=""}else{this.browserProxy.getRwsMembershipLabel(this.siteGroup.rwsNumMembers,this.siteGroup.rwsOwner).then((label=>this.rwsMembershipLabel_=label))}}shouldShowPolicyPrefIndicator_(){return!!this.siteGroup.rwsEnterpriseManaged}updatePolicyPref_(){this.rwsEnterprisePref_=this.siteGroup.rwsEnterpriseManaged?Object.assign({enforcement:chrome.settingsPrivate.Enforcement.ENFORCED,controlledBy:chrome.settingsPrivate.ControlledBy.DEVICE_POLICY}):Object.assign({enforcement:undefined,controlledBy:undefined})}updateFocus_(){const isCurrentlyFocused=this.isFocused;afterNextRender(this,(()=>{if(isCurrentlyFocused){(this.shouldShowOverflowMenu()?this.$$("#rwsOverflowMenuButton"):this.$$("#removeSiteButton")).focus()}}))}originUsagesItem_(change,index){return change.base[index]}originCookiesItem_(change,index){return change.base[index]}navigateToSiteDetails_(origin){this.fire("site-entry-selected",{item:this.siteGroup,index:this.listIndex});Router.getInstance().navigateTo(routes.SITE_SETTINGS_SITE_DETAILS,new URLSearchParams("site="+origin))}onOriginClick_(e){if(this.siteGroup.origins[e.model.index].isPartitioned){return}this.navigateToSiteDetails_(this.siteGroup.origins[e.model.index].origin);this.browserProxy.recordAction(AllSitesAction2.ENTER_SITE_DETAILS);chrome.metricsPrivate.recordUserAction("AllSites_EnterSiteDetails")}onSiteEntryClick_(){if(!this.grouped_(this.siteGroup)){this.navigateToSiteDetails_(this.siteGroup.origins[0].origin);this.browserProxy.recordAction(AllSitesAction2.ENTER_SITE_DETAILS);chrome.metricsPrivate.recordUserAction("AllSites_EnterSiteDetails");return}this.toggleCollapsible_();this.scrollIntoViewIfNeeded()}toggleCollapsible_(){const collapseChild=this.$.originList.get();collapseChild.toggle();this.$.toggleButton.setAttribute("aria-expanded",collapseChild.opened?"true":"false");this.$.expandIcon.setAttribute("aria-expanded",collapseChild.opened?"true":"false");this.$.expandIcon.classList.toggle("icon-expand-more");this.$.expandIcon.classList.toggle("icon-expand-less");this.fire("iron-resize")}showOverflowMenu_(e){this.fire("open-menu",{target:e.target,index:this.listIndex,item:this.siteGroup,origin:e.target.dataset["origin"],isPartitioned:e.target.dataset["partitioned"],actionScope:e.target.dataset["context"]})}onRemove_(e){this.fire("remove-site",{target:e.target,index:this.listIndex,item:this.siteGroup,origin:e.target.dataset["origin"],isPartitioned:e.target.dataset["partitioned"]!==undefined,actionScope:e.target.dataset["context"]})}getClassForIndex_(index){return index>0?"hr":""}getSubpageLabel_(target){return this.i18n("siteSettingsSiteDetailsSubpageAccessibilityLabel",target)}getOriginSubpageLabel_(origin){return this.getSubpageLabel_(this.originRepresentation(origin))}getRemoveOriginButtonTitle_(origin){return this.i18n("siteSettingsCookieRemoveSite",this.originRepresentation(origin))}getMoreActionsLabel_(){return this.i18n("relatedWebsiteSetsMoreActionsTitle",this.siteGroup.displayName)}updateOrigins_(sortMethod){if(!sortMethod||!this.siteGroup||!this.grouped_(this.siteGroup)){return}const origins=this.siteGroup.origins.slice();origins.sort(this.sortFunction_(sortMethod));this.set("siteGroup.origins",origins);this.originUsages_=new Array(origins.length);origins.forEach(((originInfo,i)=>{this.browserProxy.getFormattedBytes(originInfo.usage).then((string=>{this.set(`originUsages_.${i}`,string)}))}));this.cookiesNum_=new Array(this.siteGroup.origins.length);origins.forEach(((originInfo,i)=>{this.getCookieNumString_(originInfo.numCookies).then((string=>{this.set(`cookiesNum_.${i}`,string)}))}))}sortFunction_(sortMethod){if(sortMethod===SortMethod.MOST_VISITED){return(origin1,origin2)=>(origin1.isPartitioned?1:0)-(origin2.isPartitioned?1:0)||origin2.engagement-origin1.engagement}else if(sortMethod===SortMethod.STORAGE){return(origin1,origin2)=>(origin1.isPartitioned?1:0)-(origin2.isPartitioned?1:0)||origin2.usage-origin1.usage||origin2.numCookies-origin1.numCookies}else if(sortMethod===SortMethod.NAME){return(origin1,origin2)=>(origin1.isPartitioned?1:0)-(origin2.isPartitioned?1:0)||origin1.origin.localeCompare(origin2.origin)}assertNotReached()}extensionIdDescription_(siteGroup){const id=this.originRepresentation(siteGroup.origins[0].origin);return loadTimeData.getStringF("siteSettingsExtensionIdDescription",id)}isExtension_(siteGroup){return this.siteGroupScheme_(siteGroup)==="chrome-extension"}}customElements.define(SiteEntryElement.is,SiteEntryElement);function getTemplate$1m(){return html`<!--_html_template_start_-->  <style include="settings-shared md-select clear-storage-dialog-shared">cr-dialog div[slot=title]{line-height:20px}#sort{align-items:center;display:flex;margin:0 var(--cr-icon-button-margin-start);margin-bottom:8px;padding:0 var(--cr-section-padding)}#sortMethod{margin-inline-start:1em}.list-frame.without-heading{padding-inline-start:var(--cr-section-padding)}#clearAllContainer{align-items:center;display:flex;height:var(--cr-section-two-line-min-height);justify-content:space-between;margin:0 var(--cr-icon-button-margin-start);padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding)}#relatedWebsiteSetsLearnMore{margin:0 var(--cr-icon-button-margin-start);padding-bottom:16px;padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding);width:60%}#relatedWebsiteSetsDescription{margin:0 var(--cr-icon-button-margin-start);padding-bottom:8px;padding-inline-end:var(--cr-section-padding);padding-inline-start:var(--cr-section-padding)}#clearAllButton cr-button{white-space:nowrap}
  </style>
  <settings-subpage page-title="$i18n{siteSettingsAllSites}"
      search-label="$i18n{siteSettingsAllSitesFilter}"
      search-icon="settings20:filter-list"
      search-term="{{filter}}" preserve-search-term route-path$="[[routePath]]"
      hide-close-button>
    <div id="sort">
      <label id="sortLabel">$i18n{siteSettingsAllSitesSort}</label>
      <select id="sortMethod" class="md-select" aria-labelledby="sortLabel"
          on-change="onSortMethodChanged_">
        <option value="[[sortMethodEnum_.MOST_VISITED]]">
          $i18n{siteSettingsAllSitesSortMethodMostVisited}
        </option>
        <option value="[[sortMethodEnum_.STORAGE]]">
          $i18n{siteSettingsAllSitesSortMethodStorage}
        </option>
        <option value="[[sortMethodEnum_.NAME]]">
          $i18n{siteSettingsAllSitesSortMethodName}
        </option>
      </select>
    </div>
    <div id="clearAllContainer">
      <div id="clearLabel">
          [[getClearStorageDescription_(totalUsage_, filter, filteredList_)]]
      </div>
      <div id="clearAllButton"
          hidden$="[[!shouldShowClearAllButton_(filteredList_.length)]]">
        <cr-button type="button" on-click="onConfirmClearAllData_">
          [[getClearDataButtonString_(filter)]]
        </cr-button>
      </div>
    </div>
    <div id="relatedWebsiteSetsLearnMore"
        hidden$="[[!hasFilteredRwsSites_(filter, filteredList_)]]">
      [[getRwsLearnMoreLabel_(filter)]]
      <a href="$i18n{relatedWebsiteSetsLearnMoreURL}"
          aria-label="$i18n{siteSettingsRelatedWebsiteSetsLearnMoreAccessibility}">
        $i18n{learnMore}
      </a>
    </div>
    <div class="list-frame" hidden$="[[!siteGroupMapEmpty_(siteGroupMap)]]">
      <div class="list-item secondary">$i18n{emptyAllSitesPage}</div>
    </div>
    <div id="noSitesFoundText" class="list-frame"
        hidden$="[[!noSearchResultFound_(filteredList_)]]">
      <div class="list-item secondary">$i18n{noSitesFound}</div>
    </div>
    <div class="list-frame without-heading" id="listContainer">
      <iron-list id="allSitesList"
          items="[[filteredList_]]"
          scroll-target="[[subpageScrollTarget]]">
        <template>
          <site-entry site-group="[[item]]" list-index="[[index]]"
              iron-list-tab-index="[[tabIndex]]"
              focus-row-index="[[index]]"
              tabindex$="[[tabIndex]]"
              last-focused="{{lastFocused_}}"
              list-blurred="{{listBlurred_}}"
              sort-method="[[sortMethod_]]"
              is-rws-filtered="[[isRwsFiltered_(filter)]]">
          </site-entry>
        </template>
      </iron-list>
    </div>

    <!-- Overflow menu. -->
    <cr-lazy-render id="menu">
      <template>
        <cr-action-menu role-description="$i18n{menu}">
          <button class="dropdown-item" role="menuitem"
              on-click="onShowRelatedSites_">
            $i18n{relatedWebsiteSetsShowRelatedSitesButton}
          </button>
          <button class="dropdown-item" role="menuitem" on-click="onRemove_">
            $i18n{relatedWebsiteSetsSiteDeleteStorageButton}
          </button>
        </cr-action-menu>
      </template>
    </cr-lazy-render>

    <!-- Confirm remove site dialog. -->
    <cr-lazy-render id="confirmRemoveSite">
      <template>
        <cr-dialog close-text="$i18n{close}">
          <div id="removeSiteTitle" slot="title">
            [[getRemoveSiteTitle_(actionMenuModel_)]]
          </div>
          <div slot="body">
            <div id="logoutBulletPoint" class="detail">
              <cr-icon icon="all-sites:logout" aria-hidden="true"
                role="presentation"></cr-icon>
              [[getRemoveSiteLogoutBulletPoint_(actionMenuModel_)]]
            </div>
            <div class="detail">
              <cr-icon icon="all-sites:offline" aria-hidden="true"
                role="presentation"></cr-icon>
              $i18n{siteSettingsRemoveSiteOfflineData}
            </div>
            <div id="permissionsBulletPoint" class="detail"
                hidden$="[[!showPermissionsBulletPoint_(actionMenuModel_)]]">
              <cr-icon icon="privacy:page-info"></cr-icon>
              $i18n{siteSettingsRemoveSitePermissions}
            </div>
          </div>
          <div slot="button-container">
            <cr-button class="cancel-button" on-click="onCloseDialog_">
              $i18n{cancel}
            </cr-button>
            <cr-button class="action-button" on-click="onConfirmRemoveSite_">
              $i18n{siteSettingsRemoveSiteConfirm}
            </cr-button>
          </div>
        </cr-dialog>
      </template>
    </cr-lazy-render>

    <!-- Confirm clear all data dialog. -->
    <cr-lazy-render id="confirmClearAllData">
      <template>
        <cr-dialog close-text="$i18n{close}">
          <div slot="title">[[getClearAllStorageDialogTitle_(filter)]]</div>
          <div slot="body">
            <div id="clearAllStorageDialogDescription">
              [[getClearAllStorageDialogDescription_(totalUsage_,
                  filteredList_)]]
            </div>
            <div class="detail-list">
              <div id="clearAllStorageDialogSignOutLabel" class="detail">
                <cr-icon icon="all-sites:logout" aria-hidden="true"
                  role="presentation"></cr-icon>
                [[getClearAllStorageDialogSignOutLabel_(filter)]]
              </div>
              <div class="detail">
                <cr-icon icon="all-sites:offline" aria-hidden="true"
                  role="presentation"></cr-icon>
                $i18n{siteSettingsSiteGroupDeleteOfflineData}
              </div>
            </div>
          </div>
          <div slot="button-container">
            <cr-button class="cancel-button" on-click="onCloseDialog_">
              $i18n{cancel}
            </cr-button>
            <cr-button class="action-button" on-click="onClearAllData_">
              $i18n{siteSettingsSiteClearStorage}
            </cr-button>
          </div>
        </cr-dialog>
      </template>
    </cr-lazy-render>
  </settings-subpage>
<!--_html_template_end_-->`}const AllSitesElementBase=SettingsViewMixin(GlobalScrollTargetMixin(WebUiListenerMixin(I18nMixin(SiteSettingsMixin(PolymerElement)))));const RWS_RELATED_SEARCH_PREFIX="related:";class AllSitesElement extends AllSitesElementBase{static get is(){return"all-sites"}static get template(){return getTemplate$1m()}static get properties(){return{siteGroupMap:{type:Object,value(){return new Map}},filteredList_:{type:Array},subpageRoute:{type:Object,value:routes.SITE_SETTINGS_ALL,readOnly:true},filter:{type:String,value:"",observer:"forceListUpdate_"},sortMethodEnum_:{type:Object,value:SortMethod,readOnly:true},selectedItem_:Object,lastFocused_:Object,listBlurred_:Boolean,actionMenuModel_:Object,clearAllData_:Boolean,sortMethod_:String,totalUsage_:{type:String,value:"0 B"}}}metricsBrowserProxy=MetricsBrowserProxyImpl.getInstance();ready(){super.ready();this.addWebUiListener("onStorageListFetched",this.onStorageListFetched.bind(this));this.addEventListener("site-entry-selected",(e=>{this.selectedItem_=e.detail}));this.addEventListener("open-menu",this.onOpenMenu_.bind(this));this.addEventListener("remove-site",this.onRemoveSite_.bind(this));const sortParam=Router.getInstance().getQueryParameters().get("sort");if(sortParam!==null&&Object.values(SortMethod).includes(sortParam)){this.$.sortMethod.value=sortParam}this.sortMethod_=this.$.sortMethod.value}connectedCallback(){super.connectedCallback();afterNextRender(this,(()=>{this.$.allSitesList.scrollOffset=this.$.allSitesList.offsetTop}))}currentRouteChanged(currentRoute,oldRoute){super.currentRouteChanged(currentRoute,oldRoute);if(currentRoute===routes.SITE_SETTINGS_ALL&&currentRoute!==oldRoute){this.populateList_()}}populateList_(){this.browserProxy.getAllSites().then((response=>{const newMap=new Map(this.siteGroupMap);response.forEach((siteGroup=>{newMap.set(siteGroup.groupingKey,siteGroup)}));this.siteGroupMap=newMap;this.forceListUpdate_()}))}onStorageListFetched(list){const newMap=new Map(this.siteGroupMap);list.forEach((storageSiteGroup=>{newMap.set(storageSiteGroup.groupingKey,storageSiteGroup)}));this.siteGroupMap=newMap;this.forceListUpdate_();this.focusOnLastSelectedEntry_()}updateTotalUsage_(){let usageSum=0;for(const siteGroup of this.filteredList_){siteGroup.origins.forEach((origin=>{usageSum+=origin.usage}))}this.browserProxy.getFormattedBytes(usageSum).then((totalUsage=>{this.totalUsage_=totalUsage}))}filterPopulatedList_(siteGroupMap,searchQuery){const result=[];for(const[_groupingKey,siteGroup]of siteGroupMap){if(this.isRwsFiltered_()){const rwsOwnerFilter=this.filter.substring(this.filter.indexOf(":")+1);if(siteGroup.rwsOwner&&siteGroup.rwsOwner===rwsOwnerFilter){result.push(siteGroup)}}else{if(siteGroup.origins.find((originInfo=>originInfo.origin.includes(searchQuery)))){result.push(siteGroup)}}}return this.sortSiteGroupList_(result)}sortSiteGroupList_(siteGroupList){const sortMethod=this.$.sortMethod.value;if(!sortMethod){return siteGroupList}if(sortMethod===SortMethod.MOST_VISITED){siteGroupList.sort(this.mostVisitedComparator_)}else if(sortMethod===SortMethod.STORAGE){siteGroupList.sort(this.storageComparator_)}else if(sortMethod===SortMethod.NAME){siteGroupList.sort(this.nameComparator_)}return siteGroupList}mostVisitedComparator_(siteGroup1,siteGroup2){const getMaxEngagement=(max,originInfo)=>max>originInfo.engagement?max:originInfo.engagement;const score1=siteGroup1.origins.reduce(getMaxEngagement,0);const score2=siteGroup2.origins.reduce(getMaxEngagement,0);return score2-score1}storageComparator_(siteGroup1,siteGroup2){const getOverallUsage=siteGroup=>{let usage=0;siteGroup.origins.forEach((originInfo=>{usage+=originInfo.usage}));return usage};const siteGroup1Size=getOverallUsage(siteGroup1);const siteGroup2Size=getOverallUsage(siteGroup2);return siteGroup2Size-siteGroup1Size||siteGroup2.numCookies-siteGroup1.numCookies}nameComparator_(siteGroup1,siteGroup2){return siteGroup1.displayName.localeCompare(siteGroup2.displayName)}onSortMethodChanged_(){this.sortMethod_=this.$.sortMethod.value;this.filteredList_=this.sortSiteGroupList_(this.filteredList_);this.$.allSitesList.fire("iron-resize")}forceListUpdate_(){this.filteredList_=this.filterPopulatedList_(this.siteGroupMap,this.filter);this.updateTotalUsage_();this.$.allSitesList.fire("iron-resize")}forceListUpdateForTesting(){this.forceListUpdate_()}siteGroupMapEmpty_(){return!this.siteGroupMap.size}noSearchResultFound_(){return!this.filteredList_.length&&!this.siteGroupMapEmpty_()}focusOnLastSelectedEntry_(){if(!this.selectedItem_||this.siteGroupMap.size===0){return}const index=Math.max(0,Math.min(this.selectedItem_.index,this.siteGroupMap.size));this.$.allSitesList.focusItem(index);this.selectedItem_=null}onOpenMenu_(e){const index=e.detail.index;const list=this.$.allSitesList;if(index<list.firstVisibleIndex||index>list.lastVisibleIndex){list.scrollToIndex(index)}const target=e.detail.target;this.actionMenuModel_=e.detail;this.$.menu.get().showAt(target)}shouldShowClearAllButton_(){return this.filteredList_.length>0}hasFilteredRwsSites_(){return this.isRwsFiltered_()&&this.filteredList_&&this.filteredList_.length>0}onShowRelatedSites_(){this.browserProxy.recordAction(AllSitesAction2.FILTER_BY_FPS_OWNER);this.$.menu.get().close();const siteGroup=this.filteredList_[this.actionMenuModel_.index];const searchParams=new URLSearchParams("searchSubpage="+encodeURIComponent(RWS_RELATED_SEARCH_PREFIX+siteGroup.rwsOwner));const currentRoute=Router.getInstance().getCurrentRoute();Router.getInstance().navigateTo(currentRoute,searchParams)}onRemoveSite_(e){this.actionMenuModel_=e.detail;this.$.confirmRemoveSite.get().showModal()}onRemove_(){this.$.confirmRemoveSite.get().showModal()}generatePlaceholderOrigin_(numCookies,origin,etldPlus1){return{origin:etldPlus1?`http://${etldPlus1}/`:origin,engagement:0,usage:0,numCookies:numCookies,hasPermissionSettings:false,isInstalled:false,isPartitioned:false}}onConfirmRemoveSite_(e){const{index:index,actionScope:actionScope,origin:origin,isPartitioned:isPartitioned}=this.actionMenuModel_;const siteGroupToUpdate=this.filteredList_[index];const updatedSiteGroup={groupingKey:siteGroupToUpdate.groupingKey,displayName:siteGroupToUpdate.displayName,hasInstalledPWA:siteGroupToUpdate.hasInstalledPWA,numCookies:siteGroupToUpdate.numCookies,rwsOwner:siteGroupToUpdate.rwsOwner,rwsNumMembers:siteGroupToUpdate.rwsNumMembers,origins:[]};this.metricsBrowserProxy.recordDeleteBrowsingDataAction(DeleteBrowsingDataAction.SITES_SETTINGS_PAGE);if(actionScope==="origin"){if(isPartitioned){this.browserProxy.recordAction(AllSitesAction2.REMOVE_ORIGIN_PARTITIONED);this.browserProxy.clearPartitionedOriginDataAndCookies(this.toUrl(origin).href,siteGroupToUpdate.groupingKey)}else{this.browserProxy.recordAction(AllSitesAction2.REMOVE_ORIGIN);this.browserProxy.clearUnpartitionedOriginDataAndCookies(this.toUrl(origin).href);this.resetPermissionsForOrigin_(origin)}updatedSiteGroup.origins=siteGroupToUpdate.origins.filter((o=>o.isPartitioned!==isPartitioned||o.origin!==origin));updatedSiteGroup.hasInstalledPWA=updatedSiteGroup.origins.some((o=>o.isInstalled));updatedSiteGroup.numCookies-=siteGroupToUpdate.origins.find((o=>o.isPartitioned===isPartitioned&&o.origin===origin)).numCookies;if(updatedSiteGroup.origins.length===0&&updatedSiteGroup.numCookies>0){const originPlaceHolder=this.generatePlaceholderOrigin_(updatedSiteGroup.numCookies,origin,updatedSiteGroup.etldPlus1);updatedSiteGroup.origins.push(originPlaceHolder)}}else{this.browserProxy.recordAction(AllSitesAction2.REMOVE_SITE_GROUP);this.browserProxy.clearSiteGroupDataAndCookies(siteGroupToUpdate.groupingKey);siteGroupToUpdate.origins.forEach((originEntry=>{this.resetPermissionsForOrigin_(originEntry.origin)}));if(updatedSiteGroup.rwsOwner){this.decrementRwsNumMembers_(updatedSiteGroup.rwsOwner)}}this.updateSiteGroup_(index,updatedSiteGroup);this.$.allSitesList.fire("iron-resize");this.updateTotalUsage_();this.onCloseDialog_(e)}isFiltered_(){return this.filter!==""}isRwsFiltered_(){return this.filter.startsWith(RWS_RELATED_SEARCH_PREFIX)}getRwsLearnMoreLabel_(){const rwsOwner=this.filter.substring(this.filter.indexOf(":")+1);return loadTimeData.getStringF("siteSettingsRelatedWebsiteSetsLearnMore",rwsOwner)}getClearDataButtonString_(){return this.i18n(this.isFiltered_()?"siteSettingsDeleteDisplayedStorageLabel":"siteSettingsDeleteAllStorageLabel")}getClearStorageDescription_(){const descriptionId=this.isFiltered_()?"siteSettingsClearDisplayedStorageDescription":"siteSettingsClearAllStorageDescription";return loadTimeData.substituteString(this.i18n(descriptionId),this.totalUsage_)}onConfirmClearAllData_(e){e.preventDefault();this.clearAllData_=true;const anyAppsInstalled=this.filteredList_.some((g=>g.hasInstalledPWA));const scopes=[AllSitesDialog.CLEAR_DATA,"All"];const installed=anyAppsInstalled?"Installed":"";this.recordUserAction_([...scopes,installed,"DialogOpened"]);this.$.confirmClearAllData.get().showModal()}onCloseDialog_(e){chrome.metricsPrivate.recordUserAction("AllSites_DialogClosed");e.target.closest("cr-dialog").close();this.actionMenuModel_=null;this.$.menu.get().close()}getRemoveSiteTitle_(){if(this.actionMenuModel_===null){return""}const originScoped=this.actionMenuModel_.actionScope==="origin";const singleOriginSite=!originScoped&&this.actionMenuModel_.item.origins.length===1;if(this.actionMenuModel_.isPartitioned){assert(originScoped);return loadTimeData.substituteString(this.i18n("siteSettingsRemoveSiteOriginPartitionedDialogTitle",this.originRepresentation(this.actionMenuModel_.origin),this.actionMenuModel_.item.displayName))}const numInstalledApps=this.actionMenuModel_.item.origins.filter((o=>!originScoped||this.actionMenuModel_.origin===o.origin)).filter((o=>o.isInstalled)).length;let messageId;if(originScoped||singleOriginSite){if(numInstalledApps===1){messageId="siteSettingsRemoveSiteOriginAppDialogTitle"}else{assert(numInstalledApps===0);messageId="siteSettingsRemoveSiteOriginDialogTitle"}}else{if(numInstalledApps>1){messageId="siteSettingsRemoveSiteGroupAppPluralDialogTitle"}else if(numInstalledApps===1){messageId="siteSettingsRemoveSiteGroupAppDialogTitle"}else{messageId="siteSettingsRemoveSiteGroupDialogTitle"}}let displayOrigin;if(originScoped){displayOrigin=this.actionMenuModel_.origin}else if(singleOriginSite){displayOrigin=this.actionMenuModel_.item.origins[0].origin}else{displayOrigin=this.actionMenuModel_.item.displayName}return loadTimeData.substituteString(this.i18n(messageId),this.originRepresentation(displayOrigin))}getRemoveSiteLogoutBulletPoint_(){if(this.actionMenuModel_===null){return""}const originScoped=this.actionMenuModel_.actionScope==="origin";const singleOriginSite=!originScoped&&this.actionMenuModel_.item.origins.length===1;return originScoped||singleOriginSite?this.i18n("siteSettingsRemoveSiteOriginLogout"):this.i18n("siteSettingsRemoveSiteGroupLogout")}showPermissionsBulletPoint_(){if(this.actionMenuModel_===null){return false}return this.actionMenuModel_.item.origins.filter((o=>this.actionMenuModel_.actionScope!=="origin"||this.actionMenuModel_.origin===o.origin)).some((o=>o.hasPermissionSettings))}getClearAllStorageDialogTitle_(){return this.i18n(this.isFiltered_()?"siteSettingsDeleteDisplayedStorageDialogTitle":"siteSettingsDeleteAllStorageDialogTitle")}getClearAllStorageDialogDescription_(){const anyAppsInstalled=this.filteredList_.some((g=>g.hasInstalledPWA));let messageId;if(anyAppsInstalled){messageId=this.isFiltered_()?"siteSettingsDeleteDisplayedStorageConfirmationInstalled":"siteSettingsDeleteAllStorageConfirmationInstalled"}else{messageId=this.isFiltered_()?"siteSettingsDeleteDisplayedStorageConfirmation":"siteSettingsDeleteAllStorageConfirmation"}return loadTimeData.substituteString(this.i18n(messageId),this.totalUsage_)}getClearAllStorageDialogSignOutLabel_(){return this.i18n(this.isFiltered_()?"siteSettingsClearDisplayedStorageSignOut":"siteSettingsClearAllStorageSignOut")}recordUserAction_(scopes){chrome.metricsPrivate.recordUserAction(["AllSites",...scopes].filter(Boolean).join("_"))}decrementRwsNumMembers_(rwsOwner){this.filteredList_.forEach(((siteGroup,index)=>{if(siteGroup.rwsOwner===rwsOwner){this.set("filteredList_."+index+".rwsNumMembers",siteGroup.rwsNumMembers-1)}}))}resetPermissionsForOrigin_(origin){this.browserProxy.setOriginPermissions(origin,null,ContentSetting.DEFAULT)}clearDataForSiteGroupIndex_(index){const siteGroupToUpdate=this.filteredList_[index];const updatedSiteGroup={groupingKey:siteGroupToUpdate.groupingKey,displayName:siteGroupToUpdate.displayName,hasInstalledPWA:siteGroupToUpdate.hasInstalledPWA,numCookies:0,rwsOwner:siteGroupToUpdate.rwsOwner,rwsNumMembers:siteGroupToUpdate.rwsNumMembers,origins:[]};this.browserProxy.clearSiteGroupDataAndCookies(siteGroupToUpdate.groupingKey);for(let i=0;i<siteGroupToUpdate.origins.length;++i){const updatedOrigin=Object.assign({},siteGroupToUpdate.origins[i]);if(updatedOrigin.hasPermissionSettings){updatedOrigin.numCookies=0;updatedOrigin.usage=0;updatedSiteGroup.origins.push(updatedOrigin)}}this.updateSiteGroup_(index,updatedSiteGroup)}updateSiteGroup_(index,updatedSiteGroup){if(updatedSiteGroup.origins.length>0){this.set("filteredList_."+index,updatedSiteGroup);this.siteGroupMap.set(updatedSiteGroup.groupingKey,updatedSiteGroup)}else{this.splice("filteredList_",index,1);this.siteGroupMap.delete(updatedSiteGroup.groupingKey)}}onClearAllData_(e){this.browserProxy.recordAction(AllSitesAction2.CLEAR_ALL_DATA);const scopes=[AllSitesDialog.CLEAR_DATA,"All"];const anyAppsInstalled=this.filteredList_.some((g=>g.hasInstalledPWA));const installed=anyAppsInstalled?"Installed":"";this.recordUserAction_([...scopes,installed,"Confirm"]);this.metricsBrowserProxy.recordDeleteBrowsingDataAction(DeleteBrowsingDataAction.SITES_SETTINGS_PAGE);if(this.isRwsFiltered_()){this.browserProxy.recordAction(AllSitesAction2.DELETE_FOR_ENTIRE_FPS)}for(let index=this.filteredList_.length-1;index>=0;index--){this.clearDataForSiteGroupIndex_(index)}this.forceListUpdate_();this.totalUsage_="0 B";this.onCloseDialog_(e)}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(AllSitesElement.is,AllSitesElement);function getTemplate$1l(){return html`<!--_html_template_start_--><style include="settings-shared settings-columned-section"></style>
<settings-subpage page-title="$i18n{siteSettingsAntiAbuse}"
    route-path$="[[routePath]]">
  <settings-toggle-button
      id="toggleButton"
      pref="{{pref_}}"
      no-set-pref
      label="$i18n{siteSettingsAntiAbuse}"
      sub-label="$i18n{siteSettingsAntiAbuseDescription}"
      disabled="[[toggleDisabled_]]"
      on-settings-boolean-control-change="onToggleChange_">
  </settings-toggle-button>
  <div class="settings-columned-section">
    <div class="column">
      <h2 class="description-header">$i18n{columnHeadingWhenOn}</h2>
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:archive" aria-hidden="true"></cr-icon>
          <div class="secondary">$i18n{antiAbuseWhenOnSectionOne}</div>
        </li>
        <li>
          <cr-icon icon="settings20:dashboard" aria-hidden="true"></cr-icon>
          <div class="secondary">$i18n{antiAbuseWhenOnSectionTwo}</div>
        </li>
        <li>
          <cr-icon icon="settings20:timer" aria-hidden="true"></cr-icon>
          <div class="secondary">$i18n{antiAbuseWhenOnSectionThree}</div>
        </li>
      </ul>
    </div>
    <div class="column">
      <h2 class="description-header">$i18n{columnHeadingConsider}</h2>
      <ul class="icon-bulleted-list">
        <li>
          <cr-icon icon="settings20:background-replace" aria-hidden="true">
          </cr-icon>
          <div class="secondary">$i18n{antiAbuseThingsToConsiderSectionOne}</div>
        </li>
      </ul>
    </div>
  </div>
</settings-subpage>
<!--_html_template_end_-->`}const AntiAbuseElementBase=SettingsViewMixin(SiteSettingsMixin(WebUiListenerMixin(PolymerElement)));class SettingsAntiAbusePageElement extends AntiAbuseElementBase{static get is(){return"settings-anti-abuse-page"}static get template(){return getTemplate$1l()}static get properties(){return{pref_:{type:Object,value(){return{type:chrome.settingsPrivate.PrefType.BOOLEAN}}},toggleDisabled_:Boolean}}static get observers(){return["onEnforcementChanged_(pref_.enforcement)"]}ready(){super.ready();this.addWebUiListener("contentSettingCategoryChanged",(category=>this.onCategoryChanged_(category)));this.updateToggleValue_()}onCategoryChanged_(category){if(category!==ContentSettingsTypes.ANTI_ABUSE){return}this.updateToggleValue_()}onEnforcementChanged_(enforcement){this.toggleDisabled_=enforcement===chrome.settingsPrivate.Enforcement.ENFORCED}async updateToggleValue_(){const defaultValue=await this.browserProxy.getDefaultValueForContentType(ContentSettingsTypes.ANTI_ABUSE);if(defaultValue.source!==undefined&&defaultValue.source!==DefaultSettingSource.PREFERENCE){this.set("pref_.enforcement",chrome.settingsPrivate.Enforcement.ENFORCED);let controlledBy=chrome.settingsPrivate.ControlledBy.USER_POLICY;switch(defaultValue.source){case DefaultSettingSource.POLICY:controlledBy=chrome.settingsPrivate.ControlledBy.DEVICE_POLICY;break;case DefaultSettingSource.SUPERVISED_USER:controlledBy=chrome.settingsPrivate.ControlledBy.PARENT;break;case DefaultSettingSource.EXTENSION:controlledBy=chrome.settingsPrivate.ControlledBy.EXTENSION;break}this.set("pref_.controlledBy",controlledBy)}else{this.set("pref_.enforcement",null);this.set("pref_.controlledBy",null)}this.set("pref_.value",isSettingEnabled(defaultValue.setting))}onToggleChange_(){this.browserProxy.setDefaultValueForContentType(ContentSettingsTypes.ANTI_ABUSE,this.$.toggleButton.checked?ContentSetting.ALLOW:ContentSetting.BLOCK)}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsAntiAbusePageElement.is,SettingsAntiAbusePageElement);function getTemplate$1k(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsAr}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsArDescription}
  </div>
  <!-- TODO(crbug.com/40176677): Fix redesign string when available.-->
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.AR]]"
      allow-option-label="$i18n{siteSettingsArAsk}"
      allow-option-icon="privacy:cardboard"
      block-option-label="$i18n{siteSettingsArBlock}"
      block-option-icon="privacy:cardboard-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.AR]]"
      read-only-list
      allow-header="$i18n{siteSettingsArAllowedExceptions}"
      block-header="$i18n{siteSettingsArBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const ArPageElementBase=SettingsViewMixin(PolymerElement);class ArPageElement extends ArPageElementBase{static get is(){return"settings-ar-page"}static get template(){return getTemplate$1k()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(ArPageElement.is,ArPageElement);function getTemplate$1j(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsAutomaticDownloads}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
      $i18n{siteSettingsAutomaticDownloadsDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.AUTOMATIC_DOWNLOADS]]"
      allow-option-label="$i18n{siteSettingsAutomaticDownloadsAllowed}"
      allow-option-icon="cr:file-download"
      block-option-label="$i18n{siteSettingsAutomaticDownloadsBlocked}"
      block-option-icon="privacy:file-download-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.AUTOMATIC_DOWNLOADS]]"
      allow-header="$i18n{siteSettingsAutomaticDownloadsAllowedExceptions}"
      block-header="$i18n{siteSettingsAutomaticDownloadsBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const AutomaticDownloadsPageElementBase=SettingsViewMixin(PolymerElement);class AutomaticDownloadsPageElement extends AutomaticDownloadsPageElementBase{static get is(){return"settings-automatic-downloads-page"}static get template(){return getTemplate$1j()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(AutomaticDownloadsPageElement.is,AutomaticDownloadsPageElement);function getTemplate$1i(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage
    page-title="$i18n{siteSettingsCategoryAutomaticFullscreen}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsAutomaticFullscreenDescription}
  </div>
  <category-setting-exceptions read-only-list
      category="[[contentSettingsTypesEnum_.AUTOMATIC_FULLSCREEN]]"
      allow-header=
          "$i18n{siteSettingsAutomaticFullscreenAllowedExceptions}"
      block-header=
          "$i18n{siteSettingsAutomaticFullscreenBlockedExceptions}"
          search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const AutomaticFullScreenPageElementBase=SettingsViewMixin(PolymerElement);class AutomaticFullScreenPageElement extends AutomaticFullScreenPageElementBase{static get is(){return"settings-automatic-full-screen-page"}static get template(){return getTemplate$1i()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(AutomaticFullScreenPageElement.is,AutomaticFullScreenPageElement);function getTemplate$1h(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsAutoPictureInPicture}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
   <div class="content-settings-header secondary">
     $i18n{siteSettingsAutoPictureInPictureDescription}
   </div>
   <settings-category-default-radio-group
       category="[[contentSettingsTypesEnum_.AUTO_PICTURE_IN_PICTURE]]"
       allow-option-label=
           "$i18n{siteSettingsAutoPictureInPictureAllowed}"
       allow-option-icon="settings:picture-in-picture"
       block-option-label="$i18n{siteSettingsAutoPictureInPictureBlocked}"
       block-option-icon="settings:picture-in-picture-off">
   </settings-category-default-radio-group>
   <category-setting-exceptions
       category="[[contentSettingsTypesEnum_.AUTO_PICTURE_IN_PICTURE]]"
       allow-header=
           "$i18n{siteSettingsAutoPictureInPictureAllowedExceptions}"
       block-header=
           "$i18n{siteSettingsAutoPictureInPictureBlockedExceptions}"
       search-filter="[[searchTerm]]">
   </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const AutoPictureInPicturePageElementBase=SettingsViewMixin(PolymerElement);class AutoPictureInPicturePageElement extends AutoPictureInPicturePageElementBase{static get is(){return"settings-auto-picture-in-picture-page"}static get template(){return getTemplate$1h()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(AutoPictureInPicturePageElement.is,AutoPictureInPicturePageElement);function getTemplate$1g(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsBackgroundSync}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsBackgroundSyncDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.BACKGROUND_SYNC]]"
      allow-option-label="$i18n{siteSettingsBackgroundSyncAllowed}"
      allow-option-icon="cr:sync"
      block-option-label="$i18n{siteSettingsBackgroundSyncBlocked}"
      block-option-sub-label="$i18n{siteSettingsBackgroundSyncBlockedSubLabel}"
      block-option-icon="privacy:sync-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.BACKGROUND_SYNC]]"
      allow-header="$i18n{siteSettingsBackgroundSyncAllowedExceptions}"
      block-header="$i18n{siteSettingsBackgroundSyncBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const BackgroundSyncPageElementBase=SettingsViewMixin(PolymerElement);class BackgroundSyncPageElement extends BackgroundSyncPageElementBase{static get is(){return"settings-background-sync-page"}static get template(){return getTemplate$1g()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(BackgroundSyncPageElement.is,BackgroundSyncPageElement);function getTemplate$1f(){return html`<!--_html_template_start_-->    <style include="cr-shared-style settings-shared"></style>

    <div class="cr-row first">
      <h2 class="flex">[[exception.displayName]]</h2>
    </div>

    <div class="list-frame menu-content vertical-list" id="listContainer">
      <iron-list items="[[exception.sites]]" preserve-focus risk-selection>
        <template>
          <site-list-entry model="[[item]]"
              tabindex$="[[tabIndex]]"
              first$="[[!index]]"
              focus-row-index="[[index]]"
              iron-list-tab-index="[[tabIndex]]"
              last-focused="{{lastFocused_}}"
              chooser-type="[[exception.chooserType]]"
              chooser-object="[[exception.object]]"
              read-only-list>
          </site-list-entry>
        </template>
      </iron-list>
    </div>
<!--_html_template_end_-->`}class ChooserExceptionListEntryElement extends PolymerElement{static get is(){return"chooser-exception-list-entry"}static get template(){return getTemplate$1f()}static get properties(){return{exception:Object,lastFocused_:Object}}}customElements.define(ChooserExceptionListEntryElement.is,ChooserExceptionListEntryElement);function getTemplate$1e(){return html`<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">#emptyListMessage{padding:0 var(--cr-section-padding);padding-top:30px}#exceptionList{padding-top:0}#resetSettingsButton{margin:0 var(--cr-section-padding);margin-top:24px}
    </style>

    <!-- Confirm reset settings dialog. -->
    <cr-dialog id="confirmResetSettings" close-text="$i18n{close}">
      <div slot="body">[[resetPermissionsMessage_]]</div>
      <div slot="button-container">
        <cr-button class="cancel-button" on-click="onCloseDialog_">
          $i18n{cancel}
        </cr-button>
        <cr-button class="action-button" on-click="onResetSettings_">
          $i18n{siteSettingsSiteResetAll}
        </cr-button>
      </div>
    </cr-dialog>

    <div id="emptyListMessage"
        hidden$="[[hasExceptions_(chooserExceptions.*)]]">
      <div class="secondary">[[emptyListMessage_]]</div>
    </div>

    <div hidden$="[[!hasExceptions_(chooserExceptions.*)]]">
      <cr-button id="resetSettingsButton" role="button" aria-disabled="false"
          on-click="onConfirmClearSettings_">
        $i18n{siteSettingsReset}
      </cr-button>
    </div>

    <template id="exceptionList" is="dom-repeat" items="[[chooserExceptions]]">
      <chooser-exception-list-entry exception="[[item]]"
          on-show-tooltip="onShowTooltip_">
      </chooser-exception-list-entry>
    </template>

    <cr-tooltip id="tooltip" manual-mode position="top">
      [[tooltipText_]]
    </cr-tooltip>
<!--_html_template_end_-->`}const ChooserExceptionListElementBase=TooltipMixin(ListPropertyUpdateMixin(SiteSettingsMixin(WebUiListenerMixin(I18nMixin(PolymerElement)))));class ChooserExceptionListElement extends ChooserExceptionListElementBase{static get is(){return"chooser-exception-list"}static get template(){return getTemplate$1e()}static get properties(){return{chooserExceptions:{type:Array,value(){return[]}},chooserType:{observer:"chooserTypeChanged_",type:String,value:ChooserType.NONE},emptyListMessage_:{type:String,value:""},hasIncognito_:Boolean,resetPermissionsMessage_:{type:String,value:""},tooltipText_:String}}connectedCallback(){super.connectedCallback();this.addWebUiListener("contentSettingChooserPermissionChanged",((category,chooserType)=>{this.objectWithinChooserTypeChanged_(category,chooserType)}));this.addWebUiListener("onIncognitoStatusChanged",(hasIncognito=>this.onIncognitoStatusChanged_(hasIncognito)));this.browserProxy.updateIncognitoStatus()}objectWithinChooserTypeChanged_(category,chooserType){if(category===this.category&&chooserType===this.chooserType){this.chooserTypeChanged_()}}onIncognitoStatusChanged_(hasIncognito){this.hasIncognito_=hasIncognito;this.populateList_()}chooserTypeChanged_(){if(this.chooserType===ChooserType.NONE){return}switch(this.chooserType){case ChooserType.USB_DEVICES:this.emptyListMessage_=this.i18n("noUsbDevicesFound");this.resetPermissionsMessage_=this.i18n("resetUsbConfirmation");break;case ChooserType.SERIAL_PORTS:this.emptyListMessage_=this.i18n("noSerialPortsFound");this.resetPermissionsMessage_=this.i18n("resetSerialPortsConfirmation");break;case ChooserType.HID_DEVICES:this.emptyListMessage_=this.i18n("noHidDevicesFound");this.resetPermissionsMessage_=this.i18n("resetHidConfirmation");break;case ChooserType.BLUETOOTH_DEVICES:this.emptyListMessage_=this.i18n("noBluetoothDevicesFound");this.resetPermissionsMessage_=this.i18n("resetBluetoothConfirmation");break;default:this.emptyListMessage_="";this.resetPermissionsMessage_=""}this.populateList_()}hasExceptions_(){return this.chooserExceptions.length>0}onShowTooltip_(e){this.tooltipText_=e.detail.text;this.showTooltipAtTarget(this.$.tooltip,e.detail.target)}populateList_(){this.browserProxy.getChooserExceptionList(this.chooserType).then((exceptionList=>this.processExceptions_(exceptionList)))}processExceptions_(exceptionList){const exceptions=exceptionList.map((exception=>{const sites=exception.sites.map((site=>this.expandSiteException(site)));return Object.assign(exception,{sites:sites})}));if(!this.updateList("chooserExceptions",(x=>x.displayName),exceptions,true)){const siteUidGetter=x=>x.origin+x.embeddingOrigin+x.incognito;exceptions.forEach(((exception,index)=>{const propertyPath="chooserExceptions."+index+".sites";this.updateList(propertyPath,siteUidGetter,exception.sites)}),this)}}onConfirmClearSettings_(e){e.preventDefault();this.$.confirmResetSettings.showModal()}onCloseDialog_(e){e.target.closest("cr-dialog").close()}onResetSettings_(e){this.chooserExceptions.forEach((exception=>{exception.sites.forEach((site=>{this.browserProxy.resetChooserExceptionForSite(exception.chooserType,site.origin,exception.object)}))}));this.onCloseDialog_(e)}}customElements.define(ChooserExceptionListElement.is,ChooserExceptionListElement);function getTemplate$1d(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsBluetoothDevices}"
    learn-more-url="$i18n{bluetoothAdapterOffHelpURL}"
    route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsBluetoothDevicesDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.BLUETOOTH_DEVICES]]"
      allow-option-label="$i18n{siteSettingsBluetoothDevicesAllowed}"
      allow-option-icon="settings:bluetooth"
      block-option-label="$i18n{siteSettingsBluetoothDevicesBlocked}"
      block-option-icon="settings:bluetooth-off">
  </settings-category-default-radio-group>
  <chooser-exception-list
      category="[[contentSettingsTypesEnum_.BLUETOOTH_DEVICES]]"
      chooser-type="[[chooserTypeEnum_.BLUETOOTH_DEVICES]]">
  </chooser-exception-list>
</settings-subpage>
<!--_html_template_end_-->`}const BluetoothDevicesPageElementBase=SettingsViewMixin(PolymerElement);class BluetoothDevicesPageElement extends BluetoothDevicesPageElementBase{static get is(){return"settings-bluetooth-devices-page"}static get template(){return getTemplate$1d()}static get properties(){return{contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes},chooserTypeEnum_:{type:Object,value:ChooserType}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(BluetoothDevicesPageElement.is,BluetoothDevicesPageElement);function getTemplate$1c(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsBluetoothScanning}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsBluetoothScanningDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.BLUETOOTH_SCANNING]]"
      allow-option-label=
          "$i18n{siteSettingsBluetoothScanningAsk}"
      allow-option-icon="settings:bluetooth-scanning"
      block-option-label="$i18n{siteSettingsBluetoothScanningBlock}"
      block-option-icon="settings:bluetooth-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.BLUETOOTH_SCANNING]]"
      read-only-list
      block-header=
          "$i18n{siteSettingsBluetoothScanningBlockedExceptions}"
      allow-header=
          "$i18n{siteSettingsBluetoothScanningAllowedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const BluetoothScanningPageElementBase=SettingsViewMixin(PolymerElement);class BluetoothScanningPageElement extends BluetoothScanningPageElementBase{static get is(){return"settings-bluetooth-scanning-page"}static get template(){return getTemplate$1c()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(BluetoothScanningPageElement.is,BluetoothScanningPageElement);function getTemplate$1b(){return html`<!--_html_template_start_-->    <style include="settings-shared md-select">:host{display:block}
    </style>
    <div class="cr-row first" id="picker" hidden>
      <select id="mediaPicker" class="md-select" on-change="onChange_"
          aria-label$="[[label]]">
        <template is="dom-repeat" items="[[devices]]">
          <option value$="[[item.id]]">[[item.name]]</option>
        </template>
      </select>
    </div>
<!--_html_template_end_-->`}const MediaPickerElementBase=SiteSettingsMixin(WebUiListenerMixin(PolymerElement));class MediaPickerElement extends MediaPickerElementBase{static get is(){return"media-picker"}static get template(){return getTemplate$1b()}static get properties(){return{type:String,label:String,devices:Array}}ready(){super.ready();this.addWebUiListener("updateDevicesMenu",((type,devices,selectedDevice)=>this.updateDevicesMenu_(type,devices,selectedDevice)));this.browserProxy.initializeCaptureDevices(this.type)}updateDevicesMenu_(type,devices,selectedDevice){if(type!==this.type){return}this.$.picker.hidden=devices.length===0;if(devices.length>0){this.devices=devices;microTask.run((()=>{this.$.mediaPicker.value=selectedDevice}))}}onChange_(){this.browserProxy.setPreferredCaptureDevice(this.type,this.$.mediaPicker.value)}}customElements.define(MediaPickerElement.is,MediaPickerElement);function getTemplate$1a(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsCategoryCamera}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <media-picker label="$i18n{siteSettingsCameraLabel}" type="camera">
  </media-picker>
  <div class="content-settings-header secondary">
    $i18n{siteSettingsCameraDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.CAMERA]]"
      allow-option-label="$i18n{siteSettingsCameraAllowed}"
      allow-option-icon="cr:videocam"
      block-option-label="$i18n{siteSettingsCameraBlocked}"
      block-option-sub-label="$i18n{siteSettingsCameraBlockedSubLabel}"
      block-option-icon="privacy:videocam-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.CAMERA]]" read-only-list
      allow-header="$i18n{siteSettingsCameraAllowedExceptions}"
      block-header="$i18n{siteSettingsCameraBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const CameraPageElementBase=SettingsViewMixin(PolymerElement);class CameraPageElement extends CameraPageElementBase{static get is(){return"settings-camera-page"}static get template(){return getTemplate$1a()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(CameraPageElement.is,CameraPageElement);function getTemplate$19(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsCapturedSurfaceControl}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsCapturedSurfaceControlDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.CAPTURED_SURFACE_CONTROL]]"
      allow-option-label=
          "$i18n{siteSettingsCapturedSurfaceControlAllowed}"
      allow-option-icon="settings:touchpad-mouse"
      block-option-label="$i18n{siteSettingsCapturedSurfaceControlBlocked}"
      block-option-icon="settings:touchpad-mouse-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.CAPTURED_SURFACE_CONTROL]]"
      allow-header=
          "$i18n{siteSettingsCapturedSurfaceControlAllowedExceptions}"
      block-header=
          "$i18n{siteSettingsCapturedSurfaceControlBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const CapturedSurfaceControlPageElementBase=SettingsViewMixin(PolymerElement);class CapturedSurfaceControlPageElement extends CapturedSurfaceControlPageElementBase{static get is(){return"settings-captured-surface-control-page"}static get template(){return getTemplate$19()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(CapturedSurfaceControlPageElement.is,CapturedSurfaceControlPageElement);function getTemplate$18(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsClipboard}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsClipboardDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.CLIPBOARD]]"
      allow-option-label="$i18n{siteSettingsClipboardAllowed}"
      allow-option-icon="privacy:content-paste"
      block-option-label="$i18n{siteSettingsClipboardBlocked}"
      block-option-icon="privacy:content-paste-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.CLIPBOARD]]"
      allow-header="$i18n{siteSettingsClipboardAllowedExceptions}"
      block-header="$i18n{siteSettingsClipboardBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const ClipboardPageElementBase=SettingsViewMixin(PolymerElement);class ClipboardPageElement extends ClipboardPageElementBase{static get is(){return"settings-clipboard-page"}static get template(){return getTemplate$18()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(ClipboardPageElement.is,ClipboardPageElement);function getTemplate$17(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage
    page-title="$i18n{siteSettingsCategoryFederatedIdentityApi}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsFederatedIdentityApiDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.FEDERATED_IDENTITY_API]]"
      allow-option-label="$i18n{siteSettingsFederatedIdentityApiAllowed}"
      allow-option-icon="privacy:account-circle"
      block-option-label="$i18n{siteSettingsFederatedIdentityApiBlocked}"
      block-option-icon="privacy:account-circle-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.FEDERATED_IDENTITY_API]]"
      allow-header="$i18n{siteSettingsFederatedIdentityApiAllowedExceptions}"
      block-header="$i18n{siteSettingsFederatedIdentityApiBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const FederatedIdentityApiPageElementBase=SettingsViewMixin(PolymerElement);class FederatedIdentityApiPageElement extends FederatedIdentityApiPageElementBase{static get is(){return"settings-federated-identity-api-page"}static get template(){return getTemplate$17()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(FederatedIdentityApiPageElement.is,FederatedIdentityApiPageElement);function getTemplate$16(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared">.file-system{padding-inline-start:20px;padding-inline-end:20px}</style>
<div class="list-item file-system">
  <div id="fileTypeIcon"
      class$="cr-icon [[getClassForListItem_(grant)]]">
  </div>
  <div class="site-representation middle text-elide">
    <span class="display-name url-directionality text-elide">
        [[grant.displayName]]
    </span>
  </div>
  <cr-icon-button id="removeGrant" class="icon-delete-gray"
      on-click="onRemoveGrantClick_"
      aria-label=$i18n{siteSettingsFileSystemSiteListRemoveGrantLabel}>
  <cr-icon-button>
</div><!--_html_template_end_-->`}const FileSystemSiteEntryItemElementBase=BaseMixin(PolymerElement);class FileSystemSiteEntryItemElement extends FileSystemSiteEntryItemElementBase{static get is(){return"file-system-site-entry-item"}static get template(){return getTemplate$16()}static get properties(){return{grant:Object}}getClassForListItem_(){return this.grant.isDirectory?"icon-folder-open":"icon-file"}onRemoveGrantClick_(){this.fire("revoke-grant",this.grant)}}customElements.define(FileSystemSiteEntryItemElement.is,FileSystemSiteEntryItemElement);function getTemplate$15(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared">.origin{flex-grow:1;padding-inline-start:20px}.origin-row{align-items:center;display:flex;padding-bottom:5px;padding-inline-end:10px;padding-top:5px}.subpage-arrow{margin-inline-end:2px}.separator{padding-inline-end:25px}</style>

<div class="list-frame">
  <div class="origin-row">
    <site-favicon url="[[grantsPerOrigin.origin]]"></site-favicon>
    <div class="origin">[[grantsPerOrigin.origin]]</div>
    <cr-icon-button id="fileSystemSiteDetails"
        class="subpage-arrow"
        aria-label$="[[grantsPerOrigin.origin]]"
        aria-roledescription="$i18n{subpageArrowRoleDescription}"
        on-click="onNavigateToDetailsPageClick_">
    </cr-icon-button>
    <div class="separator"></div>
    <cr-icon-button
        class="icon-delete-gray"
        id="removeGrants"
        on-click="onRemoveGrantsClick_">
      $i18n{siteSettingsFileSystemSiteListRemoveGrants}
    </cr-icon-button>
  </div>
</div>
<!--_html_template_end_-->`}const FileSystemSiteEntryElementBase=BaseMixin(PolymerElement);class FileSystemSiteEntryElement extends FileSystemSiteEntryElementBase{static get is(){return"file-system-site-entry"}static get template(){return getTemplate$15()}static get properties(){return{grantsPerOrigin:Object}}onNavigateToDetailsPageClick_(){Router.getInstance().navigateTo(routes.SITE_SETTINGS_FILE_SYSTEM_WRITE_DETAILS,new URLSearchParams("site="+this.grantsPerOrigin.origin))}onRemoveGrantsClick_(){this.fire("revoke-grants",this.grantsPerOrigin)}}customElements.define(FileSystemSiteEntryElement.is,FileSystemSiteEntryElement);function getTemplate$14(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared"></style>

<div class="cr-row first">
  <h2 class="cr-secondary-text">
    $i18n{siteSettingsFileSystemSiteListHeader}
  </h2>
</div>
<div class="list-frame"
    hidden$="[[hasAllowedGrants_(allowedGrants_.*)]]">
  <div class="list-item cr-secondary-text">$i18n{noSitesAdded}</div>
</div>
<template is="dom-repeat" items="[[allowedGrants_]]" as="grantsPerOrigin">
  <file-system-site-entry grants-per-origin="[[grantsPerOrigin]]"
      on-revoke-grants="onRevokeGrants_">
  </file-system-site-entry>
</template><!--_html_template_end_-->`}const FileSystemSiteListElementBase=WebUiListenerMixin(RouteObserverMixin(SiteSettingsMixin(PolymerElement)));class FileSystemSiteListElement extends FileSystemSiteListElementBase{static get is(){return"file-system-site-list"}static get template(){return getTemplate$14()}static get properties(){return{allowedGrants_:{type:Array,value:()=>[]}}}connectedCallback(){super.connectedCallback();this.addWebUiListener("contentSettingChooserPermissionChanged",(category=>{if(category===ContentSettingsTypes.FILE_SYSTEM_WRITE){this.populateList_()}}))}disconnectedCallback(){super.disconnectedCallback()}currentRouteChanged(currentRoute,oldRoute){if(currentRoute===routes.SITE_SETTINGS_FILE_SYSTEM_WRITE&&currentRoute!==oldRoute){this.populateList_()}}async populateList_(){const response=await this.browserProxy.getFileSystemGrants();this.set("allowedGrants_",response)}hasAllowedGrants_(){return this.allowedGrants_.length>0}onRevokeGrants_(e){this.browserProxy.revokeFileSystemGrants(e.detail.origin)}}customElements.define(FileSystemSiteListElement.is,FileSystemSiteListElement);function getTemplate$13(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsFileSystemWrite}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsFileSystemWriteDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.FILE_SYSTEM_WRITE]]"
      allow-option-label="$i18n{siteSettingsFileSystemWriteAllowed}"
      allow-option-icon="privacy:file-save"
      block-option-label="$i18n{siteSettingsFileSystemWriteBlocked}"
      block-option-icon="privacy:file-save-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.FILE_SYSTEM_WRITE]]"
      read-only-list
      block-header="$i18n{siteSettingsFileSystemWriteBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
  <template is="dom-if" if="[[enablePersistentPermissions_]]">
    <file-system-site-list></file-system-site-list>
  </template>
</settings-subpage>
<!--_html_template_end_-->`}const FilesystemPageElementBase=SettingsViewMixin(PolymerElement);class FilesystemPageElement extends FilesystemPageElementBase{static get is(){return"settings-filesystem-page"}static get template(){return getTemplate$13()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes},enablePersistentPermissions_:{type:Boolean,readOnly:true,value:()=>loadTimeData.getBoolean("enablePersistentPermissions")}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(FilesystemPageElement.is,FilesystemPageElement);function getTemplate$12(){return html`<!--_html_template_start_--><style>.grants-list-header{padding-inline-start:20px;padding-bottom:20px}.view-grants{padding-top:20px}</style>
<settings-subpage page-title="[[pageTitle_]]" route-path$="[[routePath]]">
  <div class="grants-list-header"
      hidden$="[[!grantsPerOrigin.editGrants.length]]">
    $i18n{siteSettingsFileSystemSiteListEditHeader}
  </div>
  <template is="dom-repeat" items="[[grantsPerOrigin.editGrants]]"
      as="editGrant">
    <file-system-site-entry-item grant="[[editGrant]]"
        on-revoke-grant="onRevokeGrant_">
    </file-system-site-entry-item>
  </template>
  <div class="grants-list-header view-grants"
      hidden$="[[!grantsPerOrigin.viewGrants.length]]">
    $i18n{siteSettingsFileSystemSiteListViewHeader}
  </div>
  <template is="dom-repeat" items="[[grantsPerOrigin.viewGrants]]"
      as="viewGrant">
    <file-system-site-entry-item grant="[[viewGrant]]"
        on-revoke-grant="onRevokeGrant_">
    </file-system-site-entry-item>
  </template>
</settings-subpage>
<!--_html_template_end_-->`}const FileSystemSiteDetailsElementBase=WebUiListenerMixin(BaseMixin(RouteObserverMixin(SettingsViewMixin(SiteSettingsMixin(I18nMixin(PolymerElement))))));class FileSystemSiteDetailsElement extends FileSystemSiteDetailsElementBase{static get is(){return"file-system-site-details"}static get template(){return getTemplate$12()}static get properties(){return{pageTitle_:{type:String,notify:true},origin_:String,grantsPerOrigin:Object}}connectedCallback(){super.connectedCallback();this.addWebUiListener("contentSettingChooserPermissionChanged",(category=>{if(category===ContentSettingsTypes.FILE_SYSTEM_WRITE){this.populateList_()}}))}currentRouteChanged(route,oldRoute){super.currentRouteChanged(route,oldRoute);if(route!==routes.SITE_SETTINGS_FILE_SYSTEM_WRITE_DETAILS){return}const site=Router.getInstance().getQueryParameters().get("site");if(!site){return}this.browserProxy.isOriginValid(site).then((valid=>{if(!valid){Router.getInstance().navigateToPreviousRoute()}this.origin_=site;this.pageTitle_=this.origin_}));this.populateList_()}async populateList_(){const response=await this.browserProxy.getFileSystemGrants();const originFileSystemGrantsObj=response.find((grantObj=>grantObj.origin===this.origin_));if(!originFileSystemGrantsObj){Router.getInstance().navigateTo(routes.SITE_SETTINGS_FILE_SYSTEM_WRITE);return}this.grantsPerOrigin=originFileSystemGrantsObj}onRevokeGrant_(e){this.browserProxy.revokeFileSystemGrant(this.origin_,e.detail.filePath)}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(FileSystemSiteDetailsElement.is,FileSystemSiteDetailsElement);function getTemplate$11(){return html`<!--_html_template_start_--><style include="cr-hidden-style settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsCategoryLocation}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
<div class="content-settings-header secondary">
  $i18n{siteSettingsLocationDescription}
</div>
<template is="dom-if"
    if="[[!enablePermissionSiteSettingsRadioButton_]]">
  <div id="locationRadioGroup" class="radio-group">
    <h2>$i18n{siteSettingsDefaultBehavior}</h2>
    <div id="geolocationSubHeading"
        class="secondary radio-sub-heading">
        $i18n{siteSettingsDefaultBehaviorDescription}
    </div>
    <cr-radio-group
        on-selected-changed="onLocationTopLevelRadioChanged_">
      <cr-radio-button no-collapse
          id="locationAskRadioButton"
          name="location-ask-radio-button"
          checked$="[[isLocationAllowed_]]">
        <cr-icon icon="settings:location-on"></cr-icon>
        $i18n{siteSettingsLocationAllowed}
      </cr-radio-button>
      <settings-radio-group
          id="locationCpssRadioGroup"
          pref="{{prefs.generated.geolocation}}"
          selectable-elements="cr-radio-button"
          hidden$="[[!isLocationAllowed_]]">
        <cr-radio-button class="padded-radio-section"
            name="[[settingsStateEnum_.QUIET]]"
            pref="[[prefs.generated.geolocation]]"
            label="$i18n{siteSettingsLocationAskQuiet}">
        </cr-radio-button>
        <cr-radio-button class="padded-radio-section"
            name="[[settingsStateEnum_.CPSS]]"
            pref="[[prefs.generated.geolocation]]"
            label="$i18n{siteSettingsLocationAskCPSS}">
        </cr-radio-button>
        <cr-radio-button class="padded-radio-section"
            name="[[settingsStateEnum_.LOUD]]"
            pref="[[prefs.generated.geolocation]]"
            label="$i18n{siteSettingsLocationAskLoud}">
        </cr-radio-button>
      </settings-radio-group>
      <cr-radio-button class="two-line"
          id="locationBlockRadioButton"
          name="location-block-radio-button"
          sub-label="$i18n{siteSettingsLocationBlockedSubLabel}"
          checked$="[[!isLocationAllowed_]]">
        <cr-icon icon="privacy:location-off"></cr-icon>
        $i18n{siteSettingsLocationBlocked}
      </cr-radio-button>
    </cr-radio-group>
  </div>
</template>
<template is="dom-if"
    if="[[enablePermissionSiteSettingsRadioButton_]]">
  <settings-category-default-radio-group
      id="locationDefaultRadioGroup"
      category="[[contentSettingsTypesEnum_.GEOLOCATION]]"
      allow-option-label="$i18n{siteSettingsLocationAllowed}"
      allow-option-icon="settings:location-on"
      block-option-label="$i18n{siteSettingsLocationBlocked}"
      block-option-icon="privacy:location-off"
      on-selected-changed="onLocationTopLevelRadioChanged2_">
  </settings-category-default-radio-group>
  <div class="radio-group"
      id="locationCpssRadioGroup"
      hidden$="[[!isLocationAllowed_]]">
    <h2 class="cpss-heading">
      $i18n{siteSettingsHowToShowRequests}
    </h2>
    <settings-radio-group
        pref="{{prefs.generated.geolocation}}"
        selectable-elements="settings-collapse-radio-button">
      <settings-collapse-radio-button
          name="[[settingsStateEnum_.QUIET]]"
          pref="[[prefs.generated.geolocation]]"
          label="$i18n{siteSettingsLocationAskQuiet}"
          no-collapse>
      </settings-collapse-radio-button>
      <settings-collapse-radio-button
          name="[[settingsStateEnum_.CPSS]]"
          pref="[[prefs.generated.geolocation]]"
          label="$i18n{siteSettingsLocationAskCPSS}"
          no-collapse>
      </settings-collapse-radio-button>
      <settings-collapse-radio-button
          name="[[settingsStateEnum_.LOUD]]"
          pref="[[prefs.generated.geolocation]]"
          label="$i18n{siteSettingsLocationAskLoud}"
          no-collapse>
      </settings-collapse-radio-button>
    </settings-radio-group>
  </div>
</template>
<category-setting-exceptions
    category="[[contentSettingsTypesEnum_.GEOLOCATION]]"
    read-only-list
    allow-header="$i18n{siteSettingsLocationAllowedExceptions}"
    block-header="$i18n{siteSettingsLocationBlockedExceptions}"
    search-filter="[[searchTerm]]">
</category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const GeolocationPageElementBase=SettingsViewMixin(PrefsMixin(PolymerElement));class GeolocationPageElement extends GeolocationPageElementBase{static get is(){return"settings-geolocation-page"}static get template(){return getTemplate$11()}static get properties(){return{searchTerm:{type:String,notify:true,value:""},enablePermissionSiteSettingsRadioButton_:{type:Boolean,value:()=>loadTimeData.getBoolean("enablePermissionSiteSettingsRadioButton")},settingsStateEnum_:{type:Object,value:SettingsState},contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes},contentSettingEnum_:{type:Object,value:ContentSetting},isLocationAllowed_:Boolean}}siteSettingsBrowserProxy_=SiteSettingsBrowserProxyImpl.getInstance();ready(){super.ready();this.updateLocationState_()}async updateLocationState_(){const[locationDefaultValue]=await Promise.all([this.siteSettingsBrowserProxy_.getDefaultValueForContentType(ContentSettingsTypes.GEOLOCATION)]);this.isLocationAllowed_=locationDefaultValue.setting===ContentSetting.ASK}onLocationTopLevelRadioChanged_(event){const radioButtonName=event.detail.value;switch(radioButtonName){case"location-block-radio-button":this.setPrefValue("generated.geolocation",SettingsState.BLOCK);this.isLocationAllowed_=false;break;case"location-ask-radio-button":this.setPrefValue("generated.geolocation",SettingsState.CPSS);this.isLocationAllowed_=true;break}}onLocationTopLevelRadioChanged2_(event){const selected=event.detail.value;if(selected){this.setPrefValue("generated.geolocation",SettingsState.CPSS);this.isLocationAllowed_=true}else{this.setPrefValue("generated.geolocation",SettingsState.BLOCK);this.isLocationAllowed_=false}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(GeolocationPageElement.is,GeolocationPageElement);function getTemplate$10(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsHandTracking}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsHandTrackingDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.HAND_TRACKING]]"
      allow-option-label="$i18n{siteSettingsHandTrackingAsk}"
      allow-option-icon="privacy:hand-gesture"
      block-option-label="$i18n{siteSettingsHandTrackingBlock}"
      block-option-icon="privacy:hand-gesture-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.HAND_TRACKING]]"
      read-only-list
      allow-header="$i18n{siteSettingsHandTrackingAllowedExceptions}"
      block-header="$i18n{siteSettingsHandTrackingBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const HandTrackingPageElementBase=SettingsViewMixin(PolymerElement);class HandTrackingPageElement extends HandTrackingPageElementBase{static get is(){return"settings-hand-tracking-page"}static get template(){return getTemplate$10()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(HandTrackingPageElement.is,HandTrackingPageElement);function getTemplate$$(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsHidDevices}"
    learn-more-url="$i18n{chooserHidOverviewUrl}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsHidDevicesDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.HID_DEVICES]]"
      allow-option-label="$i18n{siteSettingsHidDevicesAllowed}"
      allow-option-icon="privacy:videogame-asset"
      block-option-label="$i18n{siteSettingsHidDevicesBlocked}"
      block-option-icon="privacy:videogame-asset-off">
  </settings-category-default-radio-group>
  <chooser-exception-list
      category="[[contentSettingsTypesEnum_.HID_DEVICES]]"
      chooser-type="[[chooserTypeEnum_.HID_DEVICES]]">
  </chooser-exception-list>
</settings-subpage>
<!--_html_template_end_-->`}const HidDevicesPageElementBase=SettingsViewMixin(PolymerElement);class HidDevicesPageElement extends HidDevicesPageElementBase{static get is(){return"settings-hid-devices-page"}static get template(){return getTemplate$$()}static get properties(){return{contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes},chooserTypeEnum_:{type:Object,value:ChooserType}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(HidDevicesPageElement.is,HidDevicesPageElement);function getTemplate$_(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsIdleDetection}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsDeviceUseDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.IDLE_DETECTION]]"
      allow-option-label="$i18n{siteSettingsDeviceUseAllowed}"
      allow-option-icon="settings:devices"
      block-option-label="$i18n{siteSettingsDeviceUseBlocked}"
      block-option-icon="privacy:devices-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.IDLE_DETECTION]]"
      allow-header="$i18n{siteSettingsDeviceUseAllowedExceptions}"
      block-header="$i18n{siteSettingsDeviceUseBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const IdleDetectionPageElementBase=SettingsViewMixin(PolymerElement);class IdleDetectionPageElement extends IdleDetectionPageElementBase{static get is(){return"settings-idle-detection-page"}static get template(){return getTemplate$_()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(IdleDetectionPageElement.is,IdleDetectionPageElement);function getTemplate$Z(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsCategoryImages}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsImagesDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.IMAGES]]"
      allow-option-label="$i18n{siteSettingsImagesAllowed}"
      allow-option-icon="privacy:imagesmode"
      block-option-label="$i18n{siteSettingsImagesBlocked}"
      block-option-sub-label="$i18n{siteSettingsImagesBlockedSubLabel}"
      block-option-icon="privacy:hide-image">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.IMAGES]]"
      allow-header="$i18n{siteSettingsImagesAllowedExceptions}"
      block-header="$i18n{siteSettingsImagedBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const ImagesPageElementBase=SettingsViewMixin(PolymerElement);class ImagesPageElement extends ImagesPageElementBase{static get is(){return"settings-images-page"}static get template(){return getTemplate$Z()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(ImagesPageElement.is,ImagesPageElement);function getTemplate$Y(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage
    page-title="$i18n{siteSettingsCategoryInsecureContent}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsInsecureContentDescription}
  </div>
  <div class="cr-row first secondary">
    $i18n{siteSettingsInsecureContentBlock}
  </div>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.MIXEDSCRIPT]]"
      allow-header="$i18n{siteSettingsInsecureContentAllowedExceptions}"
      block-header="$i18n{siteSettingsInsecureContentBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const InsecureContentPageElementBase=SettingsViewMixin(PolymerElement);class InsecureContentPageElement extends InsecureContentPageElementBase{static get is(){return"settings-insecure-content-page"}static get template(){return getTemplate$Y()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(InsecureContentPageElement.is,InsecureContentPageElement);function getTemplate$X(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsCategoryJavascript}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsJavascriptDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.JAVASCRIPT]]"
      allow-option-label="$i18n{siteSettingsJavascriptAllowed}"
      allow-option-icon="privacy:code"
      block-option-label="$i18n{siteSettingsJavascriptBlocked}"
      block-option-icon="privacy:code-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.JAVASCRIPT]]"
      allow-header="$i18n{siteSettingsJavascriptAllowedExceptions}"
      block-header="$i18n{siteSettingsJavascriptBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const JavascriptPageElementBase=SettingsViewMixin(PolymerElement);class JavascriptPageElement extends JavascriptPageElementBase{static get is(){return"settings-javascript-page"}static get template(){return getTemplate$X()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(JavascriptPageElement.is,JavascriptPageElement);function getTemplate$W(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsKeyboardLock}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsKeyboardLockDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.KEYBOARD_LOCK]]"
      allow-option-label=
          "$i18n{siteSettingsKeyboardLockAllowed}"
      allow-option-icon="settings20:keyboard-lock"
      block-option-label="$i18n{siteSettingsKeyboardLockBlocked}"
      block-option-icon="settings20:keyboard-lock-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.KEYBOARD_LOCK]]"
      allow-header=
          "$i18n{siteSettingsKeyboardLockAllowedExceptions}"
      block-header=
          "$i18n{siteSettingsKeyboardLockBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const KeyboardLockPageElementBase=SettingsViewMixin(PolymerElement);class KeyboardLockPageElement extends KeyboardLockPageElementBase{static get is(){return"settings-keyboard-lock-page"}static get template(){return getTemplate$W()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(KeyboardLockPageElement.is,KeyboardLockPageElement);function getTemplate$V(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{fonts}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsFontsDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.LOCAL_FONTS]]"
      allow-option-label="$i18n{siteSettingsFontsAllowed}"
      allow-option-icon="privacy:font-download"
      block-option-label="$i18n{siteSettingsFontsBlocked}"
      block-option-icon="privacy:font-download-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.LOCAL_FONTS]]"
      block-header="$i18n{siteSettingsFontsBlockedExceptions}"
      allow-header="$i18n{siteSettingsFontsAllowedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const LocalFontsPageElementBase=SettingsViewMixin(PolymerElement);class LocalFontsPageElement extends LocalFontsPageElementBase{static get is(){return"settings-local-fonts-page"}static get template(){return getTemplate$V()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(LocalFontsPageElement.is,LocalFontsPageElement);function getTemplate$U(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsLocalNetworkAccess}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsLocalNetworkAccessDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.LOCAL_NETWORK_ACCESS]]"
      allow-option-label="$i18n{siteSettingsLocalNetworkAccessAsk}"
      allow-option-icon="settings20:router"
      block-option-label="$i18n{siteSettingsLocalNetworkAccessBlock}"
      block-option-icon="settings20:router-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.LOCAL_NETWORK_ACCESS]]"
      block-header=
          "$i18n{siteSettingsLocalNetworkAccessBlockedExceptions}"
      allow-header=
          "$i18n{siteSettingsLocalNetworkAccessAllowedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const LocalNetworkAcessPageElementBase=SettingsViewMixin(PolymerElement);class LocalNetworkAcessPageElement extends LocalNetworkAcessPageElementBase{static get is(){return"settings-local-network-access-page"}static get template(){return getTemplate$U()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(LocalNetworkAcessPageElement.is,LocalNetworkAcessPageElement);function getTemplate$T(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsCategoryMicrophone}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <media-picker label="$i18n{siteSettingsMicrophoneLabel}" type="mic">
  </media-picker>
  <div class="content-settings-header secondary">
    $i18n{siteSettingsMicDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.MIC]]"
      allow-option-label="$i18n{siteSettingsMicAllowed}"
      allow-option-icon="privacy:mic"
      block-option-label="$i18n{siteSettingsMicBlocked}"
      block-option-sub-label="$i18n{siteSettingsMicBlockedSubLabel}"
      block-option-icon="privacy:mic-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.MIC]]" read-only-list
      allow-header="$i18n{siteSettingsMicAllowedExceptions}"
      block-header="$i18n{siteSettingsMicBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const MicrophonePageElementBase=SettingsViewMixin(PolymerElement);class MicrophonePageElement extends MicrophonePageElementBase{static get is(){return"settings-microphone-page"}static get template(){return getTemplate$T()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(MicrophonePageElement.is,MicrophonePageElement);function getTemplate$S(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsMidiDevices}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsMidiDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.MIDI_DEVICES]]"
      allow-option-label="$i18n{siteSettingsMidiAllowed}"
      allow-option-icon="privacy:piano"
      block-option-label="$i18n{siteSettingsMidiBlocked}"
      block-option-icon="privacy:piano-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.MIDI_DEVICES]]"
      read-only-list
      allow-header="$i18n{siteSettingsMidiAllowedExceptions}"
      block-header="$i18n{siteSettingsMidiBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const MidiDevicesPageElementBase=SettingsViewMixin(PolymerElement);class MidiDevicesPageElement extends MidiDevicesPageElementBase{static get is(){return"settings-midi-devices-page"}static get template(){return getTemplate$S()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(MidiDevicesPageElement.is,MidiDevicesPageElement);function getTemplate$R(){return html`<!--_html_template_start_--><style include="cr-hidden-style settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsCategoryNotifications}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
<template is="dom-if"
    if="[[enablePermissionSiteSettingsRadioButton_]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsNotificationsDescription}
  </div>
</template>
<div id="notificationRadioGroup" class="radio-group">
  <template is="dom-if" if="[[showNotificationPermissionsReview_]]">
    <template is="dom-if" if="[[shouldShowSafetyHub_]]">
      <h2>$i18n{safetyHub}</h2>
      <settings-safety-hub-module id="safetyHubEntryPoint"
          header="[[notificationPermissionsReviewHeader_]]"
          subheader="[[notificationPermissionsReviewSubheader_]]"
          header-icon="cr:security" header-icon-color="blue">
        <cr-button id="safetyHubButton" slot="button-container"
            class="action-button" on-click="onSafetyHubButtonClick_">
          $i18n{safetyHubEntryPointButtonLabel}
        </cr-button>
      </settings-safety-hub-module>
    </template>
  </template>
  <template is="dom-if"
      if="[[!enablePermissionSiteSettingsRadioButton_]]">
    <h2>$i18n{siteSettingsDefaultBehavior}</h2>
    <div id="notificationSubHeading"
        class="secondary radio-sub-heading">
      $i18n{siteSettingsNotificationsDefaultBehaviorDescription}
    </div>
    <cr-radio-group
        on-selected-changed="onNotificationTopLevelRadioChanged_">
      <cr-radio-button
          id="notificationAskRadioButton"
          name="notification-ask-radio-button"
          checked$="[[isNotificationAllowed_]]">
        <cr-icon icon="privacy:notifications"></cr-icon>
        $i18n{siteSettingsNotificationsAskState}
      </cr-radio-button>
      <settings-radio-group
          id="notificationCpssRadioGroup"
          pref="{{prefs.generated.notification}}"
          selectable-elements="cr-radio-button"
          hidden$="[[!isNotificationAllowed_]]">
        <cr-radio-button class="padded-radio-section"
            id="notificationAskQuiet"
            name="[[settingsStateEnum_.QUIET]]"
            pref="[[prefs.generated.notification]]"
            label="$i18n{siteSettingsNotificationsAskQuiet}">
        </cr-radio-button>
        <cr-radio-button class="padded-radio-section"
            id="notificationAskCpss"
            name="[[settingsStateEnum_.CPSS]]"
            pref="[[prefs.generated.notification]]"
            label="$i18n{siteSettingsNotificationsAskCPSS}">
        </cr-radio-button>
        <cr-radio-button class="padded-radio-section"
            id="notificationAskLoud"
            name="[[settingsStateEnum_.LOUD]]"
            pref="[[prefs.generated.notification]]"
            label="$i18n{siteSettingsNotificationsAskLoud}">
        </cr-radio-button>
      </settings-radio-group>
      <cr-radio-button class="two-line"
          id="notificationBlock"
          name="notification-block-radio-button"
          sub-label="$i18n{siteSettingsNotificationsBlockedSubLabel}"
          checked$="[[!isNotificationAllowed_]]">
        <cr-icon icon="privacy:notifications-off"></cr-icon>
        $i18n{siteSettingsNotificationsBlocked}
      </cr-radio-button>
    </cr-radio-group>
  </template>
</div>
<template is="dom-if"
    if="[[enablePermissionSiteSettingsRadioButton_]]">
  <settings-category-default-radio-group
      id="notificationDefaultRadioGroup"
      category="[[contentSettingsTypesEnum_.NOTIFICATIONS]]"
      allow-option-label="$i18n{siteSettingsNotificationsAskState}"
      allow-option-icon="privacy:notifications"
      block-option-label="$i18n{siteSettingsNotificationsBlocked}"
      block-option-icon="privacy:notifications-off"
      on-selected-changed="onNotificationTopLevelRadioChanged2_">
  </settings-category-default-radio-group>
  <div class="radio-group"
      hidden$="[[!isNotificationAllowed_]]">
    <h2 class="cpss-heading">$i18n{siteSettingsHowToShowRequests}</h2>
    <settings-radio-group
        id="notificationCpssRadioGroup"
        pref="{{prefs.generated.notification}}"
        selectable-elements="settings-collapse-radio-button">
      <settings-collapse-radio-button
          id="notificationAskQuiet"
          name="[[settingsStateEnum_.QUIET]]"
          pref="[[prefs.generated.notification]]"
          label="$i18n{siteSettingsNotificationsAskQuiet}"
          no-collapse>
      </settings-collapse-radio-button>
      <settings-collapse-radio-button
          id="notificationAskCpss"
          name="[[settingsStateEnum_.CPSS]]"
          pref="[[prefs.generated.notification]]"
          label="$i18n{siteSettingsNotificationsAskCPSS}"
          no-collapse>
      </settings-collapse-radio-button>
      <settings-collapse-radio-button
          id="notificationAskLoud"
          name="[[settingsStateEnum_.LOUD]]"
          pref="[[prefs.generated.notification]]"
          label="$i18n{siteSettingsNotificationsAskLoud}"
          no-collapse>
      </settings-collapse-radio-button>
    </settings-radio-group>
  </div>
</template>
<category-setting-exceptions
    category="[[contentSettingsTypesEnum_.NOTIFICATIONS]]"
    allow-header="$i18n{siteSettingsNotificationsAllowedExceptions}"
    block-header="$i18n{siteSettingsNotificationsBlockedExceptions}"
    search-filter="[[searchTerm]]">
</category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const NotificationsPageElementBase=RouteObserverMixin(SettingsViewMixin(WebUiListenerMixin(PrefsMixin(PolymerElement))));class NotificationsPageElement extends NotificationsPageElementBase{static get is(){return"settings-notifications-page"}static get template(){return getTemplate$R()}static get properties(){return{searchTerm:{type:String,notify:true,value:""},isGuest_:{type:Boolean,value(){return loadTimeData.getBoolean("isGuest")}},enablePermissionSiteSettingsRadioButton_:{type:Boolean,value:()=>loadTimeData.getBoolean("enablePermissionSiteSettingsRadioButton")},settingsStateEnum_:{type:Object,value:SettingsState},contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes},showNotificationPermissionsReview_:{type:Boolean,value:false},contentSettingEnum_:{type:Object,value:ContentSetting},shouldShowSafetyHub_:{type:Boolean,value(){return!loadTimeData.getBoolean("isGuest")}},isNotificationAllowed_:Boolean,notificationPermissionsReviewHeader_:String,notificationPermissionsReviewSubheader_:String}}siteSettingsBrowserProxy_=SiteSettingsBrowserProxyImpl.getInstance();safetyHubBrowserProxy_=SafetyHubBrowserProxyImpl.getInstance();metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();ready(){super.ready();this.updateNotificationState_();if(this.isGuest_){return}this.addWebUiListener(SafetyHubEvent.NOTIFICATION_PERMISSIONS_MAYBE_CHANGED,(sites=>this.onReviewNotificationPermissionListChanged_(sites)));this.safetyHubBrowserProxy_.getNotificationPermissionReview().then((sites=>this.onReviewNotificationPermissionListChanged_(sites)))}currentRouteChanged(newRoute,oldRoute){super.currentRouteChanged(newRoute,oldRoute);if(this.showNotificationPermissionsReview_){this.metricsBrowserProxy_.recordSafetyHubEntryPointShown(SafetyHubEntryPoint.NOTIFICATIONS)}}async onReviewNotificationPermissionListChanged_(permissions){if(this.showNotificationPermissionsReview_){return}this.showNotificationPermissionsReview_=!this.isGuest_&&permissions.length>0;this.notificationPermissionsReviewHeader_=await PluralStringProxyImpl.getInstance().getPluralString("safetyHubNotificationPermissionsPrimaryLabel",permissions.length);this.notificationPermissionsReviewSubheader_=await PluralStringProxyImpl.getInstance().getPluralString("safetyHubNotificationPermissionsSecondaryLabel",permissions.length)}async updateNotificationState_(){const[notificationDefaultValue]=await Promise.all([this.siteSettingsBrowserProxy_.getDefaultValueForContentType(ContentSettingsTypes.NOTIFICATIONS)]);this.isNotificationAllowed_=notificationDefaultValue.setting===ContentSetting.ASK}onNotificationTopLevelRadioChanged_(event){const radioButtonName=event.detail.value;switch(radioButtonName){case"notification-block-radio-button":this.setPrefValue("generated.notification",SettingsState.BLOCK);this.isNotificationAllowed_=false;break;case"notification-ask-radio-button":this.setPrefValue("generated.notification",SettingsState.CPSS);this.isNotificationAllowed_=true;break}}onNotificationTopLevelRadioChanged2_(event){const selected=event.detail.value;if(selected){this.setPrefValue("generated.notification",SettingsState.CPSS);this.isNotificationAllowed_=true}else{this.setPrefValue("generated.notification",SettingsState.BLOCK);this.isNotificationAllowed_=false}}onSafetyHubButtonClick_(){this.metricsBrowserProxy_.recordSafetyHubEntryPointClicked(SafetyHubEntryPoint.NOTIFICATIONS);Router.getInstance().navigateTo(routes.SAFETY_HUB)}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(NotificationsPageElement.is,NotificationsPageElement);function getTemplate$Q(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsPaymentHandler}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsPaymentHandlersDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.PAYMENT_HANDLER]]"
      allow-option-label=
          "$i18n{siteSettingsPaymentHandlersAllowed}"
      allow-option-icon="privacy:credit-card"
      block-option-label="$i18n{siteSettingsPaymentHandlersBlocked}"
      block-option-icon="privacy:credit-card-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.PAYMENT_HANDLER]]"
      allow-header=
          "$i18n{siteSettingsPaymentHandlersAllowedExceptions}"
      block-header=
          "$i18n{siteSettingsPaymentHandlersBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const PaymentHandlerPageElementBase=SettingsViewMixin(PolymerElement);class PaymentHandlerPageElement extends PaymentHandlerPageElementBase{static get is(){return"settings-payment-handler-page"}static get template(){return getTemplate$Q()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(PaymentHandlerPageElement.is,PaymentHandlerPageElement);function getTemplate$P(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsPdfDocuments}">
  <div class="radio-group">
    <div class="secondary">$i18n{siteSettingsPdfsDescription}</div>
    <h2>$i18n{siteSettingsDefaultBehavior}</h2>
    <div class="secondary radio-sub-heading">
      $i18n{siteSettingsDefaultBehaviorDescription}
    </div>
    <settings-radio-group
        pref="{{prefs.plugins.always_open_pdf_externally}}"
        selectable-elements="settings-collapse-radio-button">
      <settings-collapse-radio-button no-collapse
          pref="[[prefs.plugins.always_open_pdf_externally]]"
          label="$i18n{siteSettingsPdfsAllowed}"
          name="true"
          disabled="[[isGuest_]]"
          icon="cr:file-download">
      </settings-collapse-radio-button>
      <settings-collapse-radio-button no-collapse
          pref="[[prefs.plugins.always_open_pdf_externally]]"
          label="$i18n{siteSettingsPdfsBlocked}"
          name="false"
          disabled="[[isGuest_]]"
          icon="privacy:open-in-browser">
      </settings-collapse-radio-button>
    </settings-radio-group>
  </div>
</settings-subpage>
<!--_html_template_end_-->`}const PdfDocumentsPageElementBase=SettingsViewMixin(PolymerElement);class PdfDocumentsPageElement extends PdfDocumentsPageElementBase{static get is(){return"settings-pdf-documents-page"}static get template(){return getTemplate$P()}static get properties(){return{isGuest_:{type:Boolean,value(){return loadTimeData.getBoolean("isGuest")}}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(PdfDocumentsPageElement.is,PdfDocumentsPageElement);function getTemplate$O(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsCategoryPopups}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsPopupsDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.POPUPS]]"
      allow-option-label="$i18n{siteSettingsPopupsAllowed}"
      allow-option-icon="cr:open-in-new"
      block-option-label="$i18n{siteSettingsPopupsBlocked}"
      block-option-icon="privacy:open-in-new-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.POPUPS]]"
      allow-header="$i18n{siteSettingsPopupsAllowedExceptions}"
      block-header="$i18n{siteSettingsPopupsBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const PopupsPageElementBase=SettingsViewMixin(PolymerElement);class PopupsPageElement extends PopupsPageElementBase{static get is(){return"settings-popups-page"}static get template(){return getTemplate$O()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(PopupsPageElement.is,PopupsPageElement);function getTemplate$N(){return html`<!--_html_template_start_--><style include="cr-hidden-style settings-shared site-settings-shared"></style>

<settings-subpage page-title="$i18n{siteSettingsProtectedContent}"
    route-path$="[[routePath]]">


  <div class="radio-group">
    <div class="secondary">
      $i18n{siteSettingsProtectedContentDescription}
    </div>
    <h2>$i18n{siteSettingsDefaultBehavior}</h2>
    <div class="secondary radio-sub-heading">
      $i18n{siteSettingsDefaultBehaviorDescription}
    </div>
    <settings-radio-group
        pref="{{prefs.webkit.webprefs.encrypted_media_enabled}}"
        selectable-elements="settings-collapse-radio-button">
      <settings-collapse-radio-button no-collapse
          pref="[[prefs.webkit.webprefs.encrypted_media_enabled]]"
          label="$i18n{siteSettingsProtectedContentAllowed}"
          name="true"
          disabled$="[[isGuest_]]"
          icon="privacy:sync-saved-locally">
      </settings-collapse-radio-button>
      <settings-collapse-radio-button no-collapse
          pref="[[prefs.webkit.webprefs.encrypted_media_enabled]]"
          label="$i18n{siteSettingsProtectedContentBlocked}"
          sub-label="$i18n{siteSettingsProtectedContentBlockedSubLabel}"
          name="false"
          disabled$="[[isGuest_]]"
          icon="privacy:sync-saved-locally-off">
      </settings-collapse-radio-button>
    </settings-radio-group>
  </div>

</settings-subpage>
<!--_html_template_end_-->`}const ProtectedContentPageElementBase=SettingsViewMixin(PrefsMixin(PolymerElement));class ProtectedContentPageElement extends ProtectedContentPageElementBase{static get is(){return"settings-protected-content-page"}static get template(){return getTemplate$N()}static get properties(){return{searchTerm:{type:String,notify:true,value:""},isGuest_:{type:Boolean,value(){return loadTimeData.getBoolean("isGuest")}},contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(ProtectedContentPageElement.is,ProtectedContentPageElement);function getTemplate$M(){return html`<!--_html_template_start_-->  <style include="cr-shared-style settings-shared">:host{display:block}.column-header{margin-bottom:15px;margin-inline-start:20px;margin-top:15px}#radioGroup{padding:0 var(--cr-section-padding)}#radioGroupSubHeading{padding-bottom:10px}#appHandlerSubHeading{padding-bottom:10px}#appIcon{width:16px;height:16px;background-repeat:no-repeat;background-size:contain}settings-collapse-radio-button{--settings-collapse-toggle-min-height:var(--cr-section-min-height)}settings-collapse-radio-button:not(:first-of-type){--settings-collapse-separator-line:var(--cr-separator-line)}
  </style>
  <settings-subpage page-title="$i18n{siteSettingsCategoryHandlers}"
      route-path$="[[routePath]]">
    <div id="radioGroup">
      <div class="secondary">
        $i18n{siteSettingsProtocolHandlersDescription}
      </div>
      <h2>$i18n{siteSettingsDefaultBehavior}</h2>
      <div id="radioSubHeading" class="secondary">
        $i18n{siteSettingsDefaultBehaviorDescription}
      </div>
      <settings-radio-group
          id="protcolHandlersRadio"
          pref="[[handlersEnabledPref_]]"
          on-change="onToggleChange_"
          selectable-elements="settings-collapse-radio-button">
        <settings-collapse-radio-button no-collapse
            id="protcolHandlersRadioAllow"
            pref="[[handlersEnabledPref_]]"
            label="$i18n{siteSettingsProtocolHandlersAllowed}"
            name="true"
            disabled$="[[isGuest_]]"
            icon="privacy:protocol-handler">
        </settings-collapse-radio-button>
        <settings-collapse-radio-button no-collapse
            id="protcolHandlersRadioBlock"
            pref="[[handlersEnabledPref_]]"
            label="$i18n{siteSettingsProtocolHandlersBlocked}"
            name="false"
            disabled$="[[isGuest_]]"
            icon="privacy:protocol-handler-off">
        </settings-collapse-radio-button>
      </settings-radio-group>
    </div>

    <template is="dom-repeat" items="[[protocols]]" as="protocol">
      <div class="column-header">[[protocol.protocol_display_name]]</div>

      <div class="list-frame menu-content vertical-list">
        <template is="dom-repeat" items="[[protocol.handlers]]">

          <div class="list-item">
            <site-favicon url="[[item.host]]"></site-favicon>
            <div class="middle" >
              <div class="protocol-host">
                <span class="url-directionality">[[item.host]]</span>
              </div>
              <div class="secondary protocol-default"
                  hidden$="[[!item.is_default]]">
                $i18n{handlerIsDefault}
              </div>
            </div>

            <cr-icon-button class="icon-more-vert" on-click="showMenu_"
                title="$i18n{moreActions}"></cr-icon-button>
          </div>
        </template>
      </div>
    </template>

    <cr-action-menu role-description="$i18n{menu}">
      <button class="dropdown-item" on-click="onDefaultClick_"
          id="defaultButton" disabled$="[[actionMenuModel_.is_default]]">
        $i18n{handlerSetDefault}
      </button>
      <button class="dropdown-item" on-click="onRemoveClick_"
          id="removeButton">
        $i18n{handlerRemove}
      </button>
    </cr-action-menu>

    <template is="dom-if" if="[[ignoredProtocols.length]]">
      <div class="column-header">
        $i18n{siteSettingsProtocolHandlersBlockedExceptions}
      </div>
      <div class="list-frame menu-content vertical-list">
        <template is="dom-repeat" items="[[ignoredProtocols]]">
          <div class="list-item">
            <site-favicon url="[[item.host]]"></site-favicon>
            <div class="middle" >
              <div class="protocol-host">
                <span class="url-directionality">[[item.host]]</span></div>
              <div class="secondary protocol-protocol">
                [[item.protocol_display_name]]
              </div>
            </div>
            <cr-icon-button class="icon-clear" id="removeIgnoredButton"
                on-click="onRemoveIgnored_" title="$i18n{handlerRemove}">
            </cr-icon-button>
          </div>
        </template>
      </div>
    </template>

    <div class="column-header" hidden$="[[!showAppsProtocolHandlersTitle_]]">
      <h2>$i18n{siteSettingsAppProtocolHandlers}</h2>
    </div>

    <div class="column-header" hidden$="[[!appAllowedProtocols.length]]">
      <div id="appHandlerSubHeading" class="secondary">
        $i18n{siteSettingsAppAllowedProtocolHandlersDescription}
      </div>
    </div>

    <template is="dom-repeat" items="[[appAllowedProtocols]]" as="appProtocol">
      <div class="column-header">[[appProtocol.protocol_display_name]]</div>
      <div class="list-frame menu-content vertical-list">
        <template is="dom-repeat" items="[[appProtocol.handlers]]">
          <div class="list-item">
            <div id="appIcon"
                style="background-image: url('chrome://app-icon/[[item.app_id]]/16')">
            </div>
            <div class="middle protocol-app-name">
              <span class$="[[getNameCssClass_(item)]]">
                [[getNameText_(item)]]
              </span>
            </div>
            <cr-icon-button class="icon-clear" id="removeAppHandlerButton"
                on-click="onRemoveAppAllowedHandlerButtonClick_"
                title="$i18n{handlerRemove}">
            </cr-icon-button>
          </div>
        </template>
      </div>
    </template>

    <div class="column-header" hidden$="[[!appDisallowedProtocols.length]]">
      <div id="appHandlerSubHeading" class="secondary">
        $i18n{siteSettingsAppDisallowedProtocolHandlersDescription}
      </div>
    </div>

    <template is="dom-repeat" items="[[appDisallowedProtocols]]"
        as="appProtocol">
      <div class="column-header">[[appProtocol.protocol_display_name]]</div>
      <div class="list-frame menu-content vertical-list">
        <template is="dom-repeat" items="[[appProtocol.handlers]]">
          <div class="list-item">
            <div id="appIcon"
                style="background-image: url('chrome://app-icon/[[item.app_id]]/16')">
            </div>
            <div class="middle protocol-app-name">
              <span class$="[[getNameCssClass_(item)]]">
                [[getNameText_(item)]]
              </span>
            </div>
            <cr-icon-button class="icon-clear" id="removeAppHandlerButton"
                on-click="onRemoveAppDisallowedHandlerButtonClick_"
                title="$i18n{handlerRemove}">
            </cr-icon-button>
          </div>
        </template>
      </div>
    </template>
  </settings-subpage>
<!--_html_template_end_-->`}const ProtocolHandlersElementBase=SettingsViewMixin(WebUiListenerMixin(SiteSettingsMixin(PolymerElement)));class ProtocolHandlersElement extends ProtocolHandlersElementBase{static get is(){return"protocol-handlers"}static get template(){return getTemplate$M()}static get properties(){return{protocols:Array,appAllowedProtocols:{type:Array,value(){return[]}},appDisallowedProtocols:{type:Array,value(){return[]}},showAppsProtocolHandlersTitle_:{type:Boolean,value:false},actionMenuModel_:Object,toggleOffLabel:String,toggleOnLabel:String,ignoredProtocols:Array,handlersEnabledPref_:{type:Object,value(){return{type:chrome.settingsPrivate.PrefType.BOOLEAN,value:false}}}}}ready(){super.ready();this.addWebUiListener("setHandlersEnabled",(enabled=>this.setHandlersEnabled_(enabled)));this.addWebUiListener("setProtocolHandlers",(protocols=>this.setProtocolHandlers_(protocols)));this.addWebUiListener("setIgnoredProtocolHandlers",(ignoredProtocols=>this.setIgnoredProtocolHandlers_(ignoredProtocols)));this.browserProxy.observeProtocolHandlers();this.addWebUiListener("setAppAllowedProtocolHandlers",this.setAppAllowedProtocolHandlers_.bind(this));this.addWebUiListener("setAppDisallowedProtocolHandlers",this.setAppDisallowedProtocolHandlers_.bind(this));this.browserProxy.observeAppProtocolHandlers()}computeHandlersDescription_(){return this.handlersEnabledPref_.value?this.toggleOnLabel:this.toggleOffLabel}setHandlersEnabled_(enabled){this.set("handlersEnabledPref_.value",enabled)}setProtocolHandlers_(protocols){this.protocols=protocols}setIgnoredProtocolHandlers_(ignoredProtocols){this.ignoredProtocols=ignoredProtocols}setAppAllowedProtocolHandlers_(appAllowedProtocols){this.appAllowedProtocols=appAllowedProtocols;this.updateShowAppsProtocolHandlersTitle_()}setAppDisallowedProtocolHandlers_(appDisallowedProtocols){this.appDisallowedProtocols=appDisallowedProtocols;this.updateShowAppsProtocolHandlersTitle_()}updateShowAppsProtocolHandlersTitle_(){this.showAppsProtocolHandlersTitle_=this.appAllowedProtocols&&this.appAllowedProtocols.length>0||this.appDisallowedProtocols&&this.appDisallowedProtocols.length>0}closeActionMenu_(){this.shadowRoot.querySelector("cr-action-menu").close();this.actionMenuModel_=null}onToggleChange_(){this.browserProxy.setProtocolHandlerDefault(!!this.handlersEnabledPref_.value)}onDefaultClick_(){const item=this.actionMenuModel_;this.browserProxy.setProtocolDefault(item.protocol,item.spec);this.closeActionMenu_()}onRemoveClick_(){const item=this.actionMenuModel_;this.browserProxy.removeProtocolHandler(item.protocol,item.spec);this.closeActionMenu_()}onRemoveAppAllowedHandlerButtonClick_(event){const item=event.model.item;this.browserProxy.removeAppAllowedHandler(item.protocol,item.spec,item.app_id)}onRemoveAppDisallowedHandlerButtonClick_(event){const item=event.model.item;this.browserProxy.removeAppDisallowedHandler(item.protocol,item.spec,item.app_id)}onRemoveIgnored_(event){const item=event.model.item;this.browserProxy.removeProtocolHandler(item.protocol,item.spec)}showMenu_(event){this.actionMenuModel_=event.model.item;this.shadowRoot.querySelector("cr-action-menu").showAt(event.target)}getNameCssClass_(item){return item.app_name?"":"url-directionality"}getNameText_(item){return item.app_name||item.host}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(ProtocolHandlersElement.is,ProtocolHandlersElement);function getTemplate$L(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsSensors}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsMotionSensorsDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.SENSORS]]"
      allow-option-label="$i18n{siteSettingsMotionSensorsAllowed}"
      allow-option-icon="privacy:sensors"
      block-option-label="$i18n{siteSettingsMotionSensorsBlocked}"
      block-option-sub-label=
          "$i18n{siteSettingsMotionSensorsBlockedSubLabel}"
      block-option-icon="privacy:sensors-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.SENSORS]]" read-only-list
      allow-header="$i18n{siteSettingsMotionSensorsAllowedExceptions}"
      block-header="$i18n{siteSettingsMotionSensorsBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const SensorsPageElementBase=SettingsViewMixin(PolymerElement);class SensorsPageElement extends SensorsPageElementBase{static get is(){return"settings-sensors-page"}static get template(){return getTemplate$L()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SensorsPageElement.is,SensorsPageElement);function getTemplate$K(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsSerialPorts}"
    learn-more-url="$i18n{chooserSerialOverviewUrl}"
    route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsSerialPortsDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.SERIAL_PORTS]]"
      allow-option-label="$i18n{siteSettingsSerialPortsAllowed}"
      allow-option-icon="privacy:developer-board"
      block-option-label="$i18n{siteSettingsSerialPortsBlocked}"
      block-option-icon="privacy:developer-board-off">
  </settings-category-default-radio-group>
  <chooser-exception-list
      category="[[contentSettingsTypesEnum_.SERIAL_PORTS]]"
      chooser-type="[[chooserTypeEnum_.SERIAL_PORTS]]">
  </chooser-exception-list>
</settings-subpage>
<!--_html_template_end_-->`}const SerialPortsPageElementBase=SettingsViewMixin(PolymerElement);class SerialPortsPageElement extends SerialPortsPageElementBase{static get is(){return"settings-serial-ports-page"}static get template(){return getTemplate$K()}static get properties(){return{contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes},chooserTypeEnum_:{type:Object,value:ChooserType}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SerialPortsPageElement.is,SerialPortsPageElement);function getTemplate$J(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteDataPageTitle}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
<div class="content-settings-header secondary">
  $i18n{siteDataPageDescription}
</div>
<div class="radio-group">
  <h2>$i18n{siteDataPageDefaultBehavior}</h2>
  <div class="secondary radio-group-sub-heading">
    $i18n{siteDataPagedefaultBehaviorDescription}
  </div>
  <settings-radio-group id="defaultGroup" no-set-pref
      pref="{{prefs.generated.cookie_default_content_setting}}"
      selectable-elements="cr-radio-button, settings-collapse-radio-button"
      on-change="onDefaultRadioChange_">
    <settings-collapse-radio-button id="defaultAllow" no-collapse
        name="[[contentSettingEnum_.ALLOW]]"
        pref="[[prefs.generated.cookie_default_content_setting]]"
        label="$i18n{siteDataPageAllowRadioLabel}"
        sub-label="$i18n{siteDataPageAllowRadioSubLabel}"
        icon="privacy:database">
    </settings-collapse-radio-button>
    <settings-collapse-radio-button id="defaultSessionOnly" no-collapse
        class="two-line"
        name="[[contentSettingEnum_.SESSION_ONLY]]"
        pref="[[prefs.generated.cookie_default_content_setting]]"
        label="$i18n{siteDataPageClearOnExitRadioLabel}"
        sub-label="$i18n{siteDataPageClearOnExitRadioSubLabel}"
        icon="privacy:database">
    </settings-collapse-radio-button>
    <settings-collapse-radio-button id="defaultBlock" no-collapse
        class="two-line"
        name="[[contentSettingEnum_.BLOCK]]"
        pref="[[prefs.generated.cookie_default_content_setting]]"
        label="$i18n{siteDataPageBlockRadioLabel}"
        sub-label="$i18n{siteDataPageBlockRadioSublabel}"
        icon="privacy:database-off">
    </settings-collapse-radio-button>
  </settings-radio-group>
</div>
<div id="exceptionHeader">
  <h2>$i18n{siteDataPageCustomizedBehaviorHeading}</h2>
  <div id="exceptionHeaderSubLabel" class="secondary">
    $i18n{siteDataPageCustomizedBehaviorDescription}
  </div>
</div>
<site-list id="allowExceptionsList"
    category="[[cookiesContentSettingType_]]"
    category-subtype="[[contentSettingEnum_.ALLOW]]"
    category-header="$i18n{siteDataPageAllowExceptionsSubHeading}"
    read-only-list="[[exceptionListsReadOnly_]]"
    search-filter="[[searchTerm]]"
    cookies-exception-type="site-data">
</site-list>
<site-list id="sessionOnlyExceptionsList"
    category="[[cookiesContentSettingType_]]"
    category-subtype="[[contentSettingEnum_.SESSION_ONLY]]"
    category-header="$i18n{siteDataPageDeleteOnExitExceptionsSubHeading}"
    read-only-list="[[exceptionListsReadOnly_]]"
    search-filter="[[searchTerm]]"
    cookies-exception-type="site-data">
</site-list>
<!-- Shows all block-exceptions (in contrast to allow and session above). -->
<site-list id="blockExceptionsList"
    category="[[cookiesContentSettingType_]]"
    category-subtype="[[contentSettingEnum_.BLOCK]]"
    category-header="$i18n{siteDataPageBlockExceptionsSubHeading}"
    read-only-list="[[exceptionListsReadOnly_]]"
    search-filter="[[searchTerm]]"
    cookies-exception-type="combined">
</site-list>
<template is="dom-if" if="[[showDefaultBlockDialog_]]" restamp>
  <cr-dialog id="defaultBlockDialog" show-on-attach>
    <div slot="title">$i18n{siteDataPageBlockConfirmDialogTitle}</div>
    <div slot="body">$i18n{siteDataPageBlockConfirmDialogDescription}</div>
    <div slot="button-container">
    <cr-button id="defaultBlockDialogCancel" class="cancel-button"
        on-click="onDefaultBlockDialogCancel_">
        $i18n{siteDataPageBlockConfirmDialogCancelButton}
    </cr-button>
    <cr-button id="defaultBlockDialogConfirm" class="action-button"
        on-click="onDefaultBlockDialogConfirm_">
        $i18n{siteDataPageBlockConfirmDialogConfirmButton}
    </cr-button>
    </div>
  </cr-dialog>
</template>
</settings-subpage>
<!--_html_template_end_-->`}const SettingsSiteDataElementBase=SettingsViewMixin(PrefsMixin(PolymerElement));class SettingsSiteDataElement extends SettingsSiteDataElementBase{static get is(){return"settings-site-data"}static get template(){return getTemplate$J()}static get properties(){return{searchTerm:{type:String,notify:true,value:""},cookiesContentSettingType_:{type:String,value:ContentSettingsTypes.COOKIES},contentSettingEnum_:{type:Object,value:ContentSetting},exceptionListsReadOnly_:{type:Boolean,value:false},showDefaultBlockDialog_:Boolean}}static get observers(){return[`onGeneratedPrefsUpdated_(\n        prefs.generated.cookie_default_content_setting)`]}onGeneratedPrefsUpdated_(){const pref=this.getPref("generated.cookie_default_content_setting");this.exceptionListsReadOnly_=pref.enforcement===chrome.settingsPrivate.Enforcement.ENFORCED}onDefaultRadioChange_(){const selected=this.$.defaultGroup.selected;if(selected===ContentSetting.BLOCK){this.showDefaultBlockDialog_=true}else{this.$.defaultGroup.sendPrefChange()}}onDefaultBlockDialogCancel_(){this.$.defaultGroup.resetToPrefValue();this.showDefaultBlockDialog_=false;focusWithoutInk(this.$.defaultBlock)}onDefaultBlockDialogConfirm_(){this.$.defaultGroup.sendPrefChange();this.showDefaultBlockDialog_=false;focusWithoutInk(this.$.defaultBlock)}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsSiteDataElement.is,SettingsSiteDataElement);function getTemplate$I(){return html`<!--_html_template_start_--><style include="settings-shared">:host{align-items:center;position:relative;vertical-align:middle}.policy-icon{margin-inline-start:16px;padding:8px}.settings-row{flex:1}</style>

<div class="list-item focus-row-active">
  <div class="settings-row middle no-min-width text-elide">
    <span class="url-directionality">[[exception.displayName]]</span>
  </div>
  <template is="dom-if" if="[[shouldShowPolicyPrefIndicator_(exception)]]">
    <cr-policy-pref-indicator class="policy-icon"
        pref="[[getPolicyPref_(exception)]]"
        icon-aria-label="[[label]]">
    </cr-policy-pref-indicator>
  </template>
  <cr-icon-button id="resetSite" class="icon-delete-gray"
      hidden="[[shouldShowPolicyPrefIndicator_(exception)]]"
      on-click="onResetButtonClick_"
      aria-label="$i18n{siteSettingsActionReset}">
  </cr-icon-button>
</div>
<!--_html_template_end_-->`}class SiteDetailsPermissionDeviceEntryElement extends PolymerElement{static get is(){return"site-details-permission-device-entry"}static get template(){return getTemplate$I()}static get properties(){return{exception:Object}}getPolicyPref_(){return this.exception.sites.find((site=>site.enforcement===chrome.settingsPrivate.Enforcement.ENFORCED&&!!site.controlledBy))||null}shouldShowPolicyPrefIndicator_(){return!!this.getPolicyPref_()}onResetButtonClick_(){assert(this.exception.sites.length>0);SiteSettingsBrowserProxyImpl.getInstance().resetChooserExceptionForSite(this.exception.chooserType,this.exception.sites[0].origin,this.exception.object)}}customElements.define(SiteDetailsPermissionDeviceEntryElement.is,SiteDetailsPermissionDeviceEntryElement);function getTemplate$H(){return html`<!--_html_template_start_-->    <style include="settings-shared md-select"></style>
    <div id="details" hidden$="[[shouldHideCategory_(site)]]">
      <div id="permissionItem"
          class$="list-item [[permissionInfoStringClass_(site.source,
                                            category,
                                            site.setting,
                                            systemPermissionWarningKey_)]]">
        <div>
          <cr-icon icon="[[icon]]" aria-hidden="true" role="presentation">
          </cr-icon>
        </div>
        <div class="middle" id="permissionHeader">
          [[label]]
          <div class="secondary" id="permissionSecondary"
              hidden$="[[!showSystemPermissionWarning_(site.source,
                  category,site.setting,systemPermissionWarningKey_)]]"
              inner-h-t-m-l="[[getSystemPermissionWarning_(
                  systemPermissionWarningKey_)]]">
          </div>
          <div class="secondary" id="permissionSecondary"
              hidden$="[[!hasPermissionInfoString_(site.source,
                                        category,
                                        site.setting, 
                                        systemPermissionWarningKey_)]]"
              inner-h-t-m-l="[[permissionInfoString_(
                site.source,
                category,
                site.setting,
                '$i18nPolymer{siteSettingsAllowlisted}',
                '$i18nPolymer{siteSettingsAdsBlockBlocklistedSingular}',
                '$i18nPolymer{siteSettingsAdsBlockNotBlocklistedSingular}',
                '$i18nPolymer{siteSettingsSourceEmbargo}',
                '$i18nPolymer{siteSettingsSourceInsecureOrigin}',
                '$i18nPolymer{siteSettingsSourceKillSwitch}',

                '$i18nPolymer{siteSettingsSourceExtensionAllow}',
                '$i18nPolymer{siteSettingsSourceExtensionBlock}',
                '$i18nPolymer{siteSettingsSourceExtensionAsk}',
                '$i18nPolymer{siteSettingsSourcePolicyAllow}',
                '$i18nPolymer{siteSettingsSourcePolicyBlock}',
                '$i18nPolymer{siteSettingsSourcePolicyAsk}')]]">
          </div>
        </div>
        <select id="permission" class="md-select"
            aria-label$="[[label]]"
            aria-describedby="permissionSecondary"
            on-change="onPermissionSelectionChange_"
            disabled$="[[!isPermissionUserControlled_(site.source, category,
                              site.setting, systemPermissionWarningKey_)]]">
          <option id="default" value$="[[contentSettingEnum_.DEFAULT]]">
            [[defaultSettingString_(
                defaultSetting_,
                category,
                useAutomaticLabel,
                useBlockIfUnfamiliarLabelForDefault)]]
          </option>
          <option id="allow" value$="[[contentSettingEnum_.ALLOW]]"
              hidden$="[[!showAllowedSetting_(category)]]">
            $i18n{siteSettingsActionAllow}
          </option>
          <option id="block" value$="[[contentSettingEnum_.BLOCK]]">
            [[blockSettingString_(
                category,
                '$i18n{siteSettingsActionBlock}',
                '$i18n{siteSettingsActionMute}')]]
          </option>
          <option id="ask" value$="[[contentSettingEnum_.ASK]]"
              hidden$="[[!showAskSetting_(category, site.setting,
                                          site.source)]]">
            $i18n{siteSettingsActionAsk}
          </option>
        </select>
      </div>
      <div class="list-frame" role="table">
        <template is="dom-repeat" items="[[chooserExceptions_]]">
          <site-details-permission-device-entry exception="[[item]]">
          </site-details-permission-device-entry>
        </template>
      </div>
    </div>
<!--_html_template_end_-->`}const SiteDetailsPermissionElementBase=ListPropertyUpdateMixin(SiteSettingsMixin(WebUiListenerMixin(I18nMixin(PolymerElement))));class SiteDetailsPermissionElement extends SiteDetailsPermissionElementBase{static get is(){return"site-details-permission"}static get template(){return getTemplate$H()}static get properties(){return{useAutomaticLabel:{type:Boolean,value:false},useBlockIfUnfamiliarLabelForDefault:{type:Boolean,value:false},site:Object,defaultSetting_:String,label:String,icon:String,contentSettingEnum_:{type:Object,value:ContentSetting},chooserExceptions_:{type:Array,value(){return[]}},chooserType:{type:String,value:ChooserType.NONE},systemPermissionWarningKey_:{type:String,value:null,observer:"attachSystemPermissionSettingsLinkClick_"}}}static get observers(){return["siteChanged_(site)","updateChooserExceptions_(site, chooserType)"]}connectedCallback(){super.connectedCallback();this.addWebUiListener("contentSettingCategoryChanged",(category=>this.onDefaultSettingChanged_(category)));this.addWebUiListener("contentSettingChooserPermissionChanged",((category,chooserType)=>{if(category===this.category&&chooserType===this.chooserType){this.updateChooserExceptions_()}}));this.addWebUiListener("osGlobalPermissionChanged",(messages=>{this.setSystemPermissionWarningKey_(messages)}))}updateChooserExceptions_(){if(!this.site||this.chooserType===ChooserType.NONE){return}this.browserProxy.getChooserExceptionList(this.chooserType).then((exceptionList=>this.processChooserExceptions_(exceptionList)))}updateOsPermissionWarning_(){this.browserProxy.getSystemDeniedPermissions().then((messages=>{this.setSystemPermissionWarningKey_(messages)}))}processChooserExceptions_(exceptionList){const siteFilter=site=>{const url=this.toUrl(site.origin);const targetUrl=this.toUrl(this.site.origin);if(!url||!targetUrl){return false}return site.incognito===this.site.incognito&&url.origin===targetUrl.origin};const exceptions=exceptionList.filter((exception=>exception.sites.some((site=>siteFilter(site))))).map((exception=>{const sites=exception.sites.filter((site=>siteFilter(site))).map((site=>this.expandSiteException(site)));return Object.assign(exception,{sites:sites})}));this.updateList("chooserExceptions_",(x=>x.displayName),exceptions,true)}siteChanged_(site){if(!site){return}this.updateOsPermissionWarning_();if(site.source===SiteSettingSource.DEFAULT){this.defaultSetting_=site.setting;this.$.permission.value=ContentSetting.DEFAULT}else{this.updateDefaultPermission_();this.$.permission.value=site.setting}if(this.isNonDefaultAsk_(site.setting,site.source)){assert(this.$.permission.value===ContentSetting.ASK,"'Ask' should only show up when it's currently selected.")}}updateDefaultPermission_(){this.browserProxy.getDefaultValueForContentType(this.category).then((defaultValue=>{this.defaultSetting_=defaultValue.setting}))}onDefaultSettingChanged_(category){if(category===this.category){this.updateDefaultPermission_()}}onPermissionSelectionChange_(){this.browserProxy.setOriginPermissions(this.site.origin,this.category,this.$.permission.value)}useCustomSoundLabels_(category){return category===ContentSettingsTypes.SOUND}defaultSettingString_(defaultSetting,category,useAutomaticLabel,useBlockIfUnfamiliarLabel){if(defaultSetting===undefined||category===undefined||useAutomaticLabel===undefined){return""}if(useBlockIfUnfamiliarLabel){return this.i18n("siteSettingsActionBlockOnUnfamiliarSitesDefaultMenu")}if(defaultSetting===ContentSetting.ASK){return this.i18n("siteSettingsActionAskDefault")}else if(defaultSetting===ContentSetting.ALLOW){if(this.useCustomSoundLabels_(category)&&useAutomaticLabel){return this.i18n("siteSettingsActionAutomaticDefault")}return this.i18n("siteSettingsActionAllowDefault")}else if(defaultSetting===ContentSetting.BLOCK){if(this.useCustomSoundLabels_(category)){return this.i18n("siteSettingsActionMuteDefault")}return this.i18n("siteSettingsActionBlockDefault")}assertNotReached(`No string for ${this.category}'s default of ${defaultSetting}`)}blockSettingString_(category,blockString,muteString){if(this.useCustomSoundLabels_(category)){return muteString}return blockString}shouldHideCategory_(){return!this.site}hasPermissionInfoString_(source,category,setting){return String(this.permissionInfoString_(source,category,setting,null,null,null,null,null,null,null,null,null,null,null,null))!==""}permissionInfoStringClass_(source,category,setting){return this.hasPermissionInfoString_(source,category,setting)||this.hasSystemPermissionWarning_()?"two-line":""}isPermissionUserControlled_(source){return!(source===SiteSettingSource.ALLOWLIST||source===SiteSettingSource.POLICY||source===SiteSettingSource.EXTENSION||source===SiteSettingSource.KILL_SWITCH||source===SiteSettingSource.INSECURE_ORIGIN)&&!this.hasSystemPermissionWarning_()}showAllowedSetting_(category){return!(category===ContentSettingsTypes.SERIAL_PORTS||category===ContentSettingsTypes.USB_DEVICES||category===ContentSettingsTypes.BLUETOOTH_SCANNING||category===ContentSettingsTypes.FILE_SYSTEM_WRITE||category===ContentSettingsTypes.HID_DEVICES||category===ContentSettingsTypes.BLUETOOTH_DEVICES)}showAskSetting_(category,setting,source){if(category===ContentSettingsTypes.SERIAL_PORTS||category===ContentSettingsTypes.USB_DEVICES||category===ContentSettingsTypes.HID_DEVICES||category===ContentSettingsTypes.BLUETOOTH_DEVICES){return true}if(category===ContentSettingsTypes.BLUETOOTH_SCANNING||category===ContentSettingsTypes.FILE_SYSTEM_WRITE){return true}return this.isNonDefaultAsk_(setting,source)}setSystemPermissionWarningKey_(messages){this.set("systemPermissionWarningKey_",(category=>{if(!messages.includes(category)){return null}switch(category){case ContentSettingsTypes.CAMERA:return"siteSettingsCameraBlockedByOs";case ContentSettingsTypes.MIC:return"siteSettingsMicrophoneBlockedByOs";case ContentSettingsTypes.GEOLOCATION:return"siteSettingsLocationBlockedByOs";default:return null}})(this.category))}onSystemPermissionSettingsLinkClick_(event){event.preventDefault();if(this.category!==null){this.browserProxy.openSystemPermissionSettings(this.category)}}getSystemPermissionWarning_(){if(this.systemPermissionWarningKey_!==null){return this.i18nAdvanced(this.systemPermissionWarningKey_,{tags:["a"],attrs:["id"]})}return sanitizeInnerHtml("")}attachSystemPermissionSettingsLinkClick_(){const element=this.shadowRoot?.querySelector("#openSystemSettingsLink");if(element!==null&&element!==undefined){element.addEventListener("click",(me=>{this.onSystemPermissionSettingsLinkClick_(me)}));const settingsPageName=(()=>{switch(this.category){case ContentSettingsTypes.CAMERA:return"Camera";case ContentSettingsTypes.MIC:return"Microphone";case ContentSettingsTypes.GEOLOCATION:return"Location";default:return null}})();if(settingsPageName){element.setAttribute("aria-label",`System Settings: ${settingsPageName}`)}}}hasSystemPermissionWarning_(){return this.systemPermissionWarningKey_!==null}showSystemPermissionWarning_(source,category,setting){if(this.hasPermissionInfoString_(source,category,setting)){return false}return this.hasSystemPermissionWarning_()}isNonDefaultAsk_(setting,source){if(setting!==ContentSetting.ASK||source===SiteSettingSource.DEFAULT){return false}assert(source===SiteSettingSource.EXTENSION||source===SiteSettingSource.POLICY||source===SiteSettingSource.PREFERENCE,"Only extensions, enterprise policy or preferences can change "+"the setting to ASK.");return true}permissionInfoString_(source,category,setting,allowlistString,adsBlocklistString,adsBlockString,embargoString,insecureOriginString,killSwitchString,extensionAllowString,extensionBlockString,extensionAskString,policyAllowString,policyBlockString,policyAskString){if(source===undefined||category===undefined||setting===undefined){return window.trustedTypes.emptyHTML}const extensionStrings={};extensionStrings[ContentSetting.ALLOW]=extensionAllowString;extensionStrings[ContentSetting.BLOCK]=extensionBlockString;extensionStrings[ContentSetting.ASK]=extensionAskString;const policyStrings={};policyStrings[ContentSetting.ALLOW]=policyAllowString;policyStrings[ContentSetting.BLOCK]=policyBlockString;policyStrings[ContentSetting.ASK]=policyAskString;function htmlOrNull(str){return str===null?null:sanitizeInnerHtml(str)}if(source===SiteSettingSource.ALLOWLIST){return htmlOrNull(allowlistString)}else if(source===SiteSettingSource.ADS_FILTER_BLACKLIST){assert(ContentSettingsTypes.ADS===category,"The ads filter blocklist only applies to Ads.");return htmlOrNull(adsBlocklistString)}else if(category===ContentSettingsTypes.ADS&&setting===ContentSetting.BLOCK){return htmlOrNull(adsBlockString)}else if(source===SiteSettingSource.EMBARGO){assert(ContentSetting.BLOCK===setting,"Embargo is only used to block permissions.");return htmlOrNull(embargoString)}else if(source===SiteSettingSource.EXTENSION){return htmlOrNull(extensionStrings[setting])}else if(source===SiteSettingSource.INSECURE_ORIGIN){assert(ContentSetting.BLOCK===setting,"Permissions can only be blocked due to insecure origins.");return htmlOrNull(insecureOriginString)}else if(source===SiteSettingSource.KILL_SWITCH){assert(ContentSetting.BLOCK===setting,"The permissions kill switch can only be used to block permissions.");return htmlOrNull(killSwitchString)}else if(source===SiteSettingSource.POLICY){return htmlOrNull(policyStrings[setting])}else if(source===SiteSettingSource.DEFAULT||source===SiteSettingSource.PREFERENCE){return window.trustedTypes.emptyHTML}assertNotReached(`No string for ${category} setting source '${source}'`)}}customElements.define(SiteDetailsPermissionElement.is,SiteDetailsPermissionElement);function getTemplate$G(){return html`<!--_html_template_start_-->    <style include="cr-shared-style settings-shared action-link">.favicon-image{margin:2px}#storage{padding-inline-end:0}#storageText{display:flex}#resetSettingsButton{margin-top:24px}#usageHeader{padding:0 var(--cr-section-padding)}#usageDetails{align-items:center;display:flex;flex:1;flex-direction:row}#fpsPolicyContainer{display:flex;padding:8px}
    </style>

  <settings-subpage page-title="[[pageTitle_]]" route-path$="[[routePath]]">
    <!-- Confirm reset settings dialog. -->
    <cr-dialog id="confirmResetSettings" close-text="$i18n{close}"
        on-close="onResetSettingsDialogClosed_">
      <div slot="title">$i18n{siteSettingsSiteResetDialogTitle}</div>
      <div slot="body">
        [[i18n('siteSettingsSiteResetConfirmation', pageTitle_)]]
      </div>
      <div slot="button-container">
        <cr-button class="cancel-button" on-click="onCloseDialog_">
          $i18n{cancel}
        </cr-button>
        <cr-button class="action-button" on-click="onResetSettings_">
          $i18n{siteSettingsSiteResetAll}
        </cr-button>
      </div>
    </cr-dialog>

    <!-- Confirm clear storage dialog. -->
    <cr-dialog id="confirmClearStorage" close-text="$i18n{close}"
        on-close="onClearStorageDialogClosed_">
      <style include="clear-storage-dialog-shared"></style>
      <div slot="title">
        $i18n{siteSettingsSiteDeleteStorageDialogTitle}
      </div>
      <div slot="body">
        [[i18n('siteSettingsSiteClearStorageConfirmationNew', pageTitle_)]]
        <div class="detail-list">
          <div class="detail">
            <cr-icon icon="all-sites:logout" aria-hidden="true"
                role="presentation"></cr-icon>
            $i18n{siteSettingsSiteClearStorageSignOut}
          </div>
          <div class="detail">
            <cr-icon icon="all-sites:offline" aria-hidden="true"
                role="presentation"></cr-icon>
            $i18n{siteSettingsSiteDeleteStorageOfflineData}
          </div>
          <div class="detail" id="adPersonalization">
            <cr-icon icon="all-sites:tag" aria-hidden="true"
                role="presentation"></cr-icon>
            $i18n{siteSettingsRemoveSiteAdPersonalization}
          </div>
        </div>
      </div>
      <div slot="button-container">
        <cr-button class="cancel-button" on-click="onCloseDialog_">
          $i18n{cancel}
        </cr-button>
        <cr-button class="action-button" on-click="onClearStorage_">
          $i18n{siteSettingsSiteClearStorage}
        </cr-button>
      </div>
    </cr-dialog>

    <div id="usage">
      <div id="usageHeader">
        <h2 class="first">$i18n{siteSettingsUsage}</h2>
      </div>
      <div class="list-frame">
        <div class="list-item" id="noStorage"
            hidden$="[[hasUsage_(storedData_, numCookies_)]]">
          <div class="start">$i18n{siteSettingsUsageNone}</div>
        </div>
        <div class="list-item" id="storage"
            hidden$="[[!hasUsage_(storedData_, numCookies_)]]">
          <div id="usageDetails">
            <div>
              <div id="storageText">
                <div id="storedData" hidden$="[[!storedData_]]">
                  [[storedData_]]
                </div>
                <div hidden$="[[!hasDataAndCookies_(
                    storedData_,numCookies_)]]">
                  &nbsp;&middot;&nbsp;
                </div>
                <div id="numCookies" hidden$="[[!numCookies_]]">
                  [[numCookies_]]
                </div>
              </div>
              <div id="rwsMembership" class="secondary"
                  hidden$="[[!rwsMembership_]]">
                [[rwsMembership_]]
              </div>
            </div>
            <template is="dom-if" if="[[rwsEnterprisePref_]]">
              <div id="fpsPolicyContainer">
                <cr-policy-pref-indicator
                    id="rwsPolicy" pref="[[rwsEnterprisePref_]]"
                    icon-aria-label="[[label]]" focus-row-control
                    focus-type="policy">
                </cr-policy-pref-indicator>
              </div>
            </template>
          </div>
          <cr-button id="clearStorage" role="button" aria-disabled="false"
              on-click="onConfirmClearStorage_"
              aria-label="$i18n{siteSettingsDelete}">
            $i18n{siteSettingsDelete}
          </cr-button>
        </div>
      </div>
    </div>

    <div class="cr-row first">
      <h2 class="flex">$i18n{siteSettingsPermissions}</h2>
      <cr-button id="resetSettingsButton" class="header-aligned-button"
          role="button" aria-disabled="false"
          on-click="onConfirmClearSettings_">
        $i18n{siteSettingsReset}
      </cr-button>
    </div>

    <div class="list-frame">
      <site-details-permission category="[[contentSettingsTypesEnum_.GEOLOCATION]]"
          icon="settings:location-on" label="$i18n{siteSettingsLocation}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.CAMERA]]"
          icon="cr:videocam" label="$i18n{siteSettingsCamera}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.MIC]]"
          icon="privacy:mic" label="$i18n{siteSettingsMic}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.SENSORS]]"
          icon="privacy:sensors" label="$i18n{siteSettingsSensors}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.NOTIFICATIONS]]"
          icon="privacy:notifications"
          label="$i18n{siteSettingsNotifications}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.JAVASCRIPT]]"
          icon="privacy:code" label="$i18n{siteSettingsJavascript}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.IMAGES]]"
          icon="privacy:imagesmode" label="$i18n{siteSettingsImages}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.POPUPS]]"
          icon="cr:open-in-new" label="$i18n{siteSettingsPopups}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.ADS]]"
          icon="privacy:web-asset" label="$i18n{siteSettingsAds}">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.BACKGROUND_SYNC]]"
          icon="cr:sync" label="$i18n{siteSettingsBackgroundSync}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.SOUND]]"
          icon="privacy:volume-up" label="$i18n{siteSettingsSound}"
          use-automatic-label="[[blockAutoplayEnabled_]]">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.AUTOMATIC_DOWNLOADS]]"
          icon="cr:file-download" label="$i18n{siteSettingsAutomaticDownloads}">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.MIDI_DEVICES]]"
          icon="privacy:piano" label="$i18n{siteSettingsMidiDevices}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.USB_DEVICES]]"
          icon="privacy:usb" label="$i18n{siteSettingsUsbDevices}"
          chooser-type="[[chooserTypeEnum_.USB_DEVICES]]">
      </site-details-permission>

      <site-details-permission category="[[contentSettingsTypesEnum_.SERIAL_PORTS]]"
          icon="privacy:developer-board" label="$i18n{siteSettingsSerialPorts}"
          chooser-type="[[chooserTypeEnum_.SERIAL_PORTS]]">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.WEB_PRINTING]]"
          icon="settings:printer"
          label="$i18n{siteSettingsWebPrinting}">
      </site-details-permission>
      <template is="dom-if" if="[[enableWebBluetoothNewPermissionsBackend_]]">
        <site-details-permission
            category="[[contentSettingsTypesEnum_.BLUETOOTH_DEVICES]]"
            icon="settings:bluetooth"
            chooser-type="[[chooserTypeEnum_.BLUETOOTH_DEVICES]]"
            label="$i18n{siteSettingsBluetoothDevices}">
        </site-details-permission>
      </template>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.FILE_SYSTEM_WRITE]]"
          icon="privacy:file-save"
          label="$i18n{siteSettingsFileSystemWrite}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.HID_DEVICES]]"
          chooser-type="[[chooserTypeEnum_.HID_DEVICES]]"
          icon="privacy:videogame-asset" label="$i18n{siteSettingsHidDevices}">
      </site-details-permission>

      <site-details-permission category="[[contentSettingsTypesEnum_.CLIPBOARD]]"
          icon="privacy:content-paste" label="$i18n{siteSettingsClipboard}">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.PAYMENT_HANDLER]]"
          icon="privacy:credit-card"
          label="$i18n{siteSettingsPaymentHandler}">
      </site-details-permission>
      <template is="dom-if" if="[[enableExperimentalWebPlatformFeatures_]]">
        <site-details-permission
            category="[[contentSettingsTypesEnum_.BLUETOOTH_SCANNING]]"
            icon="settings:bluetooth-scanning"
            label="$i18n{siteSettingsBluetoothScanning}">
        </site-details-permission>
      </template>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.MIXEDSCRIPT]]"
          icon="privacy:warning"
          label="$i18n{siteSettingsInsecureContent}">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.JAVASCRIPT_OPTIMIZER]]"
          use-block-if-unfamiliar-label-for-default="[[
              useBlockIfUnfamiliarLabelForV8OptimizerDefault_]]"
          icon="privacy:v8"
          label="$i18n{siteSettingsJavascriptOptimizer}">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.FEDERATED_IDENTITY_API]]"
          icon="privacy:account-circle"
          label="$i18n{siteSettingsFederatedIdentityApi}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.AR]]"
          icon="privacy:cardboard" label="$i18n{siteSettingsAr}">
      </site-details-permission>
      <site-details-permission category="[[contentSettingsTypesEnum_.VR]]"
          icon="privacy:cardboard" label="$i18n{siteSettingsVr}">
      </site-details-permission>
      <template is="dom-if" if="[[enableHandTrackingContentSetting_]]">
        <site-details-permission
            category="[[contentSettingsTypesEnum_.HAND_TRACKING]]"
            icon="privacy:hand-gesture" label="$i18n{siteSettingsHandTracking}">
        </site-details-permission>
      </template>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.IDLE_DETECTION]]"
          icon="settings:devices"
          label="$i18n{siteSettingsIdleDetection}">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.WINDOW_MANAGEMENT]]"
          icon="privacy:select-window"
          label="$i18n{siteSettingsWindowManagement}">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.LOCAL_FONTS]]"
          icon="privacy:font-download" label="$i18n{fonts}">
      </site-details-permission>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.AUTO_PICTURE_IN_PICTURE]]"
          icon="settings:picture-in-picture"
          label="$i18n{siteSettingsAutoPictureInPicture}">
      </site-details-permission>
      <template is="dom-if" if="[[enableCapturedSurfaceControl_]]">
        <site-details-permission
            category="[[contentSettingsTypesEnum_.CAPTURED_SURFACE_CONTROL]]"
            icon="settings:touchpad-mouse"
            label="$i18n{siteSettingsCapturedSurfaceControl}">
        </site-details-permission>
      </template>
      <site-details-permission
          category="[[contentSettingsTypesEnum_.AUTOMATIC_FULLSCREEN]]"
          icon="cr:fullscreen" label="$i18n{siteSettingsAutomaticFullscreen}">
      </site-details-permission>
      <template is="dom-if" if="[[enableKeyboardLockPrompt_]]">
        <site-details-permission
            category="[[contentSettingsTypesEnum_.KEYBOARD_LOCK]]"
            icon="settings20:keyboard-lock"
            label="$i18n{siteSettingsKeyboardLock}">
        </site-details-permission>
      </template>
      <template is="dom-if" if="[[enableWebAppInstallation_]]">
        <site-details-permission
            category="[[contentSettingsTypesEnum_.WEB_APP_INSTALLATION]]"
            icon="settings:install-desktop"
            label="$i18n{siteSettingsWebAppInstallation}">
        </site-details-permission>
      </template>
      <template is="dom-if" if="[[enableLocalNetworkAccessSetting_]]">
        <site-details-permission
            category="[[contentSettingsTypesEnum_.LOCAL_NETWORK_ACCESS]]"
            icon="settings20:router"
            label="$i18n{siteSettingsLocalNetworkAccess}">
        </site-details-permission>
      </template>
    </div>
  </settings-subpage>
<!--_html_template_end_-->`}class WebsiteUsageBrowserProxyImpl{fetchUsageTotal(host){chrome.send("fetchUsageTotal",[host])}clearUsage(origin){chrome.send("clearUnpartitionedUsage",[origin])}static getInstance(){return instance$k||(instance$k=new WebsiteUsageBrowserProxyImpl)}static setInstance(obj){instance$k=obj}}let instance$k=null;loadTimeData.applyOwlOverrides();const SiteDetailsElementBase=RouteObserverMixin(SiteSettingsMixin(SettingsViewMixin(WebUiListenerMixin(PrefsMixin(I18nMixin(PolymerElement))))));class SiteDetailsElement extends SiteDetailsElementBase{static get is(){return"site-details"}static get template(){return getTemplate$G()}static get properties(){return{blockAutoplayEnabled_:Boolean,pageTitle_:{type:String,notify:true},origin_:String,storedData_:{type:String,value:""},numCookies_:{type:String,value:""},rwsMembership_:{type:String,value:""},rwsEnterprisePref_:Object,enableExperimentalWebPlatformFeatures_:{type:Boolean,value(){return loadTimeData.getBoolean("enableExperimentalWebPlatformFeatures")}},enableWebBluetoothNewPermissionsBackend_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableWebBluetoothNewPermissionsBackend")},enableHandTrackingContentSetting_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableHandTrackingContentSetting")},enableCapturedSurfaceControl_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableCapturedSurfaceControl")},enablePermissionSiteSettingsRadioButton_:{type:Boolean,value:()=>loadTimeData.getBoolean("enablePermissionSiteSettingsRadioButton")},contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes},chooserTypeEnum_:{type:Object,value:ChooserType},enableKeyboardLockPrompt_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableKeyboardLockPrompt")},enableWebAppInstallation_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableWebAppInstallation")},enableLocalNetworkAccessSetting_:{type:Boolean,value:()=>loadTimeData.getBoolean("enableLocalNetworkAccessSetting")},useBlockIfUnfamiliarLabelForV8OptimizerDefault_:{type:Boolean,computed:"computeShouldUseBlockIfUnfamiliarLabelForV8OptimizerDefault_("+"prefs.generated.javascript_optimizer.value)"}}}websiteUsageProxy_=WebsiteUsageBrowserProxyImpl.getInstance();connectedCallback(){super.connectedCallback();this.addWebUiListener("usage-total-changed",((host,data,cookies,rws,rwsPolicy)=>{this.onUsageTotalChanged_(host,data,cookies,rws,rwsPolicy)}));this.addWebUiListener("contentSettingSitePermissionChanged",((category,origin)=>this.onPermissionChanged_(category,origin)));this.addWebUiListener("onBlockAutoplayStatusChanged",(status=>this.onBlockAutoplayStatusChanged_(status)));this.browserProxy.fetchBlockAutoplayStatus()}currentRouteChanged(route,oldRoute){super.currentRouteChanged(route,oldRoute);if(route!==routes.SITE_SETTINGS_SITE_DETAILS){return}const site=Router.getInstance().getQueryParameters().get("site")??"";this.origin_=site;this.browserProxy.isOriginValid(this.origin_).then((valid=>{if(!valid){Router.getInstance().navigateToPreviousRoute()}else{this.storedData_="";this.websiteUsageProxy_.fetchUsageTotal(this.origin_);this.browserProxy.getCategoryList(this.origin_).then((categoryList=>{this.updatePermissions_(categoryList,true)}))}}))}onPermissionChanged_(category,origin){if(this.origin_===undefined||this.origin_===""||origin===undefined||origin===""){return}this.browserProxy.getCategoryList(this.origin_).then((categoryList=>{if(categoryList.includes(category)){this.updatePermissions_([category],false)}}))}onUsageTotalChanged_(origin,usage,cookies,rwsMembership,rwsPolicy){if(this.origin_===origin){this.storedData_=usage;this.numCookies_=cookies;this.rwsMembership_=rwsMembership;this.rwsEnterprisePref_=rwsPolicy?Object.assign({enforcement:chrome.settingsPrivate.Enforcement.ENFORCED,controlledBy:chrome.settingsPrivate.ControlledBy.DEVICE_POLICY}):undefined}}updatePermissions_(categoryList,hideOthers){const permissionsMap=Array.prototype.reduce.call(this.shadowRoot.querySelectorAll("site-details-permission"),((map,element)=>{if(categoryList.includes(element.category)){map[element.category]=element}else if(hideOthers){element.site=null}return map}),{});this.browserProxy.getOriginPermissions(this.origin_,categoryList).then((exceptionList=>{exceptionList.forEach(((exception,i)=>{if(permissionsMap[categoryList[i]]){permissionsMap[categoryList[i]].site=exception}}));assert(exceptionList.length>0);this.pageTitle_=exceptionList[0].displayName}))}onCloseDialog_(e){e.target.closest("cr-dialog").close()}onConfirmClearSettings_(e){e.preventDefault();this.$.confirmResetSettings.showModal()}onConfirmClearStorage_(e){e.preventDefault();this.$.confirmClearStorage.showModal()}onResetSettings_(e){this.browserProxy.setOriginPermissions(this.origin_,null,ContentSetting.DEFAULT);this.onCloseDialog_(e)}onClearStorage_(e){MetricsBrowserProxyImpl.getInstance().recordSettingsPageHistogram(PrivacyElementInteractions.SITE_DETAILS_CLEAR_DATA);if(this.hasUsage_(this.storedData_,this.numCookies_)){this.websiteUsageProxy_.clearUsage(this.toUrl(this.origin_).href);this.storedData_="";this.numCookies_=""}this.onCloseDialog_(e);const toFocus=this.shadowRoot.querySelector("#resetSettingsButton");assert(toFocus);focusWithoutInk(toFocus)}hasUsage_(storage,cookies){return storage!==""||cookies!==""}hasDataAndCookies_(storage,cookies){return storage!==""&&cookies!==""}computeShouldUseBlockIfUnfamiliarLabelForV8OptimizerDefault_(){const pref=this.getPref("generated.javascript_optimizer").value;return pref===JavascriptOptimizerSetting.BLOCKED_FOR_UNFAMILIAR_SITES}onResetSettingsDialogClosed_(){const toFocus=this.shadowRoot.querySelector("#resetSettingsButton");assert(toFocus);focusWithoutInk(toFocus)}onClearStorageDialogClosed_(){const toFocus=this.shadowRoot.querySelector("#clearStorage");assert(toFocus);focusWithoutInk(toFocus)}onBlockAutoplayStatusChanged_(autoplayStatus){this.blockAutoplayEnabled_=autoplayStatus.pref.value}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SiteDetailsElement.is,SiteDetailsElement);function getTemplate$F(){return html`<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">site-favicon{padding-inline-end:24px}.link-button[disabled]{cursor:auto;pointer-events:none}.incognito-icon{cursor:auto;pointer-events:auto}.display-name{flex:1;max-width:100%}
    </style>
    <div id="noPermissionsText" class="list-frame"
        hidden$="[[!noRecentPermissions]]">
      <div class="list-item secondary">$i18n{noRecentPermissions}</div>
    </div>
    <template is="dom-repeat" id="recentPermissionsList"
        items="[[recentSitePermissionsList_]]" on-dom-change="onDomChange_">
      <div class$="cr-row link-button [[getClassForIndex_(index)]]"
          on-click="onRecentSitePermissionClick_" actionable
          disabled$="[[item.incognito]]">
        <site-favicon url="[[item.origin]]"></site-favicon>
        <div id="displayName_[[index]]" class="display-name cr-padded-text">
          <div class="site-representation">
            <span class="url-directionality">[[getDisplayName_(item)]]</span>
            <span class="secondary"
                hidden$="[[!getSiteScheme_(item)]]">
            &nbsp;$i18nPolymer{siteSettingsSiteRepresentationSeparator}&nbsp;
            </span>
            <span class="secondary"
                hidden$="[[!getSiteScheme_(item)]]">
              [[getSiteScheme_(item)]]
            </span>
          </div>
          <div class="second-line secondary">
              [[getPermissionsText_(item)]]
          </div>
        </div>
        <cr-icon-button id="siteEntryButton_[[index]]" class="subpage-arrow"
            hidden$="[[item.incognito]]"
            aria-label$="[[getDisplayName_(item)]]"
            aria-describedby$="displayName_[[index]]"
            focus-row-control focus-type="show-detail"></cr-icon-button>
        <cr-tooltip-icon id="incognitoInfoIcon_[[index]]"
            class="incognito-icon"
            hidden$="[[!item.incognito]]"
            disabled$="[[item.incognito]]"
            icon-aria-label="$i18n{incognitoSiteExceptionDesc}"
            icon-class="settings20:incognito"
            on-click="onShowIncognitoTooltip_"
            on-mouseenter="onShowIncognitoTooltip_"
            on-focus="onShowIncognitoTooltip_"></cr-tooltip-icon>
      </div>
    </template>
    <cr-tooltip id="tooltip"
        fit-to-visible-bounds manual-mode
        position="top">
      $i18n{incognitoSiteExceptionDesc}
    </cr-tooltip>
<!--_html_template_end_-->`}const SettingsRecentSitePermissionsElementBase=TooltipMixin(RouteObserverMixin(SiteSettingsMixin(WebUiListenerMixin(I18nMixin(PolymerElement)))));class SettingsRecentSitePermissionsElement extends SettingsRecentSitePermissionsElementBase{static get is(){return"settings-recent-site-permissions"}static get template(){return getTemplate$F()}static get properties(){return{noRecentPermissions:{type:Boolean,computed:"computeNoRecentPermissions_(recentSitePermissionsList_)",notify:true},shouldFocusAfterPopulation_:Boolean,recentSitePermissionsList_:{type:Array,value:()=>[]}}}lastSelected_;constructor(){super();this.lastSelected_=null}getFocusConfig(){return new Map([[routes.SITE_SETTINGS_SITE_DETAILS.path+"_"+routes.SITE_SETTINGS.path,()=>{this.shouldFocusAfterPopulation_=true}]])}currentRouteChanged(currentRoute){if(currentRoute.path===routes.SITE_SETTINGS.path){this.populateList_()}}ready(){super.ready();this.addWebUiListener("onIncognitoStatusChanged",(hasIncognito=>this.onIncognitoStatusChanged_(hasIncognito)));this.browserProxy.updateIncognitoStatus()}getDisplayName_(recentSitePermissions){return recentSitePermissions.displayName}getSiteScheme_({origin:origin}){const scheme=this.toUrl(origin).protocol.slice(0,-1);return scheme==="https"?"":scheme}getPermissionsText_({recentPermissions:recentPermissions}){const groupSentences=[this.getPermissionGroupText_("Allowed",recentPermissions.filter((exception=>exception.setting===ContentSetting.ALLOW))),this.getPermissionGroupText_("AutoBlocked",recentPermissions.filter((exception=>exception.source===SiteSettingSource.EMBARGO))),this.getPermissionGroupText_("Blocked",recentPermissions.filter((exception=>exception.setting===ContentSetting.BLOCK&&exception.source!==SiteSettingSource.EMBARGO)))].filter((string=>string.length>0));let finalText="";for(const sentence of groupSentences){if(finalText.length>0){finalText+=`${this.i18n("sentenceEnd")} ${sentence}`}else{finalText=sentence}}if(groupSentences.length>1){finalText+=this.i18n("sentenceEnd")}return finalText}getPermissionGroupText_(setting,exceptions){if(exceptions.length===0){return""}const typeStrings=exceptions.map((exception=>{const localizationString=getLocalizationStringForContentType(exception.type);return localizationString?this.i18n(localizationString):""}));if(exceptions.length===1){return this.i18n(`recentPermission${setting}OneItem`,...typeStrings)}if(exceptions.length===2){return this.i18n(`recentPermission${setting}TwoItems`,...typeStrings)}return this.i18n(`recentPermission${setting}MoreThanTwoItems`,typeStrings[0],exceptions.length-1)}getClassForIndex_(index){return index===0?"first":""}computeNoRecentPermissions_(){return this.recentSitePermissionsList_.length===0}onIncognitoStatusChanged_(hasIncognito){if(hasIncognito===false&&this.recentSitePermissionsList_.some((p=>p.incognito))){this.populateList_()}}onRecentSitePermissionClick_(e){const origin=this.recentSitePermissionsList_[e.model.index].origin;Router.getInstance().navigateTo(routes.SITE_SETTINGS_SITE_DETAILS,new URLSearchParams({site:origin}));this.browserProxy.recordAction(AllSitesAction2.ENTER_SITE_DETAILS);this.lastSelected_={index:e.model.index,origin:e.model.item.origin,incognito:e.model.item.incognito}}onShowIncognitoTooltip_(e){e.stopPropagation();this.showTooltipAtTarget(this.$.tooltip,e.target)}focusLastSelected_(){if(this.noRecentPermissions){return}const currentIndex=this.recentSitePermissionsList_.findIndex((permissions=>permissions.origin===this.lastSelected_.origin&&permissions.incognito===this.lastSelected_.incognito));const fallbackIndex=Math.min(this.lastSelected_.index,this.recentSitePermissionsList_.length-1);const index=currentIndex>-1?currentIndex:fallbackIndex;if(this.recentSitePermissionsList_[index].incognito){const icon=this.shadowRoot.querySelector(`#incognitoInfoIcon_${index}`);assert(!!icon);const toFocus=icon.getFocusableElement();assert(!!toFocus);focusWithoutInk(toFocus)}else{const toFocus=this.shadowRoot.querySelector(`#siteEntryButton_${index}`);assert(!!toFocus);focusWithoutInk(toFocus)}}async populateList_(){this.recentSitePermissionsList_=await this.browserProxy.getRecentSitePermissions(3)}onDomChange_(){if(this.shouldFocusAfterPopulation_){this.focusLastSelected_();this.shouldFocusAfterPopulation_=false}}}customElements.define(SettingsRecentSitePermissionsElement.is,SettingsRecentSitePermissionsElement);function getTemplate$E(){return html`<!--_html_template_start_-->    <style include="settings-shared">cr-link-row{--cr-icon-button-margin-start:20px}cr-link-row:first-of-type{border-top:none}
    </style>
    <template is="dom-repeat" items="[[categoryList]]">
      <cr-link-row class="hr two-line" data-route$="[[item.route]]"
          id="[[item.id]]" label="[[i18n(item.label)]]"
          on-click="onClick_" start-icon="[[item.icon]]"
          sub-label="[[item.subLabel]]"
          role-description="$i18n{subpageArrowRoleDescription}"></cr-link-row>
    </template>
<!--_html_template_end_-->`}function defaultSettingLabel(setting,enabled,disabled,other){if(setting===ContentSetting.BLOCK){return disabled}if(setting===ContentSetting.ALLOW){return enabled}return other||enabled}const SettingsSiteSettingsListElementBase=PrefsMixin(BaseMixin(WebUiListenerMixin(I18nMixin(PolymerElement))));class SettingsSiteSettingsListElement extends SettingsSiteSettingsListElementBase{static get is(){return"settings-site-settings-list"}static get template(){return getTemplate$E()}static get properties(){return{categoryList:Array,categoryMap_:{type:Map,computed:"computeCategoryMap(categoryList)"}}}static get observers(){return["updateNotificationsLabel_(prefs.generated.notification.*)","updateLocationLabel_(prefs.generated.geolocation.*)","updateSiteDataLabel_(prefs.generated.cookie_default_content_setting.*)","updateThirdPartyCookiesLabel_(prefs.profile.cookie_controls_mode.*,"+"prefs.tracking_protection.block_all_3pc_toggle_enabled.*,"+"prefs.generated.third_party_cookie_blocking_setting.*)","updateOfferWritingHelpLabel_(prefs.compose.proactive_nudge_enabled.*)"]}browserProxy_=SiteSettingsBrowserProxyImpl.getInstance();getFocusConfig(){const focusConfig=new Map;for(const item of this.categoryList){focusConfig.set(item.route.path,(()=>{const toFocus=this.shadowRoot.querySelector(`#${item.id}`);assert(!!toFocus);focusWithoutInk(toFocus)}))}return focusConfig}computeCategoryMap(categoryList){return new Map(categoryList.map(((e,index)=>[e.id,index])))}ready(){super.ready();Promise.all(this.categoryList.map((item=>this.refreshDefaultValueLabel_(item.id)))).then((()=>{this.fire("site-settings-list-labels-updated-for-testing")}));this.addWebUiListener("contentSettingCategoryChanged",(category=>this.refreshDefaultValueLabel_(category)));const hasProtocolHandlers=this.categoryMap_.has(ContentSettingsTypes.PROTOCOL_HANDLERS);if(hasProtocolHandlers){this.addWebUiListener("setHandlersEnabled",(enabled=>{this.updateDefaultValueLabel_(ContentSettingsTypes.PROTOCOL_HANDLERS,enabled?ContentSetting.ALLOW:ContentSetting.BLOCK)}));this.browserProxy_.observeProtocolHandlersEnabledState()}}refreshDefaultValueLabel_(category){if(category===ContentSettingsTypes.ZOOM_LEVELS||category===ContentSettingsTypes.PROTECTED_CONTENT||category===ContentSettingsTypes.PDF_DOCUMENTS||category===ContentSettingsTypes.SITE_DATA||category===ContentSettingsTypes.OFFER_WRITING_HELP||category===ContentSettingsTypes.COOKIES){return Promise.resolve()}if(category===ContentSettingsTypes.NOTIFICATIONS){return Promise.resolve()}if(category===ContentSettingsTypes.PERFORMANCE){const index=this.categoryMap_.get(ContentSettingsTypes.PERFORMANCE);this.set(`categoryList.${index}.subLabel`,this.i18n("siteSettingsPerformanceSublabel"));return Promise.resolve()}if(!this.categoryMap_.has(category)){return Promise.resolve()}return this.browserProxy_.getDefaultValueForContentType(category).then((defaultValue=>{this.updateDefaultValueLabel_(category,defaultValue.setting)}))}updateDefaultValueLabel_(category,setting){const element=this.$$(`#${category}`);if(!element){return}const index=this.shadowRoot.querySelector("dom-repeat").indexForElement(element);const dataItem=this.categoryList[index];this.set(`categoryList.${index}.subLabel`,defaultSettingLabel(setting,dataItem.enabledLabel?this.i18n(dataItem.enabledLabel):"",dataItem.disabledLabel?this.i18n(dataItem.disabledLabel):"",dataItem.otherLabel?this.i18n(dataItem.otherLabel):undefined))}updateCookiesLabel_(label){const index=this.shadowRoot.querySelector("dom-repeat").indexForElement(this.shadowRoot.querySelector("#cookies"));this.set(`categoryList.${index}.subLabel`,label)}updateLocationLabel_(){const state=this.getPref("generated.geolocation").value;const index=this.categoryMap_.get(ContentSettingsTypes.GEOLOCATION);if(index===-1){return}let label="siteSettingsLocationBlocked";if(state===SettingsState.LOUD){label="siteSettingsLocationAskLoud"}else if(state===SettingsState.QUIET){label="siteSettingsLocationAskQuiet"}else if(state===SettingsState.CPSS){label="siteSettingsLocationAskCPSS"}this.set(`categoryList.${index}.subLabel`,this.i18n(label))}updateNotificationsLabel_(){const state=this.getPref("generated.notification").value;const index=this.categoryMap_.get(ContentSettingsTypes.NOTIFICATIONS);if(index===-1){return}let label="siteSettingsNotificationsBlocked";if(state===SettingsState.LOUD){label="siteSettingsNotificationsAskLoud"}else if(state===SettingsState.QUIET){label="siteSettingsNotificationsAskQuiet"}else if(state===SettingsState.CPSS){label="siteSettingsNotificationsAskCPSS"}this.set(`categoryList.${index}.subLabel`,this.i18n(label))}updateSiteDataLabel_(){const state=this.getPref("generated.cookie_default_content_setting").value;const index=this.categoryMap_.get(ContentSettingsTypes.SITE_DATA);if(index===-1){return}let label;if(state===ContentSetting.ALLOW){label="siteSettingsSiteDataAllowedSubLabel"}else if(state===ContentSetting.SESSION_ONLY){label="siteSettingsSiteDataDeleteOnExitSubLabel"}else if(state===ContentSetting.BLOCK){label="siteSettingsSiteDataBlockedSubLabel"}assert(!!label);this.set(`categoryList.${index}.subLabel`,this.i18n(label))}updateThirdPartyCookiesLabel_(){const index=this.categoryMap_.get(ContentSettingsTypes.COOKIES);if(index===-1){return}let label;if(loadTimeData.getBoolean("is3pcdCookieSettingsRedesignEnabled")){if(this.getPref("tracking_protection.block_all_3pc_toggle_enabled").value){label="thirdPartyCookiesLinkRowSublabelDisabled"}else{label="thirdPartyCookiesLinkRowSublabelLimited"}}else{const state=this.getPref("profile.cookie_controls_mode").value;if(state===CookieControlsMode.OFF||state===CookieControlsMode.INCOGNITO_ONLY){label="thirdPartyCookiesLinkRowSublabelEnabled"}else if(state===CookieControlsMode.BLOCK_THIRD_PARTY){label="thirdPartyCookiesLinkRowSublabelDisabled"}}assert(!!label);this.set(`categoryList.${index}.subLabel`,this.i18n(label))}updateOfferWritingHelpLabel_(){if(!loadTimeData.getBoolean("enableComposeProactiveNudge")){return}const enabled=this.getPref("compose.proactive_nudge_enabled").value;const index=this.categoryMap_.get(ContentSettingsTypes.OFFER_WRITING_HELP);if(index===-1){return}const label=enabled?"siteSettingsOfferWritingHelpEnabledSublabel":"siteSettingsOfferWritingHelpDisabledSublabel";this.set(`categoryList.${index}.subLabel`,this.i18n(label))}onClick_(event){Router.getInstance().navigateTo(this.categoryList[event.model.index].route)}}customElements.define(SettingsSiteSettingsListElement.is,SettingsSiteSettingsListElement);function getTemplate$D(){return html`<!--_html_template_start_-->  <style include="cr-shared-style settings-shared">.no-min-height{min-height:0}#safetyHubModule{padding:0 var(--cr-section-padding)}
  </style>
  <settings-subpage hide-close-button page-title="$i18n{siteSettings}"
      learn-more-url="$i18n{exceptionsLearnMoreURL}"
      route-path$="[[routePath]]">
    <template is="dom-if" if="[[showUnusedSitePermissions_]]">
      <div class="cr-row first">
        <h2>$i18n{safetyHub}</h2>
      </div>
      <settings-safety-hub-module id="safetyHubModule"
          header="[[unusedSitePermissionsHeader_]]"
          subheader="[[unusedSitePermissionsSubheader_]]"
          header-icon="cr:security" header-icon-color="blue">
        <cr-button id="safetyHubButton" slot="button-container"
            class="action-button" on-click="onSafetyHubButtonClick_">
          $i18n{safetyHubEntryPointButtonLabel}
        </cr-button>
      </settings-safety-hub-module>
    </template>
    <div class="cr-row first">
      <h2>$i18n{siteSettingsRecentPermissionsSectionLabel}</h2>
    </div>
    <settings-recent-site-permissions id="recentSitePermissions"
        no-recent-permissions="{{noRecentSitePermissions_}}">
    </settings-recent-site-permissions>

    <cr-link-row data-route="SITE_SETTINGS_ALL" id="allSites"
        class$="[[getClassForSiteSettingsAllLink_(noRecentSitePermissions_)]]"
        label="$i18n{siteSettingsAllSitesDescription}"
        on-click="onSiteSettingsAllClick_"
        role-description="$i18n{subpageArrowRoleDescription}"></cr-link-row>
    <div class="cr-row first line-only">
      <h2>$i18n{siteSettingsPermissions}</h2>
    </div>

    <settings-site-settings-list id="basicPermissionsList" prefs="{{prefs}}"
        category-list="[[lists_.permissionsBasic]]">
    </settings-site-settings-list>
    <cr-expand-button class="cr-row"
        expanded="{{permissionsExpanded_}}">
      <div>$i18n{siteSettingsPermissionsMore}</div>
    </cr-expand-button>
    <cr-collapse opened="[[permissionsExpanded_]]">
      <settings-site-settings-list id="advancedPermissionsList"
          category-list="[[lists_.permissionsAdvanced]]">
      </settings-site-settings-list>
    </cr-collapse>

    <div class="cr-row first line-only">
      <h2>$i18n{siteSettingsContent}</h2>
    </div>
    <settings-site-settings-list id="basicContentList" prefs="{{prefs}}"
        category-list="[[lists_.contentBasic]]">
    </settings-site-settings-list>
    <cr-expand-button id="expandContent" class="cr-row"
        expanded="{{contentExpanded_}}">
      <div>$i18n{siteSettingsContentMore}</div>
    </cr-expand-button>
    <cr-collapse opened="[[contentExpanded_]]">
      <settings-site-settings-list id="advancedContentList" prefs="{{prefs}}"
          category-list="[[lists_.contentAdvanced]]">
      </settings-site-settings-list>
    </cr-collapse>
    <settings-toggle-button
        id="unusedSitePermissionsRevocationToggle"
        pref="{{
            prefs.safety_hub.unused_site_permissions_revocation.enabled}}"
        label="$i18n{safetyHubUnusedSitePermissionsSettingLabel}"
        sub-label=
            "$i18n{safetyHubUnusedSitePermissionsSettingSublabel}">
    </settings-toggle-button>
  </settings-subpage>
<!--_html_template_end_-->`}const Id=ContentSettingsTypes;let categoryItemMap=null;function getCategoryItemMap(){if(categoryItemMap!==null){return categoryItemMap}const categoryList=[{route:routes.SITE_SETTINGS_ADS,id:Id.ADS,label:"siteSettingsAds",icon:"privacy:web-asset",enabledLabel:"siteSettingsAdsAllowed",disabledLabel:"siteSettingsAdsBlocked",shouldShow:()=>loadTimeData.getBoolean("enableSafeBrowsingSubresourceFilter")},{route:routes.SITE_SETTINGS_AUTO_VERIFY,id:Id.ANTI_ABUSE,label:"siteSettingsAntiAbuse",icon:"privacy20:person-check",enabledLabel:"siteSettingsAntiAbuseEnabledSubLabel",disabledLabel:"siteSettingsAntiAbuseDisabledSubLabel"},{route:routes.SITE_SETTINGS_AR,id:Id.AR,label:"siteSettingsAr",icon:"privacy:cardboard",enabledLabel:"siteSettingsArAsk",disabledLabel:"siteSettingsArBlock"},{route:routes.SITE_SETTINGS_AUTOMATIC_DOWNLOADS,id:Id.AUTOMATIC_DOWNLOADS,label:"siteSettingsAutomaticDownloads",icon:"cr:file-download",enabledLabel:"siteSettingsAutomaticDownloadsAllowed",disabledLabel:"siteSettingsAutomaticDownloadsBlocked"},{route:routes.SITE_SETTINGS_AUTOMATIC_FULLSCREEN,id:Id.AUTOMATIC_FULLSCREEN,label:"siteSettingsAutomaticFullscreen",icon:"cr:fullscreen"},{route:routes.SITE_SETTINGS_AUTO_PICTURE_IN_PICTURE,id:Id.AUTO_PICTURE_IN_PICTURE,label:"siteSettingsAutoPictureInPicture",icon:"settings:picture-in-picture",enabledLabel:"siteSettingsAutoPictureInPictureAllowed",disabledLabel:"siteSettingsAutoPictureInPictureBlocked"},{route:routes.SITE_SETTINGS_BACKGROUND_SYNC,id:Id.BACKGROUND_SYNC,label:"siteSettingsBackgroundSync",icon:"cr:sync",enabledLabel:"siteSettingsBackgroundSyncAllowed",disabledLabel:"siteSettingsBackgroundSyncBlocked"},{route:routes.SITE_SETTINGS_BLUETOOTH_DEVICES,id:Id.BLUETOOTH_DEVICES,label:"siteSettingsBluetoothDevices",icon:"settings:bluetooth",enabledLabel:"siteSettingsBluetoothDevicesAllowed",disabledLabel:"siteSettingsBluetoothDevicesBlocked",shouldShow:()=>loadTimeData.getBoolean("enableWebBluetoothNewPermissionsBackend")},{route:routes.SITE_SETTINGS_BLUETOOTH_SCANNING,id:Id.BLUETOOTH_SCANNING,label:"siteSettingsBluetoothScanning",icon:"settings:bluetooth-scanning",enabledLabel:"siteSettingsBluetoothScanningAsk",disabledLabel:"siteSettingsBluetoothScanningBlock",shouldShow:()=>loadTimeData.getBoolean("enableExperimentalWebPlatformFeatures")},{route:routes.SITE_SETTINGS_CAMERA,id:Id.CAMERA,label:"siteSettingsCamera",icon:"cr:videocam",enabledLabel:"siteSettingsCameraAllowed",disabledLabel:"siteSettingsCameraBlocked"},{route:routes.SITE_SETTINGS_CAPTURED_SURFACE_CONTROL,id:Id.CAPTURED_SURFACE_CONTROL,label:"siteSettingsCapturedSurfaceControl",icon:"settings:touchpad-mouse",enabledLabel:"siteSettingsCapturedSurfaceControlAllowed",disabledLabel:"siteSettingsCapturedSurfaceControlBlocked",shouldShow:()=>loadTimeData.getBoolean("enableCapturedSurfaceControl")},{route:routes.SITE_SETTINGS_CLIPBOARD,id:Id.CLIPBOARD,label:"siteSettingsClipboard",icon:"privacy:content-paste",enabledLabel:"siteSettingsClipboardAllowed",disabledLabel:"siteSettingsClipboardBlocked"},{route:routes.SITE_SETTINGS_FEDERATED_IDENTITY_API,id:Id.FEDERATED_IDENTITY_API,label:"siteSettingsFederatedIdentityApi",icon:"privacy:account-circle",enabledLabel:"siteSettingsFederatedIdentityApiAllowed",disabledLabel:"siteSettingsFederatedIdentityApiBlocked",shouldShow:()=>loadTimeData.getBoolean("enableFederatedIdentityApiContentSetting")},{route:routes.SITE_SETTINGS_FILE_SYSTEM_WRITE,id:Id.FILE_SYSTEM_WRITE,label:"siteSettingsFileSystemWrite",icon:"privacy:file-save",enabledLabel:"siteSettingsFileSystemWriteAllowed",disabledLabel:"siteSettingsFileSystemWriteBlocked"},{route:routes.SITE_SETTINGS_LOCATION,id:Id.GEOLOCATION,label:"siteSettingsLocation",icon:"settings:location-on",enabledLabel:"siteSettingsLocationAllowed",disabledLabel:"siteSettingsLocationBlocked"},{route:routes.SITE_SETTINGS_HAND_TRACKING,id:Id.HAND_TRACKING,label:"siteSettingsHandTracking",icon:"privacy:hand-gesture",enabledLabel:"siteSettingsHandTrackingAsk",disabledLabel:"siteSettingsHandTrackingBlock",shouldShow:()=>loadTimeData.getBoolean("enableHandTrackingContentSetting")},{route:routes.SITE_SETTINGS_HID_DEVICES,id:Id.HID_DEVICES,label:"siteSettingsHidDevices",icon:"privacy:videogame-asset",enabledLabel:"siteSettingsHidDevicesAsk",disabledLabel:"siteSettingsHidDevicesBlock"},{route:routes.SITE_SETTINGS_IDLE_DETECTION,id:Id.IDLE_DETECTION,label:"siteSettingsIdleDetection",icon:"settings:devices",enabledLabel:"siteSettingsDeviceUseAllowed",disabledLabel:"siteSettingsDeviceUseBlocked"},{route:routes.SITE_SETTINGS_IMAGES,id:Id.IMAGES,label:"siteSettingsImages",icon:"privacy:imagesmode",enabledLabel:"siteSettingsImagesAllowed",disabledLabel:"siteSettingsImagesBlocked"},{route:routes.SITE_SETTINGS_JAVASCRIPT,id:Id.JAVASCRIPT,label:"siteSettingsJavascript",icon:"privacy:code",enabledLabel:"siteSettingsJavascriptAllowed",disabledLabel:"siteSettingsJavascriptBlocked"},{route:routes.SITE_SETTINGS_JAVASCRIPT_OPTIMIZER,id:Id.JAVASCRIPT_OPTIMIZER,label:"siteSettingsJavascriptOptimizer",icon:"privacy:v8",enabledLabel:"siteSettingsJavascriptOptimizerAllowed",disabledLabel:"siteSettingsJavascriptOptimizerBlocked"},{route:routes.SITE_SETTINGS_KEYBOARD_LOCK,id:Id.KEYBOARD_LOCK,label:"siteSettingsKeyboardLock",icon:"settings20:keyboard-lock",enabledLabel:"siteSettingsKeyboardLockAllowed",disabledLabel:"siteSettingsKeyboardLockBlocked",shouldShow:()=>loadTimeData.getBoolean("enableKeyboardLockPrompt")},{route:routes.SITE_SETTINGS_LOCAL_FONTS,id:Id.LOCAL_FONTS,label:"fonts",icon:"privacy:font-download",enabledLabel:"siteSettingsFontsAllowed",disabledLabel:"siteSettingsFontsBlocked"},{route:routes.SITE_SETTINGS_LOCAL_NETWORK_ACCESS,id:Id.LOCAL_NETWORK_ACCESS,label:"siteSettingsLocalNetworkAccess",icon:"settings20:router",enabledLabel:"siteSettingsLocalNetworkAccessAsk",disabledLabel:"siteSettingsLocalNetworkAccessBlock",shouldShow:()=>loadTimeData.getBoolean("enableLocalNetworkAccessSetting")},{route:routes.SITE_SETTINGS_MICROPHONE,id:Id.MIC,label:"siteSettingsMic",icon:"privacy:mic",enabledLabel:"siteSettingsMicAllowed",disabledLabel:"siteSettingsMicBlocked"},{route:routes.SITE_SETTINGS_MIDI_DEVICES,id:Id.MIDI_DEVICES,label:"siteSettingsMidiDevices",icon:"privacy:piano",enabledLabel:"siteSettingsMidiAllowed",disabledLabel:"siteSettingsMidiBlocked"},{route:routes.SITE_SETTINGS_MIXEDSCRIPT,id:Id.MIXEDSCRIPT,label:"siteSettingsInsecureContent",icon:"privacy:warning",disabledLabel:"siteSettingsInsecureContentBlock"},{route:routes.SITE_SETTINGS_NOTIFICATIONS,id:Id.NOTIFICATIONS,label:"siteSettingsNotifications",icon:"privacy:notifications"},{route:routes.OFFER_WRITING_HELP,id:Id.OFFER_WRITING_HELP,label:"siteSettingsOfferWritingHelp",icon:"settings:compose",shouldShow:()=>loadTimeData.getBoolean("enableComposeProactiveNudge")},{route:routes.SITE_SETTINGS_PAYMENT_HANDLER,id:Id.PAYMENT_HANDLER,label:"siteSettingsPaymentHandler",icon:"privacy:credit-card",enabledLabel:"siteSettingsPaymentHandlersAllowed",disabledLabel:"siteSettingsPaymentHandlersBlocked",shouldShow:()=>loadTimeData.getBoolean("enablePaymentHandlerContentSetting")},{route:routes.SITE_SETTINGS_PDF_DOCUMENTS,id:Id.PDF_DOCUMENTS,label:"siteSettingsPdfDocuments",icon:"privacy:drive-pdf",enabledLabel:"siteSettingsPdfsAllowed",disabledLabel:"siteSettingsPdfsBlocked"},{route:routes.PERFORMANCE,id:Id.PERFORMANCE,label:"siteSettingsPerformance",icon:"settings:performance",enabledLabel:"siteSettingsPerformanceSublabel",disabledLabel:"siteSettingsPerformanceSublabel"},{route:routes.SITE_SETTINGS_POPUPS,id:Id.POPUPS,label:"siteSettingsPopups",icon:"cr:open-in-new",enabledLabel:"siteSettingsPopupsAllowed",disabledLabel:"siteSettingsPopupsBlocked"},{route:routes.SITE_SETTINGS_PROTECTED_CONTENT,id:Id.PROTECTED_CONTENT,label:"siteSettingsProtectedContent",icon:"privacy:sync-saved-locally",enabledLabel:"siteSettingsProtectedContentAllowed",disabledLabel:"siteSettingsProtectedContentBlocked"},{route:routes.SITE_SETTINGS_HANDLERS,id:Id.PROTOCOL_HANDLERS,label:"siteSettingsHandlers",icon:"privacy:protocol-handler",enabledLabel:"siteSettingsProtocolHandlersAllowed",disabledLabel:"siteSettingsProtocolHandlersBlocked",shouldShow:()=>!loadTimeData.getBoolean("isGuest")},{route:routes.SITE_SETTINGS_SENSORS,id:Id.SENSORS,label:"siteSettingsSensors",icon:"privacy:sensors",enabledLabel:"siteSettingsMotionSensorsAllowed",disabledLabel:"siteSettingsMotionSensorsBlocked"},{route:routes.SITE_SETTINGS_SERIAL_PORTS,id:Id.SERIAL_PORTS,label:"siteSettingsSerialPorts",icon:"privacy:developer-board",enabledLabel:"siteSettingsSerialPortsAllowed",disabledLabel:"siteSettingsSerialPortsBlocked"},{route:routes.SITE_SETTINGS_SITE_DATA,id:Id.SITE_DATA,label:"siteDataPageTitle",icon:"privacy:database"},{route:routes.SITE_SETTINGS_SOUND,id:Id.SOUND,label:"siteSettingsSound",icon:"privacy:volume-up",enabledLabel:"siteSettingsSoundAllowed",disabledLabel:"siteSettingsSoundBlocked"},{route:routes.SITE_SETTINGS_STORAGE_ACCESS,id:Id.STORAGE_ACCESS,label:"siteSettingsStorageAccess",icon:"privacy:storage-access",enabledLabel:"storageAccessAllowed",disabledLabel:"storageAccessBlocked"},{route:routes.SITE_SETTINGS_USB_DEVICES,id:Id.USB_DEVICES,label:"siteSettingsUsbDevices",icon:"privacy:usb",enabledLabel:"siteSettingsUsbAllowed",disabledLabel:"siteSettingsUsbBlocked"},{route:routes.SITE_SETTINGS_VR,id:Id.VR,label:"siteSettingsVr",icon:"privacy:cardboard",enabledLabel:"siteSettingsVrAllowed",disabledLabel:"siteSettingsVrBlocked"},{route:routes.SITE_SETTINGS_WEB_APP_INSTALLATION,id:Id.WEB_APP_INSTALLATION,label:"siteSettingsWebAppInstallation",icon:"settings:install-desktop",enabledLabel:"siteSettingsWebAppInstallationAsk",disabledLabel:"siteSettingsWebAppInstallationBlock",shouldShow:()=>loadTimeData.getBoolean("enableWebAppInstallation")},{route:routes.SITE_SETTINGS_WEB_PRINTING,id:Id.WEB_PRINTING,label:"siteSettingsWebPrinting",icon:"settings:printer",enabledLabel:"siteSettingsWebPrintingAsk",disabledLabel:"siteSettingsWebPrintingBlock",shouldShow:()=>loadTimeData.getBoolean("enableWebPrintingContentSetting")},{route:routes.SITE_SETTINGS_WINDOW_MANAGEMENT,id:Id.WINDOW_MANAGEMENT,label:"siteSettingsWindowManagement",icon:"privacy:select-window",enabledLabel:"siteSettingsWindowManagementAsk",disabledLabel:"siteSettingsWindowManagementBlocked"},{route:routes.SITE_SETTINGS_ZOOM_LEVELS,id:Id.ZOOM_LEVELS,label:"siteSettingsZoomLevels",icon:"privacy:zoom-in"},{route:routes.COOKIES,id:Id.COOKIES,label:"thirdPartyCookiesLinkRowLabel",icon:"privacy:cookie"}];categoryItemMap=new Map(categoryList.map((item=>[item.id,item])));return categoryItemMap}function buildItemListFromIds(orderedIdList){const map=getCategoryItemMap();const orderedList=[];for(const id of orderedIdList){const item=map.get(id);if(item.shouldShow===undefined||item.shouldShow()){orderedList.push(item)}}return orderedList}const SettingsSiteSettingsPageElementBase=RouteObserverMixin(SettingsViewMixin(WebUiListenerMixin(PolymerElement)));class SettingsSiteSettingsPageElement extends SettingsSiteSettingsPageElementBase{static get is(){return"settings-site-settings-page"}static get template(){return getTemplate$D()}static get properties(){return{prefs:{type:Object,notify:true},lists_:{type:Object,value:function(){return{permissionsBasic:buildItemListFromIds([Id.GEOLOCATION,Id.CAMERA,Id.MIC,Id.NOTIFICATIONS,Id.STORAGE_ACCESS]),permissionsAdvanced:buildItemListFromIds([Id.BACKGROUND_SYNC,Id.SENSORS,Id.AUTOMATIC_DOWNLOADS,Id.PROTOCOL_HANDLERS,Id.MIDI_DEVICES,Id.USB_DEVICES,Id.SERIAL_PORTS,Id.BLUETOOTH_DEVICES,Id.FILE_SYSTEM_WRITE,Id.HID_DEVICES,Id.CLIPBOARD,Id.PAYMENT_HANDLER,Id.BLUETOOTH_SCANNING,Id.AR,Id.VR,Id.HAND_TRACKING,Id.IDLE_DETECTION,Id.WEB_PRINTING,Id.WINDOW_MANAGEMENT,Id.LOCAL_FONTS,Id.AUTO_PICTURE_IN_PICTURE,Id.CAPTURED_SURFACE_CONTROL,Id.KEYBOARD_LOCK,Id.WEB_APP_INSTALLATION,Id.LOCAL_NETWORK_ACCESS]),contentBasic:buildItemListFromIds([Id.COOKIES,Id.JAVASCRIPT,Id.IMAGES,Id.POPUPS]),contentAdvanced:buildItemListFromIds([Id.SOUND,Id.ADS,Id.ZOOM_LEVELS,Id.PDF_DOCUMENTS,Id.PROTECTED_CONTENT,Id.MIXEDSCRIPT,Id.FEDERATED_IDENTITY_API,Id.ANTI_ABUSE,Id.SITE_DATA,Id.PERFORMANCE,Id.JAVASCRIPT_OPTIMIZER,Id.AUTOMATIC_FULLSCREEN,Id.OFFER_WRITING_HELP])}}},permissionsExpanded_:Boolean,contentExpanded_:Boolean,noRecentSitePermissions_:Boolean,showUnusedSitePermissions_:{type:Boolean,value:false},unusedSitePermissionsHeader_:String,unusedSitePermissionsSubheader_:String}}connectedCallback(){super.connectedCallback();this.addWebUiListener(SafetyHubEvent.UNUSED_PERMISSIONS_MAYBE_CHANGED,(sites=>this.onUnusedSitePermissionListChanged_(sites)));this.safetyHubBrowserProxy_.getRevokedUnusedSitePermissionsList().then((sites=>this.onUnusedSitePermissionListChanged_(sites)))}safetyHubBrowserProxy_=SafetyHubBrowserProxyImpl.getInstance();metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();currentRouteChanged(newRoute,oldRoute){super.currentRouteChanged(newRoute,oldRoute);if(Router.getInstance().getCurrentRoute()!==routes.SITE_SETTINGS){return}if(this.showUnusedSitePermissions_){this.metricsBrowserProxy_.recordSafetyHubEntryPointShown(SafetyHubEntryPoint.SITE_SETTINGS)}}onSiteSettingsAllClick_(){Router.getInstance().navigateTo(routes.SITE_SETTINGS_ALL)}async onUnusedSitePermissionListChanged_(permissions){if(this.showUnusedSitePermissions_){return}this.showUnusedSitePermissions_=permissions.length>0&&!loadTimeData.getBoolean("isGuest");this.unusedSitePermissionsHeader_=await PluralStringProxyImpl.getInstance().getPluralString("safetyHubUnusedSitePermissionsPrimaryLabel",permissions.length);this.unusedSitePermissionsSubheader_=await PluralStringProxyImpl.getInstance().getPluralString("safetyHubRevokedPermissionsSecondaryLabel",permissions.length)}getClassForSiteSettingsAllLink_(){return this.noRecentSitePermissions_?"":"hr"}onSafetyHubButtonClick_(){this.metricsBrowserProxy_.recordSafetyHubEntryPointClicked(SafetyHubEntryPoint.SITE_SETTINGS);Router.getInstance().navigateTo(routes.SAFETY_HUB)}getFocusConfig(){const focusConfig=new Map([[`${routes.SITE_SETTINGS_ALL.path}`,"#allSites"]]);const siteSettingsLists=this.shadowRoot.querySelectorAll("settings-site-settings-list");for(const list of siteSettingsLists){for(const[key,value]of list.getFocusConfig()){focusConfig.set(key,value)}}for(const[key,value]of this.$.recentSitePermissions.getFocusConfig()){focusConfig.set(key,value)}return focusConfig}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsSiteSettingsPageElement.is,SettingsSiteSettingsPageElement);function getTemplate$C(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsSound}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsSoundDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.SOUND]]"
      allow-option-label="$i18n{siteSettingsSoundAllowed}"
      allow-option-icon="privacy:volume-up"
      block-option-label="$i18n{siteSettingsSoundBlocked}"
      block-option-sub-label="$i18n{siteSettingsSoundBlockedSubLabel}"
      block-option-icon="privacy:volume-off">
  </settings-category-default-radio-group>
  <settings-toggle-button
      id="blockAutoplaySetting"
      class="hr"
      label="$i18n{siteSettingsBlockAutoplaySetting}"
      pref="{{blockAutoplayStatus_.pref}}"
      disabled="[[!blockAutoplayStatus_.enabled]]"
      hidden="[[!enableBlockAutoplayContentSetting_]]"
      on-settings-boolean-control-change="onBlockAutoplayToggleChange_"
      no-set-pref>
  </settings-toggle-button>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.SOUND]]"
      allow-header="$i18n{siteSettingsSoundAllowedExceptions}"
      block-header="$i18n{siteSettingsSoundBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const SoundPageElementBase=SettingsViewMixin(WebUiListenerMixin(PolymerElement));class SoundPageElement extends SoundPageElementBase{static get is(){return"settings-sound-page"}static get template(){return getTemplate$C()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes},blockAutoplayStatus_:{type:Object,value(){return{}}},enableBlockAutoplayContentSetting_:{type:Boolean,value(){return loadTimeData.getBoolean("enableBlockAutoplayContentSetting")}}}}browserProxy_=SiteSettingsBrowserProxyImpl.getInstance();ready(){super.ready();this.onBlockAutoplayStatusChanged_({pref:{key:"",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:false},enabled:false});this.addWebUiListener("onBlockAutoplayStatusChanged",(status=>this.onBlockAutoplayStatusChanged_(status)))}onBlockAutoplayStatusChanged_(autoplayStatus){this.blockAutoplayStatus_=autoplayStatus}onBlockAutoplayToggleChange_(event){const target=event.target;this.browserProxy_.setBlockAutoplayEnabled(target.checked)}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SoundPageElement.is,SoundPageElement);function getTemplate$B(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared">.row-aligned{align-items:center;display:flex}.site-representation{display:flex}.list-frame{padding-inline-end:0}.settings-row{flex:1}</style>
<div class="list-item">
  <div class="settings-row">
    <site-favicon url="[[model.faviconOrigin]]"></site-favicon>
    <div class="middle" id="displayName">
      <div class="site-representation url-directionality text-elide">
        [[model.displayName]]
      </div>
      <div class="second-line cr-secondary-text">
        [[model.description]]
      </div>
    </div>
  </div>
  <!-- Incognito icon. -->
  <template is="dom-if" if="[[model.incognito]]">
    <cr-tooltip-icon id="incognitoTooltip"
        icon-aria-label="$i18n{incognitoSiteExceptionDesc}"
        icon-class="settings20:incognito"
        focus-type="incognito"
        tooltip-text="$i18n{incognitoSiteExceptionDesc}"
        focus-row-control>
    </cr-tooltip-icon>
  </template>
  <!-- Trash can icon. -->
  <div class="row-aligned">
    <div class="separator"></div>
    <cr-icon-button id="resetButton"
        aria-label$="[[model.resetAriaLabel]]"
        class="icon-delete-gray" on-click="onResetButtonClick_"
        focus-row-control focus-type="reset">
    </cr-icon-button>
  </div>
</div>
<!--_html_template_end_-->`}const StorageAccessStaticSiteListEntryElementBase=SiteSettingsMixin(PolymerElement);class StorageAccessStaticSiteListEntryElement extends StorageAccessStaticSiteListEntryElementBase{static get is(){return"storage-access-static-site-list-entry"}static get template(){return getTemplate$B()}static get properties(){return{model:Object}}onResetButtonClick_(){this.browserProxy.resetCategoryPermissionForPattern(this.model.origin,this.model.embeddingOrigin,ContentSettingsTypes.STORAGE_ACCESS,this.model.incognito)}}customElements.define(StorageAccessStaticSiteListEntryElement.is,StorageAccessStaticSiteListEntryElement);function getTemplate$A(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared">:host{padding-inline-end:4px;display:block}.row-aligned{align-items:center;display:flex}.site-representation{display:flex}.list-frame{padding-inline-end:0}.settings-row{flex:1}storage-access-static-site-list-entry{width:100%}cr-expand-button{width:100%;--cr-section-vertical-padding:0}</style>
<div id="collapseParent" focus-row-container>
  <!-- Static row, only if the exception applies to all domains, '*'. -->
  <template is="dom-if" if="[[shouldBeStatic_(model.*)]]" restamp>
    <storage-access-static-site-list-entry
        model="[[getStaticSiteEntryForModel_(model.*)]]">
    </storage-access-static-site-list-entry>
  </template>
  <!-- Collapsible row, otherwise. -->
  <template is="dom-if" if="[[shouldBeCollapsible_(model.*)]]" restamp>
    <div class="list-item">
      <!-- Top row of the collapsible component that represents an origin. -->
      <cr-expand-button id="expandButton" no-hover expanded="{{expanded_}}"
          aria-label$="[[expandAriaLabel_]]"
          focus-type="embedded-site">
        <div class="settings-row">
          <site-favicon url="[[model.origin]]"></site-favicon>
          <div class="middle" id="displayName">
            <div class="site-representation url-directionality text-elide">
              [[model.displayName]]
            </div>
            <div class="second-line cr-secondary-text">[[description_]]</div>
          </div>
        </div>
      </cr-expand-button>
      <!-- Trash can icon. -->
      <div class="row-aligned">
        <div class="separator"></div>
        <cr-icon-button id="resetAllButton" class="icon-delete-gray"
            aria-label$="[[getResetAllButtonAriaLabel_(model.*)]]"
            on-click="onResetAllButtonClick_" focus-type="reset-all">
        </cr-icon-button>
      </div>
    </div>
    <template is="dom-if" if="[[expanded_]]" id="originList">
      <div class="list-frame">
        <template is="dom-repeat" items="[[model.exceptions]]">
          <!-- Nested row that represents an embedding origin. -->
          <div class="hr">
            <storage-access-static-site-list-entry
                model="[[getStaticSiteEntryForException_(item)]]">
            </storage-access-static-site-list-entry>
          </div>
        </template>
      </div>
    </template>
  </template>
</div>
<!--_html_template_end_-->`}const StorageAccessSiteListEntryElementBase=FocusRowMixin(SiteSettingsMixin(I18nMixin(PolymerElement)));class StorageAccessSiteListEntryElement extends StorageAccessSiteListEntryElementBase{static get is(){return"storage-access-site-list-entry"}static get template(){return getTemplate$A()}static get properties(){return{model:{type:Object,observer:"onModelChanged_"},expanded_:{type:Boolean,observer:"onExpandedChanged_",notify:true,value:false},description_:String,expandAriaLabel_:String}}onResetAllButtonClick_(){for(const exception of this.model.exceptions){this.browserProxy.resetCategoryPermissionForPattern(this.model.origin,exception.embeddingOrigin,ContentSettingsTypes.STORAGE_ACCESS,exception.incognito)}}onModelChanged_(){this.description_=this.computeDescription_();this.expandAriaLabel_=this.computeExpandButtonAriaLabel_()}onExpandedChanged_(){if(!this.shouldBeCollapsible_()){return}this.description_=this.computeDescription_();this.expandAriaLabel_=this.computeExpandButtonAriaLabel_();if(!this.expanded_){return}this.shadowRoot.querySelector("#originList").render();this.scrollIntoViewIfNeeded()}getResetAllButtonAriaLabel_(){return this.i18n("storageAccessResetAll",this.model.displayName)}getResetButtonAriaLabel_(item){return this.i18n("storageAccessResetSite",this.model.displayName,item.embeddingDisplayName)}computeExpandButtonAriaLabel_(){return this.expanded_?this.i18n("storageAccessCloseExpand"):this.i18n("storageAccessOpenExpand")}computeDescription_(){if(!this.model||!this.model.openDescription||!this.model.closeDescription){return""}return this.expanded_?this.model.openDescription:this.model.closeDescription}shouldBeStatic_(){if(!this.model){return false}return this.model.exceptions.length===0}shouldBeCollapsible_(){if(!this.model){return false}return this.model.exceptions.length!==0}getStaticSiteEntryForModel_(){return{faviconOrigin:this.model.origin,displayName:this.model.displayName,description:this.model.description,resetAriaLabel:this.getResetAllButtonAriaLabel_(),origin:this.model.origin,embeddingOrigin:"",incognito:this.model.incognito||false}}getStaticSiteEntryForException_(item){return{faviconOrigin:item.embeddingOrigin,displayName:item.embeddingDisplayName,description:item.description,resetAriaLabel:this.getResetButtonAriaLabel_(item),origin:this.model.origin,embeddingOrigin:item.embeddingOrigin,incognito:item.incognito}}}customElements.define(StorageAccessSiteListEntryElement.is,StorageAccessSiteListEntryElement);function getTemplate$z(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared"></style>
<div class="cr-row first">
  <h2 class="cr-secondary-text">[[categoryHeader]]</h2>
</div>
<div class="list-frame"
    hidden$="[[hasExceptions_(storageAccessExceptions_.*)]]">
  <div class="list-item cr-secondary-text">$i18n{noSitesAdded}</div>
</div>
<div class="list-frame" hidden$=
    "[[!showNoSearchResults_(searchFilter, storageAccessExceptions_.*)]]">
  <div class="list-item cr-secondary-text">$i18n{searchNoResults}</div>
</div>
<div class="list-frame vertical-list" id="listContainer" hidden$=
    "[[!hasExceptions_(storageAccessExceptions_.*)]]">
  <template is="dom-repeat" items=
      "[[getFilteredExceptions_(searchFilter, storageAccessExceptions_.*)]]">
    <storage-access-site-list-entry model="[[item]]">
    </storage-access-site-list-entry>
  </template>
</div>
<!--_html_template_end_-->`}const StorageAccessSiteListElementBase=ListPropertyUpdateMixin(SiteSettingsMixin(WebUiListenerMixin(PolymerElement)));class StorageAccessSiteListElement extends StorageAccessSiteListElementBase{static get is(){return"storage-access-site-list"}static get template(){return getTemplate$z()}static get properties(){return{categoryHeader:String,storageAccessExceptions_:{type:Array,value(){return[]}},categorySubtype:{type:String,value:INVALID_CATEGORY_SUBTYPE},searchFilter:{type:String,observer:"getFilteredExceptions_"}}}static get observers(){return["populateList_(categorySubtype, storageAccessExceptions_)"]}connectedCallback(){super.connectedCallback();this.addWebUiListener("contentSettingSitePermissionChanged",(category=>{if(category!==ContentSettingsTypes.STORAGE_ACCESS){return}this.populateList_()}));this.addWebUiListener("onIncognitoStatusChanged",(()=>this.populateList_()));this.browserProxy.updateIncognitoStatus()}async populateList_(){if(this.categorySubtype===undefined){return}const exceptionList=await this.browserProxy.getStorageAccessExceptionList(this.categorySubtype);this.updateList("storageAccessExceptions_",(x=>x.origin),exceptionList)}showNoSearchResults_(){return this.storageAccessExceptions_.length>0&&this.getFilteredExceptions_().length===0}hasExceptions_(){return this.storageAccessExceptions_.length>0}getFilteredExceptions_(){if(!this.searchFilter){return this.storageAccessExceptions_.slice()}const searchFilter=this.searchFilter.toLowerCase();const propNames=["displayName","origin"];return this.storageAccessExceptions_.filter((site=>propNames.some((propName=>site[propName].toLowerCase().includes(searchFilter)||this.getFilteredEmbeddingExceptions_(site.exceptions,searchFilter).length))))}getFilteredEmbeddingExceptions_(exceptions,searchFilter){const propNamesEmbedding=["embeddingDisplayName","embeddingOrigin"];return exceptions.filter((embedding=>propNamesEmbedding.some((propNamesEmbedding=>embedding[propNamesEmbedding].toLowerCase().includes(searchFilter)))))}}customElements.define(StorageAccessSiteListElement.is,StorageAccessSiteListElement);function getTemplate$y(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsStorageAccess}"
    search-label="$i18n{siteSettingsAllSitesFilter}"
    search-icon="settings20:filter-list"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{storageAccessDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.STORAGE_ACCESS]]"
      allow-option-label="$i18n{storageAccessAllowed}"
      allow-option-icon="privacy:storage-access"
      block-option-label="$i18n{storageAccessBlocked}"
      block-option-icon="privacy:storage-access-off">
  </settings-category-default-radio-group>
  <!-- Exceptions section. -->
  <div class="content-settings-header">
    <h2>$i18n{siteSettingsCustomizedBehaviors}</h2>
    <div class="cr-secondary-text">
      $i18n{siteSettingsCustomizedBehaviorsDescription}
    </div>
  </div>
  <storage-access-site-list
      category-subtype="[[contentSettingEnum_.BLOCK]]"
      category-header="$i18n{storageAccessBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </storage-access-site-list>
  <storage-access-site-list
      category-subtype="[[contentSettingEnum_.ALLOW]]"
      category-header="$i18n{storageAccessAllowedExceptions}"
      search-filter="[[searchTerm]]">
  </storage-access-site-list>
</settings-subpage>
<!--_html_template_end_-->`}const StorageAccessPageElementBase=SettingsViewMixin(PolymerElement);class StorageAccessPageElement extends StorageAccessPageElementBase{static get is(){return"settings-storage-access-page"}static get template(){return getTemplate$y()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes},contentSettingEnum_:{type:Object,value:ContentSetting}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(StorageAccessPageElement.is,StorageAccessPageElement);function getTemplate$x(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsUsbDevices}"
    learn-more-url="$i18n{chooserUsbOverviewURL}"
    route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsUsbDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.USB_DEVICES]]"
      allow-option-label="$i18n{siteSettingsUsbAllowed}"
      allow-option-icon="privacy:usb"
      block-option-label="$i18n{siteSettingsUsbBlocked}"
      block-option-icon="privacy:usb-off">
  </settings-category-default-radio-group>
  <chooser-exception-list
      category="[[contentSettingsTypesEnum_.USB_DEVICES]]"
      chooser-type="[[chooserTypeEnum_.USB_DEVICES]]">
  </chooser-exception-list>
</settings-subpage>
<!--_html_template_end_-->`}const UsbDevicesPageElementBase=SettingsViewMixin(PolymerElement);class UsbDevicesPageElement extends UsbDevicesPageElementBase{static get is(){return"settings-usb-devices-page"}static get template(){return getTemplate$x()}static get properties(){return{contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes},chooserTypeEnum_:{type:Object,value:ChooserType}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(UsbDevicesPageElement.is,UsbDevicesPageElement);function getTemplate$w(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage
    page-title="$i18n{siteSettingsCategoryJavascriptOptimizer}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsJavascriptOptimizerDescription}
  </div>
  <div class="radio-group">
    <h2>$i18n{siteSettingsDefaultBehavior}</h2>
    <div id="radioGroupSubLabel" class="secondary">
      $i18n{siteSettingsDefaultBehaviorDescription}
    </div>
    <settings-radio-group
        id="javascriptOptimizerRadioGroup"
        pref="{{prefs.generated.javascript_optimizer}}"
        selectable-elements="settings-collapse-radio-button"
        group-aria-label="$i18n{siteSettingsDefaultBehavior}">
      <settings-collapse-radio-button
          id="enableForAllSites"
          class="two-line"
          name="[[javascriptOptimizerSettingEnum_.ALLOWED]]"
          pref="[[prefs.generated.javascript_optimizer]]"
          label="$i18n{siteSettingsJavascriptOptimizerAllowed}"
          sub-label="$i18n{siteSettingsJavascriptOptimizerAllowedSubLabel}"
          no-collapse>
      </settings-collapse-radio-button>
      <template is="dom-if"
          if="[[enableBlockV8OptimizerOnUnfamiliarSites_]]">
        <settings-collapse-radio-button
            id="blockForUnfamiliarSites"
            class="two-line"
            name="[[javascriptOptimizerSettingEnum_.BLOCKED_FOR_UNFAMILIAR_SITES]]"
            pref="[[prefs.generated.javascript_optimizer]]"
            label="$i18n{siteSettingsJavascriptOptimizerBlockedUnfamiliarSites}"
            sub-label="[[getBlockForUnfamiliarSitesSubLabel_(
                prefs.generated.javascript_optimizer.value)]]"
            no-collapse>
        </settings-collapse-radio-button>
      </template>
      <settings-collapse-radio-button
          id="blockForAllSites"
          class="two-line"
          name="[[javascriptOptimizerSettingEnum_.BLOCKED]]"
          pref="[[prefs.generated.javascript_optimizer]]"
          label="$i18n{siteSettingsJavascriptOptimizerBlocked}"
          sub-label="$i18n{siteSettingsJavascriptOptimizerBlockedSubLabel}"
          no-collapse>
      </settings-collapse-radio-button>
    </settings-radio-group>
  </div>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.JAVASCRIPT_OPTIMIZER]]"
      allow-header="$i18n{siteSettingsJavascriptOptimizerAllowedExceptions}"
      block-header="$i18n{siteSettingsJavascriptOptimizerBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const V8PageElementBase=SettingsViewMixin(I18nMixin(PrefsMixin(PolymerElement)));class V8PageElement extends V8PageElementBase{static get is(){return"settings-v8-page"}static get template(){return getTemplate$w()}static get properties(){return{searchTerm:String,enableBlockV8OptimizerOnUnfamiliarSites_:{type:Boolean,value(){return loadTimeData.getBoolean("enableBlockV8OptimizerOnUnfamiliarSites")}},contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes},javascriptOptimizerSettingEnum_:{type:Object,value:JavascriptOptimizerSetting}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}getBlockForUnfamiliarSitesSubLabel_(){const safeBrowsingSetting=this.getPref("generated.safe_browsing").value;return this.i18n(safeBrowsingSetting===SafeBrowsingSetting.DISABLED?"siteSettingsJavascriptOptimizerBlockedUnfamiliarSitesSafeBrowsingOffSubLabel":"siteSettingsJavascriptOptimizerBlockedUnfamiliarSitesSubLabel")}}customElements.define(V8PageElement.is,V8PageElement);function getTemplate$v(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsVr}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsVrDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.VR]]"
      allow-option-label="$i18n{siteSettingsVrAllowed}"
      allow-option-icon="privacy:cardboard"
      block-option-label="$i18n{siteSettingsVrBlocked}"
      block-option-icon="privacy:cardboard-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.VR]]"
      read-only-list
      allow-header="$i18n{siteSettingsVrAllowedExceptions}"
      block-header="$i18n{siteSettingsVrBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const VrPageElementBase=SettingsViewMixin(PolymerElement);class VrPageElement extends VrPageElementBase{static get is(){return"settings-vr-page"}static get template(){return getTemplate$v()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(VrPageElement.is,VrPageElement);function getTemplate$u(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsWebAppInstallation}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsWebAppInstallationDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.WEB_APP_INSTALLATION]]"
      allow-option-label="$i18n{siteSettingsWebAppInstallationAsk}"
      allow-option-icon="settings:install-desktop"
      block-option-label="$i18n{siteSettingsWebAppInstallationBlock}"
      block-option-icon="settings:install-desktop-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.WEB_APP_INSTALLATION]]"
      block-header=
          "$i18n{siteSettingsWebAppInstallationBlockedExceptions}"
      allow-header=
          "$i18n{siteSettingsWebAppInstallationAllowedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const WebApplicationsPageElementBase=SettingsViewMixin(PolymerElement);class WebApplicationsPageElement extends WebApplicationsPageElementBase{static get is(){return"settings-web-applications-page"}static get template(){return getTemplate$u()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(WebApplicationsPageElement.is,WebApplicationsPageElement);function getTemplate$t(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsWebPrinting}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
      $i18n{siteSettingsWebPrintingDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.WEB_PRINTING]]"
      allow-option-label="$i18n{siteSettingsWebPrintingAsk}"
      allow-option-icon="settings:printer"
      block-option-label="$i18n{siteSettingsWebPrintingBlock}"
      block-option-icon="settings:printer-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.WEB_PRINTING]]"
      allow-header="$i18n{siteSettingsWebPrintingAllowedExceptions}"
      block-header="$i18n{siteSettingsWebPrintingBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const WebPrintingPageElementBase=SettingsViewMixin(PolymerElement);class WebPrintingPageElement extends WebPrintingPageElementBase{static get is(){return"settings-web-printing-page"}static get template(){return getTemplate$t()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(WebPrintingPageElement.is,WebPrintingPageElement);function getTemplate$s(){return html`<!--_html_template_start_--><style include="settings-shared site-settings-shared"></style>
<settings-subpage page-title="$i18n{siteSettingsWindowManagement}"
    search-label="$i18n{siteSettingsAllSitesSearch}"
    search-term="{{searchTerm}}" route-path$="[[routePath]]">
  <div class="content-settings-header secondary">
    $i18n{siteSettingsWindowManagementDescription}
  </div>
  <settings-category-default-radio-group
      category="[[contentSettingsTypesEnum_.WINDOW_MANAGEMENT]]"
      allow-option-label="$i18n{siteSettingsWindowManagementAsk}"
      allow-option-icon="privacy:select-window"
      block-option-label="$i18n{siteSettingsWindowManagementBlocked}"
      block-option-icon="privacy:select-window-off">
  </settings-category-default-radio-group>
  <category-setting-exceptions
      category="[[contentSettingsTypesEnum_.WINDOW_MANAGEMENT]]"
      allow-header="$i18n{siteSettingsWindowManagementAskExceptions}"
      block-header=
          "$i18n{siteSettingsWindowManagementBlockedExceptions}"
      search-filter="[[searchTerm]]">
  </category-setting-exceptions>
</settings-subpage>
<!--_html_template_end_-->`}const WindowManagementPageElementBase=SettingsViewMixin(PolymerElement);class WindowManagementPageElement extends WindowManagementPageElementBase{static get is(){return"settings-window-management-page"}static get template(){return getTemplate$s()}static get properties(){return{searchTerm:String,contentSettingsTypesEnum_:{type:Object,value:ContentSettingsTypes}}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(WindowManagementPageElement.is,WindowManagementPageElement);function getTemplate$r(){return html`<!--_html_template_start_-->  <style include="settings-shared">:host{display:block}.zoom-label{color:var(--cr-secondary-text-color);margin-inline-end:16px}#empty{margin-top:15px}.list-item site-favicon{flex-shrink:0}.list-item .middle{overflow-x:hidden;text-overflow:ellipsis}.content-settings-header{padding:0 var(--cr-section-padding)}
  </style>
  <settings-subpage page-title="$i18n{siteSettingsCategoryZoomLevels}">
    <div class="content-settings-header secondary">
      $i18n{siteSettingsZoomLevelsDescription}
    </div>
    <div class="list-frame vertical-list" id="listContainer">
      <iron-list id="list" preserve-focus items="[[sites_]]"
          class="cr-separators" risk-selection>
        <template>
          <div class="list-item" first$="[[!index]]">
            <site-favicon url="[[item.originForFavicon]]"></site-favicon>
            <div class="middle">
              <span class="url-directionality">[[item.displayName]]</span>
            </div>
            <div class="zoom-label">[[item.zoom]]</div>
            <cr-icon-button class="icon-clear" on-click="removeZoomLevel_"
                title="$i18n{siteSettingsRemoveZoomLevel}"
                tabindex$="[[tabIndex]]"></cr-icon-button>
          </div>
        </template>
      </iron-list>
      <div id="empty" hidden$="[[!showNoSites_]]">
        $i18n{siteSettingsNoZoomedSites}
      </div>
    </div>
  </settings-subpage>
<!--_html_template_end_-->`}const ZoomLevelsElementBase=SettingsViewMixin(ListPropertyUpdateMixin(SiteSettingsMixin(WebUiListenerMixin(PolymerElement))));class ZoomLevelsElement extends ZoomLevelsElementBase{static get is(){return"zoom-levels"}static get template(){return getTemplate$r()}static get properties(){return{sites_:{type:Array,value:()=>[]},showNoSites_:{type:Boolean,value:false}}}ready(){super.ready();this.addWebUiListener("onZoomLevelsChanged",(sites=>this.onZoomLevelsChanged_(sites)));this.browserProxy.fetchZoomLevels()}onZoomLevelsChanged_(sites){this.updateList("sites_",(item=>item.hostOrSpec),sites);this.showNoSites_=this.sites_.length===0}removeZoomLevel_(event){const site=this.sites_[event.model.index];this.browserProxy.removeZoomLevel(site.hostOrSpec)}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(ZoomLevelsElement.is,ZoomLevelsElement);class CaptionsBrowserProxyImpl{openSystemCaptionsDialog(){chrome.send("openSystemCaptionsDialog")}liveCaptionSectionReady(){chrome.send("liveCaptionSectionReady")}getInstalledLanguagePacks(){return sendWithPromise("getInstalledLanguagePacks")}getAvailableLanguagePacks(){return sendWithPromise("getAvailableLanguagePacks")}removeLanguagePack(languageCode){chrome.send("removeLanguagePack",[languageCode])}installLanguagePacks(languageCodes){chrome.send("installLanguagePacks",languageCodes)}static getInstance(){return instance$j||(instance$j=new CaptionsBrowserProxyImpl)}static setInstance(obj){instance$j=obj}}let instance$j=null;function getTemplate$q(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared">.cr-row-with-template{padding:0}#liveCaptionToggleButton{width:100%}.language-dropdown{margin-inline-start:auto}#defaultLanguageLabel{color:var(--cr-secondary-text-color)}</style>
<template is="dom-if" if="[[!enableLiveCaptionMultiLanguage_]]">
  <div class="cr-row cr-row-with-template first">
    <settings-toggle-button id="liveCaptionToggleButton"
        pref="{{prefs.accessibility.captions.live_caption_enabled}}"
        on-change="onLiveCaptionEnabledChanged_"
        label="$i18n{captionsEnableLiveCaptionTitle}"
        sub-label="[[enableLiveCaptionSubtitle_]]">
    </settings-toggle-button>
  </div>
  <cr-collapse
      opened="[[prefs.accessibility.captions.live_caption_enabled.value]]">
    <settings-toggle-button id="maskOffensiveWordsToggleButton"
        pref="{{prefs.accessibility.captions.live_caption_mask_offensive_words}}"
        on-change="onLiveCaptionMaskOffensiveWordsChanged_"
        label="$i18n{captionsMaskOffensiveWordsTitle}">
    </settings-toggle-button>
  </cr-collapse>
</template>

<template is="dom-if" if="[[enableLiveCaptionMultiLanguage_]]">
  <div class="cr-row cr-row-with-template first">
    <settings-toggle-button id="liveCaptionToggleButton"
        pref="{{prefs.accessibility.captions.live_caption_enabled}}"
        on-change="onLiveCaptionEnabledChanged_"
        label="$i18n{captionsEnableLiveCaptionTitle}"
        sub-label="$i18n{captionsEnableLiveCaptionSubtitle}">
    </settings-toggle-button>
  </div>
  <cr-collapse
      opened="[[prefs.accessibility.captions.live_caption_enabled.value]]">
    <div class="cr-row continuation">
      <div class="flex settings-box-text">
        $i18n{captionsManageLanguagesTitle}
        <div class="secondary">$i18n{captionsManageLanguagesSubtitle}</div>
      </div>
      <cr-button id="addLanguage" on-click="onAddLanguagesClick_">
        $i18n{addLanguages}
      </cr-button>
    </div>
    <div class="list-frame">
      <div id="languageList" class="vertical-list" role="list">
        <template is="dom-repeat" items="[[installedLanguagePacks_]]">
          <div class="list-item" role="listitem">
            <div class="start cr-padded-text">[[item.displayName]]
              <span id="defaultLanguageLabel"
                  hidden$="[[!isDefaultLanguage_(item.code,
                 prefs.accessibility.captions.live_caption_language.value)]]">
                $i18n{defaultLanguageLabel}
              </span>
            </div>
            <span aria-live="polite" role="region"
                class="cr-secondary-text cr-row-gap">
              [[item.downloadProgress]]
            </span>
            <cr-icon-button class="icon-more-vert" title="$i18n{moreActions}"
                id="more-[[item.language.code]]" on-click="onDotsClick_"
                aria-label="[[computeMoreButtonAriaLabel_(item.displayName,
              item.code,
              prefs.accessibility.captions.live_caption_language.value)]]">
            </cr-icon-button>
          </div>
        </template>
      </div>
    </div>
    <settings-toggle-button id="maskOffensiveWordsToggleButton"
        pref="{{prefs.accessibility.captions.live_caption_mask_offensive_words}}"
        on-change="onLiveCaptionMaskOffensiveWordsChanged_"
        label="$i18n{captionsMaskOffensiveWordsTitle}">
    </settings-toggle-button>
  </cr-collapse>
  <template is="dom-if" if="[[enableLiveTranslate_]]">
    <settings-live-translate prefs="{{prefs}}"></settings-live-translate>
  </template>
</template>
<template is="dom-if" if="[[showAddLanguagesDialog_]]" restamp>
  <settings-add-languages-dialog id="addLanguagesDialog"
      languages="[[filterAvailableLanguagePacks_(availableLanguagePacks_,
                   installedLanguagePacks_)]]"
      on-close="onAddLanguagesDialogClose_"
      on-languages-added="onLanguagesAdded_">
  </settings-add-languages-dialog>
</template>
<cr-lazy-render id="menu">
  <template>
    <cr-action-menu role-description="$i18n{menu}">
      <button class="dropdown-item" role="menuitem" id="make-default-button"
          on-click="onMakeDefaultClick_">
        $i18n{makeDefaultLanguageLabel}
      </button>
      <button class="dropdown-item" role="menuitem" id="remove-button"
          on-click="onRemoveLanguageClick_">
        $i18n{removeLanguageLabel}
      </button>
    </cr-action-menu>
  </template>
</cr-lazy-render>

<!--_html_template_end_-->`}class LanguagesBrowserProxyImpl{getLanguageSettingsPrivate(){return chrome.languageSettingsPrivate}static getInstance(){return instance$i||(instance$i=new LanguagesBrowserProxyImpl)}static setInstance(obj){instance$i=obj}}let instance$i=null;const MoveType=chrome.languageSettingsPrivate.MoveType;const kArcImeLanguage="_arc_ime_language_";let instance$h=null;function getLanguageHelperInstance(){assert(instance$h);return instance$h}const SettingsLanguagesElementBase=PrefsMixin(PolymerElement);class SettingsLanguagesElement extends SettingsLanguagesElementBase{static get is(){return"settings-languages"}static get properties(){return{languages:{type:Object,notify:true}}}static get observers(){return["alwaysTranslateLanguagesPrefChanged_("+"prefs.translate_allowlists.value.*, languages)","neverTranslateLanguagesPrefChanged_("+"prefs.translate_blocked_languages.value.*, languages)","neverTranslateSitesPrefChanged_("+"prefs.translate_site_blocklist_with_time.value.*, languages)","preferredLanguagesPrefChanged_("+"prefs.intl.accept_languages.value, languages)","preferredLanguagesPrefChanged_("+"prefs.intl.forced_languages.value.*, languages)","spellCheckDictionariesPrefChanged_("+"prefs.spellcheck.dictionaries.value.*, "+"prefs.spellcheck.forced_dictionaries.value.*, "+"prefs.spellcheck.blocked_dictionaries.value.*, languages)","translateLanguagesPrefChanged_("+"prefs.translate_blocked_languages.value.*, languages)","translateTargetPrefChanged_("+"prefs.translate_recent_target.value, languages)","updateRemovableLanguages_("+"prefs.intl.app_locale.value, languages.enabled)","updateRemovableLanguages_("+"prefs.translate_blocked_languages.value.*)"]}resolver_=new PromiseResolver;supportedLanguageMap_=new Map;enabledLanguageSet_=new Set;browserProxy_=LanguagesBrowserProxyImpl.getInstance();languageSettingsPrivate_;constructor(){super();this.languageSettingsPrivate_=this.browserProxy_.getLanguageSettingsPrivate()}connectedCallback(){super.connectedCallback();assert(!instance$h);instance$h=this;const promises=[];const args={supportedLanguages:[],translateTarget:"",alwaysTranslateCodes:[],neverTranslateCodes:[],neverTranslateSites:[],startingUILanguage:"",supportedInputMethods:[],currentInputMethodId:""};promises.push(CrSettingsPrefs.initialized);promises.push(this.languageSettingsPrivate_.getLanguageList().then((result=>{args.supportedLanguages=result})));promises.push(this.languageSettingsPrivate_.getTranslateTargetLanguage().then((result=>{args.translateTarget=result})));promises.push(this.languageSettingsPrivate_.getAlwaysTranslateLanguages().then((result=>{args.alwaysTranslateCodes=result})));promises.push(this.languageSettingsPrivate_.getNeverTranslateLanguages().then((result=>{args.neverTranslateCodes=result})));Promise.all(promises).then((()=>{if(!this.isConnected){return}this.createModel_(args);this.resolver_.resolve()}))}disconnectedCallback(){super.disconnectedCallback();instance$h=null;this.resolver_=new PromiseResolver}preferredLanguagesPrefChanged_(){if(this.prefs===undefined||this.languages===undefined){return}const enabledLanguageStates=this.getEnabledLanguageStates_(this.languages.translateTarget,this.languages.prospectiveUILanguage);this.enabledLanguageSet_.clear();for(let i=0;i<enabledLanguageStates.length;i++){this.enabledLanguageSet_.add(enabledLanguageStates[i].language.code)}this.set("languages.enabled",enabledLanguageStates);this.languageSettingsPrivate_.getTranslateTargetLanguage().then((result=>{this.set("languages.translateTarget",result)}))}spellCheckDictionariesPrefChanged_(){if(this.prefs===undefined||this.languages===undefined){return}const spellCheckSet=this.makeSetFromArray_(this.getPref("spellcheck.dictionaries").value);const spellCheckForcedSet=this.makeSetFromArray_(this.getPref("spellcheck.forced_dictionaries").value);const spellCheckBlockedSet=this.makeSetFromArray_(this.getPref("spellcheck.blocked_dictionaries").value);for(let i=0;i<this.languages.enabled.length;i++){const languageState=this.languages.enabled[i];const isUser=spellCheckSet.has(languageState.language.code);const isForced=spellCheckForcedSet.has(languageState.language.code);const isBlocked=spellCheckBlockedSet.has(languageState.language.code);this.set(`languages.enabled.${i}.spellCheckEnabled`,isUser&&!isBlocked||isForced);this.set(`languages.enabled.${i}.isManaged`,isForced||isBlocked)}const{on:spellCheckOnLanguages,off:spellCheckOffLanguages}=this.getSpellCheckLanguages_(this.languages.supported);this.set("languages.spellCheckOnLanguages",spellCheckOnLanguages);this.set("languages.spellCheckOffLanguages",spellCheckOffLanguages)}getSpellCheckLanguages_(supportedLanguages){const seenCodes=new Set;const getPrefAndDedupe=prefName=>{const result=this.getPref(prefName).value.filter((x=>!seenCodes.has(x)));result.forEach((code=>seenCodes.add(code)));return result};const forcedCodes=getPrefAndDedupe("spellcheck.forced_dictionaries");const forcedCodesSet=new Set(forcedCodes);const blockedCodes=getPrefAndDedupe("spellcheck.blocked_dictionaries");const blockedCodesSet=new Set(blockedCodes);const enabledCodes=getPrefAndDedupe("spellcheck.dictionaries");const on=[];for(const code of[...forcedCodes,...enabledCodes]){const language=this.supportedLanguageMap_.get(code);if(language){on.push({language:language,isManaged:forcedCodesSet.has(code),spellCheckEnabled:true,downloadDictionaryStatus:null,downloadDictionaryFailureCount:0})}}const off=[];for(const language of supportedLanguages){if(language.supportsSpellcheck&&(!seenCodes.has(language.code)||blockedCodesSet.has(language.code))){off.push({language:language,isManaged:blockedCodesSet.has(language.code),spellCheckEnabled:false,downloadDictionaryStatus:null,downloadDictionaryFailureCount:0})}}return{on:on,off:off}}alwaysTranslateLanguagesPrefChanged_(){if(this.prefs===undefined||this.languages===undefined){return}const alwaysTranslateCodes=Object.keys(this.getPref("translate_allowlists").value);const alwaysTranslateLanguages=alwaysTranslateCodes.map((code=>this.getLanguage(code)));this.set("languages.alwaysTranslate",alwaysTranslateLanguages)}neverTranslateLanguagesPrefChanged_(){if(this.prefs===undefined||this.languages===undefined){return}const neverTranslateCodes=this.getPref("translate_blocked_languages").value;const neverTranslateLanguages=neverTranslateCodes.map((code=>this.getLanguage(code)));this.set("languages.neverTranslate",neverTranslateLanguages)}neverTranslateSitesPrefChanged_(){if(this.prefs===undefined||this.languages===undefined){return}const neverTranslateSites=Object.keys(this.getPref("translate_site_blocklist_with_time").value);this.set("languages.neverTranslateSites",neverTranslateSites)}translateLanguagesPrefChanged_(){if(this.prefs===undefined||this.languages===undefined){return}const translateBlockedPrefValue=this.getPref("translate_blocked_languages").value;const translateBlockedSet=this.makeSetFromArray_(translateBlockedPrefValue);for(let i=0;i<this.languages.enabled.length;i++){const language=this.languages.enabled[i].language;const translateEnabled=this.isTranslateEnabled_(language.code,!!language.supportsTranslate,translateBlockedSet,this.languages.translateTarget,this.languages.prospectiveUILanguage);this.set("languages.enabled."+i+".translateEnabled",translateEnabled)}}translateTargetPrefChanged_(){if(this.prefs===undefined||this.languages===undefined){return}this.set("languages.translateTarget",this.getPref("translate_recent_target").value)}createModel_(args){for(let i=0;i<args.supportedLanguages.length;i++){const language=args.supportedLanguages[i];language.supportsUI=!!language.supportsUI;language.supportsTranslate=!!language.supportsTranslate;language.supportsSpellcheck=!!language.supportsSpellcheck;language.isProhibitedLanguage=!!language.isProhibitedLanguage;this.supportedLanguageMap_.set(language.code,language)}let prospectiveUILanguage;const enabledLanguageStates=this.getEnabledLanguageStates_(args.translateTarget,prospectiveUILanguage);for(let l=0;l<enabledLanguageStates.length;l++){this.enabledLanguageSet_.add(enabledLanguageStates[l].language.code)}const{on:spellCheckOnLanguages,off:spellCheckOffLanguages}=this.getSpellCheckLanguages_(args.supportedLanguages);const alwaysTranslateLanguages=args.alwaysTranslateCodes.map((code=>this.getLanguage(code)));const neverTranslateLanguages=args.neverTranslateCodes.map((code=>this.getLanguage(code)));const model={supported:args.supportedLanguages,enabled:enabledLanguageStates,translateTarget:args.translateTarget,alwaysTranslate:alwaysTranslateLanguages,neverTranslate:neverTranslateLanguages,neverTranslateSites:args.neverTranslateSites,spellCheckOnLanguages:spellCheckOnLanguages,spellCheckOffLanguages:spellCheckOffLanguages};this.languages=model}getEnabledLanguageStates_(translateTarget,prospectiveUILanguage){assert(CrSettingsPrefs.isInitialized);const pref=this.getPref("intl.accept_languages");const enabledLanguageCodes=pref.value.split(",");const languagesForcedPref=this.getPref("intl.forced_languages");const spellCheckPref=this.getPref("spellcheck.dictionaries");const spellCheckForcedPref=this.getPref("spellcheck.forced_dictionaries");const spellCheckBlockedPref=this.getPref("spellcheck.blocked_dictionaries");const languageForcedSet=this.makeSetFromArray_(languagesForcedPref.value);const spellCheckSet=this.makeSetFromArray_(spellCheckPref.value.concat(spellCheckForcedPref.value));const spellCheckForcedSet=this.makeSetFromArray_(spellCheckForcedPref.value);const spellCheckBlockedSet=this.makeSetFromArray_(spellCheckBlockedPref.value);const translateBlockedPrefValue=this.getPref("translate_blocked_languages").value;const translateBlockedSet=this.makeSetFromArray_(translateBlockedPrefValue);const enabledLanguageStates=[];for(let i=0;i<enabledLanguageCodes.length;i++){const code=enabledLanguageCodes[i];const language=this.supportedLanguageMap_.get(code);if(!language){continue}const languageState={language:language,spellCheckEnabled:spellCheckSet.has(code)&&!spellCheckBlockedSet.has(code)||spellCheckForcedSet.has(code),translateEnabled:this.isTranslateEnabled_(code,!!language.supportsTranslate,translateBlockedSet,translateTarget,prospectiveUILanguage),isManaged:spellCheckForcedSet.has(code)||spellCheckBlockedSet.has(code),isForced:languageForcedSet.has(code),downloadDictionaryFailureCount:0,removable:false,downloadDictionaryStatus:null};enabledLanguageStates.push(languageState)}return enabledLanguageStates}isTranslateEnabled_(code,supportsTranslate,translateBlockedSet,translateTarget,prospectiveUILanguage){const translateCode=convertLanguageCodeForTranslate(code);return supportsTranslate&&!translateBlockedSet.has(translateCode)&&translateCode!==translateTarget&&(!prospectiveUILanguage||code!==prospectiveUILanguage)}updateRemovableLanguages_(){if(this.prefs===undefined||this.languages===undefined){return}for(let i=0;i<this.languages.enabled.length;i++){const languageState=this.languages.enabled[i];this.set("languages.enabled."+i+".removable",this.canDisableLanguage(languageState))}}makeSetFromArray_(list){return new Set(list)}whenReady(){return this.resolver_.promise}isLanguageCodeForArcIme_(languageCode){return languageCode===kArcImeLanguage}isLanguageEnabled(languageCode){return this.enabledLanguageSet_.has(languageCode)}enableLanguage(languageCode){if(!CrSettingsPrefs.isInitialized){return}this.languageSettingsPrivate_.enableLanguage(languageCode)}disableLanguage(languageCode){if(!CrSettingsPrefs.isInitialized){return}this.deletePrefListItem("spellcheck.dictionaries",languageCode);this.languageSettingsPrivate_.disableLanguage(languageCode)}canDisableLanguage(_languageState){if(this.languages.enabled.length===1){return false}return true}canEnableLanguage(language){return!(this.isLanguageEnabled(language.code)||language.isProhibitedLanguage||this.isLanguageCodeForArcIme_(language.code))}setLanguageAlwaysTranslateState(languageCode,alwaysTranslate){this.languageSettingsPrivate_.setLanguageAlwaysTranslateState(languageCode,alwaysTranslate)}moveLanguage(languageCode,upDirection){if(!CrSettingsPrefs.isInitialized){return}if(upDirection){this.languageSettingsPrivate_.moveLanguage(languageCode,MoveType.UP)}else{this.languageSettingsPrivate_.moveLanguage(languageCode,MoveType.DOWN)}}moveLanguageToFront(languageCode){if(!CrSettingsPrefs.isInitialized){return}this.languageSettingsPrivate_.moveLanguage(languageCode,MoveType.TOP)}enableTranslateLanguage(languageCode){this.languageSettingsPrivate_.setEnableTranslationForLanguage(languageCode,true)}disableTranslateLanguage(languageCode){this.languageSettingsPrivate_.setEnableTranslationForLanguage(languageCode,false)}setTranslateTargetLanguage(languageCode){this.languageSettingsPrivate_.setTranslateTargetLanguage(languageCode)}toggleSpellCheck(languageCode,enable){if(!this.languages){return}if(enable){this.getPref("spellcheck.dictionaries");this.appendPrefListItem("spellcheck.dictionaries",languageCode)}else{this.deletePrefListItem("spellcheck.dictionaries",languageCode)}}getLanguage(languageCode){if(this.supportedLanguageMap_.has(languageCode)){return this.supportedLanguageMap_.get(languageCode)}const chromeLanguage=convertLanguageCodeForChrome(getBaseLanguage(languageCode));return this.supportedLanguageMap_.get(chromeLanguage)}retryDownloadDictionary(languageCode){this.languageSettingsPrivate_.retryDownloadDictionary(languageCode)}}customElements.define(SettingsLanguagesElement.is,SettingsLanguagesElement);function getTemplate$p(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared">.cr-row-with-template{padding:0}#liveCaptionToggleButton{width:100%}.language-dropdown{margin-inline-start:auto}.subsection-group{padding-bottom:10px}#liveTranslateToggleButton{width:100%}</style>
<div class="cr-row cr-row-with-template">
  <settings-toggle-button id="liveTranslateToggleButton"
      pref="{{prefs.accessibility.captions.live_translate_enabled}}"
      on-change="onLiveTranslateEnabledChange_"
      label="$i18n{captionsEnableLiveTranslateTitle}"
      sub-label="$i18n{captionsEnableLiveTranslateSubtitle}">
  </settings-toggle-button>
</div>
<cr-collapse
    opened="[[prefs.accessibility.captions.live_translate_enabled.value]]">
  <div class="cr-row continuation subsection-group">
    <div class="start cr-padded-text" aria-hidden="true">
        $i18n{captionsLiveTranslateTargetLanguage}
        <div class="secondary">
          $i18n{captionsLiveTranslateTargetLanguageSubtitle}
        </div>
    </div>
    <settings-dropdown-menu id="targetLanguageDropdown"
        class="language-dropdown"
        pref="{{prefs.accessibility.captions.live_translate_target_language}}"
        menu-options="[[translatableLanguages_]]"
        label="$i18n{captionsLiveTranslateTargetLanguage}">
    </settings-dropdown-menu>
  </div>
</cr-collapse>
<!--_html_template_end_-->`}const SettingsLiveTranslateElementBase=WebUiListenerMixin(PrefsMixin(PolymerElement));class SettingsLiveTranslateElement extends SettingsLiveTranslateElementBase{static get is(){return"settings-live-translate"}static get template(){return getTemplate$p()}static get properties(){return{enableLiveTranslateSubtitle_:{type:String,value:loadTimeData.getString("captionsEnableLiveTranslateSubtitle")},languageOptions_:{type:Array,value:()=>[]},translatableLanguages_:{type:Array,value:()=>[]}}}connectedCallback(){super.connectedCallback();const languageHelper=getLanguageHelperInstance();languageHelper.whenReady().then((()=>{this.translatableLanguages_=languageHelper.languages.supported.filter((language=>isTranslateBaseLanguage(language))).map((language=>({value:language.code,name:language.displayName})))}))}onLiveTranslateEnabledChange_(){chrome.metricsPrivate.recordBoolean("Accessibility.LiveTranslate.EnableFromSettings",this.$.liveTranslateToggleButton.checked)}}customElements.define(SettingsLiveTranslateElement.is,SettingsLiveTranslateElement);function getTemplate$o(){return html`<!--_html_template_start_-->    <style include="settings-shared">#dialog-title{align-items:center;display:flex}#dialog-body{display:flex;flex-direction:column;height:350px;overflow:auto;padding-inline-start:0;padding-inline-end:0}settings-checkbox-list-entry::part(checkbox){padding-inline-start:40px}#dialog-title>span,iron-list{flex:1}
    </style>
    <cr-dialog id="dialog" close-text="$i18n{close}">
      <div id="dialog-title" slot="title">
        <span>$i18n{addLanguagesDialogTitle}</span>
        <cr-search-field label="$i18n{searchLanguages}" id="search"
            clear-label="$i18n{clearSearch}"
            on-search-changed="onSearchChanged_"
            on-keydown="onKeydown_" autofocus>
        </cr-search-field>
      </div>
      <div id="dialog-body" slot="body" scrollable>
        <iron-list scroll-target="dialog-body" role="listbox"
            items="[[getLanguages_(filterValue_)]]">
          <template>
            <settings-checkbox-list-entry role="option"
                checked="[[willAdd_(item.code)]]" tabindex="[[tabIndex]]"
                aria-posinset$="[[getAriaPosinset_(index)]]"
                aria-setsize$="[[getLanguagesCount_(filterValue_)]]"
                aria-label="[[i18n('addLanguageAriaLabel', item.displayName)]]"
                on-change="onLanguageCheckboxChange_">
              <div class="text-elide">
                [[getDisplayText_(item)]]
              </div>
            </settings-checkbox-list-entry>
          </template>
        </iron-list>
      </div>
      <div slot="button-container">
        <cr-button class="cancel-button" on-click="onCancelButtonClick_">
          $i18n{cancel}
        </cr-button>
        <cr-button class="action-button" on-click="onActionButtonClick_"
            disabled="[[disableActionButton_]]">
          $i18n{add}
        </cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`}const SettingsAddLanguagesDialogElementBase=ScrollableMixin(FindShortcutMixin(I18nMixin(PolymerElement)));class SettingsAddLanguagesDialogElement extends SettingsAddLanguagesDialogElementBase{static get is(){return"settings-add-languages-dialog"}static get template(){return getTemplate$o()}static get properties(){return{languages:Object,languagesToAdd_:{type:Object,value(){return new Set}},disableActionButton_:{type:Boolean,value:true},filterValue_:{type:String,value:""}}}connectedCallback(){super.connectedCallback();this.$.dialog.showModal()}handleFindShortcut(_modalContextOpen){const searchInput=this.$.search.getSearchInput();searchInput.scrollIntoViewIfNeeded();if(!this.searchInputHasFocus()){searchInput.focus()}return true}searchInputHasFocus(){return this.$.search.getSearchInput()===this.$.search.shadowRoot.activeElement}onSearchChanged_(e){this.filterValue_=e.detail}getLanguages_(){if(!this.filterValue_){return this.languages}const filterValue=this.filterValue_.toLowerCase();return this.languages.filter((language=>language.displayName.toLowerCase().includes(filterValue)||language.nativeDisplayName.toLowerCase().includes(filterValue)))}getLanguagesCount_(){return this.getLanguages_().length}getAriaPosinset_(index){return index+1}getDisplayText_(language){return getFullName(language)}willAdd_(languageCode){return this.languagesToAdd_.has(languageCode)}onLanguageCheckboxChange_(e){const language=e.model.item;if(e.target.checked){this.languagesToAdd_.add(language.code)}else{this.languagesToAdd_.delete(language.code)}this.disableActionButton_=!this.languagesToAdd_.size}onCancelButtonClick_(){this.$.dialog.close()}onActionButtonClick_(){this.dispatchEvent(new CustomEvent("languages-added",{bubbles:true,composed:true,detail:Array.from(this.languagesToAdd_)}));this.$.dialog.close()}onKeydown_(e){if(e.key==="Escape"&&!this.$.search.getValue().trim()){this.$.dialog.close()}else if(e.key!=="PageDown"&&e.key!=="PageUp"){this.$.search.scrollIntoViewIfNeeded()}}}customElements.define(SettingsAddLanguagesDialogElement.is,SettingsAddLanguagesDialogElement);const SettingsLiveCaptionElementBase=WebUiListenerMixin(ListPropertyUpdateMixin(PrefsMixin(I18nMixin(PolymerElement))));class SettingsLiveCaptionElement extends SettingsLiveCaptionElementBase{static get is(){return"settings-live-caption"}static get template(){return getTemplate$q()}static get properties(){return{enableLiveCaptionSubtitle_:{type:String,value:loadTimeData.getString("captionsEnableLiveCaptionSubtitle")},enableLiveCaptionMultiLanguage_:{type:Boolean,value:function(){return loadTimeData.getBoolean("enableLiveCaptionMultiLanguage")}},enableLiveTranslate_:{type:Boolean,value:function(){return loadTimeData.getBoolean("enableLiveTranslate")}},installedLanguagePacks_:{type:Array,value:()=>[]},availableLanguagePacks_:{type:Array,value:()=>[]},detailLanguage_:Object,showAddLanguagesDialog_:Boolean}}browserProxy_=CaptionsBrowserProxyImpl.getInstance();ready(){super.ready();this.browserProxy_.getInstalledLanguagePacks().then((installedLanguagePacks=>{this.installedLanguagePacks_=installedLanguagePacks}));this.browserProxy_.getAvailableLanguagePacks().then((availableLanguagePacks=>{this.availableLanguagePacks_=availableLanguagePacks}));this.addWebUiListener("soda-download-progress-changed",((sodaDownloadProgress,languageCode)=>this.onSodaDownloadProgressChangedForLanguage_(sodaDownloadProgress,languageCode)));this.browserProxy_.liveCaptionSectionReady()}getLiveCaptionToggle(){return this.shadowRoot.querySelector("#liveCaptionToggleButton")}computeMoreButtonAriaLabel_(name,code){let label=this.i18n("moreActionsFor",name);if(this.isDefaultLanguage_(code)){label+=` ${this.i18n("defaultLanguageLabel")}`}return label}onLiveCaptionEnabledChanged_(event){const liveCaptionEnabled=event.target.checked;chrome.metricsPrivate.recordBoolean("Accessibility.LiveCaption.EnableFromSettings",liveCaptionEnabled);if(this.installedLanguagePacks_.length===0){this.installLanguagePacks_([this.getPref("accessibility.captions.live_caption_language").value])}}onLiveCaptionMaskOffensiveWordsChanged_(event){const liveCaptionMaskOffensiveWords=event.target.checked;chrome.metricsPrivate.recordBoolean("Accessibility.LiveCaption.MaskOffensiveWords",liveCaptionMaskOffensiveWords)}onAddLanguagesClick_(e){e.preventDefault();this.showAddLanguagesDialog_=true}onAddLanguagesDialogClose_(){this.showAddLanguagesDialog_=false;const toFocus=this.shadowRoot.querySelector("#addLanguage");assert(toFocus);focusWithoutInk(toFocus)}onDotsClick_(e){this.detailLanguage_=Object.assign({},e.model.item);this.$.menu.get().showAt(e.target)}isDefaultLanguage_(languageCode){if(this.prefs===undefined){return false}return languageCode===this.prefs.accessibility.captions.live_caption_language.value}onMakeDefaultClick_(){this.$.menu.get().close();this.setPrefValue("accessibility.captions.live_caption_language",this.detailLanguage_.code)}onRemoveLanguageClick_(){if(!this.detailLanguage_){return}this.$.menu.get().close();this.installedLanguagePacks_=this.installedLanguagePacks_.filter((languagePack=>languagePack.code!==this.detailLanguage_.code));this.browserProxy_.removeLanguagePack(this.detailLanguage_.code);if(this.installedLanguagePacks_.length===0){this.setPrefValue("accessibility.captions.live_caption_enabled",false);return}if(!this.installedLanguagePacks_.some((languagePack=>languagePack.code===this.getPref("accessibility.captions.live_caption_language").value))){this.setPrefValue("accessibility.captions.live_caption_language",this.installedLanguagePacks_[0].code)}}onLanguagesAdded_(e){this.installLanguagePacks_(e.detail)}installLanguagePacks_(languageCodes){const newLanguagePacks=[];languageCodes.forEach((languageCode=>{const languagePackToAdd=this.availableLanguagePacks_.find((languagePack=>languagePack.code===languageCode));if(languagePackToAdd){newLanguagePacks.push(languagePackToAdd)}}));this.updateList(`installedLanguagePacks_`,(item=>item.code),this.installedLanguagePacks_.concat(newLanguagePacks));this.browserProxy_.installLanguagePacks(languageCodes)}filterAvailableLanguagePacks_(availableLanguagePacks,installedLanguagePacks){const filteredLanguagePacks=availableLanguagePacks.filter((availableLanguagePack=>!installedLanguagePacks.some((installedLanguagePack=>installedLanguagePack.code===availableLanguagePack.code))));return filteredLanguagePacks.map((languagePack=>({code:languagePack.code,displayName:languagePack.displayName,nativeDisplayName:languagePack.nativeDisplayName})))}onSodaDownloadProgressChangedForLanguage_(sodaDownloadProgress,languageCode){if(!this.enableLiveCaptionMultiLanguage_){this.enableLiveCaptionSubtitle_=sodaDownloadProgress;return}for(let i=0;i<this.installedLanguagePacks_.length;i++){const language=this.installedLanguagePacks_[i];if(language.code===languageCode){language.downloadProgress=sodaDownloadProgress;this.notifyPath("installedLanguagePacks_."+i+".downloadProgress");break}}}}customElements.define(SettingsLiveCaptionElement.is,SettingsLiveCaptionElement);var ImportDataStatus;(function(ImportDataStatus){ImportDataStatus["INITIAL"]="initial";ImportDataStatus["IN_PROGRESS"]="inProgress";ImportDataStatus["SUCCEEDED"]="succeeded";ImportDataStatus["FAILED"]="failed"})(ImportDataStatus||(ImportDataStatus={}));class ImportDataBrowserProxyImpl{initializeImportDialog(){return sendWithPromise("initializeImportDialog")}importData(sourceBrowserProfileIndex,types){chrome.send("importData",[sourceBrowserProfileIndex,types])}importFromBookmarksFile(){chrome.send("importFromBookmarksFile")}static getInstance(){return instance$g||(instance$g=new ImportDataBrowserProxyImpl)}static setInstance(obj){instance$g=obj}}let instance$g=null;function getTemplate$n(){return html`<!--_html_template_start_-->    <style include="settings-shared md-select cr-spinner-style">.description{align-items:center;display:flex;margin-top:16px}.spinner{margin:0 8px}#successIcon{fill:var(--cr-checked-color);height:80px;margin:auto;width:100%}.md-select{margin-top:2px}

    </style>
    <cr-dialog id="dialog" close-text="$i18n{close}"
        ignore-popstate>
      <div slot="title">$i18n{importTitle}</div>
      <div slot="body">
        <div hidden$="[[!hasImportStatus_(
            importStatusEnum_.SUCCEEDED, importStatus_)]]">
          <cr-icon id="successIcon" icon="cr:check-circle"></cr-icon>
          <div hidden$="[[!prefs.import_dialog_bookmarks.value]]">
            <div class="description">$i18n{importSuccess}</div>
            <settings-toggle-button
                label="$i18n{showBookmarksBar}"
                pref="{{prefs.bookmark_bar.show_on_all_tabs}}">
            </settings-toggle-button>
          </div>
        </div>

        <div hidden$="[[hasImportStatus_(
              importStatusEnum_.SUCCEEDED, importStatus_)]]">
          <select id="browserSelect" class="md-select"
              aria-label="$i18n{importFromLabel}"
              on-change="onBrowserProfileSelectionChange_">
            <template is="dom-repeat" items="[[browserProfiles_]]">
              <option value="[[item.index]]">
                [[getProfileDisplayName_(item.name, item.profileName)]]
              </option>
            </template>
          </select>
          <div class="description">$i18n{importDescription}</div>

          <!--
            A parent div is needed here to prevent bugs caused by elements
            becoming hidden interfering with NVDA reading out changes to the
            select menu. The checkboxes just need to have a different parent
            than the select menu.
            See https://github.com/nvaccess/nvda/issues/13116.
          -->
          <div>
            <settings-checkbox id="importDialogHistory"
                hidden="[[!selected_.history]]"
                pref="{{prefs.import_dialog_history}}"
                label="$i18n{importHistory}" no-set-pref>
            </settings-checkbox>
            <settings-checkbox id="importDialogBookmarks"
                hidden="[[!selected_.favorites]]"
                pref="{{prefs.import_dialog_bookmarks}}"
                label="$i18n{importFavorites}" no-set-pref>
            </settings-checkbox>
            <settings-checkbox id="importDialogSavedPasswords"
                hidden="[[!selected_.passwords]]"
                pref="{{prefs.import_dialog_saved_passwords}}"
                label="$i18n{importPasswords}" no-set-pref>
            </settings-checkbox>
            <settings-checkbox id="importDialogSearchEngine"
                hidden="[[!selected_.search]]"
                pref="{{prefs.import_dialog_search_engine}}"
                label="$i18n{importSearch}" no-set-pref>
            </settings-checkbox>
            <settings-checkbox id="importDialogAutofillFormData"
                hidden="[[!selected_.autofillFormData]]"
                pref="{{prefs.import_dialog_autofill_form_data}}"
                label="$i18n{importAutofillFormData}" no-set-pref>
            </settings-checkbox>
          </div>
        </div>
      </div>
      <div slot="button-container">
        <div class="spinner" hidden$="[[!hasImportStatus_(
            importStatusEnum_.IN_PROGRESS, importStatus_)]]">
        </div>
        <cr-button id="cancel" class="cancel-button"
            hidden="[[hasImportStatus_(
                importStatusEnum_.SUCCEEDED, importStatus_)]]"
            disabled="[[hasImportStatus_(
                importStatusEnum_.IN_PROGRESS, importStatus_)]]"
            on-click="closeDialog_">
          $i18n{cancel}
        </cr-button>
        <cr-button id="import" class="action-button"
            hidden="[[hasImportStatus_(
                importStatusEnum_.SUCCEEDED, importStatus_)]]"
            disabled="[[shouldDisableImport_(
                importStatus_, noImportDataTypeSelected_)]]"
            on-click="onActionButtonClick_">
          [[getActionButtonText_(selected_)]]
        </cr-button>

        <cr-button id="done" class="action-button"
            hidden$="[[!hasImportStatus_(
                importStatusEnum_.SUCCEEDED, importStatus_)]]"
            on-click="closeDialog_">$i18n{done}</cr-button>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`}const SettingsImportDataDialogElementBase=WebUiListenerMixin(I18nMixin(PrefsMixin(PolymerElement)));class SettingsImportDataDialogElement extends SettingsImportDataDialogElementBase{static get is(){return"settings-import-data-dialog"}static get template(){return getTemplate$n()}static get properties(){return{browserProfiles_:Array,selected_:{type:Object,observer:"updateImportDataTypesSelected_"},noImportDataTypeSelected_:{type:Boolean,value:false},importStatus_:{type:String,value:ImportDataStatus.INITIAL},importStatusEnum_:{type:Object,value:ImportDataStatus}}}browserProxy_=ImportDataBrowserProxyImpl.getInstance();ready(){super.ready();this.addEventListener("settings-boolean-control-change",this.updateImportDataTypesSelected_)}connectedCallback(){super.connectedCallback();this.browserProxy_.initializeImportDialog().then((data=>{if(!this.isConnected){return}this.browserProfiles_=data;this.selected_=this.browserProfiles_[0];this.$.dialog.showModal()}));this.addWebUiListener("import-data-status-changed",(importStatus=>{this.importStatus_=importStatus;if(this.hasImportStatus_(ImportDataStatus.FAILED)){this.closeDialog_()}}))}getProfileDisplayName_(name,profileName){return profileName?`${name} - ${profileName}`:name}updateImportDataTypesSelected_(){const checkboxes=this.shadowRoot.querySelectorAll("settings-checkbox[checked]:not([hidden])");this.noImportDataTypeSelected_=checkboxes.length===0}hasImportStatus_(status){return this.importStatus_===status}isImportFromFileSelected_(){return this.selected_.index===this.browserProfiles_.length-1}getActionButtonText_(){return this.i18n(this.isImportFromFileSelected_()?"importChooseFile":"importCommit")}onBrowserProfileSelectionChange_(){this.selected_=this.browserProfiles_[this.$.browserSelect.selectedIndex]}onActionButtonClick_(){const checkboxes=this.shadowRoot.querySelectorAll("settings-checkbox");if(this.isImportFromFileSelected_()){this.browserProxy_.importFromBookmarksFile()}else{const types={};checkboxes.forEach((checkbox=>{types[checkbox.pref.key]=checkbox.checked&&!checkbox.hidden}));this.browserProxy_.importData(this.$.browserSelect.selectedIndex,types)}checkboxes.forEach((checkbox=>checkbox.sendPrefChange()))}closeDialog_(){this.$.dialog.close()}shouldDisableImport_(){return this.hasImportStatus_(ImportDataStatus.IN_PROGRESS)||this.noImportDataTypeSelected_}}customElements.define(SettingsImportDataDialogElement.is,SettingsImportDataDialogElement);let instance$f=null;function getCss$7(){return instance$f||(instance$f=[...[getCss$d()],css`:host{--cr-localized-link-display:inline;display:block}:host([link-disabled]){cursor:pointer;opacity:var(--cr-disabled-opacity);pointer-events:none}a{display:var(--cr-localized-link-display)}a[href]{color:var(--cr-link-color)}a[is=action-link]{user-select:none}#container{display:contents}`])}function getHtml$7(){return html$1`
<!-- innerHTML is set via setContainerInnerHtml_. -->
<div id="container"></div>`}class LocalizedLinkElement extends CrLitElement{static get is(){return"localized-link"}static get styles(){return getCss$7()}render(){return getHtml$7.bind(this)()}static get properties(){return{localizedString:{type:String},linkUrl:{type:String},linkDisabled:{type:Boolean,reflect:true},containerInnerHTML_:{type:String}}}#localizedString_accessor_storage="";get localizedString(){return this.#localizedString_accessor_storage}set localizedString(value){this.#localizedString_accessor_storage=value}#linkUrl_accessor_storage="";get linkUrl(){return this.#linkUrl_accessor_storage}set linkUrl(value){this.#linkUrl_accessor_storage=value}#linkDisabled_accessor_storage=false;get linkDisabled(){return this.#linkDisabled_accessor_storage}set linkDisabled(value){this.#linkDisabled_accessor_storage=value}#containerInnerHTML__accessor_storage="";get containerInnerHTML_(){return this.#containerInnerHTML__accessor_storage}set containerInnerHTML_(value){this.#containerInnerHTML__accessor_storage=value}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("localizedString")||changedProperties.has("linkUrl")){this.containerInnerHTML_=this.getAriaLabelledContent_(this.localizedString,this.linkUrl)}}updated(changedProperties){super.updated(changedProperties);const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("containerInnerHTML_")){this.setContainerInnerHtml_()}if(changedProperties.has("linkDisabled")){this.updateAnchorTagTabIndex_()}}getAriaLabelledContent_(localizedString,linkUrl){const tempEl=document.createElement("div");tempEl.innerHTML=sanitizeInnerHtml(localizedString,{attrs:["id"]});const ariaLabelledByIds=[];tempEl.childNodes.forEach(((node,index)=>{if(node.nodeType===Node.TEXT_NODE){const spanNode=document.createElement("span");spanNode.textContent=node.textContent;spanNode.id=`id${index}`;ariaLabelledByIds.push(spanNode.id);spanNode.setAttribute("aria-hidden","true");node.replaceWith(spanNode);return}if(node.nodeType===Node.ELEMENT_NODE&&node.nodeName==="A"){const element=node;element.id=`id${index}`;ariaLabelledByIds.push(element.id);return}assertNotReached("localized-link has invalid node types")}));const anchorTags=tempEl.querySelectorAll("a");if(anchorTags.length===0){return localizedString}assert(anchorTags.length===1,"localized-link should contain exactly one anchor tag");const anchorTag=anchorTags[0];anchorTag.setAttribute("aria-labelledby",ariaLabelledByIds.join(" "));anchorTag.tabIndex=this.linkDisabled?-1:0;if(linkUrl!==""){anchorTag.href=linkUrl;anchorTag.target="_blank"}return tempEl.innerHTML}setContainerInnerHtml_(){this.$.container.innerHTML=sanitizeInnerHtml(this.containerInnerHTML_,{attrs:["aria-hidden","aria-labelledby","id","tabindex"]});const anchorTag=this.shadowRoot.querySelector("a");if(anchorTag){anchorTag.addEventListener("click",(event=>this.onAnchorTagClick_(event)));anchorTag.addEventListener("auxclick",(event=>{if(event.button===1){this.onAnchorTagClick_(event)}}))}}onAnchorTagClick_(event){if(this.linkDisabled){event.preventDefault();return}this.fire("link-clicked",{event:event});event.stopPropagation()}updateAnchorTagTabIndex_(){const anchorTag=this.shadowRoot.querySelector("a");if(!anchorTag){return}anchorTag.tabIndex=this.linkDisabled?-1:0}}customElements.define(LocalizedLinkElement.is,LocalizedLinkElement);function getTemplate$m(){return html`<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">#sync-data-types .list-item:not([hidden])~.list-item:not([hidden]){border-top:var(--cr-separator-line)}.list-item{display:flex}.list-item>div:not(.separator){flex:1}cr-policy-indicator{margin-inline-end:var(--cr-controlled-by-spacing)}#toggles-header .cr-row.first h2{padding-top:18px}
    </style>



    <template is="dom-if" if="[[!isAccountSettingsPage_]]" restamp>
      <div id="sync-data-radio" class="cr-row first">
        <cr-radio-group
            selected="[[selectedSyncDataRadio_(syncPrefs)]]"
            on-selected-changed="onSyncDataRadioSelectionChanged_">
          <cr-radio-button name="sync-everything">
            $i18n{syncEverythingCheckboxLabel}
          </cr-radio-button>
          <cr-radio-button name="customize-sync">
            $i18n{customizeSyncLabel}
          </cr-radio-button>
        </cr-radio-group>
      </div>
    </template>


    <div hidden="[[!showSyncDisabledInformation]]">
      <div class="cr-row first">
        <cr-policy-indicator id="syncDisabledIndicator"
            indicator-type="userPolicy">
        </cr-policy-indicator>
        <div class="cr-secondary-text flex">
          $i18n{syncDisabledUserInformation}
        </div>
      </div>
    </div>


    <div class="cr-row first" hidden="[[isAccountSettingsPage_]]">
      <h2 class="cr-title-text flex">$i18n{syncData}</h2>
    </div>

    <div id="toggles-header" hidden="[[!isAccountSettingsPage_]]">
      <div class="cr-row first">
        <h2 class="cr-title-text flex">$i18n{accountDataTypesHeading}</h2>
      </div>
      <div class="cr-row continuation">
        <div class="cr-secondary-text flex">$i18n{accountDataTypesBody}</div>
      </div>
      <div class="cr-row continuation" hidden="[[!shouldShowBatchUploadPromo_(
            batchUploadPromoLocalDataCount_, isAccountSettingsPage_)]]">
        <div class="cr-secondary-text flex" id="batchUploadPromo"
            inner-h-t-m-l="[[getSubtitleString_(batchUploadPromoString_)]]">
        </div>
      </div>
    </div>


    <div class="list-frame" id="sync-data-types">

      <template is="dom-if" if="[[isAccountSettingsPage_]]" restamp>
        <div class="list-item">
          <div>
            <div id="historyTabsCheckboxLabel">
              $i18n{historyTabsCheckboxLabel}
            </div>
            <div class="cr-secondary-text"
                hidden="[[mergedHistoryTabsToggleChecked_(syncPrefs)]]">
              $i18n{historyTabsCheckboxSubLabelOff}
            </div>
          </div>
          <cr-policy-indicator id="mergedHistoryTabsToggleIndicator"
              indicator-type="userPolicy"
              hidden="[[!mergedHistoryTabsTogglePolicyIndicatorShown_(
                  syncStatus, syncPrefs.tabsManaged,
                  syncPrefs.typedUrlsManaged)]]">
          </cr-policy-indicator>
          <cr-toggle id="mergedHistoryTabsToggle"
              checked="[[mergedHistoryTabsToggleChecked_(syncPrefs)]]"
              on-change="onMergedHistoryTabsToggleChanged_"
              disabled="[[mergedHistoryTabsToggleDisabled_(syncStatus,
                  syncPrefs.tabsManaged, syncPrefs.typedUrlsManaged,
                  syncStatus.disabled)]]"
              aria-labelledby="historyTabsCheckboxLabel">
          </cr-toggle>
        </div>
      </template>


      <div hidden="[[isAccountSettingsPage_]]">
        <div class="list-item" hidden="[[!syncPrefs.typedUrlsRegistered]]">
          <div id="historyCheckboxLabel">
            $i18n{historyCheckboxLabel}
          </div>
          <cr-policy-indicator indicator-type="userPolicy"
              hidden="[[!showPolicyIndicator_(syncStatus,
                    syncPrefs.typedUrlsManaged)]]">
          </cr-policy-indicator>
          <cr-toggle id="historyToggle"
              checked="{{syncPrefs.typedUrlsSynced}}"
              on-change="onSingleSyncDataTypeChanged_"
              disabled="[[disableTypeCheckBox_(syncStatus,
                syncPrefs.syncAllDataTypes, syncPrefs.typedUrlsManaged,
                syncStatus.disabled)]]"
              aria-labelledby="historyCheckboxLabel"
              data-type$="[[UserSelectableTypeEnum_.HISTORY]]">
          </cr-toggle>
        </div>
      </div>

      <div class="list-item" hidden="[[!syncPrefs.bookmarksRegistered]]">
        <div id="bookmarksCheckboxLabel">
          $i18n{bookmarksCheckboxLabel}
        </div>
        <cr-policy-indicator indicator-type="userPolicy"
            hidden="[[!showPolicyIndicator_(syncStatus,
                  syncPrefs.bookmarksManaged)]]">
        </cr-policy-indicator>
        <cr-toggle checked="{{syncPrefs.bookmarksSynced}}"
            on-change="onSingleSyncDataTypeChanged_"
            disabled="[[disableTypeCheckBox_(syncStatus,
                syncPrefs.syncAllDataTypes, syncPrefs.bookmarksManaged,
                syncStatus.disabled)]]"
            aria-labelledby="bookmarksCheckboxLabel"
            data-type$="[[UserSelectableTypeEnum_.BOOKMARKS]]">
        </cr-toggle>
      </div>

      <div class="list-item" hidden="[[!syncPrefs.readingListRegistered]]">
        <div id="readingListCheckboxLabel">
          $i18n{readingListCheckboxLabel}
        </div>
        <cr-policy-indicator indicator-type="userPolicy"
            hidden="[[!showPolicyIndicator_(syncStatus,
                  syncPrefs.readingListManaged)]]">
        </cr-policy-indicator>
        <cr-toggle checked="{{syncPrefs.readingListSynced}}"
            on-change="onSingleSyncDataTypeChanged_"
            disabled="[[disableTypeCheckBox_(syncStatus,
                syncPrefs.syncAllDataTypes ,syncPrefs.readingListManaged,
                syncStatus.disabled)]]"
            aria-labelledby="readingListCheckboxLabel"
            data-type$="[[UserSelectableTypeEnum_.READING_LIST]]">
        </cr-toggle>
      </div>

      <div hidden="[[isAccountSettingsPage_]]">
        <div class="list-item" hidden="[[!syncPrefs.tabsRegistered]]">
          <div id="openTabsCheckboxLabel">
            $i18n{openTabsCheckboxLabel}
          </div>
          <cr-policy-indicator indicator-type="userPolicy"
              hidden="[[!showPolicyIndicator_(syncStatus,
                    syncPrefs.tabsManaged)]]">
          </cr-policy-indicator>
          <cr-toggle checked="{{syncPrefs.tabsSynced}}"
              on-change="onSingleSyncDataTypeChanged_"
              disabled="[[disableTypeCheckBox_(syncStatus,
                syncPrefs.syncAllDataTypes,syncPrefs.tabsManaged,
                syncStatus.disabled)]]"
              aria-labelledby="openTabsCheckboxLabel"
              data-type$="[[UserSelectableTypeEnum_.TABS]]">
          </cr-toggle>
        </div>

        <div class="list-item" hidden="[[!syncPrefs.savedTabGroupsRegistered]]">
          <div id="savedTabGroupsCheckboxLabel">
            $i18n{savedTabGroupsCheckboxLabel}
          </div>
          <cr-policy-indicator indicator-type="userPolicy"
              hidden="[[!showPolicyIndicator_(syncStatus,
                    syncPrefs.savedTabGroupsManaged, syncStatus.disabled)]]">
          </cr-policy-indicator>
          <cr-toggle checked="{{syncPrefs.savedTabGroupsSynced}}"
              on-change="onSingleSyncDataTypeChanged_"
              disabled="[[disableTypeCheckBox_(syncStatus,
                syncPrefs.syncAllDataTypes, syncPrefs.savedTabGroupsManaged,
                syncStatus.disabled)]]"
              aria-labelledby="savedTabGroupsCheckboxLabel"
              data-type$="[[UserSelectableTypeEnum_.SAVED_TAB_GROUPS]]">
          </cr-toggle>
        </div>
      </div>

      <div class="list-item" hidden="[[!syncPrefs.autofillRegistered]]">
        <div id="autofillCheckboxLabel">
          $i18n{autofillCheckboxLabel}
        </div>
        <cr-policy-indicator indicator-type="userPolicy"
             hidden="[[!showPolicyIndicator_(syncStatus,
                  syncPrefs.autofillManaged)]]">
         </cr-policy-indicator>
        <cr-toggle id="autofillCheckbox"
            checked="{{syncPrefs.autofillSynced}}"
            on-change="onSingleSyncDataTypeChanged_"
            disabled="[[disableTypeCheckBox_(syncStatus,
              syncPrefs.syncAllDataTypes,syncPrefs.autofillManaged,
              syncStatus.disabled)]]"
            aria-labelledby="autofillCheckboxLabel"
            data-type$="[[UserSelectableTypeEnum_.AUTOFILL]]">
        </cr-toggle>
      </div>

      <div class="list-item"
           hidden="[[!syncPrefs.paymentsRegistered]]">
        <div>
          $i18n{paymentsCheckboxLabel}
        </div>
        <cr-policy-indicator indicator-type="userPolicy"
            hidden="[[!showPolicyIndicator_(syncStatus,
                  syncPrefs.paymentsManaged)]]">
        </cr-policy-indicator>
        <cr-toggle id="paymentsCheckbox"
            checked="{{syncPrefs.paymentsSynced}}"
            on-change="onSingleSyncDataTypeChanged_"
            disabled="[[disableTypeCheckBox_(syncStatus,
                syncPrefs.syncAllDataTypes, syncPrefs.paymentsManaged,
                syncStatus.disabled)]]"
            aria-label="$i18n{paymentsCheckboxLabel}"
            data-type$="[[UserSelectableTypeEnum_.PAYMENTS]]">
        </cr-toggle>
      </div>

      <div class="list-item" hidden="[[!syncPrefs.passwordsRegistered]]">
        <div id="passwordsCheckboxLabel">
          $i18n{passwordsCheckboxLabel}
        </div>
        <cr-policy-indicator indicator-type="userPolicy"
            hidden="[[!showPolicyIndicator_(syncStatus,
                  syncPrefs.passwordsManaged)]]">
        </cr-policy-indicator>
        <cr-toggle checked="{{syncPrefs.passwordsSynced}}"
            on-change="onSingleSyncDataTypeChanged_"
            disabled="[[disableTypeCheckBox_(syncStatus,
              syncPrefs.syncAllDataTypes, syncPrefs.passwordsManaged,
              syncStatus.disabled)]]"
            aria-labelledby="passwordsCheckboxLabel"
            data-type$="[[UserSelectableTypeEnum_.PASSWORDS]]">
        </cr-toggle>
      </div>

      <div class="list-item" hidden="[[!syncPrefs.preferencesRegistered]]">
        <div id="settingsCheckboxLabel">
          $i18n{settingsCheckboxLabel}
        </div>
        <cr-policy-indicator indicator-type="userPolicy"
            hidden="[[!showPolicyIndicator_(syncStatus,
                  syncPrefs.preferencesManaged)]]">
        </cr-policy-indicator>
        <cr-toggle checked="{{syncPrefs.preferencesSynced}}"
            on-change="onSingleSyncDataTypeChanged_"
            disabled="[[disableTypeCheckBox_(syncStatus,
                syncPrefs.syncAllDataTypes, syncPrefs.preferencesManaged,
                syncStatus.disabled)]]"
            aria-labelledby="settingsCheckboxLabel"
            data-type$="[[UserSelectableTypeEnum_.PREFERENCES]]">
        </cr-toggle>
      </div>

      <div class="list-item" hidden="[[!syncPrefs.appsRegistered]]">
        <div id="appCheckboxLabel">$i18n{appCheckboxLabel}</div>
        <cr-policy-indicator indicator-type="userPolicy"
              hidden="[[!showPolicyIndicator_(syncStatus,
                  syncPrefs.appsManaged)]]">
        </cr-policy-indicator>
        <cr-toggle checked="{{syncPrefs.appsSynced}}"
            on-change="onSingleSyncDataTypeChanged_"
            disabled="[[disableTypeCheckBox_(syncStatus,
                syncPrefs.syncAllDataTypes, syncPrefs.appsManaged,
                syncStatus.disabled)]]"
            aria-labelledby="appCheckboxLabel"
            data-type$="[[UserSelectableTypeEnum_.APPS]]">
        </cr-toggle>
      </div>

      <div class="list-item" hidden="[[!syncPrefs.extensionsRegistered]]">
        <div id="extensionsCheckboxLabel">
          $i18n{extensionsCheckboxLabel}
        </div>
        <cr-policy-indicator indicator-type="userPolicy"
            hidden="[[!showPolicyIndicator_(syncStatus,
                  syncPrefs.extensionsManaged)]]">
        </cr-policy-indicator>
        <cr-toggle checked="{{syncPrefs.extensionsSynced}}"
            on-change="onSingleSyncDataTypeChanged_"
            disabled="[[disableTypeCheckBox_(syncStatus,
                syncPrefs.syncAllDataTypes , syncPrefs.extensionsManaged,
                syncStatus.disabled)]]"
            aria-labelledby="extensionsCheckboxLabel"
            data-type$="[[UserSelectableTypeEnum_.EXTENSIONS]]">
        </cr-toggle>
      </div>

      <div class="list-item" hidden="[[!syncPrefs.themesRegistered]]">
        <div id="themeCheckboxLabel">
          $i18n{themeCheckboxLabel}
        </div>
        <cr-policy-indicator indicator-type="userPolicy"
            hidden="[[!showPolicyIndicator_(syncStatus,
                  syncPrefs.themesManaged)]]">
        </cr-policy-indicator>
        <cr-toggle checked="{{syncPrefs.themesSynced}}"
            on-change="onSingleSyncDataTypeChanged_"
            disabled="[[disableTypeCheckBox_(syncStatus,
                syncPrefs.syncAllDataTypes ,syncPrefs.themesManaged,
                syncStatus.disabled)]]"
            aria-labelledby="themeCheckboxLabel"
            data-type$="[[UserSelectableTypeEnum_.THEMES]]">
        </cr-toggle>
      </div>

      <div class="list-item"
           hidden="[[!syncPrefs.productComparisonRegistered]]">
        <div id="productComparisonsCheckboxLabel">
          $i18n{productComparisonsCheckboxLabel}
        </div>
        <cr-policy-indicator indicator-type="userPolicy"
            hidden="[[!showPolicyIndicator_(syncStatus,
                  syncPrefs.productComparisonManaged)]]">
        </cr-policy-indicator>
        <cr-toggle checked="{{syncPrefs.productComparisonSynced}}"
            on-change="onSingleSyncDataTypeChanged_"
            disabled="[[disableTypeCheckBox_(syncStatus,
              syncPrefs.syncAllDataTypes, syncPrefs.productComparisonManaged,
              syncStatus.disabled)]]"
            aria-labelledby="productComparisonsCheckboxLabel"
            data-type$="[[UserSelectableTypeEnum_.PRODUCT_COMPARISON]]">
        </cr-toggle>
      </div>


<!--_html_template_end_-->`}class PageHandlerFactoryPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"batch_upload_promo.mojom.PageHandlerFactory",scope)}}class PageHandlerFactoryRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}createBatchUploadPromoHandler(page,handler){this.proxy.sendMessage(0,PageHandlerFactory_CreateBatchUploadPromoHandler_ParamsSpec.$,null,[page,handler],false)}}class PageHandlerFactory{static get $interfaceName(){return"batch_upload_promo.mojom.PageHandlerFactory"}static getRemote(){let remote=new PageHandlerFactoryRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}class PageHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"batch_upload_promo.mojom.PageHandler",scope)}}class PageHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}getBatchUploadPromoLocalDataCount(){return this.proxy.sendMessage(0,PageHandler_GetBatchUploadPromoLocalDataCount_ParamsSpec.$,PageHandler_GetBatchUploadPromoLocalDataCount_ResponseParamsSpec.$,[],false)}onBatchUploadPromoClicked(){this.proxy.sendMessage(1,PageHandler_OnBatchUploadPromoClicked_ParamsSpec.$,null,[],false)}}class PagePendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"batch_upload_promo.mojom.Page",scope)}}class PageRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}onLocalDataCountChanged(localDataCount){this.proxy.sendMessage(0,Page_OnLocalDataCountChanged_ParamsSpec.$,null,[localDataCount],false)}}class PageCallbackRouter{helper_internal_;$;router_;onLocalDataCountChanged;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.onLocalDataCountChanged=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,Page_OnLocalDataCountChanged_ParamsSpec.$,null,this.onLocalDataCountChanged.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}const PageHandlerFactory_CreateBatchUploadPromoHandler_ParamsSpec={$:{}};const PageHandler_GetBatchUploadPromoLocalDataCount_ParamsSpec={$:{}};const PageHandler_GetBatchUploadPromoLocalDataCount_ResponseParamsSpec={$:{}};const PageHandler_OnBatchUploadPromoClicked_ParamsSpec={$:{}};const Page_OnLocalDataCountChanged_ParamsSpec={$:{}};mojo.internal.Struct(PageHandlerFactory_CreateBatchUploadPromoHandler_ParamsSpec.$,"PageHandlerFactory_CreateBatchUploadPromoHandler_Params",[mojo.internal.StructField("page",0,0,mojo.internal.InterfaceProxy(PageRemote),null,false,0,undefined,undefined),mojo.internal.StructField("handler",8,0,mojo.internal.InterfaceRequest(PageHandlerPendingReceiver),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(PageHandler_GetBatchUploadPromoLocalDataCount_ParamsSpec.$,"PageHandler_GetBatchUploadPromoLocalDataCount_Params",[],[[0,8]]);mojo.internal.Struct(PageHandler_GetBatchUploadPromoLocalDataCount_ResponseParamsSpec.$,"PageHandler_GetBatchUploadPromoLocalDataCount_ResponseParams",[mojo.internal.StructField("localDataCount",0,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(PageHandler_OnBatchUploadPromoClicked_ParamsSpec.$,"PageHandler_OnBatchUploadPromoClicked_Params",[],[[0,8]]);mojo.internal.Struct(Page_OnLocalDataCountChanged_ParamsSpec.$,"Page_OnLocalDataCountChanged_Params",[mojo.internal.StructField("localDataCount",0,0,mojo.internal.Int32,0,false,0,undefined,undefined)],[[0,16]]);let instance$e=null;class BatchUploadPromoProxy{handler;callbackRouter;constructor(handler,callbackRouter){this.handler=handler;this.callbackRouter=callbackRouter}static getInstance(){if(!instance$e){const handler=new PageHandlerRemote;const callbackRouter=new PageCallbackRouter;PageHandlerFactory.getRemote().createBatchUploadPromoHandler(callbackRouter.$.bindNewPipeAndPassRemote(),handler.$.bindNewPipeAndPassReceiver());instance$e=new BatchUploadPromoProxy(handler,callbackRouter)}return instance$e}static setInstance(handler,callbackRouter){instance$e=new BatchUploadPromoProxy(handler,callbackRouter)}}var RadioButtonNames$1;(function(RadioButtonNames){RadioButtonNames["SYNC_EVERYTHING"]="sync-everything";RadioButtonNames["CUSTOMIZE_SYNC"]="customize-sync"})(RadioButtonNames$1||(RadioButtonNames$1={}));const SettingsSyncControlsElementBase=RouteObserverMixin(WebUiListenerMixin(PolymerElement));class SettingsSyncControlsElement extends SettingsSyncControlsElementBase{static get is(){return"settings-sync-controls"}static get template(){return getTemplate$m()}static get properties(){return{hidden:{type:Boolean,value:false,computed:"syncControlsHidden_("+"syncStatus.signedIn, syncStatus.disabled, "+"syncStatus.hasError, isAccountSettingsPage_, "+"syncPrefs.localSyncEnabled)",reflectToAttribute:true},syncPrefs:Object,syncStatus:{type:Object,observer:"syncStatusChanged_"},UserSelectableTypeEnum_:{type:Object,value:UserSelectableType},showSyncDisabledInformation:{type:Boolean,value:false,computed:"computeShowSyncDisabledInformation_(syncStatus.disabled, "+"isAccountSettingsPage_)",reflectToAttribute:true},isAccountSettingsPage_:{type:Boolean,value:false},batchUploadPromoLocalDataCount_:{type:Number,value:0,observer:"batchUploadPromoLocalDataCountChanged_"},batchUploadPromoString_:{type:String,value:"",observer:"attachOpenBatchUploadLinkClick_"}}}syncBrowserProxy_=SyncBrowserProxyImpl.getInstance();cachedSyncPrefs_;constructor(){super();this.cachedSyncPrefs_=null}connectedCallback(){super.connectedCallback();this.addWebUiListener("sync-prefs-changed",this.handleSyncPrefsChanged_.bind(this));if(loadTimeData.getBoolean("unoPhase2FollowUp")){BatchUploadPromoProxy.getInstance().callbackRouter.onLocalDataCountChanged.addListener((batchUploadPromoData=>{this.batchUploadPromoLocalDataCount_=batchUploadPromoData}));BatchUploadPromoProxy.getInstance().handler.getBatchUploadPromoLocalDataCount().then((({localDataCount:localDataCount})=>{this.batchUploadPromoLocalDataCount_=localDataCount}))}const router=Router.getInstance();const currentRoute=router.getCurrentRoute();if(currentRoute===routes.SYNC_ADVANCED){this.syncBrowserProxy_.didNavigateToSyncPage()}if(loadTimeData.getBoolean("replaceSyncPromosWithSignInPromos")&&currentRoute===routes.ACCOUNT){this.isAccountSettingsPage_=true;this.syncBrowserProxy_.didNavigateToAccountSettingsPage()}}handleSyncPrefsChanged_(syncPrefs){this.syncPrefs=syncPrefs}async batchUploadPromoLocalDataCountChanged_(){if(!loadTimeData.getBoolean("unoPhase2FollowUp")){return}if(!this.batchUploadPromoLocalDataCount_){this.batchUploadPromoString_="";return}this.batchUploadPromoString_=await PluralStringProxyImpl.getInstance().getPluralString("batchUploadPromoLabel",this.batchUploadPromoLocalDataCount_)}shouldShowBatchUploadPromo_(){if(!loadTimeData.getBoolean("unoPhase2FollowUp")){return false}if(!this.isAccountSettingsPage_){return false}return this.batchUploadPromoLocalDataCount_!==0}getSubtitleString_(){return sanitizeInnerHtml(this.batchUploadPromoString_,{tags:["a"],attrs:["id"]})}attachOpenBatchUploadLinkClick_(){const element=this.shadowRoot?.querySelector(`#openBatchUploadLink`);if(element!==null&&element!==undefined){element.addEventListener("click",(me=>{this.onPromoClicked_(me)}));const batchUploadElement=this.shadowRoot?.querySelector(`#batchUploadPromo`);element.setAttribute("aria-label",batchUploadElement.textContent)}}onPromoClicked_(event){assert(this.shouldShowBatchUploadPromo_());event.preventDefault();BatchUploadPromoProxy.getInstance().handler.onBatchUploadPromoClicked()}selectedSyncDataRadio_(){return this.syncPrefs.syncAllDataTypes?RadioButtonNames$1.SYNC_EVERYTHING:RadioButtonNames$1.CUSTOMIZE_SYNC}onSyncDataRadioSelectionChanged_(event){const syncAllDataTypes=event.detail.value===RadioButtonNames$1.SYNC_EVERYTHING;const previous=this.syncPrefs.syncAllDataTypes;if(previous!==syncAllDataTypes){this.set("syncPrefs.syncAllDataTypes",syncAllDataTypes);this.handleSyncAllDataTypesChanged_(syncAllDataTypes)}}currentRouteChanged(newRoute,oldRoute){if(!loadTimeData.getBoolean("replaceSyncPromosWithSignInPromos")){return}this.isAccountSettingsPage_=newRoute===routes.ACCOUNT;if(this.isAccountSettingsPage_&&oldRoute!==routes.ACCOUNT){this.syncBrowserProxy_.didNavigateToAccountSettingsPage()}}mergedHistoryTabsToggleDisabled_(syncStatus,tabsManaged,historyManaged){return!syncStatus||syncStatus.disabled||!this.syncPrefs||tabsManaged&&historyManaged}mergedHistoryTabsTogglePolicyIndicatorShown_(syncStatus,tabsManaged,historyManaged){return!!syncStatus&&!syncStatus.disabled&&tabsManaged&&historyManaged}mergedHistoryTabsToggleChecked_(syncPrefs){return syncPrefs.typedUrlsSynced||syncPrefs.tabsSynced||syncPrefs.savedTabGroupsSynced}onMergedHistoryTabsToggleChanged_(event){assert(this.isAccountSettingsPage_);const toggle=event.target;this.syncBrowserProxy_.setSyncDatatype(UserSelectableType.HISTORY,toggle.checked);this.syncBrowserProxy_.setSyncDatatype(UserSelectableType.TABS,toggle.checked);this.syncBrowserProxy_.setSyncDatatype(UserSelectableType.SAVED_TAB_GROUPS,toggle.checked)}handleSyncAllDataTypesChanged_(syncAllDataTypes){if(syncAllDataTypes){this.set("syncPrefs.syncAllDataTypes",true);this.cachedSyncPrefs_={};for(const dataType of syncPrefsIndividualDataTypes){this.cachedSyncPrefs_[dataType]=this.syncPrefs[dataType];this.set(["syncPrefs",dataType],true)}}else if(this.cachedSyncPrefs_){for(const dataType of syncPrefsIndividualDataTypes){this.set(["syncPrefs",dataType],this.cachedSyncPrefs_[dataType])}}chrome.metricsPrivate.recordUserAction(syncAllDataTypes?"Sync_SyncEverything":"Sync_CustomizeSync");this.onSingleSyncDataTypeChanged_()}onSingleSyncDataTypeChanged_(_event){if(this.isAccountSettingsPage_){assert(_event);const toggle=_event?.target;const type=Number(toggle.dataset["type"]);assert(!isNaN(type));this.syncBrowserProxy_.setSyncDatatype(type,toggle.checked);return}assert(this.syncPrefs);this.syncBrowserProxy_.setSyncDatatypes(this.syncPrefs)}disableTypeCheckBox_(syncStatus,syncAllDataTypes,dataTypeManaged){if(!syncStatus){return true}if(dataTypeManaged){return true}if(syncStatus.signedInState===SignedInState.SYNCING){return syncAllDataTypes}return syncStatus.disabled||!this.syncPrefs}showPolicyIndicator_(syncStatus,dataTypeManaged){if(this.isAccountSettingsPage_){return!!syncStatus&&!syncStatus.disabled&&dataTypeManaged}return dataTypeManaged}computeShowSyncDisabledInformation_(syncDisabled){return this.isAccountSettingsPage_&&syncDisabled}syncStatusChanged_(){const router=Router.getInstance();if(router.getCurrentRoute()===routes.SYNC_ADVANCED&&this.syncControlsHidden_()){if(loadTimeData.getBoolean("replaceSyncPromosWithSignInPromos")){router.navigateTo(routes.ACCOUNT);return}router.navigateTo(routes.SYNC)}}syncControlsHidden_(){if(!this.syncStatus){return false}if(this.isAccountSettingsPage_){return!!this.syncStatus.hasError||this.syncStatus.statusAction===StatusAction.ENTER_PASSPHRASE||!!this.syncPrefs&&this.syncPrefs.localSyncEnabled}if(this.syncStatus.signedInState!==SignedInState.SYNCING||this.syncStatus.disabled){return true}return!!this.syncStatus.hasError&&this.syncStatus.statusAction!==StatusAction.ENTER_PASSPHRASE&&this.syncStatus.statusAction!==StatusAction.RETRIEVE_TRUSTED_VAULT_KEYS&&this.syncStatus.statusAction!==StatusAction.CONFIRM_SYNC_SETTINGS}}customElements.define(SettingsSyncControlsElement.is,SettingsSyncControlsElement);function getTemplate$l(){return html`<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">#create-password-box{margin-bottom:1em}#create-password-box .list-item{margin-bottom:var(--cr-form-field-bottom-spacing)}cr-input{--cr-input-width:var(--cr-default-input-max-width)}.passphrase-reset-icon{margin-inline-end:8px}cr-radio-button[name='encrypt-with-passphrase']{align-items:start}
    </style>

    <template is="dom-if" if="[[!syncPrefs.passphraseRequired]]">
      <div id="encryptionRadioGroupContainer" class="list-frame">
        <cr-radio-group
            id="encryptionRadioGroup"
            selected="[[selectedEncryptionRadio_(syncPrefs)]]"
            on-selected-changed="onEncryptionRadioSelectionChanged_"
            disabled$="[[disableEncryptionOptions_]]">
          <cr-radio-button name="encrypt-with-google" class="list-item"
              aria-label="$i18n{encryptWithGoogleCredentialsLabel}">
            $i18n{encryptWithGoogleCredentialsLabel}
          </cr-radio-button>
          <cr-radio-button name="encrypt-with-passphrase"
              class="list-item">
            <span hidden="[[!existingPassphraseLabel]]">
              [[existingPassphraseLabel]]
            </span>
            <span on-click="onLearnMoreClick_"
                hidden="[[existingPassphraseLabel]]">
              $i18nRaw{encryptWithSyncPassphraseLabel}
            </span>
            <template is="dom-if" if="[[creatingNewPassphrase_]]" restamp>
              <div id="create-password-box">
                <div class="list-item">
                  <span>$i18nRaw{passphraseExplanationText}</span>
                </div>
                <cr-input id="passphraseInput" type="password"
                    value="{{passphrase_}}"
                    placeholder="$i18n{passphrasePlaceholder}"
                    error-message="$i18n{emptyPassphraseError}"
                    on-keypress="onNewPassphraseInputKeypress_">
                </cr-input>
                <cr-input id="passphraseConfirmationInput" type="password"
                    value="{{confirmation_}}"
                    placeholder="$i18n{passphraseConfirmationPlaceholder}"
                    error-message="$i18n{mismatchedPassphraseError}"
                    on-keypress="onNewPassphraseInputKeypress_">
                </cr-input>
                <cr-button id="saveNewPassphrase"
                    on-click="onSaveNewPassphraseClick_" class="action-button"
                    disabled="[[!isSaveNewPassphraseEnabled_(
                                  passphrase_, confirmation_)]]">
                  $i18n{save}
                </cr-button>
              </div>
            </template>
          </cr-radio-button>
        </cr-radio-group>
      </div>
    </template>

<!--_html_template_end_-->`}var RadioButtonNames;(function(RadioButtonNames){RadioButtonNames["ENCRYPT_WITH_GOOGLE"]="encrypt-with-google";RadioButtonNames["ENCRYPT_WITH_PASSPHRASE"]="encrypt-with-passphrase"})(RadioButtonNames||(RadioButtonNames={}));class SettingsSyncEncryptionOptionsElement extends PolymerElement{static get is(){return"settings-sync-encryption-options"}static get template(){return getTemplate$l()}static get properties(){return{syncPrefs:{type:Object,notify:true},syncStatus:Object,existingPassphraseLabel:{type:String},creatingNewPassphrase_:{type:Boolean,value:false},passphrase_:{type:String,value:""},confirmation_:{type:String,value:""},disableEncryptionOptions_:{type:Boolean,computed:"computeDisableEncryptionOptions_("+"syncPrefs, syncStatus)",observer:"disableEncryptionOptionsChanged_"}}}isSettingEncryptionPassphrase_;constructor(){super();this.isSettingEncryptionPassphrase_=false}computeDisableEncryptionOptions_(){return!!(this.syncPrefs&&(this.syncPrefs.encryptAllData||!this.syncPrefs.customPassphraseAllowed||this.syncPrefs.trustedVaultKeysRequired)||this.syncStatus&&this.syncStatus.supervisedUser)}disableEncryptionOptionsChanged_(){if(this.disableEncryptionOptions_){this.creatingNewPassphrase_=false}}isSaveNewPassphraseEnabled_(passphrase,confirmation){return passphrase!==""&&confirmation!==""}onNewPassphraseInputKeypress_(e){if(e.type==="keypress"&&e.key!=="Enter"){return}this.saveNewPassphrase_()}onSaveNewPassphraseClick_(){this.saveNewPassphrase_()}saveNewPassphrase_(){assert(this.creatingNewPassphrase_);chrome.metricsPrivate.recordUserAction("Sync_SaveNewPassphraseClicked");if(this.isSettingEncryptionPassphrase_){return}if(!this.validateCreatedPassphrases_()){return}this.isSettingEncryptionPassphrase_=true;SyncBrowserProxyImpl.getInstance().setEncryptionPassphrase(this.passphrase_).then((successfullySet=>{this.dispatchEvent(new CustomEvent("passphrase-changed",{bubbles:true,composed:true,detail:{didChange:successfullySet}}));this.isSettingEncryptionPassphrase_=false}))}onEncryptionRadioSelectionChanged_(event){this.creatingNewPassphrase_=event.detail.value===RadioButtonNames.ENCRYPT_WITH_PASSPHRASE}selectedEncryptionRadio_(){return this.syncPrefs.encryptAllData||this.creatingNewPassphrase_?RadioButtonNames.ENCRYPT_WITH_PASSPHRASE:RadioButtonNames.ENCRYPT_WITH_GOOGLE}validateCreatedPassphrases_(){const emptyPassphrase=!this.passphrase_;const mismatchedPassphrase=this.passphrase_!==this.confirmation_;this.shadowRoot.querySelector("#passphraseInput").invalid=emptyPassphrase;this.shadowRoot.querySelector("#passphraseConfirmationInput").invalid=!emptyPassphrase&&mismatchedPassphrase;return!emptyPassphrase&&!mismatchedPassphrase}onLearnMoreClick_(event){if(event.target.tagName==="A"){event.stopPropagation()}}}customElements.define(SettingsSyncEncryptionOptionsElement.is,SettingsSyncEncryptionOptionsElement);function getTemplate$k(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared">#other-sync-items{padding-bottom:8px}.passphrase-reset-container{display:flex;align-items:flex-start;margin-top:10px}.passphrase-reset-icon{margin-inline-end:8px}cr-link-row{padding-inline-end:0;padding-inline-start:0}cr-collapse>cr-link-row{padding-inline-start:var(--cr-section-indent-padding)}</style>

<settings-subpage page-title="$i18n{accountPageTitle}"
    route-path$="[[routePath]]">

  <template is="dom-if" if="[[shouldShowPageContents_(syncStatus_,
      syncStatus_.signedInState)]]" restamp>

    <!-- Account card -->
    <settings-sync-account-control embedded-in-subpage
        sync-status="[[syncStatus_]]" prefs="{{prefs}}" hide-banner
        access-point="[[accessPointEnum_.SETTINGS]]">
    </settings-sync-account-control>

    <!-- In your Google Account -->
    <settings-sync-controls sync-status="[[syncStatus_]]">
    </settings-sync-controls>

    <!-- Advanced -->
    <div id="sync-section">
      <div class="cr-row first">
        <h2 class="cr-title-text">$i18n{advancedPageTitle}</h2>
      </div>

      <div id="other-sync-items" class="list-frame">

        <!-- Chrome data in your account -->
        <cr-link-row id="syncDashboardLink" class="hr"
            label="$i18n{manageSyncedDataTitle}"
            on-click="onSyncDashboardLinkClick_"
            hidden="[[syncStatus_.supervisedUser]]" external>
        </cr-link-row>

        <!-- Manage your Google Account -->
        <cr-link-row id="manage-google-account" class="hr"
            label="$i18n{manageGoogleAccount}"
            hidden="[[syncStatus.hasError]]"
            on-click="onManageGoogleAccountClicked_" external>
        </cr-link-row>

        <!-- Control how browsing history is used -->
        <template is="dom-if" if="[[!isEeaChoiceCountry_]]">
          <cr-link-row class="hr" id="activityControlsLinkRowV2"
              label="$i18n{personalizeGoogleServicesTitleV2}"
              sub-label="$i18n{personalizeGoogleServicesDesc}"
              on-click="onActivityControlsClick_" external>
          </cr-link-row>
        </template>
        <template is="dom-if" if="[[isEeaChoiceCountry_]]">
          <cr-expand-button class="hr" id="personalizationExpandButton"
              expanded="{{personalizationCollapseExpanded_}}">
            $i18n{personalizeGoogleServicesTitleV2}
            <div class="secondary">
              $i18n{personalizeGoogleServicesDescWithLinkedServices}
            </div>
          </cr-expand-button>
          <cr-collapse id="personalizationCollapse"
              opened="[[personalizationCollapseExpanded_]]">
            <cr-link-row external on-click="onActivityControlsClick_"
                label="$i18n{personalizeGoogleServicesWaaTitle}">
            </cr-link-row>
            <cr-link-row external id="linkedServicesLinkRow"
                on-click="onLinkedServicesClick_"
                label="$i18n{personalizeGoogleServicesLinkedServicesTitle}"
                sub-label=
                    "$i18n{personalizeGoogleServicesLinkedServicesDesc}">
            </cr-link-row>
          </cr-collapse>
        </template>

        <!-- Encryption options -->
        <cr-expand-button id="encryptionDescription"
            hidden="[[syncPrefs.passphraseRequired]]"
            expanded="{{encryptionExpanded_}}"
            class="hr">
          $i18n{encryptionOptionsTitle}
          <div class="secondary">
            $i18n{syncDataEncryptedText}
            <div on-click="onResetSyncClick_"
                hidden="[[!syncPrefs.encryptAllData]]"
                class="passphrase-reset-container">
              <cr-icon icon="cr:info-outline"
                  class="passphrase-reset-icon">
              </cr-icon>
              <span>$i18nRaw{passphraseResetHintEncryption}</span>
            </div>
          </div>
        </cr-expand-button>

        <cr-collapse id="encryptionCollapse"
            opened="[[encryptionExpanded_]]">
          <settings-sync-encryption-options
              sync-status="[[syncStatus_]]" sync-prefs="{{syncPrefs}}"
              existing-passphrase-label="[[existingPassphraseLabel_]]">
          </settings-sync-encryption-options>
        </cr-collapse>

      </div>
    </div>

  </template>

</settings-subpage>
<!--_html_template_end_-->`}const SettingsAccountPageElementBase=SettingsViewMixin(WebUiListenerMixin(I18nMixin(PolymerElement)));class SettingsAccountPageElement extends SettingsAccountPageElementBase{static get is(){return"settings-account-page"}static get template(){return getTemplate$k()}static get properties(){return{syncStatus_:{type:Object},syncPrefs:Object,isEeaChoiceCountry_:{type:Boolean,value(){return loadTimeData.getBoolean("isEeaChoiceCountry")}},personalizationCollapseExpanded_:{type:Boolean,value:false},existingPassphraseLabel_:{type:String,computed:"computeExistingPassphraseLabel_(syncPrefs.encryptAllData,"+"syncPrefs.explicitPassphraseTime)"},dataEncrypted_:{type:Boolean,computed:"computeDataEncrypted_(syncPrefs.encryptAllData)"},encryptionExpanded_:{type:Boolean,value:false},accessPointEnum_:{type:Object,value:ChromeSigninAccessPoint}}}static get observers(){return["expandEncryptionIfNeeded_(dataEncrypted_)"]}syncBrowserProxy_=SyncBrowserProxyImpl.getInstance();connectedCallback(){super.connectedCallback();assert(loadTimeData.getBoolean("replaceSyncPromosWithSignInPromos"));this.syncBrowserProxy_.getSyncStatus().then(this.onSyncStatusChanged_.bind(this));this.addWebUiListener("sync-status-changed",this.onSyncStatusChanged_.bind(this));this.addWebUiListener("sync-prefs-changed",this.onSyncPrefsChanged_.bind(this))}onSyncStatusChanged_(syncStatus){this.syncStatus_=syncStatus;if(Router.getInstance().getCurrentRoute()!==routes.ACCOUNT){return}if(!this.shouldShowPageContents_()){Router.getInstance().navigateTo(routes.PEOPLE)}}onSyncPrefsChanged_(syncPrefs){this.syncPrefs=syncPrefs}onActivityControlsClick_(){this.syncBrowserProxy_.openActivityControlsUrl();OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("activityControlsUrl"))}onLinkedServicesClick_(){OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("linkedServicesUrl"))}onSyncDashboardLinkClick_(){OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("syncDashboardUrl"))}onResetSyncClick_(event){if(event.target.tagName==="A"){event.stopPropagation()}}onManageGoogleAccountClicked_(){OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("googleAccountUrl"))}computeExistingPassphraseLabel_(){if(!this.syncPrefs||!this.syncPrefs.encryptAllData){return window.trustedTypes.emptyHTML}if(!this.syncPrefs.explicitPassphraseTime){return this.i18nAdvanced("existingPassphraseLabel")}return this.i18nAdvanced("existingPassphraseLabelWithDate",{substitutions:[this.syncPrefs.explicitPassphraseTime]})}computeDataEncrypted_(){return!!this.syncPrefs&&this.syncPrefs.encryptAllData}expandEncryptionIfNeeded_(){this.encryptionExpanded_=this.dataEncrypted_}shouldShowPageContents_(){return this.syncStatus_&&this.syncStatus_.signedInState===SignedInState.SIGNED_IN}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsAccountPageElement.is,SettingsAccountPageElement);function getTemplate$j(){return html`<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">.delete-profile-warning{padding-bottom:10px;padding-inline-end:var(--cr-section-padding);padding-inline-start:calc(var(--cr-section-padding) + 32px);padding-top:10px}#wideFooter{padding:0}#dialog-body{padding-bottom:2px}
    </style>

    <cr-dialog id="dialog" ignore-enter-key close-text="$i18n{close}">
      <div slot="title">$i18n{syncDisconnectTitle}</div>
      <div id="dialog-body" slot="body">
        <div inner-h-t-m-l="[[
            getDisconnectExplanationHtml_(syncStatus.domain)]]">
        </div>
      </div>
      <div slot="button-container">
        <cr-button id="disconnectCancel" class="cancel-button"
            on-click="onDisconnectCancel_">
          $i18n{cancel}
        </cr-button>
        <cr-button id="disconnectConfirm" class="action-button"
            on-click="onDisconnectConfirm_">
          $i18n{syncDisconnect}
        </cr-button>
      </div>

      <div id="wideFooter" slot="footer">
        <div class="cr-row first">
          <cr-checkbox id="deleteProfile" class="flex"
              checked="{{deleteProfile_}}">
            $i18n{syncDisconnectDeleteProfile}
          </cr-checkbox>
          <cr-expand-button
              no-hover
              expanded="{{deleteProfileWarningVisible_}}"
              aria-label="$i18n{deleteProfileWarningExpandA11yLabel}">
          </cr-expand-button>
        </div>
        <cr-collapse opened="[[deleteProfileWarningVisible_]]">
          <div class="delete-profile-warning">
            [[deleteProfileWarning_]]
          </div>
        </cr-collapse>
      </div>

    </cr-dialog>
<!--_html_template_end_-->`}const SettingsSignoutDialogElementBase=WebUiListenerMixin(PolymerElement);class SettingsSignoutDialogElement extends SettingsSignoutDialogElementBase{static get is(){return"settings-signout-dialog"}static get template(){return getTemplate$j()}static get properties(){return{syncStatus:{type:Object,observer:"syncStatusChanged_"},deleteProfile_:Boolean,deleteProfileWarningVisible_:Boolean,deleteProfileWarning_:String}}connectedCallback(){super.connectedCallback();this.addWebUiListener("profile-stats-count-ready",this.handleProfileStatsCount_.bind(this));ProfileInfoBrowserProxyImpl.getInstance().getProfileStatsCount();microTask.run((()=>{this.$.dialog.showModal()}))}wasConfirmed(){return this.$.dialog.getNative().returnValue==="success"}handleProfileStatsCount_(count){const username=this.syncStatus.signedInUsername||"";if(count===0){this.deleteProfileWarning_=loadTimeData.getStringF("deleteProfileWarningWithoutCounts",username)}else if(count===1){this.deleteProfileWarning_=loadTimeData.getStringF("deleteProfileWarningWithCountsSingular",username)}else{this.deleteProfileWarning_=loadTimeData.getStringF("deleteProfileWarningWithCountsPlural",count,username)}}syncStatusChanged_(){if(!!this.syncStatus&&this.syncStatus.signedInState!==SignedInState.SYNCING&&this.$.dialog.open){this.$.dialog.close()}}getDisconnectExplanationHtml_(domain){if(domain){return sanitizeInnerHtml(loadTimeData.getStringF("syncDisconnectManagedProfileExplanation",`<span>${domain}</span>`))}return sanitizeInnerHtml(loadTimeData.getString("syncDisconnectExplanation"))}onDisconnectCancel_(){this.$.dialog.cancel()}onDisconnectConfirm_(){this.$.dialog.close();SyncBrowserProxyImpl.getInstance().signOut(this.deleteProfile_)}}customElements.define(SettingsSignoutDialogElement.is,SettingsSignoutDialogElement);function getTemplate$i(){return html`<!--_html_template_start_-->    <style include="settings-shared md-select">:host(.list-frame) settings-toggle-button{padding-inline-end:0;padding-inline-start:0}:host(.list-frame) cr-link-row{padding-inline-end:8px;padding-inline-start:0}.hr:not(.hr:not([hidden])~*){border-top:0}#chromeSigninUserChoiceSetting{padding:var(--settings-signin-choice-padding,10px 0px 10px)}#labelWrapper{margin-inline-end:20px}

    </style>


    <div id="chromeSigninUserChoiceSetting" class="hr cr-row" role="group"
        hidden="[[!chromeSigninUserChoiceInfo_.shouldShowSettings]]"
        aria-label="$i18n{chromeSigninChoiceTitle}">
      <div id="labelWrapper" class="flex">
          <div>
            $i18n{chromeSigninChoiceTitle}
          </div>
          <div id="chromeSigninChoiceDescription" class="secondary">
            [[i18n('chromeSigninChoiceDescription',
                chromeSigninUserChoiceInfo_.signedInEmail)]]
          </div>
      </div>
      <select id="chromeSigninUserChoiceSelection" class="md-select"
          on-change="onChromeSigninChoiceSelectionChanged_">
          <option selected disabled hidden
              value="[[chromeSigninUserChoiceEnum_.NO_CHOICE]]">
            $i18n{chromeSigninChoiceSelectOptionPlaceholder}
          </option>
          <option value="[[chromeSigninUserChoiceEnum_.SIGNIN]]">
            $i18n{chromeSigninChoiceSignin}
          </option>
          <option value="[[chromeSigninUserChoiceEnum_.DO_NOT_SIGNIN]]">
            $i18n{chromeSigninChoiceDoNotSignin}
          </option>
          <option value="[[chromeSigninUserChoiceEnum_.ALWAYS_ASK]]">
            $i18n{chromeSigninChoiceAlwaysAsk}
          </option>
      </select>
    </div>
    <settings-toggle-button id="signinAllowedToggle"
        class="hr"
        hidden="[[!signinAvailable_]]"
        disabled="[[syncFirstSetupInProgress_]]"
        pref="{{prefs.signin.allowed_on_next_startup}}"
        label="$i18n{signinAllowedTitle}"
        sub-label="$i18n{signinAllowedDescription}"
        on-settings-boolean-control-change="onSigninAllowedChange_"
        no-set-pref>
    </settings-toggle-button>
<!-- not chromeos -->
<!-- _google_chrome -->
    <settings-toggle-button id="urlCollectionToggle"
        class="hr"
        pref="{{prefs.url_keyed_anonymized_data_collection.enabled}}"
        label="$i18n{urlKeyedAnonymizedDataCollection}"
        sub-label="$i18n{urlKeyedAnonymizedDataCollectionDesc}">
    </settings-toggle-button>
<!-- _google_chrome -->
    <template is="dom-if" if="[[showSearchSuggestToggle_()]]" restamp>
      <settings-toggle-button id="searchSuggestToggle"
          class="hr"
          pref="{{prefs.search.suggest_enabled}}"
          label="$i18n{searchSuggestPref}"
          sub-label="$i18n{searchSuggestPrefDesc}">
      </settings-toggle-button>
    </template>

    <!-- This toggle is only shown for users with the appropriate enterprise
        policy enabled. The state is not changeable by the user, so when shown,
        it is alays selected but disabled. -->
    <template is="dom-if" if="[[showSearchAggregatorSuggest_]]" restamp>
      <settings-toggle-button id="searchAggregatorSuggestToggle"
          pref="[[searchAggregatorSuggestFakePref_]]"
          disabled
          class="hr"
          label="$i18n{searchAggregatorSuggestPref}"
          sub-label="$i18n{searchAggregatorSuggestPrefDesc}">
      </settings-toggle-button>
    </template>

    <template is="dom-if" if="[[showPriceEmailNotificationsToggle_(
        syncStatus, syncStatus.signedInState)]]" restamp>
      <settings-toggle-button id="priceEmailNotificationsToggle"
          class="hr"
          label="$i18n{priceEmailNotificationsPref}"
          sub-label="[[getPriceEmailNotificationsPrefDesc_(syncStatus)]]"
          pref="{{prefs.price_tracking.email_notifications_enabled}}">
      </settings-toggle-button>
    </template>

    <template is="dom-if" if="[[showSignoutDialog_]]" restamp>
      <settings-signout-dialog sync-status="[[syncStatus]]"
          on-close="onSignoutDialogClosed_">
      </settings-signout-dialog>
    </template>


    <cr-toast id="toast">
      <div>$i18n{restartToApplyChanges}</div>
      <cr-button on-click="onRestartClick_">$i18n{restart}</cr-button>
    </cr-toast>

    <template is="dom-if" if="[[shouldShowRelaunchDialog]]" restamp>
      <relaunch-confirmation-dialog restart-type="[[restartTypeEnum.RESTART]]"
          on-close="onRelaunchDialogClose"></relaunch-confirmation-dialog>
    </template>
    <cr-toast id="chromeSigninUserChoiceToast" duration="5000">
      <div>$i18n{chromeSigninChoiceToast}</div>
    </cr-toast>

<!--_html_template_end_-->`}const SettingsPersonalizationOptionsElementBase=HelpBubbleMixin(RelaunchMixin(WebUiListenerMixin(I18nMixin(PrefsMixin(PolymerElement)))));const ANONYMIZED_URL_COLLECTION_ID="kAnonymizedUrlCollectionPersonalizationSettingId";class SettingsPersonalizationOptionsElement extends SettingsPersonalizationOptionsElementBase{static get is(){return"settings-personalization-options"}static get template(){return getTemplate$i()}static get properties(){return{syncStatus:Object,showSearchAggregatorSuggest_:{type:Boolean,value:()=>loadTimeData.getBoolean("showSearchAggregatorSuggest")},searchAggregatorSuggestFakePref_:{type:Object,value(){return{key:"enterprise_search_aggregator_settings.fake_pref",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:true,enforcement:chrome.settingsPrivate.Enforcement.ENFORCED,controlledBy:chrome.settingsPrivate.ControlledBy.USER_POLICY}}},showSignoutDialog_:Boolean,syncFirstSetupInProgress_:{type:Boolean,value:false,computed:"computeSyncFirstSetupInProgress_(syncStatus)"},signinAvailable_:{type:Boolean,value:()=>loadTimeData.getBoolean("signinAvailable")},chromeSigninUserChoiceInfo_:{type:Object,value:null},chromeSigninUserChoiceEnum_:{type:Object,value:ChromeSigninUserChoice}}}browserProxy_=PrivacyPageBrowserProxyImpl.getInstance();syncBrowserProxy_=SyncBrowserProxyImpl.getInstance();computeSyncFirstSetupInProgress_(){return!!this.syncStatus&&!!this.syncStatus.firstSetupInProgress}showPriceEmailNotificationsToggle_(){if(!loadTimeData.getBoolean("changePriceEmailNotificationsEnabled")||!this.syncStatus){return false}if(loadTimeData.getBoolean("replaceSyncPromosWithSignInPromos")&&this.syncStatus.signedInState===SignedInState.SIGNED_IN){return true}return this.syncStatus.signedInState===SignedInState.SYNCING}getPriceEmailNotificationsPrefDesc_(){const username=this.syncStatus.signedInUsername||"";return loadTimeData.getStringF("priceEmailNotificationsPrefDesc",username)}ready(){super.ready();this.syncBrowserProxy_.getChromeSigninUserChoiceInfo().then(this.setChromeSigninUserChoiceInfo_.bind(this));this.addWebUiListener("chrome-signin-user-choice-info-change",this.setChromeSigninUserChoiceInfo_.bind(this));this.registerHelpBubble(ANONYMIZED_URL_COLLECTION_ID,this.$.urlCollectionToggle.getBubbleAnchor(),{anchorPaddingTop:10})}showSearchSuggestToggle_(){if(pageVisibility?.privacy===undefined){return true}return pageVisibility.privacy.searchPrediction}onSigninAllowedChange_(){if(this.syncStatus.signedInState===SignedInState.SYNCING&&!this.$.signinAllowedToggle.checked){this.$.signinAllowedToggle.checked=true;this.showSignoutDialog_=true}else{this.$.signinAllowedToggle.sendPrefChange();this.$.toast.show()}}onSignoutDialogClosed_(){if(this.shadowRoot.querySelector("settings-signout-dialog").wasConfirmed()){this.$.signinAllowedToggle.checked=false;this.$.signinAllowedToggle.sendPrefChange();this.$.toast.show()}this.showSignoutDialog_=false}onRestartClick_(e){e.stopPropagation();this.performRestart(RestartType.RESTART)}setChromeSigninUserChoiceInfo_(info){this.chromeSigninUserChoiceInfo_=info;if(info.choice!==ChromeSigninUserChoice.NO_CHOICE){this.$.chromeSigninUserChoiceSelection.value=info.choice.toString()}}onChromeSigninChoiceSelectionChanged_(){const selected=Number(this.$.chromeSigninUserChoiceSelection.value);assert(selected!==ChromeSigninUserChoice.NO_CHOICE);this.$.chromeSigninUserChoiceToast.show();this.syncBrowserProxy_.setChromeSigninUserChoice(selected,this.chromeSigninUserChoiceInfo_.signedInEmail)}}customElements.define(SettingsPersonalizationOptionsElement.is,SettingsPersonalizationOptionsElement);function getTemplate$h(){return html`<!--_html_template_start_--><style>settings-personalization-options{--settings-signin-choice-padding:0px 20px 10px}</style>

<settings-subpage page-title="$i18n{googleServicesPageTitle}"
    route-path$="[[routePath]]">
  <template is="dom-if" if="[[shouldShowPageContents_(syncStatus_,
      syncStatus_.signedInState)]]" restamp>
    <settings-personalization-options prefs="{{prefs}}"
        sync-status="[[syncStatus_]]">
    </settings-personalization-options>
  </template>
</settings-subpage>
<!--_html_template_end_-->`}const SettingsGoogleServicesPageElementBase=SettingsViewMixin(WebUiListenerMixin(PolymerElement));class SettingsGoogleServicesPageElement extends SettingsGoogleServicesPageElementBase{static get is(){return"settings-google-services-page"}static get template(){return getTemplate$h()}static get properties(){return{syncStatus_:{type:Object}}}connectedCallback(){super.connectedCallback();assert(loadTimeData.getBoolean("replaceSyncPromosWithSignInPromos"));SyncBrowserProxyImpl.getInstance().getSyncStatus().then(this.onSyncStatusChanged_.bind(this));this.addWebUiListener("sync-status-changed",this.onSyncStatusChanged_.bind(this))}onSyncStatusChanged_(syncStatus){this.syncStatus_=syncStatus;if(Router.getInstance().getCurrentRoute()!==routes.GOOGLE_SERVICES){return}if(!this.shouldShowPageContents_()){Router.getInstance().navigateTo(routes.PEOPLE)}}shouldShowPageContents_(){return this.syncStatus_&&this.syncStatus_.signedInState!==SignedInState.SYNCING}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsGoogleServicesPageElement.is,SettingsGoogleServicesPageElement);let instance$d=null;function getCss$6(){return instance$d||(instance$d=[...[getCss$e()],css`dialog{background:var(--color-theme-color-picker-hue-slider-dialog-background,var(--cr-fallback-color-surface));border:0;border-radius:12px;box-shadow:var(--cr-elevation-3);box-sizing:border-box;color:var(--color-theme-color-picker-hue-slider-dialog-foreground,var(--cr-fallback-color-on-surface));height:137px;overflow:hidden;margin:0;padding:0;width:296px}@media (forced-colors:active){dialog{border:solid 1px Highlight}}#contentsWrapper{padding:20px}#header{display:flex;align-items:center;height:24px;gap:8px}h2{flex:1;font-size:16px;font-weight:500;margin:0}cr-icon-button{color:var(--color-theme-color-picker-hue-slider-dialog-icon,var(--cr-fallback-color-on-surface-subtle));margin-inline-end:-6px}cr-slider{--cr-slider-active-color:transparent;--cr-slider-ripple-color:var(--cr-active-background-color);--cr-slider-ripple-opacity:0;--cr-slider-ripple-size:40px;--cr-slider-ripple-z-index:0;display:block;height:40px;margin-block-start:21px;margin-block-end:12px;padding:0;width:100%}@media (forced-colors:active){cr-slider{--cr-slider-ripple-color:Highlight;forced-color-adjust:none}}cr-slider:focus-visible::part(knob)::after{box-shadow:0 0 0 4px var(--cr-focus-outline-color)}@media (forced-colors:active){cr-slider:focus-visible::part(knob)::after{outline:var(--cr-focus-outline-hcm) !important}}cr-slider::part(container){background:linear-gradient(to right,var(--hue-gradient_));border-radius:4px;border:0;height:8px}:host-context([dir=rtl]) cr-slider::part(container){background:linear-gradient(to left,var(--hue-gradient_))}cr-slider::part(knob){background:transparent;box-shadow:none;margin-block-start:4px}cr-slider::part(knob)::after{display:block;position:absolute;content:'';box-sizing:border-box;top:50%;left:50%;width:32px;height:32px;background:hsl(var(--knob-hue_),100%,50%);border:solid 4px var(--color-theme-color-picker-hue-slider-handle,white);border-radius:50%;box-shadow:var(--cr-elevation-1);transform:translate(-50%,-50%);z-index:1}`])}function getHtml$6(){return html$1`
<dialog id="dialog">
  <div id="contentsWrapper">
    <div id="header">
      <h2 id="title">${this.i18n("hueSliderTitle")}</h2>
      <slot name="headerSuffix"></slot>
      <cr-icon-button id="close" class="icon-clear"
          aria-label="${this.i18n("close")}"
          title="${this.i18n("close")}"
          @click="${this.hide}">
      </cr-icon-button>
    </div>
    <cr-slider id="slider" .min="${this.minHue_}" .max="${this.maxHue_}"
        .value="${this.selectedHue}"
        @cr-slider-value-changed="${this.onCrSliderValueChanged_}"
        @pointerup="${this.updateSelectedHueValue_}"
        @keyup="${this.updateSelectedHueValue_}"
        .style="--hue-gradient_: ${this.hueGradient_}; --knob-hue_: ${this.knobHue_}"
        aria-label="${this.i18n("hueSliderAriaLabel",this.minHue_,this.maxHue_)}">
    </cr-slider>
  </div>
</dialog>`}const minHue=0;const maxHue=359;function computeHueGradient(){const hueDivisions=6;const hueGradientParts=[];for(let i=0;i<=hueDivisions;i++){const percentage=i/hueDivisions;const hsl=`hsl(${minHue+(maxHue-minHue)*percentage}, 100%, 50%)`;hueGradientParts.push(`${hsl} ${percentage*100}%`)}return hueGradientParts.join(",")}const ThemeHueSliderDialogElementBase=I18nMixinLit(CrLitElement);class ThemeHueSliderDialogElement extends ThemeHueSliderDialogElementBase{static get is(){return"cr-theme-hue-slider-dialog"}static get styles(){return getCss$6()}render(){return getHtml$6.bind(this)()}static get properties(){return{hueGradient_:{type:String,state:true},maxHue_:{type:Number,state:true},minHue_:{type:Number,state:true},selectedHue:{type:Number},knobHue_:{type:Number,state:true}}}#hueGradient__accessor_storage=computeHueGradient();get hueGradient_(){return this.#hueGradient__accessor_storage}set hueGradient_(value){this.#hueGradient__accessor_storage=value}#maxHue__accessor_storage=maxHue;get maxHue_(){return this.#maxHue__accessor_storage}set maxHue_(value){this.#maxHue__accessor_storage=value}#minHue__accessor_storage=minHue;get minHue_(){return this.#minHue__accessor_storage}set minHue_(value){this.#minHue__accessor_storage=value}#selectedHue_accessor_storage=minHue;get selectedHue(){return this.#selectedHue_accessor_storage}set selectedHue(value){this.#selectedHue_accessor_storage=value}#knobHue__accessor_storage=minHue;get knobHue_(){return this.#knobHue__accessor_storage}set knobHue_(value){this.#knobHue__accessor_storage=value}eventTracker_=new EventTracker;willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("selectedHue")){this.knobHue_=this.selectedHue}}onCrSliderValueChanged_(){this.knobHue_=this.$.slider.value}showAt(anchor){this.$.dialog.showModal();const anchorBoundingClientRect=anchor.getBoundingClientRect();this.$.dialog.style.left=`${anchorBoundingClientRect.right-this.$.dialog.offsetWidth}px`;if(anchorBoundingClientRect.bottom+this.$.dialog.offsetHeight>=window.innerHeight){this.$.dialog.style.top=`${anchorBoundingClientRect.top-this.$.dialog.offsetHeight}px`}else{this.$.dialog.style.top=`${anchorBoundingClientRect.bottom}px`}this.eventTracker_.add(this.$.dialog,"pointerdown",this.onPointerdown_.bind(this))}hide(){this.$.dialog.close();this.eventTracker_.removeAll()}onPointerdown_(e){if(e.button!==0||e.composedPath()[0]!==this.$.dialog){return}this.hide()}updateSelectedHueValue_(){this.selectedHue=this.$.slider.value;this.fire("selected-hue-changed",{selectedHue:this.selectedHue})}}customElements.define(ThemeHueSliderDialogElement.is,ThemeHueSliderDialogElement);let instance$c=null;function getCss$5(){return instance$c||(instance$c=[...[],css`:host{--cr-theme-color-check-mark-wrapper-background:var(--color-theme-color-picker-checkmark-background,var(--cr-fallback-color-primary));--cr-theme-color-check-mark-wrapper-color:var(--color-theme-color-picker-checkmark-foreground,var(--cr-fallback-color-on-primary));--cr-theme-color-check-mark-wrapper-end:-3px;--cr-theme-color-check-mark-wrapper-size:20px;--cr-theme-color-check-mark-wrapper-top:-3px;display:block;position:relative}svg{display:block;height:var(--cr-theme-color-check-mark-wrapper-size);left:initial;position:absolute;right:var(--cr-theme-color-check-mark-wrapper-end);top:var(--cr-theme-color-check-mark-wrapper-top);width:var(--cr-theme-color-check-mark-wrapper-size);z-index:1}:host(:not([checked])) svg{display:none}:host-context([dir=rtl]) svg{left:var(--cr-theme-color-check-mark-wrapper-end);right:initial}#background{fill:var(--cr-theme-color-check-mark-wrapper-background)}#checkMark{fill:var(--cr-theme-color-check-mark-wrapper-color)}`])}function getHtml$5(){return html$1`
<svg id="svg" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 48 48">
  <circle id="background" cx="24" cy="24" r="24"></circle>
  <path id="checkMark" d="M20 34 10 24l2.83-2.83L20 28.34l15.17-15.17L38 16Z">
  </path>
</svg>
<slot></slot>`}class CheckMarkWrapperElement extends CrLitElement{static get is(){return"cr-theme-color-check-mark-wrapper"}static get styles(){return getCss$5()}render(){return getHtml$5.bind(this)()}static get properties(){return{checked:{type:Boolean,reflect:true}}}#checked_accessor_storage=false;get checked(){return this.#checked_accessor_storage}set checked(value){this.#checked_accessor_storage=value}}customElements.define(CheckMarkWrapperElement.is,CheckMarkWrapperElement);function skColorToRgba(skColor){const a=skColor.value>>24&255;const r=skColor.value>>16&255;const g=skColor.value>>8&255;const b=skColor.value&255;return`rgba(${r}, ${g}, ${b}, ${(a/255).toFixed(2)})`}let instance$b=null;function getCss$4(){return instance$b||(instance$b=[...[],css`:host{--cr-theme-color-border-radius:50%;box-sizing:border-box;cursor:pointer;display:block;outline:none;padding:8px;width:100%}:host(:focus):host-context(.focus-outline-visible){box-shadow:0 0 0 2px var(--cr-focus-outline-color)}svg{border-radius:var(--cr-theme-color-border-radius);box-sizing:border-box;display:block;width:100%}#background{fill:var(--cr-theme-color-background-color)}#foreground{fill:var(--cr-theme-color-foreground-color)}#base{fill:var(--cr-theme-color-base-color)}:host([background-color-hidden]) #background{display:none}:host([background-color-hidden]) #base{display:none}@media (forced-colors:active){:host(:focus):host-context(.focus-outline-visible){outline:var(--cr-focus-outline-hcm) !important}}`])}function getHtml$4(){return html$1`
<cr-theme-color-check-mark-wrapper .checked="${this.checked}">
  <svg viewBox="0 0 50 50" xmlns="http://www.w3.org/2000/svg"
      xmlns:xlink="http://www.w3.org/1999/xlink">
    <rect id="foreground" x="0" y="0" width="50" height="50">
    </rect>
    <rect id="background" x="0" y="25" width="50" height="25">
    </rect>
    <rect id="base" x="25" y="25" width="25" height="25">
    </rect>
  </svg>
  <slot></slot>
</cr-theme-color-check-mark-wrapper>`}class ThemeColorElement extends CrLitElement{static get is(){return"cr-theme-color"}static get styles(){return getCss$4()}render(){return getHtml$4.bind(this)()}static get properties(){return{backgroundColor:{type:Object},foregroundColor:{type:Object},baseColor:{type:Object},checked:{type:Boolean,reflect:true},backgroundColorHidden:{type:Boolean,reflect:true}}}#backgroundColor_accessor_storage={value:0};get backgroundColor(){return this.#backgroundColor_accessor_storage}set backgroundColor(value){this.#backgroundColor_accessor_storage=value}#foregroundColor_accessor_storage={value:0};get foregroundColor(){return this.#foregroundColor_accessor_storage}set foregroundColor(value){this.#foregroundColor_accessor_storage=value}#baseColor_accessor_storage={value:0};get baseColor(){return this.#baseColor_accessor_storage}set baseColor(value){this.#baseColor_accessor_storage=value}#checked_accessor_storage=false;get checked(){return this.#checked_accessor_storage}set checked(value){this.#checked_accessor_storage=value}#backgroundColorHidden_accessor_storage=false;get backgroundColorHidden(){return this.#backgroundColorHidden_accessor_storage}set backgroundColorHidden(value){this.#backgroundColorHidden_accessor_storage=value}connectedCallback(){super.connectedCallback();FocusOutlineManager.forDocument(document)}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("foregroundColor")){this.style.setProperty("--cr-theme-color-foreground-color",skColorToRgba(this.foregroundColor))}if(changedProperties.has("foregroundColor")){this.style.setProperty("--cr-theme-color-background-color",skColorToRgba(this.backgroundColor))}if(changedProperties.has("baseColor")){this.style.setProperty("--cr-theme-color-base-color",skColorToRgba(this.baseColor))}}}customElements.define(ThemeColorElement.is,ThemeColorElement);let instance$a=null;function getCss$3(){return instance$a||(instance$a=[...[],css`:host{--cr-grid-gap:0px;--cr-column-width:auto;--cr-grid-width:fit-content}#grid{display:grid;grid-gap:var(--cr-grid-gap);grid-template-columns:repeat(var(--cr-grid-columns),var(--cr-column-width));width:var(--cr-grid-width)}::slotted(*){align-self:center;justify-self:center}`])}function getHtml$3(){return html$1`
<div id="grid" @keydown="${this.onKeyDown_}">
  <slot id="items"></slot>
</div>`}class CrGridElement extends CrLitElement{static get is(){return"cr-grid"}static get styles(){return getCss$3()}render(){return getHtml$3.bind(this)()}static get properties(){return{columns:{type:Number},disableArrowNavigation:{type:Boolean},focusSelector:{type:String},ignoreModifiedKeyEvents:{type:Boolean}}}#columns_accessor_storage=1;get columns(){return this.#columns_accessor_storage}set columns(value){this.#columns_accessor_storage=value}#disableArrowNavigation_accessor_storage=false;get disableArrowNavigation(){return this.#disableArrowNavigation_accessor_storage}set disableArrowNavigation(value){this.#disableArrowNavigation_accessor_storage=value}#focusSelector_accessor_storage;get focusSelector(){return this.#focusSelector_accessor_storage}set focusSelector(value){this.#focusSelector_accessor_storage=value}#ignoreModifiedKeyEvents_accessor_storage=false;get ignoreModifiedKeyEvents(){return this.#ignoreModifiedKeyEvents_accessor_storage}set ignoreModifiedKeyEvents(value){this.#ignoreModifiedKeyEvents_accessor_storage=value}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("columns")){this.style.setProperty("--cr-grid-columns",String(this.columns))}}getSlottedParent_(element){let parent=element;while(parent.assignedSlot!==this.$.items&&parent.parentElement!==null){parent=parent.parentElement}assert(parent);return parent}onKeyDown_(e){if(!this.disableArrowNavigation&&["ArrowLeft","ArrowRight","ArrowUp","ArrowDown"].includes(e.key)){const items=this.$.items.assignedElements().filter((el=>!!(el.offsetWidth||el.offsetHeight||el.getClientRects().length)));const currentIndex=items.indexOf(this.getSlottedParent_(e.target));const isRtl=window.getComputedStyle(this)["direction"]==="rtl";const bottomRowColumns=items.length%this.columns;const direction=["ArrowRight","ArrowDown"].includes(e.key)?1:-1;const inEdgeRow=direction===1?currentIndex>=items.length-bottomRowColumns:currentIndex<this.columns;let delta=0;switch(e.key){case"ArrowLeft":case"ArrowRight":if(this.ignoreModifiedKeyEvents&&hasKeyModifiers(e)){return}delta=direction*(isRtl?-1:1);break;case"ArrowUp":case"ArrowDown":delta=direction*(inEdgeRow?bottomRowColumns:this.columns);break}if(e.key==="ArrowUp"&&inEdgeRow&&currentIndex>=bottomRowColumns){delta-=this.columns}else if(e.key==="ArrowDown"&&!inEdgeRow&&currentIndex+delta>=items.length){delta+=bottomRowColumns}e.preventDefault();const newIndex=(items.length+currentIndex+delta)%items.length;const item=items[newIndex];const toFocus=this.focusSelector?item.querySelector(this.focusSelector):item;assert(toFocus);toFocus.focus();this.fire("cr-grid-focus-changed",toFocus)}if(["Enter"," "].includes(e.key)){e.preventDefault();e.stopPropagation();e.target.click()}}}customElements.define(CrGridElement.is,CrGridElement);const BrowserColorVariantSpec={$:mojo.internal.Enum()};var BrowserColorVariant;(function(BrowserColorVariant){BrowserColorVariant[BrowserColorVariant["MIN_VALUE"]=0]="MIN_VALUE";BrowserColorVariant[BrowserColorVariant["MAX_VALUE"]=4]="MAX_VALUE";BrowserColorVariant[BrowserColorVariant["kSystem"]=0]="kSystem";BrowserColorVariant[BrowserColorVariant["kTonalSpot"]=1]="kTonalSpot";BrowserColorVariant[BrowserColorVariant["kNeutral"]=2]="kNeutral";BrowserColorVariant[BrowserColorVariant["kVibrant"]=3]="kVibrant";BrowserColorVariant[BrowserColorVariant["kExpressive"]=4]="kExpressive"})(BrowserColorVariant||(BrowserColorVariant={}));class ThemeColorPickerHandlerFactoryPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"theme_color_picker.mojom.ThemeColorPickerHandlerFactory",scope)}}class ThemeColorPickerHandlerFactoryRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(ThemeColorPickerHandlerFactoryPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}createThemeColorPickerHandler(handler,client){this.proxy.sendMessage(0,ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_ParamsSpec.$,null,[handler,client],false)}}class ThemeColorPickerHandlerFactory{static get $interfaceName(){return"theme_color_picker.mojom.ThemeColorPickerHandlerFactory"}static getRemote(){let remote=new ThemeColorPickerHandlerFactoryRemote;remote.$.bindNewPipeAndPassReceiver().bindInBrowser();return remote}}class ThemeColorPickerHandlerPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"theme_color_picker.mojom.ThemeColorPickerHandler",scope)}}class ThemeColorPickerHandlerRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(ThemeColorPickerHandlerPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}getChromeColors(isDarkMode){return this.proxy.sendMessage(0,ThemeColorPickerHandler_GetChromeColors_ParamsSpec.$,ThemeColorPickerHandler_GetChromeColors_ResponseParamsSpec.$,[isDarkMode],false)}updateTheme(){this.proxy.sendMessage(1,ThemeColorPickerHandler_UpdateTheme_ParamsSpec.$,null,[],false)}setDefaultColor(){this.proxy.sendMessage(2,ThemeColorPickerHandler_SetDefaultColor_ParamsSpec.$,null,[],false)}setGreyDefaultColor(){this.proxy.sendMessage(3,ThemeColorPickerHandler_SetGreyDefaultColor_ParamsSpec.$,null,[],false)}setSeedColor(seedColor,variant){this.proxy.sendMessage(4,ThemeColorPickerHandler_SetSeedColor_ParamsSpec.$,null,[seedColor,variant],false)}setSeedColorFromHue(hue){this.proxy.sendMessage(5,ThemeColorPickerHandler_SetSeedColorFromHue_ParamsSpec.$,null,[hue],false)}removeBackgroundImage(){this.proxy.sendMessage(6,ThemeColorPickerHandler_RemoveBackgroundImage_ParamsSpec.$,null,[],false)}}class ThemeColorPickerClientPendingReceiver{handle;constructor(handle){this.handle=mojo.internal.interfaceSupport.getEndpointForReceiver(handle)}bindInBrowser(scope="context"){mojo.internal.interfaceSupport.bind(this.handle,"theme_color_picker.mojom.ThemeColorPickerClient",scope)}}class ThemeColorPickerClientRemote{proxy;$;onConnectionError;constructor(handle){this.proxy=new mojo.internal.interfaceSupport.InterfaceRemoteBase(ThemeColorPickerClientPendingReceiver,handle);this.$=new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);this.onConnectionError=this.proxy.getConnectionErrorEventRouter()}setTheme(theme){this.proxy.sendMessage(0,ThemeColorPickerClient_SetTheme_ParamsSpec.$,null,[theme],false)}}class ThemeColorPickerClientCallbackRouter{helper_internal_;$;router_;setTheme;onConnectionError;constructor(){this.helper_internal_=new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(ThemeColorPickerClientRemote);this.$=new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);this.router_=new mojo.internal.interfaceSupport.CallbackRouter;this.setTheme=new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);this.helper_internal_.registerHandler(0,ThemeColorPickerClient_SetTheme_ParamsSpec.$,null,this.setTheme.createReceiverHandler(false),false);this.onConnectionError=this.helper_internal_.getConnectionErrorEventRouter()}removeListener(id){return this.router_.removeListener(id)}}const ThemeSpec={$:{}};const ChromeColorSpec={$:{}};const ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_ParamsSpec={$:{}};const ThemeColorPickerHandler_GetChromeColors_ParamsSpec={$:{}};const ThemeColorPickerHandler_GetChromeColors_ResponseParamsSpec={$:{}};const ThemeColorPickerHandler_UpdateTheme_ParamsSpec={$:{}};const ThemeColorPickerHandler_SetDefaultColor_ParamsSpec={$:{}};const ThemeColorPickerHandler_SetGreyDefaultColor_ParamsSpec={$:{}};const ThemeColorPickerHandler_SetSeedColor_ParamsSpec={$:{}};const ThemeColorPickerHandler_SetSeedColorFromHue_ParamsSpec={$:{}};const ThemeColorPickerHandler_RemoveBackgroundImage_ParamsSpec={$:{}};const ThemeColorPickerClient_SetTheme_ParamsSpec={$:{}};mojo.internal.Struct(ThemeSpec.$,"Theme",[mojo.internal.StructField("hasBackgroundImage",0,0,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("hasThirdPartyTheme",0,1,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("backgroundImageMainColor",8,0,SkColorSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("isDarkMode",0,2,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("seedColor",16,0,SkColorSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("seedColorHue",4,0,mojo.internal.Float,0,false,0,undefined,undefined),mojo.internal.StructField("backgroundColor",24,0,SkColorSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("foregroundColor",32,0,SkColorSpec.$,null,true,0,undefined,undefined),mojo.internal.StructField("colorPickerIconColor",40,0,SkColorSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("colorsManagedByPolicy",0,3,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("isGreyBaseline",0,4,mojo.internal.Bool,false,false,0,undefined,undefined),mojo.internal.StructField("browserColorVariant",48,0,BrowserColorVariantSpec.$,0,false,0,undefined,undefined),mojo.internal.StructField("followDeviceTheme",0,5,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,64]]);mojo.internal.Struct(ChromeColorSpec.$,"ChromeColor",[mojo.internal.StructField("name",0,0,mojo.internal.String,null,false,0,undefined,undefined),mojo.internal.StructField("seed",8,0,SkColorSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("background",16,0,SkColorSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("foreground",24,0,SkColorSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("base",32,0,SkColorSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("variant",40,0,BrowserColorVariantSpec.$,0,false,0,undefined,undefined)],[[0,56]]);mojo.internal.Struct(ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_ParamsSpec.$,"ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_Params",[mojo.internal.StructField("handler",0,0,mojo.internal.InterfaceRequest(ThemeColorPickerHandlerPendingReceiver),null,false,0,undefined,undefined),mojo.internal.StructField("client",4,0,mojo.internal.InterfaceProxy(ThemeColorPickerClientRemote),null,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(ThemeColorPickerHandler_GetChromeColors_ParamsSpec.$,"ThemeColorPickerHandler_GetChromeColors_Params",[mojo.internal.StructField("isDarkMode",0,0,mojo.internal.Bool,false,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ThemeColorPickerHandler_GetChromeColors_ResponseParamsSpec.$,"ThemeColorPickerHandler_GetChromeColors_ResponseParams",[mojo.internal.StructField("colors",0,0,mojo.internal.Array(ChromeColorSpec.$,false),null,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ThemeColorPickerHandler_UpdateTheme_ParamsSpec.$,"ThemeColorPickerHandler_UpdateTheme_Params",[],[[0,8]]);mojo.internal.Struct(ThemeColorPickerHandler_SetDefaultColor_ParamsSpec.$,"ThemeColorPickerHandler_SetDefaultColor_Params",[],[[0,8]]);mojo.internal.Struct(ThemeColorPickerHandler_SetGreyDefaultColor_ParamsSpec.$,"ThemeColorPickerHandler_SetGreyDefaultColor_Params",[],[[0,8]]);mojo.internal.Struct(ThemeColorPickerHandler_SetSeedColor_ParamsSpec.$,"ThemeColorPickerHandler_SetSeedColor_Params",[mojo.internal.StructField("seedColor",0,0,SkColorSpec.$,null,false,0,undefined,undefined),mojo.internal.StructField("variant",8,0,BrowserColorVariantSpec.$,0,false,0,undefined,undefined)],[[0,24]]);mojo.internal.Struct(ThemeColorPickerHandler_SetSeedColorFromHue_ParamsSpec.$,"ThemeColorPickerHandler_SetSeedColorFromHue_Params",[mojo.internal.StructField("hue",0,0,mojo.internal.Float,0,false,0,undefined,undefined)],[[0,16]]);mojo.internal.Struct(ThemeColorPickerHandler_RemoveBackgroundImage_ParamsSpec.$,"ThemeColorPickerHandler_RemoveBackgroundImage_Params",[],[[0,8]]);mojo.internal.Struct(ThemeColorPickerClient_SetTheme_ParamsSpec.$,"ThemeColorPickerClient_SetTheme_Params",[mojo.internal.StructField("theme",0,0,ThemeSpec.$,null,false,0,undefined,undefined)],[[0,16]]);let instance$9=null;class ThemeColorPickerBrowserProxy{handler;callbackRouter;constructor(handler,callbackRouter){this.handler=handler;this.callbackRouter=callbackRouter}static getInstance(){if(!instance$9){const handler=new ThemeColorPickerHandlerRemote;const callbackRouter=new ThemeColorPickerClientCallbackRouter;ThemeColorPickerHandlerFactory.getRemote().createThemeColorPickerHandler(handler.$.bindNewPipeAndPassReceiver(),callbackRouter.$.bindNewPipeAndPassRemote());instance$9=new ThemeColorPickerBrowserProxy(handler,callbackRouter)}return instance$9}static setInstance(handler,callbackRouter){instance$9=new ThemeColorPickerBrowserProxy(handler,callbackRouter)}}const EMPTY_COLOR={background:{value:0},foreground:{value:0},base:{value:0}};const LIGHT_BASELINE_BLUE_COLOR={background:{value:4278933456},foreground:{value:4292076541},base:{value:4291282887}};const DARK_BASELINE_BLUE_COLOR={background:{value:4289251322},foreground:{value:4278731424},base:{value:4285887861}};const LIGHT_BASELINE_GREY_COLOR={background:{value:4278933456},foreground:{value:4293125091},base:{value:4291282887}};const DARK_BASELINE_GREY_COLOR={background:{value:4289251322},foreground:{value:4282861383},base:{value:4285887861}};var ColorType;(function(ColorType){ColorType[ColorType["NONE"]=0]="NONE";ColorType[ColorType["DEFAULT"]=1]="DEFAULT";ColorType[ColorType["MAIN"]=2]="MAIN";ColorType[ColorType["CHROME"]=3]="CHROME";ColorType[ColorType["CUSTOM"]=4]="CUSTOM";ColorType[ColorType["GREY"]=5]="GREY"})(ColorType||(ColorType={}));let instance$8=null;function getCss$2(){return instance$8||(instance$8=[...[],css`:host{--cr-theme-color-padding:8px;--cr-theme-color-picker-column-width:1fr;--cr-theme-color-picker-grid-gap:8px;--cr-theme-color-picker-grid-padding:0 16px}cr-grid{--cr-column-width:var(--cr-theme-color-picker-column-width);--cr-grid-gap:var(--cr-theme-color-picker-grid-gap);box-sizing:border-box;display:block;padding:var(--cr-theme-color-picker-grid-padding);width:100%}#colorPickerIcon{-webkit-mask-image:url(chrome://resources/images/colorize.svg);-webkit-mask-repeat:no-repeat;-webkit-mask-size:100%;background-color:var(--color-theme-color-picker-custom-color-icon-background,var(--cr-fallback-color-on-surface-subtle));height:20px;left:calc(50% - 10px);pointer-events:none;position:absolute;top:calc(50% - 10px);width:20px}managed-dialog{--cr-dialog-width:min(calc(100% - 32px),512px)}cr-theme-color{background-color:var(--color-theme-color-picker-option-background,var(--cr-fallback-color-neutral-container));border-radius:12px;padding:var(--cr-theme-color-padding)}`])}function getHtml$2(){return html$1`
<!-- TODO(crbug.com/40881996): Make grid adaptive. -->
<cr-grid columns="${this.columns}" role="radiogroup"
    aria-label="${this.i18n("colorsContainerLabel")}">
  <cr-theme-color
      id="defaultColor"
      .backgroundColor="${this.defaultColor_.background}"
      .baseColor="${this.defaultColor_.base}"
      .foregroundColor="${this.defaultColor_.foreground}"
      title="${this.i18n("defaultColorName")}"
      aria-label="${this.i18n("defaultColorName")}"
      role="radio"
      ?checked="${this.isDefaultColorSelected_}"
      aria-checked="${this.isDefaultColorSelected_}"
      tabindex="${this.tabIndex_(this.isDefaultColorSelected_)}"
      @click="${this.onDefaultColorClick_}">
  </cr-theme-color>
  <cr-theme-color
      id="greyDefaultColor"
      .backgroundColor="${this.greyDefaultColor_.background}"
      .baseColor="${this.greyDefaultColor_.base}"
      .foregroundColor="${this.greyDefaultColor_.foreground}"
      title="${this.i18n("greyDefaultColorName")}"
      aria-label="${this.i18n("greyDefaultColorName")}"
      role="radio"
      ?checked="${this.isGreyDefaultColorSelected_}"
      aria-checked="${this.isGreyDefaultColorSelected_}"
      tabindex="${this.tabIndex_(this.isGreyDefaultColorSelected_)}"
      @click="${this.onGreyDefaultColorClick_}">
  </cr-theme-color>
  ${this.colors_.map(((item,index)=>html$1`
    <cr-theme-color
        class="chrome-color"
        .backgroundColor="${item.background}"
        .baseColor="${item.base}"
        .foregroundColor="${item.foreground}"
        title="${item.name}"
        aria-label="${item.name}"
        role="radio"
        ?checked="${this.isChromeColorSelected_(item.seed,item.variant)}"
        aria-checked=
            "${this.isChromeColorSelected_(item.seed,item.variant)}"
        tabindex="${this.chromeColorTabIndex_(item.seed,item.variant)}"
        data-index="${index}"
        @click="${this.onChromeColorClick_}">
    </cr-theme-color>
  `))}
    <cr-theme-color
        id="customColor"
        .backgroundColor="${this.customColor_.background}"
        .foregroundColor="${this.customColor_.foreground}"
        background-color-hidden
        title="${this.i18n("colorPickerLabel")}"
        aria-label="${this.i18n("colorPickerLabel")}"
        role="radio"
        tabindex="${this.tabIndex_(this.isCustomColorSelected_)}"
        @click="${this.onCustomColorClick_}"
        aria-checked="${this.isCustomColorSelected_}"
        ?checked="${this.isCustomColorSelected_}">
        <div id="colorPickerIcon"></div>
    </cr-theme-color>
</cr-grid>

<cr-theme-hue-slider-dialog id="hueSlider"
    @selected-hue-changed="${this.onSelectedHueChanged_}">
</cr-theme-hue-slider-dialog>

${this.showManagedDialog_?html$1`
  <managed-dialog @close="${this.onManagedDialogClosed_}"
      title="${this.i18n("managedColorsTitle")}"
      body="${this.i18n("managedColorsBody")}">
  </managed-dialog>
`:""}`}const ThemeColorPickerElementBase=I18nMixinLit(CrLitElement);class ThemeColorPickerElement extends ThemeColorPickerElementBase{static get is(){return"cr-theme-color-picker"}static get styles(){return getCss$2()}render(){return getHtml$2.bind(this)()}static get properties(){return{defaultColor_:{type:Object,state:true},greyDefaultColor_:{type:Object,state:true},colors_:{type:Array,state:true},theme_:{type:Object,state:true},selectedColor_:{type:Object,state:true},isDefaultColorSelected_:{type:Boolean,state:true},isGreyDefaultColorSelected_:{type:Boolean,state:true},isCustomColorSelected_:{type:Boolean,state:true},customColor_:{type:Object,state:true},showManagedDialog_:{type:Boolean,state:true},columns:{type:Number}}}#defaultColor__accessor_storage=EMPTY_COLOR;get defaultColor_(){return this.#defaultColor__accessor_storage}set defaultColor_(value){this.#defaultColor__accessor_storage=value}#greyDefaultColor__accessor_storage=EMPTY_COLOR;get greyDefaultColor_(){return this.#greyDefaultColor__accessor_storage}set greyDefaultColor_(value){this.#greyDefaultColor__accessor_storage=value}#colors__accessor_storage=[];get colors_(){return this.#colors__accessor_storage}set colors_(value){this.#colors__accessor_storage=value}#theme__accessor_storage;get theme_(){return this.#theme__accessor_storage}set theme_(value){this.#theme__accessor_storage=value}#selectedColor__accessor_storage={type:ColorType.NONE};get selectedColor_(){return this.#selectedColor__accessor_storage}set selectedColor_(value){this.#selectedColor__accessor_storage=value}#isDefaultColorSelected__accessor_storage=false;get isDefaultColorSelected_(){return this.#isDefaultColorSelected__accessor_storage}set isDefaultColorSelected_(value){this.#isDefaultColorSelected__accessor_storage=value}#isGreyDefaultColorSelected__accessor_storage=false;get isGreyDefaultColorSelected_(){return this.#isGreyDefaultColorSelected__accessor_storage}set isGreyDefaultColorSelected_(value){this.#isGreyDefaultColorSelected__accessor_storage=value}#isCustomColorSelected__accessor_storage=false;get isCustomColorSelected_(){return this.#isCustomColorSelected__accessor_storage}set isCustomColorSelected_(value){this.#isCustomColorSelected__accessor_storage=value}#customColor__accessor_storage=EMPTY_COLOR;get customColor_(){return this.#customColor__accessor_storage}set customColor_(value){this.#customColor__accessor_storage=value}setThemeListenerId_=null;#showManagedDialog__accessor_storage=false;get showManagedDialog_(){return this.#showManagedDialog__accessor_storage}set showManagedDialog_(value){this.#showManagedDialog__accessor_storage=value}#columns_accessor_storage=4;get columns(){return this.#columns_accessor_storage}set columns(value){this.#columns_accessor_storage=value}handler_=ThemeColorPickerBrowserProxy.getInstance().handler;connectedCallback(){super.connectedCallback();this.setThemeListenerId_=ThemeColorPickerBrowserProxy.getInstance().callbackRouter.setTheme.addListener((theme=>{this.theme_=theme}));this.handler_.updateTheme()}disconnectedCallback(){super.disconnectedCallback();ThemeColorPickerBrowserProxy.getInstance().callbackRouter.removeListener(this.setThemeListenerId_)}willUpdate(changedProperties){super.willUpdate(changedProperties);const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("theme_")){this.defaultColor_=this.computeDefaultColor_();this.greyDefaultColor_=this.computeGreyDefaultColor_();this.updateColors_()}if(changedPrivateProperties.has("theme_")||changedPrivateProperties.has("colors_")){this.selectedColor_=this.computeSelectedColor_()}if(changedPrivateProperties.has("selectedColor_")){this.isDefaultColorSelected_=this.computeIsDefaultColorSelected_();this.isGreyDefaultColorSelected_=this.computeIsGreyDefaultColorSelected_();this.isCustomColorSelected_=this.computeIsCustomColorSelected_()}}updated(changedProperties){super.updated(changedProperties);const changedPrivateProperties=changedProperties;if(changedPrivateProperties.has("colors_")||changedPrivateProperties.has("theme_")||changedPrivateProperties.has("isCustomColorSelected_")){this.updateCustomColor_()}}computeDefaultColor_(){assert(this.theme_);return this.theme_.isDarkMode?DARK_BASELINE_BLUE_COLOR:LIGHT_BASELINE_BLUE_COLOR}computeGreyDefaultColor_(){assert(this.theme_);return this.theme_.isDarkMode?DARK_BASELINE_GREY_COLOR:LIGHT_BASELINE_GREY_COLOR}computeSelectedColor_(){if(!this.colors_||!this.theme_){return{type:ColorType.NONE}}if(this.theme_.isGreyBaseline){return{type:ColorType.GREY}}if(!this.theme_.foregroundColor){return{type:ColorType.DEFAULT}}if(this.theme_.backgroundImageMainColor&&this.theme_.backgroundImageMainColor.value===this.theme_.seedColor.value){return{type:ColorType.CUSTOM}}if(this.colors_.find((color=>color.seed.value===this.theme_.seedColor.value&&color.variant===this.theme_.browserColorVariant))){return{type:ColorType.CHROME,chromeColor:this.theme_.seedColor,variant:this.theme_.browserColorVariant}}return{type:ColorType.CUSTOM}}computeIsDefaultColorSelected_(){return this.selectedColor_.type===ColorType.DEFAULT}computeIsGreyDefaultColorSelected_(){return this.selectedColor_.type===ColorType.GREY}computeIsCustomColorSelected_(){return this.selectedColor_.type===ColorType.CUSTOM}isChromeColorSelected_(color,variant){return this.selectedColor_.type===ColorType.CHROME&&this.selectedColor_.chromeColor.value===color.value&&this.selectedColor_.variant===variant}chromeColorTabIndex_(color,variant){return this.selectedColor_.type===ColorType.CHROME&&this.selectedColor_.chromeColor.value===color.value&&this.selectedColor_.variant===variant?"0":"-1"}tabIndex_(selected){return selected?"0":"-1"}onDefaultColorClick_(){if(this.handleClickForManagedColors_()){return}this.handler_.setDefaultColor()}onGreyDefaultColorClick_(){if(this.handleClickForManagedColors_()){return}this.handler_.setGreyDefaultColor()}onChromeColorClick_(e){if(this.handleClickForManagedColors_()){return}const index=Number.parseInt(e.target.dataset["index"],10);const color=this.colors_[index];this.handler_.setSeedColor(color.seed,color.variant)}onCustomColorClick_(){if(this.handleClickForManagedColors_()){return}this.$.hueSlider.showAt(this.$.colorPickerIcon)}onSelectedHueChanged_(){const selectedHue=this.$.hueSlider.selectedHue;if(this.theme_&&this.theme_.seedColorHue===selectedHue){return}ThemeColorPickerBrowserProxy.getInstance().handler.setSeedColorFromHue(selectedHue)}updateCustomColor_(){if(!this.isCustomColorSelected_){return}assert(this.theme_);this.customColor_={background:this.theme_.backgroundColor,foreground:this.theme_.foregroundColor,base:{value:0}};this.$.colorPickerIcon.style.setProperty("background-color",skColorToRgba(this.theme_.colorPickerIconColor));this.$.hueSlider.selectedHue=this.theme_.seedColorHue}async updateColors_(){assert(this.theme_);this.colors_=(await this.handler_.getChromeColors(this.theme_.isDarkMode)).colors}onManagedDialogClosed_(){this.showManagedDialog_=false}handleClickForManagedColors_(){if(!this.theme_||!this.theme_.colorsManagedByPolicy){return false}this.showManagedDialog_=true;return true}}customElements.define(ThemeColorPickerElement.is,ThemeColorPickerElement);let instance$7=null;function getCss$1(){return instance$7||(instance$7=[...[getCss$d()],css`:host{--avatar-size:96px;--avatar-spacing:24px;--selected-border:4px;display:inline-flex}#avatar-grid{--cr-column-width:var(--avatar-size);--cr-grid-gap:var(--avatar-spacing)}#avatar-grid .avatar-container{position:relative}#avatar-grid .avatar{--avatar-focus-color:var(--google-grey-700);--avatar-gap-color:white;--avatar-gap-width:2px;--avatar-selected-color:rgba(var(--google-blue-600-rgb),0.4);background-position:center;background-repeat:no-repeat;border:1px solid var(--google-grey-300);border-radius:100%;display:flex;height:var(--avatar-size);min-width:0;padding:0;transition:none !important;width:var(--avatar-size)}#avatar-grid .iron-selected .avatar{--avatar-outline-color:var(--avatar-selected-color);--avatar-outline-width:var(--selected-border);outline:var(--avatar-outline-width) solid var(--avatar-outline-color)}.checkmark{--checkmark-size:21px;--iron-icon-fill-color:white;background-color:var(--google-blue-600);border-radius:100%;height:var(--checkmark-size);inset-inline-end:0;padding:1px;position:absolute;top:0;visibility:hidden;width:var(--checkmark-size)}.iron-selected .checkmark{visibility:visible}@media (prefers-color-scheme:dark){#avatar-grid .avatar{--avatar-focus-color:var(--google-grey-500);--avatar-gap-color:var(--google-grey-800)}.checkmark{--iron-icon-fill-color:var(--google-grey-900);background-color:var(--google-blue-300)}}:host-context(.focus-outline-visible) #avatar-grid .avatar-container:not(.iron-selected) .avatar:focus{--avatar-outline-color:var(--avatar-focus-color);--avatar-outline-width:1px}cr-button{background-size:var(--avatar-size)}cr-tooltip{--paper-tooltip-delay-in:100ms;--paper-tooltip-duration-in:100ms;--paper-tooltip-duration-out:100ms;--paper-tooltip-min-width:none}`])}function getHtml$1(){return html$1`
<cr-grid id="avatar-grid" role="radiogroup" columns="${this.columns}"
    focus-selector=".avatar"
    .ignoreModifiedKeyEvents="${this.ignoreModifiedKeyEvents}">
  ${this.avatars.map(((item,index)=>html$1`
    <!-- Wrapper div is needed so that only a single node is slotted in
        cr-grid for each avatar. -->
    <div>
      <div class="avatar-container ${this.getSelectedClass_(item)}">
        <cr-button class="avatar" role="radio" id="${this.getAvatarId_(index)}"
            data-index="${index}" aria-label="${item.label}"
            tabindex="${this.getTabIndex_(index,item)}"
            @click="${this.onAvatarClick_}"
            .style="background-image: ${getImage(item.url)}"
            aria-checked="${this.isAvatarSelected_(item)}">
        </cr-button>
        <cr-icon icon="cr:check" class="checkmark"></cr-icon>
      </div>
      <cr-tooltip for="${this.getAvatarId_(index)}" offset="0"
          fit-to-visible-bounds>
        ${item.label}
      </cr-tooltip>
    </div>
  `))}
</cr-grid>`}class CrProfileAvatarSelectorElement extends CrLitElement{static get is(){return"cr-profile-avatar-selector"}static get styles(){return getCss$1()}render(){return getHtml$1.bind(this)()}static get properties(){return{avatars:{type:Array},selectedAvatar:{type:Object,notify:true},ignoreModifiedKeyEvents:{type:Boolean},tabFocusableAvatar_:{type:Number},columns:{type:Number}}}#avatars_accessor_storage=[];get avatars(){return this.#avatars_accessor_storage}set avatars(value){this.#avatars_accessor_storage=value}#selectedAvatar_accessor_storage=null;get selectedAvatar(){return this.#selectedAvatar_accessor_storage}set selectedAvatar(value){this.#selectedAvatar_accessor_storage=value}#ignoreModifiedKeyEvents_accessor_storage=false;get ignoreModifiedKeyEvents(){return this.#ignoreModifiedKeyEvents_accessor_storage}set ignoreModifiedKeyEvents(value){this.#ignoreModifiedKeyEvents_accessor_storage=value}#columns_accessor_storage=6;get columns(){return this.#columns_accessor_storage}set columns(value){this.#columns_accessor_storage=value}#tabFocusableAvatar__accessor_storage=-1;get tabFocusableAvatar_(){return this.#tabFocusableAvatar__accessor_storage}set tabFocusableAvatar_(value){this.#tabFocusableAvatar__accessor_storage=value}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("avatars")||changedProperties.has("selectedAvatar")){const selectedAvatar=this.avatars.find((avatar=>this.isAvatarSelected_(avatar)));this.tabFocusableAvatar_=selectedAvatar?selectedAvatar.index:-1}}getAvatarId_(index){return"avatarId"+index}getTabIndex_(index,item){if(item.index===this.tabFocusableAvatar_){return"0"}if(this.tabFocusableAvatar_===-1&&index===0){return"0"}return"-1"}getSelectedClass_(avatarItem){return this.isAvatarSelected_(avatarItem)?"iron-selected":""}isAvatarSelected_(avatarItem){return avatarItem.selected||!!this.selectedAvatar&&this.selectedAvatar.index===avatarItem.index}onAvatarClick_(e){const target=e.currentTarget;const index=Number(target.dataset["index"]);this.selectedAvatar=this.avatars[index];const avatarList=this.shadowRoot.querySelectorAll(".avatar-container");assert(avatarList.length>0);const selectedAvatarElement=avatarList[index];selectedAvatarElement.scrollIntoViewIfNeeded()}}customElements.define(CrProfileAvatarSelectorElement.is,CrProfileAvatarSelectorElement);function getTemplate$g(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared">cr-input{--cr-input-error-display:none}.cr-row.manage-profile-section{display:block;padding-bottom:24px}.cr-row:not(.first){padding-top:4px}.content{padding-inline-start:var(--cr-section-indent-width);padding-top:4px}#nameInput{width:288px}.grid-container{--icon-grid-gap:25px;--icon-size:72px;max-width:100%;overflow-x:auto;overflow-y:hidden}cr-theme-color-picker,cr-profile-avatar-selector{margin-bottom:10px}cr-theme-color-picker{--selected-border:9px;--cr-theme-color-picker-column-width:calc(var(--icon-size) + var(--selected-border));--cr-theme-color-picker-grid-gap:calc(var(--icon-grid-gap) - var(--selected-border));--cr-theme-color-picker-grid-padding:0;display:inline-block}#profileAvatarSelector{--avatar-size:var(--icon-size);--avatar-spacing:var(--icon-grid-gap);padding:4px}#outerRow{align-items:center;display:flex;min-height:var(--cr-section-two-line-min-height);padding:0 var(--cr-section-padding)}#labelWrapper{padding:var(--cr-section-vertical-padding) 0}#policyIcon{position:absolute;right:5%;height:15px;width:15px}</style>

<settings-subpage page-title="$i18n{editPerson}"
    route-path$="[[routePath]]">
<div class="cr-row first manage-profile-section">
  <h1 class="cr-title-text">$i18n{nameYourProfile}</h1>
  <div class="content">
    <cr-input id="nameInput" value="[[profileName_]]" pattern="[[pattern_]]"
        on-change="onNameInputChange_"
        on-keydown="onNameInputKeydown_"
        maxlength="500"
        aria-label="$i18n{nameInputLabel}" auto-validate required
        spellcheck="false" disabled="[[hasEnterpriseLabel_]]">
      <cr-icon id="policyIcon" icon="cr:domain" slot="suffix"
          hidden="[[!hasEnterpriseLabel_]]">
      </cr-icon>
    </cr-input>
    <cr-tooltip id="tooltip"
    for="policyIcon" position="top">
    $i18n{controlledSettingPolicy}
  </cr-tooltip>
  </div>
</div>
<div class="cr-row manage-profile-section">
  <h1 class="cr-title-text">$i18n{pickThemeColor}</h1>
  <div class="content grid-container">
    <cr-theme-color-picker columns="6"></cr-theme-color-picker>
 </div>
</div>
<div class="cr-row manage-profile-section">
  <h1 class="cr-title-text">$i18n{pickAvatar}</h1>
  <div class="content grid-container">
    <cr-profile-avatar-selector
        id="profileAvatarSelector" avatars="[[availableIcons]]"
        selected-avatar="{{profileAvatar_}}" ignore-modified-key-events>
    </cr-profile-avatar-selector>
 </div>
</div>
<template is="dom-if" if="[[isProfileShortcutSettingVisible_]]">
  <div id="outerRow" class="hr">
    <div class="flex" id="labelWrapper">
      <div>$i18n{createShortcutTitle}</div>
      <div class="secondary">$i18n{createShortcutSubtitle}</div>
    </div>
    <cr-toggle id="hasShortcutToggle"
        checked="{{hasProfileShortcut_}}"
        on-change="onHasProfileShortcutChange_"
        aria-labelledby="labelWrapper">
    </cr-toggle>
  </div>
  <div class="hr"></div>
</template>
</settings-subpage>
<!--_html_template_end_-->`}var ProfileShortcutStatus;(function(ProfileShortcutStatus){ProfileShortcutStatus["PROFILE_SHORTCUT_SETTING_HIDDEN"]="profileShortcutSettingHidden";ProfileShortcutStatus["PROFILE_SHORTCUT_NOT_FOUND"]="profileShortcutNotFound";ProfileShortcutStatus["PROFILE_SHORTCUT_FOUND"]="profileShortcutFound"})(ProfileShortcutStatus||(ProfileShortcutStatus={}));class ManageProfileBrowserProxyImpl{getAvailableIcons(){return sendWithPromise("getAvailableIcons")}setProfileIconToGaiaAvatar(){chrome.send("setProfileIconToGaiaAvatar")}setProfileIconToDefaultAvatar(index){chrome.send("setProfileIconToDefaultAvatar",[index])}setProfileName(name){chrome.send("setProfileName",[name])}getProfileShortcutStatus(){return sendWithPromise("requestProfileShortcutStatus")}addProfileShortcut(){chrome.send("addProfileShortcut")}removeProfileShortcut(){chrome.send("removeProfileShortcut")}static getInstance(){return instance$6||(instance$6=new ManageProfileBrowserProxyImpl)}static setInstance(obj){instance$6=obj}}let instance$6=null;const SettingsManageProfileElementBase=SettingsViewMixin(RouteObserverMixin(WebUiListenerMixin(PolymerElement)));class SettingsManageProfileElement extends SettingsManageProfileElementBase{static get is(){return"settings-manage-profile"}static get template(){return getTemplate$g()}static get properties(){return{profileAvatar_:{type:Object,observer:"profileAvatarChanged_"},profileName_:String,hasProfileShortcut_:Boolean,availableIcons:{type:Array,value(){return[]}},isProfileShortcutSettingVisible_:Boolean,hasEnterpriseLabel_:{type:Boolean,value(){return loadTimeData.getBoolean("hasEnterpriseLabel")}},pattern_:{type:String,value:".*\\S.*"}}}browserProxy_=ManageProfileBrowserProxyImpl.getInstance();connectedCallback(){super.connectedCallback();const setIcons=icons=>{this.availableIcons=icons};this.addWebUiListener("available-icons-changed",setIcons);this.browserProxy_.getAvailableIcons().then(setIcons);ProfileInfoBrowserProxyImpl.getInstance().getProfileInfo().then(this.onProfileInfoChanged_.bind(this));this.addWebUiListener("profile-info-changed",this.onProfileInfoChanged_.bind(this))}currentRouteChanged(newRoute,oldRoute){super.currentRouteChanged(newRoute,oldRoute);if(Router.getInstance().getCurrentRoute()===routes.MANAGE_PROFILE){if(this.profileName_){this.$.nameInput.value=this.profileName_}if(loadTimeData.getBoolean("profileShortcutsEnabled")){this.browserProxy_.getProfileShortcutStatus().then((status=>{if(status===ProfileShortcutStatus.PROFILE_SHORTCUT_SETTING_HIDDEN){this.isProfileShortcutSettingVisible_=false;return}this.isProfileShortcutSettingVisible_=true;this.hasProfileShortcut_=status===ProfileShortcutStatus.PROFILE_SHORTCUT_FOUND}))}}}onProfileInfoChanged_(info){this.profileName_=info.name}onNameInputChange_(event){const target=event.target;if(target.invalid){return}this.browserProxy_.setProfileName(target.value)}onNameInputKeydown_(event){if(event.key==="Escape"){const target=event.target;target.value=this.profileName_;target.blur()}}profileAvatarChanged_(){if(this.profileAvatar_===null){return}if(this.profileAvatar_.isGaiaAvatar){this.browserProxy_.setProfileIconToGaiaAvatar()}else{this.browserProxy_.setProfileIconToDefaultAvatar(this.profileAvatar_.index)}}onHasProfileShortcutChange_(){if(this.hasProfileShortcut_){this.browserProxy_.addProfileShortcut()}else{this.browserProxy_.removeProfileShortcut()}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsManageProfileElement.is,SettingsManageProfileElement);function getTemplate$f(){return html`<!--_html_template_start_--><settings-subpage page-title="$i18n{syncAdvancedPageTitle}"
    learn-more-url="$i18n{syncAndGoogleServicesLearnMoreURL}"
    route-path$="[[routePath]]">
  <settings-sync-controls sync-status="[[syncStatus_]]">
  </settings-sync-controls>
</settings-subpage>
<!--_html_template_end_-->`}const SettingsSyncControlsPageElementBase=SettingsViewMixin(WebUiListenerMixin(PolymerElement));class SettingsSyncControlsPageElement extends SettingsSyncControlsPageElementBase{static get is(){return"settings-sync-controls-page"}static get template(){return getTemplate$f()}static get properties(){return{syncStatus_:{type:Object}}}connectedCallback(){super.connectedCallback();SyncBrowserProxyImpl.getInstance().getSyncStatus().then(this.onSyncStatusChanged_.bind(this));this.addWebUiListener("sync-status-changed",this.onSyncStatusChanged_.bind(this))}onSyncStatusChanged_(syncStatus){this.syncStatus_=syncStatus}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsSyncControlsPageElement.is,SettingsSyncControlsPageElement);function getTemplate$e(){return html`<!--_html_template_start_-->    <style include="cr-shared-style settings-shared">#sync-separator{border-bottom:var(--cr-separator-line)}#create-password-box{margin-inline-start:var(--cr-section-indent-width)}#create-password-box{margin-bottom:1em}#create-password-box .list-item{margin-bottom:var(--cr-form-field-bottom-spacing)}cr-input{--cr-input-width:var(--cr-default-input-max-width)}#existingPassphrase{border-bottom:var(--cr-separator-line);border-top:var(--cr-separator-line);padding-inline-start:var(--cr-section-padding)}#submitExistingPassphrase{margin-inline-start:16px}#passphraseRecoverHint{align-items:center}#other-sync-items{padding-bottom:8px}.passphrase-reset-icon{margin-inline-end:8px}#disabled-by-admin-icon{text-align:center;width:40px}#toast{left:0;z-index:1}:host-context([dir='rtl']) #toast{left:auto;right:0}cr-link-row{padding-inline-end:0;padding-inline-start:0}cr-collapse>cr-link-row{padding-inline-start:var(--cr-section-indent-padding)}
    </style>

  <settings-subpage page-title="$i18n{syncPageTitle}"
      learn-more-url="$i18n{syncAndGoogleServicesLearnMoreURL}"
      route-path$="[[routePath]]">

    <template is="dom-if" if="[[shouldShowSyncAccountControl_(
        syncStatus_.syncSystemEnabled)]]">
      <settings-sync-account-control embedded-in-subpage
          sync-status="[[syncStatus_]]" prefs="{{prefs}}"
          promo-label-with-account=
              "$i18n{peopleSignInSyncPagePromptSecondaryWithAccount}"
          promo-label-with-no-account=
              "$i18n{peopleSignInSyncPagePromptSecondaryWithNoAccount}"
          on-sync-setup-done="onSyncSetupDone_"
          access-point="[[accessPointEnum_.SETTINGS]]">
      </settings-sync-account-control>
    </template>

    <div class="cr-row first" hidden="[[!syncDisabledByAdmin_]]">
      <cr-icon id="disabled-by-admin-icon" icon="cr20:domain"></cr-icon>
      <div class="flex cr-padded-text">
        $i18n{syncDisabledByAdministrator}
      </div>
    </div>

    <template is="dom-if" if="[[showExistingPassphraseBelowAccount_]]"
        on-dom-change="focusPassphraseInput_">
      <div id="existingPassphrase" class="list-frame">
        <div id="existingPassphraseTitle" class="list-item">
            <div class="start cr-padded-text">
              <div>$i18n{existingPassphraseTitle}</div>
              <div id="enterPassphraseLabel" class="secondary"
                  inner-h-t-m-l="[[enterPassphraseLabel_]]">
              </div>
            </div>
        </div>
        <div id="existingPassphraseContainer" class="list-item">
          <cr-input id="existingPassphraseInput" type="password"
              value="{{existingPassphrase_}}"
              placeholder="$i18n{passphrasePlaceholder}"
              error-message="$i18n{incorrectPassphraseError}"
              on-keypress="onSubmitExistingPassphraseClick_">
            <cr-button id="submitExistingPassphrase" slot="suffix"
                on-click="onSubmitExistingPassphraseClick_"
                class="action-button" disabled="[[!existingPassphrase_]]">
              $i18n{submitPassphraseButton}
            </cr-button>
          </cr-input>
        </div>
        <div id="passphraseRecoverHint" class="list-item">
          <div class="cr-padded-text">$i18nRaw{passphraseRecover}</div>
        </div>
      </div>
    </template>

    <div id="sync-separator" hidden="[[!syncSectionDisabled_]]"></div>

    <div id="sync-section" hidden="[[syncSectionDisabled_]]">
      <div class="cr-row first">
        <h2 class="cr-title-text">$i18n{sync}</h2>
      </div>

      <div id="[[pageStatusEnum_.SPINNER]]" class="cr-row first cr-padded-text"
          hidden$="[[!isStatus_(pageStatusEnum_.SPINNER, pageStatus_)]]">
        $i18n{syncLoading}
      </div>
      <div id="[[pageStatusEnum_.CONFIGURE]]"
          hidden$="[[!isStatus_(pageStatusEnum_.CONFIGURE, pageStatus_)]]">
        <div id="other-sync-items" class="list-frame">
          <cr-link-row id="sync-advanced-row"
              label="$i18n{syncAdvancedPageTitle}"
              role-description="$i18n{subpageArrowRoleDescription}"
              on-click="onSyncAdvancedClick_">
          </cr-link-row>

          <template is="dom-if" if="[[!isEeaChoiceCountry_]]">
            <cr-link-row class="hr" id="activityControlsLinkRowV2"
                label="$i18n{personalizeGoogleServicesTitleV2}"
                sub-label="$i18n{personalizeGoogleServicesDesc}"
                on-click="onActivityControlsClick_" external>
            </cr-link-row>
          </template>
          <template is="dom-if" if="[[isEeaChoiceCountry_]]">
            <cr-expand-button class="hr" id="personalizationExpandButton"
                expanded="{{personalizationCollapseExpanded_}}">
              $i18n{personalizeGoogleServicesTitleV2}
              <div class="secondary">
                $i18n{personalizeGoogleServicesDescWithLinkedServices}
              </div>
            </cr-expand-button>
            <cr-collapse id="personalizationCollapse"
                opened="[[personalizationCollapseExpanded_]]">
              <cr-link-row external on-click="onActivityControlsClick_"
                  label="$i18n{personalizeGoogleServicesWaaTitle}">
              </cr-link-row>
              <cr-link-row external id="linkedServicesLinkRow"
                  on-click="onLinkedServicesClick_"
                  label="$i18n{personalizeGoogleServicesLinkedServicesTitle}"
                  sub-label=
                      "$i18n{personalizeGoogleServicesLinkedServicesDesc}">
              </cr-link-row>
            </cr-collapse>
          </template>

          <cr-link-row id="syncDashboardLink" class="hr"
              label="$i18n{manageSyncedDataTitle}"
              on-click="onSyncDashboardLinkClick_"
              hidden="[[syncStatus_.supervisedUser]]" external>
          </cr-link-row>

          <cr-expand-button id="encryptionDescription"
              hidden="[[syncPrefs.passphraseRequired]]"
              expanded="{{encryptionExpanded_}}"
              class="hr">
            $i18n{encryptionOptionsTitle}
            <div class="secondary">
              $i18n{syncDataEncryptedText}
              <div on-click="onResetSyncClick_"
                  hidden="[[!syncPrefs.encryptAllData]]">
                <cr-icon icon="cr:info-outline"
                    class="passphrase-reset-icon">
                </cr-icon>
                $i18nRaw{passphraseResetHintEncryption}
              </div>
            </div>
          </cr-expand-button>

          <cr-collapse id="encryptionCollapse"
              opened="[[encryptionExpanded_]]">
            <settings-sync-encryption-options
                sync-status="[[syncStatus_]]" sync-prefs="{{syncPrefs}}"
                existing-passphrase-label="[[existingPassphraseLabel_]]"
                on-passphrase-changed="onPassphraseChanged_">
            </settings-sync-encryption-options>
          </cr-collapse>

        </div>
      </div>
    </div>

    <div class="cr-row first">
      <h2 class="cr-title-text">
        $i18n{nonPersonalizedServicesSectionLabel}
      </h2>
    </div>
    <settings-personalization-options class="list-frame" prefs="{{prefs}}"
        sync-status="[[syncStatus_]]">
    </settings-personalization-options>


    <template is="dom-if" if="[[showSetupCancelDialog_]]" restamp>
      <cr-dialog id="setupCancelDialog" on-close="onSetupCancelDialogClose_"
          ignore-popstate show-on-attach>
        <div slot="title">$i18n{syncSetupCancelDialogTitle}</div>
        <div slot="body">$i18n{syncSetupCancelDialogBody}</div>
        <div slot="button-container">
          <cr-button class="cancel-button"
              on-click="onSetupCancelDialogBack_">
            $i18n{back}
          </cr-button>
          <cr-button class="action-button"
              on-click="onSetupCancelDialogConfirm_">
            $i18n{cancelSync}
          </cr-button>
        </div>
      </cr-dialog>
    </template>

  </settings-subpage>
<!--_html_template_end_-->`}const SettingsSyncPageElementBase=SettingsViewMixin(RouteObserverMixin(WebUiListenerMixin(I18nMixin(PolymerElement))));class SettingsSyncPageElement extends SettingsSyncPageElementBase{static get is(){return"settings-sync-page"}static get template(){return getTemplate$e()}static get properties(){return{prefs:{type:Object,notify:true},focusConfig:{type:Object,observer:"onFocusConfigChange_"},pageStatusEnum_:{type:Object,value:PageStatus,readOnly:true},pageStatus_:{type:String,value:PageStatus.CONFIGURE},syncPrefs:Object,syncStatus_:Object,dataEncrypted_:{type:Boolean,computed:"computeDataEncrypted_(syncPrefs.encryptAllData)"},encryptionExpanded_:{type:Boolean,value:false},forceEncryptionExpanded:{type:Boolean,value:false},existingPassphrase_:{type:String,value:""},showExistingPassphraseBelowAccount_:{type:Boolean,value:false,computed:"computeShowExistingPassphraseBelowAccount_("+"syncStatus_.signedInState, syncPrefs.passphraseRequired)"},signedIn_:{type:Boolean,value:true,computed:"computeSignedIn_(syncStatus_.signedInState)"},syncDisabledByAdmin_:{type:Boolean,value:false,computed:"computeSyncDisabledByAdmin_(syncStatus_.managed)"},syncSectionDisabled_:{type:Boolean,value:false,computed:"computeSyncSectionDisabled_("+"syncStatus_.signedInState, syncStatus_.disabled, "+"syncStatus_.hasError, syncStatus_.statusAction, "+"syncPrefs.trustedVaultKeysRequired)"},showSetupCancelDialog_:{type:Boolean,value:false},enterPassphraseLabel_:{type:String,computed:"computeEnterPassphraseLabel_(syncPrefs.encryptAllData,"+"syncPrefs.explicitPassphraseTime)"},existingPassphraseLabel_:{type:String,computed:"computeExistingPassphraseLabel_(syncPrefs.encryptAllData,"+"syncPrefs.explicitPassphraseTime)"},isEeaChoiceCountry_:{type:Boolean,value(){return loadTimeData.getBoolean("isEeaChoiceCountry")}},personalizationCollapseExpanded_:{type:Boolean,value:false},accessPointEnum_:{type:Object,value:ChromeSigninAccessPoint}}}static get observers(){return["expandEncryptionIfNeeded_(dataEncrypted_, forceEncryptionExpanded)"]}metricsBrowserProxy_=MetricsBrowserProxyImpl.getInstance();syncBrowserProxy_=SyncBrowserProxyImpl.getInstance();collapsibleSectionsInitialized_;didAbort_;setupCancelConfirmed_;beforeunloadCallback_;unloadCallback_;constructor(){super();this.beforeunloadCallback_=null;this.unloadCallback_=null;this.collapsibleSectionsInitialized_=false;this.didAbort_=true;this.setupCancelConfirmed_=false}connectedCallback(){super.connectedCallback();this.addWebUiListener("page-status-changed",this.handlePageStatusChanged_.bind(this));this.addWebUiListener("sync-prefs-changed",this.handleSyncPrefsChanged_.bind(this));this.syncBrowserProxy_.getSyncStatus().then(this.onSyncStatusChanged_.bind(this));this.addWebUiListener("sync-status-changed",this.onSyncStatusChanged_.bind(this))}disconnectedCallback(){super.disconnectedCallback();const router=Router.getInstance();if(router.getRoutes().SYNC.contains(router.getCurrentRoute())){this.onNavigateAwayFromPage_()}if(this.beforeunloadCallback_){window.removeEventListener("beforeunload",this.beforeunloadCallback_);this.beforeunloadCallback_=null}if(this.unloadCallback_){window.removeEventListener("unload",this.unloadCallback_);this.unloadCallback_=null}}onSyncStatusChanged_(syncStatus){this.syncStatus_=syncStatus;if(Router.getInstance().getCurrentRoute()===routes.SYNC&&!this.shouldShowSyncPage_()){this.onNavigateAwayFromPage_();Router.getInstance().navigateTo(routes.PEOPLE)}}computeSignedIn_(){return this.syncStatus_.signedInState===SignedInState.SYNCING}computeSyncSectionDisabled_(){return this.syncStatus_!==undefined&&(this.syncStatus_.signedInState!==SignedInState.SYNCING||!!this.syncStatus_.disabled||!!this.syncStatus_.hasError&&this.syncStatus_.statusAction!==StatusAction.ENTER_PASSPHRASE&&this.syncStatus_.statusAction!==StatusAction.RETRIEVE_TRUSTED_VAULT_KEYS&&this.syncStatus_.statusAction!==StatusAction.CONFIRM_SYNC_SETTINGS)}computeSyncDisabledByAdmin_(){return this.syncStatus_!==undefined&&!!this.syncStatus_.managed}onFocusConfigChange_(){this.focusConfig.set(Router.getInstance().getRoutes().SYNC_ADVANCED.path,(()=>{const toFocus=this.shadowRoot.querySelector("#sync-advanced-row");assert(toFocus);focusWithoutInk(toFocus)}))}onSetupCancelDialogBack_(){this.shadowRoot.querySelector("#setupCancelDialog").cancel();chrome.metricsPrivate.recordUserAction("Signin_Signin_CancelCancelAdvancedSyncSettings")}onSetupCancelDialogConfirm_(){this.setupCancelConfirmed_=true;this.shadowRoot.querySelector("#setupCancelDialog").close();const router=Router.getInstance();router.navigateTo(router.getRoutes().BASIC);chrome.metricsPrivate.recordUserAction("Signin_Signin_ConfirmCancelAdvancedSyncSettings")}onSetupCancelDialogClose_(){this.showSetupCancelDialog_=false}shouldShowSyncPage_(){return!loadTimeData.getBoolean("replaceSyncPromosWithSignInPromos")||!this.syncStatus_||this.syncStatus_.signedInState===SignedInState.SYNCING}currentRouteChanged(newRoute,oldRoute){super.currentRouteChanged(newRoute,oldRoute);const router=Router.getInstance();if(router.getCurrentRoute()===router.getRoutes().SYNC){if(!this.shouldShowSyncPage_()){this.onNavigateAwayFromPage_();Router.getInstance().navigateTo(routes.PEOPLE);return}this.onNavigateToPage_();return}if(router.getRoutes().SYNC.contains(router.getCurrentRoute())){return}const searchParams=Router.getInstance().getQueryParameters().get("search");if(searchParams){this.onNavigateAwayFromPage_();return}const userActionCancelsSetup=this.syncStatus_&&this.syncStatus_.firstSetupInProgress&&this.didAbort_;if(userActionCancelsSetup&&!this.setupCancelConfirmed_){chrome.metricsPrivate.recordUserAction("Signin_Signin_BackOnAdvancedSyncSettings");requestAnimationFrame((()=>{router.navigateTo(router.getRoutes().SYNC);this.showSetupCancelDialog_=true}));return}this.setupCancelConfirmed_=false;this.onNavigateAwayFromPage_()}isStatus_(expectedPageStatus){return expectedPageStatus===this.pageStatus_}onNavigateToPage_(){const router=Router.getInstance();assert(router.getCurrentRoute()===router.getRoutes().SYNC);if(this.beforeunloadCallback_){return}this.collapsibleSectionsInitialized_=false;this.pageStatus_=PageStatus.SPINNER;this.syncBrowserProxy_.didNavigateToSyncPage();this.beforeunloadCallback_=event=>{if(this.syncStatus_&&this.syncStatus_.firstSetupInProgress){event.preventDefault();chrome.metricsPrivate.recordUserAction("Signin_Signin_AbortAdvancedSyncSettings")}};window.addEventListener("beforeunload",this.beforeunloadCallback_);this.unloadCallback_=this.onNavigateAwayFromPage_.bind(this);window.addEventListener("unload",this.unloadCallback_)}onNavigateAwayFromPage_(){if(!this.beforeunloadCallback_){return}this.pageStatus_=PageStatus.CONFIGURE;this.syncBrowserProxy_.didNavigateAwayFromSyncPage(this.didAbort_);window.removeEventListener("beforeunload",this.beforeunloadCallback_);this.beforeunloadCallback_=null;if(this.unloadCallback_){window.removeEventListener("unload",this.unloadCallback_);this.unloadCallback_=null}}handleSyncPrefsChanged_(syncPrefs){this.syncPrefs=syncPrefs;this.pageStatus_=PageStatus.CONFIGURE}onActivityControlsClick_(){chrome.metricsPrivate.recordUserAction("Sync_OpenActivityControlsPage");this.syncBrowserProxy_.openActivityControlsUrl();window.open(loadTimeData.getString("activityControlsUrl"))}onLinkedServicesClick_(){this.metricsBrowserProxy_.recordAction("Sync_OpenLinkedServicesPage");OpenWindowProxyImpl.getInstance().openUrl(loadTimeData.getString("linkedServicesUrl"))}onSyncDashboardLinkClick_(){window.open(loadTimeData.getString("syncDashboardUrl"))}computeDataEncrypted_(){return!!this.syncPrefs&&this.syncPrefs.encryptAllData}computeEnterPassphraseLabel_(){if(!this.syncPrefs||!this.syncPrefs.encryptAllData){return window.trustedTypes.emptyHTML}if(!this.syncPrefs.explicitPassphraseTime){return this.i18nAdvanced("enterPassphraseLabel")}return this.i18nAdvanced("enterPassphraseLabelWithDate",{tags:["a"],substitutions:[loadTimeData.getString("syncErrorsHelpUrl"),this.syncPrefs.explicitPassphraseTime]})}computeExistingPassphraseLabel_(){if(!this.syncPrefs||!this.syncPrefs.encryptAllData){return window.trustedTypes.emptyHTML}if(!this.syncPrefs.explicitPassphraseTime){return this.i18nAdvanced("existingPassphraseLabel")}return this.i18nAdvanced("existingPassphraseLabelWithDate",{substitutions:[this.syncPrefs.explicitPassphraseTime]})}expandEncryptionIfNeeded_(){if(this.forceEncryptionExpanded){this.forceEncryptionExpanded=false;this.encryptionExpanded_=true;return}this.encryptionExpanded_=this.dataEncrypted_}onResetSyncClick_(event){if(event.target.tagName==="A"){event.stopPropagation()}}onSubmitExistingPassphraseClick_(e){if(e.type==="keypress"&&e.key!=="Enter"){return}this.syncBrowserProxy_.setDecryptionPassphrase(this.existingPassphrase_).then((sucessfullySet=>this.handlePageStatusChanged_(this.computePageStatusAfterPassphraseChange_(sucessfullySet))));this.existingPassphrase_=""}onPassphraseChanged_(e){this.handlePageStatusChanged_(this.computePageStatusAfterPassphraseChange_(e.detail.didChange))}computePageStatusAfterPassphraseChange_(successfullyChanged){if(!successfullyChanged){return PageStatus.PASSPHRASE_FAILED}return this.syncStatus_&&this.syncStatus_.firstSetupInProgress?PageStatus.CONFIGURE:PageStatus.DONE}handlePageStatusChanged_(pageStatus){const router=Router.getInstance();switch(pageStatus){case PageStatus.SPINNER:case PageStatus.CONFIGURE:this.pageStatus_=pageStatus;return;case PageStatus.DONE:if(router.getCurrentRoute()===router.getRoutes().SYNC){router.navigateTo(router.getRoutes().PEOPLE)}return;case PageStatus.PASSPHRASE_FAILED:if(this.pageStatus_===PageStatus.CONFIGURE&&this.syncPrefs&&this.syncPrefs.passphraseRequired){const passphraseInput=this.shadowRoot.querySelector("#existingPassphraseInput");passphraseInput.invalid=true;passphraseInput.focusInput()}return;default:assertNotReached()}}onLearnMoreClick_(event){if(event.target.tagName==="A"){event.stopPropagation()}}shouldShowSyncAccountControl_(){return this.syncStatus_!==undefined&&!!this.syncStatus_.syncSystemEnabled&&loadTimeData.getBoolean("signinAllowed")}computeShowExistingPassphraseBelowAccount_(){return this.syncStatus_!==undefined&&this.syncStatus_.signedInState===SignedInState.SYNCING&&this.syncPrefs!==undefined&&!!this.syncPrefs.passphraseRequired}onSyncAdvancedClick_(){const router=Router.getInstance();router.navigateTo(router.getRoutes().SYNC_ADVANCED)}onSyncSetupDone_(e){if(e.detail){this.didAbort_=false;chrome.metricsPrivate.recordUserAction("Signin_Signin_ConfirmAdvancedSyncSettings")}else{this.setupCancelConfirmed_=true;chrome.metricsPrivate.recordUserAction("Signin_Signin_CancelAdvancedSyncSettings")}const router=Router.getInstance();router.navigateTo(router.getRoutes().BASIC)}focusPassphraseInput_(){const passphraseInput=this.shadowRoot.querySelector("#existingPassphraseInput");const router=Router.getInstance();if(passphraseInput&&router.getCurrentRoute()===router.getRoutes().SYNC){passphraseInput.focus()}}focusBackButton(){this.shadowRoot.querySelector("settings-subpage").focusBackButton()}}customElements.define(SettingsSyncPageElement.is,SettingsSyncPageElement);var ScreenAiInstallStatus;(function(ScreenAiInstallStatus){ScreenAiInstallStatus[ScreenAiInstallStatus["NOT_DOWNLOADED"]=0]="NOT_DOWNLOADED";ScreenAiInstallStatus[ScreenAiInstallStatus["DOWNLOADING"]=1]="DOWNLOADING";ScreenAiInstallStatus[ScreenAiInstallStatus["DOWNLOAD_FAILED"]=2]="DOWNLOAD_FAILED";ScreenAiInstallStatus[ScreenAiInstallStatus["DOWNLOADED"]=3]="DOWNLOADED"})(ScreenAiInstallStatus||(ScreenAiInstallStatus={}));let instance$5=null;class AxAnnotationsBrowserProxyImpl{static getInstance(){return instance$5||(instance$5=new AxAnnotationsBrowserProxyImpl)}static setInstanceForTesting(obj){instance$5=obj}getScreenAiInstallState(){return sendWithPromise("getScreenAiInstallState")}}function getTemplate$d(){return html`<!--_html_template_start_--><style include="settings-shared"></style>
<settings-toggle-button id="mainNodeAnnotationsToggle"
    class="hr"
    pref="{{prefs.settings.a11y.enable_main_node_annotations}}"
    label="$i18n{mainNodeAnnotationsTitle}"
    sub-label="[[getMainNodeAnnotationsToggleSublabel_(
        screenAIStatus_, screenAIProgress_)]]">
</settings-toggle-button>
<!--_html_template_end_-->`}const SettingsAxAnnotationsSectionBaseElement=PrefsMixin(WebUiListenerMixin(I18nMixin(PolymerElement)));class SettingsAxAnnotationsSectionElement extends SettingsAxAnnotationsSectionBaseElement{static get is(){return"settings-ax-annotations-section"}static get template(){return getTemplate$d()}static get properties(){return{screenAIProgress_:Number,screenAIStatus_:Number}}browserProxy_=AxAnnotationsBrowserProxyImpl.getInstance();connectedCallback(){super.connectedCallback();assert(loadTimeData.getBoolean("mainNodeAnnotationsEnabled"));const updateScreenAIState=screenAIState=>{this.screenAIStatus_=screenAIState};this.browserProxy_.getScreenAiInstallState().then(updateScreenAIState);this.addWebUiListener("screen-ai-state-changed",updateScreenAIState);this.addWebUiListener("screen-ai-downloading-progress-changed",(progress=>{this.screenAIProgress_=progress}))}getMainNodeAnnotationsToggleSublabel_(){switch(this.screenAIStatus_){case ScreenAiInstallStatus.DOWNLOADING:return this.screenAIProgress_>0&&this.screenAIProgress_<100?this.i18n("mainNodeAnnotationsDownloadProgressLabel",this.screenAIProgress_):this.i18n("mainNodeAnnotationsDownloadingLabel");case ScreenAiInstallStatus.DOWNLOAD_FAILED:return this.i18n("mainNodeAnnotationsDownloadErrorLabel");case ScreenAiInstallStatus.DOWNLOADED:case ScreenAiInstallStatus.NOT_DOWNLOADED:return this.i18n("mainNodeAnnotationsSubtitle");default:assertNotReached()}}}customElements.define(SettingsAxAnnotationsSectionElement.is,SettingsAxAnnotationsSectionElement);class AccessibilityBrowserProxyImpl{openTrackpadGesturesSettings(){chrome.send("openTrackpadGesturesSettings")}recordOverscrollHistoryNavigationChanged(enabled){chrome.metricsPrivate.recordBoolean("Settings.OverscrollHistoryNavigation.Enabled",enabled)}getScreenReaderState(){return sendWithPromise("getScreenReaderState")}static getInstance(){return instance$4||(instance$4=new AccessibilityBrowserProxyImpl)}static setInstance(obj){instance$4=obj}}let instance$4=null;function getTemplate$c(){return html`<!--_html_template_start_-->    <style include="settings-shared"></style>
    <settings-section page-title="$i18n{a11yPageTitle}">
      <div route-path="default">



        <template is="dom-if" if="[[enableLiveCaption_]]">
          <settings-live-caption prefs="{{prefs}}"></settings-live-caption>
        </template>
        <cr-link-row id="captions"
            class="hr"
            label="$i18n{captionsPreferencesTitle}"
            sub-label="$i18n{captionsPreferencesSubtitle}"
            on-click="onCaptionsClick_"
            button-aria-description="$i18n{opensInNewTab}"
            external>
        </cr-link-row>





        <settings-toggle-button
            class="hr"
            pref="{{prefs.settings.a11y.focus_highlight}}"
            on-setting-boolean-control-change="onFocusHighlightChange_"
            label="$i18n{focusHighlightLabel}">
        </settings-toggle-button>
        <settings-toggle-button
            class="hr"
            pref="{{prefs.settings.a11y.caretbrowsing.enabled}}"
            on-change="onA11yCaretBrowsingChange_"
            label="$i18n{caretBrowsingTitle}"
            sub-label="$i18n{caretBrowsingSubtitle}">
        </settings-toggle-button>

        <settings-toggle-button
            class="hr"
            hidden$="[[!hasScreenReader_]]"
            pref="{{prefs.settings.a11y.enable_accessibility_image_labels}}"
            on-change="onA11yImageLabelsChange_"
            label="$i18n{accessibleImageLabelsTitle}"
            sub-label="$i18n{accessibleImageLabelsSubtitle}">
        </settings-toggle-button>
        <template is="dom-if" if="[[showAxTreeFixingSection_]]">
          <settings-toggle-button id="axTreeFixing"
              class="hr"
              pref="{{prefs.settings.a11y.enable_ax_tree_fixing}}"
              label="$i18n{axTreeFixingTitle}"
              sub-label="$i18n{axTreeFixingSubtitle}">
          </settings-toggle-button>
        </template>

        <template is="dom-if" if="[[showAxAnnotationsSection_]]">
          <settings-ax-annotations-section
              id="AxAnnotationsSection"
              prefs="{{prefs}}">
          </settings-ax-annotations-section>
        </template>



        <cr-link-row
            class="hr"
            on-click="onMacTrackpadGesturesLinkClick_"
            button-aria-description="$i18n{opensInNewTab}"
            label="$i18n{overscrollHistoryNavigationTitle}"
            sub-label="$i18n{overscrollHistoryNavigationSubtitle}"
            external>
        </cr-link-row>


        <settings-toggle-button class="hr" id="toastToggle"
          pref="{{prefs.settings.toast.alert_level}}"
          numeric-unchecked-values="[[numericUncheckedToastAlertValues_]]"
          numeric-checked-value="[[toastAlertLevelEnum_.ALL]]"
            on-change="onToastAlertLevelChange_" label="$i18n{toastAlertLevelTitle}"
            sub-label="$i18n{toastAlertLevelDescription}">
        </settings-toggle-button>

        <cr-link-row class="hr" label="$i18n{moreFeaturesLink}"
            on-click="onMoreFeaturesLinkClick_" sub-label="$i18n{a11yWebStore}"
            button-aria-description="$i18n{opensInNewTab}"
            external>
        </cr-link-row>
      </div>
    </settings-section>
<!--_html_template_end_-->`}var ToastAlertLevel;(function(ToastAlertLevel){ToastAlertLevel[ToastAlertLevel["ALL"]=0]="ALL";ToastAlertLevel[ToastAlertLevel["ACTIONABLE"]=1]="ACTIONABLE";ToastAlertLevel[ToastAlertLevel["COUNT"]=1]="COUNT"})(ToastAlertLevel||(ToastAlertLevel={}));const SettingsA11yPageElementBase=SettingsViewMixin(PrefsMixin(WebUiListenerMixin(BaseMixin(PolymerElement))));class SettingsA11yPageElement extends SettingsA11yPageElementBase{static get is(){return"settings-a11y-page"}static get template(){return getTemplate$c()}static get properties(){return{enableLiveCaption_:{type:Boolean,value:function(){return loadTimeData.getBoolean("enableLiveCaption")}},hasScreenReader_:{type:Boolean,value:false},showAxTreeFixingSection_:{type:Boolean,value:()=>loadTimeData.getBoolean("axTreeFixingEnabled")},showAxAnnotationsSection_:{type:Boolean,computed:"computeShowAxAnnotationsSection_(hasScreenReader_)"},toastAlertLevelEnum_:{type:Object,value:ToastAlertLevel},numericUncheckedToastAlertValues_:{type:Array,value:()=>[ToastAlertLevel.ACTIONABLE]}}}browserProxy_=AccessibilityBrowserProxyImpl.getInstance();connectedCallback(){super.connectedCallback();const updateScreenReaderState=hasScreenReader=>{this.hasScreenReader_=hasScreenReader};this.browserProxy_.getScreenReaderState().then(updateScreenReaderState);this.addWebUiListener("screen-reader-state-changed",updateScreenReaderState)}onA11yCaretBrowsingChange_(event){if(event.target.checked){chrome.metricsPrivate.recordUserAction("Accessibility.CaretBrowsing.EnableWithSettings")}else{chrome.metricsPrivate.recordUserAction("Accessibility.CaretBrowsing.DisableWithSettings")}}onA11yImageLabelsChange_(event){const a11yImageLabelsOn=event.target.checked;if(a11yImageLabelsOn){chrome.send("confirmA11yImageLabels")}}computeShowAxAnnotationsSection_(){const anyAxAnnotationsFeatureEnabled=loadTimeData.getBoolean("mainNodeAnnotationsEnabled");return anyAxAnnotationsFeatureEnabled&&this.hasScreenReader_}onCaptionsClick_(){CaptionsBrowserProxyImpl.getInstance().openSystemCaptionsDialog()}onFocusHighlightChange_(event){chrome.metricsPrivate.recordBoolean("Accessibility.FocusHighlight.ToggleEnabled",event.target.checked)}onMoreFeaturesLinkClick_(){window.open("https://chrome.google.com/webstore/category/collection/3p_accessibility_extensions")}onMacTrackpadGesturesLinkClick_(){this.browserProxy_.openTrackpadGesturesSettings()}onToastAlertLevelChange_(){chrome.metricsPrivate.recordEnumerationValue("Toast.FrequencyPrefChanged",this.getPref("settings.toast.alert_level").value,ToastAlertLevel.COUNT)}getAssociatedControlFor(childViewId){assert(childViewId==="captions");const control=this.shadowRoot.querySelector("#captions");assert(control);return control}}customElements.define(SettingsA11yPageElement.is,SettingsA11yPageElement);function getTemplate$b(){return html`<!--_html_template_start_--><style include="settings-shared">cr-view-manager [hidden-by-search],cr-view-manager[show-all] [slot=view][data-parent-view-id]{display:none}</style>

<cr-view-manager id="viewManager" class="cr-centered-card-container"
    show-all$="[[shouldShowAll]]">
  <settings-a11y-page slot="view" id="parent" prefs="{{prefs}}"
      route-path$="[[routes_.ACCESSIBILITY.path]]">
  </settings-a11y-page>


</cr-view-manager>
<!--_html_template_end_-->`}const SettingsA11yPageIndexElementBase=SearchableViewContainerMixin(RouteObserverMixin(PolymerElement));class SettingsA11yPageIndexElement extends SettingsA11yPageIndexElementBase{static get is(){return"settings-a11y-page-index"}static get template(){return getTemplate$b()}static get properties(){return{prefs:Object,routes_:{type:Object,value:()=>routes}}}currentRouteChanged(newRoute,oldRoute){super.currentRouteChanged(newRoute,oldRoute);queueMicrotask((()=>{switch(newRoute){case routes.ACCESSIBILITY:this.$.viewManager.switchView("parent","no-animation","no-animation");break;case routes.BASIC:this.$.viewManager.switchView("parent","no-animation","no-animation");break}}))}}customElements.define(SettingsA11yPageIndexElement.is,SettingsA11yPageIndexElement);function getTemplate$a(){return html`<!--_html_template_start_--><style>:host{--justify-margin:8px;align-items:center;display:flex}:host([enforced_]){pointer-events:none}cr-policy-pref-indicator{pointer-events:all}:host(:not([end-justified])) cr-policy-pref-indicator{margin-inline-start:var(--cr-controlled-by-spacing)}:host([end-justified]) cr-policy-pref-indicator{margin-inline-end:var(--cr-controlled-by-spacing);margin-inline-start:calc(var(--cr-controlled-by-spacing) - var(--justify-margin));order:-1}</style>

<cr-button class$="[[actionClass_]]"
    disabled="[[!buttonEnabled_(enforced_, disabled)]]">
  [[label]]
</cr-button>

<template is="dom-if" if="[[hasPrefPolicyIndicator(pref.*)]]" restamp>
  <cr-policy-pref-indicator pref="[[pref]]" on-click="onIndicatorClick_"
      icon-aria-label="[[label]]">
  </cr-policy-pref-indicator>
</template>
<!--_html_template_end_-->`}const ControlledButtonElementBase=CrPolicyPrefMixin(PrefControlMixin(PolymerElement));class ControlledButtonElement extends ControlledButtonElementBase{static get is(){return"controlled-button"}static get template(){return getTemplate$a()}static get properties(){return{endJustified:{type:Boolean,value:false,reflectToAttribute:true},label:String,disabled:{type:Boolean,value:false,reflectToAttribute:true},actionClass_:{type:String,value:""},enforced_:{type:Boolean,computed:"isPrefEnforced(pref.*)",reflectToAttribute:true}}}connectedCallback(){super.connectedCallback();if(this.classList.contains("action-button")){this.actionClass_="action-button"}}focus(){this.shadowRoot.querySelector("cr-button").focus()}onIndicatorClick_(e){e.preventDefault();e.stopPropagation()}buttonEnabled_(enforced,disabled){return!enforced&&!disabled}}customElements.define(ControlledButtonElement.is,ControlledButtonElement);class DownloadsBrowserProxyImpl{initializeDownloads(){chrome.send("initializeDownloads")}selectDownloadLocation(){chrome.send("selectDownloadLocation")}resetAutoOpenFileTypes(){chrome.send("resetAutoOpenFileTypes")}static getInstance(){return instance$3||(instance$3=new DownloadsBrowserProxyImpl)}static setInstance(obj){instance$3=obj}}let instance$3=null;function getTemplate$9(){return html`<!--_html_template_start_-->  <style include="cr-shared-style settings-shared">#defaultDownloadPath{word-break:break-word}
  </style>
  <settings-section page-title="$i18n{downloadsPageTitle}"
      class="cr-centered-card-container">
    <div class="cr-row first">
      <div class="flex cr-padded-text">
        <div id="locationLabel" aria-hidden="true">
          $i18n{downloadLocation}
        </div>
        <div class="secondary" id="defaultDownloadPath" aria-hidden="true">

          [[prefs.download.default_directory.value]]


        </div>
      </div>
      <div class="separator"></div>
      <controlled-button id="changeDownloadsPath"
          label="$i18n{changeDownloadLocation}"
          aria-labelledby="locationLabel defaultDownloadPath"
          on-click="selectDownloadLocation_"
          pref="[[prefs.download.default_directory]]"
          end-justified>
      </controlled-button>
    </div>
    <settings-toggle-button
        class="hr"
        pref="{{prefs.download.prompt_for_download}}"
        label="$i18n{promptForDownload}">
    </settings-toggle-button>
    <template is="dom-if" if="[[autoOpenDownloads_]]" restamp>
      <div class="cr-row">
        <div class="flex">$i18n{openFileTypesAutomatically}</div>
        <div class="separator"></div>
        <cr-button id="resetAutoOpenFileTypes"
            on-click="onClearAutoOpenFileTypesClick_">
          $i18n{clear}
        </cr-button>
      </div>
    </template>
    <template is="dom-if" if="[[downloadBubblePartialViewControlledByPref_]]">
      <settings-toggle-button id="showDownloadsToggle"
          class="hr"
          pref="{{prefs.download_bubble.partial_view_enabled}}"
          label="$i18n{showDownloadsWhenFinished}">
      </settings-toggle-button>
    </template>
  </settings-section>
<!--_html_template_end_-->`}const SettingsDownloadsPageElementBase=WebUiListenerMixin(PrefsMixin(PolymerElement));class SettingsDownloadsPageElement extends SettingsDownloadsPageElementBase{static get is(){return"settings-downloads-page"}static get template(){return getTemplate$9()}static get properties(){return{autoOpenDownloads_:{type:Boolean,value:false},downloadBubblePartialViewControlledByPref_:{type:Boolean,value(){return loadTimeData.getBoolean("downloadBubblePartialViewControlledByPref")}}}}browserProxy_=DownloadsBrowserProxyImpl.getInstance();ready(){super.ready();this.addWebUiListener("auto-open-downloads-changed",(autoOpen=>{this.autoOpenDownloads_=autoOpen}));this.browserProxy_.initializeDownloads()}selectDownloadLocation_(){this.browserProxy_.selectDownloadLocation()}onClearAutoOpenFileTypesClick_(){this.browserProxy_.resetAutoOpenFileTypes()}async searchContents(query){const searchRequest=await getSearchManager().search(query,this);return searchRequest.getSearchResult()}}customElements.define(SettingsDownloadsPageElement.is,SettingsDownloadsPageElement);function getTemplate$8(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared action-link">cr-action-menu.complex .dropdown-item{min-height:36px}cr-action-menu:not(.complex) hr{display:none}cr-action-menu.complex hr{border:none;border-top:var(--cr-separator-line);margin:6px 0 0 0}div.list-item.non-target .target-info{display:none}div.list-item.target~div.list-item.target .target-info{display:none}#languagesSectionHeader{padding-bottom:12px;padding-top:12px}

</style>
<settings-section page-title="$i18n{languagesCardTitle}">
<div id="languagesSection">
  <div class="cr-row continuation">
    <div id="languagesSectionHeader" class="flex">
      <div>$i18n{preferredLanguagesHeader}</div>
      <div class="secondary">$i18n{preferredLanguagesDesc}</div>
    </div>
    <cr-button id="addLanguages" class="cr-button-gap header-aligned-button"
        disabled="[[!canEnableSomeSupportedLanguage_(languages)]]"
        on-click="onAddLanguagesClick_">
      $i18n{addLanguages}
    </cr-button>
  </div>
  <div class="list-frame vertical-list" role="list">
    <template is="dom-repeat" items="[[languages.enabled]]">
      <div class$="list-item [[getLanguageItemClass_(
          item.language.code, language.prospectiveUILanguage)]]
          [[isTranslationTarget_(item.language.code,
          languages.translateTarget)]]" role="listitem">
        <div class="start cr-padded-text">
          <div title="[[item.language.nativeDisplayName]]" role="none">
            [[formatIndex_(index)]]. [[item.language.displayName]]
          </div>
          <div class="target-info secondary">
            $i18n{translateTargetLabel}
          </div>
 <!-- is_win -->
        </div>
 <!-- is_win -->
        <cr-icon-button class="icon-more-vert"
            title="$i18n{moreActions}"
            id="more-[[item.language.code]]"
            on-click="onDotsClick_">
        </cr-icon-button>
      </div>
    </template>
  </div>
  <cr-lazy-render id="menu">
    <template>
      <cr-action-menu role-description="$i18n{menu}"

          >
 <!-- is_win -->
        <button class="dropdown-item" role="menuitem"
            on-click="onMoveToTopClick_"
            hidden="[[isNthLanguage_(
                0, detailLanguage_, languages.enabled.*)]]">
          $i18n{moveToTop}
        </button>
        <button class="dropdown-item" role="menuitem"
            on-click="onMoveUpClick_"
            hidden="[[!showMoveUp_(detailLanguage_, languages.enabled.*)]]">
          $i18n{moveUp}
        </button>
        <button class="dropdown-item" role="menuitem"
            on-click="onMoveDownClick_"
            hidden="[[!showMoveDown_(
                detailLanguage_, languages.enabled.*)]]">
          $i18n{moveDown}
        </button>
        <button class="dropdown-item" role="menuitem"
            on-click="onRemoveLanguageClick_"
            disabled="[[!detailLanguage_.removable]]">
          $i18n{removeLanguage}
        </button>
      </cr-action-menu>
    </template>
  </cr-lazy-render>
</div>
<template is="dom-if" if="[[showAddLanguagesDialog_]]" restamp>
  <settings-add-languages-dialog languages="[[addLanguagesDialogLanguages_]]"
      on-languages-added="onLanguagesAdded_"
      on-close="onAddLanguagesDialogClose_">
  </settings-add-languages-dialog>
</template>
<template is="dom-if" if="[[showManagedLanguageDialog_]]" restamp>
  <managed-dialog on-close="onManagedLanguageDialogClosed_"
      title="[[i18n('languageManagedDialogTitle')]]"
      body="[[i18n('languageManagedDialogBody')]]">
  </managed-dialog>
</template>
<template is="dom-if" if="[[shouldShowRelaunchDialog]]" restamp>
  <relaunch-confirmation-dialog restart-type="[[restartTypeEnum.RESTART]]"
      on-close="onRelaunchDialogClose">
  </relaunch-confirmation-dialog>
</template>
</settings-section>
<!--_html_template_end_-->`}var LanguageSettingsActionType;(function(LanguageSettingsActionType){LanguageSettingsActionType[LanguageSettingsActionType["LANGUAGE_ADDED"]=2]="LANGUAGE_ADDED";LanguageSettingsActionType[LanguageSettingsActionType["LANGUAGE_REMOVED"]=3]="LANGUAGE_REMOVED";LanguageSettingsActionType[LanguageSettingsActionType["DISABLE_TRANSLATE_GLOBALLY"]=4]="DISABLE_TRANSLATE_GLOBALLY";LanguageSettingsActionType[LanguageSettingsActionType["ENABLE_TRANSLATE_GLOBALLY"]=5]="ENABLE_TRANSLATE_GLOBALLY";LanguageSettingsActionType[LanguageSettingsActionType["DISABLE_TRANSLATE_FOR_SINGLE_LANGUAGE"]=6]="DISABLE_TRANSLATE_FOR_SINGLE_LANGUAGE";LanguageSettingsActionType[LanguageSettingsActionType["ENABLE_TRANSLATE_FOR_SINGLE_LANGUAGE"]=7]="ENABLE_TRANSLATE_FOR_SINGLE_LANGUAGE";LanguageSettingsActionType[LanguageSettingsActionType["LANGUAGE_LIST_REORDERED"]=8]="LANGUAGE_LIST_REORDERED";LanguageSettingsActionType[LanguageSettingsActionType["CHANGE_CHROME_LANGUAGE"]=9]="CHANGE_CHROME_LANGUAGE";LanguageSettingsActionType[LanguageSettingsActionType["CHANGE_TRANSLATE_TARGET"]=10]="CHANGE_TRANSLATE_TARGET";LanguageSettingsActionType[LanguageSettingsActionType["REMOVE_FROM_NEVER_TRANSLATE"]=11]="REMOVE_FROM_NEVER_TRANSLATE";LanguageSettingsActionType[LanguageSettingsActionType["ADD_TO_NEVER_TRANSLATE"]=12]="ADD_TO_NEVER_TRANSLATE";LanguageSettingsActionType[LanguageSettingsActionType["REMOVE_FROM_ALWAYS_TRANSLATE"]=13]="REMOVE_FROM_ALWAYS_TRANSLATE";LanguageSettingsActionType[LanguageSettingsActionType["ADD_TO_ALWAYS_TRANSLATE"]=14]="ADD_TO_ALWAYS_TRANSLATE";LanguageSettingsActionType[LanguageSettingsActionType["REMOVE_FROM_NEVER_TRANSLATE_SITES"]=15]="REMOVE_FROM_NEVER_TRANSLATE_SITES";LanguageSettingsActionType[LanguageSettingsActionType["RESTART_FOR_SPLIT_INSTALL"]=16]="RESTART_FOR_SPLIT_INSTALL";LanguageSettingsActionType[LanguageSettingsActionType["ENABLE_SPELL_CHECK_GLOBALLY"]=17]="ENABLE_SPELL_CHECK_GLOBALLY";LanguageSettingsActionType[LanguageSettingsActionType["DISABLE_SPELL_CHECK_GLOBALLY"]=18]="DISABLE_SPELL_CHECK_GLOBALLY";LanguageSettingsActionType[LanguageSettingsActionType["ENABLE_SPELL_CHECK_FOR_LANGUAGE"]=19]="ENABLE_SPELL_CHECK_FOR_LANGUAGE";LanguageSettingsActionType[LanguageSettingsActionType["DISABLE_SPELL_CHECK_FOR_LANGUAGE"]=20]="DISABLE_SPELL_CHECK_FOR_LANGUAGE";LanguageSettingsActionType[LanguageSettingsActionType["SELECT_BASIC_SPELL_CHECK"]=21]="SELECT_BASIC_SPELL_CHECK";LanguageSettingsActionType[LanguageSettingsActionType["SELECT_ENHANCED_SPELL_CHECK"]=22]="SELECT_ENHANCED_SPELL_CHECK"})(LanguageSettingsActionType||(LanguageSettingsActionType={}));var LanguageSettingsPageImpressionType;(function(LanguageSettingsPageImpressionType){LanguageSettingsPageImpressionType[LanguageSettingsPageImpressionType["MAIN"]=0]="MAIN";LanguageSettingsPageImpressionType[LanguageSettingsPageImpressionType["ADD_LANGUAGE"]=1]="ADD_LANGUAGE";LanguageSettingsPageImpressionType[LanguageSettingsPageImpressionType["CHROME_LANGUAGE"]=3]="CHROME_LANGUAGE";LanguageSettingsPageImpressionType[LanguageSettingsPageImpressionType["ADVANCED_LANGUAGE_SETTINGS"]=4]="ADVANCED_LANGUAGE_SETTINGS";LanguageSettingsPageImpressionType[LanguageSettingsPageImpressionType["TARGET_LANGUAGE"]=5]="TARGET_LANGUAGE";LanguageSettingsPageImpressionType[LanguageSettingsPageImpressionType["LANGUAGE_OVERFLOW_MENU_OPENED"]=6]="LANGUAGE_OVERFLOW_MENU_OPENED"})(LanguageSettingsPageImpressionType||(LanguageSettingsPageImpressionType={}));class LanguageSettingsMetricsProxyImpl{recordSettingsMetric(interaction){chrome.metricsPrivate.recordEnumerationValue("LanguageSettings.Actions",interaction,Object.keys(LanguageSettingsActionType).length)}recordPageImpressionMetric(interaction){chrome.metricsPrivate.recordEnumerationValue("LanguageSettings.PageImpression",interaction,Object.keys(LanguageSettingsPageImpressionType).length)}static getInstance(){return instance$2||(instance$2=new LanguageSettingsMetricsProxyImpl)}static setInstance(obj){instance$2=obj}}let instance$2=null;const kMenuCloseDelay=100;const SettingsLanguagesPageElementBase=RouteObserverMixin(RelaunchMixin(I18nMixin(PrefsMixin(PolymerElement))));class SettingsLanguagesPageElement extends SettingsLanguagesPageElementBase{static get is(){return"settings-languages-page"}static get template(){return getTemplate$8()}static get properties(){return{languages:Object,detailLanguage_:Object,showAddLanguagesDialog_:Boolean,addLanguagesDialogLanguages_:Array,showManagedLanguageDialog_:{type:Boolean,value:false}}}languageHelper_;languageSettingsMetricsProxy_=LanguageSettingsMetricsProxyImpl.getInstance();connectedCallback(){super.connectedCallback();this.languageHelper_=getLanguageHelperInstance()}onAddLanguagesClick_(e){e.preventDefault();assert(this.languages);this.languageSettingsMetricsProxy_.recordPageImpressionMetric(LanguageSettingsPageImpressionType.ADD_LANGUAGE);this.addLanguagesDialogLanguages_=this.languages.supported.filter((language=>this.languageHelper_.canEnableLanguage(language)));this.showAddLanguagesDialog_=true}onLanguagesAdded_(e){const languagesToAdd=e.detail;languagesToAdd.forEach((languageCode=>{this.languageHelper_.enableLanguage(languageCode);LanguageSettingsMetricsProxyImpl.getInstance().recordSettingsMetric(LanguageSettingsActionType.LANGUAGE_ADDED)}))}onAddLanguagesDialogClose_(){this.showAddLanguagesDialog_=false;this.addLanguagesDialogLanguages_=null;const toFocus=this.shadowRoot.querySelector("#addLanguages");assert(toFocus);focusWithoutInk(toFocus)}formatIndex_(index){return(index+1).toLocaleString()}canEnableSomeSupportedLanguage_(languages){return languages!==undefined&&languages.supported.some((language=>getLanguageHelperInstance().canEnableLanguage(language)))}isNthLanguage_(n){if(this.languages===undefined||this.detailLanguage_===undefined){return false}if(n>=this.languages.enabled.length){return false}const compareLanguage=this.languages.enabled[n];return this.detailLanguage_.language===compareLanguage.language}showMoveUp_(){return!this.isNthLanguage_(0)&&!this.isNthLanguage_(1)}showMoveDown_(){return this.languages!==undefined&&!this.isNthLanguage_(this.languages.enabled.length-1)}isTranslationTarget_(languageCode,translateTarget){if(convertLanguageCodeForTranslate(languageCode)===translateTarget){return"target"}else{return"non-target"}}onMoveToTopClick_(){this.$.menu.get().close();if(this.detailLanguage_.isForced){this.showManagedLanguageDialog_=true;return}this.languageHelper_.moveLanguageToFront(this.detailLanguage_.language.code);this.languageSettingsMetricsProxy_.recordSettingsMetric(LanguageSettingsActionType.LANGUAGE_LIST_REORDERED)}onMoveUpClick_(){this.$.menu.get().close();if(this.detailLanguage_.isForced){this.showManagedLanguageDialog_=true;return}this.languageHelper_.moveLanguage(this.detailLanguage_.language.code,true);this.languageSettingsMetricsProxy_.recordSettingsMetric(LanguageSettingsActionType.LANGUAGE_LIST_REORDERED)}onMoveDownClick_(){this.$.menu.get().close();if(this.detailLanguage_.isForced){this.showManagedLanguageDialog_=true;return}this.languageHelper_.moveLanguage(this.detailLanguage_.language.code,false);this.languageSettingsMetricsProxy_.recordSettingsMetric(LanguageSettingsActionType.LANGUAGE_LIST_REORDERED)}onRemoveLanguageClick_(){this.$.menu.get().close();if(this.detailLanguage_.isForced){this.showManagedLanguageDialog_=true;return}this.languageHelper_.disableLanguage(this.detailLanguage_.language.code);this.languageSettingsMetricsProxy_.recordSettingsMetric(LanguageSettingsActionType.LANGUAGE_REMOVED)}getLanguageItemClass_(languageCode,prospectiveUILanguage){if(isWindows&&languageCode===prospectiveUILanguage){return"selected"}return""}onDotsClick_(e){this.detailLanguage_=Object.assign({},e.model.item);this.$.menu.get().showAt(e.target);this.languageSettingsMetricsProxy_.recordPageImpressionMetric(LanguageSettingsPageImpressionType.LANGUAGE_OVERFLOW_MENU_OPENED)}closeMenuSoon_(){const menu=this.$.menu.get();setTimeout((function(){if(menu.open){menu.close()}}),kMenuCloseDelay)}onManagedLanguageDialogClosed_(){this.showManagedLanguageDialog_=false}currentRouteChanged(currentRoute){if(currentRoute===routes.LANGUAGES){this.languageSettingsMetricsProxy_.recordPageImpressionMetric(LanguageSettingsPageImpressionType.MAIN)}}}customElements.define(SettingsLanguagesPageElement.is,SettingsLanguagesPageElement);function getTemplate$7(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared action-link">.name-with-error-list{padding:14px 0}.name-with-error-list div{color:var(--google-red-500);margin-top:8px}@media (prefers-color-scheme:dark){.name-with-error-list div{color:var(--settings-error-color)}}cr-icon[icon='cr:error']{--iron-icon-fill-color:var(--settings-error-color);height:var(--cr-icon-size);margin-inline-end:8px;width:var(--cr-icon-size)}.name-with-error-list[disabled]{pointer-events:none}cr-policy-pref-indicator{margin-inline-end:var(--cr-controlled-by-spacing)}.spell-check-radio-group{padding-block-end:var(--cr-section-vertical-padding)}.spell-check-radio-button{--cr-radio-button-label-spacing:calc(var(--cr-section-indent-width) - var(--cr-radio-button-size))}.spell-check-radio-button.enhanced{align-items:start;--cr-radio-button-disc-margin-block-start:calc((1.5em - var(--cr-radio-button-size)) / 2)}.enhanced-spellcheck-description{padding-inline-end:150px}.spell-check-languages .list-item:last-of-type{border-bottom:var(--cr-separator-line)}</style>
<settings-section page-title="$i18n{spellCheckTitle}">
  <div route-path="default">
    <settings-toggle-button id="enableSpellcheckingToggle" class="hr"
        label="$i18n{offerToEnableSpellCheck}"
        sub-label="[[getSpellCheckSubLabel_(spellCheckLanguages_)]]"
        pref="{{prefs.browser.enable_spellchecking}}"
        disabled="[[!spellCheckLanguages_.length]]"
        on-settings-boolean-control-change="onSpellCheckToggleChange_">
    </settings-toggle-button>
 <!-- _google_chrome or not is_macosx -->
  </div>
</settings-section>
<!--_html_template_end_-->`}const SettingsSpellCheckPageElementBase=SettingsViewMixin(I18nMixin(PrefsMixin(BaseMixin(PolymerElement))));class SettingsSpellCheckPageElement extends SettingsSpellCheckPageElementBase{static get is(){return"settings-spell-check-page"}static get template(){return getTemplate$7()}static get properties(){return{languages:Object,hideSpellCheckLanguages_:{type:Boolean,value:false}}}languageHelper_;languageSettingsMetricsProxy_=LanguageSettingsMetricsProxyImpl.getInstance();connectedCallback(){super.connectedCallback();this.languageHelper_=getLanguageHelperInstance()}onSpellCheckToggleChange_(e){this.languageSettingsMetricsProxy_.recordSettingsMetric(e.target.checked?LanguageSettingsActionType.ENABLE_SPELL_CHECK_GLOBALLY:LanguageSettingsActionType.DISABLE_SPELL_CHECK_GLOBALLY)}onSelectedSpellingServiceChange_(){this.languageSettingsMetricsProxy_.recordSettingsMetric(this.prefs.spellcheck.use_spelling_service.value?LanguageSettingsActionType.SELECT_ENHANCED_SPELL_CHECK:LanguageSettingsActionType.SELECT_BASIC_SPELL_CHECK)}getSpellCheckSubLabel_(){return undefined}toggleExpandButton_(e){if(e.target.tagName==="CR-EXPAND-BUTTON"){return}if(!e.currentTarget.hasAttribute("actionable")){return}const expandButton=e.currentTarget.querySelector("cr-expand-button");assert(expandButton);expandButton.expanded=!expandButton.expanded;focusWithoutInk(expandButton)}getAssociatedControlFor(childViewId){assert(childViewId==="editDictionary");const control=this.shadowRoot.querySelector("#spellCheckSubpageTrigger");assert(control);return control}}customElements.define(SettingsSpellCheckPageElement.is,SettingsSpellCheckPageElement);function getTemplate$6(){return html`<!--_html_template_start_--><style include="settings-shared">cr-view-manager [hidden-by-search],cr-view-manager[show-all] [slot=view][data-parent-view-id]{display:none}cr-view-manager [slot=view]:not(.closing){position:initial}</style>

<cr-view-manager id="viewManager" class="cr-centered-card-container"
    show-all$="[[shouldShowAll]]">
  <settings-languages-page slot="view" id="languages" prefs="{{prefs}}"
      languages="[[languages]]" route-path$="[[routes_.LANGUAGES.path]]">
  </settings-languages-page>

  <settings-spell-check-page slot="view" id="spellCheck" prefs="{{prefs}}"
      languages="[[languages]]" route-path$="[[routes_.SPELL_CHECK.path]]">
  </settings-spell-check-page>


</cr-view-manager>
<!--_html_template_end_-->`}const SettingsLanguagesPageIndexElementBase=SearchableViewContainerMixin(RouteObserverMixin(PolymerElement));class SettingsLanguagesPageIndexElement extends SettingsLanguagesPageIndexElementBase{static get is(){return"settings-languages-page-index"}static get template(){return getTemplate$6()}static get properties(){return{prefs:Object,languages:Object,routes_:{type:Object,value:()=>routes}}}showDefaultViews_(){this.$.viewManager.switchViews(["languages","spellCheck"],"no-animation","no-animation")}currentRouteChanged(newRoute,oldRoute){super.currentRouteChanged(newRoute,oldRoute);queueMicrotask((()=>{switch(newRoute){case routes.LANGUAGES:this.showDefaultViews_();break;case routes.BASIC:this.showDefaultViews_();break}}))}}customElements.define(SettingsLanguagesPageIndexElement.is,SettingsLanguagesPageIndexElement);function getTemplate$5(){return html`<!--_html_template_start_-->    <style include="settings-shared action-link cr-spinner-style">.spinner{margin:0 8px}#dialog-body{padding-bottom:2px}
    </style>
    <cr-dialog id="dialog" close-text="$i18n{close}"
        ignore-popstate ignore-enter-key>
      <div slot="title">
        [[getPageTitle_(isTriggered_, triggeredResetToolName_)]]
      </div>
      <div id="dialog-body" slot="body">
        <span inner-h-t-m-l="[[getExplanationText_(
              isTriggered_, triggeredResetToolName_)]]">
        </span>
        <a href="$i18nRaw{resetPageLearnMoreUrl}"
            aria-label="$i18n{resetLearnMoreAccessibilityText}"
            target="_blank">$i18n{learnMore}</a>
      </div>
      <div slot="button-container">
        <div class="spinner" hidden$="[[!clearingInProgress_]]"></div>
        <cr-button class="cancel-button" on-click="onCancelClick_"
            id="cancel" disabled="[[clearingInProgress_]]">
          $i18n{cancel}
        </cr-button>
        <cr-button class="action-button" on-click="onResetClick_"
            id="reset" disabled="[[clearingInProgress_]]">
          $i18n{resetDialogCommit}
        </cr-button>
      </div>
      <div slot="footer">
        <cr-checkbox id="sendSettings" checked>
          $i18nRaw{resetPageFeedback}</cr-checkbox>
      </div>
    </cr-dialog>
<!--_html_template_end_-->`}const SettingsResetProfileDialogElementBase=I18nMixin(PolymerElement);class SettingsResetProfileDialogElement extends SettingsResetProfileDialogElementBase{static get is(){return"settings-reset-profile-dialog"}static get template(){return getTemplate$5()}static get properties(){return{isTriggered_:{type:Boolean,value:false},triggeredResetToolName_:{type:String,value:""},resetRequestOrigin_:String,clearingInProgress_:{type:Boolean,value:false}}}browserProxy_=ResetBrowserProxyImpl.getInstance();getExplanationText_(){if(this.isTriggered_){return this.i18nAdvanced("triggeredResetPageExplanation",{substitutions:[this.triggeredResetToolName_]})}if(loadTimeData.getBoolean("showExplanationWithBulletPoints")){return this.i18nAdvanced("resetPageExplanationBulletPoints",{tags:["LINE_BREAKS","LINE_BREAK"]})}return this.i18nAdvanced("resetPageExplanation")}getPageTitle_(){if(this.isTriggered_){return loadTimeData.getStringF("triggeredResetPageTitle",this.triggeredResetToolName_)}return loadTimeData.getStringF("resetDialogTitle")}ready(){super.ready();this.addEventListener("cancel",(()=>{this.browserProxy_.onHideResetProfileDialog()}));this.shadowRoot.querySelector("cr-checkbox a").addEventListener("click",this.onShowReportedSettingsClick_.bind(this))}showDialog_(){if(!this.$.dialog.open){this.$.dialog.showModal()}this.browserProxy_.onShowResetProfileDialog()}show(){this.isTriggered_=Router.getInstance().getCurrentRoute()===routes.TRIGGERED_RESET_DIALOG;if(this.isTriggered_){this.browserProxy_.getTriggeredResetToolName().then((name=>{this.resetRequestOrigin_="triggeredreset";this.triggeredResetToolName_=name;this.showDialog_()}))}else{this.resetRequestOrigin_=Router.getInstance().getQueryParameters().get("origin")||"";this.showDialog_()}}onCancelClick_(){this.cancel()}cancel(){if(this.$.dialog.open){this.$.dialog.cancel()}}onResetClick_(){this.clearingInProgress_=true;this.browserProxy_.performResetProfileSettings(this.$.sendSettings.checked,this.resetRequestOrigin_).then((()=>{this.clearingInProgress_=false;if(this.$.dialog.open){this.$.dialog.close()}this.dispatchEvent(new CustomEvent("reset-done",{bubbles:true,composed:true}))}))}onShowReportedSettingsClick_(e){this.browserProxy_.showReportedSettings();e.stopPropagation()}}customElements.define(SettingsResetProfileDialogElement.is,SettingsResetProfileDialogElement);function getTemplate$4(){return html`<!--_html_template_start_--><style include="settings-shared"></style>
<settings-section page-title="$i18n{resetPageTitle}"
    class="cr-centered-card-container">
  <cr-link-row id="resetProfile" label="$i18n{resetTrigger}"
      on-click="onShowResetProfileDialog_"></cr-link-row>
  <!-- Keep a single instance of reset-profile-dialog on purpose, to
    preserve state across show/hide operations. -->
  <cr-lazy-render id="resetProfileDialog">
    <template>
      <settings-reset-profile-dialog on-close="onResetProfileDialogClose_">
      </settings-reset-profile-dialog>
    </template>
  </cr-lazy-render>
</settings-section>
<!--_html_template_end_-->`}const SettingsResetPageElementBase=RouteObserverMixin(PolymerElement);class SettingsResetPageElement extends SettingsResetPageElementBase{static get is(){return"settings-reset-page"}static get template(){return getTemplate$4()}currentRouteChanged(route){const lazyRender=this.$.resetProfileDialog;if(route===routes.TRIGGERED_RESET_DIALOG||route===routes.RESET_DIALOG){lazyRender.get().show()}else{const dialog=lazyRender.getIfExists();if(dialog){dialog.cancel()}}}onShowResetProfileDialog_(){Router.getInstance().navigateTo(routes.RESET_DIALOG,new URLSearchParams("origin=userclick"))}onResetProfileDialogClose_(){Router.getInstance().navigateTo(routes.RESET_DIALOG.parent);focusWithoutInk(this.$.resetProfile)}async searchContents(query){const searchRequest=await getSearchManager().search(query,this);return searchRequest.getSearchResult()}}customElements.define(SettingsResetPageElement.is,SettingsResetPageElement);function getTemplate$3(){return html`<!--_html_template_start_-->  <style include="cr-shared-style settings-shared">.proxy-multisource-padding{margin-inline-start:36px}#proxy-single-source-container{display:flex;flex:1}
  </style>
  <settings-section page-title="$i18n{systemPageTitle}"
      class="cr-centered-card-container">

    <settings-toggle-button id="hardwareAcceleration"
        pref="{{prefs.hardware_acceleration_mode.enabled}}"
        label="$i18n{hardwareAccelerationLabel}">
      <template is="dom-if" if="[[shouldShowRestart_(
          prefs.hardware_acceleration_mode.enabled.value)]]">
        <cr-button on-click="onRestartClick_" slot="more-actions">
          $i18n{restart}
        </cr-button>
      </template>
    </settings-toggle-button>

    <!--  -->

    <div id="proxy" class="cr-row" on-click="onProxyClick_"
        actionable$="[[isProxyDefault_]]">
      <div id="proxy-single-source-container"
          hidden$="[[isProxyEnforcedByMultipleSources_]]">
        <div class="flex cr-row-text" hidden$="[[!isProxyDefault_]]">
          $i18n{proxySettingsLabel}
        </div>
        <div class="flex cr-row-text"
            hidden$="[[!prefs.proxy.extensionId]]">
          $i18n{proxySettingsExtensionLabel}
        </div>
        <div class="flex cr-row-text"
            hidden$="[[!isProxyEnforcedByPolicy_]]">
          $i18n{proxySettingsPolicyLabel}
        </div>
        <cr-icon-button class="icon-external"
            hidden$="[[!isProxyDefault_]]"
            aria-label="$i18n{proxySettingsLabel}"></cr-icon-button>
        <template is="dom-if" if="[[isProxyEnforcedByPolicy_]]">
          <cr-policy-pref-indicator pref="[[prefs.proxy]]"
              icon-aria-label="$i18n{proxySettingsLabel}">
          </cr-policy-pref-indicator>
        </template>
      </div>
      <div id="proxyMultipleSourcesLabel"
          hidden$="[[!isProxyEnforcedByMultipleSources_]]">
        $i18n{proxySettingsMultipleSourcesLabel}
      </div>
    </div>
    <div id="proxyMultipleSources"
        hidden$="[[!isProxyEnforcedByMultipleSources_]]">
      <div id="proxyDeviceSettings" class="cr-row continuation"
          hidden$="[[!isProxyDefault_]]" on-click="onProxyClick_"
          actionable$="[[isProxyDefault_]]">
        <div class="flex cr-row-text proxy-multisource-padding">
          $i18n{proxySettingsYourDevice}
        </div>
        <cr-icon-button class="icon-external"
            hidden$="[[!isProxyDefault_]]"
            aria-label="$i18n{proxySettingsLabel}"></cr-icon-button>
      </div>
      <div class="cr-row continuation">
        <div class="flex cr-row-text proxy-multisource-padding">
          $i18n{proxySettingsYourOrganization}
        </div>
        <cr-policy-pref-indicator pref="[[prefs.proxy_override_rules]]"
            icon-aria-label="$i18n{proxySettingsLabel}">
        </cr-policy-pref-indicator>
      </div>
    </div>
    <template is="dom-if" if="[[prefs.proxy.extensionId]]">
      <div class="cr-row continuation">
        <extension-controlled-indicator class="flex"
            extension-id="[[prefs.proxy.extensionId]]"
            extension-name="[[prefs.proxy.controlledByName]]"
            extension-name-only-in-label="[[isProxyEnforcedByMultipleSources_]]"
            extension-can-be-disabled="[[prefs.proxy.extensionCanBeDisabled]]"
            on-extension-disable="onExtensionDisable_">
        </extension-controlled-indicator>
      </div>
    </template>

    <template is="dom-if" if="[[shouldShowRelaunchDialog]]" restamp>
      <relaunch-confirmation-dialog restart-type="[[restartTypeEnum.RESTART]]"
          on-close="onRelaunchDialogClose"></relaunch-confirmation-dialog>
    </template>
  </settings-section>
<!--_html_template_end_-->`}class SystemPageBrowserProxyImpl{showProxySettings(){chrome.send("showProxySettings")}wasHardwareAccelerationEnabledAtStartup(){return loadTimeData.getBoolean("hardwareAccelerationEnabledAtStartup")}static getInstance(){return instance$1||(instance$1=new SystemPageBrowserProxyImpl)}static setInstance(obj){instance$1=obj}}let instance$1=null;const SettingsSystemPageElementBase=RelaunchMixin(PolymerElement);class SettingsSystemPageElement extends SettingsSystemPageElementBase{static get is(){return"settings-system-page"}static get template(){return getTemplate$3()}static get properties(){return{prefs:{type:Object,notify:true},isProxyEnforcedByPolicy_:Boolean,isProxyDefault_:Boolean,isProxyEnforcedByMultipleSources_:Boolean}}static get observers(){return["observeProxyPrefChanged_(prefs.proxy.*)","observeProxyPrefChanged_(prefs.proxy_override_rules.*)"]}observeProxyPrefChanged_(){const pref=this.prefs.proxy;this.isProxyEnforcedByPolicy_=pref.enforcement===chrome.settingsPrivate.Enforcement.ENFORCED&&pref.controlledBy===chrome.settingsPrivate.ControlledBy.USER_POLICY;this.isProxyDefault_=!this.isProxyEnforcedByPolicy_&&!pref.extensionId;this.isProxyEnforcedByMultipleSources_=this.prefs.proxy_override_rules&&this.prefs.proxy_override_rules.value&&this.prefs.proxy_override_rules.value.length!==0&&!this.isProxyEnforcedByPolicy_}onExtensionDisable_(){this.dispatchEvent(new CustomEvent("refresh-pref",{bubbles:true,composed:true,detail:"proxy"}))}onProxyClick_(){if(this.isProxyDefault_){SystemPageBrowserProxyImpl.getInstance().showProxySettings()}}onRestartClick_(e){e.stopPropagation();this.performRestart(RestartType.RESTART)}shouldShowRestart_(enabled){const proxy=SystemPageBrowserProxyImpl.getInstance();return enabled!==proxy.wasHardwareAccelerationEnabledAtStartup()}async searchContents(query){const searchRequest=await getSearchManager().search(query,this);return searchRequest.getSearchResult()}}customElements.define(SettingsSystemPageElement.is,SettingsSystemPageElement);function getTemplate$2(){return html`<!--_html_template_start_--><style include="your-saved-info-shared">.card{overflow:hidden}
</style>
<settings-subpage page-title="$i18n{identityDocsCardTitle}"
    class="multi-card">

  <div class="card">
    <settings-toggle-button id="optInToggle"
        disabled="[[optInToggleDisabled_(
            enhancedAutofillEligibleUser_, enhancedAutofillOptedIn_,
            autofillAiIgnoresWhetherAddressFillingIsEnabled_,
            prefs.autofill.profile_enabled.value)]]"
        on-settings-boolean-control-change="onOptInToggleChange_"
        pref="[[identityDocsOptedIn_]]"
        no-extension-indicator
        label="$i18n{identityDocsOptInToggleLabel}"
        sub-label="$i18n{identityDocsOptInToggleSubLabel}">
  </div>

  <!-- Entities list card -->
  <div class="card">
    <settings-autofill-ai-entries-list
        list-title="$i18n{identityDocsCardTitle}"
        allowed-entity-types="[[getAllowedEntityTypes_()]]"
        allow-editing-pref="[[
            prefs.autofill.autofill_ai.identity_entities_enabled]]"
        prefs="{{prefs}}">
    </settings-autofill-ai-entries-list>
  </div>

</settings-subpage>
<!--_html_template_end_-->`}const SettingsIdentityDocsPageElementBase=SettingsViewMixin(PrefsMixin(PolymerElement));class SettingsIdentityDocsPageElement extends SettingsIdentityDocsPageElementBase{static get is(){return"settings-identity-docs-page"}static get template(){return getTemplate$2()}static get properties(){return{enhancedAutofillEligibleUser_:{type:Boolean,value(){return loadTimeData.getBoolean("userEligibleForAutofillAi")}},enhancedAutofillOptedIn_:{type:Boolean,value:false},identityDocsOptedIn_:{type:Object,computed:"computeIdentityDocsOptedIn_(enhancedAutofillEligibleUser_, "+"enhancedAutofillOptedIn_, "+"prefs.autofill.autofill_ai.identity_entities_enabled, "+"prefs.autofill.profile_enabled.value)"},autofillAiIgnoresWhetherAddressFillingIsEnabled_:{type:Boolean,value(){return loadTimeData.getBoolean("AutofillAiIgnoresWhetherAddressFillingIsEnabled")}}}}static get observers(){return["onAutofillOptInStatusChange_(prefs.autofill.autofill_ai.opt_in_status)"]}entityDataManager_=EntityDataManagerProxyImpl.getInstance();connectedCallback(){super.connectedCallback()}optInToggleDisabled_(){const addressAutofillOptInStatus=this.getPref("autofill.profile_enabled").value;const ignoreAddressAutofill=this.autofillAiIgnoresWhetherAddressFillingIsEnabled_;const optInToggleEnabled=this.enhancedAutofillEligibleUser_&&this.enhancedAutofillOptedIn_&&(ignoreAddressAutofill||addressAutofillOptInStatus);return!optInToggleEnabled}onAutofillOptInStatusChange_(){this.entityDataManager_.getOptInStatus().then((status=>{this.set("enhancedAutofillOptedIn_",status)}))}computeIdentityDocsOptedIn_(){const fakePref={key:"fake",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:this.getPref("autofill.autofill_ai.identity_entities_enabled").value};if(this.optInToggleDisabled_()){fakePref.value=false}return fakePref}onOptInToggleChange_(){this.setPrefValue("autofill.autofill_ai.identity_entities_enabled",this.$.optInToggle.checked)}getAllowedEntityTypes_(){return new Set([EntityTypeName.kDriversLicense,EntityTypeName.kNationalIdCard,EntityTypeName.kPassport])}}customElements.define(SettingsIdentityDocsPageElement.is,SettingsIdentityDocsPageElement);function getTemplate$1(){return html`<!--_html_template_start_--><style include="your-saved-info-shared">.card{overflow:hidden}
</style>
<settings-subpage page-title="$i18n{travelCardTitle}" class="multi-card">

  <div class="card">
    <settings-toggle-button id="optInToggle"
        disabled="[[optInToggleDisabled_(
            enhancedAutofillEligibleUser_, enhancedAutofillOptedIn_,
            autofillAiIgnoresWhetherAddressFillingIsEnabled_,
            prefs.autofill.profile_enabled.value)]]"
        on-settings-boolean-control-change="onOptInToggleChange_"
        pref="[[travelOptedIn_]]"
        no-extension-indicator
        label="$i18n{travelOptInToggleLabel}"
        sub-label="$i18n{travelOptInToggleSubLabel}">
  </div>

  <!-- Entities list card -->
  <div class="card">
    <settings-autofill-ai-entries-list
        list-title="$i18n{travelCardTitle}"
        allowed-entity-types="[[getAllowedEntityTypes_()]]"
        allow-editing-pref="[[
            prefs.autofill.autofill_ai.travel_entities_enabled]]"
        prefs="{{prefs}}">
    </settings-autofill-ai-entries-list>
  </div>

</settings-subpage>
<!--_html_template_end_-->`}const SettingsTravelPageElementBase=SettingsViewMixin(PrefsMixin(PolymerElement));class SettingsTravelPageElement extends SettingsTravelPageElementBase{static get is(){return"settings-travel-page"}static get template(){return getTemplate$1()}static get properties(){return{enhancedAutofillEligibleUser_:{type:Boolean,value(){return loadTimeData.getBoolean("userEligibleForAutofillAi")}},enhancedAutofillOptedIn_:{type:Boolean,value:false},travelOptedIn_:{type:Object,computed:"computeTravelOptedIn_(enhancedAutofillEligibleUser_, "+"enhancedAutofillOptedIn_, "+"prefs.autofill.autofill_ai.travel_entities_enabled, "+"prefs.autofill.profile_enabled.value)"},autofillAiIgnoresWhetherAddressFillingIsEnabled_:{type:Boolean,value(){return loadTimeData.getBoolean("AutofillAiIgnoresWhetherAddressFillingIsEnabled")}}}}static get observers(){return["onAutofillOptInStatusChange_(prefs.autofill.autofill_ai.opt_in_status)"]}entityDataManager_=EntityDataManagerProxyImpl.getInstance();connectedCallback(){super.connectedCallback()}optInToggleDisabled_(){const addressAutofillOptInStatus=this.getPref("autofill.profile_enabled").value;const ignoreAddressAutofill=this.autofillAiIgnoresWhetherAddressFillingIsEnabled_;const optInToggleEnabled=this.enhancedAutofillEligibleUser_&&this.enhancedAutofillOptedIn_&&(ignoreAddressAutofill||addressAutofillOptInStatus);return!optInToggleEnabled}onAutofillOptInStatusChange_(){this.entityDataManager_.getOptInStatus().then((status=>{this.set("enhancedAutofillOptedIn_",status)}))}computeTravelOptedIn_(){const fakePref={key:"fake",type:chrome.settingsPrivate.PrefType.BOOLEAN,value:this.getPref("autofill.autofill_ai.travel_entities_enabled").value};if(this.optInToggleDisabled_()){fakePref.value=false}return fakePref}onOptInToggleChange_(){this.setPrefValue("autofill.autofill_ai.travel_entities_enabled",this.$.optInToggle.checked)}getAllowedEntityTypes_(){return new Set([EntityTypeName.kFlightReservation,EntityTypeName.kKnownTravelerNumber,EntityTypeName.kRedressNumber,EntityTypeName.kVehicle])}}customElements.define(SettingsTravelPageElement.is,SettingsTravelPageElement);let instance=null;function getCss(){return instance||(instance=[...[getCss$b()],css`#content{display:flex;flex:1}.collapsible{overflow:hidden;text-overflow:ellipsis}span{white-space:pre}.elided-text{overflow:hidden;text-overflow:ellipsis;white-space:var(--cr-toast-white-space,nowrap)}`])}function getHtml(){return html$1`
<cr-toast id="toast" .duration="${this.duration}">
  <div id="content" class="elided-text"></div>
  <slot id="slotted"></slot>
</cr-toast>`}let toastManagerInstance=null;function getToastManager(){assert(toastManagerInstance);return toastManagerInstance}function setInstance(instance){assert(!instance||!toastManagerInstance);toastManagerInstance=instance}class CrToastManagerElement extends CrLitElement{static get is(){return"cr-toast-manager"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{duration:{type:Number}}}#duration_accessor_storage=0;get duration(){return this.#duration_accessor_storage}set duration(value){this.#duration_accessor_storage=value}get isToastOpen(){return this.$.toast.open}get slottedHidden(){return this.$.slotted.hidden}connectedCallback(){super.connectedCallback();setInstance(this)}disconnectedCallback(){super.disconnectedCallback();setInstance(null)}show(label,hideSlotted=false){this.$.content.textContent=label;this.showInternal_(hideSlotted)}showForStringPieces(pieces,hideSlotted=false){const content=this.$.content;content.textContent="";pieces.forEach((function(p){if(p.value.length===0){return}const span=document.createElement("span");span.textContent=p.value;if(p.collapsible){span.classList.add("collapsible")}content.appendChild(span)}));this.showInternal_(hideSlotted)}showInternal_(hideSlotted){this.$.slotted.hidden=hideSlotted;this.$.toast.show()}hide(){this.$.toast.hide()}}customElements.define(CrToastManagerElement.is,CrToastManagerElement);function getTemplate(){return html`<!--_html_template_start_--><style include="cr-shared-style settings-shared md-select"></style>
<settings-section page-title="$i18n{translatePageTitle}">
<settings-toggle-button id="offerTranslateOtherLanguages"
    pref="{{prefs.translate.enabled}}"
    label="$i18n{offerToEnableTranslate}"
    sub-label="$i18n{offerToEnableTranslateSublabel}"
    on-settings-boolean-control-change="onTranslateToggleChange_">
</settings-toggle-button>
<cr-collapse opened="[[prefs.translate.enabled.value]]">
  <div class="cr-row continuation">
    <div id="targetLanguageLabel" class="flex cr-padded-text"
        aria-hidden="true">
      $i18n{targetLanguageLabel}
    </div>
    <select id="targetLanguage" class="md-select"
        aria-labelledby="targetLanguageLabel"
        on-change="onTargetLanguageChange_">
      <template is="dom-repeat" items="[[languages.supported]]"
          filter="isTranslateSupported_">
        <option value="[[item.code]]"
            selected="[[translateLanguageEqual_(
                item.code, languages.translateTarget)]]">
          [[getTargetLanguageDisplayOption_(item)]]
        </option>
      </template>
    </select>
  </div>
  <div class="cr-row continuation">
    <h2 class="flex">$i18n{automaticallyTranslateLanguages}</h2>
    <cr-button id="addAlwaysTranslate" class="header-aligned-button"
        aria-label="$i18n{addAutomaticallyTranslateLanguagesAriaLabel}"
        on-click="onAddAlwaysTranslateLanguagesClick_">
      $i18n{addLanguages}
    </cr-button>
  </div>
  <div class="list-frame">
    <div id="alwaysTranslateList" class="vertical-list" role="list">
      <template is="dom-repeat" items="[[languages.alwaysTranslate]]"
          sort="alphabeticalSort_" filter="hasDisplayName_">
        <div class="list-item" role="listitem">
          <div class="start cr-padded-text">[[item.displayName]]</div>
          <cr-icon-button class="icon-delete-gray"
              aria-label="[[i18n('removeAutomaticLanguageAriaLabel',
                            item.displayName)]]"
              on-click="onRemoveAlwaysTranslateLanguageClick_"
              title="$i18n{delete}">
          </cr-icon-button>
        </div>
      </template>
    </div>
    <div id="noAlwaysTranslateLabel" class="list-item" role="listitem"
        hidden$="[[hasSome_(languages.alwaysTranslate)]]">
      $i18n{noLanguagesAdded}
    </div>
  </div>
  <div class="cr-row continuation">
    <h2 class="flex">$i18n{neverTranslateLanguages}</h2>
    <cr-button id="addNeverTranslate" class="header-aligned-button"
        aria-label="$i18n{addNeverTranslateLanguagesAriaLabel}"
        on-click="onAddNeverTranslateLanguagesClick_">
      $i18n{addLanguages}
    </cr-button>
  </div>
  <div class="list-frame">
    <div id="neverTranslateList" class="vertical-list" role="list">
      <template is="dom-repeat" items="[[languages.neverTranslate]]"
          sort="alphabeticalSort_" filter="hasDisplayName_">
        <div class="list-item" role="listitem">
          <div class="start cr-padded-text">[[item.displayName]]</div>
          <cr-icon-button class="icon-delete-gray" value="[[item.code]]"
              disabled="[[hasLength_(languages.neverTranslate, 1)]]"
              aria-label="[[i18n('removeNeverLanguageAriaLabel',
                            item.displayName)]]"
              on-click="onRemoveNeverTranslateLanguageClick_"
              title="$i18n{delete}">
          </cr-icon-button>
        </div>
      </template>
    </div>
    <div id="noNeverTranslateLabel" class="list-item" role="listitem"
        hidden$="[[hasSome_(languages.neverTranslate)]]">
      $i18n{noLanguagesAdded}
    </div>
  </div>
</cr-collapse>
<template is="dom-if" if="[[showAddAlwaysTranslateDialog_]]" restamp>
  <settings-add-languages-dialog id="alwaysTranslateDialog"
      languages="[[addLanguagesDialogLanguages_]]"
      on-close="onAlwaysTranslateDialogClose_"
      on-languages-added="onAlwaysTranslateLanguagesAdded_">
  </settings-add-languages-dialog>
</template>
<template is="dom-if" if="[[showAddNeverTranslateDialog_]]" restamp>
  <settings-add-languages-dialog id="neverTranslateDialog"
      languages="[[addLanguagesDialogLanguages_]]"
      on-close="onNeverTranslateDialogClose_"
      on-languages-added="onNeverTranslateLanguagesAdded_">
  </settings-add-languages-dialog>
</template>
</settings-section>
<!--_html_template_end_-->`}const SettingsTranslatePageElementBase=PrefsMixin(I18nMixin(PolymerElement));class SettingsTranslatePageElement extends SettingsTranslatePageElementBase{static get is(){return"settings-translate-page"}static get template(){return getTemplate()}static get properties(){return{languages:Object,showAddAlwaysTranslateDialog_:Boolean,showAddNeverTranslateDialog_:Boolean,addLanguagesDialogLanguages_:Array}}languageHelper_;languageSettingsMetricsProxy_=LanguageSettingsMetricsProxyImpl.getInstance();connectedCallback(){super.connectedCallback();this.languageHelper_=getLanguageHelperInstance()}onTargetLanguageChange_(){this.languageHelper_.setTranslateTargetLanguage(this.shadowRoot.querySelector("#targetLanguage").value);this.languageSettingsMetricsProxy_.recordSettingsMetric(LanguageSettingsActionType.CHANGE_TRANSLATE_TARGET)}getTargetLanguageDisplayOption_(item){return getFullName(item)}translateLanguageEqual_(chromeItemCode,translateTarget){return chromeItemCode===convertLanguageCodeForChrome(translateTarget)}alphabeticalSort_(first,second){return first.displayName.localeCompare(second.displayName)}hasDisplayName_(language){return!!language&&!!language.displayName}onAddAlwaysTranslateLanguagesClick_(e){e.preventDefault();const translatableLanguages=this.getTranslatableLanguages_();this.addLanguagesDialogLanguages_=translatableLanguages.filter((language=>!this.languages.alwaysTranslate.includes(language)));this.showAddAlwaysTranslateDialog_=true}onAlwaysTranslateDialogClose_(){this.showAddAlwaysTranslateDialog_=false;this.addLanguagesDialogLanguages_=null;const toFocus=this.shadowRoot.querySelector("#addAlwaysTranslate");assert(toFocus);focusWithoutInk(toFocus)}onAlwaysTranslateLanguagesAdded_(e){const languagesToAdd=e.detail;languagesToAdd.forEach((languageCode=>{this.languageHelper_.setLanguageAlwaysTranslateState(languageCode,true);this.languageSettingsMetricsProxy_.recordSettingsMetric(LanguageSettingsActionType.ADD_TO_ALWAYS_TRANSLATE)}))}onRemoveAlwaysTranslateLanguageClick_(e){const languageCode=e.model.item.code;this.languageHelper_.setLanguageAlwaysTranslateState(languageCode,false);this.languageSettingsMetricsProxy_.recordSettingsMetric(LanguageSettingsActionType.REMOVE_FROM_ALWAYS_TRANSLATE)}onAddNeverTranslateLanguagesClick_(e){e.preventDefault();const translatableLanguages=this.getTranslatableLanguages_();this.addLanguagesDialogLanguages_=translatableLanguages.filter((language=>!this.languages.neverTranslate.includes(language)));this.showAddNeverTranslateDialog_=true}onNeverTranslateDialogClose_(){this.showAddNeverTranslateDialog_=false;this.addLanguagesDialogLanguages_=null;const toFocus=this.shadowRoot.querySelector("#addNeverTranslate");assert(toFocus);focusWithoutInk(toFocus)}onNeverTranslateLanguagesAdded_(e){const languagesToAdd=e.detail;languagesToAdd.forEach((languageCode=>{this.languageHelper_.disableTranslateLanguage(languageCode);this.languageSettingsMetricsProxy_.recordSettingsMetric(LanguageSettingsActionType.ADD_TO_NEVER_TRANSLATE)}))}onRemoveNeverTranslateLanguageClick_(e){const languageCode=e.model.item.code;this.languageHelper_.enableTranslateLanguage(languageCode);this.languageSettingsMetricsProxy_.recordSettingsMetric(LanguageSettingsActionType.REMOVE_FROM_NEVER_TRANSLATE)}onTranslateToggleChange_(e){this.languageSettingsMetricsProxy_.recordSettingsMetric(e.target.checked?LanguageSettingsActionType.ENABLE_TRANSLATE_GLOBALLY:LanguageSettingsActionType.DISABLE_TRANSLATE_GLOBALLY)}hasSome_(list){return!!list.length}hasLength_(list,length){return list.length===length}getTranslatableLanguages_(){return this.languages.supported.filter((language=>this.isTranslateSupported_(language)))}isTranslateSupported_(language){return isTranslateBaseLanguage(language)}}customElements.define(SettingsTranslatePageElement.is,SettingsTranslatePageElement);export{AccessibilityBrowserProxyImpl,AddSiteDialogElement,AiEnterpriseFeaturePrefName,AiPageActions,AllSitesElement,AutofillAddressOptInChange,AutofillManagerImpl,BioEnrollDialogPage,BrowsingDataType,COMPOSE_PROACTIVE_NUDGE_DISABLED_SITES_PREF,COMPOSE_PROACTIVE_NUDGE_PREF,CaptionsBrowserProxyImpl,CardState,CategorySettingExceptionsElement,ChooserExceptionListElement,ChooserExceptionListEntryElement,ChooserType,ClearBrowsingDataBrowserProxyImpl,ContentSetting,ContentSettingsTypes,ControlledButtonElement,CookieControlsMode,CookiesExceptionType,CountryDetailManagerProxyImpl,CrLottieElement,CrSliderElement,CrTextareaElement,CredentialManagementDialogPage,Ctap2Status,DefaultSettingSource,DownloadsBrowserProxyImpl,EntityDataManagerProxyImpl,FINGERPRINT_CHECK_DARK_URL,FINGERPRINT_CHECK_LIGHT_URL,FINGERPRINT_SCANNED_ICON_DARK,FINGERPRINT_SCANNED_ICON_LIGHT,FeatureOptInState,FileSystemSiteDetailsElement,FileSystemSiteEntryElement,FileSystemSiteEntryItemElement,FileSystemSiteListElement,FingerprintProgressArcElement,FontsBrowserProxyImpl,GeolocationPageElement,HttpsFirstModeSetting,ImportDataBrowserProxyImpl,ImportDataStatus,JavascriptOptimizerSetting,LanguageSettingsActionType,LanguageSettingsMetricsProxyImpl,LanguageSettingsPageImpressionType,LanguagesBrowserProxyImpl,ManageProfileBrowserProxyImpl,NotificationsPageElement,PROGRESS_CIRCLE_BACKGROUND_COLOR_DARK,PROGRESS_CIRCLE_BACKGROUND_COLOR_LIGHT,PROGRESS_CIRCLE_FILL_COLOR_DARK,PROGRESS_CIRCLE_FILL_COLOR_LIGHT,PasskeysBrowserProxyImpl,PaymentsManagerImpl,PdfDocumentsPageElement,PermissionsRevocationType,PrivacySandboxInterestItemElement,ProfileShortcutStatus,ProtectedContentPageElement,ProtocolHandlersElement,ResetDialogPage,SITE_EXCEPTION_WILDCARD,SafeBrowsingSetting,SafetyHubBrowserProxyImpl,SafetyHubEvent,SampleStatus,ScreenAiInstallStatus,SecureDnsInputElement,SecureDnsResolverType,SecurityKeysBioEnrollProxyImpl,SecurityKeysCredentialBrowserProxyImpl,SecurityKeysPinBrowserProxyImpl,SecurityKeysResetBrowserProxyImpl,SecurityKeysSubpageElement,SecurityPageFeatureRowElement,SecuritySettingsBundleSetting,SetPinDialogPage,SettingsA11yPageElement,SettingsAccountPageElement,SettingsAddLanguagesDialogElement,SettingsAddressEditDialogElement,SettingsAddressRemoveConfirmationDialogElement,SettingsAiCompareSubpageElement,SettingsAiPolicyIndicator,SettingsAiTabOrganizationSubpageElement,SettingsAntiAbusePageElement,SettingsAppearanceFontsPageElement,SettingsAutofillAiSectionElement,SettingsAutofillSectionElement,SettingsAxAnnotationsSectionElement,SettingsCategoryDefaultRadioGroupElement,SettingsCheckboxElement,SettingsClearBrowsingDataAccountIndicator,SettingsClearBrowsingDataDialogElement,SettingsClearBrowsingDataDialogV2Element,SettingsClearBrowsingDataTimePicker,SettingsCookiesPageElement,SettingsCreditCardEditDialogElement,SettingsCreditCardListEntryElement,SettingsDoNotTrackToggleElement,SettingsDownloadsPageElement,SettingsEditExceptionDialogElement,SettingsGoogleServicesPageElement,SettingsHistoryDeletionDialogElement,SettingsHistorySearchPageElement,SettingsIbanEditDialogElement,SettingsIbanListEntryElement,SettingsIdentityDocsPageElement,SettingsImportDataDialogElement,SettingsLanguagesPageElement,SettingsLiveCaptionElement,SettingsLiveTranslateElement,SettingsManageProfileElement,SettingsOfferWritingHelpPageElement,SettingsOmniboxExtensionEntryElement,SettingsOtherGoogleDataDialogElement,SettingsPasskeysSubpageElement,SettingsPasswordsDeletionDialogElement,SettingsPayOverTimeIssuerListEntryElement,SettingsPaymentsListElement,SettingsPaymentsSectionElement,SettingsPersonalizationOptionsElement,SettingsPrivacySandboxAdMeasurementSubpageElement,SettingsPrivacySandboxFledgeSubpageElement,SettingsPrivacySandboxManageTopicsSubpageElement,SettingsPrivacySandboxPageElement,SettingsPrivacySandboxTopicsSubpageElement,SettingsRecentSitePermissionsElement,SettingsResetPageElement,SettingsResetProfileDialogElement,SettingsSafetyHubCardElement,SettingsSafetyHubExtensionsModuleElement,SettingsSafetyHubNotificationPermissionsModuleElement,SettingsSafetyHubPageElement,SettingsSafetyHubUnusedSitePermissionsModuleElement,SettingsSearchEngineEditDialogElement,SettingsSearchEngineEntryElement,SettingsSearchEnginesListElement,SettingsSearchEnginesPageElement,SettingsSecureDnsElement,SettingsSecurityKeysBioEnrollDialogElement,SettingsSecurityKeysCredentialManagementDialogElement,SettingsSecurityKeysResetDialogElement,SettingsSecurityKeysSetPinDialogElement,SettingsSecurityPageElement,SettingsSecurityPageV2Element,SettingsSiteDataElement,SettingsSiteSettingsPageElement,SettingsSliderElement,SettingsSpellCheckPageElement,SettingsState,SettingsSyncControlsElement,SettingsSyncEncryptionOptionsElement,SettingsSyncPageElement,SettingsSystemPageElement,SettingsTranslatePageElement,SettingsTravelPageElement,SettingsVirtualCardUnenrollDialogElement,SiteDetailsElement,SiteDetailsPermissionDeviceEntryElement,SiteDetailsPermissionElement,SiteEntryElement,SiteListElement,SiteListEntryElement,SiteSettingSource,SiteSettingsBrowserProxyImpl,SortMethod,SoundPageElement,StorageAccessSiteListElement,StorageAccessSiteListEntryElement,StorageAccessStaticSiteListEntryElement,SystemPageBrowserProxyImpl,ThirdPartyCookieBlockingSetting,TimePeriod,ToastAlertLevel,V8PageElement,WebsiteUsageBrowserProxyImpl,ZoomLevelsElement,defaultSettingLabel,getDataTypePrefName,getLanguageHelperInstance,getTimePeriodString,getToastManager,isFeatureDisabledByPolicy,kMenuCloseDelay};