// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '//resources/js/cr.js';
import { ClickDispositionFlag, PageCallbackRouter, PageHandlerFactory, PageHandlerRemote } from './reload_button.mojom-webui.js';
export { ClickDispositionFlag };
export class BrowserProxyImpl {
    callbackRouter;
    handler;
    constructor() {
        this.callbackRouter = new PageCallbackRouter();
        this.handler = new PageHandlerRemote();
        PageHandlerFactory.getRemote().createPageHandler(this.callbackRouter.$.bindNewPipeAndPassRemote(), this.handler.$.bindNewPipeAndPassReceiver());
    }
    /**
     * Records a value in a histogram.
     * @param histogramName The name of the histogram.
     * @param value The value to record.
     * @param maxValue The maximum value of the histogram.
     */
    recordInHistogram(histogramName, value, maxValue) {
        chrome.send('metricsHandler:recordInHistogram', [histogramName, value, maxValue]);
    }
    static getInstance() {
        return instance || (instance = new BrowserProxyImpl());
    }
    static setInstance(proxy) {
        instance = proxy;
    }
}
let instance = null;
