import '/strings.m.js';
import type { PolymerElement } from 'chrome://resources/polymer/v3_0/polymer/polymer_bundled.min.js';
import { PrivacySandboxPromptAction } from './privacy_sandbox_dialog_browser_proxy.js';
type Constructor<T> = new (...args: any[]) => T;
export declare const PrivacySandboxDialogMixin: <T extends Constructor<PolymerElement>>(superClass: T) => T & Constructor<PrivacySandboxDialogMixinInterface>;
export interface PrivacySandboxDialogMixinInterface {
    wasScrolledToBottom: boolean;
    loadPrivacyPolicyOnExpand(newValue: boolean, oldValue: boolean): void;
    onConsentLearnMoreExpandedChanged(newValue: boolean, oldValue: boolean): void;
    onNoticeLearnMoreExpandedChanged(newValue: boolean, oldValue: boolean): void;
    onNoticeSiteSuggestedAdsLearnMoreExpandedChanged(newValue: boolean, oldValue: boolean): void;
    onNoticeAdsMeasurementLearnMoreExpandedChanged(newValue: boolean, oldValue: boolean): void;
    onNoticeOpenSettings(): void;
    onNoticeAcknowledge(): void;
    maybeShowMoreButton(): Promise<void>;
    whenWasScrolledToBottomForTest(): Promise<void>;
    moreButtonInitializedForTest(): Promise<void>;
    promptActionOccurred(action: PrivacySandboxPromptAction): void;
    updateScrollableContents(): void;
}
export {};
