import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="cr-shared-style shared-style">#privacyPolicyLink{color:var(--cr-link-color)}</style>

<div id="consentNotice" hidden$="[[hideConsentNoticePage_]]">
  <div class="content-area custom-scrollbar" scrollable tabindex="-1">
    <div class="header">
      <img class="logo" alt="">
      <h1>$i18n{m1ConsentTitle}</h1>
    </div>
    <div id="consentContentV2">
      <div id="consentContentV2FirstDescription"
          class="section cr-secondary-text">
        [[consentContentV2FirstDescription_]]
      </div>
      <div class="banner">
        <img class="topics-banner" alt="">
      </div>
      <div class="section cr-secondary-text">
        $i18n{m1ConsentDescription3}
      </div>
      <privacy-sandbox-dialog-learn-more class="learn-more-section"
          expanded="{{expanded_}}"
          title="$i18n{m1ConsentLearnMoreExpandLabel}">
        <ul class="cr-secondary-text">
          <li>$i18nRaw{m1ConsentLearnmoreBullet1V2}</li>
          <li>$i18nRaw{m1ConsentLearnmoreBullet2V2}</li>
          <template is="dom-if" if="[[!shouldShowAdTopicsContentParity_]]">
            <div id="learnMoreBulletDescription"
                class="learn-more-bullet-description">
              $i18nRaw{m1ConsentLearnmoreBullet2Description}
            </div>
          </template>
          <template is="dom-if" if="[[shouldShowAdTopicsContentParity_]]">
            <div id="learnMoreBulletDescriptionContentParity"
                class="learn-more-bullet-description">
              $i18nRaw{m1ConsentLearnMoreBullet2DescriptionContentParity}
            </div>
          </template>
          <li>$i18nRaw{m1ConsentLearnmoreBullet3V2}</li>
        </ul>
      </privacy-sandbox-dialog-learn-more>
      <div class="section cr-secondary-text" id="lastTextElementV2">
        $i18n{m1ConsentDescription4V2}
      </div>
    </div>
    <div class="buttons-container">
      <cr-button id="declineButton" class="tonal-button"
          on-click="onConsentDeclined_">
        $i18n{m1ConsentDeclineButton}
      </cr-button>
      <cr-button id="confirmButton" class="tonal-button"
          on-click="onConsentAccepted_">
        $i18n{m1ConsentAcceptButton}
      </cr-button>
    </div>
  </div>
  <div id="showMoreOverlay" hidden="[[wasScrolledToBottom]]">
    <cr-button id="moreButton" on-click="onConsentMoreClicked"
        class="action-button">
      $i18n{m1DialogMoreButton}
      <cr-icon icon="cr:expand-more"></cr-icon>
    </cr-button>
  </div>
</div>
<template is="dom-if" if="[[loadPrivacyPolicy_]]">
  <privacy-sandbox-privacy-policy-dialog
      id="privacyPolicyDialog"
      should-show="[[hideConsentNoticePage_]]"
      on-back-button-clicked="onBackButtonClicked_">
  </privacy-sandbox-privacy-policy-dialog>
</template>
<!--_html_template_end_-->`;
}
