import 'chrome://resources/cr_elements/cr_shared_style.css.js';
import 'chrome://resources/cr_elements/cr_button/cr_button.js';
import 'chrome://resources/cr_elements/cr_view_manager/cr_view_manager.js';
import './topics_consent_notice.js';
import './protected_audience_measurement_notice.js';
import './three_ads_apis_notice.js';
import './measurement_notice.js';
import '/strings.m.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import type { CrViewManagerElement } from 'chrome://resources/cr_elements/cr_view_manager/cr_view_manager.js';
import { PrivacySandboxNotice } from './notice.mojom-webui.js';
export interface BaseDialogApp {
    $: {
        viewManager: CrViewManagerElement;
    };
}
export declare class BaseDialogApp extends CrLitElement {
    static get is(): string;
    static get styles(): import("//resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("//resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    private proxy_;
    private handler_;
    private navigateToNextStepListenerId_;
    firstUpdated(): void;
    connectedCallback(): void;
    disconnectedCallback(): void;
    private navigateToStep_;
    /**
     * Converts a PrivacySandboxNotice enum value (number) into its corresponding
     * string key/name (e.g., 0 becomes "kTopicsConsentNotice").
     * Used to generate unique string IDs for the different dialog steps.
     */
    protected getNoticeId(step: PrivacySandboxNotice): string;
    private resizeAndShowNativeDialog;
}
declare global {
    interface HTMLElementTagNameMap {
        'base-dialog-app': BaseDialogApp;
    }
}
