import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { ContentSettingPatternSource as contentSettings_mojom_ContentSettingPatternSource, ContentSettingsPattern as contentSettings_mojom_ContentSettingsPattern } from './content_settings.mojom-webui.js';
import { ContentSettingsType as contentSettings_mojom_ContentSettingsType } from './content_settings_types.mojom-webui.js';
import { Value as mojoBase_mojom_Value } from '//resources/mojo/mojo/public/mojom/base/values.mojom-webui.js';
export type PageHandlerPendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
export declare class PageHandlerPendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {
    handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
    constructor(handle: MojoHandle | PageHandlerPendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface PageHandlerInterface {
    readPrefsWithPrefixes(prefPrefixes: string[]): Promise<{
        prefs: PrivacySandboxInternalsPref[];
    }>;
    readContentSettings(type: contentSettings_mojom_ContentSettingsType): Promise<{
        contentSettings: contentSettings_mojom_ContentSettingPatternSource[];
    }>;
    getTpcdMetadataGrants(): Promise<{
        contentSettings: contentSettings_mojom_ContentSettingPatternSource[];
    }>;
    contentSettingsPatternToString(pattern: contentSettings_mojom_ContentSettingsPattern): Promise<{
        s: string;
    }>;
    stringToContentSettingsPattern(s: string): Promise<{
        pattern: contentSettings_mojom_ContentSettingsPattern;
    }>;
}
export declare class PageHandlerRemote implements PageHandlerInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | PageHandlerPendingReceiverEndpoint);
    readPrefsWithPrefixes(prefPrefixes: string[]): Promise<{
        prefs: PrivacySandboxInternalsPref[];
    }>;
    readContentSettings(type: contentSettings_mojom_ContentSettingsType): Promise<{
        contentSettings: contentSettings_mojom_ContentSettingPatternSource[];
    }>;
    getTpcdMetadataGrants(): Promise<{
        contentSettings: contentSettings_mojom_ContentSettingPatternSource[];
    }>;
    contentSettingsPatternToString(pattern: contentSettings_mojom_ContentSettingsPattern): Promise<{
        s: string;
    }>;
    stringToContentSettingsPattern(s: string): Promise<{
        pattern: contentSettings_mojom_ContentSettingsPattern;
    }>;
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class PageHandlerReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageHandlerRemote, PageHandlerPendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(impl: PageHandlerInterface);
}
export declare class PageHandler {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): PageHandlerRemote;
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class PageHandlerCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageHandlerRemote, PageHandlerPendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    readPrefsWithPrefixes: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    readContentSettings: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    getTpcdMetadataGrants: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    contentSettingsPatternToString: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    stringToContentSettingsPattern: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export type PagePendingReceiverEndpoint = mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
export declare class PagePendingReceiver implements mojo.internal.interfaceSupport.PendingReceiver<Page> {
    handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
    constructor(handle: MojoHandle | PagePendingReceiverEndpoint);
    bindInBrowser(scope?: string): void;
}
export interface PageInterface {
}
export declare class PageRemote implements PageInterface {
    private proxy;
    $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(handle?: MojoHandle | PagePendingReceiverEndpoint);
}
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export declare class PageReceiver {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageRemote, PagePendingReceiver>;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor(_impl: PageInterface);
}
export declare class Page {
    static get $interfaceName(): string;
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote(): PageRemote;
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export declare class PageCallbackRouter {
    private helper_internal_;
    $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<PageRemote, PagePendingReceiver>;
    router_: mojo.internal.interfaceSupport.CallbackRouter;
    onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;
    constructor();
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id: number): boolean;
}
export declare const PrivacySandboxInternalsPrefSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_ReadPrefsWithPrefixes_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_ReadPrefsWithPrefixes_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_ReadContentSettings_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_ReadContentSettings_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetTpcdMetadataGrants_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_GetTpcdMetadataGrants_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_ContentSettingsPatternToString_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_ContentSettingsPatternToString_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_StringToContentSettingsPattern_ParamsSpec: {
    $: mojo.internal.MojomType;
};
export declare const PageHandler_StringToContentSettingsPattern_ResponseParamsSpec: {
    $: mojo.internal.MojomType;
};
export interface PrivacySandboxInternalsPrefMojoType {
    name: string;
    value: mojoBase_mojom_Value;
}
export type PrivacySandboxInternalsPref = PrivacySandboxInternalsPrefMojoType;
export interface PageHandler_ReadPrefsWithPrefixes_ParamsMojoType {
    prefPrefixes: string[];
}
export type PageHandler_ReadPrefsWithPrefixes_Params = PageHandler_ReadPrefsWithPrefixes_ParamsMojoType;
export interface PageHandler_ReadPrefsWithPrefixes_ResponseParamsMojoType {
    prefs: PrivacySandboxInternalsPref[];
}
export type PageHandler_ReadPrefsWithPrefixes_ResponseParams = PageHandler_ReadPrefsWithPrefixes_ResponseParamsMojoType;
export interface PageHandler_ReadContentSettings_ParamsMojoType {
    type: contentSettings_mojom_ContentSettingsType;
}
export type PageHandler_ReadContentSettings_Params = PageHandler_ReadContentSettings_ParamsMojoType;
export interface PageHandler_ReadContentSettings_ResponseParamsMojoType {
    contentSettings: contentSettings_mojom_ContentSettingPatternSource[];
}
export type PageHandler_ReadContentSettings_ResponseParams = PageHandler_ReadContentSettings_ResponseParamsMojoType;
export interface PageHandler_GetTpcdMetadataGrants_ParamsMojoType {
}
export type PageHandler_GetTpcdMetadataGrants_Params = PageHandler_GetTpcdMetadataGrants_ParamsMojoType;
export interface PageHandler_GetTpcdMetadataGrants_ResponseParamsMojoType {
    contentSettings: contentSettings_mojom_ContentSettingPatternSource[];
}
export type PageHandler_GetTpcdMetadataGrants_ResponseParams = PageHandler_GetTpcdMetadataGrants_ResponseParamsMojoType;
export interface PageHandler_ContentSettingsPatternToString_ParamsMojoType {
    pattern: contentSettings_mojom_ContentSettingsPattern;
}
export type PageHandler_ContentSettingsPatternToString_Params = PageHandler_ContentSettingsPatternToString_ParamsMojoType;
export interface PageHandler_ContentSettingsPatternToString_ResponseParamsMojoType {
    s: string;
}
export type PageHandler_ContentSettingsPatternToString_ResponseParams = PageHandler_ContentSettingsPatternToString_ResponseParamsMojoType;
export interface PageHandler_StringToContentSettingsPattern_ParamsMojoType {
    s: string;
}
export type PageHandler_StringToContentSettingsPattern_Params = PageHandler_StringToContentSettingsPattern_ParamsMojoType;
export interface PageHandler_StringToContentSettingsPattern_ResponseParamsMojoType {
    pattern: contentSettings_mojom_ContentSettingsPattern;
}
export type PageHandler_StringToContentSettingsPattern_ResponseParams = PageHandler_StringToContentSettingsPattern_ResponseParamsMojoType;
