// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '//resources/cr_elements/cr_button/cr_button.js';
import './list_item.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import { getCss } from './list_container.css.js';
import { getHtml } from './list_container.html.js';
export class RelatedWebsiteSetsListContainerElement extends CrLitElement {
    static get is() {
        return 'related-website-sets-list-container';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            relatedWebsiteSets: { type: Array },
            filteredItems: { type: Array },
            isAnyRowCollapsed: { type: Boolean },
            errorMessage: { type: String },
            query: { type: String },
        };
    }
    #relatedWebsiteSets_accessor_storage = [];
    get relatedWebsiteSets() { return this.#relatedWebsiteSets_accessor_storage; }
    set relatedWebsiteSets(value) { this.#relatedWebsiteSets_accessor_storage = value; }
    #query_accessor_storage = '';
    get query() { return this.#query_accessor_storage; }
    set query(value) { this.#query_accessor_storage = value; }
    #errorMessage_accessor_storage = '';
    get errorMessage() { return this.#errorMessage_accessor_storage; }
    set errorMessage(value) { this.#errorMessage_accessor_storage = value; }
    #isAnyRowCollapsed_accessor_storage = true;
    get isAnyRowCollapsed() { return this.#isAnyRowCollapsed_accessor_storage; }
    set isAnyRowCollapsed(value) { this.#isAnyRowCollapsed_accessor_storage = value; }
    #filteredItems_accessor_storage = [];
    get filteredItems() { return this.#filteredItems_accessor_storage; }
    set filteredItems(value) { this.#filteredItems_accessor_storage = value; }
    rowExpandedStates_ = new Map();
    willUpdate(changedProperties) {
        super.willUpdate(changedProperties);
        this.isAnyRowCollapsed = Array.from(this.rowExpandedStates_.values())
            .some(expanded => !expanded);
        if (changedProperties.has('query') ||
            changedProperties.has('relatedWebsiteSets')) {
            this.filteredItems =
                this.relatedWebsiteSets.filter(set => this.hasMatch_(set));
            this.errorMessage =
                this.filteredItems.length === 0 ? 'No items match' : '';
        }
    }
    hasMatch_(set) {
        const normalizedQuery = this.query.toLowerCase().trim();
        if (set.primarySite.toLowerCase().includes(normalizedQuery)) {
            return true;
        }
        for (const member of set.memberSites) {
            if (member.site.toLowerCase().includes(normalizedQuery)) {
                return true;
            }
        }
        return false;
    }
    onClick_() {
        const rows = this.shadowRoot.querySelectorAll('related-website-sets-list-item');
        for (const row of rows) {
            row.expanded = this.isAnyRowCollapsed;
        }
    }
    onExpandedToggled_(e) {
        this.rowExpandedStates_.set(e.detail.id, e.detail.expanded);
        this.requestUpdate();
    }
    expandCollapseButtonText_() {
        return this.isAnyRowCollapsed ? 'Expand All' : 'Collapse All';
    }
    getDisplayedError() {
        return this.errorMessage.replace('Error', '');
    }
    getMemberSites_(item) {
        return item.memberSites.filter(ms => ms.site !== item.primarySite);
    }
}
customElements.define(RelatedWebsiteSetsListContainerElement.is, RelatedWebsiteSetsListContainerElement);
