// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '//resources/cr_elements/cr_drawer/cr_drawer.js';
import './sidebar.js';
import './toolbar.js';
import './list_container.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import { getCss } from './app.css.js';
import { getHtml } from './app.html.js';
import { RelatedWebsiteSetsApiBrowserProxyImpl } from './related_website_sets_api_proxy.js';
export class RelatedWebsiteSetsAppElement extends CrLitElement {
    static get is() {
        return 'related-website-sets-app';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            pageTitle_: { type: String },
            narrow_: { type: Boolean },
            isDrawerOpen_: { type: Boolean },
            relatedWebsiteSets_: { type: Array },
            errorMessage_: { type: String },
            query_: { type: String },
        };
    }
    #pageTitle__accessor_storage = 'Related Website Sets';
    // TODO (b/330877132): Add Localization once UI stable
    get pageTitle_() { return this.#pageTitle__accessor_storage; }
    set pageTitle_(value) { this.#pageTitle__accessor_storage = value; }
    #narrow__accessor_storage = true;
    get narrow_() { return this.#narrow__accessor_storage; }
    set narrow_(value) { this.#narrow__accessor_storage = value; }
    #isDrawerOpen__accessor_storage = false;
    get isDrawerOpen_() { return this.#isDrawerOpen__accessor_storage; }
    set isDrawerOpen_(value) { this.#isDrawerOpen__accessor_storage = value; }
    #relatedWebsiteSets__accessor_storage = [];
    get relatedWebsiteSets_() { return this.#relatedWebsiteSets__accessor_storage; }
    set relatedWebsiteSets_(value) { this.#relatedWebsiteSets__accessor_storage = value; }
    #errorMessage__accessor_storage = '';
    get errorMessage_() { return this.#errorMessage__accessor_storage; }
    set errorMessage_(value) { this.#errorMessage__accessor_storage = value; }
    #query__accessor_storage = '';
    get query_() { return this.#query__accessor_storage; }
    set query_(value) { this.#query__accessor_storage = value; }
    apiProxy_ = RelatedWebsiteSetsApiBrowserProxyImpl.getInstance();
    connectedCallback() {
        super.connectedCallback();
        this.updateQueryFromUrl_();
        window.addEventListener('popstate', (() => this.handlePopState_()));
        this.apiProxy_.handler.getRelatedWebsiteSets().then(({ relatedWebsiteSetsInfo }) => {
            if (relatedWebsiteSetsInfo.errorMessage) {
                this.errorMessage_ = relatedWebsiteSetsInfo.errorMessage;
            }
            else if (relatedWebsiteSetsInfo.relatedWebsiteSets) {
                this.relatedWebsiteSets_ =
                    relatedWebsiteSetsInfo.relatedWebsiteSets;
            }
        });
    }
    disconnectedCallback() {
        window.removeEventListener('popstate', (() => this.handlePopState_()));
        super.disconnectedCallback();
    }
    updated(changedProperties) {
        super.updated(changedProperties);
        const changedPrivateProperties = changedProperties;
        if (changedPrivateProperties.has('narrow_')) {
            if (this.$.drawer.open && !this.narrow_) {
                this.$.drawer.close();
            }
        }
    }
    onNarrowChanged_(e) {
        this.narrow_ = e.detail.value;
    }
    onMenuButtonClick_() {
        this.showDrawerMenu_();
    }
    showDrawerMenu_() {
        this.$.drawer.openDrawer();
        this.isDrawerOpen_ = this.$.drawer.open;
    }
    onDrawerClose_() {
        this.isDrawerOpen_ = this.$.drawer.open;
    }
    onSearchChanged_(event) {
        this.query_ = event.detail;
        this.updateUrlParams_();
    }
    updateUrlParams_() {
        const urlParams = new URLSearchParams(window.location.search);
        if (this.query_) {
            urlParams.set('q', this.query_);
        }
        else {
            urlParams.delete('q');
        }
        window.history.replaceState({}, '', `${window.location.pathname}?${urlParams.toString()}`);
    }
    updateQueryFromUrl_() {
        const params = new URLSearchParams(window.location.search);
        this.query_ = params.get('q') || '';
        this.$.toolbar.setSearchFieldValue(this.query_);
    }
    handlePopState_() {
        this.updateQueryFromUrl_();
    }
    setNarrowForTesting(state) {
        this.narrow_ = state;
    }
}
customElements.define(RelatedWebsiteSetsAppElement.is, RelatedWebsiteSetsAppElement);
