import '//resources/cr_elements/cr_drawer/cr_drawer.js';
import './sidebar.js';
import './toolbar.js';
import './list_container.js';
import type { CrDrawerElement } from '//resources/cr_elements/cr_drawer/cr_drawer.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import type { PropertyValues } from '//resources/lit/v3_0/lit.rollup.js';
import type { RelatedWebsiteSet } from './related_website_sets.mojom-webui.js';
import type { RelatedWebsiteSetsSidebarElement } from './sidebar.js';
import type { RelatedWebsiteSetsToolbarElement } from './toolbar.js';
export interface RelatedWebsiteSetsAppElement {
    $: {
        drawer: CrDrawerElement;
        toolbar: RelatedWebsiteSetsToolbarElement;
        sidebar: RelatedWebsiteSetsSidebarElement;
    };
}
export declare class RelatedWebsiteSetsAppElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("//resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("//resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        pageTitle_: {
            type: StringConstructor;
        };
        narrow_: {
            type: BooleanConstructor;
        };
        isDrawerOpen_: {
            type: BooleanConstructor;
        };
        relatedWebsiteSets_: {
            type: ArrayConstructor;
        };
        errorMessage_: {
            type: StringConstructor;
        };
        query_: {
            type: StringConstructor;
        };
    };
    protected accessor pageTitle_: string;
    protected accessor narrow_: boolean;
    protected accessor isDrawerOpen_: boolean;
    protected accessor relatedWebsiteSets_: RelatedWebsiteSet[];
    protected accessor errorMessage_: string;
    protected accessor query_: string;
    private apiProxy_;
    connectedCallback(): void;
    disconnectedCallback(): void;
    updated(changedProperties: PropertyValues<this>): void;
    protected onNarrowChanged_(e: CustomEvent<{
        value: boolean;
    }>): void;
    protected onMenuButtonClick_(): void;
    private showDrawerMenu_;
    protected onDrawerClose_(): void;
    protected onSearchChanged_(event: CustomEvent<string>): void;
    private updateUrlParams_;
    private updateQueryFromUrl_;
    private handlePopState_;
    setNarrowForTesting(state: boolean): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'related-website-sets-app': RelatedWebsiteSetsAppElement;
    }
}
