// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import './toolbar.js';
import '//resources/cr_elements/cr_drawer/cr_drawer.js';
import './sidebar.js';
import './navigation.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import { getCss } from './app.css.js';
import { getHtml } from './app.html.js';
import { PrivateStateTokensApiBrowserProxyImpl } from './browser_proxy.js';
import { ItemsToRender, nullMetadataObj } from './types.js';
export class PrivateStateTokensAppElement extends CrLitElement {
    static get is() {
        return 'private-state-tokens-app';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            pageTitle_: { type: String },
            narrow_: { type: Boolean },
            narrowThreshold_: { type: Number },
            isDrawerOpen_: { type: Boolean },
            itemToRender: { type: String },
            data: { type: Array },
        };
    }
    #narrowThreshold__accessor_storage = 1096;
    get narrowThreshold_() { return this.#narrowThreshold__accessor_storage; }
    set narrowThreshold_(value) { this.#narrowThreshold__accessor_storage = value; }
    #narrow__accessor_storage;
    get narrow_() { return this.#narrow__accessor_storage; }
    set narrow_(value) { this.#narrow__accessor_storage = value; }
    #pageTitle__accessor_storage = 'Private State Tokens';
    get pageTitle_() { return this.#pageTitle__accessor_storage; }
    set pageTitle_(value) { this.#pageTitle__accessor_storage = value; }
    #isDrawerOpen__accessor_storage = false;
    get isDrawerOpen_() { return this.#isDrawerOpen__accessor_storage; }
    set isDrawerOpen_(value) { this.#isDrawerOpen__accessor_storage = value; }
    #data_accessor_storage = [];
    get data() { return this.#data_accessor_storage; }
    set data(value) { this.#data_accessor_storage = value; }
    #itemToRender_accessor_storage = ItemsToRender.ISSUER_LIST;
    get itemToRender() { return this.#itemToRender_accessor_storage; }
    set itemToRender(value) { this.#itemToRender_accessor_storage = value; }
    metadata_;
    handleNavigationToMetadata_ = this.handleContentNavigation_.bind(this, ItemsToRender.ISSUER_METADATA);
    handleNavigationToList_ = this.handleContentNavigation_.bind(this, ItemsToRender.ISSUER_LIST);
    browserProxy = PrivateStateTokensApiBrowserProxyImpl.getInstance();
    constructor() {
        super();
        this.narrow_ = window.innerWidth < this.narrowThreshold_;
    }
    connectedCallback() {
        super.connectedCallback();
        this.updateIssuerTokenCounts_();
        this.addEventListener('cr-toolbar-menu-click', this.onMenuButtonClick_);
        this.addEventListener('narrow-changed', this.onNarrowChanged_);
    }
    firstUpdated() {
        window.addEventListener('navigate-to-metadata', this.handleNavigationToMetadata_);
        window.addEventListener('navigate-to-container', this.handleNavigationToList_);
    }
    disconnectedCallback() {
        this.removeEventListener('cr-toolbar-menu-click', this.onMenuButtonClick_);
        this.removeEventListener('narrow-changed', this.onNarrowChanged_);
        super.disconnectedCallback();
    }
    async updateIssuerTokenCounts_() {
        const newIssuer = await this.browserProxy.handler.getIssuerTokenCounts();
        this.data = newIssuer.privateStateTokensCount
            .sort((a, b) => a.issuer.localeCompare(b.issuer))
            .map(issuerObj => ({
            issuerOrigin: issuerObj.issuer,
            numTokens: issuerObj.count,
            // TODO(crbug.com/348590926): redemptions data will
            // be plumbed in a following cl
            redemptions: [],
            metadata: nullMetadataObj,
        }));
    }
    onNarrowChanged_(e) {
        this.narrow_ = e.detail.value;
        if (this.$.drawer.open && !this.narrow_) {
            this.$.drawer.close();
        }
    }
    onMenuButtonClick_() {
        this.showDrawerMenu_();
    }
    showDrawerMenu_() {
        this.$.drawer.openDrawer();
        this.isDrawerOpen_ = this.$.drawer.open;
    }
    onDrawerClose_() {
        this.isDrawerOpen_ = this.$.drawer.open;
    }
    handleContentNavigation_(itemToRender, event) {
        this.itemToRender = itemToRender;
        if (this.itemToRender === ItemsToRender.ISSUER_METADATA) {
            this.metadata_ = event.detail;
        }
        this.requestUpdate();
    }
    setNarrowForTesting(state) {
        this.narrow_ = state;
    }
}
customElements.define(PrivateStateTokensAppElement.is, PrivateStateTokensAppElement);
