import './toolbar.js';
import '//resources/cr_elements/cr_drawer/cr_drawer.js';
import './sidebar.js';
import './navigation.js';
import type { CrDrawerElement } from '//resources/cr_elements/cr_drawer/cr_drawer.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import type { PrivateStateTokensSidebarElement } from './sidebar.js';
import type { PrivateStateTokensToolbarElement } from './toolbar.js';
import { ItemsToRender } from './types.js';
import type { ListItem, Metadata } from './types.js';
export interface PrivateStateTokensAppElement {
    $: {
        drawer: CrDrawerElement;
        sidebar: PrivateStateTokensSidebarElement;
        toolbar: PrivateStateTokensToolbarElement;
    };
}
export declare class PrivateStateTokensAppElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("//resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("//resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        pageTitle_: {
            type: StringConstructor;
        };
        narrow_: {
            type: BooleanConstructor;
        };
        narrowThreshold_: {
            type: NumberConstructor;
        };
        isDrawerOpen_: {
            type: BooleanConstructor;
        };
        itemToRender: {
            type: StringConstructor;
        };
        data: {
            type: ArrayConstructor;
        };
    };
    protected accessor narrowThreshold_: number;
    protected accessor narrow_: boolean;
    protected accessor pageTitle_: string;
    protected accessor isDrawerOpen_: boolean;
    accessor data: ListItem[];
    accessor itemToRender: ItemsToRender;
    protected metadata_?: Metadata;
    private handleNavigationToMetadata_;
    private handleNavigationToList_;
    private browserProxy;
    constructor();
    connectedCallback(): void;
    firstUpdated(): void;
    disconnectedCallback(): void;
    private updateIssuerTokenCounts_;
    protected onNarrowChanged_(e: CustomEvent<{
        value: boolean;
    }>): void;
    protected onMenuButtonClick_(): void;
    private showDrawerMenu_;
    protected onDrawerClose_(): void;
    protected handleContentNavigation_(itemToRender: ItemsToRender, event: CustomEvent<Metadata>): void;
    setNarrowForTesting(state: boolean): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'private-state-tokens-app': PrivateStateTokensAppElement;
    }
}
