// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
export class Router{static instance;observers=new Set;currentPage=null;currentSearchQuery=null;constructor(){window.addEventListener("popstate",(()=>{const{page:page,searchQuery:searchQuery}=this.getRouteFromUrl();this.setRoute(page,searchQuery)}))}static resetInstanceForTesting(){Router.instance=undefined}static getInstance(){if(!Router.instance){Router.instance=new Router}return Router.instance}navigateTo(pageName){if(pageName===this.currentPage){return}const url=new URL(window.location.href);url.searchParams.set("page",pageName);url.searchParams.delete("search");history.pushState({page:pageName},"",url.toString());this.setRoute(pageName,null)}setSearchQuery(query){const newQuery=query?.trim()||null;if(newQuery===this.currentSearchQuery){return}const url=new URL(window.location.href);if(newQuery){url.searchParams.set("search",newQuery)}else{url.searchParams.delete("search")}history.replaceState({page:this.currentPage,search:newQuery},"",url.toString());this.setRoute(this.currentPage,newQuery)}processInitialRoute(defaultPage){const routeParams=this.getRouteFromUrl();let page=routeParams.page;const searchQuery=routeParams.searchQuery;if(!page){page=defaultPage;const url=new URL(window.location.href);url.searchParams.set("page",page);history.replaceState({page:page,search:searchQuery},"",url.toString())}this.setRoute(page,searchQuery)}addObserver(observer){this.observers.add(observer)}removeObserver(observer){this.observers.delete(observer)}getRouteFromUrl(){const params=new URLSearchParams(window.location.search);const page=params.get("page");const searchQuery=params.get("search");return{page:page,searchQuery:searchQuery}}setRoute(pageName,searchQuery){if(this.currentPage===pageName&&this.currentSearchQuery===searchQuery){return}this.currentPage=pageName;this.currentSearchQuery=searchQuery;for(const observer of this.observers){observer.onRouteChanged(this.currentPage,this.currentSearchQuery)}}}