// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"./content_setting_pattern_source.js";import"./cr_frame_list.js";import"./mojo_timedelta.js";import"./pref_display.js";import"./pref_page.js";import"chrome://resources/cr_elements/cr_tab_box/cr_tab_box.js";import"./privacy_sandbox_internals.mojom-webui.js";import"./search_bar.js";import{CustomElement}from"chrome://resources/js/custom_element.js";import{contentSettingGroups}from"./content_settings_groups.js";import{ContentSettingsType}from"./content_settings_types.mojom-webui.js";import{highlight,unhighlight}from"./highlight_utils.js";import{getTemplate}from"./internals_page.html.js";import{PrivacySandboxInternalsBrowserProxy}from"./privacy_sandbox_internals_browser_proxy.js";import{Router}from"./router.js";const tpcdExperimentPrefPrefixes=["tpcd_experiment.","uninstall_metrics.installation_date2","profile.cookie_controls_mode","profile.cookie_block_truncated"];const trackingProtectionPrefPrefixes=["profile.managed_cookies_allowed_for_urls","enable_do_not_track","tracking_protection."];const advertisingPrefPrefixes=["privacy_sandbox."];const prefPagesToCreate=[{id:"tracking-protection",title:"Tracking Protection / 3PCD Prefs",prefGroups:[{id:"tracking-protection",title:"Tracking Protection Service Prefs",prefPrefixes:trackingProtectionPrefPrefixes},{id:"tpcd-experiment",title:"3PCD Experiment Prefs",prefPrefixes:tpcdExperimentPrefPrefixes}]},{id:"advertising",title:"Advertising Prefs",prefGroups:[{id:"advertising",title:"Advertising Prefs",prefPrefixes:advertisingPrefPrefixes}]}];export class InternalsPage extends CustomElement{browserProxy_=PrivacySandboxInternalsBrowserProxy.getInstance();tabBox_=null;panels_=this.shadowRoot.querySelectorAll(".panel");activePageName_=null;cachedItems_=new Map;loadedPages_=new Set;static get is(){return"internals-page"}constructor(){super();Router.getInstance().addObserver(this)}connectedCallback(){this.createInitialLayout();this.setupEventListeners();const defaultPage=this.shadowRoot.querySelector('[slot="tab"][selected]')?.dataset["pageName"];Router.getInstance().processInitialRoute(defaultPage)}get tabBox(){if(!this.tabBox_){this.tabBox_=this.shadowRoot.querySelector("#ps-page")}return this.tabBox_}static get template(){return getTemplate()}disconnectedCallback(){Router.getInstance().removeObserver(this)}async onRouteChanged(pageName,query){if(!pageName){return}this.activePageName_=pageName;const frameList=this.shadowRoot.querySelector("#ps-page");const allTabsInDom=Array.from(frameList.querySelectorAll('[slot="tab"]'));let index=allTabsInDom.findIndex((tab=>tab.dataset["pageName"]===pageName));if(index===-1){index=allTabsInDom.findIndex((tab=>tab.hasAttribute("selected")))}if(index!==-1){frameList.setAttribute("selected-index",index.toString())}const allPanels=Array.from(this.panels_);const activePanel=allPanels.find((p=>p.dataset["pageName"]===pageName));allPanels.forEach((p=>{p.hidden=p!==activePanel}));if(activePanel){if(!this.loadedPages_.has(pageName)){await this.loadDataForPage(pageName);this.loadedPages_.add(pageName)}if(activePanel){if(!this.loadedPages_.has(pageName)){await this.loadDataForPage(pageName);this.loadedPages_.add(pageName)}const searchBar=activePanel.querySelector("search-bar");if(searchBar){searchBar.setQuery(query||"");this.filterAndHighlightContent(query);if(query){searchBar.focusInput()}}}}}async loadDataForPage(pageName){const prefPageConfig=prefPagesToCreate.find((p=>p.id===pageName));if(prefPageConfig){await this.loadPrefsForPage(prefPageConfig);return}const settingType=this.getContentSettingsTypeFromName(pageName);if(settingType!==undefined){await this.loadContentSettingsData(settingType,pageName);return}console.warn(`No data loader found for page: ${pageName}`)}getContentSettingsTypeFromName(name){const upperCaseName=name.toUpperCase();return ContentSettingsType[upperCaseName]}filterAndHighlightContent(query){const lowerCaseQuery=query?query.toLowerCase().trim():"";const activeItems=this.cachedItems_.get(this.activePageName_)||[];for(const item of activeItems){const isMatch=!lowerCaseQuery||item.content.includes(lowerCaseQuery);unhighlight(item.element);item.element.hidden=!isMatch;if(isMatch&&lowerCaseQuery){highlight(item.element,lowerCaseQuery)}}}createInitialLayout(){this.createPrefPageLayout();this.createContentSettingsPageLayout();this.panels_=this.shadowRoot.querySelectorAll(".panel")}createPrefPageLayout(){const headerTab=document.createElement("div");headerTab.innerText="Prefs";headerTab.className="settings-category-header";headerTab.setAttribute("role","heading");headerTab.setAttribute("slot","tab");this.tabBox.appendChild(headerTab);const headerPanel=document.createElement("div");headerPanel.setAttribute("slot","panel");this.tabBox.appendChild(headerPanel);prefPagesToCreate.forEach((pageConfig=>{const tab=document.createElement("div");tab.setAttribute("slot","tab");tab.textContent=pageConfig.title;tab.dataset["pageName"]=pageConfig.id;if(pageConfig.id==="tracking-protection"){tab.setAttribute("selected","")}this.tabBox.appendChild(tab);const panel=document.createElement("div");panel.setAttribute("slot","panel");panel.classList.add("panel");panel.dataset["pageName"]=pageConfig.id;panel.hidden=pageConfig.id!=="tracking-protection";const mainContentWrapper=document.createElement("div");mainContentWrapper.className="main-content-wrapper";const searchContainer=document.createElement("div");searchContainer.className="search-bar-container";searchContainer.appendChild(document.createElement("search-bar"));mainContentWrapper.appendChild(searchContainer);const panelsContainer=document.createElement("div");panelsContainer.className="panels-container";pageConfig.prefGroups.forEach((group=>{const heading=document.createElement("h3");heading.textContent=group.title;panelsContainer.appendChild(heading);const prefsPanelDiv=document.createElement("div");prefsPanelDiv.id=`${group.id}-prefs-panel`;panelsContainer.appendChild(prefsPanelDiv)}));mainContentWrapper.appendChild(panelsContainer);panel.appendChild(mainContentWrapper);this.tabBox.appendChild(panel)}))}async loadPrefsForPage(pageConfig){const allPrefPrefixesForPage=pageConfig.prefGroups.flatMap((prefGroup=>prefGroup.prefPrefixes));const uniquePrefixes=[...new Set(allPrefPrefixesForPage)];const{prefs:prefs}=await this.browserProxy_.handler.readPrefsWithPrefixes(uniquePrefixes);pageConfig.prefGroups.forEach((prefGroup=>{this.addPrefsToDom(this.shadowRoot.querySelector("#"+prefGroup.id+"-prefs-panel"),prefs.filter((pref=>prefGroup.prefPrefixes.some((prefix=>pref.name.startsWith(prefix))))),pageConfig.id)}))}addPrefsToDom(parentElement,prefs,pageName){if(!parentElement){console.error("Parent element not found for pref group.");return}if(!this.cachedItems_.has(pageName)){this.cachedItems_.set(pageName,[])}const pageItems=this.cachedItems_.get(pageName);prefs.forEach((({name:name,value:value})=>{const item=document.createElement("pref-display");item.configure(name,value);parentElement.appendChild(item);const contentString=`${name} ${JSON.stringify(value)}`.toLowerCase();pageItems.push({element:item,content:contentString})}))}createContentSettingsPageLayout(){const shouldShowTpcdMetadataGrants=this.browserProxy_.shouldShowTpcdMetadataGrants();const addHeaderToTabBox=(name,className)=>{const headerTab=document.createElement("div");headerTab.innerText=name;headerTab.className=className;headerTab.setAttribute("role","heading");headerTab.setAttribute("slot","tab");this.tabBox.appendChild(headerTab);const headerPanel=document.createElement("div");headerPanel.setAttribute("slot","panel");this.tabBox.appendChild(headerPanel)};const addContentSettingPanel=setting=>{if(setting===ContentSettingsType.TPCD_METADATA_GRANTS&&!shouldShowTpcdMetadataGrants){return}if(setting===ContentSettingsType.DEFAULT){return}const pageName=ContentSettingsType[setting].toLowerCase();const tab=document.createElement("div");tab.innerText=ContentSettingsType[setting];tab.setAttribute("slot","tab");tab.dataset["pageName"]=pageName;this.tabBox.appendChild(tab);const panel=document.createElement("div");panel.setAttribute("slot","panel");panel.classList.add("panel");panel.dataset["pageName"]=pageName;panel.hidden=true;const mainContentWrapper=document.createElement("div");mainContentWrapper.className="main-content-wrapper";const searchContainer=document.createElement("div");searchContainer.className="search-bar-container";searchContainer.appendChild(document.createElement("search-bar"));mainContentWrapper.appendChild(searchContainer);const panelsContainer=document.createElement("div");panelsContainer.className="panels-container";const panelTitle=document.createElement("h2");panelTitle.innerText=ContentSettingsType[setting];panelsContainer.appendChild(panelTitle);const contentSettingsContainer=document.createElement("div");contentSettingsContainer.classList.add("content-settings");panelsContainer.appendChild(contentSettingsContainer);mainContentWrapper.appendChild(panelsContainer);panel.appendChild(mainContentWrapper);this.tabBox.appendChild(panel)};addHeaderToTabBox("Content Settings","settings-category-header");const otherSettings=new Set;for(let i=ContentSettingsType.MIN_VALUE;i<=ContentSettingsType.MAX_VALUE;i++){if(i!==ContentSettingsType.DEFAULT){otherSettings.add(i)}}contentSettingGroups.forEach((group=>{addHeaderToTabBox(group.name,"setting-header");group.settings.forEach((setting=>{addContentSettingPanel(setting);otherSettings.delete(setting)}))}));otherSettings.forEach((setting=>addContentSettingPanel(setting)))}async loadContentSettingsData(setting,pageName){const panel=this.shadowRoot.querySelector(`.panel[data-page-name="${pageName}"] .content-settings`);if(!panel){console.error(`Content settings panel for ${pageName} not found.`);return}const handler=this.browserProxy_.handler;const shouldShowTpcdMetadataGrants=this.browserProxy_.shouldShowTpcdMetadataGrants();let mojoResponse;if(setting===ContentSettingsType.TPCD_METADATA_GRANTS){if(!shouldShowTpcdMetadataGrants){return}mojoResponse=await handler.getTpcdMetadataGrants()}else{mojoResponse=await handler.readContentSettings(setting)}if(!this.cachedItems_.has(pageName)){this.cachedItems_.set(pageName,[])}const pageItems=this.cachedItems_.get(pageName);for(const cs of mojoResponse.contentSettings){const item=document.createElement("content-setting-pattern-source");panel.appendChild(item);const content=await item.configure(handler,cs);pageItems.push({element:item,content:content.toLowerCase()})}}setupEventListeners(){this.tabBox.addEventListener("selected-index-change",(()=>{const selectedTab=this.tabBox.querySelector('[slot="tab"][selected]');if(selectedTab?.dataset["pageName"]){Router.getInstance().navigateTo(selectedTab.dataset["pageName"])}}))}}customElements.define("internals-page",InternalsPage);