import type { ChromeEvent } from '/tools/typescript/definitions/chrome_event.js';
type SaveRequestType = chrome.pdfViewerPrivate.SaveRequestType;
type SaveToDriveProgress = chrome.pdfViewerPrivate.SaveToDriveProgress;
export interface PdfViewerPrivateProxy {
    onSaveToDriveProgress: ChromeEvent<(url: string, progress: SaveToDriveProgress) => void>;
    saveToDrive(saveRequestType?: SaveRequestType): void;
    setPdfDocumentTitle(title: string): void;
}
export declare class PdfViewerPrivateProxyImpl implements PdfViewerPrivateProxy {
    onSaveToDriveProgress: ChromeEvent<(url: string, progress: SaveToDriveProgress) => void>;
    saveToDrive(saveRequestType?: SaveRequestType): void;
    setPdfDocumentTitle(title: string): void;
    static getInstance(): PdfViewerPrivateProxy;
    static setInstance(obj: PdfViewerPrivateProxy): void;
}
export {};
