import './viewer_thumbnail.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { PropertyValues } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { ViewerThumbnailElement } from './viewer_thumbnail.js';
export interface Ink2ThumbnailData {
    type: string;
    pageNumber: number;
    isInk: boolean;
    imageData: ArrayBuffer;
    width: number;
    height: number;
}
export interface ViewerThumbnailBarElement {
    $: {
        thumbnails: HTMLElement;
    };
}
export declare class ViewerThumbnailBarElement extends CrLitElement {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        activePage: {
            type: NumberConstructor;
        };
        clockwiseRotations: {
            type: NumberConstructor;
        };
        docLength: {
            type: NumberConstructor;
        };
        isPluginActive_: {
            type: BooleanConstructor;
        };
    };
    accessor activePage: number;
    accessor clockwiseRotations: number;
    accessor docLength: number;
    protected accessor isPluginActive_: boolean;
    private intersectionObserver_;
    private pluginController_;
    private tracker_;
    inTest: boolean;
    constructor();
    firstUpdated(): void;
    updated(changedProperties: PropertyValues<this>): void;
    private clickThumbnailForPage;
    getThumbnailForPage(pageNumber: number): ViewerThumbnailElement | null;
    /** @return The array of page numbers. */
    protected computePageNumbers_(): number[];
    protected getAriaLabel_(pageNumber: number): string;
    /** @return Whether the page is the current page. */
    protected isActivePage_(page: number): boolean;
    /** Forwards focus to a thumbnail when tabbing. */
    private onFocus_;
    private onKeydown_;
    private handleUpdateInkThumbnail_;
}
declare global {
    interface HTMLElementTagNameMap {
        'viewer-thumbnail-bar': ViewerThumbnailBarElement;
    }
}
