// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { html } from 'chrome://resources/lit/v3_0/lit.rollup.js';
export function getHtml() {
    return html `<!--_html_template_start_-->
<cr-icon-button id="save"
    iron-icon="${this.getIronIcon()}"
    @click="${this.onSaveClick}" aria-label="$i18n{tooltipSaveToDrive}"
    aria-haspopup="${this.getAriaHasPopup()}"
    title="$i18n{tooltipSaveToDrive}"></cr-icon-button>
  ${this.isUploading_() ? html `
    <circular-progress-ring .value="${this.progress}">
    </circular-progress-ring>
  ` : ''}
<cr-action-menu id="menu">
  <button id="save-edited" class="dropdown-item"
      @click="${this.onSaveEditedClick}">
    $i18n{downloadEdited}
  </button>
  <button id="save-original" class="dropdown-item"
      @click="${this.onSaveOriginalClick}">
    $i18n{downloadOriginal}
  </button>
</cr-action-menu>
<!--_html_template_end_-->`;
}
