// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import 'chrome://resources/cr_elements/cr_icon_button/cr_icon_button.js';
import { I18nMixinLit } from 'chrome://resources/cr_elements/i18n_mixin_lit.js';
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { TextStyle } from '../constants.js';
import { Ink2Manager } from '../ink2_manager.js';
import { InkTextObserverMixin } from './ink_text_observer_mixin.js';
import { getCss } from './text_styles_selector.css.js';
import { getHtml } from './text_styles_selector.html.js';
const TextStylesSelectorElementBase = InkTextObserverMixin(I18nMixinLit(CrLitElement));
export class TextStylesSelectorElement extends TextStylesSelectorElementBase {
    static get is() {
        return 'text-styles-selector';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            currentStyles_: { type: Object },
        };
    }
    #currentStyles__accessor_storage = {
        [TextStyle.BOLD]: false,
        [TextStyle.ITALIC]: false,
    };
    get currentStyles_() { return this.#currentStyles__accessor_storage; }
    set currentStyles_(value) { this.#currentStyles__accessor_storage = value; }
    getTextStyles_() {
        return Object.values(TextStyle);
    }
    onStyleButtonClick_(e) {
        const style = e.target.dataset['style'];
        const newStyles = Object.assign({}, this.currentStyles_);
        newStyles[style] = !newStyles[style];
        Ink2Manager.getInstance().setTextStyles(newStyles);
    }
    getActiveClass_(style) {
        return this.currentStyles_[style] ? 'active' : '';
    }
    getAriaPressed_(style) {
        return this.currentStyles_[style] ? 'true' : 'false';
    }
    getTitle_(style) {
        switch (style) {
            case TextStyle.BOLD:
                return this.i18n('ink2TextStyleBold');
            case TextStyle.ITALIC:
                return this.i18n('ink2TextStyleItalic');
        }
    }
    onTextAttributesChanged(attributes) {
        this.currentStyles_ = attributes.styles;
    }
}
customElements.define(TextStylesSelectorElement.is, TextStylesSelectorElement);
