import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { PropertyValues } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type { TextAttributes } from '../constants.js';
export interface InkTextBoxElement {
    $: {
        textbox: HTMLTextAreaElement;
    };
}
export declare enum TextBoxState {
    INACTIVE = 0,// No active text annotation being edited; box is hidden.
    NEW = 1,// Box initialized with an annotation, but user has not made edits.
    EDITED = 2
}
declare const InkTextBoxElementBase: typeof CrLitElement & (new (...args: any[]) => import("./ink_text_observer_mixin.js").InkTextObserverMixinInterface);
export declare class InkTextBoxElement extends InkTextBoxElementBase {
    static get is(): string;
    static get styles(): import("chrome://resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("chrome://resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        height_: {
            type: NumberConstructor;
        };
        locationX_: {
            type: NumberConstructor;
        };
        locationY_: {
            type: NumberConstructor;
        };
        minHeight_: {
            type: NumberConstructor;
        };
        minWidth_: {
            type: NumberConstructor;
        };
        state_: {
            type: NumberConstructor;
        };
        textOrientation_: {
            type: NumberConstructor;
        };
        textRotations_: {
            type: NumberConstructor;
            reflect: boolean;
        };
        textValue_: {
            type: StringConstructor;
        };
        viewportRotations_: {
            type: NumberConstructor;
        };
        width_: {
            type: NumberConstructor;
        };
        zoom_: {
            type: NumberConstructor;
        };
    };
    private accessor locationX_;
    private accessor locationY_;
    private accessor minHeight_;
    private accessor minWidth_;
    private accessor height_;
    private accessor state_;
    private accessor textOrientation_;
    protected accessor textRotations_: number;
    protected accessor textValue_: string;
    private accessor viewportRotations_;
    private accessor width_;
    private accessor zoom_;
    private attributes_?;
    private currentArrowKey_;
    private dragTarget_;
    private eventTracker_;
    private existing_;
    private id_;
    private keyDownCount_;
    private pageNumber_;
    private pageHeight_;
    private pageWidth_;
    private pageX_;
    private pageY_;
    private pointerStart_;
    private startPosition_;
    firstUpdated(changedProperties: PropertyValues<this>): void;
    connectedCallback(): void;
    disconnectedCallback(): void;
    willUpdate(changedProperties: PropertyValues<this>): void;
    updated(changedProperties: PropertyValues<this>): void;
    private styleFontSize_;
    protected onFocus_(e: FocusEvent): void;
    protected onTextValueInput_(): void;
    private textBoxEdited_;
    private updateMinimumSize_;
    private removePointerDragListeners_;
    private removeKeyDragListeners_;
    private resetDrag_;
    commitTextAnnotation(): void;
    private onInitializeTextBox_;
    private focusTextboxWhenReady_;
    private onViewportChanged_;
    private onDocumentKeyDown_;
    private onKeyDown_;
    private onHandleKeyUp_;
    protected onPointerDown_(e: PointerEvent): void;
    private onHandlePointerMove_;
    private onMove_;
    private onHandlePointerUp_;
    private updateTextAttributes_;
    onTextAttributesChanged(newAttributes: TextAttributes): void;
}
declare global {
    interface HTMLElementTagNameMap {
        'ink-text-box': InkTextBoxElement;
    }
}
export {};
