import {html} from 'chrome://resources/lit/v3_0/lit.rollup.js';
import type {PdfViewerElement} from './pdf_viewer.js';

import {AnnotationMode} from './constants.js';


export function getHtml(this: PdfViewerElement) {
  return html`<!--_html_template_start_--><!-- #html_wrapper_imports_start

import {AnnotationMode} from './constants.js';

#html_wrapper_imports_end -->

<viewer-toolbar id="toolbar"
    .docTitle="${this.title_}" .docLength="${this.docLength_}"
    .embeddedViewer="${this.embedded_}" .pageNo="${this.pageNo_}"
    .loadProgress="${this.loadProgress_}" .hasEdits="${this.hasEdits_}"
    .strings="${this.strings}"

    .annotationMode="${this.annotationMode_}"
    .enableUndoRedo="${!this.isTextboxActive_()}"
    .hasInk2Edits="${this.hasInk2AnnotationEdits_()}"

    .rotated="${this.isRotated_()}"
    .formFieldFocus="${this.formFieldFocus_}"
    .sidenavCollapsed="${this.sidenavCollapsed_}"
    .twoUpViewEnabled="${this.twoUpViewEnabled_}"
    .viewportZoom="${this.viewportZoom_}"
    .zoomBounds="${this.zoomBounds_}"

    .annotationAvailable="${this.annotationAvailable_()}"
    .pdfInk2Enabled="${this.pdfInk2Enabled_}"


    .pdfSaveToDriveEnabled="${this.pdfSaveToDriveEnabled_}"
    .saveToDriveProgress="${this.getSaveToDriveProgress_()}"
    .saveToDriveState="${this.saveToDriveState_}"

    @change-page="${this.onChangePage_}"
    @display-annotations-changed="${this.onDisplayAnnotationsChanged_}"
    @fit-to-changed="${this.onFitToChanged}"
    @present-click="${this.onPresentClick_}"
    @properties-click="${this.onPropertiesClick_}"
    @sidenav-toggle-click="${this.onSidenavToggleClick_}"
    @two-up-view-changed="${this.onTwoUpViewChanged_}"
    @zoom-changed="${this.onZoomChanged}" @zoom-in="${this.onZoomIn}"
    @zoom-out="${this.onZoomOut}" @rotate-left="${this.rotateCounterclockwise}"

    @annotation-mode-updated="${this.onAnnotationModeUpdated_}"

    @print="${this.onPrint_}" @save="${this.onToolbarSave_}"

    @save-to-drive="${this.onSaveToDrive_}"


    @strokes-updated="${this.onStrokesUpdated_}"

    hidden>
</viewer-toolbar>

<div id="container">
  <div id="sidenav-container" ?closed="${this.sidenavCollapsed_}"
      ?hidden="${!this.toolbarEnabled_}">
    <viewer-pdf-sidenav id="sidenav"
        .activePage="${this.pageNo_}" .attachments="${this.attachments_}"
        .bookmarks="${this.bookmarks_}"
        .clockwiseRotations="${this.clockwiseRotations_}"
        .docLength="${this.docLength_}"
        .strings="${this.strings}"
        @change-page="${this.onChangePage_}"
        @change-page-and-xy="${this.onChangePageAndXy_}"
        @navigate="${this.onNavigate_}"
        @save-attachment="${this.onSaveAttachment_}">
    </viewer-pdf-sidenav>
  </div>
  <div id="main">
    <div id="scroller">
      <div id="sizer">
      </div>
      
        ${this.isInTextAnnotationMode_() ? html`
          <div class="text-box-container">
            <ink-text-box @state-changed="${this.onTextBoxStateChanged_}">
            </ink-text-box>
          </div>` : ''}
      
      <div id="content">
      </div>
    </div>
    <div id="content-focus-rectangle" ?hidden="${!this.documentHasFocus_}">
    </div>
    
      ${this.shouldShowInkBottomToolbar_() ? html`
        <cr-page-selector id="bottom" attr-for-selected="toolbar-name"
            selected="${this.annotationMode_}">
          <viewer-bottom-toolbar .strings="${this.strings}"
              toolbar-name="${AnnotationMode.DRAW}">
          </viewer-bottom-toolbar>
          <viewer-text-bottom-toolbar toolbar-name="${AnnotationMode.TEXT}">
          </viewer-text-bottom-toolbar>
        </cr-page-selector>` : ''}
    
  </div>
  
    ${this.shouldShowInkSidePanel_() ? html`
      <cr-page-selector attr-for-selected="page-name" id="side-panel"
          selected="${this.annotationMode_}">
        <viewer-side-panel page-name="${AnnotationMode.DRAW}">
        </viewer-side-panel>
        <viewer-text-side-panel page-name="${AnnotationMode.TEXT}">
        </viewer-text-side-panel>
      </cr-page-selector>
    ` : ''}
  
  <cr-toast id="searchifyProgress">
    <div class="spinner"></div>
    <span>$i18n{searchifyInProgress}</span>
  </cr-toast>
</div>

${this.showErrorDialog ? html`<viewer-error-dialog id="error-dialog">
</viewer-error-dialog>` : ''}

${this.showPasswordDialog_ ? html`<viewer-password-dialog id="password-dialog"
    @close="${this.onPasswordDialogClose_}"
    @password-submitted="${this.onPasswordSubmitted_}">
</viewer-password-dialog>` : ''}

${this.showPropertiesDialog_ ? html`<viewer-properties-dialog
    id="properties-dialog"
    .documentMetadata="${this.documentMetadata_}"
    .fileName="${this.fileName_}"
    .pageCount="${this.docLength_}"
    .strings="${this.strings}"
    @close="${this.onPropertiesDialogClose_}">
</viewer-properties-dialog>` : ''}


${this.pdfSaveToDriveEnabled_ ? html`<viewer-save-to-drive-bubble
    .docTitle="${this.title_}"
    .progress="${this.saveToDriveProgress_}"
    .state="${this.saveToDriveState_}"
    @save-to-drive-bubble-action="${this.onSaveToDriveBubbleAction_}">
</viewer-save-to-drive-bubble>` : ''}

<!--_html_template_end_-->`;
}