import {css, CSSResultGroup} from 'chrome://resources/lit/v3_0/lit.rollup.js';
import {getCss as getCrHiddenStyleLit} from 'chrome://resources/cr_elements/cr_hidden_style_lit.css.js';
import 'chrome://resources/cr_elements/cr_shared_vars.css.js';
import {getCss as getCrSpinnerStyleLit} from 'chrome://resources/cr_elements/cr_spinner_style_lit.css.js';
import './elements/shared_vars.css.js';
import {getCss as getPdfViewerSharedStyle} from './pdf_viewer_shared_style.css.js';

let instance: CSSResultGroup|null = null;
export function getCss() {
  return instance || (instance = [...[getPdfViewerSharedStyle(),getCrHiddenStyleLit(),getCrSpinnerStyleLit()], css`:host{--viewer-pdf-sidenav-width:300px;display:flex;flex-direction:column;height:100%;width:100%}viewer-pdf-sidenav,viewer-toolbar{--pdf-toolbar-text-color:rgb(241,241,241)}#side-panel{border-inline-start:1px solid var(--viewer-border-color)}viewer-toolbar{--active-button-bg:rgba(255,255,255,0.24);z-index:1}@media (max-width:200px),(max-height:250px){viewer-toolbar{display:none}}#bottom{display:flex;justify-content:center}#sidenav-container{border-inline-end:1px solid var(--viewer-border-color);overflow:hidden;transition:transform 250ms cubic-bezier(.6,0,0,1),visibility 250ms;visibility:visible;width:var(--viewer-pdf-sidenav-width)}#sidenav-container.floating{bottom:0;position:absolute;top:0;z-index:1}#sidenav-container[closed]{transform:translateX(-100%);transition:transform 200ms cubic-bezier(.6,0,0,1),visibility 200ms,width 0ms 200ms;visibility:hidden;width:0}:host-context([dir='rtl']) #sidenav-container[closed]{transform:translateX(100%)}@media (max-width:500px),(max-height:250px){#sidenav-container{display:none}}#content-focus-rectangle{border:2px solid var(--google-grey-500);border-radius:2px;box-sizing:border-box;height:100%;pointer-events:none;position:absolute;top:0;width:100%}viewer-ink-host{height:100%;position:absolute;width:100%}#container{display:flex;flex:1;overflow:hidden;position:relative}#plugin{position:initial}#content{height:100%;left:0;position:sticky;top:0;user-select:none;z-index:initial}#sizer{top:0;width:100%;z-index:initial}#main{flex:1;overflow:hidden;position:relative}#scroller{direction:ltr;height:100%;overflow:auto;position:relative}#scroller:fullscreen{overflow:hidden}.spinner{mask-image:url(chrome://resources/images/throbber_small.svg);margin-inline-end:8px;--cr-spinner-size:16px}#searchifyProgress{--cr-toast-background:rgb(227,227,227);--cr-toast-text-color:rgb(31,31,31)}.text-box-container{height:calc(100% - var(--horizontal-scrollbar-width,0px));left:0;overflow:hidden;position:absolute;top:0;width:calc(100% - var(--vertical-scrollbar-width,0px))}
`]);
}