import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style>#description{margin-top:16px}a[href]{color:var(--cr-link-color)}</style>

<cr-dialog id="dialog" close-text="$i18n{close}" show-on-attach>
  <div slot="title">
    <share-password-dialog-header id="header">
      [[dialogTitle]]
    </share-password-dialog-header>
  </div>
  <div slot="body">
    <picture>
      <source srcset="./images/password_sharing_family_banner_dark.svg"
          media="(prefers-color-scheme: dark)">
      <img src="./images/password_sharing_family_banner.svg"
          role="presentation">
    </picture>
    <div id="description" on-click="onDescriptionClick_"
        inner-h-t-m-l="[[i18nAdvanced('sharePasswordNoOtherFamilyMembers')]]">
    </div>
  </div>
  <div slot="button-container">
    <cr-button class="action-button" on-click="onClickActionButton_"
         id="action">
      $i18n{sharePasswordGotIt}
    </cr-button>
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}
