import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="shared-style cr-shared-style cr-spinner-style">#tryAgainButton{margin-inline-start:8px}cr-link-row[hide-icon]::part(icon){display:none}
 </style>

<cr-link-row class="cr-row" non-clickable label="$i18n{exportPasswords}"
    sub-label="$i18n{exportPasswordsDescription}" hide-icon>
    <template is="dom-if" if="[[!showExportInProgress_]]" restamp>
      <cr-button id="exportPasswordsButton" class="cr-row-action-button"
          on-click="onExportClick_" aria-label="[[getAriaLabel_()]]">
        $i18n{downloadFile}
      </cr-button>
    </template>
    <div class="spinner" hidden$="[[!showExportInProgress_]]"></div>
</cr-link-row>

<template is="dom-if" if="[[showPasswordsExportErrorDialog_]]" restamp>
  <cr-dialog id="dialogError" close-text="$i18n{close}" show-on-attach>
    <div slot="title" class="dialog-title">
      [[exportErrorMessage_]]
    </div>
    <div slot="body">
      $i18n{exportPasswordsFailTips}
      <ul>
        <li>$i18n{exportPasswordsFailTipsEnoughSpace}</li>
        <li>$i18n{exportPasswordsFailTipsAnotherFolder}</li>
      </ul>
    </div>
    <div slot="button-container">
      <cr-button id="cancelButton" on-click="closePasswordsExportErrorDialog_"
          autofocus>
        $i18n{cancel}
      </cr-button>
      <cr-button id="tryAgainButton" class="action-button"
        on-click="onTryAgainClick_">
        $i18n{exportPasswordsTryAgain}
      </cr-button>
    </div>
  </cr-dialog>
</template>

<cr-toast id="exportSuccessToast" duration="2500">
  <div>$i18n{exportSuccessful}</div>
  <cr-button id="openInShellButton" on-click="onOpenInShellButtonClick_">
    $i18n{downloadLinkShow}
  </cr-button>
</cr-toast>
<!--_html_template_end_-->`;
}
