import { html } from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
    return html `<!--_html_template_start_--><style include="shared-style cr-shared-style">#checkbox{--cr-checkbox-size:14px;--cr-checkbox-border-size:1px;--cr-checkbox-ripple-size:36px;flex-grow:0;margin-inline-end:8px}site-favicon{height:16px;padding-inline-end:8px;width:16px}#container{align-items:center;display:grid;flex-grow:1;grid-template-columns:auto 125px;padding-inline-end:8px;width:100%}.url-username-group{column-gap:16px;display:grid;grid-template-columns:fit-content(50%) 1fr;padding-inline-end:16px;width:100%}#website{color:var(--cr-primary-text-color)}#password{background-color:transparent;border:none;color:var(--cr-secondary-text-color)}#password:disabled{flex:none;font-family:inherit;margin-inline-start:auto;text-overflow:clip;width:50px}cr-icon-button{--cr-icon-button-margin-start:8px}cr-checkbox::part(label-container){clip:rect(0,0,0,0);display:block;position:fixed}</style>
<div class="flex-centered">
  <cr-checkbox id="checkbox" checked="{{checked}}">
    [[url]], [[username]]
  </cr-checkbox>
  <div id="container" class$="[[getElementClass_(first)]]">
    <div class="flex-centered">
      <site-favicon domain="[[url]]" aria-hidden="true">
      </site-favicon>
      <div class="url-username-group">
        <div id="website" class="text-elide">[[url]]</div>
        <div id="username" class="text-elide">[[username]]</div>
      </div>
    </div>
    <div class="flex-centered">
      <input id="password" readonly class="text-elide password-input"
          type="[[getPasswordInputType(isPasswordVisible)]]"
          disabled$="[[!isPasswordVisible]]"
          value="[[getPasswordValue_(isPasswordVisible, password)]]">
      <cr-icon-button id="showPasswordButton"
          title="[[getShowHideButtonLabel(isPasswordVisible)]]"
          class$="[[getShowHideButtonIconClass(isPasswordVisible)]]"
          on-click="onShowHidePasswordButtonClick"
          aria-label="[[getShowHidePasswordButtonA11yLabel_(isPasswordVisible)]]">
      </cr-icon-button>
    </div>
  </div>
</div>
<!--_html_template_end_-->`;
}
