import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="shared-style">:host{margin-top:8px;padding:8px 24px 8px 8px;border:0.5px solid var(--cr-separator-color);border-radius:25px;display:grid;grid-template-columns:auto min-content;column-gap:12px;cursor:pointer}:host([disabled]){cursor:initial}:host([disabled])>.content{opacity:var(--cr-disabled-opacity)}:host(:not([disabled]):not([selected]):is(:hover,:focus)){background:var(--google-grey-100)}:host([selected]){border-color:var(--google-blue-300);background:var(--google-blue-50)}#checkbox{opacity:0;margin:auto;--cr-checkbox-ripple-size:36px}:host([selected]) #checkbox,:host(:not([disabled]):is(:hover,:focus)) #checkbox{opacity:100}:host([selected]) #avatar,:host(:not([disabled]):is(:hover,:focus)) #avatar{opacity:0}.content{display:grid;grid-template-columns:32px auto;column-gap:12px}#avatar{position:absolute;border-radius:50%;height:32px;margin-inline-end:8px;width:32px}.user-data{margin-block:auto}#name{font-size:100%;color:var(--cr-primary-text-color);line-height:normal}#email{font-size:85%;color:var(--cr-secondary-text-color);line-height:normal}.disabled-info{margin-inline-start:auto}#notAvailable{font-size:85%;margin-top:0.15rem;white-space:nowrap}cr-tooltip-icon{--cr-icon-size:16px;margin-inline-end:4px}.avatar-checkbox{position:relative;width:32px;height:32px;margin-block:auto}cr-checkbox::part(label-container){clip:rect(0,0,0,0);display:block;position:fixed}@media (prefers-color-scheme:dark){:host(:not([disabled]):not([selected]):is(:hover,:focus)){background:var(--google-grey-900)}:host([selected]){background:rgb(0,74,119);border-color:var(--google-blue-600)}}</style>

<div class="content">
  <div class="flex-centered avatar-checkbox">
    <cr-checkbox id="checkbox" disabled$="[[disabled]]" checked="{{selected}}">
      [[recipient.displayName]], [[recipient.email]]
    </cr-checkbox>
    <img is="cr-auto-img" id="avatar" auto-src="[[recipient.profileImageUrl]]"
        draggable="false" alt="">
  </div>
  <div class="user-data text-elide">
    <div id="name" class="text-elide">[[recipient.displayName]]</div>
    <div id="email" class="text-elide">[[recipient.email]]</div>
  </div>
</div>
<template is="dom-if" if="[[disabled]]" restamp>
  <div id="disabled-info" class="flex-centered">
    <cr-tooltip-icon tooltip-text="$i18n{sharePasswordMemeberUnavailable}"
        icon-class="cr:info-outline"
        icon-aria-label="[[recipient.displayName]], $i18n{sharePasswordMemeberUnavailable}">
    </cr-tooltip-icon>
    <span id="notAvailable">$i18n{sharePasswordNotAvailable}</span>
  </div>
</template>
<!--_html_template_end_-->`;
}