import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="cr-hidden-style">a[href]{color:var(--cr-link-color)}cr-dialog{--cr-dialog-width:320px;--cr-dialog-body-padding-horizontal:16px}.animation-container{height:95px;position:relative;--avatar-radius:30px;--avatar-size_:calc(var(--avatar-radius) * 2)}#senderAvatar,#recipientAvatar,#lock,#progress,#favicon{position:absolute}#senderAvatar,#recipientAvatar{top:50%;right:50%;transform:translate(50%,-50%);transition:right 500ms cubic-bezier(0.7,0,0.45,1.45)}#senderAvatar{border-radius:50%;height:var(--avatar-size_);width:var(--avatar-size_);z-index:1}#recipientAvatar{z-index:2}#lock{z-index:3;background-color:var(--cr-dialog-background-color,white);top:50%;right:50%;width:24px;height:24px;opacity:0;transform:translate(50%,-50%) scale(0.5);transition:opacity 0.15s ease-in 500ms,transform 0.15s ease-in 500ms}#favicon{--site-favicon-height:22px;--site-favicon-width:22px;background:white;z-index:3;border:4px solid white;border-radius:7px;top:calc(50% + var(--avatar-radius) - 10px);right:50%;opacity:0;transform:translate(50%,0) scale(0);transition:opacity 0.15s ease-in 500ms,transform 0.15s ease-in 500ms}#progress{z-index:0;display:flex;overflow:hidden;top:50%;left:calc(50% - 47px);width:0;transition:all 4.1s linear 500ms,opacity 0.15s ease-in 500ms}.loading #senderAvatar{right:calc(50% + 78px)}.loading #recipientAvatar{right:calc(50% - 78px)}.loading #progress{opacity:1;width:95px}.loading #lock{opacity:1;transform:translate(50%,-50%) scale(1)}[success] #senderAvatar{right:calc(50% + var(--avatar-radius) - 4px);z-index:2}[success] #recipientAvatar{z-index:1;right:calc(50% - var(--avatar-radius) + 4px)}[success] #lock,[success] #progress{opacity:0;transition-delay:0s}[success] #favicon{opacity:1;transform:translate(50%,0) scale(1)}[canceled] #progress{opacity:0;transition:none}[canceled] #senderAvatar{z-index:2}[canceled] #recipientAvatar{z-index:1}[canceled] #lock,[canceled] #senderAvatar,[canceled] #recipientAvatar{transition-property:transform,opacity,right;transition-timing-function:cubic-bezier(0.7,-0.45,0.45,1);transition-duration:500ms;transition-delay:0s}#description{margin-top:16px;overflow:hidden;text-overflow:ellipsis}div[slot='footer']{background:var(--google-grey-100);border-top:none;padding:8px 16px}#footerDescription{color:var(--cr-secondary-text-color);overflow:hidden;text-overflow:ellipsis}@media (prefers-color-scheme:dark){#lock{background-color:var(--cr-dialog-background-color,var(--google-grey-900));background-image:linear-gradient(rgba(255,255,255,.04),rgba(255,255,255,.04))}div[slot='footer']{background:var(--google-grey-900)}#favicon{border-color:var(--google-grey-900);background:var(--google-grey-900)}}</style>

<cr-dialog id="dialog" close-text="$i18n{close}" show-on-attach no-cancel>
  <div slot="title">
    <share-password-dialog-header id="header" aria-live="polite">
      [[getDialogTitle_(dialogStage_)]]
    </share-password-dialog-header>
  </div>
  <div slot="body">
    <div class="animation-container" id="animation"
        canceled$="[[isStage_(dialogStageEnum_.CANCELED, dialogStage_)]]"
        success$="[[isStage_(dialogStageEnum_.SUCCESS, dialogStage_)]]">
      <img id="senderAvatar" src="[[avatarImage]]" draggable="false"
          aria-hidden="true">
      <share-password-group-avatar members="[[recipients]]"
          id="recipientAvatar">
      </share-password-group-avatar>
      <div id="lock">
        <img src="../images/password_sharing_secure_lock.svg"
            aria-hidden="true">
      </div>
      <div id="progress">
        <img src="../images/password_sharing_progress_bar.svg"
            aria-hidden="true">
      </div>
      <site-favicon id="favicon" url="[[iconUrl]]" domain="[[passwordName]]"
          aria-hidden="true">
      </site-favicon>
    </div>
    <div id="description"
        hidden$="[[!isStage_(dialogStageEnum_.SUCCESS, dialogStage_)]]"
        inner-h-t-m-l="[[getSuccessDescription_(recipients)]]">
    </div>
  </div>
  <div slot="button-container">
    <cr-button class="cancel-button" on-click="onClickCancel_" id="cancel"
        hidden$="[[!isStage_(dialogStageEnum_.LOADING, dialogStage_)]]">
      $i18n{cancel}
    </cr-button>
    <cr-button class="action-button" on-click="onClickDone_" id="done"
        hidden$="[[isStage_(dialogStageEnum_.LOADING, dialogStage_)]]">
      $i18n{done}
    </cr-button>
  </div>
  <div slot="footer" id="footerDescription" on-click="onFooterClick_"
      hidden$="[[!isStage_(dialogStageEnum_.SUCCESS, dialogStage_)]]"
      inner-h-t-m-l="[[getFooterDescription_(password)]]">
  </div>
</cr-dialog>
<!--_html_template_end_-->`;
}