import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="shared-style cr-shared-style">#container:hover{background-color:var(--cr-hover-background-color);border-radius:inherit;cursor:pointer;--cr-icon-button-hover-background-color:transparent;--cr-icon-button-active-background-color:transparent}#borderPart{display:grid;flex:1;grid-template-columns:auto 1fr;min-height:var(--section-min-height)}#favicon{margin-inline-end:20px;margin-inline-start:20px}.label{overflow:hidden;text-overflow:ellipsis;white-space:nowrap}#numberOfAccounts{margin-inline-start:8px;unicode-bidi:embed}#endIcons{--cr-icon-button-margin-start:0px;--cr-icon-button-margin-end:10px;justify-self:end}cr-tooltip{overflow:hidden;white-space:nowrap}span{color:var(--cr-secondary-text-color)}#localPasswordsIcon{--iron-icon-width:16px;--iron-icon-height:16px}</style>
<div id="container" class="flex-centered">
  <!-- TODO(crbug.com/40234318): Support icons for android apps. -->
  <site-favicon id="favicon" url="[[item.iconUrl]]"
      domain="[[item.name]]" aria-hidden="true">
  </site-favicon>
  <div id="borderPart" class$="[[getElementClass_(first)]]">
    <div class="label" aria-hidden="true">
      <searchable-label id="displayedName"
          title="[[getTitle_(item, searchTerm)]]"
          search-term="[[searchTerm]]"></searchable-label>
      <span id="numberOfAccounts"
          hidden="[[!showNumberOfAccounts_(item, searchTerm)]]">
        [[numberOfAccounts_]]
      </span>
    </div>

    <div id="endIcons">
      <cr-icon id="localPasswordsIcon"
          icon="cr20:cloud-off" aria-hidden="true"
          hidden="[[!shouldShowDeviceOnlyCredentialsIcon_(isAccountStoreUser, item.entries)]]">
      </cr-icon>
      <cr-icon-button id="seePasswordDetails" class="subpage-arrow"
          aria-label="[[getAriaLabel_(item, deviceOnlyCredentialsAccessibilityLabelText_)]]">
      </cr-icon-button>
    </div>
  </div>
</div>

<cr-tooltip position="top"
    for="localPasswordsIcon" offset="0">[[tooltipText_]]</cr-tooltip>
<!--_html_template_end_-->`;
}