import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="shared-style cr-shared-style">:host(:not(.multi-card)){background-color:var(--cr-card-background-color);box-shadow:var(--cr-card-shadow);height:100%}#header{align-items:center;display:flex;padding-top:28px}a[href]{color:var(--cr-link-color)}#title{font-family:'Roboto';font-size:14px;font-style:normal;font-weight:500;line-height:20px}.columned-section{display:flex;gap:16px;padding:16px var(--cr-section-padding) 0}settings-collapse-radio-button .columned-section{padding:4px 0 16px 0}.columned-section .column{flex:1;min-width:0}.columned-section .description-header{color:var(--google-blue-600)}.columned-section h2.description-header,.columned-section h3.description-header{font-size:inherit;font-weight:400;margin:0;padding:0}@media (prefers-color-scheme:dark){.columned-section .description-header{color:var(--google-blue-300)}}.columned-section ul{list-style-type:none;padding-inline-start:0}.columned-section ul.icon-bulleted-list li{column-gap:16px;display:flex}.columned-section li{margin:16px 0}cr-icon{flex-shrink:0;width:20px;height:20px}</style>

<div id="header">
  <cr-icon-button id="back" class="icon-arrow-back back-button"
      on-click="navigateBack_" aria-label="$i18n{backToSettings}">
  </cr-icon-button>
  <h2 id="title" class="page-title">$i18n{passwordChangeSettingLabel}</h2>
</div>
<div class="cr-row first">
  <div class="flex cr-padded-text">
    <div class="cr-padded-text cr-secondary-text"
      inner-h-t-m-l="[[i18nAdvanced('passwordChangeSettingSubLabel')]]">
    </div>
  </div>
</div>
<div class="columned-section">
  <div class="column">
    <h3 class="description-header">$i18n{columnHeadingWhenUsed}</h3>
    <ul class="icon-bulleted-list cr-secondary-text">
      <li>
        <cr-icon icon="passwords-icon:chat-info" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{passwordChangeSettingDataBreach}</div>
      </li>
      <li>
        <cr-icon icon="cr20:password" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{passwordChangeSettingWhereSaved}</div>
      </li>
    </ul>
  </div>
  <div class="column">
    <h3 class="description-header">$i18n{columnHeadingConsider}</h3>
    <ul class="icon-bulleted-list cr-secondary-text">
      <li>
        <cr-icon icon="passwords-icon:psychiatry" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{passwordChangeSettingExperimental}</div>
      </li>
      <li>
        <cr-icon icon="passwords-icon:account-box" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{passwordChangeSettingContent}</div>
      </li>
      <li>
        <cr-icon icon="passwords-icon:lock" aria-hidden="true"></cr-icon>
        <div class="secondary">$i18n{passwordChangeSettingEncryption}</div>
      </li>
    </ul>
  </div>
</div><!--_html_template_end_-->`;
}