import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="shared-style cr-input-style cr-shared-style
                credential-details-card cr-icons">:host{isolation:auto}</style>
<div class="card" aria-label="[[getAriaLabelForBackupPasswordCard_(password)]]"
    role="region">
  <div class="credential-container">
    <div class="row-container">
      <div class="column-container">
        <credential-field value="[[password.username]]" id="usernameValue"
            label="$i18n{usernameLabel}" copy-button-label="$i18n{copyUsername}"
            value-copied-toast-label="$i18n{usernameCopiedToClipboard}"
            placeholder="$i18n{emptyUsername}"
            interaction-id="[[interactionsEnum_.USERNAME_COPY_BUTTON_CLICKED]]">
        </credential-field>
      </div>
      <div class="column-container">
        <div id="domainLabel" class="cr-form-field-label">
          [[getDomainLabel_(password)]]
        </div>
        <template id="links" is="dom-repeat"
            items="[[password.affiliatedDomains]]">
          <div class="elide-left">
            <a href="[[item.url]]" class="site-link" target="_blank">
              [[item.name]]
            </a>
          </div>
        </template>
      </div>
    </div>
    <div class="row-container">
      <div class="column-container">
        <cr-input id="passwordValue" label="$i18n{passwordLabel}"
            value="[[password.backupPassword.value]]"
            class="input-field password-input" role="textbox"
            type="[[getPasswordInputType(isPasswordVisible)]]" readonly
            aria-disabled="true">
          <cr-icon-button id="showPasswordButton"
              class$="[[getShowHideButtonIconClass(isPasswordVisible)]]"
              title="[[getShowHideButtonLabel(isPasswordVisible)]]"
              on-click="onShowPasswordClick_" slot="inline-suffix">
          </cr-icon-button>
          <cr-icon-button id="copyPasswordButton" class="icon-copy-content"
              title="$i18n{copyPassword}" on-click="onCopyPasswordClick_"
              slot="inline-suffix">
          </cr-icon-button>
        </cr-input>
      </div>
      <div class="column-container">
        <credential-note note="[[getNoteValue_(password)]]" id="noteValue"
            always-expanded>
        </credential-note>
      </div>
    </div>
  </div>
  <div class="button-container">
    <cr-button id="deleteButton" on-click="onDeleteClick_"
        aria-label="[[getAriaLabelForDeleteButton_(password)]]">
      $i18n{deletePassword}
    </cr-button>
  </div>
</div>
<!--_html_template_end_-->`;
}