import {html} from '//resources/polymer/v3_0/polymer/polymer_bundled.min.js';
export function getTemplate() {
  return html`<!--_html_template_start_--><style include="shared-style cr-shared-style">:host(:not(.multi-card)){background-color:var(--cr-card-background-color);box-shadow:var(--cr-card-shadow);height:100%}#header{align-items:center;display:flex;padding-top:28px}#title{font-family:'Roboto';font-size:14px;font-style:normal;font-weight:500;line-height:20px}#body{margin-top:40px;padding-inline-end:20px;padding-inline-start:20px}#subtitle,#expandMutedCompromisedCredentialsButton{color:var(--cr-secondary-text-color);font-weight:500}#description{margin-top:12px}#insecureCredentials{margin-top:24px}.reuse-title{margin-inline-start:20px;margin-top:24px}cr-icon.policy-disabled{margin-inline-start:var(--cr-controlled-by-spacing)}</style>
<div id="header">
  <cr-icon-button class="icon-arrow-back back-button" id="backButton"
      on-click="navigateBack_" aria-label="$i18n{backToCheckup}">
  </cr-icon-button>
  <h2 id="title" class="page-title">[[pageTitle_]]</h2>
</div>
<div id="body">
  <div id="subtitle" class="label"> [[pageSubtitle_]] </div>
  <div id="description" class="cr-secondary-text label">
    [[getDescription_(insecurityType_)]]
  </div>
</div>
<template is="dom-if" if="[[!isReusedType(insecurityType_)]]">
  <template id="insecureCredentials" is="dom-repeat"
      items="[[shownInsecureCredentials_]]" initial-count="50">
    <checkup-list-item item="[[item]]" first="[[!index]]"
        group="[[getCurrentGroup_(item.id, groups_)]]"
        show-details="[[isCompromisedType(insecurityType_)]]"
        show-already-changed=
            "[[clickedChangePassword_(item, clickedChangePasswordIds_.size)]]"
        on-more-actions-click="onMoreActionsClick_"
        on-change-password-clicked="onChangePasswordClick_">
    </checkup-list-item>
  </template>
  <template is="dom-if" if="[[mutedCompromisedCredentials_.length]]">
    <cr-expand-button id="expandMutedCompromisedCredentialsButton"
        class="cr-row list-item" no-hover
        expanded="{{mutedLeakedCredentialsExpanded_}}">
      $i18n{mutedCompromisedCredentials}
    </cr-expand-button>
    <cr-collapse id="mutedCredentialsList"
        opened="[[mutedLeakedCredentialsExpanded_]]">
      <template is="dom-repeat" items="[[mutedCompromisedCredentials_]]">
        <checkup-list-item item="[[item]]" first="[[!index]]"
            group="[[getCurrentGroup_(item.id, groups_)]]"
            show-details="[[isCompromisedType(insecurityType_)]]"
            show-already-changed=
            "[[clickedChangePassword_(item, clickedChangePasswordIds_.size)]]"
            on-more-actions-click="onMoreActionsClick_"
            on-change-password-clicked="onChangePasswordClick_">
        </checkup-list-item>
      </template>
    </cr-collapse>
  </template>
</template>
<template is="dom-if" if="[[isReusedType(insecurityType_)]]" restamp>
  <template id="reusedCredentials" is="dom-repeat"
      items="[[credentialsWithReusedPassword_]]" initial-count="50">
    <div class="cr-secondary-text label reuse-title">
      [[item.title]]
    </div>
    <template is="dom-repeat" items="[[item.credentials]]">
      <checkup-list-item item="[[item]]" first="[[!index]]"
          group="[[getCurrentGroup_(item.id, groups_)]]"
          show-already-changed=
            "[[clickedChangePassword_(item, clickedChangePasswordIds_.size)]]"
          on-more-actions-click="onMoreActionsClick_"
          on-change-password-clicked="onChangePasswordClick_">
      </checkup-list-item>
    </template>
  </template>
</template>
<cr-action-menu id="moreActionsMenu" role-description="$i18n{menu}"
    accessibility-label="$i18n{moreActions}">
  <button id="menuShowPassword" class="dropdown-item"
      on-click="onMenuShowPasswordClick_">
    [[getShowHideTitle_(activeListItem_)]]
  </button>
  <button id="menuEditPassword" class="dropdown-item"
      on-click="onMenuEditPasswordClick_">
    $i18n{editPassword}
  </button>
  <button id="menuDeletePassword" class="dropdown-item"
      on-click="onMenuDeletePasswordClick_">
    $i18n{deletePassword}
  </button>
  <template is="dom-if" if="[[isCompromisedType(insecurityType_)]]">
    <button id="menuMuteUnmuteButton" class="dropdown-item"
        on-click="onMenuMuteUnmuteClick_" disabled="[[isMutingDisabled_]]">
      [[getMuteUnmuteLabel_(activeListItem_)]]
      <template is="dom-if" if="[[isMutingDisabled_]]" restamp>
        <cr-icon icon="cr20:domain" class="policy-disabled">
        </cr-icon>
      </template>
    </button>
  </template>
</cr-action-menu>
<!--_html_template_end_-->`;
}