// chrome/browser/ui/webui/on_device_internals/on_device_internals_page.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit
// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { mojo } from '//resources/mojo/mojo/public/js/bindings.js';
import { LoadModelResultSpec as onDeviceModel_mojom_LoadModelResultSpec, OnDeviceModelPendingReceiver as onDeviceModel_mojom_OnDeviceModelPendingReceiver, CapabilitiesSpec as onDeviceModel_mojom_CapabilitiesSpec, DeviceInfoSpec as onDeviceModel_mojom_DeviceInfoSpec, DevicePerformanceInfoSpec as onDeviceModel_mojom_DevicePerformanceInfoSpec } from './on_device_model.mojom-webui.js';
import { ModelPerformanceHintSpec as onDeviceModel_mojom_ModelPerformanceHintSpec } from './on_device_model_service.mojom-webui.js';
import { BigBufferSpec as mojoBase_mojom_BigBufferSpec } from '//resources/mojo/mojo/public/mojom/base/big_buffer.mojom-webui.js';
import { FilePathSpec as mojoBase_mojom_FilePathSpec } from '//resources/mojo/mojo/public/mojom/base/file_path.mojom-webui.js';
import { TimeSpec as mojoBase_mojom_TimeSpec } from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import { BitmapMappedFromTrustedProcessSpec as skia_mojom_BitmapMappedFromTrustedProcessSpec } from '//resources/mojo/skia/public/mojom/bitmap.mojom-webui.js';
export class PageHandlerFactoryPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'on_device_internals.mojom.PageHandlerFactory', scope);
    }
}
export class PageHandlerFactoryRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerFactoryPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    createPageHandler(page, handler) {
        this.proxy.sendMessage(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, [
            page,
            handler
        ], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerFactoryReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, impl.createPageHandler.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandlerFactory {
    static get $interfaceName() {
        return "on_device_internals.mojom.PageHandlerFactory";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerFactoryRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerFactoryCallbackRouter {
    helper_internal_;
    $;
    router_;
    createPageHandler;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerFactoryRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.createPageHandler =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandlerFactory_CreatePageHandler_ParamsSpec.$, null, this.createPageHandler.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PageHandlerPendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'on_device_internals.mojom.PageHandler', scope);
    }
}
export class PageHandlerRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PageHandlerPendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    loadModel(modelPath, performanceHint, model) {
        return this.proxy.sendMessage(0, PageHandler_LoadModel_ParamsSpec.$, PageHandler_LoadModel_ResponseParamsSpec.$, [
            modelPath,
            performanceHint,
            model
        ], false);
    }
    loadPlatformModel(modelPath, model) {
        return this.proxy.sendMessage(1, PageHandler_LoadPlatformModel_ParamsSpec.$, PageHandler_LoadPlatformModel_ResponseParamsSpec.$, [
            modelPath,
            model
        ], false);
    }
    getDeviceAndPerformanceInfo() {
        return this.proxy.sendMessage(2, PageHandler_GetDeviceAndPerformanceInfo_ParamsSpec.$, PageHandler_GetDeviceAndPerformanceInfo_ResponseParamsSpec.$, [], false);
    }
    getDefaultModelPath() {
        return this.proxy.sendMessage(3, PageHandler_GetDefaultModelPath_ParamsSpec.$, PageHandler_GetDefaultModelPath_ResponseParamsSpec.$, [], false);
    }
    getPageData() {
        return this.proxy.sendMessage(4, PageHandler_GetPageData_ParamsSpec.$, PageHandler_GetPageData_ResponseParamsSpec.$, [], false);
    }
    setFeatureRecentlyUsedState(featureKey, isRecentlyUsed) {
        this.proxy.sendMessage(5, PageHandler_SetFeatureRecentlyUsedState_ParamsSpec.$, null, [
            featureKey,
            isRecentlyUsed
        ], false);
    }
    decodeBitmap(imageBuffer) {
        return this.proxy.sendMessage(6, PageHandler_DecodeBitmap_ParamsSpec.$, PageHandler_DecodeBitmap_ResponseParamsSpec.$, [
            imageBuffer
        ], false);
    }
    resetModelCrashCount() {
        this.proxy.sendMessage(7, PageHandler_ResetModelCrashCount_ParamsSpec.$, null, [], false);
    }
}
;
/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, PageHandler_LoadModel_ParamsSpec.$, PageHandler_LoadModel_ResponseParamsSpec.$, impl.loadModel.bind(impl), false);
        this.helper_internal_.registerHandler(1, PageHandler_LoadPlatformModel_ParamsSpec.$, PageHandler_LoadPlatformModel_ResponseParamsSpec.$, impl.loadPlatformModel.bind(impl), false);
        this.helper_internal_.registerHandler(2, PageHandler_GetDeviceAndPerformanceInfo_ParamsSpec.$, PageHandler_GetDeviceAndPerformanceInfo_ResponseParamsSpec.$, impl.getDeviceAndPerformanceInfo.bind(impl), false);
        this.helper_internal_.registerHandler(3, PageHandler_GetDefaultModelPath_ParamsSpec.$, PageHandler_GetDefaultModelPath_ResponseParamsSpec.$, impl.getDefaultModelPath.bind(impl), false);
        this.helper_internal_.registerHandler(4, PageHandler_GetPageData_ParamsSpec.$, PageHandler_GetPageData_ResponseParamsSpec.$, impl.getPageData.bind(impl), false);
        this.helper_internal_.registerHandler(5, PageHandler_SetFeatureRecentlyUsedState_ParamsSpec.$, null, impl.setFeatureRecentlyUsedState.bind(impl), false);
        this.helper_internal_.registerHandler(6, PageHandler_DecodeBitmap_ParamsSpec.$, PageHandler_DecodeBitmap_ResponseParamsSpec.$, impl.decodeBitmap.bind(impl), false);
        this.helper_internal_.registerHandler(7, PageHandler_ResetModelCrashCount_ParamsSpec.$, null, impl.resetModelCrashCount.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class PageHandler {
    static get $interfaceName() {
        return "on_device_internals.mojom.PageHandler";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageHandlerRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
    helper_internal_;
    $;
    router_;
    loadModel;
    loadPlatformModel;
    getDeviceAndPerformanceInfo;
    getDefaultModelPath;
    getPageData;
    setFeatureRecentlyUsedState;
    decodeBitmap;
    resetModelCrashCount;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageHandlerRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.loadModel =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, PageHandler_LoadModel_ParamsSpec.$, PageHandler_LoadModel_ResponseParamsSpec.$, this.loadModel.createReceiverHandler(true /* expectsResponse */), false);
        this.loadPlatformModel =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(1, PageHandler_LoadPlatformModel_ParamsSpec.$, PageHandler_LoadPlatformModel_ResponseParamsSpec.$, this.loadPlatformModel.createReceiverHandler(true /* expectsResponse */), false);
        this.getDeviceAndPerformanceInfo =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(2, PageHandler_GetDeviceAndPerformanceInfo_ParamsSpec.$, PageHandler_GetDeviceAndPerformanceInfo_ResponseParamsSpec.$, this.getDeviceAndPerformanceInfo.createReceiverHandler(true /* expectsResponse */), false);
        this.getDefaultModelPath =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(3, PageHandler_GetDefaultModelPath_ParamsSpec.$, PageHandler_GetDefaultModelPath_ResponseParamsSpec.$, this.getDefaultModelPath.createReceiverHandler(true /* expectsResponse */), false);
        this.getPageData =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(4, PageHandler_GetPageData_ParamsSpec.$, PageHandler_GetPageData_ResponseParamsSpec.$, this.getPageData.createReceiverHandler(true /* expectsResponse */), false);
        this.setFeatureRecentlyUsedState =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(5, PageHandler_SetFeatureRecentlyUsedState_ParamsSpec.$, null, this.setFeatureRecentlyUsedState.createReceiverHandler(false /* expectsResponse */), false);
        this.decodeBitmap =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(6, PageHandler_DecodeBitmap_ParamsSpec.$, PageHandler_DecodeBitmap_ResponseParamsSpec.$, this.decodeBitmap.createReceiverHandler(true /* expectsResponse */), false);
        this.resetModelCrashCount =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(7, PageHandler_ResetModelCrashCount_ParamsSpec.$, null, this.resetModelCrashCount.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export class PagePendingReceiver {
    handle;
    constructor(handle) {
        this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
    }
    bindInBrowser(scope = 'context') {
        mojo.internal.interfaceSupport.bind(this.handle, 'on_device_internals.mojom.Page', scope);
    }
}
export class PageRemote {
    proxy;
    $;
    onConnectionError;
    constructor(handle) {
        this.proxy =
            new mojo.internal.interfaceSupport.InterfaceRemoteBase(PagePendingReceiver, handle);
        this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);
        this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
    }
    onLogMessageAdded(eventTime, sourceFile, sourceLine, message) {
        this.proxy.sendMessage(0, Page_OnLogMessageAdded_ParamsSpec.$, null, [
            eventTime,
            sourceFile,
            sourceLine,
            message
        ], false);
    }
}
;
/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
    helper_internal_;
    $;
    onConnectionError;
    constructor(impl) {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.helper_internal_.registerHandler(0, Page_OnLogMessageAdded_ParamsSpec.$, null, impl.onLogMessageAdded.bind(impl), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
}
export class Page {
    static get $interfaceName() {
        return "on_device_internals.mojom.Page";
    }
    /**
     * Returns a remote for this interface which sends messages to the browser.
     * The browser must have an interface request binder registered for this
     * interface and accessible to the calling document's frame.
     */
    static getRemote() {
        let remote = new PageRemote;
        remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
        return remote;
    }
}
/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
    helper_internal_;
    $;
    router_;
    onLogMessageAdded;
    onConnectionError;
    constructor() {
        this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(PageRemote);
        this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);
        this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;
        this.onLogMessageAdded =
            new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(this.router_);
        this.helper_internal_.registerHandler(0, Page_OnLogMessageAdded_ParamsSpec.$, null, this.onLogMessageAdded.createReceiverHandler(false /* expectsResponse */), false);
        this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
    }
    /**
     * @param id An ID returned by a prior call to addListener.
     * @return True iff the identified listener was found and removed.
     */
    removeListener(id) {
        return this.router_.removeListener(id);
    }
}
export const PageDataSpec = { $: {} };
export const BaseModelStateSpec = { $: {} };
export const BaseModelInfoSpec = { $: {} };
export const SupplementaryModelInfoSpec = { $: {} };
export const FeatureAdaptationInfoSpec = { $: {} };
export const PageHandlerFactory_CreatePageHandler_ParamsSpec = { $: {} };
export const PageHandler_LoadModel_ParamsSpec = { $: {} };
export const PageHandler_LoadModel_ResponseParamsSpec = { $: {} };
export const PageHandler_LoadPlatformModel_ParamsSpec = { $: {} };
export const PageHandler_LoadPlatformModel_ResponseParamsSpec = { $: {} };
export const PageHandler_GetDeviceAndPerformanceInfo_ParamsSpec = { $: {} };
export const PageHandler_GetDeviceAndPerformanceInfo_ResponseParamsSpec = { $: {} };
export const PageHandler_GetDefaultModelPath_ParamsSpec = { $: {} };
export const PageHandler_GetDefaultModelPath_ResponseParamsSpec = { $: {} };
export const PageHandler_GetPageData_ParamsSpec = { $: {} };
export const PageHandler_GetPageData_ResponseParamsSpec = { $: {} };
export const PageHandler_SetFeatureRecentlyUsedState_ParamsSpec = { $: {} };
export const PageHandler_DecodeBitmap_ParamsSpec = { $: {} };
export const PageHandler_DecodeBitmap_ResponseParamsSpec = { $: {} };
export const PageHandler_ResetModelCrashCount_ParamsSpec = { $: {} };
export const Page_OnLogMessageAdded_ParamsSpec = { $: {} };
mojo.internal.Struct(PageDataSpec.$, 'PageData', [
    mojo.internal.StructField('baseModel', 0, 0, BaseModelStateSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('suppModels', 8, 0, mojo.internal.Array(SupplementaryModelInfoSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('modelCrashCount', 16, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('maxModelCrashCount', 20, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('featureAdaptations', 24, 0, mojo.internal.Array(FeatureAdaptationInfoSpec.$, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('performanceInfo', 32, 0, onDeviceModel_mojom_DevicePerformanceInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('minVramMb', 40, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
], [[0, 56],]);
mojo.internal.Struct(BaseModelStateSpec.$, 'BaseModelState', [
    mojo.internal.StructField('state', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('registrationCriteria', 8, 0, mojo.internal.Map(mojo.internal.String, mojo.internal.String, false), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('info', 16, 0, BaseModelInfoSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(BaseModelInfoSpec.$, 'BaseModelInfo', [
    mojo.internal.StructField('componentVersion', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('filePath', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('fileSize', 16, 0, mojo.internal.Uint64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('name', 24, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('version', 32, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('backendType', 40, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 56],]);
mojo.internal.Struct(SupplementaryModelInfoSpec.$, 'SupplementaryModelInfo', [
    mojo.internal.StructField('suppModelName', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isReady', 8, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(FeatureAdaptationInfoSpec.$, 'FeatureAdaptationInfo', [
    mojo.internal.StructField('featureName', 0, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('featureKey', 8, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('version', 16, 0, mojo.internal.Int64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isRecentlyUsed', 12, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 32],]);
mojo.internal.Struct(PageHandlerFactory_CreatePageHandler_ParamsSpec.$, 'PageHandlerFactory_CreatePageHandler_Params', [
    mojo.internal.StructField('page', 0, 0, mojo.internal.InterfaceProxy(PageRemote), null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('handler', 8, 0, mojo.internal.InterfaceRequest(PageHandlerPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_LoadModel_ParamsSpec.$, 'PageHandler_LoadModel_Params', [
    mojo.internal.StructField('modelPath', 0, 0, mojoBase_mojom_FilePathSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('performanceHint', 8, 0, onDeviceModel_mojom_ModelPerformanceHintSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('model', 12, 0, mojo.internal.InterfaceRequest(onDeviceModel_mojom_OnDeviceModelPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_LoadModel_ResponseParamsSpec.$, 'PageHandler_LoadModel_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, onDeviceModel_mojom_LoadModelResultSpec.$, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('capabilities', 8, 0, onDeviceModel_mojom_CapabilitiesSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_LoadPlatformModel_ParamsSpec.$, 'PageHandler_LoadPlatformModel_Params', [
    mojo.internal.StructField('modelPath', 0, 0, mojoBase_mojom_FilePathSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('model', 8, 0, mojo.internal.InterfaceRequest(onDeviceModel_mojom_OnDeviceModelPendingReceiver), null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_LoadPlatformModel_ResponseParamsSpec.$, 'PageHandler_LoadPlatformModel_ResponseParams', [
    mojo.internal.StructField('result', 0, 0, onDeviceModel_mojom_LoadModelResultSpec.$, 0, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetDeviceAndPerformanceInfo_ParamsSpec.$, 'PageHandler_GetDeviceAndPerformanceInfo_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetDeviceAndPerformanceInfo_ResponseParamsSpec.$, 'PageHandler_GetDeviceAndPerformanceInfo_ResponseParams', [
    mojo.internal.StructField('performanceInfo', 0, 0, onDeviceModel_mojom_DevicePerformanceInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('deviceInfo', 8, 0, onDeviceModel_mojom_DeviceInfoSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_GetDefaultModelPath_ParamsSpec.$, 'PageHandler_GetDefaultModelPath_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetDefaultModelPath_ResponseParamsSpec.$, 'PageHandler_GetDefaultModelPath_ResponseParams', [
    mojo.internal.StructField('modelPath', 0, 0, mojoBase_mojom_FilePathSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_GetPageData_ParamsSpec.$, 'PageHandler_GetPageData_Params', [], [[0, 8],]);
mojo.internal.Struct(PageHandler_GetPageData_ResponseParamsSpec.$, 'PageHandler_GetPageData_ResponseParams', [
    mojo.internal.StructField('pageData', 0, 0, PageDataSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_SetFeatureRecentlyUsedState_ParamsSpec.$, 'PageHandler_SetFeatureRecentlyUsedState_Params', [
    mojo.internal.StructField('featureKey', 0, 0, mojo.internal.Int32, 0, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('isRecentlyUsed', 4, 0, mojo.internal.Bool, false, false /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_DecodeBitmap_ParamsSpec.$, 'PageHandler_DecodeBitmap_Params', [
    mojo.internal.StructField('imageBuffer', 0, 0, mojoBase_mojom_BigBufferSpec.$, null, false /* nullable */, 0, undefined, undefined),
], [[0, 24],]);
mojo.internal.Struct(PageHandler_DecodeBitmap_ResponseParamsSpec.$, 'PageHandler_DecodeBitmap_ResponseParams', [
    mojo.internal.StructField('bitmap', 0, 0, skia_mojom_BitmapMappedFromTrustedProcessSpec.$, null, true /* nullable */, 0, undefined, undefined),
], [[0, 16],]);
mojo.internal.Struct(PageHandler_ResetModelCrashCount_ParamsSpec.$, 'PageHandler_ResetModelCrashCount_Params', [], [[0, 8],]);
mojo.internal.Struct(Page_OnLogMessageAdded_ParamsSpec.$, 'Page_OnLogMessageAdded_Params', [
    mojo.internal.StructField('eventTime', 0, 0, mojoBase_mojom_TimeSpec.$, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sourceFile', 8, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('sourceLine', 16, 0, mojo.internal.Int64, BigInt(0), false /* nullable */, 0, undefined, undefined),
    mojo.internal.StructField('message', 24, 0, mojo.internal.String, null, false /* nullable */, 0, undefined, undefined),
], [[0, 40],]);
