// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import '//resources/cr_elements/cr_button/cr_button.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import { BrowserProxy } from './browser_proxy.js';
import { getCss } from './model_status.css.js';
import { getHtml } from './model_status.html.js';
import { PerformanceClass } from './on_device_model.mojom-webui.js';
export class OnDeviceInternalsModelStatusElement extends CrLitElement {
    constructor() {
        super();
        this.getPageData_();
    }
    static get is() {
        return 'on-device-internals-model-status';
    }
    static get styles() {
        return getCss();
    }
    static get properties() {
        return {
            pageData_: { type: Object },
            mayRestartBrowser_: { type: Boolean },
        };
    }
    render() {
        return getHtml.bind(this)();
    }
    #pageData__accessor_storage = {
        baseModel: {
            state: 'NO STATE',
            registrationCriteria: {},
            info: null,
        },
        suppModels: [],
        modelCrashCount: 0,
        maxModelCrashCount: 0,
        featureAdaptations: [],
        performanceInfo: {
            performanceClass: PerformanceClass.kError,
            vramMb: 0n,
        },
        minVramMb: 0n,
    };
    get pageData_() { return this.#pageData__accessor_storage; }
    set pageData_(value) { this.#pageData__accessor_storage = value; }
    #mayRestartBrowser__accessor_storage = false;
    get mayRestartBrowser_() { return this.#mayRestartBrowser__accessor_storage; }
    set mayRestartBrowser_(value) { this.#mayRestartBrowser__accessor_storage = value; }
    proxy_ = BrowserProxy.getInstance();
    async onResetModelCrashCountClick_() {
        await this.proxy_.handler.resetModelCrashCount();
        await this.getPageData_();
        this.mayRestartBrowser_ = true;
    }
    async onFeatureUsageSetterClick_(feature, isRecentlyUsed) {
        await this.proxy_.handler.setFeatureRecentlyUsedState(feature, isRecentlyUsed);
        this.getPageData_();
    }
    async getPageData_() {
        this.pageData_ = (await this.proxy_.handler.getPageData()).pageData;
    }
}
customElements.define(OnDeviceInternalsModelStatusElement.is, OnDeviceInternalsModelStatusElement);
