import '//resources/cr_components/composebox/contextual_entrypoint_and_carousel.js';
import '//resources/cr_components/searchbox/searchbox_dropdown.js';
import '//resources/cr_elements/icons.html.js';
import '/strings.m.js';
import type { ContextualEntrypointAndCarouselElement } from '//resources/cr_components/composebox/contextual_entrypoint_and_carousel.js';
import type { SearchboxDropdownElement } from '//resources/cr_components/searchbox/searchbox_dropdown.js';
import { CrLitElement } from '//resources/lit/v3_0/lit.rollup.js';
import type { PropertyValues } from '//resources/lit/v3_0/lit.rollup.js';
import type { AutocompleteResult, TabInfo } from '//resources/mojo/components/omnibox/browser/searchbox.mojom-webui.js';
import type { Url } from '//resources/mojo/url/mojom/url.mojom-webui.js';
export interface OmniboxPopupAppElement {
    $: {
        context: ContextualEntrypointAndCarouselElement;
    };
}
declare const OmniboxPopupAppElement_base: typeof CrLitElement & (new (...args: any[]) => import("//resources/cr_elements/i18n_mixin_lit.js").I18nMixinLitInterface);
export declare class OmniboxPopupAppElement extends OmniboxPopupAppElement_base {
    static get is(): string;
    static get styles(): import("//resources/lit/v3_0/lit.rollup.js").CSSResultGroup;
    render(): import("//resources/lit/v3_0/lit.rollup.js").TemplateResult<1>;
    static get properties(): {
        /**
         * Whether the secondary side can be shown based on the feature state and
         * the width available to the dropdown.
         */
        canShowSecondarySide: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        hasSecondarySide: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        /**
         * Whether the app is in debug mode.
         */
        isDebug: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        /**
         * Whether matches are visible, as some may be hidden by filtering rules
         * (e.g., Gemini suggestions).
         */
        hasVisibleMatches_: {
            type: BooleanConstructor;
            reflect: boolean;
        };
        isInKeywordMode_: {
            type: BooleanConstructor;
        };
        result_: {
            type: ObjectConstructor;
        };
        searchboxLayoutMode_: {
            type: StringConstructor;
        };
        showContextEntrypoint_: {
            type: BooleanConstructor;
        };
        showAiModePrefEnabled_: {
            type: BooleanConstructor;
        };
        isContentSharingEnabled_: {
            type: BooleanConstructor;
        };
        isLensSearchEnabled_: {
            type: BooleanConstructor;
        };
        isLensSearchEligible_: {
            type: BooleanConstructor;
        };
        isAimEligible_: {
            type: BooleanConstructor;
        };
        isRecentTabChipEnabled_: {
            type: BooleanConstructor;
        };
        tabSuggestions_: {
            type: ArrayConstructor;
        };
    };
    accessor canShowSecondarySide: boolean;
    accessor hasSecondarySide: boolean;
    accessor isDebug: boolean;
    protected accessor isInKeywordMode_: boolean;
    protected accessor showAiModePrefEnabled_: boolean;
    protected accessor hasVisibleMatches_: boolean;
    protected accessor result_: AutocompleteResult | null;
    protected accessor searchboxLayoutMode_: string;
    protected accessor showContextEntrypoint_: boolean;
    protected accessor isContentSharingEnabled_: boolean;
    protected accessor isLensSearchEnabled_: boolean;
    protected accessor isRecentTabChipEnabled_: boolean;
    protected accessor isLensSearchEligible_: boolean;
    protected accessor isAimEligible_: boolean;
    protected accessor tabSuggestions_: TabInfo[];
    private callbackRouter_;
    private eventTracker_;
    private listenerIds_;
    private pageHandler_;
    constructor();
    connectedCallback(): void;
    disconnectedCallback(): void;
    willUpdate(changedProperties: PropertyValues<this>): void;
    getDropdown(): SearchboxDropdownElement;
    protected get shouldHideEntrypointButton_(): boolean;
    private computeShowContextEntrypoint_;
    private onCanShowSecondarySideChanged_;
    private onAutocompleteResultChanged_;
    private onShow_;
    protected onResultRepaint_(): void;
    private onUpdateSelection_;
    protected onHasSecondarySideChanged_(e: CustomEvent<{
        value: boolean;
    }>): void;
    protected onContextualEntryPointClicked_(e: CustomEvent<{
        x: number;
        y: number;
    }>): void;
    protected refreshTabSuggestions_(): Promise<void>;
    protected onLensSearchChipClicked_(): void;
    protected addTabContext_(e: CustomEvent<{
        id: number;
        title: string;
        url: Url;
        delayUpload: boolean;
    }>): void;
    protected computeShowRecentTabChip_(): boolean;
    private stripUrl_;
}
declare global {
    interface HTMLElementTagNameMap {
        'omnibox-popup-app': OmniboxPopupAppElement;
    }
}
export {};
